/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.icu;

import com.ibm.icu.dev.test.util.ArrayComparator;
import com.ibm.icu.dev.test.util.BagFormatter;
import com.ibm.icu.dev.test.util.Relation;
import com.ibm.icu.dev.test.util.SortedBag;
import com.ibm.icu.dev.test.util.TransliteratorUtilities;
import com.ibm.icu.dev.test.util.UnicodeMap;
import com.ibm.icu.dev.tool.UOption;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.Collator;
import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.Normalizer;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.RuleBasedCollator;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.text.Transliterator;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.text.UnicodeSetIterator;
import com.ibm.icu.util.Currency;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.icu.ICUResourceWriter;
import org.unicode.cldr.icu.LDML2ICUConverter;
import org.unicode.cldr.util.LDMLUtilities;
import org.unicode.cldr.util.Utility;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class GenerateCldrTests {
    private static PrintWriter log;
    PrintWriter out;
    private static final int HELP1 = 0;
    private static final int HELP2 = 1;
    private static final int SOURCEDIR = 2;
    private static final int DESTDIR = 3;
    private static final int LOGDIR = 4;
    private static final int MATCH = 5;
    private static final int FULLY_RESOLVED = 6;
    private static final int LANGUAGES = 7;
    private static final int TZADIR = 8;
    private static final UOption[] options;
    CldrCollations cldrCollations;
    static String logDir;
    static String destDir;
    static final UnicodeSet NON_LATIN;
    static Map fixCountryNames;
    public static final Transliterator toLatin;
    Set collationLocales;
    Set numberLocales = this.addULocales(NumberFormat.getAvailableLocales(), new TreeSet(ULocaleComparator));
    Set dateLocales = this.addULocales(DateFormat.getAvailableLocales(), new TreeSet(ULocaleComparator));
    Set allLocales = new TreeSet(ULocaleComparator);
    Map localesToRules = new HashMap();
    Relation.CollectionFactory cm = new Relation.CollectionMaker(ULocaleComparator);
    Relation rulesToLocales = new Relation(new TreeMap(), this.cm);
    Relation parentToLocales = new Relation(new TreeMap(ULocaleComparator), this.cm);
    CldrOthers cldrOthers;
    public static final Comparator ULocaleComparator;
    static TimeZone utc;
    static DateFormat iso;
    static int[] DateFormatValues;
    static String[] DateFormatNames;
    static Equator DateEquator;
    DataShower DateShower;
    static String[] NumberNames;
    static Currency NO_CURRENCY;
    static Equator NumberEquator;
    DataShower NumberShower;
    Equator CollationEquator;
    static ULocale zhHack;
    DataShower CollationShower;
    static final UnicodeSet SKIP_COLLATION_SET;
    public static final CloseCodePoint CCCP;

    public GenerateCldrTests() {
        iso.setTimeZone(utc);
        this.DateShower = new DataShower(){

            public void show(ULocale locale, Collection others) throws ParseException {
                GenerateCldrTests.this.showLocales("date", others);
                String[] samples = new String[]{"1900-01-31T00:00:00Z", "1909-02-28T00:00:01Z", "1918-03-26T00:59:59Z", "1932-04-24T01:00:00Z", "1945-05-20T01:00:01Z", "1952-06-18T11:59:59Z", "1973-07-16T12:00:00Z", "1999-08-14T12:00:01Z", "2000-09-12T22:59:59Z", "2001-10-08T23:00:00Z", "2004-11-04T23:00:01Z", "2010-12-01T23:59:59Z"};
                ResultsPrinter rp = new ResultsPrinter();
                for (int j = 0; j < samples.length; ++j) {
                    Date datetime = iso.parse(samples[j]);
                    rp.set("input", iso.format(datetime));
                    for (int i = 0; i < DateFormatValues.length; ++i) {
                        rp.set("dateType", DateFormatNames[i]);
                        for (int k = 0; k < DateFormatValues.length; ++k) {
                            if (DateFormatValues[i] == -1 && DateFormatValues[k] == -1) continue;
                            rp.set("timeType", DateFormatNames[k]);
                            DateFormat df = GenerateCldrTests.getDateFormat(locale, i, k);
                            df.setTimeZone(utc);
                            rp.print(df.format(datetime));
                        }
                    }
                }
                GenerateCldrTests.this.out.println("  </date>");
            }
        };
        this.NumberShower = new DataShower(){

            public void show(ULocale locale, Collection others) throws ParseException {
                GenerateCldrTests.this.showLocales("number", others);
                double[] samples = new double[]{0.0, 0.01, -0.01, 1.0, -1.0, 123.456, -123.456, 123456.78, -123456.78, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NaN};
                ResultsPrinter rp = new ResultsPrinter();
                for (int j = 0; j < samples.length; ++j) {
                    double sample = samples[j];
                    rp.set("input", String.valueOf(sample));
                    for (int i = 0; i < NumberNames.length; ++i) {
                        rp.set("numberType", NumberNames[i]);
                        NumberFormat nf = GenerateCldrTests.getNumberFormat(locale, i);
                        rp.print(nf.format(sample));
                    }
                }
                GenerateCldrTests.this.out.println("  </number>");
            }
        };
        this.CollationEquator = new Equator(){

            public boolean equals(Object o1, Object o2) {
                ULocale loc1 = (ULocale)o1;
                ULocale loc2 = (ULocale)o2;
                return GenerateCldrTests.this.cldrCollations.getInstance(loc1).equals((Object)GenerateCldrTests.this.cldrCollations.getInstance(loc2));
            }
        };
        this.CollationShower = new DataShower(){

            public void show(ULocale locale, Collection others) {
                if (locale.equals((Object)zhHack)) {
                    return;
                }
                GenerateCldrTests.this.showLocales("collation", others);
                RuleBasedCollator col = GenerateCldrTests.this.cldrCollations.getInstance(locale);
                UnicodeSet tailored = col.getTailoredSet();
                if (locale.getLanguage().equals("zh")) {
                    tailored.addAll(new UnicodeSet("[[a-z]-[v]]"));
                    log.println("HACK for Pinyin");
                }
                tailored = GenerateCldrTests.createCaseClosure(tailored);
                tailored = GenerateCldrTests.nfc(tailored);
                UnicodeSet exemplars = GenerateCldrTests.this.getExemplarSet(locale, 2);
                exemplars = GenerateCldrTests.createCaseClosure(exemplars);
                exemplars = GenerateCldrTests.nfc(exemplars);
                tailored.addAll(exemplars);
                if (!exemplars.containsAll(tailored)) {
                    log.println("In Tailored, but not Exemplar; Locale: " + locale + "\t" + locale.getDisplayName());
                    log.println(new UnicodeSet(tailored).removeAll(exemplars).toPattern(false));
                    log.flush();
                }
                tailored.addAll(new UnicodeSet("[\\ .02{12}]"));
                tailored.removeAll(SKIP_COLLATION_SET);
                SortedBag bag = new SortedBag((Comparator)col);
                GenerateCldrTests.this.doCollationResult((Collator)col, tailored, bag);
                GenerateCldrTests.this.out.println("  </collation>");
            }
        };
    }

    public static boolean hasLocalizedLanguageFor(ULocale locale, ULocale otherLocale) {
        String localizedVersion;
        String lang = otherLocale.getLanguage();
        return !lang.equals(localizedVersion = otherLocale.getDisplayLanguage(locale));
    }

    public static boolean hasLocalizedCountryFor(ULocale locale, ULocale otherLocale) {
        String country = otherLocale.getCountry();
        if (country.equals("")) {
            return true;
        }
        String localizedVersion = otherLocale.getDisplayCountry(locale);
        return !country.equals(localizedVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        UOption.parseArgs((String[])args, (UOption[])options);
        log = BagFormatter.openUTF8Writer((String)GenerateCldrTests.options[4].value, (String)"log.txt");
        try {
            if (GenerateCldrTests.options[7].doesOccur) {
                GenerateCldrTests.generateSize(true);
                return;
            }
            GenerateCldrTests t = new GenerateCldrTests();
            t.generate(GenerateCldrTests.options[5].value);
        }
        finally {
            log.close();
            System.out.println("Done");
        }
    }

    private static void generateSize(boolean transliterate) throws IOException {
        PrintWriter logHtml = BagFormatter.openUTF8Writer((String)GenerateCldrTests.options[4].value, (String)"log.html");
        String dir = GenerateCldrTests.options[2].value + "main" + File.separator;
        DraftChecker dc = new DraftChecker(dir);
        Set filenames = GenerateCldrTests.getMatchingXMLFiles(dir, ".*");
        Collator col = Collator.getInstance((ULocale)ULocale.ENGLISH);
        TreeSet languages = new TreeSet(col);
        TreeSet countries = new TreeSet(col);
        TreeSet draftLanguages = new TreeSet(col);
        TreeSet draftCountries = new TreeSet(col);
        TreeSet nativeLanguages = new TreeSet();
        TreeSet nativeCountries = new TreeSet();
        TreeSet draftNativeLanguages = new TreeSet();
        TreeSet draftNativeCountries = new TreeSet();
        int localeCount = 0;
        int draftLocaleCount = 0;
        Iterator it = filenames.iterator();
        while (it.hasNext()) {
            String localeName = (String)it.next();
            if (localeName.equals("root")) continue;
            boolean draft = dc.isDraft(localeName);
            if (draft) {
                ++draftLocaleCount;
                GenerateCldrTests.addCounts(localeName, true, draftLanguages, draftCountries, draftNativeLanguages, draftNativeCountries);
                continue;
            }
            ++localeCount;
            GenerateCldrTests.addCounts(localeName, false, languages, countries, nativeLanguages, nativeCountries);
        }
        draftLanguages.removeAll(languages);
        it = nativeLanguages.iterator();
        while (it.hasNext()) {
            draftNativeLanguages.remove(it.next());
        }
        logHtml.println("<html><head>");
        logHtml.println("<meta http-equiv='Content-Type' content='text/html; charset=utf-8'>");
        logHtml.println("</head><body>");
        logHtml.println("<p><b>Locales (" + localeCount + "):</b>");
        logHtml.println("<p><b>Languages (" + languages.size() + "):</b>");
        logHtml.println(GenerateCldrTests.showSet(nativeLanguages, transliterate, true));
        logHtml.println("<p><b>Countries (" + countries.size() + "):</b>");
        logHtml.println(GenerateCldrTests.showSet(nativeCountries, transliterate, false));
        logHtml.println("<p><b>Draft locales (" + draftLocaleCount + "):</b>");
        logHtml.println("<p><b>Draft languages (" + draftLanguages.size() + "):</b>");
        logHtml.println(GenerateCldrTests.showSet(draftNativeLanguages, transliterate, true));
        logHtml.println("<p><b>Draft countries (" + draftCountries.size() + "):</b>");
        logHtml.println(GenerateCldrTests.showSet(draftNativeCountries, transliterate, false));
        logHtml.println("</body></html>");
        logHtml.close();
    }

    private static void addCounts(String localeName, boolean isDraft, Set draftLanguages, Set draftCountries, Set draftNativeLanguages, Set draftNativeCountries) {
        ULocale uloc = new ULocale(localeName);
        String lang = localeName;
        String country = "";
        if (localeName.length() > 3 && localeName.charAt(localeName.length() - 3) == '_') {
            lang = localeName.substring(0, localeName.length() - 3);
            country = localeName.substring(localeName.length() - 2);
        }
        if ((country.equals("TW") || country.equals("HK") || country.equals("MO")) && lang.equals("zh")) {
            return;
        }
        if (lang.equals("zh_Hans") || lang.equals("sr_Cyrl") || lang.equals("sh")) {
            return;
        }
        draftLanguages.add(lang);
        String nativeName = uloc.getDisplayLanguage(uloc);
        String englishName = uloc.getDisplayLanguage(ULocale.ENGLISH);
        if (!lang.equals("en") && nativeName.equals(englishName)) {
            log.println((isDraft ? "D" : "") + "\tWarning: in " + localeName + ", display name for " + lang + " equals English: " + nativeName);
        }
        draftNativeLanguages.add(new LanguageList(lang, englishName, GenerateCldrTests.fixedTitleCase(uloc, nativeName)));
        if (!country.equals("")) {
            draftCountries.add(country);
            nativeName = GenerateCldrTests.getFixedDisplayCountry(uloc, uloc);
            englishName = GenerateCldrTests.getFixedDisplayCountry(uloc, ULocale.ENGLISH);
            if (!lang.equals("en") && nativeName.equals(englishName)) {
                log.println((isDraft ? "D" : "") + "\tWarning: in " + localeName + ", display name for " + country + " equals English: " + nativeName);
            }
            draftNativeCountries.add(new LanguageList(uloc.toString(), englishName, GenerateCldrTests.fixedTitleCase(uloc, nativeName)));
        }
    }

    static String fixedTitleCase(ULocale uloc, String in) {
        String result = UCharacter.toTitleCase((ULocale)uloc, (String)in, null);
        result = GenerateCldrTests.replace(result, "U.s.", "U.S.");
        result = GenerateCldrTests.replace(result, "S.a.r.", "S.A.R.");
        return result;
    }

    private static String getFixedDisplayCountry(ULocale uloc, ULocale forLanguage) {
        String name = uloc.getDisplayCountry(forLanguage);
        Object trial = fixCountryNames.get(name);
        if (trial != null) {
            return (String)trial;
        }
        return name;
    }

    private static String showSet(Set nativeCountries, boolean transliterate, boolean isLanguage) {
        TreeSet<LanguageList> s;
        UnicodeSet BIDI_R = new UnicodeSet("[[:Bidi_Class=R:][:Bidi_Class=AL:]]");
        StringBuffer result = new StringBuffer();
        TreeMap<String, TreeSet<LanguageList>> sb = new TreeMap<String, TreeSet<LanguageList>>((Comparator<String>)LanguageList.col);
        Iterator<Object> it = nativeCountries.iterator();
        while (it.hasNext()) {
            LanguageList llist = (LanguageList)it.next();
            s = (TreeSet<LanguageList>)sb.get(llist.getEnglishName());
            if (s == null) {
                s = new TreeSet<LanguageList>();
                sb.put(llist.getEnglishName(), s);
            }
            s.add(llist);
        }
        it = sb.keySet().iterator();
        while (it.hasNext()) {
            String englishName = (String)it.next();
            s = (Set)sb.get(englishName);
            if (result.length() != 0) {
                result.append(", ");
            }
            String qualifiers = "";
            String title = "";
            int count = 0;
            boolean needQualifier = s.size() != 1;
            Iterator it2 = s.iterator();
            while (it2.hasNext()) {
                String locale;
                ++count;
                LanguageList llist = (LanguageList)it2.next();
                String localName = llist.getLocalName();
                String lang = locale = llist.getLocale();
                String country = "";
                if (locale.length() > 3 && locale.charAt(locale.length() - 3) == '_') {
                    lang = locale.substring(0, locale.length() - 3);
                    country = locale.substring(locale.length() - 2);
                }
                if (BIDI_R.containsSome(localName)) {
                    localName = '\u200e' + localName + '\u200e';
                }
                if (qualifiers.length() != 0) {
                    qualifiers = qualifiers + "; ";
                }
                qualifiers = qualifiers + lang;
                if (title.length() != 0) {
                    title = title + "; ";
                }
                title = isLanguage ? title + lang : title + country;
                if (localName.equalsIgnoreCase(englishName)) continue;
                needQualifier = true;
                qualifiers = qualifiers + ", " + localName;
                if (!transliterate || !NON_LATIN.containsSome(localName) || lang.equals("ja")) continue;
                String transName = GenerateCldrTests.fixedTitleCase(ULocale.ENGLISH, toLatin.transliterate(localName));
                if (NON_LATIN.containsSome(transName)) {
                    log.println("Can't transliterate " + localName + ": " + transName);
                    continue;
                }
                title = title + ", " + transName;
            }
            String before = "";
            String after = "";
            if (title.length() != 0) {
                before = "<span title='" + TransliteratorUtilities.toHTML.transliterate(title) + "'>";
                after = "</span>";
            }
            qualifiers = !needQualifier ? "" : " (" + qualifiers + ")";
            if (englishName.endsWith(", China")) {
                englishName = englishName.substring(0, englishName.length() - ", China".length()) + " China";
            }
            result.append(before).append(TransliteratorUtilities.toHTML.transliterate(englishName + qualifiers)).append(after);
        }
        return result.toString();
    }

    private static void checkLocaleNames() {
        ULocale[] locales = ULocale.getAvailableLocales();
        for (int i = 0; i < locales.length; ++i) {
            if (!(GenerateCldrTests.hasLocalizedCountryFor(ULocale.ENGLISH, locales[i]) && GenerateCldrTests.hasLocalizedLanguageFor(ULocale.ENGLISH, locales[i]) && GenerateCldrTests.hasLocalizedCountryFor(locales[i], locales[i]) && GenerateCldrTests.hasLocalizedLanguageFor(locales[i], locales[i]))) {
                log.print("FAILURE\t");
            } else {
                log.print("       \t");
            }
            log.println(locales[i] + "\t" + locales[i].getDisplayName(ULocale.ENGLISH) + "\t" + locales[i].getDisplayName(locales[i]));
        }
    }

    private static void showLocales(Set sLocs) {
        Iterator it = sLocs.iterator();
        while (it.hasNext()) {
            String s = (String)it.next();
            log.println(s + "\t" + ULocale.getDisplayLanguage((String)s, (String)"en"));
        }
    }

    private static Set filter(Object[] cols) {
        TreeSet<String> result = new TreeSet<String>();
        for (int i = 0; i < cols.length; ++i) {
            String s = cols[i].toString();
            if (s.indexOf(95) >= 0) continue;
            result.add(s);
        }
        return result;
    }

    Set addULocales(Object[] objects, Set target) {
        for (int i = 0; i < objects.length; ++i) {
            target.add(new ULocale(objects[i].toString()));
        }
        return target;
    }

    private void addLocale(ULocale item) {
        String lang = item.getLanguage();
        if (lang.length() == 0) {
            return;
        }
        ULocale parent = new ULocale(lang);
        this.parentToLocales.add((Object)parent, (Object)item);
    }

    void getLocaleList() {
        this.collationLocales = new TreeSet(ULocaleComparator);
        this.collationLocales.addAll(this.cldrCollations.getAvailableSet());
        this.allLocales.addAll(this.collationLocales);
        this.allLocales.addAll(this.numberLocales);
        this.allLocales.addAll(this.dateLocales);
        Iterator it = this.allLocales.iterator();
        while (it.hasNext()) {
            this.addLocale((ULocale)it.next());
        }
    }

    void generate(String pat) throws Exception {
        this.cldrOthers = new CldrOthers(GenerateCldrTests.options[2].value + "main" + File.separator, pat);
        this.cldrOthers.show();
        this.cldrCollations = new CldrCollations(GenerateCldrTests.options[2].value + "collation" + File.separator, pat);
        this.cldrCollations.show();
        this.cldrOthers = new CldrOthers(GenerateCldrTests.options[2].value + "main" + File.separator, pat);
        this.cldrOthers.show();
        this.getLocaleList();
        Matcher m = Pattern.compile(pat).matcher("");
        Iterator it = this.parentToLocales.keySet().iterator();
        while (it.hasNext()) {
            String p = it.next().toString();
            if (!m.reset(p).matches()) continue;
            this.generate(new ULocale(p));
        }
    }

    private void generate(ULocale locale) throws Exception {
        this.out = BagFormatter.openUTF8Writer((String)GenerateCldrTests.options[3].value, (String)(locale + ".xml"));
        this.out.println("<?xml version='1.0' encoding='UTF-8' ?>");
        this.out.println("<!DOCTYPE ldml SYSTEM 'http://www.unicode.org/cldr/dtd/1.2/beta/cldrTest.dtd'>");
        this.out.println("<!-- For information, see readme.html -->");
        this.out.println(" <cldrTest version='1.2' base='" + locale + "'>");
        this.out.println(" <!-- " + TransliteratorUtilities.toXML.transliterate(locale.getDisplayName(ULocale.ENGLISH) + " [" + locale.getDisplayName(locale)) + "] -->");
        this.generateItems(locale, this.numberLocales, NumberEquator, this.NumberShower);
        this.generateItems(locale, this.dateLocales, DateEquator, this.DateShower);
        this.generateItems(locale, this.collationLocales, this.CollationEquator, this.CollationShower);
        this.out.println(" </cldrTest>");
        this.out.close();
        Utility.generateBat(GenerateCldrTests.options[2].value + "test" + File.separator, locale + ".xml", GenerateCldrTests.options[3].value, locale + ".xml", new Utility.SimpleLineComparator(0));
    }

    void add(ULocale locale, Map uniqueLocales) {
        try {
            RuleBasedCollator col = this.cldrCollations.getInstance(locale);
            String key = col.getRules() + "\uffff" + this.getExemplarSet(locale, 0);
            TreeSet<ULocale> s = (TreeSet<ULocale>)uniqueLocales.get(key);
            if (s == null) {
                s = new TreeSet<ULocale>(ULocaleComparator);
                uniqueLocales.put(key, s);
            }
            System.out.println("Adding " + locale);
            s.add(locale);
        }
        catch (Throwable e) {
            System.out.println("skipped " + locale);
        }
    }

    public UnicodeSet getExemplarSet(ULocale locale, int options) {
        String n = locale.toString();
        int pos = n.indexOf(64);
        if (pos >= 0) {
            locale = new ULocale(n.substring(0, pos));
        }
        UnicodeSet result = this.cldrOthers.getExemplarSet(locale);
        if (options == 0) {
            result.closeOver(2);
        }
        return result;
    }

    static boolean intersects(Collection a, Collection b) {
        Iterator it = a.iterator();
        while (it.hasNext()) {
            if (!b.contains(it.next())) continue;
            return true;
        }
        return false;
    }

    static Collection extract(Object x, Collection a, Equator e, Collection output) {
        ArrayList itemsToRemove = new ArrayList();
        Iterator it = a.iterator();
        while (it.hasNext()) {
            Object item = it.next();
            if (!e.equals(x, item)) continue;
            itemsToRemove.add(item);
            output.add(item);
        }
        a.removeAll(itemsToRemove);
        return output;
    }

    private void generateItems(ULocale locale, Collection onlyLocales, Equator test, DataShower generator) throws Exception {
        Collection sublocales = this.parentToLocales.get((Object)locale, new ArrayList());
        sublocales.retainAll(onlyLocales);
        while (sublocales.size() != 0) {
            ULocale first = (ULocale)sublocales.iterator().next();
            Collection others = GenerateCldrTests.extract(first, sublocales, test, new ArrayList());
            generator.show(first, others);
        }
    }

    private void showLocales(String elementName, Collection others) {
        this.out.println("  <" + elementName + " ");
        StringBuffer comment = new StringBuffer();
        if (others != null && others.size() != 0) {
            this.out.print("locales='");
            boolean first = true;
            Iterator it = others.iterator();
            while (it.hasNext()) {
                if (first) {
                    first = false;
                } else {
                    this.out.print(" ");
                    comment.append("; ");
                }
                ULocale loc = (ULocale)it.next();
                this.out.print(loc);
                comment.append(loc.getDisplayName(ULocale.ENGLISH) + " [" + loc.getDisplayName(loc) + "]");
            }
            this.out.print("'");
        }
        this.out.println(">");
        this.out.println("<!-- " + TransliteratorUtilities.toXML.transliterate(comment.toString()) + " -->");
    }

    private static DateFormat getDateFormat(ULocale locale, int i, int k) {
        Locale olocale = locale.toLocale();
        if (olocale != null) {
            throw new IllegalArgumentException("Internal Error: should never get here.");
        }
        DateFormat df = DateFormatValues[k] == -1 ? DateFormat.getDateInstance((int)DateFormatValues[i], (Locale)olocale) : (DateFormatValues[i] == -1 ? DateFormat.getTimeInstance((int)DateFormatValues[k], (Locale)olocale) : DateFormat.getDateTimeInstance((int)DateFormatValues[i], (int)DateFormatValues[k], (Locale)olocale));
        return df;
    }

    private static NumberFormat getNumberFormat(ULocale ulocale, int i) {
        Locale olocale = ulocale.toLocale();
        NumberFormat nf = null;
        switch (i) {
            case 0: {
                nf = NumberFormat.getInstance((Locale)olocale);
                break;
            }
            case 1: {
                nf = NumberFormat.getIntegerInstance((Locale)olocale);
                break;
            }
            case 2: {
                nf = NumberFormat.getNumberInstance((Locale)olocale);
                break;
            }
            case 3: {
                nf = NumberFormat.getPercentInstance((Locale)olocale);
                break;
            }
            case 4: {
                nf = NumberFormat.getScientificInstance((Locale)olocale);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown NumberFormat: " + i);
            }
        }
        return nf;
    }

    private void doCollationResult(Collator col, UnicodeSet tailored, SortedBag bag) {
        UnicodeSetIterator usi = new UnicodeSetIterator(tailored);
        while (usi.next()) {
            String s = usi.getString();
            bag.add((Object)('x' + s));
            bag.add((Object)('X' + s));
            bag.add((Object)('x' + s + 'x'));
        }
        this.out.println("   <result>");
        String last = "";
        boolean needEquals = false;
        Iterator it = bag.iterator();
        while (it.hasNext()) {
            String s = (String)it.next();
            if (col.compare(s, last) != 0) {
                if (needEquals) {
                    this.out.println(last);
                }
                needEquals = false;
                last = s;
            } else {
                needEquals = true;
            }
            this.out.println(TransliteratorUtilities.toXML.transliterate(s));
        }
        this.out.println("   </result>");
    }

    public static Set getMatchingXMLFiles(String sourceDir, String localeRegex) {
        Matcher m = Pattern.compile(localeRegex).matcher("");
        TreeSet<String> s = new TreeSet<String>();
        File[] files = new File(sourceDir).listFiles();
        for (int i = 0; i < files.length; ++i) {
            String locale;
            String name = files[i].getName();
            if (!name.endsWith(".xml") || name.startsWith("supplementalData") || !(locale = name.substring(0, name.length() - 4)).equals("root") && !m.reset(locale).matches()) continue;
            s.add(locale);
        }
        return s;
    }

    public static boolean isDraft(Node node) {
        while (node.getNodeType() != 9) {
            NamedNodeMap attributes = node.getAttributes();
            if (attributes != null) {
                for (int i = 0; i < attributes.getLength(); ++i) {
                    Node attribute = attributes.item(i);
                    if (!attribute.getNodeName().equals("draft") || !attribute.getNodeValue().equals("unconfirmed")) continue;
                    return true;
                }
            }
            node = node.getParentNode();
        }
        return false;
    }

    public static String getXPath(Node node) {
        StringBuffer xpathFragment = new StringBuffer();
        StringBuffer xpath = new StringBuffer();
        while (node.getNodeType() != 9) {
            xpathFragment.setLength(0);
            xpathFragment.append('/').append(node.getNodeName());
            NamedNodeMap attributes = node.getAttributes();
            if (attributes != null) {
                for (int i = 0; i < attributes.getLength(); ++i) {
                    Node attribute = attributes.item(i);
                    xpathFragment.append("[@").append(attribute.getNodeName()).append('=').append(attribute.getNodeValue()).append(']');
                }
            }
            xpath.insert(0, (Object)xpathFragment);
            node = node.getParentNode();
        }
        xpath.insert(0, '/');
        return xpath.toString();
    }

    public static String getParent(String locale) {
        int pos = locale.lastIndexOf(95);
        if (pos >= 0) {
            return locale.substring(0, pos);
        }
        if (!locale.equals("root")) {
            return "root";
        }
        return null;
    }

    public static String replace(String source, String pattern, String replacement) {
        int pos = source.indexOf(pattern, 0);
        while (pos >= 0) {
            source = source.substring(0, pos) + replacement + source.substring(pos + pattern.length());
            pos = source.indexOf(pattern, pos + 1);
        }
        return source;
    }

    static UnicodeSet apply(UnicodeSet source, Apply apply) {
        UnicodeSet target = new UnicodeSet();
        UnicodeSetIterator usi = new UnicodeSetIterator(source);
        while (usi.next()) {
            String s = usi.getString();
            target.add(apply.apply(s));
        }
        return target;
    }

    static UnicodeSet nfc(UnicodeSet source) {
        return GenerateCldrTests.apply(source, new Apply(){

            public String apply(String source) {
                return Normalizer.compose((String)source, (boolean)false);
            }
        });
    }

    public static UnicodeSet createCaseClosure(UnicodeSet source) {
        UnicodeSet target = new UnicodeSet();
        UnicodeSetIterator usi = new UnicodeSetIterator(source);
        while (usi.next()) {
            String s = usi.getString();
            UnicodeSet temp = GenerateCldrTests.createClosure(s, CCCP);
            if (temp == null) {
                target.add(s);
                continue;
            }
            target.addAll(temp);
        }
        return target;
    }

    public static UnicodeSet createClosure(String source, CloseCodePoint closer) {
        return GenerateCldrTests.createClosure(source, 0, closer);
    }

    public static UnicodeSet createClosure(String source, int position, CloseCodePoint closer) {
        UnicodeSet result = new UnicodeSet();
        if (position >= source.length()) {
            return result;
        }
        int cp = UTF16.charAt((String)source, (int)position);
        int endPosition = position + UTF16.getCharCount((int)cp);
        if (endPosition >= source.length()) {
            return closer.close(cp, result);
        }
        UnicodeSet remainder = GenerateCldrTests.createClosure(source, endPosition, closer);
        return GenerateCldrTests.createAppend(closer.close(cp, result), remainder);
    }

    public static UnicodeSet createAppend(UnicodeSet a, UnicodeSet b) {
        UnicodeSet target = new UnicodeSet();
        UnicodeSetIterator usi = new UnicodeSetIterator(a);
        while (usi.next()) {
            String s = usi.getString();
            UnicodeSetIterator usi2 = new UnicodeSetIterator(b);
            while (usi2.next()) {
                String s2 = usi2.getString();
                target.add(s + s2);
            }
        }
        return target;
    }

    static {
        options = new UOption[]{UOption.HELP_H(), UOption.HELP_QUESTION_MARK(), UOption.SOURCEDIR().setDefault("../../common/"), UOption.DESTDIR().setDefault("../../dropbox/gen/test/"), UOption.create((String)"log", (char)'l', (int)1).setDefault("../../dropbox/gen/test/"), UOption.create((String)"match", (char)'m', (int)1).setDefault(".*"), UOption.create((String)"fullyresolved", (char)'f', (int)0), UOption.create((String)"languages", (char)'g', (int)0), UOption.create((String)"tzadir", (char)'t', (int)1).setDefault("C:\\ICU4J\\icu4j\\src\\com\\ibm\\icu\\dev\\tool\\cldr\\")};
        logDir = null;
        destDir = null;
        NON_LATIN = new UnicodeSet("[^[:latin:][:common:][:inherited:]]");
        fixCountryNames = new HashMap();
        fixCountryNames.put("\u0408\u0443\u0433\u043e\u0441\u043b\u0430\u0432\u0438\u0458\u0430", "\u0421\u0440\u0431\u0438\u0458\u0430 \u0438 \u0426\u0440\u043d\u0430 \u0413\u043e\u0440\u0430");
        fixCountryNames.put("Jugoslavija", "Srbija i Crna Gora");
        fixCountryNames.put("Yugoslavia", "Serbia and Montenegro");
        Utility.registerTransliteratorFromFile("Latin-Armenian", GenerateCldrTests.options[8].value, null);
        Utility.registerTransliteratorFromFile("Latin-Ethiopic", GenerateCldrTests.options[8].value, null);
        Utility.registerTransliteratorFromFile("Cyrillic-Latin", GenerateCldrTests.options[8].value, null);
        Utility.registerTransliteratorFromFile("Arabic-Latin", GenerateCldrTests.options[8].value, null);
        toLatin = Transliterator.getInstance((String)"any-latin");
        ULocaleComparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                return o1.toString().compareTo(o2.toString());
            }
        };
        utc = TimeZone.getTimeZone((String)"GMT");
        iso = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        DateFormatValues = new int[]{-1, 3, 2, 1, 0};
        DateFormatNames = new String[]{"none", "short", "medium", "long", "full"};
        DateEquator = new Equator(){

            public boolean equals(Object o1, Object o2) {
                ULocale loc1 = (ULocale)o1;
                ULocale loc2 = (ULocale)o2;
                for (int i = 0; i < DateFormatValues.length; ++i) {
                    for (int j = 0; j < DateFormatValues.length; ++j) {
                        if (i == 0 && j == 0) continue;
                        DateFormat df1 = GenerateCldrTests.getDateFormat(loc1, i, j);
                        NumberFormat nf = df1.getNumberFormat();
                        nf.setCurrency(NO_CURRENCY);
                        df1.setNumberFormat(nf);
                        DateFormat df2 = GenerateCldrTests.getDateFormat(loc2, i, j);
                        nf = df2.getNumberFormat();
                        nf.setCurrency(NO_CURRENCY);
                        df2.setNumberFormat(nf);
                        if (df1.equals((Object)df2)) continue;
                        df1.equals((Object)df2);
                        return false;
                    }
                }
                return true;
            }
        };
        NumberNames = new String[]{"standard", "integer", "decimal", "percent", "scientific"};
        NO_CURRENCY = Currency.getInstance((String)"XXX");
        NumberEquator = new Equator(){

            public boolean equals(Object o1, Object o2) {
                ULocale loc1 = (ULocale)o1;
                ULocale loc2 = (ULocale)o2;
                for (int i = 0; i < NumberNames.length; ++i) {
                    NumberFormat nf1 = GenerateCldrTests.getNumberFormat(loc1, i);
                    nf1.setCurrency(NO_CURRENCY);
                    NumberFormat nf2 = GenerateCldrTests.getNumberFormat(loc2, i);
                    nf2.setCurrency(NO_CURRENCY);
                    if (nf1.equals((Object)nf2)) continue;
                    return false;
                }
                return true;
            }
        };
        zhHack = new ULocale("zh");
        SKIP_COLLATION_SET = new UnicodeSet("[[:script=han:][:script=hangul:]-[\u4e00-\u4eff \u9f00-\u9fff \uac00-\uacff \ud700-\ud7ff]]");
        CCCP = new CloseCodePoint(){
            Locale locale = Locale.ENGLISH;
            UnicodeSet NONE = new UnicodeSet();
            UnicodeMap map = new UnicodeMap();

            public UnicodeSet close(int cp, UnicodeSet toAddTo) {
                UnicodeSet result = (UnicodeSet)this.map.getValue(cp);
                if (result == null) {
                    result = new UnicodeSet();
                    result.add(cp);
                    String s = UCharacter.toLowerCase((Locale)this.locale, (String)UTF16.valueOf((int)cp));
                    result.add(s);
                    s = UCharacter.toUpperCase((Locale)this.locale, (String)UTF16.valueOf((int)cp));
                    result.add(s);
                    s = UCharacter.toTitleCase((Locale)this.locale, (String)UTF16.valueOf((int)cp), null);
                    result.add(s);
                    if (result.contains("SS")) {
                        result.add("sS").add("ss");
                    }
                    if (result.size() == 1) {
                        result = this.NONE;
                    }
                    this.map.put(cp, (Object)result);
                }
                if (result != this.NONE) {
                    toAddTo.addAll(result);
                } else {
                    toAddTo.add(cp);
                }
                return toAddTo;
            }
        };
    }

    static class UnicodeSetComparator
    implements Comparator {
        UnicodeSetIterator ait = new UnicodeSetIterator();
        UnicodeSetIterator bit = new UnicodeSetIterator();

        UnicodeSetComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            UnicodeSet a = (UnicodeSet)o1;
            UnicodeSet b = (UnicodeSet)o2;
            if (a.size() != b.size()) {
                return a.size() < b.size() ? -1 : 1;
            }
            this.ait.reset(a);
            this.bit.reset(b);
            while (this.ait.nextRange()) {
                this.bit.nextRange();
                if (this.ait.codepoint != this.bit.codepoint) {
                    return this.ait.codepoint < this.bit.codepoint ? -1 : 1;
                }
                if (this.ait.codepoint == UnicodeSetIterator.IS_STRING) {
                    int result = this.ait.string.compareTo(this.bit.string);
                    if (result == 0) continue;
                    return result;
                }
                if (this.ait.codepointEnd == this.bit.codepointEnd) continue;
                return this.ait.codepointEnd < this.bit.codepointEnd ? -1 : 1;
            }
            return 0;
        }
    }

    public static interface CloseCodePoint {
        public UnicodeSet close(int var1, UnicodeSet var2);
    }

    public static interface Apply {
        public String apply(String var1);
    }

    static class CldrCollations {
        Set validLocales = new TreeSet();
        Map ulocale_rules = new TreeMap(ULocaleComparator);
        Map locale_types_rules = new TreeMap();
        String sourceDir;
        Map collation_collation = new HashMap();
        RuleBasedCollator emptyCollator = (RuleBasedCollator)Collator.getInstance((ULocale)new ULocale(""));
        static Transliterator fromHex = Transliterator.getInstance((String)"hex-any");

        public Set getAvailableSet() {
            return this.ulocale_rules.keySet();
        }

        public RuleBasedCollator getInstance(ULocale locale) {
            return (RuleBasedCollator)this.ulocale_rules.get(locale);
        }

        void show() {
            log.println("Showing Locales");
            log.println("Unique Collators: " + this.collation_collation.size());
            Iterator it2 = this.ulocale_rules.keySet().iterator();
            while (it2.hasNext()) {
                ULocale locale = (ULocale)it2.next();
                RuleBasedCollator col = (RuleBasedCollator)this.ulocale_rules.get(locale);
                log.println("\t" + locale + ", " + col.getRules());
            }
        }

        CldrCollations(String sourceDir, String localeRegex) throws Exception {
            Map types_rules;
            String locale;
            this.sourceDir = sourceDir;
            Set s = GenerateCldrTests.getMatchingXMLFiles(sourceDir, localeRegex);
            Iterator<Object> it = s.iterator();
            while (it.hasNext()) {
                this.getCollationRules((String)it.next());
            }
            it = this.validLocales.iterator();
            block1: while (it.hasNext()) {
                locale = (String)it.next();
                types_rules = (Map)this.locale_types_rules.get(locale);
                if (types_rules != null) {
                    log.println("Weird: overlap in validLocales: " + locale);
                    continue;
                }
                String parentlocale = GenerateCldrTests.getParent(locale);
                while (parentlocale != null) {
                    types_rules = (Map)this.locale_types_rules.get(parentlocale);
                    if (types_rules != null) {
                        this.locale_types_rules.put(locale, types_rules);
                        continue block1;
                    }
                    locale = GenerateCldrTests.getParent(parentlocale);
                }
            }
            it = this.locale_types_rules.keySet().iterator();
            while (it.hasNext()) {
                locale = (String)it.next();
                types_rules = (Map)this.locale_types_rules.get(locale);
                Iterator it2 = types_rules.keySet().iterator();
                while (it2.hasNext()) {
                    String type = (String)it2.next();
                    RuleBasedCollator col = (RuleBasedCollator)types_rules.get(type);
                    String name = type.equals("standard") ? locale : locale + "@collation=" + type;
                    this.ulocale_rules.put(new ULocale(name), col);
                }
            }
        }

        private void getCollationRules(String locale) throws Exception {
            System.out.println(locale);
            Document doc = LDMLUtilities.getFullyResolvedLDML(this.sourceDir, locale, false, false, false, false);
            Node node = LDMLUtilities.getNode(doc, "//ldml/collations");
            LDML2ICUConverter cnv = new LDML2ICUConverter();
            StringBuffer stringBuffer = new StringBuffer();
            ICUResourceWriter.ResourceTable resource = (ICUResourceWriter.ResourceTable)cnv.parseCollations(node, stringBuffer, false);
            TreeMap<String, RuleBasedCollator> types_rules = new TreeMap<String, RuleBasedCollator>();
            this.locale_types_rules.put(locale, types_rules);
            ICUResourceWriter.Resource current = resource.first;
            while (current != null) {
                if (current.name == null) {
                    log.println("Collation: null name found in " + locale);
                } else if (current instanceof ICUResourceWriter.ResourceTable) {
                    ICUResourceWriter.ResourceTable table = (ICUResourceWriter.ResourceTable)current;
                    ICUResourceWriter.Resource current2 = table.first;
                    while (current2 != null) {
                        if (current2 instanceof ICUResourceWriter.ResourceString) {
                            String rules;
                            RuleBasedCollator fixed;
                            ICUResourceWriter.ResourceString foo = (ICUResourceWriter.ResourceString)current2;
                            if (foo.name.equals("Sequence") && (fixed = this.generateCollator(locale, current.name, foo.name, rules = fromHex.transliterate(foo.val))) != null) {
                                log.println("Rules for: " + locale + ", " + current.name);
                                log.println(rules);
                                if (!rules.equals(foo.val)) {
                                    log.println("Original Rules from Ram: ");
                                    log.println(foo.val);
                                }
                                types_rules.put(current.name, fixed);
                            }
                        }
                        current2 = current2.next;
                    }
                }
                current = current.next;
            }
            Document doc2 = LDMLUtilities.parse(this.sourceDir + locale + ".xml", false);
            Node colls = LDMLUtilities.getNode(doc2, "//ldml/collations");
            String validSubLocales = LDMLUtilities.getAttributeValue(colls, "validSubLocales");
            if (validSubLocales != null) {
                String[] items = new String[100];
                com.ibm.icu.impl.Utility.split((String)validSubLocales, (char)' ', (String[])items);
                int i = 0;
                while (items[i].length() != 0) {
                    log.println("Valid Sub Locale: " + items[i]);
                    this.validLocales.add(items[i]);
                    ++i;
                }
            }
        }

        private RuleBasedCollator generateCollator(String locale, String current, String foo, String rules) {
            RuleBasedCollator fixed = null;
            try {
                if (rules.equals("")) {
                    fixed = this.emptyCollator;
                } else {
                    rules = GenerateCldrTests.replace(rules, "[optimize[", "[optimize [");
                    RuleBasedCollator col = new RuleBasedCollator(rules = GenerateCldrTests.replace(rules, "[suppressContractions[", "[suppressContractions ["));
                    fixed = (RuleBasedCollator)this.collation_collation.get(col);
                    if (fixed == null) {
                        this.collation_collation.put(col, col);
                        fixed = col;
                    }
                }
            }
            catch (Exception e) {
                log.println("***Cannot create collator from: " + locale + ", " + current + ", " + foo + ", " + rules);
                e.printStackTrace(log);
                RuleBasedCollator coll = (RuleBasedCollator)Collator.getInstance((ULocale)new ULocale(locale));
                String oldrules = coll.getRules();
                log.println("Old ICU4J: " + oldrules);
                log.println("Equal?: " + oldrules.equals(rules));
            }
            return fixed;
        }
    }

    static class CldrOthers {
        Map ulocale_exemplars = new TreeMap(ULocaleComparator);
        Map uniqueExemplars = new HashMap();
        String sourceDir;
        Set locales = new TreeSet(ULocaleComparator);
        static final ULocale ROOT = new ULocale("root");

        UnicodeSet getExemplarSet(ULocale locale) {
            return (UnicodeSet)this.ulocale_exemplars.get(locale);
        }

        void show() {
            log.println("Showing Locales");
            log.println("Unique Exemplars: " + this.uniqueExemplars.size());
            Iterator it2 = this.ulocale_exemplars.keySet().iterator();
            while (it2.hasNext()) {
                ULocale locale = (ULocale)it2.next();
                UnicodeSet us = this.getExemplarSet(locale);
                log.println("\t" + locale + ", " + us);
            }
        }

        CldrOthers(String sourceDir, String localeRegex) {
            this.sourceDir = sourceDir;
            Set s = GenerateCldrTests.getMatchingXMLFiles(sourceDir, localeRegex);
            Iterator it = s.iterator();
            while (it.hasNext()) {
                this.getInfo((String)it.next());
            }
            it = this.locales.iterator();
            block1: while (it.hasNext()) {
                ULocale locale = (ULocale)it.next();
                UnicodeSet ex = (UnicodeSet)this.ulocale_exemplars.get(locale);
                if (ex != null) continue;
                for (ULocale parent = locale.getFallback(); parent != null; parent = parent.getFallback()) {
                    ULocale fixedParent = parent.getLanguage().length() == 0 ? ROOT : parent;
                    ex = (UnicodeSet)this.ulocale_exemplars.get(fixedParent);
                    if (ex == null) continue;
                    this.ulocale_exemplars.put(locale, ex);
                    continue block1;
                }
            }
        }

        void getInfo(String locale) {
            String exemplars;
            UnicodeSet exemplarSet;
            UnicodeSet fixed;
            System.out.println("Getting info for: " + locale);
            this.locales.add(new ULocale(locale));
            Document doc = options[6].doesOccur ? LDMLUtilities.getFullyResolvedLDML(this.sourceDir, locale, false, false, false, false) : LDMLUtilities.parse(this.sourceDir + locale + ".xml", false);
            Node node = LDMLUtilities.getNode(doc, "//ldml/characters/exemplarCharacters");
            if (node == null) {
                return;
            }
            if (GenerateCldrTests.isDraft(node)) {
                System.out.println("Skipping draft: " + locale + ", " + GenerateCldrTests.getXPath(node));
            }
            if ((fixed = (UnicodeSet)this.uniqueExemplars.get(exemplarSet = new UnicodeSet(exemplars = LDMLUtilities.getNodeValue(node)))) == null) {
                this.uniqueExemplars.put(exemplarSet, exemplarSet);
                fixed = exemplarSet;
            }
            this.ulocale_exemplars.put(new ULocale(locale), fixed);
        }
    }

    static interface DataShower {
        public void show(ULocale var1, Collection var2) throws Exception;
    }

    class ResultsPrinter {
        Map settings = new TreeMap();
        Map oldSettings = new TreeMap();

        ResultsPrinter() {
        }

        void set(String name, String value) {
            this.settings.put(name, value);
        }

        void print(String result) {
            GenerateCldrTests.this.out.print("   <result");
            Iterator it = this.settings.keySet().iterator();
            while (it.hasNext()) {
                Object key = it.next();
                Object value = this.settings.get(key);
                if (value.equals(this.oldSettings.get(key))) continue;
                GenerateCldrTests.this.out.print(" " + key + "='" + TransliteratorUtilities.toXML.transliterate(value.toString()) + "'");
                this.oldSettings.put(key, value);
            }
            GenerateCldrTests.this.out.println(">" + TransliteratorUtilities.toXML.transliterate(result) + "</result>");
        }
    }

    public static interface Equator {
        public boolean equals(Object var1, Object var2);
    }

    public static class DraftChecker {
        String dir;
        Map cache = new HashMap();
        Object TRUE = new Object();
        Object FALSE = new Object();

        public DraftChecker(String dir) {
            this.dir = dir;
        }

        public boolean isDraft(String localeName) {
            Object check = this.cache.get(localeName);
            if (check != null) {
                return check == this.TRUE;
            }
            BufferedReader pw = null;
            boolean result = true;
            try {
                String line;
                pw = BagFormatter.openUTF8Reader((String)this.dir, (String)(localeName + ".xml"));
                do {
                    if ((line = pw.readLine()) != null) continue;
                    throw new IllegalArgumentException("Internal Error: should never get here.");
                } while (line.indexOf("<ldml") < 0);
                check = line.indexOf("draft") >= 0 ? this.TRUE : this.FALSE;
                pw.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new IllegalArgumentException("Failure on " + localeName + ": " + this.dir + localeName + ".xml");
            }
            this.cache.put(localeName, check);
            return check == this.TRUE;
        }
    }

    private static class LanguageList
    implements Comparable {
        Object[] contents;
        static Collator col = Collator.getInstance((ULocale)ULocale.ENGLISH);
        static Comparator comp = new ArrayComparator((Comparator[])new Collator[]{col, col, null});

        LanguageList(String locale, String englishName, String localName) {
            this.contents = new Object[]{englishName, locale, localName};
        }

        public int compareTo(Object o) {
            return comp.compare(this.contents, ((LanguageList)o).contents);
        }

        String getLocale() {
            return (String)this.contents[1];
        }

        String getEnglishName() {
            return (String)this.contents[0];
        }

        String getLocalName() {
            return (String)this.contents[2];
        }
    }
}

