/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.ooo;

import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMWrapper {
    private Document m_Doc = null;

    public DOMWrapper(Document doc) {
        this.resetDoc(doc);
    }

    public void resetDoc(Document doc) {
        this.m_Doc = doc;
    }

    public String getTextFromElement(String element) {
        NodeList nlChildren;
        Node textNode;
        String text = null;
        if (element == null) {
            return text;
        }
        NodeList nl = this.m_Doc.getElementsByTagName(element);
        Node node = nl.item(0);
        if (node != null && node.getNodeType() == 1 && (textNode = (nlChildren = node.getChildNodes()).item(0)) != null && textNode.getNodeType() == 3) {
            text = textNode.getNodeValue();
        }
        return text;
    }

    public String getTextFromElement(String parentElement, String element) {
        String text = null;
        if (parentElement == null || element == null) {
            return text;
        }
        NodeList nl = this.m_Doc.getElementsByTagName(element);
        for (int i = 0; i < nl.getLength(); ++i) {
            NodeList nlChildren;
            Node textNode;
            Node node = nl.item(i);
            Node nodeParent = node.getParentNode();
            if (node.getNodeType() != 1 || nodeParent.getNodeName().compareTo(parentElement) != 0 || (textNode = (nlChildren = node.getChildNodes()).item(0)) == null || textNode.getNodeType() != 3) continue;
            text = textNode.getNodeValue();
            break;
        }
        return text;
    }

    public Vector getTextFromAllElements(String parentElement, String element) {
        Vector<String> data = new Vector<String>();
        if (parentElement == null || element == null) {
            return null;
        }
        NodeList nl = this.m_Doc.getElementsByTagName(element);
        for (int i = 0; i < nl.getLength(); ++i) {
            String text;
            NodeList nlChildren;
            Node textNode;
            Node node = nl.item(i);
            Node nodeParent = node.getParentNode();
            if (node.getNodeType() != 1 || nodeParent.getNodeName().compareTo(parentElement) != 0 || (textNode = (nlChildren = node.getChildNodes()).item(0)) == null || textNode.getNodeType() != 3 || (text = textNode.getNodeValue()) == null) continue;
            data.add(text);
        }
        return data;
    }

    public Vector getAttributesFromElement(String parentElement, String element) {
        Vector allElementAttributes = new Vector();
        if (parentElement == null || element == null) {
            return null;
        }
        NodeList nl = this.m_Doc.getElementsByTagName(element);
        for (int i = 0; i < nl.getLength(); ++i) {
            Hashtable<String, String> attributes = new Hashtable<String, String>();
            Node node = nl.item(i);
            Node nodeParent = node.getParentNode();
            if (node.getNodeType() == 1 && nodeParent.getNodeName().compareTo(parentElement) == 0) {
                NamedNodeMap attrMap = node.getAttributes();
                for (int j = 0; j < attrMap.getLength(); ++j) {
                    Node attrNode = attrMap.item(j);
                    String key = attrNode.getNodeName();
                    String value = attrNode.getNodeValue();
                    attributes.put(key, value);
                }
            }
            allElementAttributes.add(attributes);
        }
        return allElementAttributes;
    }

    public Hashtable getAttributesFromElement(String parentElement, String element, String attribute) {
        Hashtable allElementAttributes = new Hashtable();
        if (parentElement == null || element == null || attribute == null) {
            return null;
        }
        NodeList nl = this.m_Doc.getElementsByTagName(element);
        for (int i = 0; i < nl.getLength(); ++i) {
            Hashtable<String, String> attributes = new Hashtable<String, String>();
            String attributeValue = null;
            Node node = nl.item(i);
            Node nodeParent = node.getParentNode();
            if (node.getNodeType() == 1 && nodeParent.getNodeName().compareTo(parentElement) == 0) {
                NamedNodeMap attrMap = node.getAttributes();
                for (int j = 0; j < attrMap.getLength(); ++j) {
                    Node attrNode = attrMap.item(j);
                    String key = attrNode.getNodeName();
                    String value = attrNode.getNodeValue();
                    if (key.compareTo(attribute) == 0) {
                        attributeValue = value;
                    }
                    attributes.put(key, value);
                }
            }
            if (attributeValue == null) continue;
            if (!allElementAttributes.containsKey(attributeValue)) {
                allElementAttributes.put(attributeValue, attributes);
                continue;
            }
            System.err.println("WARNING 1: duplicate " + attributeValue + " attribute under " + parentElement);
        }
        return allElementAttributes;
    }

    public Hashtable getAndMapAttributes(String element, String attribute1, String attribute2) {
        Hashtable<String, String> data = new Hashtable<String, String>();
        if (element == null || attribute1 == null || attribute2 == null) {
            return null;
        }
        NodeList nl = this.m_Doc.getElementsByTagName(element);
        for (int i = 0; i < nl.getLength(); ++i) {
            Hashtable attributes = new Hashtable();
            Object attributeValue = null;
            Node node = nl.item(i);
            if (node.getNodeType() != 1) continue;
            NamedNodeMap attrMap = node.getAttributes();
            String key = null;
            String value = null;
            for (int j = 0; j < attrMap.getLength(); ++j) {
                Node attrNode = attrMap.item(j);
                if (attrNode.getNodeName().equals(attribute1)) {
                    key = attrNode.getNodeValue();
                }
                if (!attrNode.getNodeName().equals(attribute2)) continue;
                value = attrNode.getNodeValue();
            }
            if (key == null || value == null) continue;
            String val = (String)data.get(key);
            if (val != null) {
                value = val + " " + value;
            }
            data.put(key, value);
        }
        return data;
    }

    public String getAttributesFromElement(String parentElement, String element, String attribName, String parentAttribName, String parentAttribValue) {
        if (parentElement == null || element == null || attribName == null || parentAttribName == null || parentAttribValue == null) {
            return null;
        }
        String attributeValue = null;
        NodeList nl = this.m_Doc.getElementsByTagName(element);
        for (int i = 0; i < nl.getLength(); ++i) {
            String value;
            String key;
            Node attrNode;
            int j;
            Node node = nl.item(i);
            Node nodeParent = node.getParentNode();
            if (node.getNodeType() != 1 || nodeParent.getNodeName().compareTo(parentElement) != 0) continue;
            boolean bParentMatch = false;
            NamedNodeMap attrMap = nodeParent.getAttributes();
            for (j = 0; j < attrMap.getLength(); ++j) {
                attrNode = attrMap.item(j);
                key = attrNode.getNodeName();
                value = attrNode.getNodeValue();
                if (key.compareTo(parentAttribName) != 0 || value.compareTo(parentAttribValue) != 0) continue;
                bParentMatch = true;
                break;
            }
            if (!bParentMatch) continue;
            attrMap = node.getAttributes();
            for (j = 0; j < attrMap.getLength(); ++j) {
                attrNode = attrMap.item(j);
                key = attrNode.getNodeName();
                value = attrNode.getNodeValue();
                if (key.compareTo(attribName) != 0) continue;
                attributeValue = value;
            }
        }
        return attributeValue;
    }

    public Vector getAttributesFromElement2(String parentElement, String element, String attribName, String parentAttribName, String parentAttribValue) {
        if (parentElement == null || element == null || attribName == null || parentAttribName == null || parentAttribValue == null) {
            return null;
        }
        Vector<String> attributes = new Vector<String>();
        NodeList nl = this.m_Doc.getElementsByTagName(element);
        for (int i = 0; i < nl.getLength(); ++i) {
            String value;
            String key;
            Node attrNode;
            int j;
            Node node = nl.item(i);
            Node nodeParent = node.getParentNode();
            if (node.getNodeType() != 1 || nodeParent.getNodeName().compareTo(parentElement) != 0) continue;
            boolean bParentMatch = false;
            NamedNodeMap attrMap = nodeParent.getAttributes();
            for (j = 0; j < attrMap.getLength(); ++j) {
                attrNode = attrMap.item(j);
                key = attrNode.getNodeName();
                value = attrNode.getNodeValue();
                if (key.compareTo(parentAttribName) != 0 || value.compareTo(parentAttribValue) != 0) continue;
                bParentMatch = true;
                break;
            }
            if (!bParentMatch) continue;
            attrMap = node.getAttributes();
            for (j = 0; j < attrMap.getLength(); ++j) {
                attrNode = attrMap.item(j);
                key = attrNode.getNodeName();
                value = attrNode.getNodeValue();
                if (key.compareTo(attribName) != 0) continue;
                attributes.add(value);
            }
        }
        return attributes;
    }

    public Vector getAttributesFromElement(String element) {
        if (element == null) {
            return null;
        }
        Vector allElementAttributes = new Vector();
        NodeList nl = this.m_Doc.getElementsByTagName(element);
        for (int i = 0; i < nl.getLength(); ++i) {
            Hashtable<String, String> attributes = new Hashtable<String, String>();
            Node node = nl.item(i);
            NamedNodeMap attrMap = node.getAttributes();
            for (int j = 0; j < attrMap.getLength(); ++j) {
                Node attrNode = attrMap.item(j);
                String key = attrNode.getNodeName();
                String value = attrNode.getNodeValue();
                attributes.put(key, value);
            }
            allElementAttributes.add(attributes);
        }
        return allElementAttributes;
    }

    public String getAttributeFromElement(String element, String attrName) {
        if (element == null) {
            return null;
        }
        String attrValue = null;
        NodeList nl = this.m_Doc.getElementsByTagName(element);
        block0: for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            NamedNodeMap attrMap = node.getAttributes();
            for (int j = 0; j < attrMap.getLength(); ++j) {
                Node attrNode = attrMap.item(j);
                if (attrNode.getNodeName().compareTo(attrName) != 0) continue;
                attrValue = attrNode.getNodeValue();
                continue block0;
            }
        }
        return attrValue;
    }

    public Vector getAttrsFromElement(String element, String attribName) {
        if (element == null) {
            return null;
        }
        Vector<String> allElementAttributes = new Vector<String>();
        NodeList nl = this.m_Doc.getElementsByTagName(element);
        block0: for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            NamedNodeMap attrMap = node.getAttributes();
            for (int j = 0; j < attrMap.getLength(); ++j) {
                Node attrNode = attrMap.item(j);
                if (attrNode.getNodeName().compareTo(attribName) != 0) continue;
                allElementAttributes.add(attrNode.getNodeValue());
                continue block0;
            }
        }
        return allElementAttributes;
    }

    public Hashtable getAttributesFromNode(Node node) {
        Hashtable<String, String> attributes = new Hashtable<String, String>();
        if (node == null) {
            return null;
        }
        if (node.getNodeType() == 1) {
            NamedNodeMap attrMap = node.getAttributes();
            for (int j = 0; j < attrMap.getLength(); ++j) {
                Node attrNode = attrMap.item(j);
                String key = attrNode.getNodeName();
                String value = attrNode.getNodeValue();
                attributes.put(key, value);
            }
        }
        return attributes;
    }

    public Hashtable getTextFromElementsAndGGPAttrib(String parentElement, String element, String elementSibling, String greatGrandParentAttrib) {
        Hashtable<String, String> inner = new Hashtable<String, String>();
        Hashtable outer = new Hashtable();
        if (parentElement == null || element == null || elementSibling == null) {
            return null;
        }
        String prevGreatGParentAttribValue = "unknown";
        NodeList nl = this.m_Doc.getElementsByTagName(element);
        for (int i = 0; i < nl.getLength(); ++i) {
            Hashtable greatGParentAttribs;
            String greatGParentAttribValue;
            Node greatGParentNode;
            String elementText = null;
            String siblingElementText = null;
            Node node = nl.item(i);
            Node nodeParent = node.getParentNode();
            if (node.getNodeType() != 1 || nodeParent.getNodeName().compareTo(parentElement) != 0) continue;
            NodeList nlChildren = node.getChildNodes();
            Node textNode = nlChildren.item(0);
            if (textNode.getNodeType() == 3) {
                elementText = textNode.getNodeValue();
            }
            for (Node siblingNode = node.getNextSibling(); siblingNode != null; siblingNode = siblingNode.getNextSibling()) {
                NodeList nlSiblingChildren;
                Node siblingTextNode;
                if (siblingNode.getNodeName().compareTo(elementSibling) != 0 || (siblingTextNode = (nlSiblingChildren = siblingNode.getChildNodes()).item(0)) == null || siblingTextNode.getNodeType() != 3) continue;
                siblingElementText = siblingTextNode.getNodeValue();
                break;
            }
            if ((greatGParentNode = nodeParent.getParentNode().getParentNode()) == null || (greatGParentAttribValue = (String)(greatGParentAttribs = this.getAttributesFromNode(greatGParentNode)).get(greatGrandParentAttrib)) == null) continue;
            if (prevGreatGParentAttribValue.compareTo("unknown") == 0) {
                prevGreatGParentAttribValue = greatGParentAttribValue;
            }
            if (prevGreatGParentAttribValue.compareTo(greatGParentAttribValue) == 0) {
                if (elementText != null && siblingElementText != null) {
                    if (!inner.containsKey(elementText)) {
                        inner.put(elementText, siblingElementText);
                    } else {
                        System.err.println("WARNING 2: duplicate " + elementText + " element value under " + parentElement);
                    }
                }
            } else {
                Hashtable innerCopy = new Hashtable(inner);
                if (!outer.containsKey(prevGreatGParentAttribValue)) {
                    outer.put(prevGreatGParentAttribValue, innerCopy);
                } else {
                    System.err.println("WARNING 3: duplicate " + prevGreatGParentAttribValue + " value for " + greatGrandParentAttrib);
                }
                inner.clear();
                if (elementText != null && siblingElementText != null) {
                    if (!inner.containsKey(elementText)) {
                        inner.put(elementText, siblingElementText);
                    } else {
                        System.err.println("WARNING 4: duplicate " + elementText + " element value under " + parentElement);
                    }
                }
            }
            prevGreatGParentAttribValue = greatGParentAttribValue;
        }
        if (prevGreatGParentAttribValue.compareTo("unknown") != 0) {
            if (!outer.containsKey(prevGreatGParentAttribValue)) {
                outer.put(prevGreatGParentAttribValue, inner);
            } else {
                System.err.println("WARNING 5: duplicate " + prevGreatGParentAttribValue + " value for " + greatGrandParentAttrib);
            }
        }
        return outer;
    }

    public Hashtable getTextFromElementsAndGPAttrib(String parentElement, String element, String grandParentAttrib) {
        if (parentElement == null || element == null || grandParentAttrib == null) {
            return null;
        }
        Hashtable<String, String> outer = new Hashtable<String, String>();
        NodeList nl = this.m_Doc.getElementsByTagName(element);
        for (int i = 0; i < nl.getLength(); ++i) {
            Hashtable grandParentAttribs;
            String grandParentAttribValue;
            Node grandParentNode;
            String elementText = null;
            Node node = nl.item(i);
            Node nodeParent = node.getParentNode();
            if (node.getNodeType() != 1 || nodeParent.getNodeName().compareTo(parentElement) != 0) continue;
            NodeList nlChildren = node.getChildNodes();
            Node textNode = nlChildren.item(0);
            if (textNode.getNodeType() == 3) {
                elementText = textNode.getNodeValue();
            }
            if ((grandParentNode = nodeParent.getParentNode()) == null || (grandParentAttribValue = (String)(grandParentAttribs = this.getAttributesFromNode(grandParentNode)).get(grandParentAttrib)) == null) continue;
            if (!outer.containsKey(grandParentAttribValue)) {
                outer.put(grandParentAttribValue, elementText);
                continue;
            }
            System.err.println("WARNING 6: duplicate " + grandParentAttribValue + " value for " + grandParentAttrib);
        }
        return outer;
    }

    public Hashtable getTextFromElementsAndGPAttrib(String element, String parentElement, String gparentElement, String grandParentAttrib) {
        if (element == null || parentElement == null || gparentElement == null || grandParentAttrib == null) {
            return null;
        }
        Hashtable<String, String> outer = new Hashtable<String, String>();
        NodeList nl = this.m_Doc.getElementsByTagName(element);
        for (int i = 0; i < nl.getLength(); ++i) {
            Hashtable grandParentAttribs;
            String grandParentAttribValue;
            String elementText = null;
            Node node = nl.item(i);
            Node nodeParent = node.getParentNode();
            if (node.getNodeType() != 1 || nodeParent == null || nodeParent.getNodeName().compareTo(parentElement) != 0) continue;
            Node nodeGParent = nodeParent.getParentNode();
            if (nodeParent.getNodeType() != 1 || nodeGParent == null || nodeGParent.getNodeName().compareTo(gparentElement) != 0) continue;
            NodeList nlChildren = node.getChildNodes();
            Node textNode = nlChildren.item(0);
            if (textNode.getNodeType() == 3) {
                elementText = textNode.getNodeValue();
            }
            if ((grandParentAttribValue = (String)(grandParentAttribs = this.getAttributesFromNode(nodeGParent)).get(grandParentAttrib)) == null || elementText == null) continue;
            if (!outer.containsKey(grandParentAttribValue)) {
                outer.put(grandParentAttribValue, elementText);
                continue;
            }
            System.err.println("WARNING 7: duplicate " + grandParentAttribValue + " value for " + grandParentAttrib);
        }
        return outer;
    }

    public Vector getTextFromElementsAndGPAttrib(String element, String elAttrib, String gparentElement, String grandParentAttrib, String gParentAttribValue) {
        if (element == null || elAttrib == null || gparentElement == null || grandParentAttrib == null || gParentAttribValue == null) {
            return null;
        }
        Vector<String> attrs = new Vector<String>();
        NodeList nl = this.m_Doc.getElementsByTagName(element);
        for (int i = 0; i < nl.getLength(); ++i) {
            Hashtable grandParentAttribs;
            String grandParentAttribValue;
            String attrText = null;
            Node node = nl.item(i);
            Node nodeParent = node.getParentNode();
            if (node.getNodeType() != 1 || nodeParent == null) continue;
            Node nodeGParent = nodeParent.getParentNode();
            if (nodeParent.getNodeType() != 1 || nodeGParent == null || nodeGParent.getNodeName().compareTo(gparentElement) != 0) continue;
            NamedNodeMap nlAttrs = node.getAttributes();
            Node attrNode = nlAttrs.getNamedItem(elAttrib);
            if (attrNode.getNodeType() == 2 && attrNode.getNodeName().compareTo(elAttrib) == 0) {
                attrText = attrNode.getNodeValue();
            }
            if ((grandParentAttribValue = (String)(grandParentAttribs = this.getAttributesFromNode(nodeGParent)).get(grandParentAttrib)).compareTo(gParentAttribValue) != 0) continue;
            attrs.add(attrText);
        }
        return attrs;
    }

    public Hashtable getTextFromElementsAndParentAttrib(String parentElement, String element, String parentAttrib) {
        if (parentElement == null || element == null || parentAttrib == null) {
            return null;
        }
        Hashtable<String, String> outer = new Hashtable<String, String>();
        NodeList nl = this.m_Doc.getElementsByTagName(element);
        for (int i = 0; i < nl.getLength(); ++i) {
            Hashtable parentAttribs;
            String parentAttribValue;
            String elementText = null;
            Node node = nl.item(i);
            Node nodeParent = node.getParentNode();
            if (node.getNodeType() != 1 || nodeParent.getNodeName().compareTo(parentElement) != 0) continue;
            NodeList nlChildren = node.getChildNodes();
            Node textNode = nlChildren.item(0);
            if (textNode != null && textNode.getNodeType() == 3) {
                elementText = textNode.getNodeValue();
            }
            if (nodeParent == null || (parentAttribValue = (String)(parentAttribs = this.getAttributesFromNode(nodeParent)).get(parentAttrib)) == null || elementText == null) continue;
            if (!outer.containsKey(parentAttribValue)) {
                outer.put(parentAttribValue, elementText);
                continue;
            }
            System.err.println("WARNING 8: duplicate " + parentElement + " with " + parentAttrib + " = " + parentAttribValue);
        }
        return outer;
    }

    public Hashtable getTextFromElementsAndElementAttrib(String parentElement, String element, String elementAttrib) {
        if (parentElement == null || element == null || elementAttrib == null) {
            return null;
        }
        Hashtable<String, String> outer = new Hashtable<String, String>();
        NodeList nl = this.m_Doc.getElementsByTagName(element);
        for (int i = 0; i < nl.getLength(); ++i) {
            Hashtable attribs;
            String attribValue;
            String elementText = null;
            Node node = nl.item(i);
            Node nodeParent = node.getParentNode();
            if (node.getNodeType() != 1 || nodeParent.getNodeName().compareTo(parentElement) != 0) continue;
            NodeList nlChildren = node.getChildNodes();
            Node textNode = nlChildren.item(0);
            if (textNode != null && textNode.getNodeType() == 3) {
                elementText = textNode.getNodeValue();
            }
            if ((attribValue = (String)(attribs = this.getAttributesFromNode(node)).get(elementAttrib)) == null || elementText == null) continue;
            if (!outer.containsKey(attribValue)) {
                outer.put(attribValue, elementText);
                continue;
            }
            System.err.println("WARNING 9: duplicate " + attribValue + " for " + elementAttrib);
        }
        return outer;
    }

    public Hashtable getTextFromElement(String parentElement, String element, String elementSibling) {
        Hashtable<String, String> table = new Hashtable<String, String>();
        if (parentElement == null || element == null || elementSibling == null) {
            return null;
        }
        NodeList nl = this.m_Doc.getElementsByTagName(element);
        for (int i = 0; i < nl.getLength(); ++i) {
            NodeList nlSiblingChildren;
            Node siblingTextNode;
            Node siblingNode;
            String elementText = null;
            String siblingElementText = null;
            Node node = nl.item(i);
            Node nodeParent = node.getParentNode();
            if (node.getNodeType() != 1 || nodeParent.getNodeName().compareTo(parentElement) != 0) continue;
            NodeList nlChildren = node.getChildNodes();
            Node textNode = nlChildren.item(0);
            if (textNode.getNodeType() == 3) {
                elementText = textNode.getNodeValue();
            }
            for (siblingNode = node.getNextSibling(); siblingNode != null; siblingNode = siblingNode.getNextSibling()) {
                if (siblingNode.getNodeName().compareTo(elementSibling) != 0 || (siblingTextNode = (nlSiblingChildren = siblingNode.getChildNodes()).item(0)) == null || siblingTextNode.getNodeType() != 3) continue;
                siblingElementText = siblingTextNode.getNodeValue();
                break;
            }
            if (siblingElementText == null) {
                for (siblingNode = node.getPreviousSibling(); siblingNode != null; siblingNode = siblingNode.getPreviousSibling()) {
                    if (siblingNode.getNodeName().compareTo(elementSibling) != 0 || (siblingTextNode = (nlSiblingChildren = siblingNode.getChildNodes()).item(0)) == null || siblingTextNode.getNodeType() != 3) continue;
                    siblingElementText = siblingTextNode.getNodeValue();
                    break;
                }
            }
            if (elementText == null || siblingElementText == null) continue;
            if (!table.containsKey(elementText)) {
                table.put(elementText, siblingElementText);
                continue;
            }
            System.err.println("WARNING 10: duplicate " + elementText + " under " + parentElement);
        }
        return table;
    }

    public String getAttributeValue(String element, String attribute) {
        String attributeValue = null;
        if (element == null || attribute == null) {
            return null;
        }
        NodeList nl = this.m_Doc.getElementsByTagName(element);
        if (nl.getLength() > 0) {
            Node node = nl.item(0);
            NamedNodeMap attrMap = node.getAttributes();
            for (int j = 0; j < attrMap.getLength(); ++j) {
                Node attrNode = attrMap.item(j);
                String key = attrNode.getNodeName();
                if (key.compareTo(attribute) != 0) continue;
                attributeValue = attrNode.getNodeValue();
                break;
            }
        }
        return attributeValue;
    }

    public Hashtable getAttributeValues(String element, String attribute, String parentElement, String parentAttribute) {
        if (element == null || attribute == null || parentElement == null || parentAttribute == null) {
            return null;
        }
        Hashtable<String, String> table = new Hashtable<String, String>();
        NodeList nl = this.m_Doc.getElementsByTagName(element);
        for (int i = 0; i < nl.getLength(); ++i) {
            String attributeValue = null;
            Node node = nl.item(i);
            NamedNodeMap attrMap = node.getAttributes();
            for (int j = 0; j < attrMap.getLength(); ++j) {
                Node attrNode = attrMap.item(j);
                String key = attrNode.getNodeName();
                if (key.compareTo(attribute) != 0) continue;
                attributeValue = attrNode.getNodeValue();
                break;
            }
            if (attributeValue == null) continue;
            String parentAttributeValue = null;
            Node nodeParent = node.getParentNode();
            NamedNodeMap parentAttrMap = nodeParent.getAttributes();
            for (int j = 0; j < parentAttrMap.getLength(); ++j) {
                Node attrNode = parentAttrMap.item(j);
                String key = attrNode.getNodeName();
                if (key.compareTo(parentAttribute) != 0) continue;
                parentAttributeValue = attrNode.getNodeValue();
                break;
            }
            if (parentAttributeValue == null) continue;
            if (!table.containsKey(parentAttributeValue)) {
                table.put(parentAttributeValue, attributeValue);
                continue;
            }
            System.err.println("WARNING 11: duplicate " + parentAttributeValue + " for " + parentAttribute);
        }
        return table;
    }

    public Hashtable getParentAttribsOfElement(String parentElement, String element) {
        if (parentElement == null || element == null) {
            return null;
        }
        Hashtable<String, Hashtable> table = new Hashtable<String, Hashtable>();
        NodeList nl = this.m_Doc.getElementsByTagName(element);
        for (int i = 0; i < nl.getLength(); ++i) {
            String elementText = null;
            Node node = nl.item(i);
            Node nodeParent = node.getParentNode();
            if (node.getNodeType() != 1 || nodeParent.getNodeName().compareTo(parentElement) != 0) continue;
            NodeList nlChildren = node.getChildNodes();
            Node textNode = nlChildren.item(0);
            if (textNode != null && textNode.getNodeType() == 3) {
                elementText = textNode.getNodeValue();
            }
            if (nodeParent == null) continue;
            Hashtable parentAttribs = this.getAttributesFromNode(nodeParent);
            if (elementText == null || parentAttribs == null) continue;
            if (!table.containsKey(elementText)) {
                table.put(elementText, parentAttribs);
                continue;
            }
            System.err.println("WARNING 12: duplicate " + elementText + " under " + parentElement);
        }
        return table;
    }

    public String getTextFromElementWithAttrib(String element, String attribute, String attribValue, String parent, String grandparent) {
        String text = "";
        NodeList nl = this.m_Doc.getElementsByTagName(element);
        int i = 0;
        boolean found = false;
        while (nl.getLength() != 0) {
            Node node = nl.item(i);
            NamedNodeMap attrMap = node.getAttributes();
            for (int j = 0; j < attrMap.getLength(); ++j) {
                NodeList nlChildren;
                Node textNode;
                Node grandparentNode;
                Node parentNode;
                Node attrNode = attrMap.item(j);
                String key = attrNode.getNodeName();
                String val = attrNode.getNodeValue();
                if (key.compareTo(attribute) != 0 || val.compareTo(attribValue) != 0 || (parentNode = node.getParentNode()) == null || parentNode.getNodeName().compareTo(parent) != 0 || (grandparentNode = parentNode.getParentNode()) == null || grandparentNode.getNodeName().compareTo(grandparent) != 0 || (textNode = (nlChildren = node.getChildNodes()).item(0)) == null || textNode.getNodeType() != 3) continue;
                text = textNode.getNodeValue();
                break;
            }
            if (++i < nl.getLength() && !found) continue;
        }
        return text;
    }

    public Vector getAttributesAndTextFromAllElements(String parentElement, String element) {
        Vector allElements = new Vector();
        if (parentElement == null || element == null) {
            return null;
        }
        NodeList nl = this.m_Doc.getElementsByTagName(element);
        for (int i = 0; i < nl.getLength(); ++i) {
            Hashtable<String, Object> attribsText = new Hashtable<String, Object>();
            Hashtable<String, String> attributes = new Hashtable<String, String>();
            Node node = nl.item(i);
            Node nodeParent = node.getParentNode();
            if (node.getNodeType() == 1 && nodeParent.getNodeName().compareTo(parentElement) == 0) {
                String text;
                NamedNodeMap attrMap = node.getAttributes();
                for (int j = 0; j < attrMap.getLength(); ++j) {
                    Node attrNode = attrMap.item(j);
                    String key = attrNode.getNodeName();
                    String value = attrNode.getNodeValue();
                    attributes.put(key, value);
                }
                NodeList nlChildren = node.getChildNodes();
                Node textNode = nlChildren.item(0);
                if (textNode != null && textNode.getNodeType() == 3 && (text = textNode.getNodeValue()) != null) {
                    attribsText.put("innerText", text);
                }
            }
            if (attributes.size() > 0) {
                attribsText.put("attributes", attributes);
            }
            if (attribsText.size() <= 0) continue;
            allElements.add(attribsText);
        }
        return allElements;
    }

    public Hashtable getTextFromAllElementsWithGGGParent(String element, String attribute, String parent, String parentAttribute, String parentAttributeValue, String gparent, String ggparent, String gggparent, String gggparentAttribute) {
        Hashtable allElements = new Hashtable();
        if (element == null || attribute == null || parent == null || parentAttribute == null || parentAttributeValue == null || gparent == null || ggparent == null || gggparent == null || gggparentAttribute == null) {
            return null;
        }
        NodeList nl = this.m_Doc.getElementsByTagName(element);
        for (int i = 0; i < nl.getLength(); ++i) {
            String str;
            Hashtable elementText = new Hashtable();
            Node node = nl.item(i);
            Node nodeParent = node.getParentNode();
            if (node.getNodeType() != 1 || this.getAttributeValue(node, attribute) == null || nodeParent.getNodeName().compareTo(parent) != 0 || !this.nodeAttributeValueMatches(nodeParent, parentAttribute, parentAttributeValue)) continue;
            Node nodeGParent = nodeParent.getParentNode();
            if (nodeParent.getNodeType() != 1 || nodeGParent.getNodeName().compareTo(gparent) != 0) continue;
            Node nodeGGParent = nodeGParent.getParentNode();
            if (nodeGParent.getNodeType() != 1 || nodeGGParent.getNodeName().compareTo(ggparent) != 0) continue;
            Node nodeGGGParent = nodeGGParent.getParentNode();
            if (nodeGGParent.getNodeType() != 1 || nodeGGGParent.getNodeName().compareTo(gggparent) != 0) continue;
            String gggparentAttributeValue = this.getAttributeValue(nodeGGGParent, gggparentAttribute);
            String nodeText = this.getNodeText(node);
            if (gggparentAttributeValue == null || nodeText == null) continue;
            Hashtable<String, String> innerTable = (Hashtable<String, String>)allElements.get(gggparentAttributeValue);
            if (innerTable == null) {
                innerTable = new Hashtable<String, String>();
                allElements.put(gggparentAttributeValue, innerTable);
            }
            if (innerTable.get(str = this.getAttributeValue(node, attribute)) == null) {
                innerTable.put(str, nodeText);
                continue;
            }
            System.err.println("WARNING 13: duplicate " + str + " with " + attribute + " = " + nodeText);
        }
        return allElements;
    }

    public Hashtable getTextFromAllElementsWithGGGParent(String element, String attribute, String parent, String parentAttribute, String parentAttributeValue, String gparent, String ggparent, String gggparent, String gggparentAttribute, String gparentAttribute, String gparentAttribValue) {
        Hashtable allElements = new Hashtable();
        if (element == null || attribute == null || parent == null || parentAttribute == null || parentAttributeValue == null || gparent == null || ggparent == null || gggparent == null || gggparentAttribute == null) {
            return null;
        }
        NodeList nl = this.m_Doc.getElementsByTagName(element);
        for (int i = 0; i < nl.getLength(); ++i) {
            String str;
            Hashtable elementText = new Hashtable();
            Node node = nl.item(i);
            Node nodeParent = node.getParentNode();
            if (node.getNodeType() != 1 || this.getAttributeValue(node, attribute) == null || nodeParent.getNodeName().compareTo(parent) != 0 || !this.nodeAttributeValueMatches(nodeParent, parentAttribute, parentAttributeValue)) continue;
            Node nodeGParent = nodeParent.getParentNode();
            if (nodeParent.getNodeType() != 1 || nodeGParent.getNodeName().compareTo(gparent) != 0 || this.getAttributeValue(nodeGParent, gparentAttribute).compareTo(gparentAttribValue) != 0) continue;
            Node nodeGGParent = nodeGParent.getParentNode();
            if (nodeGParent.getNodeType() != 1 || nodeGGParent.getNodeName().compareTo(ggparent) != 0) continue;
            Node nodeGGGParent = nodeGGParent.getParentNode();
            if (nodeGGParent.getNodeType() != 1 || nodeGGGParent.getNodeName().compareTo(gggparent) != 0) continue;
            String gggparentAttributeValue = this.getAttributeValue(nodeGGGParent, gggparentAttribute);
            String nodeText = this.getNodeText(node);
            if (gggparentAttributeValue == null || nodeText == null) continue;
            Hashtable<String, String> innerTable = (Hashtable<String, String>)allElements.get(gggparentAttributeValue);
            if (innerTable == null) {
                innerTable = new Hashtable<String, String>();
                allElements.put(gggparentAttributeValue, innerTable);
            }
            if (innerTable.get(str = this.getAttributeValue(node, attribute)) == null) {
                innerTable.put(str, nodeText);
                continue;
            }
            System.err.println("WARNING 13: duplicate " + str + " with " + attribute + " = " + nodeText);
        }
        return allElements;
    }

    public Hashtable getTextFromAllElementsWithGGParent(String element, String attribute, String parent, String gparent, String ggparent, String ggparentAttribute) {
        Hashtable allElements = new Hashtable();
        if (element == null || attribute == null || parent == null || gparent == null || ggparent == null || ggparentAttribute == null) {
            return null;
        }
        NodeList nl = this.m_Doc.getElementsByTagName(element);
        for (int i = 0; i < nl.getLength(); ++i) {
            Hashtable elementText = new Hashtable();
            Node node = nl.item(i);
            Node nodeParent = node.getParentNode();
            if (node.getNodeType() != 1 || this.getAttributeValue(node, attribute) == null || nodeParent.getNodeName().compareTo(parent) != 0) continue;
            Node nodeGParent = nodeParent.getParentNode();
            if (nodeParent.getNodeType() != 1 || nodeGParent.getNodeName().compareTo(gparent) != 0) continue;
            Node nodeGGParent = nodeGParent.getParentNode();
            if (nodeGParent.getNodeType() != 1 || nodeGGParent.getNodeName().compareTo(ggparent) != 0) continue;
            String ggparentAttributeValue = this.getAttributeValue(nodeGGParent, ggparentAttribute);
            String nodeText = this.getNodeText(node);
            if (ggparentAttributeValue == null || nodeText == null) continue;
            Hashtable<String, String> innerTable = (Hashtable<String, String>)allElements.get(ggparentAttributeValue);
            if (innerTable == null) {
                innerTable = new Hashtable<String, String>();
                allElements.put(ggparentAttributeValue, innerTable);
            }
            if (innerTable.get(this.getAttributeValue(node, attribute)) == null) {
                innerTable.put(this.getAttributeValue(node, attribute), nodeText);
                continue;
            }
            System.err.println("WARNING 14: duplicate " + attribute);
        }
        return allElements;
    }

    public Hashtable getTextFromAllElementsWithGGParent(String element, String parent, String gparent, String ggparent, String ggparentAttribute) {
        Hashtable<String, String> allElements = new Hashtable<String, String>();
        if (element == null || parent == null || gparent == null || ggparent == null || ggparentAttribute == null) {
            return null;
        }
        NodeList nl = this.m_Doc.getElementsByTagName(element);
        for (int i = 0; i < nl.getLength(); ++i) {
            Hashtable elementText = new Hashtable();
            Node node = nl.item(i);
            Node nodeParent = node.getParentNode();
            if (node.getNodeType() != 1 || nodeParent.getNodeName().compareTo(parent) != 0) continue;
            Node nodeGParent = nodeParent.getParentNode();
            if (nodeParent.getNodeType() != 1 || nodeGParent.getNodeName().compareTo(gparent) != 0) continue;
            Node nodeGGParent = nodeGParent.getParentNode();
            if (nodeGParent.getNodeType() != 1 || nodeGGParent.getNodeName().compareTo(ggparent) != 0) continue;
            String ggparentAttributeValue = this.getAttributeValue(nodeGGParent, ggparentAttribute);
            String nodeText = this.getNodeText(node);
            if (ggparentAttributeValue == null || ggparentAttributeValue.length() <= 0 || nodeText == null) continue;
            String text = (String)allElements.get(ggparentAttributeValue);
            if (text == null) {
                allElements.put(ggparentAttributeValue, nodeText);
                continue;
            }
            System.err.println("WARNING 15: duplicate " + ggparentAttributeValue + " under " + ggparentAttribute);
        }
        return allElements;
    }

    private boolean nodeAttributeValueMatches(Node node, String attribute, String value) {
        boolean matches = false;
        if (node == null) {
            return false;
        }
        NamedNodeMap attrMap = node.getAttributes();
        for (int j = 0; j < attrMap.getLength() && !matches; ++j) {
            Node attrNode = attrMap.item(j);
            String key = attrNode.getNodeName();
            String nodeValue = attrNode.getNodeValue();
            matches = key.compareTo(attribute) == 0 && nodeValue.compareTo(value) == 0;
        }
        return matches;
    }

    private boolean nodeHasAttribute(Node node, String attribute) {
        boolean hasAttribute = false;
        if (node == null) {
            return false;
        }
        NamedNodeMap attrMap = node.getAttributes();
        for (int j = 0; j < attrMap.getLength() && !hasAttribute; ++j) {
            Node attrNode = attrMap.item(j);
            String key = attrNode.getNodeName();
            hasAttribute = key.compareTo(attribute) == 0;
        }
        return hasAttribute;
    }

    private String getAttributeValue(Node node, String attribute) {
        String value = null;
        if (node == null) {
            return null;
        }
        NamedNodeMap attrMap = node.getAttributes();
        for (int j = 0; j < attrMap.getLength() && value == null; ++j) {
            Node attrNode = attrMap.item(j);
            String key = attrNode.getNodeName();
            if (key.compareTo(attribute) != 0) continue;
            value = attrNode.getNodeValue();
        }
        return value;
    }

    private String getNodeText(Node node) {
        String text = null;
        NodeList nlChildren = node.getChildNodes();
        Node textNode = nlChildren.item(0);
        if (textNode != null && textNode.getNodeType() == 3) {
            text = textNode.getNodeValue();
        }
        return text;
    }

    public Hashtable getAttributeFromElementsAndGPAttrib(String parentElement, String element, String elementAttrib, String grandParentAttrib) {
        if (parentElement == null || element == null || elementAttrib == null || grandParentAttrib == null) {
            return null;
        }
        Hashtable<String, String> outer = new Hashtable<String, String>();
        NodeList nl = this.m_Doc.getElementsByTagName(element);
        for (int i = 0; i < nl.getLength(); ++i) {
            String attributeValue = null;
            String gparentAttribValue = null;
            Node node = nl.item(i);
            Node nodeParent = node.getParentNode();
            if (node.getNodeType() != 1 || nodeParent.getNodeName().compareTo(parentElement) != 0) continue;
            attributeValue = this.getAttributeValue(node, elementAttrib);
            Node grandParentNode = nodeParent.getParentNode();
            if (attributeValue == null || grandParentNode == null || (gparentAttribValue = this.getAttributeValue(grandParentNode, grandParentAttrib)) == null) continue;
            if (!outer.containsKey(gparentAttribValue)) {
                outer.put(gparentAttribValue, attributeValue);
                continue;
            }
            System.err.println("WARNING 16: duplicate " + gparentAttribValue + " for " + grandParentAttrib);
        }
        return outer;
    }

    public String getAttributeFromElement(String parentElement, String element, String elementAttrib) {
        if (parentElement == null || element == null || elementAttrib == null) {
            return null;
        }
        String attributeValue = null;
        Hashtable outer = new Hashtable();
        NodeList nl = this.m_Doc.getElementsByTagName(element);
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            Node nodeParent = node.getParentNode();
            if (node.getNodeType() != 1 || nodeParent.getNodeName().compareTo(parentElement) != 0) continue;
            attributeValue = this.getAttributeValue(node, elementAttrib);
        }
        return attributeValue;
    }

    public Vector getAttributesFromElementGroups(String parentElement, String element) {
        Vector allParentGroups = new Vector();
        if (parentElement == null || element == null) {
            return null;
        }
        NodeList nl = this.m_Doc.getElementsByTagName(parentElement);
        for (int i = 0; i < nl.getLength(); ++i) {
            Vector parentGroup = new Vector();
            Node nodeParent = nl.item(i);
            NodeList nlChildren = nodeParent.getChildNodes();
            for (int j = 0; j < nlChildren.getLength(); ++j) {
                Hashtable<String, String> attributes = new Hashtable<String, String>();
                Node node = nlChildren.item(j);
                if (node.getNodeType() == 1 && node.getNodeName().compareTo(element) == 0) {
                    NamedNodeMap attrMap = node.getAttributes();
                    for (int k = 0; k < attrMap.getLength(); ++k) {
                        Node attrNode = attrMap.item(k);
                        String key = attrNode.getNodeName();
                        String value = attrNode.getNodeValue();
                        attributes.put(key, value);
                    }
                }
                if (attributes.size() <= 0) continue;
                parentGroup.add(attributes);
            }
            if (parentGroup.size() <= 0) continue;
            allParentGroups.add(parentGroup);
        }
        return allParentGroups;
    }

    public boolean elementExists(String element) {
        boolean exists = false;
        if (element == null || element.length() == 0) {
            return exists;
        }
        NodeList nl = this.m_Doc.getElementsByTagName(element);
        exists = nl.getLength() > 0;
        return exists;
    }
}

