/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.ooo;

import java.io.PrintStream;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import org.unicode.cldr.ooo.Logging;
import org.unicode.cldr.ooo.XMLWriter;

public class LDMLLocaleWriter
extends XMLWriter {
    protected Vector m_LegacyCurrencies = new Vector();

    public LDMLLocaleWriter(PrintStream out) {
        super(out);
    }

    public LDMLLocaleWriter(PrintStream out, PrintStream err) {
        super(out, err);
    }

    public void open() {
        this.println("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
        String dtd = "<!DOCTYPE ldml SYSTEM \"http://www.unicode.org/cldr/dtd/1.2/ldml.dtd\">";
        this.println(dtd);
        this.println("<ldml>");
        this.indent();
    }

    public boolean open(String namespace, String dtdLocation, String nsDTD, String cldrVersion) {
        this.println("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
        String dtd = "<!DOCTYPE ldml SYSTEM \"";
        dtd = dtdLocation != null && dtdLocation.compareTo("") != 0 ? dtd + dtdLocation + "/ldml.dtd\"" : dtd + "http://www.unicode.org/cldr/dtd/" + cldrVersion + "/ldml.dtd\"";
        dtd = namespace == null || namespace.compareTo("") == 0 ? dtd + ">" : (dtdLocation != null && dtdLocation.compareTo("") != 0 ? dtd + "\n" + "[\n" + "\t<!ENTITY % " + namespace + " SYSTEM \"" + dtdLocation + "/" + nsDTD + "\">\n%" + namespace + ";\n]\n>" : dtd + "\n" + "[\n" + "\t<!ENTITY % " + namespace + " SYSTEM \"http://www.unicode.org/cldr/dtd/" + cldrVersion + "/" + nsDTD + "\">\n%" + namespace + ";\n]\n>");
        this.println(dtd);
        this.println("<ldml>");
        this.indent();
        return true;
    }

    public void close() {
        this.outdent();
        this.println("</ldml>");
    }

    protected void print(String val) {
        if (this.needsIndent) {
            this.out.print(this.indentString);
            this.needsIndent = false;
        }
        this.out.print(val);
    }

    protected void println(String val) {
        this.print(val);
        this.out.println();
        this.lineLength = 0;
        this.needsIndent = true;
    }

    public String getDate() {
        Calendar cal = Calendar.getInstance();
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        int day = cal.get(5);
        String date = year + "/" + month + "/" + day;
        return date;
    }

    public String getTime() {
        Calendar cal = Calendar.getInstance();
        int hour = cal.get(11);
        int min = cal.get(12);
        int sec = cal.get(13);
        String time = hour + ":" + min + ":" + sec;
        return time;
    }

    protected void writeIdentity(Locale locale, String message) {
        if (locale == null) {
            return;
        }
        String lang = locale.getLanguage();
        String terr = locale.getCountry();
        String var = locale.getVariant();
        this.println("<identity>");
        this.indent();
        String version = "$Revision: 1.3 $";
        String msgStr = "";
        if (message != null) {
            msgStr = message;
        }
        String versionStr = "<version number=\"" + version + "\">" + msgStr + "</version>";
        this.println(versionStr);
        String generationStr = "<generation date=\"$Date: 2006/06/19 12:14:00 $\"/>";
        this.println(generationStr);
        String language = "<language type = \"" + lang + "\"/>";
        this.println(language);
        if (terr.compareTo("") != 0) {
            String territory = "<territory type = \"" + terr + "\"/>";
            this.println(territory);
        }
        if (var.compareTo("") != 0) {
            String variant = "<variant type = \"" + var + "\"/>";
            this.println(variant);
        }
        this.outdent();
        this.println("</identity>");
    }

    public void writeIdentity(Hashtable data) {
        String language;
        if (data == null || data.size() == 0) {
            Logging.Log1("No LDML Identity data to write ");
            return;
        }
        String version_number = (String)data.get("version number");
        String generation_info = (String)data.get("generation");
        String language_type = (String)data.get("language type");
        String script_type = (String)data.get("script type");
        String territory_type = (String)data.get("territory type");
        String variant_type = (String)data.get("variant type");
        String platformID = (String)data.get("platformId");
        this.println("<identity>");
        this.indent();
        if (version_number != null) {
            String versionStr = "<version number=\"" + version_number + "\"";
            versionStr = generation_info == null ? versionStr + "/>" : versionStr + ">" + generation_info + "</version>";
            this.println(versionStr);
        }
        String generationStr = "<generation date=\"$Date: 2006/06/19 12:14:00 $\"/>";
        this.println(generationStr);
        if (language_type != null) {
            language = "<language type=\"" + language_type + "\"/>";
            this.println(language);
        }
        if (script_type != null) {
            language = "<script type=\"" + script_type + "\"/>";
            this.println(language);
        }
        if (territory_type != null && territory_type != "") {
            String territory = "<territory type=\"" + territory_type + "\"/>";
            this.println(territory);
        }
        if (variant_type != null) {
            String variant = "<variant type=\"" + variant_type + "\"/>";
            this.println(variant);
        }
        if (platformID != null) {
            this.println("<special xmlns:openOffice=\"http://www.openOffice.org\">");
            this.indent();
            this.printNS("openOffice", "platformId", true);
            this.print(platformID);
            this.printlnNS("openOffice", "platformId", false);
            this.outdent();
            this.println("</special>");
        }
        this.outdent();
        this.println("</identity>");
    }

    protected void writeDayWidth(Hashtable days, String dayWidthType) {
        if (days == null || dayWidthType == null || dayWidthType == "") {
            return;
        }
        String dayWidthString = "<dayWidth type =\"" + dayWidthType + "\">";
        this.println(dayWidthString);
        this.indent();
        String dayStr = null;
        String day = (String)days.get("sun");
        if (day != null) {
            dayStr = "<day type=\"sun\">" + day + "</day>";
            this.println(dayStr);
        }
        if ((day = (String)days.get("mon")) != null) {
            dayStr = "<day type=\"mon\">" + day + "</day>";
            this.println(dayStr);
        }
        if ((day = (String)days.get("tue")) != null) {
            dayStr = "<day type=\"tue\">" + day + "</day>";
            this.println(dayStr);
        }
        if ((day = (String)days.get("wed")) != null) {
            dayStr = "<day type=\"wed\">" + day + "</day>";
            this.println(dayStr);
        }
        if ((day = (String)days.get("thu")) != null) {
            dayStr = "<day type=\"thu\">" + day + "</day>";
            this.println(dayStr);
        }
        if ((day = (String)days.get("fri")) != null) {
            dayStr = "<day type=\"fri\">" + day + "</day>";
            this.println(dayStr);
        }
        if ((day = (String)days.get("sat")) != null) {
            dayStr = "<day type=\"sat\">" + day + "</day>";
            this.println(dayStr);
        }
        this.outdent();
        this.println("</dayWidth>");
    }

    protected void writeMonthWidth(Hashtable months, String monthWidthType) {
        if (months == null || monthWidthType == null || monthWidthType == "") {
            return;
        }
        String monthWidthString = "<monthWidth type =\"" + monthWidthType + "\">";
        this.println(monthWidthString);
        this.indent();
        String monthStr = null;
        String month = (String)months.get("1");
        if (month != null) {
            monthStr = "<month type=\"1\">" + month + "</month>";
            this.println(monthStr);
        }
        if ((month = (String)months.get("2")) != null) {
            monthStr = "<month type=\"2\">" + month + "</month>";
            this.println(monthStr);
        }
        if ((month = (String)months.get("3")) != null) {
            monthStr = "<month type=\"3\">" + month + "</month>";
            this.println(monthStr);
        }
        if ((month = (String)months.get("4")) != null) {
            monthStr = "<month type=\"4\">" + month + "</month>";
            this.println(monthStr);
        }
        if ((month = (String)months.get("5")) != null) {
            monthStr = "<month type=\"5\">" + month + "</month>";
            this.println(monthStr);
        }
        if ((month = (String)months.get("6")) != null) {
            monthStr = "<month type=\"6\">" + month + "</month>";
            this.println(monthStr);
        }
        if ((month = (String)months.get("7")) != null) {
            monthStr = "<month type=\"7\">" + month + "</month>";
            this.println(monthStr);
        }
        if ((month = (String)months.get("8")) != null) {
            monthStr = "<month type=\"8\">" + month + "</month>";
            this.println(monthStr);
        }
        if ((month = (String)months.get("9")) != null) {
            monthStr = "<month type=\"9\">" + month + "</month>";
            this.println(monthStr);
        }
        if ((month = (String)months.get("10")) != null) {
            monthStr = "<month type=\"10\">" + month + "</month>";
            this.println(monthStr);
        }
        if ((month = (String)months.get("11")) != null) {
            monthStr = "<month type=\"11\">" + month + "</month>";
            this.println(monthStr);
        }
        if ((month = (String)months.get("12")) != null) {
            monthStr = "<month type=\"12\">" + month + "</month>";
            this.println(monthStr);
        }
        if ((month = (String)months.get("13")) != null) {
            monthStr = "<month type=\"13\">" + month + "</month>";
            this.println(monthStr);
        }
        this.outdent();
        this.println("</monthWidth>");
    }

    protected void writeQuarterWidth(Hashtable data, String widthType) {
        if (data == null || widthType == null || widthType.compareTo("") == 0) {
            return;
        }
        String widthString = "<quarterWidth type =\"" + widthType + "\">";
        this.println(widthString);
        this.indent();
        String quarterStr = null;
        String quarter = (String)data.get("1");
        if (quarter != null) {
            quarterStr = "<quarter type=\"1\">" + quarter + "</quarter>";
            this.println(quarterStr);
        }
        if ((quarter = (String)data.get("2")) != null) {
            quarterStr = "<quarter type=\"2\">" + quarter + "</quarter>";
            this.println(quarterStr);
        }
        if ((quarter = (String)data.get("3")) != null) {
            quarterStr = "<quarter type=\"3\">" + quarter + "</quarter>";
            this.println(quarterStr);
        }
        if ((quarter = (String)data.get("4")) != null) {
            quarterStr = "<quarter type=\"4\">" + quarter + "</quarter>";
            this.println(quarterStr);
        }
        this.outdent();
        this.println("</quarterWidth>");
    }

    protected void writeEras(Hashtable eras) {
        if (eras == null) {
            return;
        }
        Enumeration enKeys = eras.keys();
        Enumeration enValues = eras.elements();
        while (enKeys.hasMoreElements()) {
            String key = (String)enKeys.nextElement();
            String value = (String)enValues.nextElement();
            if (key == null || value == null) continue;
            String eraStr = "<era type=\"" + key + "\">" + value + "</era>";
            this.println(eraStr);
        }
    }

    protected void writeDelimiterss(Hashtable data) {
        if (data == null) {
            return;
        }
        String quoteStart = (String)data.get("quotationStart");
        String quoteEnd = (String)data.get("quotationEnd");
        String altQuoteStart = (String)data.get("alternateQuotationStart");
        String altQuoteEnd = (String)data.get("alternateQuotationEnd");
        if (quoteStart != null || quoteEnd != null || altQuoteStart != null || altQuoteEnd != null) {
            this.println("<delimiters>");
            this.indent();
            if (quoteStart != null) {
                this.println("<quotationStart>" + quoteStart + "</quotationStart>");
            }
            if (quoteEnd != null) {
                this.println("<quotationEnd>" + quoteEnd + "</quotationEnd>");
            }
            if (altQuoteStart != null) {
                this.println("<alternateQuotationStart>" + altQuoteStart + "</alternateQuotationStart>");
            }
            if (altQuoteEnd != null) {
                this.println("<alternateQuotationEnd>" + altQuoteEnd + "</alternateQuotationEnd>");
            }
            this.outdent();
            this.println("</delimiters>");
        }
    }

    protected void writeMeasurement(Hashtable data) {
        if (data == null) {
            return;
        }
        String measurement = (String)data.get("measurement");
        if (measurement != null) {
            this.println("<measurement>");
            this.indent();
            this.println("<measurementSystem type=\"" + measurement + "\"/>");
            this.outdent();
            this.println("</measurement>");
        }
    }

    protected void writeAlias(Vector alias) {
        if (alias == null || alias.size() == 0) {
            return;
        }
        this.print("<alias source=\"" + alias.elementAt(0) + "\"");
        if (alias.size() > 1) {
            this.println(" type=\"" + alias.elementAt(1) + "\"/>");
        } else {
            this.println("/>");
        }
    }

    protected void writeWeek(String minDays, String firstDay, String weStart, String weEnd, String calendar) {
        if (firstDay != null || minDays != null || weStart != null || weEnd != null) {
            this.println("<week>");
            this.indent();
            if (minDays != null) {
                this.println("<minDays count=\"" + minDays + "\"/>");
            } else {
                Logging.Log3("\tNo minDays to write for calendar : " + calendar);
            }
            if (firstDay != null) {
                this.println("<firstDay day=\"" + firstDay + "\"/>");
            } else {
                Logging.Log3("\tNo firstDay to write for calendar : " + calendar);
            }
            if (weStart != null) {
                this.println("<weekendStart day=\"" + weStart + "\"/>");
            }
            if (weEnd != null) {
                this.println("<weekendEnd day=\"" + weEnd + "\"/>");
            }
            this.outdent();
            this.println("</week>");
        } else {
            Logging.Log3("\tNo week information to write for calendar : " + calendar);
        }
    }

    protected void writeAmPm(String am, String pm, String calendar) {
        if (am != null) {
            this.println("<am>" + am + "</am>");
        } else {
            Logging.Log3("\tNo am to write for calendar : " + calendar);
        }
        if (pm != null) {
            this.println("<pm>" + pm + "</pm>");
        } else {
            Logging.Log3("\tNo pm to write for calendar : " + calendar);
        }
    }

    protected void WriteDateFormatLength(String pattern, String dateFormatLengthType) {
        if (pattern == null || dateFormatLengthType == null) {
            return;
        }
        String dateFormatLengtStr = "<dateFormatLength type = \"" + dateFormatLengthType + "\">";
        this.println(dateFormatLengtStr);
        this.indent();
        this.println("<dateFormat>");
        this.indent();
        this.println("<pattern>" + pattern + "</pattern>");
        this.outdent();
        this.println("</dateFormat>");
        this.outdent();
        this.println("</dateFormatLength>");
    }

    protected void WriteTimeFormatLength(String pattern, String timeFormatLengthType) {
        if (pattern == null || timeFormatLengthType == null) {
            return;
        }
        String timeFormatLengtStr = "<timeFormatLength type = \"" + timeFormatLengthType + "\">";
        this.println(timeFormatLengtStr);
        this.indent();
        this.println("<timeFormat>");
        this.indent();
        this.println("<pattern>" + pattern + "</pattern>");
        this.outdent();
        this.println("</timeFormat>");
        this.outdent();
        this.println("</timeFormatLength>");
    }

    protected void WritePattern(String pattern, String outerEl_o, String outerEl_c, String innerEl_o, String innerEl_c) {
        if (pattern == null || outerEl_o == null || outerEl_c == null || innerEl_o == null || innerEl_c == null) {
            return;
        }
        this.println(outerEl_o);
        this.indent();
        this.println(innerEl_o);
        this.indent();
        this.println("<pattern>" + pattern + "</pattern>");
        this.outdent();
        this.println(innerEl_c);
        this.outdent();
        this.println(outerEl_c);
    }

    protected void writeSymbols(Hashtable data) {
        if (data == null || data.size() == 0) {
            Logging.Log1("No symbols to write to LDML");
            return;
        }
        String decimal = (String)data.get("decimal");
        String group = (String)data.get("group");
        String list = (String)data.get("list");
        String percent = (String)data.get("percentSign");
        String zero = (String)data.get("nativeZeroDigit");
        String pattern = (String)data.get("patternDigit");
        String minus = (String)data.get("minusSign");
        String exp = (String)data.get("exponential");
        String permille = (String)data.get("perMille");
        String infinity = (String)data.get("infinity");
        String nan = (String)data.get("nan");
        this.println("<symbols>");
        this.indent();
        if (decimal != null) {
            this.println("<decimal>" + decimal + "</decimal>");
        }
        if (group != null) {
            this.println("<group>" + group + "</group>");
        }
        if (list != null) {
            this.println("<list>" + list + "</list>");
        }
        if (percent != null) {
            this.println("<percentSign>" + percent + "</percentSign>");
        }
        if (zero != null) {
            this.println("<nativeZeroDigit>" + zero + "</nativeZeroDigit>");
        }
        if (pattern != null) {
            this.println("<patternDigit>" + pattern + "</patternDigit>");
        }
        if (minus != null) {
            this.println("<minusSign>" + minus + "</minusSign>");
        }
        if (exp != null) {
            this.println("<exponential>" + exp + "</exponential>");
        }
        if (permille != null) {
            this.println("<perMille>" + permille + "</perMille>");
        }
        if (infinity != null) {
            this.println("<infinity>" + infinity + "</infinity>");
        }
        if (nan != null) {
            this.println("<nan>" + nan + "</nan>");
        }
        this.outdent();
        this.println("</symbols>");
    }

    protected void writeCurrency(Hashtable data) {
        if (data == null) {
            return;
        }
        String type = (String)data.get("type");
        String symbol = (String)data.get("symbol");
        String decimal = (String)data.get("decimal");
        String psttern = (String)data.get("pattern");
        if (type != null) {
            this.println("<currency type=\"" + type + "\">");
        } else {
            this.println("<currency>");
        }
        this.indent();
        if (psttern != null) {
            this.println("<pattern>" + psttern + "</pattern>");
        }
        if (symbol != null) {
            this.println("<symbol>" + symbol + "</symbol>");
        }
        if (decimal != null) {
            this.println("<decimal>" + decimal + "</decimal>");
        }
        this.outdent();
        this.println("</currency>");
    }

    protected String[] cast(Object dataObject) {
        String[] retStr = null;
        if (dataObject == null) {
            return retStr;
        }
        if (dataObject instanceof String) {
            retStr = new String[]{(String)dataObject};
        } else if (dataObject instanceof String[]) {
            retStr = (String[])dataObject;
        } else if (dataObject instanceof String[][]) {
            int iLen = ((String[][])dataObject).length;
            retStr = new String[iLen];
            for (int i = 0; i < iLen; ++i) {
                retStr[i] = ((String[][])dataObject)[i][1];
            }
        }
        return retStr;
    }

    protected void printNS(String namespace, String element, boolean isOpen) {
        if (namespace == null || element == null) {
            return;
        }
        String start = "<";
        if (!isOpen) {
            start = start + "/";
        }
        this.print(start + namespace + ":" + element + ">");
    }

    protected void printlnNS(String namespace, String element, boolean isOpen) {
        if (namespace == null || element == null) {
            return;
        }
        String start = "<";
        if (!isOpen) {
            start = start + "/";
        }
        this.println(start + namespace + ":" + element + ">");
    }

    protected void printNS(String namespace, String element, Hashtable attribs, boolean bIsOpen, boolean bHasSubElementsOrData, boolean bNewLine) {
        if (namespace == null || element == null || attribs == null) {
            return;
        }
        String start = "<";
        if (!bIsOpen) {
            start = start + "/";
        }
        String str = "";
        Enumeration keys = attribs.keys();
        Enumeration data = attribs.elements();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String datum = (String)data.nextElement();
            str = str + " " + namespace + ":" + key + "=\"" + datum + "\"";
        }
        str = !bHasSubElementsOrData ? str + "/>" : str + ">";
        if (bNewLine) {
            this.println(start + namespace + ":" + element + str);
        } else {
            this.print(start + namespace + ":" + element + str);
        }
    }

    protected void printSpecial(String namespace, String www, Hashtable attribs, boolean bHasSubElementsOrData, boolean bNewLine) {
        if (namespace == null || www == null || attribs == null) {
            return;
        }
        String start = "<special xmlns:" + namespace + "=\"" + www + "\"";
        String str = "";
        Enumeration keys = attribs.keys();
        Enumeration data = attribs.elements();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String datum = (String)data.nextElement();
            str = str + " " + namespace + ":" + key + "=\"" + datum + "\"";
        }
        str = !bHasSubElementsOrData ? str + "/>" : str + ">";
        if (bNewLine) {
            this.println(start + str);
        } else {
            this.print(start + str);
        }
    }

    protected void print(String element, Hashtable attribs, boolean bIsOpen, boolean bHasSubElementsOrData, boolean bNewLine) {
        if (element == null || attribs == null) {
            return;
        }
        String start = "<";
        if (!bIsOpen) {
            start = start + "/";
        }
        String str = "";
        Enumeration keys = attribs.keys();
        Enumeration data = attribs.elements();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String datum = (String)data.nextElement();
            str = str + " " + key + "=\"" + datum + "\"";
        }
        str = !bHasSubElementsOrData ? str + "/>" : str + ">";
        if (bNewLine) {
            this.println(start + element + str);
        } else {
            this.print(start + element + str);
        }
    }

    protected void getLegacyCurrencies() {
        this.m_LegacyCurrencies.add("ATS");
        this.m_LegacyCurrencies.add("BEF");
        this.m_LegacyCurrencies.add("FIM");
        this.m_LegacyCurrencies.add("FRF");
        this.m_LegacyCurrencies.add("DEM");
        this.m_LegacyCurrencies.add("GRD");
        this.m_LegacyCurrencies.add("IEP");
        this.m_LegacyCurrencies.add("ITL");
        this.m_LegacyCurrencies.add("LUF");
        this.m_LegacyCurrencies.add("NLG");
        this.m_LegacyCurrencies.add("PTE");
        this.m_LegacyCurrencies.add("ESP");
    }

    protected String escapeXML(String inData) {
        if (inData == null) {
            return null;
        }
        String outData = inData.replaceAll("&", "&amp;");
        outData = outData.replaceAll("<", "&lt;");
        outData = outData.replaceAll(">", "&gt;");
        outData = outData.replaceAll("'", "&apos;");
        outData = outData.replaceAll("\"", "&quot;");
        return outData;
    }
}

