/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.ooo;

import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.TreeSet;
import java.util.Vector;
import org.unicode.cldr.ooo.XMLWriter;
import org.unicode.cldr.ooo.supplementalData;

public class OOLocaleWriter
extends XMLWriter {
    private Hashtable m_Aliases;
    private boolean m_bTemplate = false;

    public OOLocaleWriter(PrintStream out, boolean bTemplate) {
        super(out);
        this.m_bTemplate = bTemplate;
    }

    public OOLocaleWriter(PrintStream out, PrintStream err) {
        super(out, err);
    }

    protected void indent() {
        this.indent(1);
    }

    protected void outdent() {
        this.outdent(1);
    }

    public void open(Hashtable localeInfo) {
        this.println("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
        String dtd = "<!DOCTYPE Locale SYSTEM 'locale.dtd'>";
        this.println(dtd);
        this.println("<!-- Some data is generated from the Common Locale Data Repository (www.unicode.org/cldr) -->");
        StringBuffer localeStrBuff = new StringBuffer("<Locale");
        String str = (String)localeInfo.get("versionDTD");
        if (str != null) {
            localeStrBuff.append(" versionDTD=\"" + str + "\"");
        }
        String string = str = !this.m_bTemplate ? (String)localeInfo.get("allowUpdateFromCLDR") : "yes|no";
        if (str != null) {
            localeStrBuff.append(" allowUpdateFromCLDR=\"" + str + "\"");
        }
        String string2 = str = !this.m_bTemplate ? (String)localeInfo.get("version") : "<NA>";
        if (str != null) {
            localeStrBuff.append(" version=\"" + str + "\"");
        }
        localeStrBuff.append(">");
        this.println(localeStrBuff.toString());
        this.indent();
    }

    public void close() {
        this.outdent();
        this.println("</Locale>");
    }

    protected void print(String val) {
        if (this.needsIndent) {
            this.out.print(this.indentString);
            this.needsIndent = false;
        }
        this.out.print(val);
    }

    protected void println(String val) {
        this.print(val);
        this.out.println();
        this.lineLength = 0;
        this.needsIndent = true;
    }

    public void setAliases(Hashtable aliases) {
        if (aliases != null) {
            this.m_Aliases = aliases;
        }
    }

    public void writeLC_INFO(Hashtable data) {
        String variant;
        String platformID;
        String country;
        String language;
        this.println("<LC_INFO>");
        this.indent();
        this.println("<Language>");
        this.indent();
        String langID = (String)data.get("LangID");
        this.println("<LangID>" + langID + "</" + "LangID" + ">");
        String string = language = !this.m_bTemplate ? (String)data.get("Language") : "<NA>";
        if (language != null) {
            this.println("<DefaultName>" + language + "</" + "DefaultName" + ">");
        }
        this.outdent();
        this.println("</Language>");
        this.println("<Country>");
        this.indent();
        String countryID = (String)data.get("CountryID");
        if (countryID != null) {
            this.println("<CountryID>" + countryID + "</" + "CountryID" + ">");
        } else {
            this.println("<CountryID/>");
        }
        String string2 = country = !this.m_bTemplate ? (String)data.get("Country") : "<NA>";
        if (country != null) {
            this.println("<DefaultName>" + country + "</" + "DefaultName" + ">");
        } else {
            this.println("<DefaultName/>");
        }
        this.outdent();
        this.println("</Country>");
        String string3 = platformID = !this.m_bTemplate ? (String)data.get("PlatformID") : "<NA?>";
        if (platformID != null) {
            this.println("<Platform>");
            this.indent();
            this.println("<PlatformID>" + platformID + "</" + "PlatformID" + ">");
            this.outdent();
            this.println("</Platform>");
        }
        String string4 = variant = !this.m_bTemplate ? (String)data.get("Variant") : "<NA?>";
        if (variant != null) {
            this.println("<Variant>" + variant + "</" + "Variant" + ">");
        }
        this.outdent();
        this.println("</LC_INFO>");
    }

    public void writeLC_CTYPE(Hashtable data) {
        String measurementSystem;
        String timePM;
        String timeAM;
        Hashtable Markers;
        if (data == null || data.size() < 1) {
            return;
        }
        this.println("<LC_CTYPE>");
        this.indent();
        Hashtable Separators = (Hashtable)data.get("Separators");
        if (Separators != null && Separators.size() > 0) {
            String longDateYearSeparator;
            String longDateMonthSeparator;
            String longDateDaySeparator;
            String longDateDayOfWeekSeparator;
            String time100SecSeparator;
            String timeSeparator;
            String dateSeparator;
            this.println("<Separators>");
            this.indent();
            String string = dateSeparator = !this.m_bTemplate ? (String)Separators.get("DateSeparator") : "<NA>";
            if (dateSeparator != null && dateSeparator.length() > 0) {
                this.println("<DateSeparator>" + dateSeparator + "</" + "DateSeparator" + ">");
            } else {
                this.println("<DateSeparator/>");
            }
            String thousandSeparator = (String)Separators.get("ThousandSeparator");
            if (thousandSeparator != null && thousandSeparator.length() > 0) {
                this.println("<ThousandSeparator>" + thousandSeparator + "</" + "ThousandSeparator" + ">");
            } else {
                this.println("<ThousandSeparator/>");
            }
            String decimalSeparator = (String)Separators.get("DecimalSeparator");
            if (decimalSeparator != null && decimalSeparator.length() > 0) {
                this.println("<DecimalSeparator>" + decimalSeparator + "</" + "DecimalSeparator" + ">");
            } else {
                this.println("<DecimalSeparator/>");
            }
            String string2 = timeSeparator = !this.m_bTemplate ? (String)Separators.get("TimeSeparator") : "<NA>";
            if (timeSeparator != null && timeSeparator.length() > 0) {
                this.println("<TimeSeparator>" + timeSeparator + "</" + "TimeSeparator" + ">");
            } else {
                this.println("<TimeSeparator/>");
            }
            String string3 = time100SecSeparator = !this.m_bTemplate ? (String)Separators.get("Time100SecSeparator") : "<NA>";
            if (time100SecSeparator != null && time100SecSeparator.length() > 0) {
                this.println("<Time100SecSeparator>" + time100SecSeparator + "</" + "Time100SecSeparator" + ">");
            } else {
                this.println("<Time100SecSeparator/>");
            }
            String listSeparator = (String)Separators.get("ListSeparator");
            if (listSeparator != null && listSeparator.length() > 0) {
                this.println("<ListSeparator>" + listSeparator + "</" + "ListSeparator" + ">");
            } else {
                this.println("<ListSeparator/>");
            }
            String string4 = longDateDayOfWeekSeparator = !this.m_bTemplate ? (String)Separators.get("LongDateDayOfWeekSeparator") : "<NA>";
            if (longDateDayOfWeekSeparator != null && longDateDayOfWeekSeparator.length() > 0) {
                this.println("<LongDateDayOfWeekSeparator>" + longDateDayOfWeekSeparator + "</" + "LongDateDayOfWeekSeparator" + ">");
            } else {
                this.println("<LongDateDayOfWeekSeparator/>");
            }
            String string5 = longDateDaySeparator = !this.m_bTemplate ? (String)Separators.get("LongDateDaySeparator") : "<NA>";
            if (longDateDaySeparator != null && longDateDaySeparator.length() > 0) {
                this.println("<LongDateDaySeparator>" + longDateDaySeparator + "</" + "LongDateDaySeparator" + ">");
            } else {
                this.println("<LongDateDaySeparator/>");
            }
            String string6 = longDateMonthSeparator = !this.m_bTemplate ? (String)Separators.get("LongDateMonthSeparator") : "<NA>";
            if (longDateMonthSeparator != null && longDateMonthSeparator.length() > 0) {
                this.println("<LongDateMonthSeparator>" + longDateMonthSeparator + "</" + "LongDateMonthSeparator" + ">");
            } else {
                this.println("<LongDateMonthSeparator/>");
            }
            String string7 = longDateYearSeparator = !this.m_bTemplate ? (String)Separators.get("LongDateYearSeparator") : "<NA>";
            if (longDateYearSeparator != null && longDateYearSeparator.length() > 0) {
                this.println("<LongDateYearSeparator>" + longDateYearSeparator + "</" + "LongDateYearSeparator" + ">");
            } else {
                this.println("<LongDateYearSeparator/>");
            }
            this.outdent();
            this.println("</Separators>");
        }
        if ((Markers = (Hashtable)data.get("Markers")) != null && Markers.size() > 0) {
            String doubleQuotationEnd;
            String doubleQuotationStart;
            String quotationEnd;
            this.println("<Markers>");
            this.indent();
            String quotationStart = (String)Markers.get("QuotationStart");
            if (quotationStart != null && quotationStart.length() > 0) {
                this.println("<QuotationStart>" + quotationStart + "</" + "QuotationStart" + ">");
            }
            if ((quotationEnd = (String)Markers.get("QuotationEnd")) != null && quotationEnd.length() > 0) {
                this.println("<QuotationEnd>" + quotationEnd + "</" + "QuotationEnd" + ">");
            }
            if ((doubleQuotationStart = (String)Markers.get("DoubleQuotationStart")) != null && doubleQuotationStart.length() > 0) {
                this.println("<DoubleQuotationStart>" + doubleQuotationStart + "</" + "DoubleQuotationStart" + ">");
            }
            if ((doubleQuotationEnd = (String)Markers.get("DoubleQuotationEnd")) != null && doubleQuotationEnd.length() > 0) {
                this.println("<DoubleQuotationEnd>" + doubleQuotationEnd + "</" + "DoubleQuotationEnd" + ">");
            }
            this.outdent();
            this.println("</Markers>");
        }
        if ((timeAM = (String)data.get("TimeAM")) != null && timeAM.length() > 0) {
            this.println("<TimeAM>" + timeAM + "</" + "TimeAM" + ">");
        }
        if ((timePM = (String)data.get("TimePM")) != null && timePM.length() > 0) {
            this.println("<TimePM>" + timePM + "</" + "TimePM" + ">");
        }
        if ((measurementSystem = (String)data.get("MeasurementSystem")) != null && measurementSystem.length() > 0) {
            this.println("<MeasurementSystem>" + measurementSystem + "</" + "MeasurementSystem" + ">");
        }
        this.outdent();
        this.println("</LC_CTYPE>");
    }

    public boolean writeLC_FORMATRef(String replaceFrom, String replaceTo, String ref) {
        StringBuffer lcFormat = new StringBuffer("<LC_FORMAT");
        if (ref != null) {
            lcFormat.append(" ref=\"" + ref + "\"");
        }
        if (replaceFrom != null) {
            lcFormat.append(" replaceFrom=\"" + replaceFrom + "\"");
        }
        if (replaceTo != null) {
            lcFormat.append(" replaceTo=\"" + replaceTo + "\"");
        }
        lcFormat.append("/>");
        this.println(lcFormat.toString());
        return true;
    }

    public boolean writeLC_FORMAT(Hashtable inFormatElements, Hashtable inFormatCodes, Hashtable inFormatDefaultNames, boolean inHasOpened, String replaceFrom, String replaceTo) {
        boolean m_hasOpened = inHasOpened;
        if (inFormatElements == null || inFormatCodes == null) {
            return m_hasOpened;
        }
        if (!m_hasOpened) {
            StringBuffer lcFormat = new StringBuffer("<LC_FORMAT");
            if (replaceFrom != null && replaceTo != null) {
                lcFormat.append(" replaceFrom=\"" + replaceFrom + "\" " + "replaceTo" + "=\"" + replaceTo + "\"");
            }
            lcFormat.append(">");
            this.println(lcFormat.toString());
            this.indent();
            m_hasOpened = true;
        }
        String defaultKey = null;
        String type = null;
        String usage = null;
        String formatIndex = null;
        String formatCode = null;
        String defaultName = null;
        TreeSet<String> fi_values = new TreeSet<String>();
        Enumeration data = inFormatElements.elements();
        while (data.hasMoreElements()) {
            Hashtable elements = (Hashtable)data.nextElement();
            formatIndex = (String)elements.get("formatindex");
            fi_values.add(formatIndex);
        }
        Object[] fi = fi_values.toArray();
        for (int i = 0; i < fi.length; ++i) {
            Enumeration keys = inFormatElements.keys();
            while (keys.hasMoreElements()) {
                Hashtable elementAttribs;
                String key = (String)keys.nextElement();
                if (key == null || key.length() <= 0 || (elementAttribs = (Hashtable)inFormatElements.get(key)) == null || elementAttribs.size() <= 0 || (formatIndex = (String)elementAttribs.get("formatindex")).compareTo((String)fi[i]) != 0) continue;
                StringBuffer formatLine = new StringBuffer("<FormatElement msgid=\"" + key + "\"");
                defaultKey = (String)elementAttribs.get("default");
                if (defaultKey != null && defaultKey.length() > 0) {
                    formatLine.append(" default=\"" + defaultKey + "\"");
                }
                if ((type = (String)elementAttribs.get("type")) != null && type.length() > 0) {
                    formatLine.append(" type=\"" + type + "\"");
                }
                if ((usage = (String)elementAttribs.get("usage")) != null && usage.length() > 0) {
                    formatLine.append(" usage=\"" + usage + "\"");
                }
                if (formatIndex != null && formatIndex.length() > 0) {
                    formatLine.append(" formatindex=\"" + formatIndex + "\"");
                }
                defaultName = (String)inFormatDefaultNames.get(key);
                formatLine.append(">");
                this.println(formatLine.toString());
                this.indent();
                formatCode = (String)inFormatCodes.get(key);
                if (formatCode != null && formatCode.length() > 0) {
                    this.println("<FormatCode>" + formatCode + "</" + "FormatCode" + ">");
                }
                if (defaultName != null && defaultName.length() > 0) {
                    this.println("<DefaultName>" + defaultName + "</" + "DefaultName" + ">");
                }
                this.outdent();
                this.println("</FormatElement>");
            }
        }
        return m_hasOpened;
    }

    public void writeCloseLC_FORMAT(boolean hasOpened) {
        if (hasOpened) {
            this.outdent();
            this.println("</LC_FORMAT>");
        }
    }

    public void writeLC_COLLATION(Hashtable data, String ref) {
        boolean noSubElems = false;
        StringBuffer lcCollation = new StringBuffer("<LC_COLLATION");
        if (ref != null && ref.length() > 0) {
            lcCollation.append(" ref=\"" + ref + "\"");
        }
        Vector collators = (Vector)data.get("Collator");
        Vector collationOptions = (Vector)data.get("CollationOptions");
        if (collators == null && collationOptions == null) {
            lcCollation.append(" />");
            noSubElems = true;
        } else {
            lcCollation.append(">");
        }
        this.println(lcCollation.toString());
        if (noSubElems) {
            return;
        }
        this.indent();
        Enumeration collatorKeys = collators.elements();
        while (collatorKeys.hasMoreElements()) {
            Hashtable collator = (Hashtable)collatorKeys.nextElement();
            if (collator == null || collator.size() <= 0) continue;
            StringBuffer collStr = new StringBuffer("<Collator");
            Enumeration collKeys = collator.keys();
            while (collKeys.hasMoreElements()) {
                String key = (String)collKeys.nextElement();
                String value = (String)collator.get(key);
                if (key == null || key.length() <= 0 || value == null) continue;
                collStr.append(" " + key + "=\"" + value + "\"");
            }
            collStr.append(" />");
            this.println(collStr.toString());
        }
        Enumeration collationOptsKeys = collationOptions.elements();
        while (collationOptsKeys.hasMoreElements()) {
            String transliterationModule = (String)collationOptsKeys.nextElement();
            if (transliterationModule == null || transliterationModule.length() <= 0) continue;
            this.println("<CollationOptions>");
            this.indent();
            this.println("<TransliterationModules>" + transliterationModule + "</" + "TransliterationModules" + ">");
            this.outdent();
            this.println("</CollationOptions>");
        }
        this.outdent();
        this.println("</LC_COLLATION>");
    }

    public void writeLC_SEARCH(Vector searchOptions, String ref) {
        boolean noSubElems = false;
        if (ref != null && ref.length() > 0) {
            this.println("<LC_SEARCH ref=\"" + ref + "\"/>");
        } else if (searchOptions != null && searchOptions.size() > 0) {
            this.println("<LC_SEARCH>");
            this.indent();
            this.println("<SearchOptions>");
            this.indent();
            Enumeration searchKeys = searchOptions.elements();
            while (searchKeys.hasMoreElements()) {
                String transliterationModule = (String)searchKeys.nextElement();
                if (transliterationModule == null || transliterationModule.length() <= 0) continue;
                this.println("<TransliterationModules>" + transliterationModule + "</" + "TransliterationModules" + ">");
            }
            this.outdent();
            this.println("</SearchOptions>");
            this.outdent();
            this.println("</LC_SEARCH>");
        }
    }

    public void writeLC_INDEX(Hashtable indexData, String ref) {
        if (ref != null && ref.length() > 0) {
            this.println("<LC_INDEX ref=\"" + ref + "\"/>");
        } else if (indexData != null && indexData.size() > 0) {
            Vector followWordPages;
            Vector unicodeScripts;
            this.println("<LC_INDEX>");
            this.indent();
            Vector indexKeys = (Vector)indexData.get("IndexKey");
            if (indexKeys != null && indexKeys.size() > 0) {
                Enumeration indexkeysEnum = indexKeys.elements();
                while (indexkeysEnum.hasMoreElements()) {
                    Hashtable indexKey = (Hashtable)indexkeysEnum.nextElement();
                    if (indexKey == null || indexKey.size() <= 0) continue;
                    String indexkeyText = (String)indexKey.get("innerText");
                    Hashtable attributes = (Hashtable)indexKey.get("attributes");
                    StringBuffer indexkeyStr = new StringBuffer("<IndexKey");
                    Enumeration attributeKeys = attributes.keys();
                    while (attributeKeys.hasMoreElements()) {
                        String key = (String)attributeKeys.nextElement();
                        String value = (String)attributes.get(key);
                        if (key == null || key.length() <= 0 || value == null) continue;
                        indexkeyStr.append(" " + key + "=\"" + value + "\"");
                    }
                    if (indexkeyText != null && indexkeyText.length() > 0) {
                        indexkeyStr.append(">" + indexkeyText + "</" + "IndexKey" + ">");
                    } else {
                        indexkeyStr.append(" />");
                    }
                    this.println(indexkeyStr.toString());
                }
            }
            if ((unicodeScripts = (Vector)indexData.get("UnicodeScript")) != null && unicodeScripts.size() > 0) {
                Enumeration usEnum = unicodeScripts.elements();
                while (usEnum.hasMoreElements()) {
                    String us = (String)usEnum.nextElement();
                    if (us == null || us.length() <= 0) continue;
                    this.println("<UnicodeScript>" + us + "</" + "UnicodeScript" + ">");
                }
            }
            if ((followWordPages = (Vector)indexData.get("FollowPageWord")) != null && followWordPages.size() > 0) {
                Enumeration fwpEnum = followWordPages.elements();
                while (fwpEnum.hasMoreElements()) {
                    String fwp = (String)fwpEnum.nextElement();
                    if (fwp == null || fwp.length() <= 0) continue;
                    this.println("<FollowPageWord>" + fwp + "</" + "FollowPageWord" + ">");
                }
            }
            this.outdent();
            this.println("</LC_INDEX>");
        }
    }

    public void writeLC_CALENDAR(Hashtable data) {
        if (data == null || data.size() == 0) {
            return;
        }
        this.println("<LC_CALENDAR>");
        this.indent();
        Vector calendarTypes = (Vector)data.get("unoid");
        if (calendarTypes != null && calendarTypes.size() > 0) {
            String defaultCal = (String)data.get("default");
            Enumeration calEnum = calendarTypes.elements();
            while (calEnum.hasMoreElements()) {
                String calendarType;
                Hashtable calendar = (Hashtable)calEnum.nextElement();
                if (calendar == null || (calendarType = (String)calendar.get("unoid")) == null || calendarType.length() <= 0) continue;
                StringBuffer calTag = new StringBuffer("<Calendar unoid=\"" + calendarType + "\"");
                if (defaultCal != null && defaultCal.compareTo(calendarType) == 0) {
                    calTag.append(" default=\"true\"");
                } else {
                    calTag.append(" default=\"false\"");
                }
                calTag.append(">");
                this.println(calTag.toString());
                this.indent();
                this.writeDays(data, calendarType);
                this.writeMonths(data, calendarType);
                this.writeEras(data, calendarType);
                this.writeStartOfWeek(data, calendarType);
                this.writeMinDays(data, calendarType);
                this.outdent();
                this.println("</Calendar>");
            }
        }
        this.outdent();
        this.println("</LC_CALENDAR>");
    }

    private void writeDays(Hashtable data, String unoid) {
        Hashtable daysAbbr = (Hashtable)data.get("DaysOfWeek.DefaultAbbrvName");
        Hashtable daysFull = (Hashtable)data.get("DaysOfWeek.DefaultFullName");
        if (daysAbbr != null && daysAbbr.size() > 0 || daysFull != null && daysFull.size() > 0) {
            Hashtable daysAbbrvUnoid = null;
            Hashtable daysFullUnoid = null;
            if (daysAbbr != null) {
                daysAbbrvUnoid = (Hashtable)daysAbbr.get(unoid);
            }
            if (daysFull != null) {
                daysFullUnoid = (Hashtable)daysFull.get(unoid);
            }
            if (daysAbbrvUnoid == null) {
                daysAbbrvUnoid = (Hashtable)daysAbbr.get("gregorian");
            }
            if (daysFullUnoid == null) {
                daysFullUnoid = (Hashtable)daysFull.get("gregorian");
            }
            if (daysAbbrvUnoid != null && daysAbbrvUnoid.size() > 0 || daysFullUnoid != null && daysFullUnoid.size() > 0) {
                this.println("<DaysOfWeek>");
                this.indent();
                this.writeDay("sun", daysAbbrvUnoid, daysFullUnoid);
                this.writeDay("mon", daysAbbrvUnoid, daysFullUnoid);
                this.writeDay("tue", daysAbbrvUnoid, daysFullUnoid);
                this.writeDay("wed", daysAbbrvUnoid, daysFullUnoid);
                this.writeDay("thu", daysAbbrvUnoid, daysFullUnoid);
                this.writeDay("fri", daysAbbrvUnoid, daysFullUnoid);
                this.writeDay("sat", daysAbbrvUnoid, daysFullUnoid);
                this.outdent();
                this.println("</DaysOfWeek>");
            }
        }
    }

    private void writeDay(String ooDay, Hashtable daysAbbr, Hashtable daysFull) {
        String dayID = ooDay;
        String abbrvDay = null;
        String fullDay = null;
        if (daysAbbr != null) {
            abbrvDay = (String)daysAbbr.get(dayID);
        }
        if (daysFull != null) {
            fullDay = (String)daysFull.get(dayID);
        }
        if (abbrvDay != null || fullDay != null) {
            this.println("<Day>");
            this.indent();
            this.println("<DayID>" + dayID + "</" + "DayID" + ">");
            if (abbrvDay != null) {
                this.println("<DefaultAbbrvName>" + abbrvDay + "</" + "DefaultAbbrvName" + ">");
            }
            if (fullDay != null) {
                this.println("<DefaultFullName>" + fullDay + "</" + "DefaultFullName" + ">");
            }
            this.outdent();
            this.println("</Day>");
        }
    }

    private void writeMonths(Hashtable data, String unoid) {
        Hashtable monthsAbbr = (Hashtable)data.get("MonthsOfYear.DefaultAbbrvName");
        Hashtable monthsFull = (Hashtable)data.get("MonthsOfYear.DefaultFullName");
        if (monthsAbbr != null && monthsAbbr.size() > 0 || monthsFull != null && monthsFull.size() > 0) {
            Hashtable monthsAbbrvUnoid = null;
            Hashtable monthsFullUnoid = null;
            if (monthsAbbr != null) {
                monthsAbbrvUnoid = (Hashtable)monthsAbbr.get(unoid);
            }
            if (monthsFull != null) {
                monthsFullUnoid = (Hashtable)monthsFull.get(unoid);
            }
            if (monthsAbbrvUnoid == null) {
                monthsAbbrvUnoid = (Hashtable)monthsAbbr.get("gregorian");
            }
            if (monthsFullUnoid == null) {
                monthsFullUnoid = (Hashtable)monthsFull.get("gregorian");
            }
            if (monthsAbbrvUnoid != null && monthsAbbrvUnoid.size() > 0 || monthsFullUnoid != null && monthsFullUnoid.size() > 0) {
                this.println("<MonthsOfYear>");
                this.indent();
                String m1 = "jan";
                String m2 = "feb";
                String m3 = "mar";
                String m4 = "apr";
                String m5 = "may";
                String m6 = "jun";
                String m7 = "jul";
                String m8 = "aug";
                String m9 = "sep";
                String m10 = "oct";
                String m11 = "nov";
                String m12 = "dec";
                String m13 = "";
                if (unoid.compareTo("jewish") == 0) {
                    m1 = "Nissan";
                    m2 = "Iyar";
                    m3 = "Sivan";
                    m4 = "Tammuz";
                    m5 = "Av";
                    m6 = "Elul";
                    m7 = "Tishri";
                    m8 = "Heshvan";
                    m9 = "Kislev";
                    m10 = "Tevet";
                    m11 = "Shevat";
                    m12 = "Adar";
                    m13 = "ve-Adar";
                }
                this.writeMonth(m1, monthsAbbrvUnoid, monthsFullUnoid);
                this.writeMonth(m2, monthsAbbrvUnoid, monthsFullUnoid);
                this.writeMonth(m3, monthsAbbrvUnoid, monthsFullUnoid);
                this.writeMonth(m4, monthsAbbrvUnoid, monthsFullUnoid);
                this.writeMonth(m5, monthsAbbrvUnoid, monthsFullUnoid);
                this.writeMonth(m6, monthsAbbrvUnoid, monthsFullUnoid);
                this.writeMonth(m7, monthsAbbrvUnoid, monthsFullUnoid);
                this.writeMonth(m8, monthsAbbrvUnoid, monthsFullUnoid);
                this.writeMonth(m9, monthsAbbrvUnoid, monthsFullUnoid);
                this.writeMonth(m10, monthsAbbrvUnoid, monthsFullUnoid);
                this.writeMonth(m11, monthsAbbrvUnoid, monthsFullUnoid);
                this.writeMonth(m12, monthsAbbrvUnoid, monthsFullUnoid);
                if (unoid.compareTo("jewish") == 0) {
                    this.writeMonth(m13, monthsAbbrvUnoid, monthsFullUnoid);
                }
                this.outdent();
                this.println("</MonthsOfYear>");
            }
        }
    }

    private void writeMonth(String ooMonth, Hashtable monthsAbbr, Hashtable monthsFull) {
        String monthID = ooMonth;
        String abbrvMonth = null;
        String fullMonth = null;
        if (monthsAbbr != null) {
            abbrvMonth = (String)monthsAbbr.get(monthID);
        }
        if (monthsFull != null) {
            fullMonth = (String)monthsFull.get(monthID);
        }
        if (abbrvMonth != null || fullMonth != null) {
            this.println("<Month>");
            this.indent();
            this.println("<MonthID>" + monthID + "</" + "MonthID" + ">");
            if (abbrvMonth != null) {
                this.println("<DefaultAbbrvName>" + abbrvMonth + "</" + "DefaultAbbrvName" + ">");
            }
            if (fullMonth != null) {
                this.println("<DefaultFullName>" + fullMonth + "</" + "DefaultFullName" + ">");
            }
            this.outdent();
            this.println("</Month>");
        }
    }

    private void writeEras(Hashtable data, String unoid) {
        if (data == null || data.size() == 0) {
            return;
        }
        Hashtable erasCollection = (Hashtable)data.get("Eras");
        if (erasCollection == null) {
            return;
        }
        Hashtable calendarEra = (Hashtable)erasCollection.get(unoid);
        if (calendarEra == null || calendarEra.size() == 0) {
            return;
        }
        this.println("<Eras>");
        this.indent();
        if (unoid.compareTo("gregorian") == 0) {
            this.writeSingleEra(calendarEra, "bc");
            this.writeSingleEra(calendarEra, "ad");
        } else if (unoid.compareTo("ROC") == 0) {
            this.writeSingleEra(calendarEra, "before");
            this.writeSingleEra(calendarEra, "MINGUO");
        } else if (unoid.compareTo("hijri") == 0) {
            this.writeSingleEra(calendarEra, "BeforeHijra");
            this.writeSingleEra(calendarEra, "AfterHijra");
        } else if (unoid.compareTo("jewish") == 0) {
            this.writeSingleEra(calendarEra, "before");
            this.writeSingleEra(calendarEra, "after");
        } else if (unoid.compareTo("buddhist") == 0) {
            this.writeSingleEra(calendarEra, "before");
            this.writeSingleEra(calendarEra, "after");
        } else if (unoid.compareTo("hanja") == 0) {
            this.writeSingleEra(calendarEra, "bc");
            this.writeSingleEra(calendarEra, "ad");
        } else if (unoid.compareTo("gengou") == 0) {
            this.writeSingleEra(calendarEra, "Dummy");
            this.writeSingleEra(calendarEra, "Meiji");
            this.writeSingleEra(calendarEra, "Taisho");
            this.writeSingleEra(calendarEra, "Showa");
            this.writeSingleEra(calendarEra, "Heisei");
        }
        this.outdent();
        this.println("</Eras>");
    }

    private void writeSingleEra(Hashtable calendarEra, String eraID) {
        Hashtable eraNames = (Hashtable)calendarEra.get(eraID);
        if (eraNames == null) {
            return;
        }
        String abbr = (String)eraNames.get("DefaultAbbrvName");
        String name = (String)eraNames.get("DefaultFullName");
        this.println("<Era>");
        this.indent();
        this.println("<EraID>" + eraID + "</" + "EraID" + ">");
        if (abbr != null) {
            this.println("<DefaultAbbrvName>" + abbr + "</" + "DefaultAbbrvName" + ">");
        } else {
            this.println("<DefaultAbbrvName/>");
        }
        if (name != null) {
            this.println("<DefaultFullName>" + name + "</" + "DefaultFullName" + ">");
        } else {
            this.println("<DefaultFullName/>");
        }
        this.outdent();
        this.println("</Era>");
    }

    private void writeStartOfWeek(Hashtable data, String calendarType) {
        if (data == null) {
            return;
        }
        Hashtable startOfWeeks = (Hashtable)data.get("StartDayOfWeek");
        if (startOfWeeks == null) {
            return;
        }
        String startOfWeek = (String)startOfWeeks.get(calendarType);
        if (startOfWeek == null) {
            startOfWeek = (String)startOfWeeks.get("gregorian");
        }
        if (startOfWeek != null) {
            this.println("<StartDayOfWeek>");
            this.indent();
            this.println("<DayID>" + startOfWeek + "</" + "DayID" + ">");
            this.outdent();
            this.println("</StartDayOfWeek>");
        }
    }

    public void writeMinDays(Hashtable data, String calendarType) {
        if (data == null) {
            return;
        }
        Hashtable minDaysTable = (Hashtable)data.get("MinimalDaysInFirstWeek");
        if (minDaysTable == null) {
            this.println("<MinimalDaysInFirstWeek/>");
            return;
        }
        String minDays = (String)minDaysTable.get(calendarType);
        if (minDays == null) {
            minDays = (String)minDaysTable.get("gregorian");
        }
        if (minDays != null) {
            this.println("<MinimalDaysInFirstWeek>" + minDays + "</" + "MinimalDaysInFirstWeek" + ">");
        } else {
            this.println("<MinimalDaysInFirstWeek/>");
        }
    }

    public void WriteLC_CURRENCY(Vector currencyData_cldr, Vector currencyData_ooo, supplementalData suppData, boolean bRoundTrip, String territory) {
        if (currencyData_cldr == null && currencyData_ooo == null || currencyData_cldr.size() == 0 && currencyData_ooo.size() == 0) {
            return;
        }
        Vector validCurrs = suppData.getCurrencies(territory);
        this.println("<LC_CURRENCY>");
        this.indent();
        if (this.m_bTemplate) {
            Vector inner_cldr = (Vector)currencyData_cldr.elementAt(0);
            String code = (String)inner_cldr.elementAt(2);
            String symbol = (String)inner_cldr.elementAt(1);
            String name = (String)inner_cldr.elementAt(3);
            String def = " default=\"true\"";
            String uicfc = " usedInCompatibleFormatCodes=\"true|false\"";
            this.println("<Currency" + def + uicfc + ">");
            this.indent();
            this.println("<CurrencyID>" + code + "</" + "CurrencyID" + ">");
            this.println("<CurrencySymbol>" + symbol + "</" + "CurrencySymbol" + ">");
            this.println("<BankSymbol>" + code + "</" + "BankSymbol" + ">");
            this.println("<CurrencyName>" + name + "</" + "CurrencyName" + ">");
            String digits = Integer.toString(suppData.getDigits(code));
            this.println("<DecimalPlaces>" + digits + "</" + "DecimalPlaces" + ">");
            this.outdent();
            this.println("</Currency>");
        } else {
            for (int i = 0; i < currencyData_ooo.size(); ++i) {
                Vector inner_ooo = (Vector)currencyData_ooo.elementAt(i);
                String code = (String)inner_ooo.elementAt(2);
                String deflt = (String)inner_ooo.elementAt(5);
                String symbol = (String)inner_ooo.elementAt(1);
                String name = (String)inner_ooo.elementAt(3);
                if (deflt.equals("true") && !bRoundTrip) {
                    for (int j = 0; j < currencyData_cldr.size(); ++j) {
                        Vector inner_cldr = (Vector)currencyData_cldr.elementAt(j);
                        if (!inner_cldr.elementAt(2).equals(code)) continue;
                        symbol = (String)inner_cldr.elementAt(1);
                        symbol = this.extractSymbolFromChoice(symbol);
                        name = (String)inner_cldr.elementAt(3);
                        break;
                    }
                }
                String def = " default=\"" + deflt + "\"";
                String uicfc = " usedInCompatibleFormatCodes=\"" + (String)inner_ooo.elementAt(6) + "\"";
                String legacy = "";
                if (inner_ooo.size() > 7) {
                    legacy = " legacyOnly=\"" + (String)inner_ooo.elementAt(7) + "\"";
                }
                this.println("<Currency" + def + uicfc + legacy + ">");
                this.indent();
                this.println("<CurrencyID>" + (String)inner_ooo.elementAt(0) + "</" + "CurrencyID" + ">");
                this.println("<CurrencySymbol>" + symbol + "</" + "CurrencySymbol" + ">");
                this.println("<BankSymbol>" + code + "</" + "BankSymbol" + ">");
                this.println("<CurrencyName>" + name + "</" + "CurrencyName" + ">");
                String digits = Integer.toString(suppData.getDigits(code));
                this.println("<DecimalPlaces>" + digits + "</" + "DecimalPlaces" + ">");
                this.outdent();
                this.println("</Currency>");
            }
        }
        this.outdent();
        this.println("</LC_CURRENCY>");
    }

    public void WriteLC_TRANSLITERATIONS(Vector transliterations, String ref) {
        if (ref != null && ref.length() > 0) {
            this.println("<LC_TRANSLITERATION ref=\"" + ref + "\"/>");
        } else if (transliterations != null && transliterations.size() != 0) {
            this.println("<LC_TRANSLITERATION>");
            this.indent();
            Enumeration transEnum = transliterations.elements();
            while (transEnum.hasMoreElements()) {
                String transliteration = (String)transEnum.nextElement();
                if (transliteration == null || transliteration.length() <= 0) continue;
                this.println("<Transliteration unoid=\"" + transliteration + "\"" + "/>");
            }
            this.outdent();
            this.println("</LC_TRANSLITERATION>");
        }
    }

    public void WriteLC_MISC(Hashtable data, String ref) {
        if (ref != null && ref.length() > 0) {
            this.println("<LC_MISC ref=\"" + ref + "\"/>");
        } else if (data != null && data.size() != 0) {
            Hashtable resWords;
            this.println("<LC_MISC>");
            this.indent();
            String forbiddenLineBeg = (String)data.get("ForbiddenLineBeginCharacters");
            String forbiddenLineEnd = (String)data.get("ForbiddenLineEndCharacters");
            if (forbiddenLineBeg != null && forbiddenLineBeg.length() > 0 || forbiddenLineEnd != null && forbiddenLineEnd.length() > 0 || this.m_bTemplate) {
                String fle;
                String flb;
                this.println("<ForbiddenCharacters>");
                this.indent();
                String string = flb = !this.m_bTemplate ? this.escapeXML(forbiddenLineBeg) : "<NA?>";
                if (flb != null && flb.length() > 0) {
                    this.println("<ForbiddenLineBeginCharacters>" + flb + "</" + "ForbiddenLineBeginCharacters" + ">");
                }
                String string2 = fle = !this.m_bTemplate ? this.escapeXML(forbiddenLineEnd) : "<NA?>";
                if (fle != null && fle.length() > 0) {
                    this.println("<ForbiddenLineEndCharacters>" + fle + "</" + "ForbiddenLineEndCharacters" + ">");
                }
                this.outdent();
                this.println("</ForbiddenCharacters>");
            }
            if ((resWords = (Hashtable)data.get("ReservedWords")) != null && resWords.size() > 0) {
                this.println("<ReservedWords>");
                this.indent();
                this.writeReservedWord(resWords, "trueWord");
                this.writeReservedWord(resWords, "falseWord");
                this.writeReservedWord(resWords, "quarter1Word");
                this.writeReservedWord(resWords, "quarter2Word");
                this.writeReservedWord(resWords, "quarter3Word");
                this.writeReservedWord(resWords, "quarter4Word");
                this.writeReservedWord(resWords, "aboveWord");
                this.writeReservedWord(resWords, "belowWord");
                this.writeReservedWord(resWords, "quarter1Abbreviation");
                this.writeReservedWord(resWords, "quarter2Abbreviation");
                this.writeReservedWord(resWords, "quarter3Abbreviation");
                this.writeReservedWord(resWords, "quarter4Abbreviation");
                this.outdent();
                this.println("</ReservedWords>");
            }
            this.outdent();
            this.println("</LC_MISC>");
        }
    }

    private void writeReservedWord(Hashtable reservedWords, String ooKey) {
        String reservedWord = (String)reservedWords.get(ooKey);
        if (reservedWord == null && this.m_bTemplate) {
            reservedWord = "<NA>";
        }
        if (reservedWord != null && reservedWord.length() > 0) {
            this.println("<" + ooKey + ">" + reservedWord + "</" + ooKey + ">");
        }
    }

    public void WriteLC_NumberingLevel(Vector numberingLevelAtts, String ref) {
        if (ref != null && ref.length() > 0) {
            this.println("<LC_NumberingLevel ref=\"" + ref + "\"/>");
        } else if (numberingLevelAtts != null && numberingLevelAtts.size() != 0) {
            this.println("<LC_NumberingLevel>");
            this.indent();
            Enumeration numEnum = numberingLevelAtts.elements();
            while (numEnum.hasMoreElements()) {
                StringBuffer elem = new StringBuffer("<NumberingLevel");
                Hashtable atts = (Hashtable)numEnum.nextElement();
                if (atts != null) {
                    Enumeration keys = atts.keys();
                    while (keys.hasMoreElements()) {
                        String key = (String)keys.nextElement();
                        String value = (String)atts.get(key);
                        if (value == null || value.length() <= 0) continue;
                        elem.append(" " + key + "=\"" + value + "\"");
                    }
                }
                elem.append("/>");
                this.println(elem.toString());
            }
            this.outdent();
            this.println("</LC_NumberingLevel>");
        }
    }

    public void WriteLC_OutlineNumberingLevel(Vector outlineNumberingLevels, String ref) {
        if (ref != null && ref.length() > 0) {
            this.println("<LC_OutLineNumberingLevel ref=\"" + ref + "\"/>");
        } else if (outlineNumberingLevels != null && outlineNumberingLevels.size() != 0) {
            this.println("<LC_OutLineNumberingLevel>");
            this.indent();
            Enumeration parentsEnum = outlineNumberingLevels.elements();
            while (parentsEnum.hasMoreElements()) {
                Vector styleGroup = (Vector)parentsEnum.nextElement();
                if (styleGroup == null || styleGroup.size() <= 0) continue;
                this.println("<OutlineStyle>");
                this.indent();
                Enumeration elemsEnum = styleGroup.elements();
                while (elemsEnum.hasMoreElements()) {
                    this.write_outlineNumberingLevel((Hashtable)elemsEnum.nextElement());
                }
                this.outdent();
                this.println("</OutlineStyle>");
            }
            this.outdent();
            this.println("</LC_OutLineNumberingLevel>");
        }
    }

    private void write_outlineNumberingLevel(Hashtable attributes) {
        if (attributes == null || attributes.size() == 0) {
            return;
        }
        StringBuffer elem = new StringBuffer("<OutLineNumberingLevel");
        this.appentOutlineNumberingLevelAtt(attributes, elem, "Prefix");
        this.appentOutlineNumberingLevelAtt(attributes, elem, "NumType");
        this.appentOutlineNumberingLevelAtt(attributes, elem, "Suffix");
        this.appentOutlineNumberingLevelAtt(attributes, elem, "BulletChar");
        this.appentOutlineNumberingLevelAtt(attributes, elem, "BulletFontName");
        this.appentOutlineNumberingLevelAtt(attributes, elem, "ParentNumbering");
        this.appentOutlineNumberingLevelAtt(attributes, elem, "LeftMargin");
        this.appentOutlineNumberingLevelAtt(attributes, elem, "SymbolTextDistance");
        this.appentOutlineNumberingLevelAtt(attributes, elem, "FirstLineOffset");
        this.appentOutlineNumberingLevelAtt(attributes, elem, "Transliteration");
        this.appentOutlineNumberingLevelAtt(attributes, elem, "NatNum");
        elem.append("/>");
        this.println(elem.toString());
    }

    private void appentOutlineNumberingLevelAtt(Hashtable attributes, StringBuffer str, String ooConstant) {
        String val = (String)attributes.get(ooConstant);
        if (val != null) {
            str.append(" " + ooConstant + "=\"" + val + "\"");
        }
    }

    protected String escapeXML(String inData) {
        if (inData == null) {
            return null;
        }
        String outData = inData.replaceAll("&", "&amp;");
        outData = outData.replaceAll("<", "&lt;");
        outData = outData.replaceAll(">", "&gt;");
        outData = outData.replaceAll("'", "&apos;");
        outData = outData.replaceAll("\"", "&quot;");
        return outData;
    }

    protected String extractSymbolFromChoice(String currString) {
        if (currString.indexOf("|") >= 0) {
            String[] choices = currString.split("\\u007c");
            for (int i = choices.length - 1; i >= 0; --i) {
                Float ten;
                String[] numvalue = choices[i].split("[<\\u2264]", 2);
                Float num = Float.valueOf(numvalue[0]);
                if (num.compareTo(ten = new Float(10.0f)) > 0 && i != 0) continue;
                currString = numvalue[1];
                i = 0;
            }
        }
        return currString;
    }

    protected String getDataString(Hashtable data, String id, boolean bTemplate, boolean bMandatory) {
        String str = (String)data.get(id);
        if (bTemplate) {
            str = "<NA>";
        }
        if (str == null && bMandatory) {
            str = "";
        }
        return str;
    }

    public void writeLC_FORMAT_template() {
        this.println("<LC_FORMAT replaceFrom=\"<NA?>\" replaceTo=\"<NA?>\">");
        this.indent();
        for (int i = 0; i <= 47; ++i) {
            if (i == 10 || i == 11) continue;
            String msgid = "";
            String usage = "";
            int start = 0;
            if (i <= 5) {
                start = 0;
                msgid = "Fixed";
                usage = "FIXED_NUMBER";
            } else if (i >= 6 && i <= 7) {
                start = 6;
                msgid = "Scientific";
                usage = "SCIENTIFIC_NUMBER";
            } else if (i >= 8 && i <= 9) {
                start = 8;
                msgid = "Percent";
                usage = "PERCENT_NUMBER";
            } else if (i >= 12 && i <= 17) {
                start = 12;
                msgid = "Currency";
                usage = "CURRENCY";
            } else if (i >= 18 && i <= 38) {
                start = 18;
                msgid = "Date";
                usage = "DATE";
            } else if (i >= 39 && i <= 45) {
                start = 39;
                msgid = "Time";
                usage = "TIME";
            } else if (i >= 46 && i <= 47) {
                start = 46;
                msgid = "DateTime";
                usage = "DATE_TIME";
            }
            msgid = msgid.equals("Date") ? msgid + "Formatskey" + "1-21" : msgid + "Formatskey" + Integer.toString(i - start + 1);
            String fi = Integer.toString(i);
            this.println("<FormatElement msgid=\"" + msgid + "\"" + " " + "default" + "=\"" + "true|false" + "\"" + " " + "type" + "=\"" + "long|medium|short" + "\"" + " " + "usage" + "=\"" + usage + "\"" + " " + "formatindex" + "=\"" + fi + "\">");
            this.indent();
            this.println("<FormatCode><NA></FormatCode>");
            this.println("<DefaultName><NA?></DefaultName>");
            this.outdent();
            this.println("</FormatElement>");
        }
        this.println("</LC_FORMAT>");
    }

    public void writeLC_COLLATION_template() {
        this.println("<LC_COLLATION>");
        this.indent();
        this.println("<Collator default=\"true|false\" unoid=\"<NA>\"/>");
        this.println("<CollationOptions>");
        this.indent();
        this.println("<TransliterationModules><NA></TransliterationModules>");
        this.outdent();
        this.println("</CollationOptions>");
        this.outdent();
        this.println("</LC_COLLATION>");
    }

    public void writeLC_SEARCH_template() {
        this.println("<LC_SEARCH>");
        this.indent();
        this.println("<SearchOptions>");
        this.indent();
        this.println("<TransliterationModules><NA></TransliterationModules>");
        this.outdent();
        this.println("</SearchOptions>");
        this.outdent();
        this.println("</LC_SEARCH>");
    }

    public void writeLC_INDEX_template() {
        int i;
        this.println("<LC_INDEX>");
        this.indent();
        this.println("<IndexKey default=\"true|false\" phonetic=\"true|false\" unoid=\"<NA>\"><NA></IndexKey>");
        for (i = 0; i < 2; ++i) {
            this.println("<UnicodeScript><NA></UnicodeScript>");
        }
        for (i = 0; i < 2; ++i) {
            this.println("<FollowPageWord><NA></FollowPageWord>");
        }
        this.outdent();
        this.println("</LC_INDEX>");
    }

    public void writeLC_TRANSLITERATIONS_template() {
        String tr = "UPPERCASE_LOWERCASE|LOWERCASE_UPPERCASE|IGNORE_CASE";
        this.println("<LC_TRANSLITERATION>");
        this.indent();
        for (int i = 0; i < 3; ++i) {
            this.println("<Transliteration unoid=\"" + tr + "\"/>");
        }
        this.outdent();
        this.println("</LC_TRANSLITERATION>");
    }

    public void writeLC_NumberingLevel_template() {
        this.println("<LC_NumberingLevel>");
        this.indent();
        for (int i = 0; i < 8; ++i) {
            this.println("<NumberingLevel NumType=\"<NA>\" Prefix=\"<NA>\" Suffix=\"<NA>\"/>");
        }
        this.outdent();
        this.println("</LC_NumberingLevel>");
    }

    public void writeLC_OutlineNumberingLevel_template() {
        this.println("<LC_OutLineNumberingLevel>");
        this.indent();
        for (int i = 0; i < 8; ++i) {
            this.println("<OutlineStyle>");
            this.indent();
            for (int j = 0; j < 8; ++j) {
                this.println("<OutLineNumberingLevel Prefix=\"<NA>\" NumType=\"<NA>\" Suffix=\"<NA>\" BulletChar=\"<NA>\" BulletFontName=\"<NA>\" ParentNumbering=\"<NA>\" LeftMargin=\"<NA>\" SymbolTextDistance=\"<NA>\" FirstLineOffset=\"<NA>\"/>");
            }
            this.outdent();
            this.println("</OutlineStyle>");
        }
        this.outdent();
        this.println("</LC_OutLineNumberingLevel>");
    }
}

