/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.test;

import com.ibm.icu.dev.test.util.ElapsedTimer;
import com.ibm.icu.dev.test.util.TransliteratorUtilities;
import com.ibm.icu.dev.tool.UOption;
import com.ibm.icu.impl.CollectionUtilities;
import com.ibm.icu.text.MessageFormat;
import com.ibm.icu.text.Transliterator;
import com.ibm.icu.text.UnicodeSet;
import java.io.BufferedReader;
import java.io.IOException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.test.CheckAlt;
import org.unicode.cldr.test.CheckAttributeValues;
import org.unicode.cldr.test.CheckCoverage;
import org.unicode.cldr.test.CheckCurrencies;
import org.unicode.cldr.test.CheckDates;
import org.unicode.cldr.test.CheckDisplayCollisions;
import org.unicode.cldr.test.CheckExemplars;
import org.unicode.cldr.test.CheckForExemplars;
import org.unicode.cldr.test.CheckNew;
import org.unicode.cldr.test.CheckNumbers;
import org.unicode.cldr.test.CheckZones;
import org.unicode.cldr.test.CoverageLevel;
import org.unicode.cldr.test.FlexibleDateFromCLDR;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.Counter;
import org.unicode.cldr.util.LocaleIDParser;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.Utility;

public abstract class CheckCLDR {
    private CLDRFile cldrFileToCheck;
    private CLDRFile resolvedCldrFileToCheck;
    private static CLDRFile displayInformation;
    static boolean SHOW_LOCALE;
    static boolean SHOW_EXAMPLES;
    public static boolean SHOW_TIMES;
    public static boolean showStackTrace;
    public static boolean errorsOnly;
    public static String finalErrorType;
    private static final int HELP1 = 0;
    private static final int HELP2 = 1;
    private static final int COVERAGE = 2;
    private static final int EXAMPLES = 3;
    private static final int FILE_FILTER = 4;
    private static final int TEST_FILTER = 5;
    private static final int DATE_FORMATS = 6;
    private static final int ORGANIZATION = 7;
    private static final int SHOWALL = 8;
    private static final int PRETTY = 9;
    private static final int ERRORS_ONLY = 10;
    private static final UOption[] options;
    private static String[] HelpMessage;
    static Transliterator prettyPath;

    public static CompoundCheckCLDR getCheckAll(String nameMatcher) {
        return new CompoundCheckCLDR().setFilter(Pattern.compile(nameMatcher, 2).matcher("")).add(new CheckAttributeValues()).add(new CheckCoverage()).add(new CheckDates()).add(new CheckDisplayCollisions()).add(new CheckExemplars()).add(new CheckForExemplars()).add(new CheckNew()).add(new CheckNumbers()).add(new CheckZones()).add(new CheckAlt()).add(new CheckCurrencies());
    }

    public static CLDRFile getDisplayInformation() {
        return displayInformation;
    }

    public static void setDisplayInformation(CLDRFile displayInformation) {
        CheckCLDR.displayInformation = displayInformation;
    }

    public static void main(String[] args) throws IOException {
        StandardCodes sc;
        Map foo;
        String organization;
        double deltaTime = System.currentTimeMillis();
        UOption.parseArgs((String[])args, (UOption[])options);
        if (CheckCLDR.options[0].doesOccur || CheckCLDR.options[1].doesOccur) {
            for (int i = 0; i < HelpMessage.length; ++i) {
                System.out.println(HelpMessage[i]);
            }
            return;
        }
        String factoryFilter = CheckCLDR.options[4].value;
        String checkFilter = CheckCLDR.options[5].value;
        errorsOnly = CheckCLDR.options[10].doesOccur;
        if (errorsOnly) {
            finalErrorType = "Warning";
        }
        SHOW_EXAMPLES = CheckCLDR.options[3].doesOccur;
        boolean showAll = CheckCLDR.options[8].doesOccur;
        boolean checkFlexibleDates = CheckCLDR.options[6].doesOccur;
        boolean pretty = CheckCLDR.options[9].doesOccur;
        CoverageLevel.Level coverageLevel = null;
        String coverageLevelInput = CheckCLDR.options[2].value;
        if (coverageLevelInput != null) {
            coverageLevel = CoverageLevel.Level.get(coverageLevelInput);
        }
        if ((organization = CheckCLDR.options[7].value) != null && !(foo = (sc = StandardCodes.make()).getLocaleTypes()).keySet().contains(organization)) {
            throw new IllegalArgumentException("-o" + organization + "\t is invalid: must be one of: " + foo.keySet());
        }
        System.out.println("factoryFilter: " + factoryFilter);
        System.out.println("test filter: " + checkFilter);
        System.out.println("organization: " + organization);
        System.out.println("show examples: " + SHOW_EXAMPLES);
        System.out.println("coverage level: " + coverageLevel);
        System.out.println("checking dates: " + checkFlexibleDates);
        System.out.println("show all: " + showAll);
        System.out.println("errors only?: " + errorsOnly);
        CLDRFile.Factory cldrFactory = CLDRFile.Factory.make("../../common/main/", factoryFilter);
        CompoundCheckCLDR checkCldr = CheckCLDR.getCheckAll(checkFilter);
        CheckCLDR.setDisplayInformation(cldrFactory.make("en", true));
        PathShower pathShower = new PathShower();
        Set locales = cldrFactory.getAvailable();
        ArrayList result = new ArrayList();
        TreeSet paths = new TreeSet(CLDRFile.ldmlComparator);
        TreeMap m = new TreeMap();
        HashMap<String, String> options = new HashMap<String, String>();
        Counter totalCount = new Counter();
        Counter subtotalCount = new Counter();
        FlexibleDateFromCLDR fset = new FlexibleDateFromCLDR();
        Iterator it = locales.iterator();
        while (it.hasNext()) {
            String localeID = (String)it.next();
            if (CLDRFile.isSupplementalName(localeID)) continue;
            if (SHOW_LOCALE) {
                System.out.println("Locale:\t" + CheckCLDR.getLocaleAndName(localeID) + "\t");
            }
            boolean isLanguageLocale = localeID.equals(new LocaleIDParser().set(localeID).getLanguageScript());
            options.clear();
            if (!isLanguageLocale) {
                options.put("CheckCoverage.skip", "true");
            }
            if (coverageLevel != null) {
                options.put("CheckCoverage.requiredLevel", coverageLevel.toString());
            }
            if (organization != null) {
                options.put("CoverageLevel.localeType", organization);
            }
            options.put("submission", "true");
            CLDRFile file = cldrFactory.make(localeID, isLanguageLocale);
            ((CheckCLDR)checkCldr).setCldrFileToCheck(file, options, result);
            subtotalCount.clear();
            Iterator it3 = result.iterator();
            while (it3.hasNext()) {
                CheckStatus status = (CheckStatus)it3.next();
                String statusString = status.toString();
                String statusType = status.getType();
                if (errorsOnly) {
                    if (!statusType.equals("Error")) continue;
                }
                System.out.print("Locale:\t" + CheckCLDR.getLocaleAndName(localeID) + "\t");
                System.out.println(statusString);
                subtotalCount.add(status.type, 1L);
            }
            paths.clear();
            CollectionUtilities.addAll((Iterator)file.iterator(), paths);
            UnicodeSet missingExemplars = new UnicodeSet();
            if (checkFlexibleDates) {
                fset.set(file);
            }
            pathShower.set(localeID);
            if (pretty) {
                String prettyString;
                System.out.println("Showing Pretty Paths");
                TreeMap<String, String> prettyMap = new TreeMap<String, String>();
                TreeSet<String> prettySet = new TreeSet<String>();
                Iterator it2 = paths.iterator();
                while (it2.hasNext()) {
                    Object old;
                    String path = (String)it2.next();
                    prettyString = prettyPath.transliterate(path);
                    if (prettyString.indexOf("%%") >= 0) {
                        prettyString = "unmatched/" + prettyString;
                    }
                    if ((old = prettyMap.get(prettyString)) != null) {
                        System.out.println("Collision with: ");
                        System.out.println("\t" + prettyString);
                        System.out.println("\t\t" + path);
                        System.out.println("\t\t" + old);
                    }
                    prettyMap.put(prettyString, path);
                    String cleanPath = prettyString;
                    int last = prettyString.lastIndexOf(124);
                    if (last >= 0) {
                        cleanPath = cleanPath.substring(0, last);
                    }
                    prettySet.add(cleanPath);
                    System.out.println(prettyString + " => " + path);
                }
                System.out.println("Showing Structure");
                String oldSplit = pathShower.getSplitChar();
                pathShower.setSplitChar("\\|");
                Iterator<Object> it22 = prettyMap.keySet().iterator();
                while (it22.hasNext()) {
                    prettyString = (String)it22.next();
                    String path = (String)prettyMap.get(prettyString);
                    pathShower.showHeader(prettyString, file.getStringValue(path));
                }
                System.out.println("Showing Non-Leaves");
                pathShower.setSplitChar(oldSplit);
                it22 = prettySet.iterator();
                while (it22.hasNext()) {
                    prettyString = (String)it22.next();
                    System.out.println(prettyString);
                }
                System.out.println("Done Showing Pretty Paths");
                return;
            }
            Iterator it2 = paths.iterator();
            while (it2.hasNext()) {
                String path = (String)it2.next();
                String value = file.getStringValue(path);
                String fullPath = file.getFullXPath(path);
                if (checkFlexibleDates) {
                    fset.checkFlexibles(path, value, fullPath);
                }
                int limit = 1;
                if (SHOW_EXAMPLES) {
                    limit = 2;
                }
                for (int jj = 0; jj < limit; ++jj) {
                    if (jj == 0) {
                        checkCldr.check(path, fullPath, value, options, result);
                    } else {
                        checkCldr.getExamples(path, fullPath, value, options, result);
                    }
                    if (showAll) {
                        pathShower.showHeader(path, value);
                    }
                    Iterator it32 = result.iterator();
                    while (it32.hasNext()) {
                        CheckStatus status = (CheckStatus)it32.next();
                        String statusString = status.toString();
                        String statusType = status.getType();
                        if (errorsOnly) {
                            if (!statusType.equals("Error")) continue;
                        }
                        pathShower.showHeader(path, value);
                        if (statusType.equals("Demo")) {
                            SimpleDemo d = status.getDemo();
                            if (d == null || !(d instanceof FormatDemo)) continue;
                            FormatDemo fd = (FormatDemo)d;
                            m.clear();
                            if (!d.processPost(m)) continue;
                            System.out.println("\tDemo:\t" + fd.getPlainText(m));
                            continue;
                        }
                        System.out.println("\t" + statusString);
                        subtotalCount.add(status.type, 1L);
                        totalCount.add(status.type, 1L);
                        Object[] parameters = status.getParameters();
                        if (parameters == null) continue;
                        for (int i = 0; i < parameters.length; ++i) {
                            if (showStackTrace && parameters[i] instanceof Throwable) {
                                ((Throwable)parameters[i]).printStackTrace();
                            }
                            if (!status.getMessage().startsWith("Not in exemplars")) continue;
                            missingExemplars.addAll(new UnicodeSet(parameters[i].toString()));
                        }
                    }
                }
            }
            if (missingExemplars.size() != 0) {
                System.out.print("Locale:\t" + CheckCLDR.getLocaleAndName(localeID) + "\t");
                System.out.println("Total missing:\t" + missingExemplars);
            }
            it2 = new TreeSet(subtotalCount.keySet()).iterator();
            while (it2.hasNext()) {
                String type = (String)it2.next();
                System.out.println("Locale:\t" + CheckCLDR.getLocaleAndName(localeID) + "\tSubtotal " + type + ":\t" + subtotalCount.getCount(type));
            }
            if (!checkFlexibleDates) continue;
            fset.showFlexibles();
        }
        Iterator it2 = new TreeSet(totalCount.keySet()).iterator();
        while (it2.hasNext()) {
            String type = (String)it2.next();
            System.out.println("Total " + type + ":\t" + totalCount.getCount(type));
        }
        deltaTime = (double)System.currentTimeMillis() - deltaTime;
        System.out.println("Elapsed: " + deltaTime / 1000.0 + " seconds");
    }

    public final CLDRFile getCldrFileToCheck() {
        return this.cldrFileToCheck;
    }

    public final CLDRFile getResolvedCldrFileToCheck() {
        if (this.resolvedCldrFileToCheck == null) {
            this.resolvedCldrFileToCheck = this.cldrFileToCheck.getResolved();
        }
        return this.resolvedCldrFileToCheck;
    }

    public CheckCLDR setCldrFileToCheck(CLDRFile cldrFileToCheck, Map options, List possibleErrors) {
        this.cldrFileToCheck = cldrFileToCheck;
        this.resolvedCldrFileToCheck = null;
        return this;
    }

    public final CheckCLDR check(String path, String fullPath, String value, Map options, List result) {
        if (this.cldrFileToCheck == null) {
            throw new InternalError("CheckCLDR problem: cldrFileToCheck must not be null");
        }
        if (path == null) {
            throw new InternalError("CheckCLDR problem: path must not be null");
        }
        if (fullPath == null) {
            throw new InternalError("CheckCLDR problem: fullPath must not be null");
        }
        if (value == null) {
            throw new InternalError("CheckCLDR problem: value must not be null");
        }
        result.clear();
        return this.handleCheck(path, fullPath, value, options, result);
    }

    public final CheckCLDR getExamples(String path, String fullPath, String value, Map options, List result) {
        result.clear();
        return this.handleGetExamples(path, fullPath, value, options, result);
    }

    protected CheckCLDR handleGetExamples(String path, String fullPath, String value, Map options2, List result) {
        return this;
    }

    public abstract CheckCLDR handleCheck(String var1, String var2, String var3, Map var4, List var5);

    public static String getLocaleAndName(String locale) {
        String localizedName = displayInformation.getName(locale, false);
        if (localizedName == null || localizedName.equals(locale)) {
            return locale;
        }
        return locale + " [" + localizedName + "]";
    }

    public static Transliterator getTransliteratorFromFile(String ID, String file) {
        try {
            String line;
            BufferedReader br = Utility.getUTF8Data("prettyPath.txt");
            StringBuffer input = new StringBuffer();
            while ((line = br.readLine()) != null) {
                if (line.startsWith("\ufeff")) {
                    line = line.substring(1);
                }
                input.append(line);
                input.append('\n');
            }
            return Transliterator.createFromRules((String)ID, (String)input.toString(), (int)0);
        }
        catch (IOException e) {
            return null;
        }
    }

    static {
        SHOW_LOCALE = true;
        SHOW_EXAMPLES = false;
        SHOW_TIMES = false;
        showStackTrace = false;
        errorsOnly = false;
        finalErrorType = "Error";
        options = new UOption[]{UOption.HELP_H(), UOption.HELP_QUESTION_MARK(), UOption.create((String)"coverage", (char)'c', (int)1), UOption.create((String)"examples", (char)'x', (int)0), UOption.create((String)"file_filter", (char)'f', (int)1).setDefault(".*"), UOption.create((String)"test_filter", (char)'t', (int)1).setDefault(".*"), UOption.create((String)"date_formats", (char)'d', (int)0), UOption.create((String)"organization", (char)'o', (int)1), UOption.create((String)"showall", (char)'s', (int)0), UOption.create((String)"pretty", (char)'p', (int)0), UOption.create((String)"errors_only", (char)'e', (int)0)};
        HelpMessage = new String[]{"-h \t This message", "-f xxx \t Pick the locales (files) to check: xxx is a regular expression, eg -f fr, or -f fr.*, or -f (fr|en-.*)", "-c xxx \t Set the coverage: eg -c comprehensive or -c modern or -c moderate or -c basic", "-t xxx \t Filter the Checks: xxx is a regular expression, eg -t.*number.*", "-o xxx \t Organization (for coverage tests): ibm, google, ....", "-x \t Turn on examples (actually a summary of the demo)", "-d \t Turn on special date format checks", "-s \t Show all paths", "-e \t Show errors only"};
        prettyPath = CheckCLDR.getTransliteratorFromFile("ID", "prettyPath.txt");
    }

    static class CompoundCheckCLDR
    extends CheckCLDR {
        private Matcher filter;
        private List checkList = new ArrayList();
        private List filteredCheckList = new ArrayList();

        CompoundCheckCLDR() {
        }

        public CompoundCheckCLDR add(CheckCLDR item) {
            this.checkList.add(item);
            if (this.filter == null || this.filter.reset(item.getClass().getName()).matches()) {
                this.filteredCheckList.add(item);
            }
            return this;
        }

        public CheckCLDR handleCheck(String path, String fullPath, String value, Map options, List result) {
            result.clear();
            Iterator it = this.filteredCheckList.iterator();
            while (it.hasNext()) {
                CheckCLDR item = (CheckCLDR)it.next();
                try {
                    item.handleCheck(path, fullPath, value, options, result);
                }
                catch (Exception e) {
                    this.addError(result, item, e);
                    return this;
                }
            }
            return this;
        }

        protected CheckCLDR handleGetExamples(String path, String fullPath, String value, Map options, List result) {
            result.clear();
            Iterator it = this.filteredCheckList.iterator();
            while (it.hasNext()) {
                CheckCLDR item = (CheckCLDR)it.next();
                try {
                    item.handleGetExamples(path, fullPath, value, options, result);
                }
                catch (Exception e) {
                    this.addError(result, item, e);
                    return this;
                }
            }
            return this;
        }

        private void addError(List result, CheckCLDR item, Exception e) {
            result.add(new CheckStatus().setType("Error").setMessage("Internal error in {0}. Exception: {1}, Message: {2}, Trace: {3}", new Object[]{item.getClass().getName(), e.getClass().getName(), e, Arrays.asList(e.getStackTrace())}));
        }

        public CheckCLDR setCldrFileToCheck(CLDRFile cldrFileToCheck, Map options, List possibleErrors) {
            ElapsedTimer testTime = null;
            if (cldrFileToCheck == null) {
                return this;
            }
            super.setCldrFileToCheck(cldrFileToCheck, options, possibleErrors);
            possibleErrors.clear();
            Iterator it = this.filteredCheckList.iterator();
            while (it.hasNext()) {
                CheckCLDR item = (CheckCLDR)it.next();
                if (SHOW_TIMES) {
                    testTime = new ElapsedTimer("Test setup time for " + item.getClass().toString() + " {0}");
                }
                try {
                    item.setCldrFileToCheck(cldrFileToCheck, options, possibleErrors);
                    if (!SHOW_TIMES) continue;
                    System.err.println("OK : " + testTime);
                }
                catch (RuntimeException e) {
                    this.addError(possibleErrors, item, e);
                    if (!SHOW_TIMES) continue;
                    System.err.println("ERR: " + testTime + " - " + e.toString());
                }
            }
            return this;
        }

        public Matcher getFilter() {
            return this.filter;
        }

        public CompoundCheckCLDR setFilter(Matcher filter) {
            this.filter = filter;
            this.filteredCheckList.clear();
            Iterator it = this.checkList.iterator();
            while (it.hasNext()) {
                CheckCLDR item = (CheckCLDR)it.next();
                if (filter != null && !filter.reset(item.getClass().getName()).matches()) continue;
                this.filteredCheckList.add(item);
                item.setCldrFileToCheck(this.getCldrFileToCheck(), null, null);
            }
            return this;
        }
    }

    public static abstract class FormatDemo
    extends SimpleDemo {
        protected String currentPattern;
        protected String currentInput;
        protected String currentFormatted;
        protected String currentReparsed;
        protected String currentContext = "";
        protected ParsePosition parsePosition = new ParsePosition(0);

        protected abstract String getPattern();

        protected abstract String getRandomInput();

        protected abstract void getArguments(Map var1);

        public String getHTML(Map postArguments) throws Exception {
            this.getArguments(postArguments);
            StringBuffer htmlMessage = new StringBuffer();
            FormatDemo.appendTitle(htmlMessage);
            FormatDemo.appendLine(htmlMessage, this.currentPattern, this.currentContext, this.currentInput, this.currentFormatted, this.currentReparsed);
            htmlMessage.append("</table>");
            return htmlMessage.toString();
        }

        public String getPlainText(Map postArguments) {
            this.getArguments(postArguments);
            return MessageFormat.format((String)"<\"\u200e{0}\u200e\", \"{1}\", \"{2}\"> \u2192 \"\u200e{3}\u200e\" \u2192 \"{4}\"", (Object[])new String[]{this.currentPattern, this.currentContext, this.currentInput, this.currentFormatted, this.currentReparsed});
        }

        public static void appendLine(StringBuffer htmlMessage, String pattern, String context, String input, String formatted, String reparsed) {
            htmlMessage.append("<tr><td><input type='text' name='pattern' readonly='true' value='").append(TransliteratorUtilities.toXML.transliterate(pattern)).append("'></td><td><input type='text' name='context' readonly='true' value='").append(TransliteratorUtilities.toXML.transliterate(context)).append("'></td><td><input type='text' name='input' value='").append(TransliteratorUtilities.toXML.transliterate(input)).append("'></td><td>").append("<input type='button' value='Test' name='Test'>").append("</td><td><input type='text' name='formatted' value='").append(TransliteratorUtilities.toXML.transliterate(formatted)).append("'></td><td><input type='text' name='reparsed' value='").append(TransliteratorUtilities.toXML.transliterate(reparsed)).append("'></td></tr>");
        }

        public static void appendTitle(StringBuffer htmlMessage) {
            htmlMessage.append("<table border='1' cellspacing='0' cellpadding='2'><tr><th>Pattern</th><th>Context</th><th>Unlocalized Input</th><th></th><th>Localized Format</th><th>Re-Parsed</th></tr>");
        }
    }

    public static abstract class SimpleDemo {
        Map internalPostArguments = new HashMap();

        public abstract String getHTML(Map var1) throws Exception;

        public final String getHTML(String path, String fullPath, String value) throws Exception {
            return this.getHTML(this.internalPostArguments);
        }

        public final boolean processPost(Map postArguments) {
            this.internalPostArguments.clear();
            this.internalPostArguments.putAll(postArguments);
            return true;
        }
    }

    public static class CheckStatus {
        public static final String alertType = "Comment";
        public static final String warningType = "Warning";
        public static final String errorType = "Error";
        public static final String exampleType = "Example";
        public static final String demoType = "Demo";
        private String type;
        private String messageFormat;
        private Object[] parameters;
        private String htmlMessage;
        private CheckCLDR cause;

        public String getType() {
            return this.type;
        }

        public CheckStatus setType(String type) {
            this.type = type;
            return this;
        }

        public String getMessage() {
            if (this.messageFormat == null) {
                return this.messageFormat;
            }
            return MessageFormat.format((String)MessageFormat.autoQuoteApostrophe((String)this.messageFormat), (Object[])this.parameters);
        }

        public String getHTMLMessage() {
            return this.htmlMessage;
        }

        public CheckStatus setHTMLMessage(String message) {
            this.htmlMessage = message;
            return this;
        }

        public CheckStatus setMessage(String message) {
            this.messageFormat = message;
            return this;
        }

        public CheckStatus setMessage(String message, Object[] messageArguments) {
            this.messageFormat = message;
            this.parameters = messageArguments;
            return this;
        }

        public String toString() {
            return this.getType() + ": " + this.getMessage();
        }

        public Object[] getParameters() {
            return this.parameters;
        }

        public CheckStatus setParameters(Object[] parameters) {
            this.parameters = parameters;
            return this;
        }

        public SimpleDemo getDemo() {
            return null;
        }

        public CheckCLDR getCause() {
            return this.cause;
        }

        public CheckStatus setCause(CheckCLDR cause) {
            this.cause = cause;
            return this;
        }
    }

    public static class PathShower {
        String localeID;
        boolean newLocale = true;
        String lastPath;
        String[] lastSplitPath;
        boolean showEnglish;
        String splitChar = "/";
        static final String lead = "****************************************";

        public void set(String localeID) {
            this.localeID = localeID;
            this.newLocale = true;
            LocaleIDParser localeIDParser = new LocaleIDParser();
            this.showEnglish = !localeIDParser.set(localeID).getLanguageScript().equals("en");
            this.lastPath = null;
            this.lastSplitPath = null;
        }

        public void setDisplayInformation(CLDRFile displayInformation) {
            CheckCLDR.setDisplayInformation(displayInformation);
        }

        public void showHeader(String path, String value) {
            if (this.newLocale) {
                System.out.println("Locale:\t" + CheckCLDR.getLocaleAndName(this.localeID));
                this.newLocale = false;
            }
            if (path.equals(this.lastPath)) {
                return;
            }
            String[] splitPath = path.split(this.splitChar);
            for (int i = 0; i < splitPath.length; ++i) {
                if (this.lastSplitPath != null && i < this.lastSplitPath.length && splitPath[i].equals(this.lastSplitPath[i])) continue;
                this.lastSplitPath = null;
                System.out.print(lead.substring(0, i));
                System.out.print(splitPath[i]);
                if (i == splitPath.length - 1) {
                    System.out.print("\tValue:\t" + value);
                    if (this.showEnglish) {
                        String englishValue = displayInformation.getStringValue(path);
                        if (englishValue == null) {
                            String path2 = CLDRFile.getNondraftNonaltXPath(path);
                            englishValue = displayInformation.getStringValue(path2);
                        }
                        System.out.print("\t[English: " + englishValue + "]");
                    }
                    System.out.print("\tLocale:\t" + this.localeID);
                } else {
                    System.out.print(":");
                }
                System.out.println();
            }
            this.lastPath = path;
            this.lastSplitPath = splitPath;
        }

        public String getSplitChar() {
            return this.splitChar;
        }

        public PathShower setSplitChar(String splitChar) {
            this.splitChar = splitChar;
            return this;
        }
    }
}

