/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.test;

import java.util.List;
import java.util.Map;
import org.unicode.cldr.test.CheckCLDR;
import org.unicode.cldr.test.CoverageLevel;
import org.unicode.cldr.util.CLDRFile;

public class CheckCoverage
extends CheckCLDR {
    static final boolean DEBUG = false;
    static final boolean DEBUG_SET = false;
    private static CoverageLevel coverageLevel = new CoverageLevel();
    private CoverageLevel.Level requiredLevel;
    private boolean skip;

    public CheckCLDR handleCheck(String path, String fullPath, String value, Map options, List result) {
        if (this.skip) {
            return this;
        }
        if (options.get("submission") == null) {
            return this;
        }
        if (path.indexOf("localeDisplayNames") < 0 && path.indexOf("currencies") < 0 && path.indexOf("exemplarCity") < 0) {
            return this;
        }
        String source = this.getResolvedCldrFileToCheck().getSourceLocaleID(path, null);
        if (!source.equals("code-fallback")) {
            return this;
        }
        if (path == null) {
            throw new InternalError("Empty path!");
        }
        if (this.getCldrFileToCheck() == null) {
            throw new InternalError("no file to check!");
        }
        CoverageLevel.Level level = coverageLevel.getCoverageLevel(fullPath);
        if (level == CoverageLevel.Level.UNDETERMINED) {
            return this;
        }
        if (this.requiredLevel.compareTo(level) >= 0) {
            result.add(new CheckCLDR.CheckStatus().setCause(this).setType(CheckCLDR.finalErrorType).setMessage("Needed to meet {0} coverage level.", new Object[]{level}));
        }
        return this;
    }

    public CheckCLDR setCldrFileToCheck(CLDRFile cldrFileToCheck, Map options, List possibleErrors) {
        String optionLevel;
        if (cldrFileToCheck == null) {
            return this;
        }
        this.skip = true;
        if (options != null && options.get("CheckCoverage.skip") != null) {
            return this;
        }
        super.setCldrFileToCheck(cldrFileToCheck, options, possibleErrors);
        if (cldrFileToCheck.getLocaleID().equals("root")) {
            return this;
        }
        coverageLevel.setFile(cldrFileToCheck, options, this, possibleErrors);
        this.requiredLevel = null;
        if (options != null && (optionLevel = (String)options.get("CheckCoverage.requiredLevel")) != null) {
            this.requiredLevel = CoverageLevel.Level.get(optionLevel);
        }
        if (this.requiredLevel == null) {
            this.requiredLevel = coverageLevel.getRequiredLevel(cldrFileToCheck.getLocaleID(), options);
        }
        if (this.requiredLevel == null) {
            this.requiredLevel = CoverageLevel.Level.BASIC;
        }
        this.skip = false;
        return this;
    }

    public void setRequiredLevel(CoverageLevel.Level level) {
        this.requiredLevel = level;
    }

    public CoverageLevel.Level getRequiredLevel() {
        return this.requiredLevel;
    }
}

