/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.test;

import com.ibm.icu.dev.test.util.UnicodeProperty;
import com.ibm.icu.text.BreakIterator;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import org.unicode.cldr.test.CheckCLDR;
import org.unicode.cldr.test.FlexibleDateFromCLDR;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.ICUServiceBuilder;
import org.unicode.cldr.util.Utility;
import org.unicode.cldr.util.XPathParts;

public class CheckDates
extends CheckCLDR {
    ICUServiceBuilder icuServiceBuilder = new ICUServiceBuilder();
    NumberFormat english = NumberFormat.getNumberInstance((ULocale)ULocale.ENGLISH);
    UnicodeProperty.PatternMatcher m;
    static String[] samples = new String[]{"2005-12-02 12:15:16"};
    static String SampleList = "{0}";
    private static final String DECIMAL_XPATH = "//ldml/numbers/symbols/decimal";
    Set neededFormats = new TreeSet<String>(Arrays.asList("yM", "yMMM", "yMd", "yMMMd", "Md", "MMMd", "yQ"));
    Set neededHours12 = new TreeSet<String>(Arrays.asList("hm", "hms"));
    Set neededHours24 = new TreeSet<String>(Arrays.asList("Hm", "Hms"));
    BreakIterator bi;
    FlexibleDateFromCLDR flexInfo;
    Collection redundants = new HashSet();
    TimeZone denver = TimeZone.getTimeZone((String)"America/Denver");
    static final SimpleDateFormat neutralFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", ULocale.ENGLISH);
    XPathParts pathParts = new XPathParts(null, null);
    static long date1950;
    static long date2010;
    static long date4004BC;
    static Random random;
    private ParsePosition parsePosition = new ParsePosition(0);
    static final UnicodeSet XGRAPHEME;
    static final UnicodeSet DIGIT;

    public CheckCLDR setCldrFileToCheck(CLDRFile cldrFileToCheck, Map options, List possibleErrors) {
        if (cldrFileToCheck == null) {
            return this;
        }
        super.setCldrFileToCheck(cldrFileToCheck, options, possibleErrors);
        this.icuServiceBuilder.setCldrFile(this.getResolvedCldrFileToCheck());
        try {
            this.bi = BreakIterator.getCharacterInstance((ULocale)new ULocale(cldrFileToCheck.getLocaleID()));
        }
        catch (RuntimeException e) {
            this.bi = BreakIterator.getCharacterInstance((ULocale)new ULocale(""));
        }
        CLDRFile resolved = this.getResolvedCldrFileToCheck();
        this.flexInfo = new FlexibleDateFromCLDR();
        this.flexInfo.set(resolved);
        String decimal = resolved.getStringValue(DECIMAL_XPATH);
        if (decimal != null) {
            this.flexInfo.checkFlexibles(DECIMAL_XPATH, decimal, DECIMAL_XPATH);
        }
        Iterator it = resolved.iterator("//ldml/dates/calendars/calendar[@type=\"gregorian\"]");
        while (it.hasNext()) {
            String path = (String)it.next();
            String value = resolved.getStringValue(path);
            String fullPath = resolved.getFullXPath(path);
            this.flexInfo.checkFlexibles(path, value, fullPath);
        }
        this.redundants.clear();
        this.flexInfo.getRedundants(this.redundants);
        Set baseSkeletons = this.flexInfo.gen.getBaseSkeletons(new TreeSet());
        TreeSet notCovered = new TreeSet(this.neededFormats);
        if (this.flexInfo.preferred12Hour()) {
            notCovered.addAll(this.neededHours12);
        } else {
            notCovered.addAll(this.neededHours24);
        }
        notCovered.removeAll(baseSkeletons);
        if (notCovered.size() != 0) {
            possibleErrors.add(new CheckCLDR.CheckStatus().setCause(this).setType(CheckCLDR.finalErrorType).setMessage("Missing availableFormats: {0}", new Object[]{((Object)notCovered).toString()}));
        }
        return this;
    }

    public CheckCLDR handleCheck(String path, String fullPath, String value, Map options, List result) {
        if (path.indexOf("/dates") < 0 || path.indexOf("gregorian") < 0) {
            return this;
        }
        try {
            int end;
            if (path.indexOf("[@type=\"narrow\"]") >= 0 && (end = this.getFirstGraphemeClusterBoundary(value)) != value.length()) {
                result.add(new CheckCLDR.CheckStatus().setCause(this).setType(CheckCLDR.finalErrorType).setMessage("Illegal narrow value. Must be only one grapheme cluster \u200e{0}\u200e~\u200e{1}\u200e", new Object[]{value.substring(0, end), value.substring(end)}));
            }
            if (path.indexOf("/pattern") >= 0 && path.indexOf("/dateTimeFormat") < 0 || path.indexOf("/dateFormatItem") >= 0) {
                this.checkPattern(path, fullPath, value, result);
            }
        }
        catch (ParseException e) {
            CheckCLDR.CheckStatus item = new CheckCLDR.CheckStatus().setCause(this).setType(CheckCLDR.finalErrorType).setMessage("Error in creating date format {0}", new Object[]{e});
            result.add(item);
        }
        catch (Exception e) {
            CheckCLDR.CheckStatus item = new CheckCLDR.CheckStatus().setCause(this).setType("Error").setMessage("Error in creating date format {0}", new Object[]{e});
            result.add(item);
        }
        return this;
    }

    public CheckCLDR handleGetExamples(String path, String fullPath, String value, Map options, List result) {
        if (path.indexOf("/dates") < 0 || path.indexOf("gregorian") < 0) {
            return this;
        }
        try {
            if (path.indexOf("/pattern") >= 0 && path.indexOf("/dateTimeFormat") < 0 || path.indexOf("/dateFormatItem") >= 0) {
                this.checkPattern2(path, fullPath, value, result);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return this;
    }

    private static String getRandomDate(long startDate, long endDate) {
        double guess = (double)startDate + random.nextDouble() * (double)(endDate - startDate);
        return neutralFormat.format(new Date((long)guess));
    }

    private void checkPattern(String path, String fullPath, String value, List result) throws ParseException {
        this.pathParts.set(path);
        if (this.pathParts.containsElement("dateFormatItem")) {
            String failureMessage = (String)this.flexInfo.getFailurePath(path);
            if (failureMessage != null) {
                result.add(new CheckCLDR.CheckStatus().setCause(this).setType("Error").setMessage("{0}", new Object[]{failureMessage}));
            }
            if (this.redundants.contains(value)) {
                result.add(new CheckCLDR.CheckStatus().setCause(this).setType("Error").setMessage("Redundant with some pattern (or combination)", new Object[0]));
            }
        }
        String calendar = this.pathParts.findAttributeValue("calendar", "type");
        if (path.indexOf("\"full\"") >= 0) {
            SimpleDateFormat y = this.icuServiceBuilder.getDateFormat(calendar, 4, 4);
            Date dateSource = new Date(date4004BC);
            int year = dateSource.getYear() + 1900;
            if (year > 0) {
                year = 1 - year;
                dateSource.setYear(year - 1900);
            }
            String result2 = y.format(dateSource);
            Date backAgain = y.parse(result2);
            if (path.indexOf("/timeFormat") >= 0 && y.toPattern().indexOf("v") < 0) {
                CheckCLDR.CheckStatus item = new CheckCLDR.CheckStatus().setType(CheckCLDR.finalErrorType).setMessage("Need full zone (v) in full format", new Object[0]);
                result.add(item);
            }
        }
    }

    private void checkPattern2(String path, String fullPath, String value, List result) throws ParseException {
        this.pathParts.set(path);
        String calendar = this.pathParts.findAttributeValue("calendar", "type");
        SimpleDateFormat x = this.icuServiceBuilder.getDateFormat(calendar, value);
        Object[] arguments = new Object[samples.length];
        for (int i = 0; i < samples.length; ++i) {
            String source = CheckDates.getRandomDate(date1950, date2010);
            Date dateSource = neutralFormat.parse(source);
            String formatted = x.format(dateSource);
            this.parsePosition.setIndex(0);
            Date parsed = x.parse(formatted, this.parsePosition);
            String reparsed = this.parsePosition.getIndex() != formatted.length() ? "Couldn't parse past: " + formatted.substring(0, this.parsePosition.getIndex()) : neutralFormat.format(parsed);
            arguments[i] = source + " \u2192 \u201c\u200e" + formatted + "\u200e\u201d \u2192 " + reparsed;
        }
        result.add(new CheckCLDR.CheckStatus().setCause(this).setType("Example").setMessage(SampleList, arguments));
        result.add(new MyCheckStatus().setFormat(x).setCause(this).setType("Demo"));
    }

    private int getFirstGraphemeClusterBoundary(String value) {
        if (value.length() <= 1) {
            return value.length();
        }
        int current = 0;
        this.bi.setText(value);
        if (current != 0) {
            this.bi.preceding(current + 1);
        }
        current = this.bi.next();
        if ((current = Utility.scan(XGRAPHEME, value, current)) != value.length() && DIGIT.containsAll(value) && value.length() == 2) {
            return value.length();
        }
        return current;
    }

    static {
        neutralFormat.setTimeZone(TimeZone.getTimeZone((String)"GMT"));
        date1950 = new Date(50, 0, 1, 0, 0, 0).getTime();
        date2010 = new Date(110, 0, 1, 0, 0, 0).getTime();
        date4004BC = new Date(-5904, 9, 23, 2, 0, 0).getTime();
        random = new Random(0L);
        XGRAPHEME = new UnicodeSet("[[:mark:][:grapheme_extend:]]");
        DIGIT = new UnicodeSet("[:decimal_number:]");
    }

    static class MyDemo
    extends CheckCLDR.FormatDemo {
        private SimpleDateFormat df;

        MyDemo() {
        }

        protected String getPattern() {
            return this.df.toPattern();
        }

        protected String getRandomInput() {
            return CheckDates.getRandomDate(date1950, date2010);
        }

        public MyDemo setFormat(SimpleDateFormat df) {
            this.df = df;
            return this;
        }

        protected void getArguments(Map inout) {
            Date d;
            this.currentReparsed = "?";
            this.currentFormatted = "?";
            this.currentInput = "?";
            this.currentPattern = "?";
            boolean result = false;
            try {
                this.currentPattern = (String)inout.get("pattern");
                if (this.currentPattern != null) {
                    this.df.applyPattern(this.currentPattern);
                } else {
                    this.currentPattern = this.getPattern();
                }
            }
            catch (Exception e) {
                this.currentPattern = "Use format like: ##,###.##";
                return;
            }
            try {
                this.currentInput = (String)inout.get("input");
                if (this.currentInput == null) {
                    this.currentInput = this.getRandomInput();
                }
                d = neutralFormat.parse(this.currentInput);
            }
            catch (Exception e) {
                this.currentInput = "Use neutral format like: 1993-11-31 13:49:02";
                return;
            }
            try {
                this.currentFormatted = this.df.format(d);
            }
            catch (Exception e) {
                this.currentFormatted = "Can't format: " + e.getMessage();
                return;
            }
            try {
                this.parsePosition.setIndex(0);
                Date n = this.df.parse(this.currentFormatted, this.parsePosition);
                this.currentReparsed = this.parsePosition.getIndex() != this.currentFormatted.length() ? "Couldn't parse past: \u200e" + this.currentFormatted.substring(0, this.parsePosition.getIndex()) + "\u200e" : neutralFormat.format(n);
            }
            catch (Exception e) {
                this.currentReparsed = "Can't parse: " + e.getMessage();
            }
        }
    }

    public static class MyCheckStatus
    extends CheckCLDR.CheckStatus {
        private SimpleDateFormat df;

        public MyCheckStatus setFormat(SimpleDateFormat df) {
            this.df = df;
            return this;
        }

        public CheckCLDR.SimpleDemo getDemo() {
            return new MyDemo().setFormat(this.df);
        }
    }
}

