/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.XPathParts;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DeclHandler;

public class GenerateAttributeList {
    XPathParts parts = new XPathParts(null, null);
    Map element_attribute_valueSet = new TreeMap();
    Set allElements = new TreeSet();
    Map defaults = new HashMap();

    public GenerateAttributeList(CLDRFile.Factory cldrFactory) throws IOException {
        this.addFromStandardCodes();
        this.addFromDTD("../../common/main/en.xml");
        this.addFromDTD("../../common/supplemental/characters.xml");
        this.addFromDirectory("../../common/collation/");
        this.addFromDirectory("../../common/main/");
        this.addFromDirectory("../../common/supplemental/");
    }

    private void addFromStandardCodes() {
        StandardCodes sc = StandardCodes.make();
        String cat = "language";
        this.addFromStandardCodes(sc, "language");
        this.addFromStandardCodes(sc, "territory");
        this.addFromStandardCodes(sc, "script");
        this.addFromStandardCodes(sc, "variant");
        this.addFromStandardCodes(sc, "currency");
        this.addFromStandardCodes(sc, "tzid");
    }

    private void addFromStandardCodes(StandardCodes sc, String cat) {
        Set c = sc.getGoodAvailableCodes(cat);
        String target = cat.equals("tzid") ? "zone" : cat;
        Iterator it = c.iterator();
        while (it.hasNext()) {
            String item = (String)it.next();
            this.add(target, "type", item, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFromDTD(String filename) throws IOException {
        FileInputStream fis = new FileInputStream(filename);
        try {
            InputSource is = new InputSource(fis);
            MyDeclHandler me = new MyDeclHandler();
            XMLReader xmlReader = CLDRFile.createXMLReader(true);
            xmlReader.setProperty("http://xml.org/sax/properties/declaration-handler", me);
            xmlReader.parse(is);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            fis.close();
        }
    }

    private void addFromDirectory(String directory) throws IOException {
        File dir = new File(directory);
        directory = dir.getCanonicalPath();
        String[] files = dir.list();
        for (int i = 0; i < files.length; ++i) {
            String file;
            if (files[i].startsWith(".#") || !files[i].endsWith(".xml") || new File(file = directory + File.separatorChar + files[i]).isDirectory()) continue;
            this.addFromFiles(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFromFiles(String file) throws IOException {
        System.out.println(file);
        FileInputStream fis = new FileInputStream(file);
        try {
            InputSource is = new InputSource(fis);
            MyDeclHandler me = new MyDeclHandler();
            XMLReader xmlReader = CLDRFile.createXMLReader(true);
            xmlReader.setContentHandler(new MyContentHandler());
            xmlReader.parse(is);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            fis.close();
        }
    }

    void add(String element, String attribute, String attributeValue, boolean dtd) {
        Set[] valueSets;
        if (element.equals("generation") && attribute.equals("date")) {
            attributeValue = "[date]";
        } else if (element.equals("version") && attribute.equals("number")) {
            attributeValue = "[revision]";
        } else if (attribute.equals("draft") || attribute.equals("validSubLocales") || attribute.equals("standard") || attribute.equals("references")) {
            element = "[common]";
        } else if (attribute.equals("alt")) {
            int pos = attributeValue.indexOf("proposed");
            if (pos == 0) {
                return;
            }
            if (pos > 0) {
                attributeValue = attributeValue.substring(0, pos - 1);
            }
            element = "[common]";
        }
        TreeMap<String, Set[]> attribute_valueSet = (TreeMap<String, Set[]>)this.element_attribute_valueSet.get(element);
        if (attribute_valueSet == null) {
            attribute_valueSet = new TreeMap<String, Set[]>();
            this.element_attribute_valueSet.put(element, attribute_valueSet);
        }
        if ((valueSets = (Set[])attribute_valueSet.get(attribute)) == null) {
            Comparator c = CLDRFile.getAttributeValueComparator(element, attribute);
            valueSets = new Set[]{new TreeSet(c), new TreeSet()};
            attribute_valueSet.put(attribute, valueSets);
        }
        valueSets[dtd ? 1 : 0].add(attributeValue);
    }

    void show(PrintWriter pw) {
        pw.println("<html><head>");
        pw.println("<style>td,th { border-style: solid; border-width: 1; vertical-align: top }</style>");
        pw.println("</head><body>");
        pw.println("<table>");
        pw.println("<tr><th>Element</th><th>Attribute</th><th>Actual Attribute Values</th><th>Other DTD Attribute Values</th></tr>");
        Iterator it = this.element_attribute_valueSet.keySet().iterator();
        while (it.hasNext()) {
            String element = (String)it.next();
            Map attribute_valueSet = (Map)this.element_attribute_valueSet.get(element);
            int size = attribute_valueSet.size();
            if (size == 0) continue;
            boolean first = true;
            Iterator it2 = attribute_valueSet.keySet().iterator();
            while (it2.hasNext()) {
                String attribute = (String)it2.next();
                Set[] valueSets = (Set[])attribute_valueSet.get(attribute);
                pw.print("<tr>");
                if (first) {
                    first = false;
                    pw.print("<td" + (size == 1 ? "" : " rowSpan='" + attribute_valueSet.size() + "'") + ">" + element + "</td>");
                }
                pw.print("<td>" + attribute + "</td><td>");
                String defaultKey = element + "|" + attribute;
                pw.print(this.toString(valueSets[0], defaultKey));
                pw.println("</td><td>");
                TreeSet toRemove = new TreeSet(valueSets[0]);
                TreeSet remainder = new TreeSet(valueSets[1]);
                remainder.removeAll(toRemove);
                pw.print(this.toString(remainder, defaultKey));
                pw.println("</td></tr>");
            }
        }
        pw.println("</table></body></html>");
    }

    private String toString(Collection source, String defaultKey) {
        StringBuffer result = new StringBuffer();
        boolean first = true;
        Iterator it = source.iterator();
        while (it.hasNext()) {
            String value = (String)it.next();
            if (first) {
                first = false;
            } else {
                result.append(", ");
            }
            if (value.equals(this.defaults.get(defaultKey))) {
                result.append("<b>").append(value).append("</b>");
                continue;
            }
            result.append(value);
        }
        return result.toString();
    }

    public Map getElement_attribute_valueSet() {
        return this.element_attribute_valueSet;
    }

    class MyContentHandler
    implements ContentHandler {
        MyContentHandler() {
        }

        public void endDocument() throws SAXException {
        }

        public void startDocument() throws SAXException {
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
        }

        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        public void endPrefixMapping(String prefix) throws SAXException {
        }

        public void skippedEntity(String name) throws SAXException {
        }

        public void setDocumentLocator(Locator locator) {
        }

        public void processingInstruction(String target, String data) throws SAXException {
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes attributes) throws SAXException {
            if (attributes == null) {
                return;
            }
            for (int i = 0; i < attributes.getLength(); ++i) {
                String attribute = attributes.getQName(i);
                String value = attributes.getValue(i);
                GenerateAttributeList.this.add(qName, attribute, value, false);
            }
        }
    }

    class MyDeclHandler
    implements DeclHandler {
        Matcher idmatcher = Pattern.compile("[a-zA-Z][-_a-zA-Z0-9]*").matcher("");

        MyDeclHandler() {
        }

        public void attributeDecl(String eName, String aName, String type, String mode, String value) throws SAXException {
            if (value != null) {
                GenerateAttributeList.this.add(eName, aName, value, true);
                GenerateAttributeList.this.defaults.put(eName + "|" + aName, value);
            }
            this.idmatcher.reset(type);
            while (this.idmatcher.find()) {
                GenerateAttributeList.this.add(eName, aName, this.idmatcher.group(), true);
            }
        }

        public void elementDecl(String name, String model) throws SAXException {
        }

        public void internalEntityDecl(String name, String value) throws SAXException {
        }

        public void externalEntityDecl(String name, String publicId, String systemId) throws SAXException {
        }
    }
}

