/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.ibm.icu.dev.test.util.BagFormatter;
import com.ibm.icu.dev.test.util.TransliteratorUtilities;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.LanguageTagParser;
import org.unicode.cldr.util.StandardCodes;

public class GenerateKaraList {
    static CLDRFile english;
    static CLDRFile.Factory cldrFactory;

    public static void main(String[] args) throws IOException {
        cldrFactory = CLDRFile.Factory.make("../../common/", ".*");
        english = cldrFactory.make("en", true);
        PrintWriter log = BagFormatter.openUTF8Writer((String)"../../dropbox/gen/main/", (String)"karaList.xml");
        Set locales = LanguageTagParser.getLanguageScript(cldrFactory.getAvailable());
        locales.remove("sr");
        locales.remove("zh");
        StandardCodes codes = StandardCodes.make();
        log.println("<root>");
        GenerateKaraList.printCodes(log, locales, codes.getAvailableCodes("language"), 0);
        GenerateKaraList.printCodes(log, locales, codes.getAvailableCodes("territory"), 2);
        GenerateKaraList.printCodes(log, locales, codes.getAvailableCodes("currency"), 4);
        log.println("</root>");
        log.close();
        System.out.println("Done");
    }

    private static void printCodes(PrintWriter log, Set locales, Set availableCodes, int choice) {
        boolean hasAbbreviation = choice == 4;
        HashSet<String> errors = new HashSet<String>();
        Iterator it = availableCodes.iterator();
        while (it.hasNext()) {
            String aename;
            String id = (String)it.next();
            String ename = english.getName(choice, id, true);
            if (ename == null) {
                ename = "[untranslated: " + id + "]";
            }
            System.out.println(id + "\t" + ename);
            log.println("\t<entry>");
            log.println("\t\t<hdterm>" + TransliteratorUtilities.toXML.transliterate(ename) + "</hdterm>\t<!-- " + TransliteratorUtilities.toXML.transliterate(CLDRFile.getNameName(choice)) + ": " + id + " -->");
            log.println("\t\t<hom>");
            log.println("\t\t\t<epos>n</epos>");
            log.println("\t\t\t<sense>");
            if (hasAbbreviation && (aename = english.getName(5, id, true)) != null) {
                log.println("\t\t\t\t<eabbr>" + TransliteratorUtilities.toXML.transliterate(aename) + "</eabbr>");
            }
            Iterator it2 = locales.iterator();
            while (it2.hasNext()) {
                String locale = (String)it2.next();
                try {
                    String aename2;
                    CLDRFile cldrfile = cldrFactory.make(locale, true);
                    String trans = cldrfile.getName(choice, id, true);
                    if (trans == null) continue;
                    log.println("\t\t\t\t<target>");
                    log.println("\t\t\t\t\t<tlanguage>" + locale + "</tlanguage>\t<!-- " + TransliteratorUtilities.toXML.transliterate(english.getName(locale, true)) + " -->");
                    log.println("\t\t\t\t\t<trans>" + TransliteratorUtilities.toXML.transliterate(trans) + "</trans>");
                    if (hasAbbreviation && (aename2 = cldrfile.getName(5, id, true)) != null && !aename2.equals(id)) {
                        log.println("\t\t\t\t\t<tabbr>" + TransliteratorUtilities.toXML.transliterate(aename2) + "</tabbr>");
                    }
                    log.println("\t\t\t\t</target>");
                }
                catch (RuntimeException e) {
                    String s = e.getMessage();
                    if (errors.contains(s)) continue;
                    System.out.println(s);
                    errors.add(s);
                }
            }
            log.println("\t\t\t</sense>");
            log.println("\t\t</hom>");
            log.println("\t</entry>");
        }
    }
}

