/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.ibm.icu.dev.test.util.BagFormatter;
import com.ibm.icu.dev.test.util.TransliteratorUtilities;
import com.ibm.icu.dev.tool.UOption;
import com.ibm.icu.text.Collator;
import com.ibm.icu.text.RuleBasedCollator;
import com.ibm.icu.text.RuleBasedNumberFormat;
import com.ibm.icu.text.Transliterator;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.ULocale;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.unicode.cldr.tool.ShowData;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.PrettyPath;
import org.unicode.cldr.util.Utility;
import org.unicode.cldr.util.XPathParts;
import org.xml.sax.SAXException;

public class GenerateSidewaysView {
    static final boolean DEBUG = false;
    static final boolean DEBUG2 = false;
    static final boolean DEBUG_SHOW_ADD = false;
    static final boolean DEBUG_ELEMENT = false;
    static final boolean DEBUG_SHOW_BAT = false;
    static boolean usePrettyPath = true;
    static final boolean FIX_ZONE_ALIASES = true;
    private static final int HELP1 = 0;
    private static final int HELP2 = 1;
    private static final int SOURCEDIR = 2;
    private static final int DESTDIR = 3;
    private static final int MATCH = 4;
    private static final int SKIP = 5;
    private static final int TZADIR = 6;
    private static final int NONVALIDATING = 7;
    private static final int SHOW_DTD = 8;
    private static final int TRANSLIT = 9;
    private static final String NEWLINE = "\n";
    private static final UOption[] options = new UOption[]{UOption.HELP_H(), UOption.HELP_QUESTION_MARK(), UOption.SOURCEDIR().setDefault("../../common/main/"), UOption.DESTDIR().setDefault("../../dropbox/gen/charts\\by_type\\"), UOption.create((String)"match", (char)'m', (int)1).setDefault(".*"), UOption.create((String)"skip", (char)'z', (int)1).setDefault("zh_(C|S|HK|M).*"), UOption.create((String)"tzadir", (char)'t', (int)1).setDefault("C:\\ICU4J\\icu4j\\src\\com\\ibm\\icu\\dev\\tool\\cldr\\"), UOption.create((String)"nonvalidating", (char)'n', (int)0), UOption.create((String)"dtd", (char)'w', (int)0), UOption.create((String)"transliterate", (char)'y', (int)0)};
    private static String timeZoneAliasDir = null;
    private static Map path_value_locales = new TreeMap();
    private static XPathParts parts = new XPathParts(null, null);
    private static long startTime = System.currentTimeMillis();
    static RuleBasedCollator standardCollation = (RuleBasedCollator)Collator.getInstance((ULocale)ULocale.ENGLISH);
    private static CLDRFile english;
    private static ShowData.DataShower dataShower;
    static PrettyPath prettyPath;
    static Set skipSet;
    static String[] headerAndFooter;

    public static void main(String[] args) throws SAXException, IOException {
        startTime = System.currentTimeMillis();
        Utility.registerExtraTransliterators();
        UOption.parseArgs((String[])args, (UOption[])options);
        CLDRFile.Factory cldrFactory = CLDRFile.Factory.make(GenerateSidewaysView.options[2].value, GenerateSidewaysView.options[4].value);
        english = cldrFactory.make("en", true);
        GenerateSidewaysView.loadInformation(cldrFactory);
        String oldMain = "";
        PrintWriter out = null;
        System.out.println("Getting types");
        String[] partial = new String[]{""};
        TreeSet<String> types = new TreeSet<String>();
        Iterator it = path_value_locales.keySet().iterator();
        while (it.hasNext()) {
            String path = (String)it.next();
            String main = GenerateSidewaysView.getFileName(path, partial);
            if (main.equals(oldMain)) continue;
            oldMain = main;
            types.add(main);
        }
        System.out.println("Printing files");
        Transliterator toLatin = Transliterator.getInstance((String)"any-latin");
        Transliterator toHTML = TransliteratorUtilities.toHTML;
        UnicodeSet BIDI_R = new UnicodeSet("[[:Bidi_Class=R:][:Bidi_Class=AL:]]");
        Iterator it2 = path_value_locales.keySet().iterator();
        while (it2.hasNext()) {
            String originalPath;
            String englishValue;
            String path = (String)it2.next();
            String main = GenerateSidewaysView.getFileName(path, partial);
            if (!main.equals(oldMain)) {
                oldMain = main;
                out = GenerateSidewaysView.start(out, main, types);
            }
            String key = partial[0];
            if (usePrettyPath && (englishValue = english.getStringValue(originalPath = prettyPath.getOriginal(path))) != null) {
                key = key + " (English: " + englishValue + ")";
            }
            out.println("<tr><th colSpan='2' class='path'>" + toHTML.transliterate(key) + "</th><tr>");
            Map value_locales = (Map)path_value_locales.get(path);
            Iterator it22 = value_locales.keySet().iterator();
            while (it22.hasNext()) {
                String value = (String)it22.next();
                String valueClass = " class='value'";
                if (ShowData.DataShower.getBidiStyle(value).length() != 0) {
                    valueClass = " class='rtl_value'";
                }
                out.println("<tr><th" + valueClass + ">" + ShowData.DataShower.getPrettyValue(value) + "</th><td class='td'>");
                Set locales = (Set)value_locales.get(value);
                boolean first = true;
                Iterator it3 = locales.iterator();
                while (it3.hasNext()) {
                    String locale = (String)it3.next();
                    if (first) {
                        first = false;
                    } else {
                        out.print(" ");
                    }
                    if (locale.endsWith("*")) {
                        locale = locale.substring(0, locale.length() - 1);
                        out.print("<i>\u00b7" + locale + "\u00b7</i>");
                        continue;
                    }
                    out.print("\u00b7" + locale + "\u00b7");
                }
                out.println("</td><tr>");
            }
        }
        GenerateSidewaysView.finish(out);
        System.out.println("Done in " + new RuleBasedNumberFormat(new ULocale("en"), 3).format((double)(System.currentTimeMillis() - startTime) / 1000.0));
    }

    private static void loadInformation(CLDRFile.Factory cldrFactory) {
        Set alllocales = cldrFactory.getAvailable();
        String[] postFix = new String[]{""};
        Iterator it = alllocales.iterator();
        while (it.hasNext()) {
            String localeID = (String)it.next();
            System.out.println("Loading: " + localeID);
            CLDRFile cldrFile = cldrFactory.make(localeID, localeID.equals("root"));
            if (cldrFile.isNonInheriting()) continue;
            Iterator it2 = cldrFile.iterator();
            while (it2.hasNext()) {
                TreeSet<String> locales;
                TreeMap<String, TreeSet<String>> value_locales;
                String path = (String)it2.next();
                if (path.indexOf("/alias") >= 0 || path.indexOf("/identity") >= 0 || path.indexOf("/references") >= 0) continue;
                String cleanPath = GenerateSidewaysView.fixPath(path, postFix);
                String fullPath = cldrFile.getFullXPath(path);
                String value = GenerateSidewaysView.getValue(cldrFile, path, fullPath);
                if (fullPath.indexOf("[@draft=") >= 0) {
                    postFix[0] = "*";
                }
                if ((value_locales = (TreeMap<String, TreeSet<String>>)path_value_locales.get(cleanPath)) == null) {
                    value_locales = new TreeMap<String, TreeSet<String>>((Comparator<String>)standardCollation);
                    path_value_locales.put(cleanPath, value_locales);
                }
                if ((locales = (TreeSet<String>)value_locales.get(value)) == null) {
                    locales = new TreeSet<String>();
                    value_locales.put(value, locales);
                }
                locales.add(localeID + postFix[0]);
            }
        }
    }

    private static String fixPath(String path, String[] localePrefix) {
        localePrefix[0] = "";
        if (path.indexOf("[@alt=") >= 0 || path.indexOf("[@draft=") >= 0) {
            localePrefix[0] = "*";
            path = GenerateSidewaysView.removeAttributes(path, skipSet);
        }
        if (usePrettyPath) {
            path = prettyPath.getPrettyPath(path);
        }
        return path;
    }

    private static String removeAttributes(String xpath, Set skipAttributes) {
        XPathParts parts = new XPathParts(null, null).set(xpath);
        GenerateSidewaysView.removeAttributes(parts, skipAttributes);
        return parts.toString();
    }

    private static void removeAttributes(XPathParts parts, Set skipAttributes) {
        for (int i = 0; i < parts.size(); ++i) {
            String element = parts.getElement(i);
            Map attributes = parts.getAttributes(i);
            Iterator it = attributes.keySet().iterator();
            while (it.hasNext()) {
                String attribute = (String)it.next();
                if (!skipAttributes.contains(attribute)) continue;
                it.remove();
            }
        }
    }

    private static String getValue(CLDRFile cldrFile, String path, String fullPath) {
        String value = cldrFile.getStringValue(path);
        if (value == null) {
            System.out.println("Null value for " + path);
            return value;
        }
        if (value.length() == 0) {
            parts.set(fullPath);
            GenerateSidewaysView.removeAttributes(parts, skipSet);
            int limit = parts.size();
            value = parts.toString(limit - 1, limit);
        }
        return value;
    }

    private static String getFileName(String path, String[] partial) {
        if (usePrettyPath) {
            path = prettyPath.getOutputForm(path);
            int pos = path.lastIndexOf(124);
            partial[0] = path.substring(pos + 1);
            return path.substring(0, pos).replace('|', '.');
        }
        parts.set(path);
        int start = 1;
        String main = parts.getElement(start);
        if (main.equals("localeDisplayNames") || main.equals("dates") || main.equals("numbers")) {
            start = 2;
            String part2 = parts.getElement(start);
            main = main + "_" + part2;
            if (part2.equals("calendars")) {
                start = 3;
                Map m = parts.getAttributes(start);
                part2 = (String)m.get("type");
                main = main + "_" + part2;
            }
        }
        partial[0] = parts.toString(start + 1, parts.size());
        return main;
    }

    private static PrintWriter start(PrintWriter out, String main, Set types) throws IOException {
        GenerateSidewaysView.finish(out);
        out = BagFormatter.openUTF8Writer((String)GenerateSidewaysView.options[3].value, (String)(main + ".html"));
        ShowData.getChartTemplate("By-Type Chart: " + main, english.getDtdVersion(), "", headerAndFooter);
        out.println(headerAndFooter[0]);
        out.println("<blockquote><p>");
        boolean first = true;
        String lastMain = "";
        Iterator it = types.iterator();
        while (it.hasNext()) {
            String fileName = (String)it.next();
            int breakPos = fileName.indexOf(46);
            if (breakPos >= 0) {
                String mainName = fileName.substring(0, breakPos);
                String subName = fileName.substring(breakPos + 1);
                if (!mainName.equals(lastMain)) {
                    if (lastMain.length() != 0) {
                        out.print("<br>");
                    }
                    out.println("<b>" + mainName + "</b>: ");
                    lastMain = mainName;
                } else {
                    out.println(" | ");
                }
                out.println("<a href='" + fileName + ".html'>" + subName + "</a>");
                continue;
            }
            if (first) {
                first = false;
            } else {
                out.println(" | ");
            }
            out.println("<a href='" + fileName + ".html'>" + fileName + "</a>");
        }
        out.println("</p></blockquote><table class='table'>");
        return out;
    }

    private static void finish(PrintWriter out) {
        if (out == null) {
            return;
        }
        out.println("</table>");
        out.println(headerAndFooter[1]);
        out.close();
    }

    static {
        standardCollation.setStrength(15);
        standardCollation.setNumericCollation(true);
        dataShower = new ShowData.DataShower();
        prettyPath = new PrettyPath();
        skipSet = new HashSet<String>(Arrays.asList("draft", "alt"));
        headerAndFooter = new String[2];
    }
}

