/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.unicode.cldr.util.CachingEntityResolver;
import org.unicode.cldr.util.LDMLUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLValidator {
    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("No files specified. Validation failed");
            System.exit(-1);
        }
        try {
            for (int i = 0; i < args.length; ++i) {
                System.out.println("Processing file " + args[i]);
                Document doc = XMLValidator.parse(args[i]);
                if (doc == null) continue;
                try {
                    OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(args[i].replace('.', '_') + "_debug.xml"), "UTF-8");
                    LDMLUtilities.printDOMTree(doc, new PrintWriter(writer), "http://www.unicode.org/cldr/dtd/1.3/ldml.dtd", null);
                    writer.flush();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                System.exit(0);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        System.exit(-1);
    }

    public static String filenameToURL(String filename) {
        if (null == filename) {
            return null;
        }
        if (filename.startsWith("file:") || filename.startsWith("http:") || filename.startsWith("ftp:") || filename.startsWith("gopher:") || filename.startsWith("mailto:") || filename.startsWith("news:") || filename.startsWith("telnet:")) {
            return filename;
        }
        File f = new File(filename);
        String tmp = null;
        try {
            tmp = f.getCanonicalPath();
        }
        catch (IOException ioe) {
            tmp = f.getAbsolutePath();
        }
        if (File.separatorChar == '\\') {
            tmp = tmp.replace('\\', '/');
        }
        if (tmp.startsWith("/")) {
            return "file://" + tmp;
        }
        return "file:///" + tmp;
    }

    static Document parse(String filename) {
        String docURI = XMLValidator.filenameToURL(filename);
        return XMLValidator.parse(new InputSource(docURI), filename);
    }

    static Document parse(InputSource docSrc, String filename) {
        Document doc;
        block9: {
            DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
            dfactory.setNamespaceAware(true);
            dfactory.setValidating(true);
            final String filename2 = filename;
            ErrorHandler nullHandler = new ErrorHandler(){

                public void warning(SAXParseException e) throws SAXException {
                    System.err.println(filename2 + ": Warning: " + e.getMessage());
                }

                public void error(SAXParseException e) throws SAXException {
                    int col = e.getColumnNumber();
                    System.err.println(filename2 + ":" + e.getLineNumber() + (col >= 0 ? ":" + col : "") + ": ERROR: Element " + e.getPublicId() + " is not valid because " + e.getMessage());
                }

                public void fatalError(SAXParseException e) throws SAXException {
                    System.err.println(filename2 + ": ERROR ");
                    throw e;
                }
            };
            doc = null;
            try {
                DocumentBuilder docBuilder = dfactory.newDocumentBuilder();
                docBuilder.setErrorHandler(nullHandler);
                docBuilder.setEntityResolver(new CachingEntityResolver());
                doc = docBuilder.parse(docSrc);
            }
            catch (Throwable se) {
                if (se instanceof SAXParseException) {
                    SAXParseException pe = (SAXParseException)se;
                    int col = pe.getColumnNumber();
                    System.err.println(filename + ":" + pe.getLineNumber() + (col >= 0 ? ":" + col : "") + ": ERROR:" + se.toString());
                } else {
                    System.err.println(filename + ": ERROR:" + se.toString());
                }
                try {
                    throw new RuntimeException(filename + ": XMLComparator not HTML parser!");
                }
                catch (Exception e) {
                    if (filename == null) break block9;
                    try {
                        String tmp;
                        FileReader fr = new FileReader(filename);
                        BufferedReader br = new BufferedReader(fr);
                        StringBuffer buffer = new StringBuffer();
                        while ((tmp = br.readLine()) != null) {
                            buffer.append(tmp);
                            buffer.append("\n");
                        }
                        DocumentBuilder docBuilder = dfactory.newDocumentBuilder();
                        doc = docBuilder.newDocument();
                        Element outElem = doc.createElement("out");
                        Text textNode = doc.createTextNode(buffer.toString());
                        outElem.appendChild(textNode);
                        doc.appendChild(outElem);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }
        return doc;
    }
}

