/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.ibm.icu.impl.CollectionUtilities;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.Freezable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.util.CachingEntityResolver;
import org.unicode.cldr.util.LanguageTagParser;
import org.unicode.cldr.util.LocaleIDParser;
import org.unicode.cldr.util.Log;
import org.unicode.cldr.util.MapComparator;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.StripUTF8BOMInputStream;
import org.unicode.cldr.util.Utility;
import org.unicode.cldr.util.XMLSource;
import org.unicode.cldr.util.XPathParts;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class CLDRFile
implements Freezable {
    private static boolean LOG_PROGRESS = false;
    public static boolean HACK_ORDER = false;
    private static boolean DEBUG_LOGGING = false;
    private static boolean SHOW_ALIAS_FIXES = false;
    public static final String SUPPLEMENTAL_NAME = "supplementalData";
    public static final String SUPPLEMENTAL_METADATA = "supplementalMetadata";
    public static final String SUPPLEMENTAL_PREFIX = "supplemental";
    public static final String GEN_VERSION = "1.4";
    private boolean locked;
    private XMLSource dataSource;
    private String dtdVersion;
    public static final int MERGE_KEEP_MINE = 0;
    public static final int MERGE_REPLACE_MINE = 1;
    public static final int MERGE_ADD_ALTERNATE = 2;
    public static final int MERGE_REPLACE_MY_DRAFT = 3;
    static XPathParts nondraftParts = new XPathParts(null, null);
    public static final int NO_NAME = -1;
    public static final int LANGUAGE_NAME = 0;
    public static final int SCRIPT_NAME = 1;
    public static final int TERRITORY_NAME = 2;
    public static final int VARIANT_NAME = 3;
    public static final int CURRENCY_NAME = 4;
    public static final int CURRENCY_SYMBOL = 5;
    public static final int TZ_EXEMPLAR = 6;
    public static final int TZ_START = 6;
    public static final int TZ_GENERIC_LONG = 7;
    public static final int TZ_GENERIC_SHORT = 8;
    public static final int TZ_STANDARD_LONG = 9;
    public static final int TZ_STANDARD_SHORT = 10;
    public static final int TZ_DAYLIGHT_LONG = 11;
    public static final int TZ_DAYLIGHT_SHORT = 12;
    public static final int TZ_LIMIT = 13;
    public static final int LIMIT_TYPES = 13;
    private static final String[][] NameTable = new String[][]{{"//ldml/localeDisplayNames/languages/language[@type=\"", "\"]", "language"}, {"//ldml/localeDisplayNames/scripts/script[@type=\"", "\"]", "script"}, {"//ldml/localeDisplayNames/territories/territory[@type=\"", "\"]", "territory"}, {"//ldml/localeDisplayNames/variants/variant[@type=\"", "\"]", "variant"}, {"//ldml/numbers/currencies/currency[@type=\"", "\"]/displayName", "currency"}, {"//ldml/numbers/currencies/currency[@type=\"", "\"]/symbol", "currency-symbol"}, {"//ldml/dates/timeZoneNames/zone[@type=\"", "\"]/exemplarCity", "exemplar-city"}, {"//ldml/dates/timeZoneNames/zone[@type=\"", "\"]/long/generic", "tz-generic-long"}, {"//ldml/dates/timeZoneNames/zone[@type=\"", "\"]/short/generic", "tz-generic-short"}, {"//ldml/dates/timeZoneNames/zone[@type=\"", "\"]/long/standard", "tz-standard-long"}, {"//ldml/dates/timeZoneNames/zone[@type=\"", "\"]/short/standard", "tz-standard-short"}, {"//ldml/dates/timeZoneNames/zone[@type=\"", "\"]/long/daylight", "tz-daylight-long"}, {"//ldml/dates/timeZoneNames/zone[@type=\"", "\"]/short/daylight", "tz-daylight-short"}};
    transient LanguageTagParser lparser = new LanguageTagParser();
    static MapComparator elementOrdering = (MapComparator)new MapComparator().add((Comparable[])"ldml alternate attributeOrder attributes character character-fallback comment context cp deprecatedItems elementOrder first_variable fractions identity info languageAlias languageCoverage last_variable first_tertiary_ignorable last_tertiary_ignorable first_secondary_ignorable last_secondary_ignorable first_primary_ignorable last_primary_ignorable first_non_ignorable last_non_ignorable first_trailing last_trailing mapTimezones mapZone reference region scriptAlias scriptCoverage serialElements substitute suppress tRule territoryAlias territoryCoverage timezoneCoverage transform validity alias appendItem base beforeCurrency afterCurrency currencyMatch dateFormatItem day deprecated coverageAdditions era eraNames eraAbbr eraNarrow exemplarCharacters field generic height hourFormat hoursFormat gmtFormat key languages localeDisplayNames layout localizedPatternChars calendars long mapping measurementSystem measurementSystemName messages minDays firstDay month months monthNames monthAbbr days dayNames dayAbbr orientation inList paperSize pattern displayName quarter quarters quotationStart quotationEnd alternateQuotationStart alternateQuotationEnd regionFormat fallbackFormat abbreviationFallback preferenceOrdering relative reset p pc rule s sc scripts segmentation settings short exemplarCity singleCountries default calendar collation currency currencyFormat currencySpacing currencyFormatLength dateFormat dateFormatLength dateTimeFormat dateTimeFormatLength availableFormats appendItems dayContext dayWidth decimalFormat decimalFormatLength monthContext monthWidth percentFormat percentFormatLength quarterContext quarterWidth scientificFormat scientificFormatLength skipDefaultLocale standard daylight suppress_contractions optimize rules surroundingMatch insertBetween symbol decimal group list percentSign nativeZeroDigit patternDigit plusSign minusSign exponential perMille infinity nan symbols decimalFormats scientificFormats percentFormats currencyFormats currencies t tc q qc i ic extend territories timeFormat timeFormatLength timeZoneNames type variable attributeValues variables segmentRules variantAlias variants keys types measurementSystemNames version generation currencyData language script territory territoryContainment languageData calendarData variant week am pm eras dateFormats timeFormats dateTimeFormats fields weekData measurementData timezoneData characters delimiters measurement dates numbers collations posix segmentations references transforms metadata weekendStart weekendEnd width x yesstr nostr yesexpr noexpr zone special zoneAlias zoneFormatting zoneItem supplementalData".split("\\s+")).setErrorOnMissing(false).freeze();
    static MapComparator attributeOrdering = (MapComparator)new MapComparator().add((Comparable[])"_q type id choice key registry source target path day date version count lines characters iso4217 before from to number time casing list uri digits rounding iso3166 hex request direction alternate backwards caseFirst caseLevel hiraganaQuarternary hiraganaQuaternary variableTop normalization numeric strength validSubLocales elements element attributes attribute aliases attributeValue contains multizone order other replacement scripts services territories territory tzidVersion value values variant variants visibility standard references alt draft".split("\\s+")).setErrorOnMissing(false).freeze();
    static MapComparator valueOrdering = (MapComparator)new MapComparator().setErrorOnMissing(false).freeze();
    static MapComparator dayValueOrder = (MapComparator)new MapComparator().add((Comparable[])new String[]{"sun", "mon", "tue", "wed", "thu", "fri", "sat"}).freeze();
    static MapComparator widthOrder = (MapComparator)new MapComparator().add((Comparable[])new String[]{"abbreviated", "narrow", "wide"}).freeze();
    static MapComparator lengthOrder = (MapComparator)new MapComparator().add((Comparable[])new String[]{"full", "long", "medium", "short"}).freeze();
    static MapComparator dateFieldOrder = (MapComparator)new MapComparator().add((Comparable[])new String[]{"era", "year", "month", "week", "day", "weekday", "dayperiod", "hour", "minute", "second", "zone"}).freeze();
    static Comparator zoneOrder = StandardCodes.make().getTZIDComparator();
    static Set orderedElements = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("variable", "comment", "tRule", "attributeValues", "base", "settings", "suppress_contractions", "optimize", "rules", "reset", "p", "pc", "s", "sc", "t", "tc", "q", "qc", "i", "ic", "x", "extend", "first_variable", "last_variable", "first_tertiary_ignorable", "last_tertiary_ignorable", "first_secondary_ignorable", "last_secondary_ignorable", "first_primary_ignorable", "last_primary_ignorable", "first_non_ignorable", "last_non_ignorable", "first_trailing", "last_trailing")));
    public static Comparator ldmlComparator = new LDMLComparator();
    static String[][] distinguishingData = new String[][]{{"*", "key"}, {"*", "id"}, {"*", "_q"}, {"*", "alt"}, {"*", "iso4217"}, {"*", "iso3166"}, {"default", "type"}, {"measurementSystem", "type"}, {"mapping", "type"}, {"abbreviationFallback", "type"}, {"preferenceOrdering", "type"}, {"deprecatedItems", "iso3166"}};
    private static final Map distinguishingAttributeMap = CLDRFile.asMap(distinguishingData, true);
    private static final Map defaultSuppressionMap;
    transient CLDRFile resolvedVersion;
    private static final DistinguishedXPath distinguishedXPath;

    public String toString() {
        return "locked: " + this.locked + "\r\n" + this.dataSource;
    }

    public String toString(String regex) {
        return "locked: " + this.locked + " [" + regex + "]\r\n" + this.dataSource.toString(regex);
    }

    public CLDRFile setNonInheriting(boolean isSupplemental) {
        if (this.locked) {
            throw new UnsupportedOperationException("Attempt to modify locked object");
        }
        this.dataSource.setNonInheriting(isSupplemental);
        return this;
    }

    public boolean isNonInheriting() {
        return this.dataSource.isNonInheriting();
    }

    public CLDRFile(XMLSource dataSource, boolean resolved) {
        if (dataSource == null) {
            dataSource = new SimpleXMLSource(null, null);
        }
        if (resolved && !dataSource.isResolving()) {
            dataSource = dataSource.getResolving();
        }
        if (!resolved && dataSource.isResolving()) {
            throw new IllegalArgumentException("Can't create unresolved file from resolved one");
        }
        this.dataSource = dataSource;
    }

    public static CLDRFile make(String localeName) {
        CLDRFile result = new CLDRFile(null, false);
        result.dataSource.setLocaleID(localeName);
        return result;
    }

    public static CLDRFile makeSupplemental(String localeName) {
        CLDRFile result = new CLDRFile(null, false);
        result.dataSource.setLocaleID(localeName);
        result.setNonInheriting(true);
        return result;
    }

    public static CLDRFile make(String localeName, String dir, boolean includeDraft) {
        return CLDRFile.makeFromFile(dir + File.separator + localeName + ".xml", localeName, includeDraft);
    }

    public static CLDRFile makeFromFile(String fullFileName, String localeName, boolean includeDraft) {
        File f = new File(fullFileName);
        try {
            fullFileName = f.getCanonicalPath();
            if (DEBUG_LOGGING) {
                System.out.println("Parsing: " + fullFileName);
                Log.logln(LOG_PROGRESS, "Parsing: " + fullFileName);
            }
            FileInputStream fis = new FileInputStream(f);
            CLDRFile result = CLDRFile.make(fullFileName, localeName, fis, includeDraft);
            fis.close();
            return result;
        }
        catch (Exception e) {
            throw (IllegalArgumentException)new IllegalArgumentException("Can't read " + fullFileName).initCause(e);
        }
    }

    public static CLDRFile make(String fileName, String localeName, InputStream fis, boolean includeDraft) {
        try {
            fis = new StripUTF8BOMInputStream(fis);
            CLDRFile result = CLDRFile.make(localeName);
            MyDeclHandler DEFAULT_DECLHANDLER = new MyDeclHandler(result, includeDraft);
            XMLReader xmlReader = CLDRFile.createXMLReader(true);
            xmlReader.setContentHandler(DEFAULT_DECLHANDLER);
            xmlReader.setErrorHandler(DEFAULT_DECLHANDLER);
            xmlReader.setProperty("http://xml.org/sax/properties/lexical-handler", DEFAULT_DECLHANDLER);
            xmlReader.setProperty("http://xml.org/sax/properties/declaration-handler", DEFAULT_DECLHANDLER);
            InputSource is = new InputSource(fis);
            is.setSystemId(fileName);
            xmlReader.parse(is);
            if (DEFAULT_DECLHANDLER.isSupplemental < 0) {
                throw new IllegalArgumentException("root of file must be either ldml or supplementalData");
            }
            result.setNonInheriting(DEFAULT_DECLHANDLER.isSupplemental > 0);
            return result;
        }
        catch (SAXParseException e) {
            System.out.println(CLDRFile.showSAX(e));
            throw (IllegalArgumentException)new IllegalArgumentException("Can't read " + localeName).initCause(e);
        }
        catch (SAXException e) {
            throw (IllegalArgumentException)new IllegalArgumentException("Can't read " + localeName).initCause(e);
        }
        catch (IOException e) {
            throw (IllegalArgumentException)new IllegalArgumentException("Can't read " + localeName).initCause(e);
        }
    }

    public Object cloneAsThawed() {
        try {
            CLDRFile result = (CLDRFile)super.clone();
            result.locked = false;
            result.dataSource = (XMLSource)result.dataSource.cloneAsThawed();
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError("should never happen");
        }
    }

    public CLDRFile show() {
        Iterator it2 = this.iterator();
        while (it2.hasNext()) {
            String xpath = (String)it2.next();
            System.out.println(this.getFullXPath(xpath) + " =>\t" + this.getStringValue(xpath));
        }
        return this;
    }

    public CLDRFile write(PrintWriter pw) {
        XPathParts temp;
        String xpath;
        TreeSet orderedSet = new TreeSet(ldmlComparator);
        CollectionUtilities.addAll((Iterator)this.dataSource.iterator(), orderedSet);
        pw.println("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
        pw.println("<!DOCTYPE " + (this.isNonInheriting() ? SUPPLEMENTAL_NAME : "ldml") + " SYSTEM \"http://www.unicode.org/cldr/dtd/" + GEN_VERSION + "/ldml" + (this.isNonInheriting() ? "Supplemental" : "") + ".dtd\">");
        TreeSet<String> identitySet = new TreeSet<String>(ldmlComparator);
        if (!this.isNonInheriting()) {
            String ldml_identity = "//ldml/identity";
            if (orderedSet.size() > 0) {
                String firstPath = (String)orderedSet.iterator().next();
                String firstFullPath = this.getFullXPath(firstPath);
                XPathParts parts = new XPathParts(null, null).set(firstFullPath);
                ldml_identity = firstFullPath.indexOf("/identity") >= 0 ? parts.toString(2) : parts.toString(1) + "/identity";
            }
            identitySet.add(ldml_identity + "/version[@number=\"$Revision: 1.70 $\"]");
            identitySet.add(ldml_identity + "/generation[@date=\"$Date: 2006/07/20 21:37:53 $\"]");
            LocaleIDParser lip = new LocaleIDParser();
            lip.set(this.dataSource.getLocaleID());
            identitySet.add(ldml_identity + "/language[@type=\"" + lip.getLanguage() + "\"]");
            if (lip.getScript().length() != 0) {
                identitySet.add(ldml_identity + "/script[@type=\"" + lip.getScript() + "\"]");
            }
            if (lip.getRegion().length() != 0) {
                identitySet.add(ldml_identity + "/territory[@type=\"" + lip.getRegion() + "\"]");
            }
            String[] variants = lip.getVariants();
            for (int i = 0; i < variants.length; ++i) {
                identitySet.add(ldml_identity + "/variant[@type=\"" + variants[i] + "\"]");
            }
        }
        XPathParts.writeComment(pw, 0, this.dataSource.getXpathComments().getInitialComment(), false);
        XPathParts.Comments tempComments = (XPathParts.Comments)this.dataSource.getXpathComments().clone();
        MapComparator modAttComp = attributeOrdering;
        if (HACK_ORDER) {
            modAttComp = new MapComparator().add("alt").add("draft").add(modAttComp.getOrder());
        }
        XPathParts last = new XPathParts(attributeOrdering, defaultSuppressionMap);
        XPathParts current = new XPathParts(attributeOrdering, defaultSuppressionMap);
        XPathParts lastFiltered = new XPathParts(attributeOrdering, defaultSuppressionMap);
        XPathParts currentFiltered = new XPathParts(attributeOrdering, defaultSuppressionMap);
        Iterator it2 = identitySet.iterator();
        while (it2.hasNext()) {
            xpath = (String)it2.next();
            currentFiltered.set(xpath);
            current.set(xpath);
            current.writeDifference(pw, currentFiltered, last, lastFiltered, "", tempComments);
            temp = current;
            current = last;
            last = temp;
            temp = currentFiltered;
            currentFiltered = lastFiltered;
            lastFiltered = temp;
        }
        it2 = orderedSet.iterator();
        while (it2.hasNext()) {
            xpath = (String)it2.next();
            currentFiltered.set(xpath);
            if (currentFiltered.getElement(1).equals("identity")) continue;
            current.set(this.getFullXPath(xpath));
            current.writeDifference(pw, currentFiltered, last, lastFiltered, this.getStringValue(xpath), tempComments);
            temp = current;
            current = last;
            last = temp;
            temp = currentFiltered;
            currentFiltered = lastFiltered;
            lastFiltered = temp;
        }
        current.clear().writeDifference(pw, null, last, lastFiltered, null, tempComments);
        String finalComment = this.dataSource.getXpathComments().getFinalComment();
        List x = tempComments.extractCommentsWithoutBase();
        if (x.size() != 0) {
            String extras = "Comments without bases\n";
            Iterator it = x.iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                extras = extras + "\n" + key;
            }
            finalComment = finalComment + "\n" + extras;
        }
        XPathParts.writeComment(pw, 0, finalComment, true);
        return this;
    }

    public String getStringValue(String xpath) {
        return this.dataSource.getValueAtPath(xpath);
    }

    public String getFullXPath(String xpath) {
        return this.dataSource.getFullPath(xpath);
    }

    public String getSourceLocaleID(String xpath, Status status) {
        return this.dataSource.getSourceLocaleID(xpath, status);
    }

    public CLDRFile add(String currentFullXPath, String value) {
        if (this.locked) {
            throw new UnsupportedOperationException("Attempt to modify locked object");
        }
        Log.logln(LOG_PROGRESS, "ADDING: \t" + currentFullXPath + " \t" + value + "\t" + currentFullXPath);
        try {
            this.dataSource.putValueAtPath(currentFullXPath, value);
        }
        catch (RuntimeException e) {
            throw (IllegalArgumentException)new IllegalArgumentException("failed adding " + currentFullXPath + ",\t" + value).initCause(e);
        }
        return this;
    }

    public CLDRFile addComment(String xpath, String comment, int type) {
        if (this.locked) {
            throw new UnsupportedOperationException("Attempt to modify locked object");
        }
        Log.logln(LOG_PROGRESS, "ADDING Comment: \t" + type + "\t" + xpath + " \t" + comment);
        if (xpath == null || xpath.length() == 0) {
            this.dataSource.getXpathComments().setFinalComment(Utility.joinWithSeparation(this.dataSource.getXpathComments().getFinalComment(), "\n", comment));
        } else {
            xpath = CLDRFile.getDistinguishingXPath(xpath, null, false);
            this.dataSource.getXpathComments().addComment(type, xpath, comment);
        }
        return this;
    }

    public CLDRFile putAll(CLDRFile other, int conflict_resolution) {
        if (this.locked) {
            throw new UnsupportedOperationException("Attempt to modify locked object");
        }
        XPathParts parts = new XPathParts(null, null);
        if (conflict_resolution == 0) {
            TreeMap temp = this.isNonInheriting() ? new TreeMap() : new TreeMap(ldmlComparator);
            this.dataSource.putAll(other.dataSource, 0);
        } else if (conflict_resolution == 1) {
            this.dataSource.putAll(other.dataSource, 1);
        } else if (conflict_resolution == 3) {
            String cpath;
            HashSet<String> hasDraftVersion = new HashSet<String>();
            Iterator it = this.dataSource.iterator();
            while (it.hasNext()) {
                cpath = (String)it.next();
                String fullpath = this.getFullXPath(cpath);
                if (fullpath.indexOf("[@draft") < 0) continue;
                hasDraftVersion.add(CLDRFile.getNondraftNonaltXPath(cpath));
            }
            it = other.iterator();
            while (it.hasNext()) {
                cpath = (String)it.next();
                cpath = CLDRFile.getNondraftNonaltXPath(cpath);
                String newValue = other.getStringValue(cpath);
                String newFullPath = CLDRFile.getNondraftNonaltXPath(other.getFullXPath(cpath));
                newFullPath = this.addReferencesIfNeeded(newFullPath, this.getFullXPath(cpath));
                if (!hasDraftVersion.contains(cpath)) {
                    if (cpath.startsWith("//ldml/identity/")) continue;
                    String myVersion = this.getStringValue(cpath);
                    if (myVersion == null || !newValue.equals(myVersion)) {
                        Log.logln(this.getLocaleID() + "\tDenied attempt to replace non-draft\r\n\tcurr: [" + cpath + ",\t" + myVersion + "]\r\n\twith: [" + newValue + "]");
                        continue;
                    }
                }
                Log.logln(this.getLocaleID() + "\tVETTED: [" + newFullPath + ",\t" + newValue + "]");
                this.dataSource.putValueAtPath(newFullPath, newValue);
            }
        } else if (conflict_resolution == 2) {
            Iterator it = other.iterator();
            block2: while (it.hasNext()) {
                String key = (String)it.next();
                String otherValue = other.getStringValue(key);
                String myValue = this.dataSource.getValueAtPath(key);
                if (myValue == null) {
                    this.dataSource.putValueAtPath(other.getFullXPath(key), otherValue);
                    continue;
                }
                if (myValue.equals(otherValue) && CLDRFile.equalsIgnoringDraft(this.getFullXPath(key), other.getFullXPath(key)) || key.startsWith("//ldml/identity")) continue;
                int i = 0;
                while (true) {
                    String prop = "proposed" + (i == 0 ? "" : String.valueOf(i));
                    String fullPath = parts.set(other.getFullXPath(key)).addAttribute("alt", prop).toString();
                    String path = CLDRFile.getDistinguishingXPath(fullPath, null, false);
                    if (this.dataSource.getValueAtPath(path) == null) {
                        this.dataSource.putValueAtPath(fullPath, otherValue);
                        continue block2;
                    }
                    ++i;
                }
            }
        } else {
            throw new IllegalArgumentException("Illegal operand: " + conflict_resolution);
        }
        this.dataSource.getXpathComments().setInitialComment(Utility.joinWithSeparation(this.dataSource.getXpathComments().getInitialComment(), "\n", other.dataSource.getXpathComments().getInitialComment()));
        this.dataSource.getXpathComments().setFinalComment(Utility.joinWithSeparation(this.dataSource.getXpathComments().getFinalComment(), "\n", other.dataSource.getXpathComments().getFinalComment()));
        this.dataSource.getXpathComments().joinAll(other.dataSource.getXpathComments());
        return this;
    }

    private String addReferencesIfNeeded(String newFullPath, String fullXPath) {
        String references;
        Map attributes;
        if (fullXPath == null || fullXPath.indexOf("[@references=") < 0) {
            return newFullPath;
        }
        XPathParts parts = new XPathParts(null, null).set(fullXPath);
        String accummulatedReferences = null;
        for (int i = 0; i < parts.size(); ++i) {
            attributes = parts.getAttributes(i);
            references = (String)attributes.get("references");
            if (references == null) continue;
            accummulatedReferences = accummulatedReferences == null ? references : accummulatedReferences + ", " + references;
        }
        if (accummulatedReferences == null) {
            return newFullPath;
        }
        XPathParts newParts = new XPathParts(null, null).set(newFullPath);
        attributes = newParts.getAttributes(newParts.size() - 1);
        references = (String)attributes.get("references");
        references = references == null ? accummulatedReferences : references + ", " + accummulatedReferences;
        attributes.put("references", references);
        System.out.println("Changing " + newFullPath + " plus " + fullXPath + " to " + newParts.toString());
        return newParts.toString();
    }

    public CLDRFile remove(String xpath) {
        this.remove(xpath, false);
        return this;
    }

    public CLDRFile remove(String xpath, boolean butComment) {
        if (this.locked) {
            throw new UnsupportedOperationException("Attempt to modify locked object");
        }
        if (butComment) {
            this.appendFinalComment(this.dataSource.getFullPath(xpath) + "::<" + this.dataSource.getValueAtPath(xpath) + ">");
        }
        this.dataSource.removeValueAtPath(xpath);
        return this;
    }

    public CLDRFile removeAll(Set xpaths, boolean butComment) {
        if (butComment) {
            this.appendFinalComment("Illegal attributes removed:");
        }
        Iterator it = xpaths.iterator();
        while (it.hasNext()) {
            this.remove((String)it.next(), butComment);
        }
        return this;
    }

    public CLDRFile removeDuplicates(CLDRFile other, boolean butComment, Map keepList) {
        if (this.locked) {
            throw new UnsupportedOperationException("Attempt to modify locked object");
        }
        boolean first = true;
        Iterator it = other.iterator();
        while (it.hasNext()) {
            String otherFullXPath;
            String currentFullXPath;
            String keepValue;
            String otherValue;
            String xpath = (String)it.next();
            String currentValue = this.dataSource.getValueAtPath(xpath);
            if (currentValue == null || !currentValue.equals(otherValue = other.dataSource.getValueAtPath(xpath)) || (keepValue = (String)keepList.get(xpath)) != null && keepValue.equals(currentValue) || !CLDRFile.equalsIgnoringDraft(currentFullXPath = this.dataSource.getFullPath(xpath), otherFullXPath = other.dataSource.getFullPath(xpath))) continue;
            if (first) {
                first = false;
                if (butComment) {
                    this.appendFinalComment("Duplicates removed:");
                }
            }
            this.remove(xpath, butComment);
        }
        return this;
    }

    public String getFinalComment() {
        return this.dataSource.getXpathComments().getFinalComment();
    }

    public String getInitialComment() {
        return this.dataSource.getXpathComments().getInitialComment();
    }

    public XPathParts.Comments getXpath_comments() {
        return (XPathParts.Comments)this.dataSource.getXpathComments().clone();
    }

    public String getLocaleID() {
        return this.dataSource.getLocaleID();
    }

    public synchronized boolean isFrozen() {
        return this.locked;
    }

    public synchronized Object freeze() {
        this.locked = true;
        this.dataSource.freeze();
        return this;
    }

    public CLDRFile clearComments() {
        if (this.locked) {
            throw new UnsupportedOperationException("Attempt to modify locked object");
        }
        this.dataSource.setXpathComments(new XPathParts.Comments());
        return this;
    }

    public CLDRFile setFinalComment(String comment) {
        if (this.locked) {
            throw new UnsupportedOperationException("Attempt to modify locked object");
        }
        this.dataSource.getXpathComments().setFinalComment(comment);
        return this;
    }

    public CLDRFile appendFinalComment(String comment) {
        if (this.locked) {
            throw new UnsupportedOperationException("Attempt to modify locked object");
        }
        this.dataSource.getXpathComments().setFinalComment(Utility.joinWithSeparation(this.dataSource.getXpathComments().getFinalComment(), "\n", comment));
        return this;
    }

    public CLDRFile setInitialComment(String comment) {
        if (this.locked) {
            throw new UnsupportedOperationException("Attempt to modify locked object");
        }
        this.dataSource.getXpathComments().setInitialComment(comment);
        return this;
    }

    public static Set getMatchingXMLFiles(String sourceDir, Matcher m) {
        TreeSet<String> s = new TreeSet<String>();
        File[] files = new File(sourceDir).listFiles();
        for (int i = 0; i < files.length; ++i) {
            String locale;
            String name = files[i].getName();
            if (!name.endsWith(".xml") || !m.reset(locale = name.substring(0, name.length() - 4)).matches()) continue;
            s.add(locale);
        }
        return s;
    }

    public Iterator iterator() {
        return this.dataSource.iterator();
    }

    public Iterator iterator(String prefix) {
        return this.dataSource.iterator(prefix);
    }

    public Iterator iterator(String prefix, Comparator comparator) {
        Iterator it;
        Iterator iterator = it = prefix == null || prefix.length() == 0 ? this.dataSource.iterator() : this.dataSource.iterator(prefix);
        if (comparator == null) {
            return it;
        }
        TreeSet orderedSet = new TreeSet(ldmlComparator);
        CollectionUtilities.addAll((Iterator)it, orderedSet);
        return orderedSet.iterator();
    }

    public static String getDistinguishingXPath(String xpath, String[] normalizedPath, boolean nonInheriting) {
        return DistinguishedXPath.getDistinguishingXPath(xpath, normalizedPath, nonInheriting);
    }

    private static boolean equalsIgnoringDraft(String path1, String path2) {
        if (path1.indexOf("[@draft=") < 0 && path2.indexOf("[@draft=") < 0) {
            return path1.equals(path2);
        }
        return CLDRFile.getNondraftNonaltXPath(path1).equals(CLDRFile.getNondraftNonaltXPath(path2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getNondraftNonaltXPath(String xpath) {
        if (xpath.indexOf("draft=\"") < 0 && xpath.indexOf("alt=\"") < 0) {
            return xpath;
        }
        XPathParts xPathParts = nondraftParts;
        synchronized (xPathParts) {
            XPathParts parts = new XPathParts(null, null).set(xpath);
            for (int i = 0; i < parts.size(); ++i) {
                String element = parts.getElement(i);
                Map attributes = parts.getAttributes(i);
                String restore = null;
                Iterator it = attributes.keySet().iterator();
                while (it.hasNext()) {
                    String value;
                    int proposedPos;
                    String attribute = (String)it.next();
                    if (attribute.equals("draft")) {
                        it.remove();
                        continue;
                    }
                    if (!attribute.equals("alt") || (proposedPos = (value = (String)attributes.get(attribute)).indexOf("proposed")) < 0) continue;
                    it.remove();
                    if (proposedPos <= 0) continue;
                    restore = value.substring(0, proposedPos - 1);
                }
                if (restore == null) continue;
                attributes.put("alt", restore);
            }
            return parts.toString();
        }
    }

    public static boolean isDistinguishing(String elementName, String attribute) {
        boolean result = attribute.equals("key") || attribute.equals("request") || attribute.equals("id") || attribute.equals("_q") || attribute.equals("registry") || attribute.equals("alt") || attribute.equals("iso4217") || attribute.equals("iso3166") || attribute.equals("type") && !elementName.equals("default") && !elementName.equals("measurementSystem") && !elementName.equals("mapping") && !elementName.equals("abbreviationFallback") && !elementName.equals("preferenceOrdering") || elementName.equals("deprecatedItems");
        return result;
    }

    public static XMLReader createXMLReader(boolean validating) {
        String[] testList = new String[]{"org.apache.xerces.parsers.SAXParser", "org.apache.crimson.parser.XMLReaderImpl", "gnu.xml.aelfred2.XmlReader", "com.bluecast.xml.Piccolo", "oracle.xml.parser.v2.SAXParser", ""};
        XMLReader result = null;
        for (int i = 0; i < testList.length; ++i) {
            try {
                result = testList[i].length() != 0 ? XMLReaderFactory.createXMLReader(testList[i]) : XMLReaderFactory.createXMLReader();
                result.setFeature("http://xml.org/sax/features/validation", validating);
                break;
            }
            catch (SAXException e1) {
                continue;
            }
        }
        if (result == null) {
            throw new NoClassDefFoundError("No SAX parser is available, or unable to set validation correctly");
        }
        try {
            result.setEntityResolver(new CachingEntityResolver());
        }
        catch (Throwable e) {
            System.err.println("WARNING: Can't set caching entity resolver  -  error " + e.toString());
            e.printStackTrace();
        }
        return result;
    }

    public static boolean isSupplementalName(String localeName) {
        return localeName.startsWith(SUPPLEMENTAL_PREFIX) || localeName.equals("characters");
    }

    public static String showSAX(SAXParseException exception) {
        return exception.getMessage() + ";\t SystemID: " + exception.getSystemId() + ";\t PublicID: " + exception.getPublicId() + ";\t LineNumber: " + exception.getLineNumber() + ";\t ColumnNumber: " + exception.getColumnNumber();
    }

    /*
     * WARNING - void declaration
     */
    private CLDRFile fixAliases(Factory factory, boolean includeDraft) {
        ArrayList<String> aliases = new ArrayList<String>();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            String xpath = (String)it.next();
            if (xpath.indexOf("/alias") < 0) continue;
            aliases.add(xpath);
        }
        if (aliases.size() == 0) {
            return this;
        }
        XPathParts parts = new XPathParts(attributeOrdering, defaultSuppressionMap);
        XPathParts fullParts = new XPathParts(attributeOrdering, defaultSuppressionMap);
        XPathParts otherParts = new XPathParts(attributeOrdering, defaultSuppressionMap);
        Iterator it2 = aliases.iterator();
        while (it2.hasNext()) {
            void var13_13;
            CLDRFile other;
            String xpathKey = (String)it2.next();
            if (SHOW_ALIAS_FIXES) {
                System.out.println("Doing Alias for: " + xpathKey);
            }
            parts.set(xpathKey);
            int index = parts.findElement("alias");
            if (index < 0) continue;
            parts.trimLast();
            fullParts.set(this.dataSource.getFullPath(xpathKey));
            Map attributes = fullParts.getAttributes(index);
            fullParts.trimLast();
            String source = (String)attributes.get("source");
            if (source == null || source.equals("locale")) {
                source = this.dataSource.getLocaleID();
            }
            otherParts.set(parts);
            String otherPath = (String)attributes.get("path");
            if (otherPath != null) {
                otherParts.addRelative(otherPath);
            }
            if (source.equals(this.dataSource.getLocaleID())) {
                other = this;
            } else {
                try {
                    other = factory.make(source, true, includeDraft);
                }
                catch (RuntimeException e) {
                    System.err.println("Bad alias");
                    e.printStackTrace();
                    throw e;
                }
            }
            this.addChildren(parts, fullParts, (CLDRFile)var13_13, otherParts);
        }
        return this;
    }

    private CLDRFile addChildren(XPathParts parts, XPathParts fullParts, CLDRFile other, XPathParts otherParts) {
        String otherPath = otherParts + "/";
        XPathParts temp = new XPathParts(attributeOrdering, defaultSuppressionMap);
        XPathParts fullTemp = new XPathParts(attributeOrdering, defaultSuppressionMap);
        HashMap<String, String> stuffToAdd = new HashMap<String, String>();
        Iterator it = other.iterator();
        while (it.hasNext()) {
            String path = (String)it.next();
            if (!path.startsWith(otherPath)) continue;
            fullTemp.set(other.dataSource.getFullPath(path));
            fullTemp.replace(otherParts.size(), fullParts);
            String newPath = fullTemp.toString();
            String value = this.dataSource.getValueAtPath(path);
            if (SHOW_ALIAS_FIXES) {
                System.out.println("Adding*: " + path + ";\r\n\t" + newPath + ";\r\n\t" + this.dataSource.getValueAtPath(path));
            }
            stuffToAdd.put(newPath, value);
        }
        this.dataSource.putAll(stuffToAdd, 1);
        return this;
    }

    private CLDRFile removeChildren(XPathParts parts) {
        String mypath = parts + "/";
        HashSet<String> temp = new HashSet<String>();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            String path = (String)it.next();
            if (!path.startsWith(mypath)) continue;
            temp.add(path);
        }
        this.dataSource.removeAll(temp);
        return this;
    }

    public boolean isDraft() {
        String item = (String)this.iterator().next();
        return item.startsWith("//ldml[@draft=\"unconfirmed\"]");
    }

    public static int getNameType(String xpath) {
        for (int i = 0; i < NameTable.length; ++i) {
            if (!xpath.startsWith(NameTable[i][0]) || xpath.indexOf(NameTable[i][1], NameTable[i][0].length()) < 0) continue;
            return i;
        }
        return -1;
    }

    public static String getNameTypeName(int index) {
        try {
            return CLDRFile.getNameName(index);
        }
        catch (Exception e) {
            return "Illegal Type Name: " + index;
        }
    }

    public static String getKey(int type, String code) {
        return NameTable[type][0] + code + NameTable[type][1];
    }

    public static String getCode(String path) {
        int type = CLDRFile.getNameType(path);
        if (type < 0) {
            throw new IllegalArgumentException("Illegal type in path: " + path);
        }
        int start = NameTable[type][0].length();
        int end = path.indexOf(NameTable[type][1], start);
        return path.substring(start, end);
    }

    public String getName(int type, String code, boolean skipDraft) {
        String path = CLDRFile.getKey(type, code);
        if (skipDraft && this.dataSource.isDraft(path)) {
            return null;
        }
        return this.getStringValue(path);
    }

    public String getName(String type, String code, boolean skipDraft) {
        return this.getName(CLDRFile.typeNameToCode(type), code, skipDraft);
    }

    public static int typeNameToCode(String type) {
        for (int i = 0; i < 13; ++i) {
            if (!type.equalsIgnoreCase(CLDRFile.getNameName(i))) continue;
            return i;
        }
        return -1;
    }

    public synchronized String getName(String localeOrTZID, boolean skipDraft) {
        String sname;
        this.lparser.set(localeOrTZID);
        String original = this.lparser.getLanguage();
        String name = this.getName(0, original, skipDraft);
        if (name == null) {
            name = original;
        }
        if ((sname = (original = this.lparser.getScript())).length() != 0) {
            sname = this.getName(1, sname, skipDraft);
            name = name + " - " + (sname == null ? original : sname);
        }
        String extras = "";
        original = sname = this.lparser.getRegion();
        if (sname.length() != 0) {
            if (extras.length() != 0) {
                extras = extras + ", ";
            }
            sname = this.getName(2, sname, skipDraft);
            extras = extras + (sname == null ? original : sname);
        }
        List variants = this.lparser.getVariants();
        for (int i = 0; i < variants.size(); ++i) {
            if (extras.length() != 0) {
                extras = extras + ", ";
            }
            original = (String)variants.get(i);
            sname = this.getName(3, original, skipDraft);
            extras = extras + (sname == null ? original : sname);
        }
        return name + (extras.length() == 0 ? "" : " (" + extras + ")");
    }

    public static String getNameName(int choice) {
        return NameTable[choice][2];
    }

    public static Collection getElementOrder() {
        return elementOrdering.getOrder();
    }

    public static Collection getAttributeOrder() {
        return attributeOrdering.getOrder();
    }

    public static Comparator getAttributeComparator() {
        return attributeOrdering;
    }

    public static Collection getValueOrder() {
        return valueOrdering.getOrder();
    }

    public static String getParent(String localeName) {
        int pos = localeName.lastIndexOf(95);
        if (pos >= 0) {
            return localeName.substring(0, pos);
        }
        if (localeName.equals("root") || localeName.equals(SUPPLEMENTAL_NAME)) {
            return null;
        }
        return "root";
    }

    public static Comparator getAttributeValueComparator(String element, String attribute) {
        Comparator comp = valueOrdering;
        if (attribute.equals("day")) {
            comp = dayValueOrder;
        } else if (attribute.equals("type")) {
            if (element.endsWith("FormatLength")) {
                comp = lengthOrder;
            } else if (element.endsWith("Width")) {
                comp = widthOrder;
            } else if (element.equals("day")) {
                comp = dayValueOrder;
            } else if (element.equals("field")) {
                comp = dateFieldOrder;
            } else if (element.equals("zone")) {
                comp = zoneOrder;
            }
        }
        return comp;
    }

    private static boolean matches(Map map, Object[] items, boolean doStar) {
        for (int i = 0; i < items.length - 2; ++i) {
            Map tempMap = (Map)map.get(items[i]);
            if (doStar && map == null) {
                map = (Map)map.get("*");
            }
            if (map == null) {
                return false;
            }
            map = tempMap;
        }
        return map.get(items[items.length - 2]) == items[items.length - 1];
    }

    private static Map asMap(String[][] data, boolean tree) {
        AbstractMap tempmain = tree ? new TreeMap() : new HashMap();
        int len = data[0].length;
        for (int i = 0; i < data.length; ++i) {
            AbstractMap temp = tempmain;
            if (len != data[i].length) {
                throw new IllegalArgumentException("Must be square array: fails row " + i);
            }
            for (int j = 0; j < len - 2; ++j) {
                AbstractMap newTemp = (AbstractMap)temp.get(data[i][j]);
                if (newTemp == null) {
                    newTemp = tree ? new TreeMap() : new HashMap();
                    temp.put(data[i][j], newTemp);
                }
                temp = newTemp;
            }
            temp.put(data[i][len - 2], data[i][len - 1]);
        }
        return tempmain;
    }

    public CLDRFile removeComment(String string) {
        if (this.locked) {
            throw new UnsupportedOperationException("Attempt to modify locked object");
        }
        this.dataSource.getXpathComments().removeComment(string);
        return this;
    }

    public CLDRFile makeDraft() {
        if (this.locked) {
            throw new UnsupportedOperationException("Attempt to modify locked object");
        }
        XPathParts parts = new XPathParts(null, null);
        Iterator it = this.dataSource.iterator();
        while (it.hasNext()) {
            String path = (String)it.next();
            parts.set(this.dataSource.getFullPath(path)).addAttribute("draft", "unconfirmed");
            this.dataSource.putValueAtPath(parts.toString(), this.dataSource.getValueAtPath(path));
        }
        return this;
    }

    public UnicodeSet getExemplarSet(String type) {
        String v;
        if (type.length() != 0) {
            type = "[@type=\"" + type + "\"]";
        }
        if ((v = this.getStringValue("//ldml/characters/exemplarCharacters" + type)) == null) {
            return null;
        }
        UnicodeSet result = new UnicodeSet(v, 2);
        result.remove(32);
        return result;
    }

    public CLDRFile getResolved() {
        if (this.dataSource.isResolving()) {
            return this;
        }
        if (this.resolvedVersion == null) {
            this.resolvedVersion = new CLDRFile(this.dataSource, true);
        }
        return this.resolvedVersion;
    }

    public Set getAvailableLocales() {
        return this.dataSource.getAvailableLocales();
    }

    public CLDRFile make(String locale, boolean resolved) {
        if (this.dataSource == null) {
            throw new UnsupportedOperationException("Make not supported");
        }
        return new CLDRFile(this.dataSource.make(locale), resolved);
    }

    public static final String distinguishedXPathStats() {
        return distinguishedXPath.stats();
    }

    public static boolean isLOG_PROGRESS() {
        return LOG_PROGRESS;
    }

    public static void setLOG_PROGRESS(boolean log_progress) {
        LOG_PROGRESS = log_progress;
    }

    public boolean isEmpty() {
        return !this.dataSource.iterator().hasNext();
    }

    public Map getNonDistinguishingAttributes(String fullPath, Map result, Set skipList) {
        return distinguishedXPath.getNonDistinguishingAttributes(fullPath, result, skipList);
    }

    public String getDtdVersion() {
        return this.dtdVersion;
    }

    public String getStringValue(String path, boolean ignoreOtherLeafAttributes) {
        String result = this.getStringValue(path);
        if (result != null) {
            return result;
        }
        XPathParts parts = new XPathParts().set(path);
        Map lastAttributes = parts.getAttributes(parts.size() - 1);
        XPathParts other = new XPathParts();
        String base = parts.toString(parts.size() - 1) + "/" + parts.getElement(parts.size() - 1);
        Iterator it = this.iterator(base);
        while (it.hasNext()) {
            Map lastOtherAttributes;
            String otherPath = (String)it.next();
            other.set(otherPath);
            if (other.size() != parts.size() || !this.contains(lastOtherAttributes = other.getAttributes(other.size() - 1), lastAttributes)) continue;
            if (result == null) {
                result = this.getStringValue(otherPath);
                continue;
            }
            throw new IllegalArgumentException("Multiple values for path: " + path);
        }
        return result;
    }

    private boolean contains(Map a, Map b) {
        Iterator it = b.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            Object otherValue = a.get(key);
            if (otherValue == null) {
                return false;
            }
            Object value = b.get(key);
            if (otherValue.equals(value)) continue;
            return false;
        }
        return true;
    }

    public String getFullXPath(String path, boolean ignoreOtherLeafAttributes) {
        String result = this.getFullXPath(path);
        if (result != null) {
            return result;
        }
        XPathParts parts = new XPathParts().set(path);
        Map lastAttributes = parts.getAttributes(parts.size() - 1);
        XPathParts other = new XPathParts();
        String base = parts.toString(parts.size() - 1) + "/" + parts.getElement(parts.size() - 1);
        Iterator it = this.iterator(base);
        while (it.hasNext()) {
            Map lastOtherAttributes;
            String otherPath = (String)it.next();
            other.set(otherPath);
            if (other.size() != parts.size() || !this.contains(lastOtherAttributes = other.getAttributes(other.size() - 1), lastAttributes)) continue;
            if (result == null) {
                result = this.getFullXPath(otherPath);
                continue;
            }
            throw new IllegalArgumentException("Multiple values for path: " + path);
        }
        return result;
    }

    static {
        String[][] data = new String[][]{{"ldml", "version", GEN_VERSION}, {"orientation", "characters", "left-to-right"}, {"orientation", "lines", "top-to-bottom"}, {"weekendStart", "time", "00:00"}, {"weekendEnd", "time", "24:00"}, {"dateFormat", "type", "standard"}, {"timeFormat", "type", "standard"}, {"dateTimeFormat", "type", "standard"}, {"decimalFormat", "type", "standard"}, {"scientificFormat", "type", "standard"}, {"percentFormat", "type", "standard"}, {"currencyFormat", "type", "standard"}, {"pattern", "type", "standard"}, {"currency", "type", "standard"}, {"collation", "type", "standard"}, {"transform", "visibility", "external"}, {"*", "_q", "*"}};
        Map tempmain = CLDRFile.asMap(data, true);
        defaultSuppressionMap = Collections.unmodifiableMap(tempmain);
        distinguishedXPath = new DistinguishedXPath();
    }

    public static class Status {
        public String pathWhereFound;
    }

    private static class DistinguishedXPath {
        private static Map distinguishingMap = new HashMap();
        private static Map normalizedPathMap = new HashMap();
        private static XPathParts distinguishingParts = new XPathParts(attributeOrdering, null);

        private DistinguishedXPath() {
        }

        public static final String stats() {
            return "distinguishingMap:" + distinguishingMap.size() + " " + "normalizedPathMap:" + normalizedPathMap.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static String getDistinguishingXPath(String xpath, String[] normalizedPath, boolean nonInheriting) {
            Map map = distinguishingMap;
            synchronized (map) {
                String result = (String)distinguishingMap.get(xpath);
                if (result == null) {
                    String element;
                    Map attributes;
                    int i;
                    distinguishingParts.set(xpath);
                    boolean inheriting = distinguishingParts.getElement(0).equals("ldml");
                    String draft = null;
                    String alt = null;
                    String references = "";
                    for (i = 0; i < distinguishingParts.size() - 1; ++i) {
                        attributes = distinguishingParts.getAttributes(i);
                        Iterator it = attributes.keySet().iterator();
                        while (it.hasNext()) {
                            String attribute = (String)it.next();
                            if (attribute.equals("draft")) {
                                draft = (String)attributes.get(attribute);
                                it.remove();
                                continue;
                            }
                            if (attribute.equals("alt")) {
                                alt = (String)attributes.get(attribute);
                                it.remove();
                                continue;
                            }
                            if (!attribute.equals("references")) continue;
                            if (references.length() != 0) {
                                references = references + " ";
                            }
                            references = references + (String)attributes.get("references");
                            it.remove();
                        }
                    }
                    if (draft != null || alt != null || references.length() != 0) {
                        String newXPath;
                        int placementIndex = distinguishingParts.size() - 1;
                        while (orderedElements.contains(element = distinguishingParts.getElement(placementIndex))) {
                            --placementIndex;
                        }
                        attributes = distinguishingParts.getAttributes(placementIndex);
                        if (draft != null) {
                            attributes.put("draft", draft);
                        }
                        if (alt != null) {
                            attributes.put("alt", alt);
                        }
                        if (references.length() != 0) {
                            attributes.put("references", references);
                        }
                        if (!(newXPath = distinguishingParts.toString()).equals(xpath)) {
                            normalizedPathMap.put(xpath, newXPath);
                        }
                    }
                    if (inheriting) {
                        for (i = 0; i < distinguishingParts.size(); ++i) {
                            element = distinguishingParts.getElement(i);
                            Map attributes2 = distinguishingParts.getAttributes(i);
                            Iterator it = attributes2.keySet().iterator();
                            while (it.hasNext()) {
                                String attribute = (String)it.next();
                                if (CLDRFile.isDistinguishing(element, attribute)) continue;
                                it.remove();
                            }
                        }
                    }
                    result = distinguishingParts.toString();
                    distinguishingMap.put(xpath, result);
                }
                if (normalizedPath != null) {
                    normalizedPath[0] = (String)normalizedPathMap.get(xpath);
                    if (normalizedPath[0] == null) {
                        normalizedPath[0] = xpath;
                    }
                }
                return result;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map getNonDistinguishingAttributes(String fullPath, Map result, Set skipList) {
            if (result == null) {
                result = new LinkedHashMap();
            } else {
                result.clear();
            }
            Map map = distinguishingMap;
            synchronized (map) {
                distinguishingParts.set(fullPath);
                for (int i = 0; i < distinguishingParts.size(); ++i) {
                    String element = distinguishingParts.getElement(i);
                    Map attributes = distinguishingParts.getAttributes(i);
                    Iterator it = attributes.keySet().iterator();
                    while (it.hasNext()) {
                        String attribute = (String)it.next();
                        if (CLDRFile.isDistinguishing(element, attribute) || skipList.contains(attribute)) continue;
                        result.put(attribute, attributes.get(attribute));
                    }
                }
            }
            return result;
        }
    }

    static class LDMLComparator
    implements Comparator {
        transient XPathParts a = new XPathParts(attributeOrdering, null);
        transient XPathParts b = new XPathParts(attributeOrdering, null);
        transient Set attSet1 = new TreeSet(attributeOrdering);
        transient Set attSet2 = new TreeSet(attributeOrdering);

        LDMLComparator() {
        }

        public void addElement(String a) {
        }

        public void addAttribute(String a) {
        }

        public void addValue(String a) {
        }

        public int compare(Object o1, Object o2) {
            if (o1 == o2) {
                return 0;
            }
            this.a.set((String)o1);
            this.b.set((String)o2);
            int minSize = this.a.size();
            if (this.b.size() < minSize) {
                minSize = this.b.size();
            }
            for (int i = 0; i < minSize; ++i) {
                String bname;
                String aname = this.a.getElement(i);
                int result = elementOrdering.compare(aname, bname = this.b.getElement(i));
                if (0 != result) {
                    boolean aOrdered = orderedElements.contains(aname);
                    boolean bOrdered = orderedElements.contains(bname);
                    if (!aOrdered || !bOrdered) {
                        if (aOrdered == bOrdered) {
                            return result;
                        }
                        return aOrdered ? 1 : 0;
                    }
                }
                Map am = this.a.getAttributes(i);
                Map bm = this.b.getAttributes(i);
                int minMapSize = am.size();
                if (bm.size() < minMapSize) {
                    minMapSize = bm.size();
                }
                if (minMapSize != 0) {
                    Iterator ait = am.keySet().iterator();
                    Iterator bit = bm.keySet().iterator();
                    for (int j = 0; j < minMapSize; ++j) {
                        String bkey;
                        String akey = (String)ait.next();
                        result = attributeOrdering.compare(akey, bkey = (String)bit.next());
                        if (0 != result) {
                            return result;
                        }
                        String avalue = (String)am.get(akey);
                        String bvalue = (String)bm.get(bkey);
                        Comparator comp = CLDRFile.getAttributeValueComparator(aname, akey);
                        result = comp.compare(avalue, bvalue);
                        if (0 == result) continue;
                        return result;
                    }
                }
                if (am.size() < bm.size()) {
                    return -1;
                }
                if (am.size() <= bm.size()) continue;
                return 1;
            }
            if (this.a.size() < this.b.size()) {
                return -1;
            }
            if (this.a.size() > this.b.size()) {
                return 1;
            }
            return 0;
        }
    }

    private static class MyDeclHandler
    implements DeclHandler,
    ContentHandler,
    LexicalHandler,
    ErrorHandler {
        private static UnicodeSet whitespace = new UnicodeSet("[:whitespace:]");
        private boolean includeDraft;
        private static final boolean SHOW_START_END = false;
        private int commentStack;
        private boolean justPopped = false;
        private String lastChars = "";
        private String currentFullXPath = "/";
        private String comment = null;
        private Map attributeOrder = new TreeMap(attributeOrdering);
        private CLDRFile target;
        private String lastActiveLeafNode;
        private String lastLeafNode;
        private int isSupplemental = -1;
        private int orderedCounter;
        private static Set changedTypes = new HashSet<String>(Arrays.asList("abbreviationFallback", "default", "mapping", "measurementSystem", "preferenceOrdering"));
        static final char XML_LINESEPARATOR = '\n';
        static final String XML_LINESEPARATOR_STRING = String.valueOf('\n');

        MyDeclHandler(CLDRFile target, boolean includeDraft) {
            this.target = target;
            this.includeDraft = includeDraft;
        }

        private String show(Attributes attributes) {
            if (attributes == null) {
                return "null";
            }
            String result = "";
            for (int i = 0; i < attributes.getLength(); ++i) {
                String attribute = attributes.getQName(i);
                String value = attributes.getValue(i);
                result = result + "[@" + attribute + "=\"" + value + "\"]";
            }
            return result;
        }

        private void push(String qName, Attributes attributes) {
            Log.logln(LOG_PROGRESS, "push\t" + qName + "\t" + this.show(attributes));
            if (this.lastChars.length() != 0) {
                if (whitespace.containsAll(this.lastChars)) {
                    this.lastChars = "";
                } else {
                    throw new IllegalArgumentException("Internal Error");
                }
            }
            this.currentFullXPath = this.currentFullXPath + "/" + qName;
            if (orderedElements.contains(qName)) {
                this.currentFullXPath = this.currentFullXPath + "[@_q=\"" + this.orderedCounter++ + "\"]";
            }
            if (attributes.getLength() > 0) {
                String value;
                String attribute;
                this.attributeOrder.clear();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    attribute = attributes.getQName(i);
                    value = attributes.getValue(i);
                    if (attribute.equals("version") && (qName.equals("ldml") || qName.equals(CLDRFile.SUPPLEMENTAL_NAME))) {
                        this.target.dtdVersion = value;
                        continue;
                    }
                    this.putAndFixDeprecatedAttribute(qName, attribute, value);
                }
                Iterator it = this.attributeOrder.keySet().iterator();
                while (it.hasNext()) {
                    attribute = (String)it.next();
                    value = (String)this.attributeOrder.get(attribute);
                    String both = "[@" + attribute + "=\"" + value + "\"]";
                    this.currentFullXPath = this.currentFullXPath + both;
                }
            }
            if (this.comment != null) {
                this.target.addComment(this.currentFullXPath, this.comment, 1);
                this.comment = null;
            }
            this.justPopped = false;
            this.lastActiveLeafNode = null;
            Log.logln(LOG_PROGRESS, "currentFullXPath\t" + this.currentFullXPath);
        }

        private void putAndFixDeprecatedAttribute(String element, String attribute, String value) {
            if (attribute.equals("draft")) {
                if (value.equals("true")) {
                    value = "approved";
                } else if (value.equals("false")) {
                    value = "unconfirmed";
                }
            }
            if (attribute.equals("type") && changedTypes.contains(element)) {
                attribute = "choice";
            }
            this.attributeOrder.put(attribute, value);
        }

        private void pop(String qName) {
            Log.logln(LOG_PROGRESS, "pop\t" + qName);
            if (this.lastChars.length() != 0 || !this.justPopped) {
                if (this.includeDraft || this.currentFullXPath.indexOf("[@draft=\"unconfirmed\"]") < 0) {
                    this.target.add(this.currentFullXPath, this.lastChars);
                    this.lastLeafNode = this.lastActiveLeafNode = this.currentFullXPath;
                }
                this.lastChars = "";
            } else {
                Log.logln(LOG_PROGRESS && this.lastActiveLeafNode != null, "pop: zeroing last leafNode: " + this.lastActiveLeafNode);
                this.lastActiveLeafNode = null;
                if (this.comment != null) {
                    this.target.addComment(this.lastLeafNode, this.comment, 2);
                    this.comment = null;
                }
            }
            this.currentFullXPath = MyDeclHandler.stripAfter(this.currentFullXPath, qName);
            this.justPopped = true;
        }

        private static String stripAfter(String input, String qName) {
            int pos = MyDeclHandler.findLastSlash(input);
            if (qName != null && !input.substring(pos + 1).startsWith(qName)) {
                throw new IllegalArgumentException("Internal Error: should never get here.");
            }
            return input.substring(0, pos);
        }

        private static int findLastSlash(String input) {
            int braceStack = 0;
            block5: for (int i = input.length() - 1; i >= 0; --i) {
                char ch = input.charAt(i);
                switch (ch) {
                    case '/': {
                        if (braceStack != 0) continue block5;
                        return i;
                    }
                    case '[': {
                        --braceStack;
                        continue block5;
                    }
                    case ']': {
                        ++braceStack;
                    }
                }
            }
            return -1;
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            Log.logln(LOG_PROGRESS, "startElement uri\t" + uri + "\tlocalName " + localName + "\tqName " + qName + "\tattributes " + this.show(attributes));
            try {
                if (this.isSupplemental < 0) {
                    if (qName.equals("ldml")) {
                        this.isSupplemental = 0;
                    } else if (qName.equals(CLDRFile.SUPPLEMENTAL_NAME)) {
                        this.isSupplemental = 1;
                    } else {
                        throw new IllegalArgumentException("File is neither ldml or supplementalData!");
                    }
                }
                this.push(qName, attributes);
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                throw e;
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            Log.logln(LOG_PROGRESS, "endElement uri\t" + uri + "\tlocalName " + localName + "\tqName " + qName);
            try {
                this.pop(qName);
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                throw e;
            }
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            try {
                String value = new String(ch, start, length);
                Log.logln(LOG_PROGRESS, "characters:\t" + value);
                while (value.startsWith(XML_LINESEPARATOR_STRING) && this.lastChars.length() == 0) {
                    value = value.substring(1);
                }
                if (value.indexOf(10) >= 0) {
                    value = value.replace('\n', ' ');
                }
                this.lastChars = this.lastChars + value;
                this.justPopped = false;
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                throw e;
            }
        }

        public void startDTD(String name, String publicId, String systemId) throws SAXException {
            Log.logln(LOG_PROGRESS, "startDTD name: " + name + ", publicId: " + publicId + ", systemId: " + systemId);
            ++this.commentStack;
        }

        public void endDTD() throws SAXException {
            Log.logln(LOG_PROGRESS, "endDTD");
            --this.commentStack;
        }

        public void comment(char[] ch, int start, int length) throws SAXException {
            Log.logln(LOG_PROGRESS, this.commentStack + " comment " + new String(ch, start, length));
            try {
                if (this.commentStack != 0) {
                    return;
                }
                String comment0 = new String(ch, start, length);
                if (this.lastActiveLeafNode != null) {
                    this.target.addComment(this.lastActiveLeafNode, comment0, 0);
                } else {
                    this.comment = this.comment == null ? comment0 : this.comment + "\n" + comment0;
                }
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                throw e;
            }
        }

        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            Log.logln(LOG_PROGRESS, "ignorableWhitespace length: " + length);
            for (int i = 0; i < ch.length; ++i) {
                if (ch[i] != '\n') continue;
                Log.logln(LOG_PROGRESS && this.lastActiveLeafNode != null, "\\n: zeroing last leafNode: " + this.lastActiveLeafNode);
                this.lastActiveLeafNode = null;
            }
        }

        public void startDocument() throws SAXException {
            Log.logln(LOG_PROGRESS, "startDocument");
            this.commentStack = 0;
        }

        public void endDocument() throws SAXException {
            Log.logln(LOG_PROGRESS, "endDocument");
            try {
                if (this.comment != null) {
                    this.target.addComment(null, this.comment, 0);
                }
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                throw e;
            }
        }

        public void elementDecl(String name, String model) throws SAXException {
            Log.logln(LOG_PROGRESS, "Attribute\t" + name + "\t" + model);
        }

        public void attributeDecl(String eName, String aName, String type, String mode, String value) throws SAXException {
            Log.logln(LOG_PROGRESS, "Attribute\t" + eName + "\t" + aName + "\t" + type + "\t" + mode + "\t" + value);
        }

        public void internalEntityDecl(String name, String value) throws SAXException {
            Log.logln(LOG_PROGRESS, "Internal Entity\t" + name + "\t" + value);
        }

        public void externalEntityDecl(String name, String publicId, String systemId) throws SAXException {
            Log.logln(LOG_PROGRESS, "Internal Entity\t" + name + "\t" + publicId + "\t" + systemId);
        }

        public void notationDecl(String name, String publicId, String systemId) {
            Log.logln(LOG_PROGRESS, "notationDecl: " + name + ", " + publicId + ", " + systemId);
        }

        public void processingInstruction(String target, String data) throws SAXException {
            Log.logln(LOG_PROGRESS, "processingInstruction: " + target + ", " + data);
        }

        public void skippedEntity(String name) throws SAXException {
            Log.logln(LOG_PROGRESS, "skippedEntity: " + name);
        }

        public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) {
            Log.logln(LOG_PROGRESS, "unparsedEntityDecl: " + name + ", " + publicId + ", " + systemId + ", " + notationName);
        }

        public void setDocumentLocator(Locator locator) {
            Log.logln(LOG_PROGRESS, "setDocumentLocator Locator " + locator);
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            Log.logln(LOG_PROGRESS, "startPrefixMapping prefix: " + prefix + ", uri: " + uri);
        }

        public void endPrefixMapping(String prefix) throws SAXException {
            Log.logln(LOG_PROGRESS, "endPrefixMapping prefix: " + prefix);
        }

        public void startEntity(String name) throws SAXException {
            Log.logln(LOG_PROGRESS, "startEntity name: " + name);
        }

        public void endEntity(String name) throws SAXException {
            Log.logln(LOG_PROGRESS, "endEntity name: " + name);
        }

        public void startCDATA() throws SAXException {
            Log.logln(LOG_PROGRESS, "startCDATA");
        }

        public void endCDATA() throws SAXException {
            Log.logln(LOG_PROGRESS, "endCDATA");
        }

        public void error(SAXParseException exception) throws SAXException {
            if (!LOG_PROGRESS) {
                // empty if block
            }
            Log.logln(true, "error: " + CLDRFile.showSAX(exception));
            throw exception;
        }

        public void fatalError(SAXParseException exception) throws SAXException {
            Log.logln(LOG_PROGRESS, "fatalError: " + CLDRFile.showSAX(exception));
            throw exception;
        }

        public void warning(SAXParseException exception) throws SAXException {
            Log.logln(LOG_PROGRESS, "warning: " + CLDRFile.showSAX(exception));
            throw exception;
        }
    }

    public static class Factory {
        private String sourceDirectory;
        private String matchString;
        private Set localeList = new TreeSet();
        private Map mainCache = new TreeMap();
        private Map resolvedCache = new TreeMap();
        private Map mainCacheNoDraft = new TreeMap();
        private Map resolvedCacheNoDraft = new TreeMap();
        private Map supplementalCache = new TreeMap();
        private boolean needToReadRoot = true;

        private Factory() {
        }

        public static Factory make(String sourceDirectory, String matchString) {
            Factory result = new Factory();
            result.sourceDirectory = sourceDirectory;
            result.matchString = matchString;
            Matcher m = Pattern.compile(matchString).matcher("");
            result.localeList = CLDRFile.getMatchingXMLFiles(sourceDirectory, m);
            try {
                result.localeList.addAll(CLDRFile.getMatchingXMLFiles(sourceDirectory + "/../supplemental/", m));
            }
            catch (Throwable t) {
                throw new Error("CLDRFile unable to load Supplemental data: couldn't getMatchingXMLFiles(" + sourceDirectory + "/../supplemental" + ")", t);
            }
            return result;
        }

        public Set getAvailable() {
            return Collections.unmodifiableSet(this.localeList);
        }

        public Set getAvailableLanguages() {
            TreeSet<String> result = new TreeSet<String>();
            Iterator it = this.localeList.iterator();
            while (it.hasNext()) {
                String s = (String)it.next();
                if (!XPathParts.isLanguage(s)) continue;
                result.add(s);
            }
            return result;
        }

        public Set getAvailableWithParent(String parent, boolean isProper) {
            TreeSet<String> result = new TreeSet<String>();
            Iterator it = this.localeList.iterator();
            while (it.hasNext()) {
                String s = (String)it.next();
                int relation = XPathParts.isSubLocale(parent, s);
                if (relation < 0 || isProper && relation == 0) continue;
                result.add(s);
            }
            return result;
        }

        public CLDRFile make(String localeName, boolean resolved) {
            return this.make(localeName, resolved, true);
        }

        public CLDRFile make(String localeName, boolean resolved, boolean includeDraft) {
            Map cache = includeDraft ? (resolved ? this.resolvedCache : this.mainCache) : (resolved ? this.resolvedCacheNoDraft : this.mainCacheNoDraft);
            CLDRFile result = (CLDRFile)cache.get(localeName);
            if (result == null) {
                result = CLDRFile.make(localeName, CLDRFile.isSupplementalName(localeName) ? this.sourceDirectory + File.separator + "../supplemental/" : this.sourceDirectory, includeDraft);
                ((SimpleXMLSource)result.dataSource).factory = this;
                if (resolved) {
                    result.dataSource = result.dataSource.getResolving();
                } else {
                    result.freeze();
                }
                cache.put(localeName, result);
            }
            return result;
        }
    }

    public static class SimpleXMLSource
    extends XMLSource {
        private HashMap xpath_value = new HashMap();
        private HashMap xpath_fullXPath = new HashMap();
        private XPathParts.Comments xpath_comments = new XPathParts.Comments();
        private Factory factory;

        public SimpleXMLSource(Factory factory, String localeID) {
            this.factory = factory;
            this.setLocaleID(localeID);
        }

        public String getValueAtDPath(String xpath) {
            return (String)this.xpath_value.get(xpath);
        }

        public String getFullPathAtDPath(String xpath) {
            String result = (String)this.xpath_fullXPath.get(xpath);
            if (result != null) {
                return result;
            }
            if (this.xpath_value.get(xpath) != null) {
                return xpath;
            }
            return null;
        }

        public XPathParts.Comments getXpathComments() {
            return this.xpath_comments;
        }

        public void setXpathComments(XPathParts.Comments xpath_comments) {
            this.xpath_comments = xpath_comments;
        }

        public void removeValueAtDPath(String distinguishingXPath) {
            this.xpath_value.remove(distinguishingXPath);
            this.xpath_fullXPath.remove(distinguishingXPath);
        }

        public Iterator iterator() {
            return Collections.unmodifiableSet(this.xpath_value.keySet()).iterator();
        }

        public Object freeze() {
            this.locked = true;
            return this;
        }

        public Object cloneAsThawed() {
            SimpleXMLSource result = (SimpleXMLSource)super.cloneAsThawed();
            result.xpath_comments = (XPathParts.Comments)result.xpath_comments.clone();
            result.xpath_fullXPath = (HashMap)result.xpath_fullXPath.clone();
            result.xpath_value = (HashMap)result.xpath_value.clone();
            return result;
        }

        public void putFullPathAtDPath(String distinguishingXPath, String fullxpath) {
            this.xpath_fullXPath.put(distinguishingXPath, fullxpath);
        }

        public void putValueAtDPath(String distinguishingXPath, String value) {
            this.xpath_value.put(distinguishingXPath, value);
        }

        public XMLSource make(String localeID) {
            if (localeID == null) {
                return null;
            }
            CLDRFile file = this.factory.make(localeID, false);
            if (file == null) {
                return null;
            }
            return file.dataSource;
        }

        public Set getAvailableLocales() {
            return this.factory.getAvailable();
        }
    }
}

