/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.ibm.icu.text.Transliterator;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.XPathParts;

public class CLDRTransforms {
    static Map id_instance = new HashMap();
    static Transliterator fixup = Transliterator.getInstance((String)"[:Mn:]any-hex/java");
    static Set available = new HashSet();
    static String[] doFirst = new String[]{"Latin-ConjoiningJamo"};

    public static Set getAvailableTransforms() {
        return available;
    }

    public static Transliterator getInstance(String id) {
        Transliterator result = (Transliterator)id_instance.get(id);
        if (result == null) {
            throw new IllegalArgumentException("No transform for " + id);
        }
        return result;
    }

    private static void cache(CLDRFile cldrFile) {
        String id;
        boolean first = true;
        StringBuffer rules = new StringBuffer();
        XPathParts parts = new XPathParts();
        String source = null;
        String target = null;
        String variant = null;
        String direction = null;
        Iterator it = cldrFile.iterator("", CLDRFile.ldmlComparator);
        while (it.hasNext()) {
            String path = (String)it.next();
            String value = cldrFile.getStringValue(path);
            if (first) {
                parts.set(path);
                Map attributes = parts.findAttributes("transform");
                if (attributes == null) {
                    return;
                }
                source = (String)attributes.get("source");
                target = (String)attributes.get("target");
                variant = (String)attributes.get("variant");
                direction = (String)attributes.get("direction");
                first = false;
            }
            if (path.indexOf("/comment") >= 0) continue;
            if (path.indexOf("/tRule") >= 0) {
                value = value.replace('\u2192', '>');
                value = value.replace('\u2190', '<');
                value = value.replaceAll("\u2194", "<>");
                value = fixup.transliterate(value);
                rules.append(value).append("\r\n");
                continue;
            }
            throw new IllegalArgumentException("Unknown element: " + path + "\t " + value);
        }
        String ruleString = rules.toString();
        if (direction.equals("both") || direction.equals("forward")) {
            id = source + "-" + target + (variant == null ? "" : "/" + variant);
            CLDRTransforms.internalRegister(id, ruleString, 0);
        }
        if (direction.equals("both") || direction.equals("backward")) {
            id = target + "-" + source + (variant == null ? "" : "/" + variant);
            CLDRTransforms.internalRegister(id, ruleString, 1);
        }
    }

    private static void internalRegister(String id, String ruleString, int direction) {
        try {
            Transliterator t = Transliterator.createFromRules((String)id, (String)ruleString, (int)direction);
            id_instance.put(id, t);
            Transliterator.unregister((String)id);
            Transliterator.registerInstance((Transliterator)t);
        }
        catch (RuntimeException e) {
            System.out.println("ERROR: couldn't register new Transliterator: " + id);
        }
    }

    static {
        CLDRFile.Factory cldrFactory = CLDRFile.Factory.make("../../common/transforms/", ".*");
        LinkedHashSet<String> ordered = new LinkedHashSet<String>();
        ordered.addAll(Arrays.asList(doFirst));
        ordered.addAll(cldrFactory.getAvailable());
        Iterator it = ordered.iterator();
        while (it.hasNext()) {
            String cldrFileName = (String)it.next();
            CLDRFile file = cldrFactory.make(cldrFileName, false);
            CLDRTransforms.cache(file);
        }
        available = Collections.unmodifiableSet(id_instance.keySet());
    }
}

