/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.ibm.icu.text.Normalizer;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.text.UnicodeSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.XPathParts;

public class ExtractCollationRules {
    Map type_rules = new TreeMap();
    XPathParts parts = new XPathParts();
    StringBuffer rules = new StringBuffer();
    static StringBuffer quoteOperandBuffer = new StringBuffer();
    static UnicodeSet needsQuoting = null;
    static UnicodeSet needsUnicodeForm = null;

    public ExtractCollationRules set(CLDRFile file) {
        this.type_rules.clear();
        String lastType = "";
        this.rules.setLength(0);
        boolean lastLen = false;
        String context = null;
        Iterator it = file.iterator("//ldml/collations", CLDRFile.ldmlComparator);
        block9: while (it.hasNext()) {
            String mainType;
            String path = (String)it.next();
            String value = file.getStringValue(path);
            this.parts.set(path);
            String type = this.parts.findAttributeValue("collation", "type");
            if (!type.equals(lastType)) {
                lastType = type;
                this.type_rules.put(lastType, this.rules.toString());
                this.rules.setLength(0);
                lastLen = false;
            }
            if ((mainType = this.parts.getElement(3)).equals("settings")) {
                this.writeSettings(this.parts.getAttributes(3), this.rules);
                continue;
            }
            if (mainType.equals("rules")) {
                String ruleType = this.parts.getElement(4);
                char c = ruleType.charAt(0);
                if (c == 'x') {
                    ruleType = this.parts.getElement(5);
                    c = ruleType.charAt(0);
                }
                boolean isMultiple = ruleType.length() > 1 && ruleType.charAt(1) == 'c';
                String lastContext = context;
                context = null;
                switch (c) {
                    case 'r': {
                        this.appendOrdering("&", null, value, false, true);
                        continue block9;
                    }
                    case 'p': {
                        this.appendOrdering("<", lastContext, value, isMultiple, true);
                        continue block9;
                    }
                    case 's': {
                        this.appendOrdering("<<", lastContext, value, isMultiple, true);
                        continue block9;
                    }
                    case 't': {
                        this.appendOrdering("<<<", lastContext, value, isMultiple, false);
                        continue block9;
                    }
                    case 'i': {
                        this.appendOrdering("=", lastContext, value, isMultiple, false);
                        continue block9;
                    }
                    case 'c': {
                        context = value;
                        continue block9;
                    }
                    case 'e': {
                        this.appendOrdering("/", null, value, false, false);
                        continue block9;
                    }
                }
                System.out.println("Couldn't handle: " + path + "\t" + value);
                continue;
            }
            System.out.println("Couldn't handle: " + path + "\t" + value);
        }
        this.type_rules.put(lastType, this.rules.toString());
        return this;
    }

    private void appendOrdering(String relation, String context, String valueAfter, boolean isMultiple, boolean lineBreakBefore) {
        if (isMultiple) {
            int cp;
            for (int i = 0; i < valueAfter.length(); i += UTF16.getCharCount((int)cp)) {
                cp = UTF16.charAt((String)valueAfter, (int)i);
                if (lineBreakBefore) {
                    this.rules.append("\r\n");
                } else {
                    this.rules.append(' ');
                }
                this.rules.append(relation);
                if (context != null) {
                    this.rules.append(' ').append(ExtractCollationRules.quote(context));
                }
                this.rules.append(' ').append(ExtractCollationRules.quote(UTF16.valueOf((int)cp)));
            }
        } else {
            if (lineBreakBefore) {
                this.rules.append("\r\n");
            } else {
                this.rules.append(' ');
            }
            this.rules.append(relation);
            if (context != null) {
                this.rules.append(' ').append(ExtractCollationRules.quote(context));
            }
            this.rules.append(' ').append(ExtractCollationRules.quote(valueAfter));
        }
    }

    private void writeSettings(Map attributes, StringBuffer results) {
        Iterator it = attributes.keySet().iterator();
        while (it.hasNext()) {
            String attribute = (String)it.next();
            String value = (String)attributes.get(attribute);
            results.append("[" + attribute + " " + value + "]\r\n");
        }
    }

    public Iterator iterator() {
        return this.type_rules.keySet().iterator();
    }

    public String getRules(Object key) {
        return (String)this.type_rules.get(key);
    }

    static final String quote(String s) {
        int cp;
        if (needsQuoting == null) {
            needsQuoting = new UnicodeSet("[[:whitespace:][:c:][:z:][:ascii:]-[a-zA-Z0-9]]");
            needsUnicodeForm = new UnicodeSet("[\\u000d\\u000a[:zl:][:zp:]]");
        }
        s = Normalizer.compose((String)s, (boolean)false);
        quoteOperandBuffer.setLength(0);
        boolean noQuotes = true;
        boolean inQuote = false;
        for (int i = 0; i < s.length(); i += UTF16.getCharCount((int)cp)) {
            cp = UTF16.charAt((String)s, (int)i);
            if (!needsQuoting.contains(cp)) {
                if (inQuote) {
                    quoteOperandBuffer.append('\'');
                    inQuote = false;
                }
                quoteOperandBuffer.append(UTF16.valueOf((int)cp));
                continue;
            }
            noQuotes = false;
            if (cp == 39) {
                quoteOperandBuffer.append("''");
                continue;
            }
            if (!inQuote) {
                quoteOperandBuffer.append('\'');
                inQuote = true;
            }
            if (!needsUnicodeForm.contains(cp)) {
                quoteOperandBuffer.append(UTF16.valueOf((int)cp));
                continue;
            }
            if (cp > 65535) {
                quoteOperandBuffer.append("\\U").append(ExtractCollationRules.hex(cp, 8));
                continue;
            }
            if (cp <= 32 || cp > 126) {
                quoteOperandBuffer.append("\\u").append(ExtractCollationRules.hex(cp, 4));
                continue;
            }
            quoteOperandBuffer.append(UTF16.valueOf((int)cp));
        }
        if (inQuote) {
            quoteOperandBuffer.append('\'');
        }
        if (noQuotes) {
            return s;
        }
        return quoteOperandBuffer.toString();
    }

    public static String hex(long i, int places) {
        String result;
        boolean negative;
        if (i == Long.MIN_VALUE) {
            return "-8000000000000000";
        }
        boolean bl = negative = i < 0L;
        if (negative) {
            i = -i;
        }
        if ((result = Long.toString(i, 16).toUpperCase()).length() < places) {
            result = "0000000000000000".substring(result.length(), places) + result;
        }
        if (negative) {
            return '-' + result;
        }
        return result;
    }
}

