/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.ibm.icu.text.MessageFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.text.UFormat;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.TimeZone;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.ICUServiceBuilder;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.Utility;
import org.unicode.cldr.util.XPathParts;

public class TimezoneFormatter
extends UFormat {
    public static boolean SHOW_DRAFT = false;
    public static final int SHORT = 0;
    public static final int LONG = 1;
    public static final int LENGTH_LIMIT = 2;
    public static final int GMT = 0;
    public static final int GENERIC = 1;
    public static final int STANDARD = 2;
    public static final int DAYLIGHT = 3;
    public static final int TYPE_LIMIT = 4;
    public static final List LENGTH = Arrays.asList("short", "long");
    public static final List TYPE = Arrays.asList("gmt", "generic", "standard", "daylight");
    private static final Map zone_countries = StandardCodes.make().getZoneToCounty();
    private static final Map countries_zoneSet = StandardCodes.make().getCountryToZoneSet();
    private static final Map old_new = StandardCodes.make().getZoneLinkold_new();
    private transient SimpleDateFormat hourFormatPlus = new SimpleDateFormat();
    private transient SimpleDateFormat hourFormatMinus = new SimpleDateFormat();
    private transient MessageFormat hoursFormat;
    private transient MessageFormat gmtFormat;
    private transient MessageFormat regionFormat;
    private transient MessageFormat fallbackFormat;
    private transient String abbreviationFallback;
    private transient String preferenceOrdering;
    private transient Set singleCountriesSet;
    private transient Calendar calendar = Calendar.getInstance((TimeZone)TimeZone.getTimeZone((String)"GMT"));
    private transient SimpleDateFormat rfc822Plus = new SimpleDateFormat("+HHmm");
    private transient SimpleDateFormat rfc822Minus = new SimpleDateFormat("-HHmm");
    private CLDRFile desiredLocaleFile;
    private String inputLocaleID;
    private boolean skipDraft;
    private static final int WALL_LIMIT = 2;
    private static final int STANDARD_LIMIT = 4;
    private static final String[] zoneTypes = new String[]{"\"]/long/generic", "\"]/short/generic", "\"]/long/standard", "\"]/short/standard", "\"]/long/daylight", "\"]/short/daylight"};
    private transient Matcher m;
    private transient boolean parseInfoBuilt;
    private final transient Map localizedCountry_countryCode;
    private final transient Map exemplar_zone;
    private final transient Map localizedExplicit_zone;
    private final transient Map country_zone;

    public TimezoneFormatter(CLDRFile.Factory cldrFactory, String localeID, boolean includeDraft) {
        this(cldrFactory.make(localeID, true, includeDraft), includeDraft);
    }

    public TimezoneFormatter(CLDRFile resolvedLocaleFile, boolean includeDraft) {
        TimeZone gmt = TimeZone.getTimeZone((String)"GMT");
        this.rfc822Plus.setTimeZone(gmt);
        this.rfc822Minus.setTimeZone(gmt);
        this.m = Pattern.compile("([-+])([0-9][0-9])([0-9][0-9])").matcher("");
        this.localizedCountry_countryCode = new HashMap();
        this.exemplar_zone = new HashMap();
        this.localizedExplicit_zone = new HashMap();
        this.country_zone = new HashMap();
        this.desiredLocaleFile = resolvedLocaleFile;
        this.inputLocaleID = this.desiredLocaleFile.getLocaleID();
        String hourFormatString = this.getStringValue("//ldml/dates/timeZoneNames/hourFormat");
        String[] hourFormatStrings = Utility.splitArray(hourFormatString, ';');
        ICUServiceBuilder icuServiceBuilder = new ICUServiceBuilder().setCldrFile(this.desiredLocaleFile);
        this.hourFormatPlus = icuServiceBuilder.getDateFormat("gregorian", 0, 1);
        this.hourFormatPlus.applyPattern(hourFormatStrings[0]);
        this.hourFormatMinus = icuServiceBuilder.getDateFormat("gregorian", 0, 1);
        this.hourFormatMinus.applyPattern(hourFormatStrings[1]);
        this.gmtFormat = new MessageFormat(this.getStringValue("//ldml/dates/timeZoneNames/gmtFormat"));
        this.regionFormat = new MessageFormat(this.getStringValue("//ldml/dates/timeZoneNames/regionFormat"));
        this.fallbackFormat = new MessageFormat(this.getStringValue("//ldml/dates/timeZoneNames/fallbackFormat"));
        this.checkForDraft("//ldml/dates/timeZoneNames/singleCountries");
        String singleCountriesList = "Africa/Bamako America/Godthab America/Santiago America/Guayaquil Asia/Shanghai Asia/Tashkent Asia/Kuala_Lumpur Europe/Madrid Europe/Lisbon Europe/London Pacific/Auckland Pacific/Tahiti";
        String temp = this.desiredLocaleFile.getFullXPath("//ldml/dates/timeZoneNames/singleCountries");
        if (temp != null) {
            singleCountriesList = new XPathParts(null, null).set(temp).findAttributeValue("singleCountries", "list");
        }
        this.singleCountriesSet = new TreeSet(Utility.splitList(singleCountriesList, ' '));
    }

    private String getStringValue(String cleanPath) {
        this.checkForDraft(cleanPath);
        return this.desiredLocaleFile.getStringValue(cleanPath);
    }

    private String getName(int territory_name, String country, boolean skipDraft2) {
        this.checkForDraft(CLDRFile.getKey(territory_name, country));
        return this.desiredLocaleFile.getName(territory_name, country, skipDraft2);
    }

    private void checkForDraft(String cleanPath) {
        String xpath = this.desiredLocaleFile.getFullXPath(cleanPath);
        if (SHOW_DRAFT && xpath != null && xpath.indexOf("[@draft=\"true\"]") >= 0) {
            System.out.println("Draft in " + this.inputLocaleID + ":\t" + cleanPath);
        }
    }

    public String getFormattedZone(String inputZoneid, String pattern, long date, boolean skipExact) {
        String zoneid = (String)old_new.get(inputZoneid);
        if (zoneid == null) {
            zoneid = inputZoneid;
        }
        TimeZone tz = TimeZone.getTimeZone((String)zoneid);
        int gmtOffset1 = tz.getOffset(date);
        boolean daylight = tz.getRawOffset() != gmtOffset1;
        return this.getFormattedZone(zoneid, pattern, daylight, gmtOffset1, skipExact);
    }

    public String getFormattedZone(String zoneid, String pattern, boolean daylight, int gmtOffset1, boolean skipExact) {
        int length;
        int n = length = pattern.length() < 4 ? 0 : 1;
        int type = pattern.startsWith("z") ? (daylight ? 3 : 2) : (pattern.startsWith("Z") ? 0 : 1);
        return this.getFormattedZone(zoneid, length, type, gmtOffset1, skipExact);
    }

    public String getFormattedZone(String inputZoneid, int length, int type, int gmtOffset1, boolean skipExact) {
        Set s;
        String formatValue;
        String zoneid = (String)old_new.get(inputZoneid);
        if (zoneid == null) {
            zoneid = inputZoneid;
        }
        String prefix = "//ldml/dates/timeZoneNames/zone[@type=\"" + zoneid + "\"]/";
        if (type != 0 && !skipExact && (formatValue = this.getStringValue(prefix + LENGTH.get(length) + "/" + TYPE.get(type))) != null) {
            return formatValue;
        }
        if (type == 0 && length == 0) {
            return gmtOffset1 < 0 ? this.rfc822Minus.format(new Date(-gmtOffset1)) : this.rfc822Plus.format(new Date(gmtOffset1));
        }
        String country = (String)zone_countries.get(zoneid);
        if (type != 1 || country.equals("001")) {
            SimpleDateFormat format = gmtOffset1 < 0 ? this.hourFormatMinus : this.hourFormatPlus;
            this.calendar.setTimeInMillis((long)Math.abs(gmtOffset1));
            String result = format.format((Object)this.calendar);
            return this.gmtFormat.format((Object)new Object[]{result});
        }
        String countryTranslation = this.desiredLocaleFile.getName(2, country, this.skipDraft);
        if (countryTranslation == null) {
            countryTranslation = country;
        }
        if ((s = (Set)countries_zoneSet.get(country)) != null && s.size() == 1 || this.singleCountriesSet.contains(zoneid)) {
            return this.regionFormat.format((Object)new Object[]{countryTranslation});
        }
        String exemplarValue = this.getStringValue(prefix + "exemplarCity");
        if (exemplarValue == null) {
            exemplarValue = TimezoneFormatter.getFallbackName(zoneid);
        }
        return this.fallbackFormat.format((Object)new Object[]{exemplarValue, countryTranslation});
    }

    public String parse(String inputText, ParsePosition parsePosition) {
        long[] offsetMillisOutput = new long[1];
        String result = this.parse(inputText, parsePosition, offsetMillisOutput);
        if (result == null || result.length() != 0) {
            return result;
        }
        long offsetMillis = offsetMillisOutput[0];
        String sign = "Etc/GMT-";
        if (offsetMillis < 0L) {
            offsetMillis = -offsetMillis;
            sign = "Etc/GMT+";
        }
        long minutes = (offsetMillis + 30000L) / 60000L;
        long hours = minutes / 60L;
        result = sign + String.valueOf(hours);
        if ((minutes %= 60L) != 0L) {
            result = result + ":" + String.valueOf(100L + minutes).substring(1, 3);
        }
        return result;
    }

    public String parse(String inputText, ParsePosition parsePosition, long[] offsetMillis) {
        if (!this.parseInfoBuilt) {
            this.buildParsingInfo();
        }
        int startOffset = parsePosition.getIndex();
        Object result = this.localizedExplicit_zone.get(inputText);
        if (result != null) {
            if (result instanceof String) {
                return (String)result;
            }
            offsetMillis[0] = (Long)result;
            return "";
        }
        if (this.m.reset(inputText).matches()) {
            int hours = Integer.parseInt(this.m.group(2));
            int minutes = Integer.parseInt(this.m.group(3));
            int millis = hours * 60 * 60 * 1000 + minutes * 60 * 1000;
            if (this.m.group(1).equals("-")) {
                millis = -millis;
            }
            offsetMillis[0] = millis;
            return "";
        }
        Object[] results = this.gmtFormat.parse(inputText, parsePosition);
        if (results != null) {
            String hours = (String)results[0];
            parsePosition.setIndex(0);
            Date date = this.hourFormatPlus.parse(hours, parsePosition);
            if (date != null) {
                offsetMillis[0] = date.getTime();
                return "";
            }
            parsePosition.setIndex(0);
            date = this.hourFormatMinus.parse(hours, parsePosition);
            if (date != null) {
                offsetMillis[0] = -date.getTime();
                return "";
            }
        }
        String city = null;
        String country = null;
        parsePosition.setIndex(startOffset);
        Object[] x = this.fallbackFormat.parse(inputText, parsePosition);
        if (x != null) {
            city = (String)x[0];
            country = (String)x[1];
            return (String)this.exemplar_zone.get(city);
        }
        parsePosition.setIndex(startOffset);
        x = this.regionFormat.parse(inputText, parsePosition);
        if (x == null) {
            return null;
        }
        country = (String)x[0];
        String countryCode = (String)this.localizedCountry_countryCode.get(country);
        if (countryCode == null) {
            countryCode = country;
        }
        return (String)this.country_zone.get(countryCode);
    }

    private void buildParsingInfo() {
        Object key;
        String zoneid;
        Iterator it = old_new.keySet().iterator();
        while (it.hasNext()) {
            zoneid = (String)it.next();
            this.exemplar_zone.put(TimezoneFormatter.getFallbackName(zoneid), zoneid);
        }
        it = zone_countries.keySet().iterator();
        while (it.hasNext()) {
            zoneid = (String)it.next();
            this.exemplar_zone.put(TimezoneFormatter.getFallbackName(zoneid), zoneid);
        }
        String prefix = "//ldml/dates/timeZoneNames/zone[@type=\"";
        String countryPrefix = "//ldml/localeDisplayNames/territories/territory[@type=\"";
        HashMap<String, Object> localizedNonWall = new HashMap<String, Object>();
        HashSet<String> skipDuplicates = new HashSet<String>();
        Iterator it2 = this.desiredLocaleFile.iterator();
        while (it2.hasNext()) {
            String name;
            String path = (String)it2.next();
            if (path.startsWith(prefix)) {
                String name2;
                String zoneId = this.matchesPart(path, prefix, "\"]/exemplarCity");
                if (zoneId != null && (name2 = this.desiredLocaleFile.getStringValue(path)) != null) {
                    this.exemplar_zone.put(name2, zoneId);
                }
                for (int i = 0; i < zoneTypes.length; ++i) {
                    String name3;
                    zoneId = this.matchesPart(path, prefix, zoneTypes[i]);
                    if (zoneId == null || (name3 = this.desiredLocaleFile.getStringValue(path)) == null) continue;
                    if (i < 2) {
                        this.localizedExplicit_zone.put(name3, zoneId);
                        continue;
                    }
                    Object dup = localizedNonWall.get(name3);
                    if (dup != null) {
                        skipDuplicates.add(name3);
                        TimeZone tz = TimeZone.getTimeZone((String)zoneId);
                        int offset = tz.getRawOffset();
                        if (i >= 4) {
                            offset += tz.getDSTSavings();
                        }
                        localizedNonWall.put(name3, new Long(offset));
                        continue;
                    }
                    localizedNonWall.put(name3, zoneId);
                }
                continue;
            }
            String countryCode = this.matchesPart(path, countryPrefix, "\"]");
            if (countryCode == null || (name = this.desiredLocaleFile.getStringValue(path)) == null) continue;
            this.localizedCountry_countryCode.put(name, countryCode);
        }
        it2 = localizedNonWall.keySet().iterator();
        while (it2.hasNext()) {
            key = it2.next();
            Object value = localizedNonWall.get(key);
            this.localizedExplicit_zone.put(key, value);
        }
        it2 = countries_zoneSet.keySet().iterator();
        while (it2.hasNext()) {
            key = it2.next();
            HashSet set = (HashSet)countries_zoneSet.get(key);
            if (set == null) continue;
            if (set.size() == 1) {
                this.country_zone.put(key, set.iterator().next());
                continue;
            }
            set = new HashSet(set);
            set.retainAll(this.singleCountriesSet);
            if (set.size() != 1) continue;
            this.country_zone.put(key, set.iterator().next());
        }
        this.parseInfoBuilt = true;
    }

    private String matchesPart(String input, String prefix, String suffix) {
        if (!input.startsWith(prefix)) {
            return null;
        }
        if (!input.endsWith(suffix)) {
            return null;
        }
        return input.substring(prefix.length(), input.length() - suffix.length());
    }

    public static String getFallbackName(String zoneid) {
        int pos = zoneid.lastIndexOf(47);
        String result = pos < 0 ? zoneid : zoneid.substring(pos + 1);
        result = result.replace('_', ' ');
        return result;
    }

    public boolean isSkipDraft() {
        return this.skipDraft;
    }

    public TimezoneFormatter setSkipDraft(boolean skipDraft) {
        this.skipDraft = skipDraft;
        return this;
    }

    public Object parseObject(String source, ParsePosition pos) {
        return null;
    }

    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        return null;
    }
}

