/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.ibm.icu.impl.CollectionUtilities;
import com.ibm.icu.util.Freezable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.LocaleIDParser;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.TimezoneFormatter;
import org.unicode.cldr.util.XPathParts;

public abstract class XMLSource
implements Freezable {
    public static final String CODE_FALLBACK_ID = "code-fallback";
    private transient XPathParts parts = new XPathParts(null, null);
    private static Map allowDuplicates = new HashMap();
    private String localeID;
    private boolean nonInheriting;
    protected boolean locked;
    transient String[] fixedPath = new String[1];

    public String getLocaleID() {
        return this.localeID;
    }

    public void setLocaleID(String localeID) {
        this.localeID = localeID;
    }

    public void putAll(Map tempMap, int conflict_resolution) {
        Iterator it = tempMap.keySet().iterator();
        while (it.hasNext()) {
            String path = (String)it.next();
            if (conflict_resolution == 0 && this.getValueAtPath(path) != null) continue;
            this.putValueAtPath(path, (String)tempMap.get(path));
        }
    }

    public void putAll(XMLSource otherSource, int conflict_resolution) {
        Iterator it = otherSource.iterator();
        while (it.hasNext()) {
            String path = (String)it.next();
            if (conflict_resolution == 0 && this.getValueAtDPath(path) != null) continue;
            this.putValueAtPath(otherSource.getFullPathAtDPath(path), otherSource.getValueAtDPath(path));
        }
    }

    public void removeAll(Collection xpaths) {
        Iterator it = xpaths.iterator();
        while (it.hasNext()) {
            this.removeValueAtDPath((String)it.next());
        }
    }

    public boolean isDraft(String path) {
        String fullpath = this.getFullPath(path);
        if (fullpath.indexOf("[@draft") < 0) {
            return false;
        }
        return this.parts.set(fullpath).containsAttribute("draft");
    }

    public boolean isFrozen() {
        return this.locked;
    }

    public String putValueAtPath(String xpath, String value) {
        if (this.locked) {
            throw new UnsupportedOperationException("Attempt to modify locked object");
        }
        String distinguishingXPath = CLDRFile.getDistinguishingXPath(xpath, this.fixedPath, this.nonInheriting);
        this.putValueAtDPath(distinguishingXPath, value);
        if (!this.fixedPath[0].equals(distinguishingXPath)) {
            this.putFullPathAtDPath(distinguishingXPath, this.fixedPath[0]);
        }
        return distinguishingXPath;
    }

    public static Map getPathsAllowingDuplicates() {
        return allowDuplicates;
    }

    public List addAliases(List output) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            String path = (String)it.next();
            String fullPath = this.getFullPathAtDPath(path);
            Alias temp = Alias.make(fullPath);
            if (temp == null) continue;
            output.add(temp);
        }
        return output;
    }

    public String getSourceLocaleID(String path, CLDRFile.Status status) {
        if (status != null) {
            status.pathWhereFound = CLDRFile.getDistinguishingXPath(path, null, false);
        }
        return this.getLocaleID();
    }

    public void removeValueAtPath(String xpath) {
        if (this.locked) {
            throw new UnsupportedOperationException("Attempt to modify locked object");
        }
        this.removeValueAtDPath(CLDRFile.getDistinguishingXPath(xpath, null, this.nonInheriting));
    }

    public String getValueAtPath(String xpath) {
        return this.getValueAtDPath(CLDRFile.getDistinguishingXPath(xpath, null, this.nonInheriting));
    }

    public String getFullPath(String xpath) {
        return this.getFullPathAtDPath(CLDRFile.getDistinguishingXPath(xpath, null, this.nonInheriting));
    }

    public abstract void putFullPathAtDPath(String var1, String var2);

    public abstract void putValueAtDPath(String var1, String var2);

    public abstract void removeValueAtDPath(String var1);

    public abstract String getValueAtDPath(String var1);

    public boolean hasValueAtDPath(String path) {
        return this.getValueAtDPath(path) != null;
    }

    public abstract String getFullPathAtDPath(String var1);

    public abstract XPathParts.Comments getXpathComments();

    public abstract void setXpathComments(XPathParts.Comments var1);

    public abstract Iterator iterator();

    public abstract XMLSource make(String var1);

    public abstract Set getAvailableLocales();

    public Iterator iterator(String prefix) {
        return new CollectionUtilities.PrefixIterator().set(this.iterator(), prefix);
    }

    public boolean isResolving() {
        return false;
    }

    public XMLSource getResolving() {
        if (this.isResolving()) {
            return this;
        }
        return new ResolvingSource(this);
    }

    public Object cloneAsThawed() {
        try {
            XMLSource result = (XMLSource)super.clone();
            result.locked = false;
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError("should never happen");
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            String path = (String)it.next();
            String value = this.getValueAtDPath(path);
            String fullpath = this.getFullPathAtDPath(path);
            result.append(fullpath).append(" =\t ").append(value).append("\r\n");
        }
        return result.toString();
    }

    public String toString(String regex) {
        Matcher matcher = Pattern.compile(regex).matcher("");
        StringBuffer result = new StringBuffer();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            String path = (String)it.next();
            if (!matcher.reset(path).matches()) continue;
            String value = this.getValueAtDPath(path);
            String fullpath = this.getFullPathAtDPath(path);
            result.append(fullpath).append(" =\t ").append(value).append("\r\n");
        }
        return result.toString();
    }

    public boolean isNonInheriting() {
        return this.nonInheriting;
    }

    public void setNonInheriting(boolean nonInheriting) {
        this.nonInheriting = nonInheriting;
    }

    private static class ResolvingSource
    extends XMLSource {
        private XMLSource mySource;
        private transient ParentAndPath parentAndPath = new ParentAndPath();
        private Alias tempAlias = new Alias();
        public static final boolean TRACE_VALUE = false;
        static final boolean TRACE_FILL = false;
        transient Set cachedKeySet = null;
        private static final String[] keyDisplayNames;
        private static final String[][] typeDisplayNames;
        static XMLSource constructedItems;

        public boolean isResolving() {
            return true;
        }

        public String getValueAtDPath(String xpath) {
            XMLSource currentSource = this.mySource;
            String result = currentSource.getValueAtDPath(xpath);
            if (result != null) {
                return result;
            }
            this.parentAndPath.set(xpath, currentSource, this.getLocaleID()).next();
            while (this.parentAndPath.parentID != null) {
                currentSource = this.make(this.parentAndPath.parentID);
                result = currentSource.getValueAtDPath(this.parentAndPath.path);
                if (result != null) {
                    return result;
                }
                this.parentAndPath.next();
            }
            return constructedItems.getValueAtDPath(xpath);
        }

        public String getFullPathAtDPath(String xpath) {
            XMLSource currentSource = this.mySource;
            String result = currentSource.getValueAtDPath(xpath);
            if (result != null) {
                return currentSource.getFullPathAtDPath(xpath);
            }
            this.parentAndPath.set(xpath, currentSource, this.getLocaleID()).next();
            while (this.parentAndPath.parentID != null) {
                currentSource = this.make(this.parentAndPath.parentID);
                result = currentSource.getValueAtDPath(this.parentAndPath.path);
                if (result != null) {
                    result = currentSource.getFullPathAtDPath(this.parentAndPath.path);
                    return this.tempAlias.changeNewToOld(result, this.parentAndPath.path, xpath);
                }
                this.parentAndPath.next();
            }
            return constructedItems.getFullPathAtDPath(xpath);
        }

        public String getSourceLocaleID(String xpath, CLDRFile.Status status) {
            XMLSource currentSource = this.mySource;
            boolean result = currentSource.hasValueAtDPath(xpath = CLDRFile.getDistinguishingXPath(xpath, null, false));
            if (result) {
                if (status != null) {
                    status.pathWhereFound = xpath;
                }
                return this.mySource.getLocaleID();
            }
            this.parentAndPath.set(xpath, currentSource, this.getLocaleID()).next();
            while (true) {
                if (this.parentAndPath.parentID == null) {
                    if (status != null) {
                        status.pathWhereFound = this.parentAndPath.path;
                    }
                    return XMLSource.CODE_FALLBACK_ID;
                }
                currentSource = this.make(this.parentAndPath.parentID);
                result = currentSource.hasValueAtDPath(this.parentAndPath.path);
                if (result) {
                    currentSource.getFullPathAtDPath(this.parentAndPath.path);
                    if (status != null) {
                        status.pathWhereFound = this.parentAndPath.path;
                    }
                    return currentSource.getLocaleID();
                }
                this.parentAndPath.next();
            }
        }

        private void fillKeys(int level, XMLSource currentSource, Alias alias, List excludedAliases, Set resultKeySet) {
            ArrayList<Alias> collectedAliases = null;
            Iterator it = currentSource.iterator();
            while (it.hasNext()) {
                String fullPath;
                Alias possibleAlias;
                String path;
                String originalPath = path = (String)it.next();
                if (alias != null) {
                    if (!path.startsWith(alias.newPath)) continue;
                    if (!alias.oldPath.equals(alias.newPath)) {
                        path = alias.oldPath + path.substring(alias.newPath.length());
                    }
                }
                if (excludedAliases != null && ResolvingSource.startsWith(path, excludedAliases)) continue;
                if (path.indexOf("/alias") >= 0 && (possibleAlias = Alias.make(fullPath = currentSource.getFullPathAtDPath(originalPath))) != null) {
                    if (collectedAliases == null) {
                        collectedAliases = new ArrayList<Alias>();
                    }
                    collectedAliases.add(possibleAlias);
                }
                resultKeySet.add(path);
            }
            if (currentSource != constructedItems) {
                XMLSource parentSource = constructedItems;
                String parentID = LocaleIDParser.getParent(currentSource.getLocaleID());
                if (parentID != null) {
                    parentSource = this.make(parentID);
                }
                if (collectedAliases != null) {
                    if (excludedAliases == null) {
                        excludedAliases = new ArrayList();
                    } else {
                        excludedAliases.addAll(collectedAliases);
                    }
                }
                this.fillKeys(level + 1, parentSource, alias, excludedAliases, resultKeySet);
            }
            if (collectedAliases != null) {
                it = collectedAliases.iterator();
                while (it.hasNext()) {
                    Alias foundAlias = (Alias)it.next();
                    XMLSource aliasSource = this.mySource;
                    if (foundAlias.newLocaleID != null) {
                        aliasSource = this.make(foundAlias.newLocaleID);
                    }
                    this.fillKeys(level + 1, aliasSource, foundAlias, null, resultKeySet);
                }
            }
        }

        public Iterator iterator() {
            return this.getCachedKeySet().iterator();
        }

        private Set getCachedKeySet() {
            if (this.cachedKeySet == null) {
                this.cachedKeySet = new HashSet();
                this.fillKeys(0, this.mySource, null, null, this.cachedKeySet);
                this.cachedKeySet = Collections.unmodifiableSet(this.cachedKeySet);
            }
            return this.cachedKeySet;
        }

        private static boolean startsWith(String path, List aliasPaths) {
            Iterator it = aliasPaths.iterator();
            while (it.hasNext()) {
                if (!path.startsWith(((Alias)it.next()).oldPath)) continue;
                return true;
            }
            return false;
        }

        public void putFullPathAtDPath(String distinguishingXPath, String fullxpath) {
            throw new UnsupportedOperationException("Resolved CLDRFiles are read-only");
        }

        public void putValueAtDPath(String distinguishingXPath, String value) {
            throw new UnsupportedOperationException("Resolved CLDRFiles are read-only");
        }

        public XPathParts.Comments getXpathComments() {
            return this.mySource.getXpathComments();
        }

        public void setXpathComments(XPathParts.Comments path) {
            throw new UnsupportedOperationException("Resolved CLDRFiles are read-only");
        }

        public void removeValueAtDPath(String xpath) {
            throw new UnsupportedOperationException("Resolved CLDRFiles are read-only");
        }

        public Object freeze() {
            throw new UnsupportedOperationException("Resolved CLDRFiles can't be locked");
        }

        public ResolvingSource(XMLSource source) {
            this.mySource = source;
        }

        public String getLocaleID() {
            return this.mySource.getLocaleID();
        }

        public XMLSource make(String localeID) {
            return this.mySource.make(localeID);
        }

        public Set getAvailableLocales() {
            return this.mySource.getAvailableLocales();
        }

        static {
            int i;
            keyDisplayNames = new String[]{"calendar", "collation", "currency"};
            typeDisplayNames = new String[][]{{"big5han", "collation"}, {"buddhist", "calendar"}, {"chinese", "calendar"}, {"direct", "collation"}, {"gb2312han", "collation"}, {"gregorian", "calendar"}, {"hebrew", "calendar"}, {"islamic", "calendar"}, {"islamic-civil", "calendar"}, {"japanese", "calendar"}, {"phonebook", "collation"}, {"pinyin", "collation"}, {"stroke", "collation"}, {"traditional", "collation"}};
            constructedItems = new CLDRFile.SimpleXMLSource(null, null);
            StandardCodes sc = StandardCodes.make();
            Map countries_zoneSet = sc.getCountryToZoneSet();
            Map zone_countries = sc.getZoneToCounty();
            for (int typeNo = 0; typeNo <= 6; ++typeNo) {
                String type = CLDRFile.getNameName(typeNo);
                String type2 = typeNo == 5 ? CLDRFile.getNameName(4) : (typeNo >= 6 ? "tzid" : type);
                Set codes = sc.getGoodAvailableCodes(type2);
                Iterator codeIt = codes.iterator();
                while (codeIt.hasNext()) {
                    String code;
                    String value = code = (String)codeIt.next();
                    if (typeNo == 6) {
                        String country = (String)zone_countries.get(code);
                        Set s = (Set)countries_zoneSet.get(country);
                        if (s != null && s.size() == 1) continue;
                        value = TimezoneFormatter.getFallbackName(value);
                    }
                    String fullpath = CLDRFile.getKey(typeNo, code);
                    String distinguishingPath = constructedItems.putValueAtPath(fullpath, value);
                    if (typeNo != 0 && typeNo != 1 && typeNo != 2) continue;
                    allowDuplicates.put(distinguishingPath, code);
                }
            }
            for (i = 0; i < keyDisplayNames.length; ++i) {
                constructedItems.putValueAtPath("//ldml/localeDisplayNames/keys/key[@type=\"" + keyDisplayNames[i] + "\"]", keyDisplayNames[i]);
            }
            for (i = 0; i < typeDisplayNames.length; ++i) {
                constructedItems.putValueAtPath("//ldml/localeDisplayNames/types/type[@type=\"" + typeDisplayNames[i][0] + "\"]" + "[@key=\"" + typeDisplayNames[i][1] + "\"]", typeDisplayNames[i][0]);
            }
            constructedItems.freeze();
            allowDuplicates = Collections.unmodifiableMap(allowDuplicates);
        }

        private static class ParentAndPath {
            String parentID;
            String path;
            XMLSource source;
            String desiredLocaleID;
            transient List aliases = new ArrayList();

            private ParentAndPath() {
            }

            public ParentAndPath set(String xpath, XMLSource source, String desiredLocaleID) {
                this.parentID = source.getLocaleID();
                this.path = xpath;
                this.source = source;
                this.desiredLocaleID = desiredLocaleID;
                return this;
            }

            public ParentAndPath next() {
                this.aliases.clear();
                this.source.addAliases(this.aliases);
                if (this.aliases.size() != 0) {
                    Iterator it = this.aliases.iterator();
                    while (it.hasNext()) {
                        Alias alias = (Alias)it.next();
                        if (!this.path.startsWith(alias.oldPath)) continue;
                        this.parentID = alias.newLocaleID;
                        if (this.parentID == null) {
                            this.parentID = this.desiredLocaleID;
                        }
                        this.source = this.source.make(this.parentID);
                        this.path = alias.newPath + this.path.substring(alias.oldPath.length());
                        return this;
                    }
                }
                this.parentID = LocaleIDParser.getParent(this.parentID);
                this.source = this.parentID == null ? null : this.source.make(this.parentID);
                return this;
            }
        }
    }

    protected static class Alias {
        public String oldPath;
        public String newLocaleID;
        public String newPath;
        XPathParts partsOld = new XPathParts(null, null);
        XPathParts partsNew = new XPathParts(null, null);
        XPathParts partsFull = new XPathParts(null, null);

        protected Alias() {
        }

        public static Alias make(String aliasPath) {
            String relativePath;
            XPathParts tempAliasParts = new XPathParts(null, null);
            int pos = aliasPath.indexOf("/alias");
            if (pos < 0) {
                return null;
            }
            if (!tempAliasParts.set(aliasPath).containsElement("alias")) {
                return null;
            }
            Alias result = new Alias();
            result.oldPath = aliasPath.substring(0, pos);
            Map attributes = tempAliasParts.getAttributes(tempAliasParts.size() - 1);
            result.newLocaleID = (String)attributes.get("source");
            if (result.newLocaleID != null && result.newLocaleID.equals("locale")) {
                result.newLocaleID = null;
            }
            result.newPath = (relativePath = (String)attributes.get("path")) == null ? result.oldPath : tempAliasParts.trimLast().addRelative(relativePath).toString();
            if (result.newPath.equals(result.oldPath) && result.newLocaleID == null) {
                throw new IllegalArgumentException("Alias must have different path or different source. AliasPath: " + aliasPath + ", Alias: " + result.toString());
            }
            return result;
        }

        public String toString() {
            return "oldPath: " + this.oldPath + ", " + "newLocaleID: " + this.newLocaleID + ", " + "newPath: " + this.newPath;
        }

        public String changeNewToOld(String fullPath, String newPath, String oldPath) {
            if (fullPath.startsWith(newPath)) {
                return oldPath + fullPath.substring(newPath.length());
            }
            this.partsOld.set(oldPath);
            this.partsNew.set(newPath);
            this.partsFull.set(fullPath);
            Map attributesFull = this.partsFull.getAttributes(-1);
            Map attributesNew = this.partsNew.getAttributes(-1);
            Map attributesOld = this.partsOld.getAttributes(-1);
            Iterator it = attributesFull.keySet().iterator();
            while (it.hasNext()) {
                Object attribute = it.next();
                if (attributesNew.containsKey(attribute)) continue;
                attributesOld.put(attribute, attributesFull.get(attribute));
            }
            String result = this.partsOld.toString();
            return result;
        }
    }
}

