/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.unicode.cldr.util.ICUServiceBuilder;

public class ZoneInflections
implements Comparable {
    private static final long SECOND = 1000L;
    private static final long MINUTE = 60000L;
    private static final long HOUR = 3600000L;
    private static final double DHOUR = 3600000.0;
    private static final long DAY = 86400000L;
    private static final long GROSS_PERIOD = 1296000000L;
    private static final long EPSILON = 900000L;
    private static final long endDate = ZoneInflections.getDateLong(2010, 1, 1);
    private static final long startDate = ZoneInflections.getDateLong(1970, 1, 1);
    private int minOffset;
    private int maxOffset;
    List inflectionPoints = new ArrayList();
    private transient OutputLong temp = new OutputLong(0L);
    private static final NumberFormat nf = NumberFormat.getInstance((ULocale)ULocale.US);

    public int getMaxOffset() {
        return this.maxOffset;
    }

    public int getMinOffset() {
        return this.minOffset;
    }

    public int getMaxOffset(long afterDateTime) {
        long minSoFar = Integer.MAX_VALUE;
        for (int i = 0; i < this.inflectionPoints.size(); ++i) {
            InflectionPoint ip = (InflectionPoint)this.inflectionPoints.get(i);
            if (ip.utcDateTime < afterDateTime) break;
            if (ip.offset >= minSoFar) continue;
            minSoFar = ip.offset;
        }
        return (int)minSoFar;
    }

    public int getMinOffset(long afterDateTime) {
        long maxSoFar = Integer.MIN_VALUE;
        for (int i = 0; i < this.inflectionPoints.size(); ++i) {
            InflectionPoint ip = (InflectionPoint)this.inflectionPoints.get(i);
            if (ip.utcDateTime < afterDateTime) break;
            if (ip.offset <= maxSoFar) continue;
            maxSoFar = ip.offset;
        }
        return (int)maxSoFar;
    }

    public String toString() {
        return this.inflectionPoints.toString();
    }

    public ZoneInflections(TimeZone zone) {
        int lastOffset = zone.getOffset(endDate);
        this.inflectionPoints.add(new InflectionPoint(endDate, zone.getOffset(endDate)));
        long lastInflection = endDate;
        long lastDate = endDate;
        this.minOffset = this.maxOffset = zone.getOffset(lastDate);
        for (long currentDate = endDate; currentDate >= startDate; currentDate -= 1296000000L) {
            int currentOffset = zone.getOffset(currentDate);
            if (currentOffset != lastOffset) {
                if (currentOffset < this.minOffset) {
                    this.minOffset = currentOffset;
                }
                if (currentOffset > this.maxOffset) {
                    this.maxOffset = currentOffset;
                }
                long low = currentDate;
                int lowOffset = currentOffset;
                long high = lastDate;
                int highOffset = lastOffset;
                while (high - low > 900000L) {
                    int midOffset;
                    long mid = (high + low) / 2L;
                    if ((mid = mid / 900000L * 900000L) <= low) {
                        mid += 900000L;
                    }
                    if ((midOffset = zone.getOffset(mid)) == lowOffset) {
                        low = mid;
                        continue;
                    }
                    high = mid;
                }
                this.inflectionPoints.add(new InflectionPoint(high, highOffset));
                lastInflection = low;
            }
            lastOffset = currentOffset;
            lastDate = currentDate;
        }
        this.inflectionPoints.add(new InflectionPoint(startDate, zone.getOffset(startDate)));
    }

    public int compareTo(ZoneInflections other, OutputLong mostRecentDateTime) {
        mostRecentDateTime.value = 0L;
        if (other == null) {
            mostRecentDateTime.value = this.get((int)0).utcDateTime;
            return 1;
        }
        ZoneInflections that = other;
        int minLength = this.inflectionPoints.size();
        if (minLength < that.inflectionPoints.size()) {
            minLength = that.inflectionPoints.size();
        }
        for (int i = 0; i < minLength; ++i) {
            InflectionPoint ip1 = this.get(i);
            InflectionPoint ip2 = that.get(i);
            if (ip1.offset == ip2.offset && ip1.utcDateTime == ip2.utcDateTime) continue;
            if (ip1.offset != ip2.offset) {
                mostRecentDateTime.value = Math.max(ip1.utcDateTime, ip2.utcDateTime) - 900000L;
            } else if (ip1.utcDateTime > ip2.utcDateTime) {
                mostRecentDateTime.value = ip1.utcDateTime - 900000L;
                ip1 = this.get(i + 1);
            } else {
                mostRecentDateTime.value = ip2.utcDateTime - 900000L;
                ip2 = that.get(i + 1);
            }
            return ip1.offset > ip2.offset ? 1 : (ip1.offset < ip2.offset ? -1 : 0);
        }
        mostRecentDateTime.value = Long.MIN_VALUE;
        return 0;
    }

    InflectionPoint get(int i) {
        return (InflectionPoint)this.inflectionPoints.get(i);
    }

    int size() {
        return this.inflectionPoints.size();
    }

    public int compareTo(Object o) {
        return this.compareTo((ZoneInflections)o, this.temp);
    }

    static long getDateLong(int year, int month, int day) {
        return new Date(year - 1900, month - 1, day).getTime();
    }

    public static String formatHours(int hours) {
        return nf.format((double)hours / 3600000.0);
    }

    public static class OutputLong
    implements Comparable {
        public long value;

        public OutputLong(long value) {
            this.value = value;
        }

        public int compareTo(Object o) {
            OutputLong that = (OutputLong)o;
            return this.value < that.value ? -1 : (this.value > that.value ? 1 : 0);
        }
    }

    public static class InflectionPoint
    implements Comparable {
        static final long NONE = Long.MIN_VALUE;
        public long utcDateTime;
        long offset;

        public String toString() {
            return ICUServiceBuilder.isoDateFormat(new Date(this.utcDateTime)) + ";" + ZoneInflections.formatHours((int)this.offset);
        }

        public InflectionPoint(long utcDateTime, int offset) {
            this.utcDateTime = utcDateTime;
            this.offset = offset;
        }

        public int compareTo(Object o) {
            InflectionPoint that = (InflectionPoint)o;
            if (this.utcDateTime < that.utcDateTime) {
                return -1;
            }
            if (this.utcDateTime > that.utcDateTime) {
                return 1;
            }
            if (this.offset < that.offset) {
                return -1;
            }
            if (this.offset > that.offset) {
                return 1;
            }
            return 0;
        }
    }
}

