/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.dev.test;

import com.ibm.icu.dev.test.TestLog;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.VersionInfo;
import java.util.Date;

public abstract class AbstractTestLog
implements TestLog {
    public static boolean dontSkipForVersion = false;

    public boolean skipIfBeforeICU(int major, int minor) {
        if (dontSkipForVersion || VersionInfo.ICU_VERSION.compareTo(VersionInfo.getInstance((int)major, (int)minor)) > 0) {
            return false;
        }
        this.logln("Test skipped before ICU release " + major + "." + minor);
        return true;
    }

    public boolean isICUVersionAtLeast(int major, int minor) {
        return VersionInfo.ICU_VERSION.compareTo(VersionInfo.getInstance((int)major, (int)minor)) >= 0;
    }

    public final void log(String message) {
        this.msg(message, 0, true, false);
    }

    public final void logln(String message) {
        this.msg(message, 0, true, true);
    }

    public final void err(String message) {
        this.msg(message, 2, true, false);
    }

    public final void errln(String message) {
        this.msg(message, 2, true, true);
    }

    public final void warn(String message) {
        this.msg(message, 1, true, false);
    }

    public final void warnln(String message) {
        this.msg(message, 1, true, true);
    }

    public abstract void msg(String var1, int var2, boolean var3, boolean var4);

    public boolean isDateAtLeast(int year, int month, int day) {
        Calendar c = Calendar.getInstance();
        Date dt = new Date(year, month, day);
        return c.getTime().compareTo(dt) >= 0;
    }

    public static final class DelegatingLog
    extends AbstractTestLog {
        private TestLog delegate;

        public DelegatingLog(TestLog delegate) {
            this.delegate = delegate;
        }

        public void msg(String message, int level, boolean incCount, boolean newln) {
            if (this.delegate != null) {
                this.delegate.msg(message, level, incCount, newln);
            }
        }
    }
}

