/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.dev.test.util;

import com.ibm.icu.dev.test.util.ICUPropertyFactory;
import com.ibm.icu.dev.test.util.Tabber;
import com.ibm.icu.dev.test.util.UnicodeLabel;
import com.ibm.icu.dev.test.util.UnicodeProperty;
import com.ibm.icu.dev.test.util.Visitor;
import com.ibm.icu.impl.Utility;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.Transliterator;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.text.UnicodeSet;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;

public class BagFormatter {
    static final boolean DEBUG = false;
    public static final boolean SHOW_FILES;
    public static final PrintWriter CONSOLE;
    private static PrintWriter log;
    private boolean abbreviated = false;
    private String separator = ",";
    private String prefix = "[";
    private String suffix = "]";
    private UnicodeProperty.Factory source;
    private UnicodeLabel nameSource;
    private UnicodeLabel labelSource;
    private UnicodeLabel rangeBreakSource;
    private UnicodeLabel valueSource;
    private String propName = "";
    private boolean showCount = true;
    private boolean skipNullValues = true;
    private boolean hexValue = false;
    private static final String NULL_VALUE = "_NULL_VALUE_";
    private int fullTotal = -1;
    private boolean showTotal = true;
    private String lineSeparator = "\r\n";
    private Tabber tabber = new Tabber.MonoTabber();
    private Relation r = new NullRelation();
    private Join labelVisitor = new Join();
    private boolean mergeRanges = true;
    private Transliterator showLiteral = null;
    private Transliterator fixName = null;
    private boolean showSetAlso = false;
    private RangeFinder rf = new RangeFinder();
    private MessageFormat inOut = new MessageFormat("In {0}, but not in {1}:");
    private MessageFormat outIn = new MessageFormat("Not in {0}, but in {1}:");
    private MessageFormat inIn = new MessageFormat("In both {0}, and in {1}:");
    private MyVisitor mainVisitor = new MyVisitor();
    private static NumberFormat nf;
    boolean shortLabel = true;
    boolean shortValue = true;
    public static final Transliterator hex;

    public String showSetDifferences(String name1, UnicodeSet set1, String name2, UnicodeSet set2) {
        StringWriter result = new StringWriter();
        this.showSetDifferences(new PrintWriter(result), name1, set1, name2, set2);
        result.flush();
        return result.getBuffer().toString();
    }

    public String showSetDifferences(String name1, Collection set1, String name2, Collection set2) {
        StringWriter result = new StringWriter();
        this.showSetDifferences(new PrintWriter(result), name1, set1, name2, set2);
        result.flush();
        return result.getBuffer().toString();
    }

    public void showSetDifferences(PrintWriter pw, String name1, UnicodeSet set1, String name2, UnicodeSet set2) {
        this.showSetDifferences(pw, name1, set1, name2, set2, -1);
    }

    public void showSetDifferences(PrintWriter pw, String name1, UnicodeSet set1, String name2, UnicodeSet set2, int flags) {
        UnicodeSet temp;
        if (pw == null) {
            pw = CONSOLE;
        }
        String[] names = new String[]{name1, name2};
        if ((flags & 1) != 0) {
            temp = new UnicodeSet(set1).removeAll(set2);
            pw.print(this.lineSeparator);
            pw.print(this.inOut.format(names));
            pw.print(this.lineSeparator);
            this.showSetNames(pw, (Object)temp);
        }
        if ((flags & 2) != 0) {
            temp = new UnicodeSet(set2).removeAll(set1);
            pw.print(this.lineSeparator);
            pw.print(this.outIn.format(names));
            pw.print(this.lineSeparator);
            this.showSetNames(pw, (Object)temp);
        }
        if ((flags & 4) != 0) {
            temp = new UnicodeSet(set2).retainAll(set1);
            pw.print(this.lineSeparator);
            pw.print(this.inIn.format(names));
            pw.print(this.lineSeparator);
            this.showSetNames(pw, (Object)temp);
        }
        pw.flush();
    }

    public void showSetDifferences(PrintWriter pw, String name1, Collection set1, String name2, Collection set2) {
        if (pw == null) {
            pw = CONSOLE;
        }
        String[] names = new String[]{name1, name2};
        HashSet temp = new HashSet(set1);
        temp.removeAll(set2);
        pw.println();
        pw.println(this.inOut.format(names));
        this.showSetNames(pw, temp);
        temp.clear();
        temp.addAll(set2);
        temp.removeAll(set1);
        pw.println();
        pw.println(this.outIn.format(names));
        this.showSetNames(pw, temp);
        temp.clear();
        temp.addAll(set1);
        temp.retainAll(set2);
        pw.println();
        pw.println(this.inIn.format(names));
        this.showSetNames(pw, temp);
    }

    public String showSetNames(Object c) {
        StringWriter buffer = new StringWriter();
        PrintWriter output = new PrintWriter(buffer);
        this.showSetNames(output, c);
        return buffer.toString();
    }

    public void showSetNames(PrintWriter output, Object c) {
        this.mainVisitor.doAt(c, output);
        output.flush();
    }

    public void showSetNames(String filename, Object c) throws IOException {
        PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), "utf-8"));
        this.showSetNames(log, c);
        pw.close();
    }

    public String getAbbreviatedName(String source, String pattern, String substitute) {
        int matchEnd = NameIterator.findMatchingEnd(source, pattern);
        int sdiv = source.length() - matchEnd;
        int pdiv = pattern.length() - matchEnd;
        StringBuffer result = new StringBuffer();
        this.addMatching(source.substring(0, sdiv), pattern.substring(0, pdiv), substitute, result);
        this.addMatching(source.substring(sdiv), pattern.substring(pdiv), substitute, result);
        return result.toString();
    }

    public BagFormatter setRelation(Relation r) {
        this.r = r;
        return this;
    }

    public Relation getRelation() {
        return this.r;
    }

    public BagFormatter setMergeRanges(boolean in) {
        this.mergeRanges = in;
        return this;
    }

    public BagFormatter setShowSetAlso(boolean b) {
        this.showSetAlso = b;
        return this;
    }

    public String getName(int codePoint) {
        return this.getName("", codePoint, codePoint);
    }

    public String getName(String separator, int start, int end) {
        if (this.getNameSource() == null || this.getNameSource() == UnicodeLabel.NULL) {
            return "";
        }
        String result = this.getName(start, false);
        if (start == end) {
            return separator + result;
        }
        String endString = this.getName(end, false);
        if (result.length() == 0 && endString.length() == 0) {
            return separator;
        }
        if (this.abbreviated) {
            endString = this.getAbbreviatedName(endString, result, "~");
        }
        return separator + result + ".." + endString;
    }

    public String getName(String s) {
        return this.getName(s, false);
    }

    public String getName(int codePoint, boolean withCodePoint) {
        String result = this.getNameSource().getValue(codePoint, !withCodePoint);
        return this.fixName == null ? result : this.fixName.transliterate(result);
    }

    public String getName(String s, boolean withCodePoint) {
        String result = this.getNameSource().getValue(s, this.separator, !withCodePoint);
        return this.fixName == null ? result : this.fixName.transliterate(result);
    }

    public String hex(String s) {
        return this.hex(s, this.separator);
    }

    public String hex(String s, String separator) {
        return UnicodeLabel.HEX.getValue(s, separator, true);
    }

    public String hex(int start, int end) {
        String s = Utility.hex((int)start, (int)4);
        if (start == end) {
            return s;
        }
        return s + ".." + Utility.hex((int)end, (int)4);
    }

    public BagFormatter setUnicodePropertyFactory(UnicodeProperty.Factory source) {
        this.source = source;
        return this;
    }

    public UnicodeProperty.Factory getUnicodePropertyFactory() {
        if (this.source == null) {
            this.source = ICUPropertyFactory.make();
        }
        return this.source;
    }

    public BagFormatter() {
    }

    public BagFormatter(UnicodeProperty.Factory source) {
        this.setUnicodePropertyFactory(source);
    }

    public String join(Object o) {
        return this.labelVisitor.join(o);
    }

    private void addMatching(String source, String pattern, String substitute, StringBuffer result) {
        String s1;
        NameIterator n1 = new NameIterator(source);
        NameIterator n2 = new NameIterator(pattern);
        boolean first = true;
        while ((s1 = n1.next()) != null) {
            String s2 = n2.next();
            if (!first) {
                result.append(" ");
            }
            first = false;
            if (s1.equals(s2)) {
                result.append(substitute);
                continue;
            }
            result.append(s1);
        }
    }

    boolean equalTo(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (a == null) {
            return false;
        }
        return a.equals(b);
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public BagFormatter setPrefix(String string) {
        this.prefix = string;
        return this;
    }

    public BagFormatter setSuffix(String string) {
        this.suffix = string;
        return this;
    }

    public boolean isAbbreviated() {
        return this.abbreviated;
    }

    public BagFormatter setAbbreviated(boolean b) {
        this.abbreviated = b;
        return this;
    }

    public UnicodeLabel getLabelSource(boolean visible) {
        if (this.labelSource == null) {
            HashMap<String, String> labelMap = new HashMap<String, String>();
            labelMap.put("Lu", "L&");
            labelMap.put("Lt", "L&");
            labelMap.put("Ll", "L&");
            this.labelSource = new UnicodeProperty.FilteredProperty(this.getUnicodePropertyFactory().getProperty("General_Category"), new UnicodeProperty.MapFilter(labelMap)).setAllowValueAliasCollisions(true);
        }
        return this.labelSource;
    }

    public static void addAll(UnicodeSet source, Collection target) {
        source.addAllTo(target);
    }

    public static BufferedReader openUTF8Reader(String dir, String filename) throws IOException {
        return BagFormatter.openReader(dir, filename, "UTF-8");
    }

    public static BufferedReader openReader(String dir, String filename, String encoding) throws IOException {
        File file = new File(dir + filename);
        if (SHOW_FILES && log != null) {
            log.println("Opening File: " + file.getCanonicalPath());
        }
        return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), encoding), 4096);
    }

    public static PrintWriter openUTF8Writer(String dir, String filename) throws IOException {
        return BagFormatter.openWriter(dir, filename, "UTF-8");
    }

    public static PrintWriter openWriter(String dir, String filename, String encoding) throws IOException {
        String parentName;
        File file = new File(dir + filename);
        if (SHOW_FILES && log != null) {
            log.println("Creating File: " + file.getCanonicalPath());
        }
        if ((parentName = file.getParent()) != null) {
            File parent = new File(parentName);
            parent.mkdirs();
        }
        return new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding), 4096));
    }

    public static PrintWriter getLog() {
        return log;
    }

    public BagFormatter setLog(PrintWriter writer) {
        log = writer;
        return this;
    }

    public String getSeparator() {
        return this.separator;
    }

    public BagFormatter setSeparator(String string) {
        this.separator = string;
        return this;
    }

    public Transliterator getShowLiteral() {
        return this.showLiteral;
    }

    public BagFormatter setShowLiteral(Transliterator transliterator) {
        this.showLiteral = transliterator;
        return this;
    }

    public BagFormatter setLabelSource(UnicodeLabel label) {
        if (label == null) {
            label = UnicodeLabel.NULL;
        }
        this.labelSource = label;
        return this;
    }

    public UnicodeLabel getNameSource() {
        if (this.nameSource == null) {
            this.nameSource = new NameLabel(this.getUnicodePropertyFactory());
        }
        return this.nameSource;
    }

    public BagFormatter setNameSource(UnicodeLabel label) {
        if (label == null) {
            label = UnicodeLabel.NULL;
        }
        this.nameSource = label;
        return this;
    }

    public UnicodeLabel getValueSource() {
        if (this.valueSource == null) {
            this.valueSource = UnicodeLabel.NULL;
        }
        return this.valueSource;
    }

    private String getValue(int cp, boolean shortValue) {
        String result = this.getValueSource().getValue(cp, shortValue);
        if (result == null) {
            return NULL_VALUE;
        }
        if (this.hexValue) {
            result = this.hex(result, " ");
        }
        return result;
    }

    public BagFormatter setValueSource(UnicodeLabel label) {
        if (label == null) {
            label = UnicodeLabel.NULL;
        }
        this.valueSource = label;
        return this;
    }

    public BagFormatter setValueSource(String label) {
        return this.setValueSource(new UnicodeLabel.Constant(label));
    }

    public boolean isShowCount() {
        return this.showCount;
    }

    public BagFormatter setShowCount(boolean b) {
        this.showCount = b;
        return this;
    }

    public String getPropName() {
        return this.propName;
    }

    public BagFormatter setPropName(String string) {
        if (string == null) {
            string = "";
        }
        this.propName = string;
        return this;
    }

    public boolean isHexValue() {
        return this.hexValue;
    }

    public BagFormatter setHexValue(boolean b) {
        this.hexValue = b;
        return this;
    }

    public int getFullTotal() {
        return this.fullTotal;
    }

    public BagFormatter setFullTotal(int i) {
        this.fullTotal = i;
        return this;
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public BagFormatter setLineSeparator(String string) {
        this.lineSeparator = string;
        return this;
    }

    public UnicodeLabel getRangeBreakSource() {
        if (this.rangeBreakSource == null) {
            HashMap<String, String> labelMap = new HashMap<String, String>();
            labelMap.put("Lo", "G&");
            labelMap.put("Lm", "G&");
            labelMap.put("Lu", "G&");
            labelMap.put("Lt", "G&");
            labelMap.put("Ll", "G&");
            labelMap.put("Mn", "G&");
            labelMap.put("Me", "G&");
            labelMap.put("Mc", "G&");
            labelMap.put("Nd", "G&");
            labelMap.put("Nl", "G&");
            labelMap.put("No", "G&");
            labelMap.put("Zs", "G&");
            labelMap.put("Pd", "G&");
            labelMap.put("Ps", "G&");
            labelMap.put("Pe", "G&");
            labelMap.put("Pc", "G&");
            labelMap.put("Po", "G&");
            labelMap.put("Pi", "G&");
            labelMap.put("Pf", "G&");
            labelMap.put("Sm", "G&");
            labelMap.put("Sc", "G&");
            labelMap.put("Sk", "G&");
            labelMap.put("So", "G&");
            labelMap.put("Zl", "Cf");
            labelMap.put("Zp", "Cf");
            this.rangeBreakSource = new UnicodeProperty.FilteredProperty(this.getUnicodePropertyFactory().getProperty("General_Category"), new UnicodeProperty.MapFilter(labelMap)).setAllowValueAliasCollisions(true);
        }
        return this.rangeBreakSource;
    }

    public BagFormatter setRangeBreakSource(UnicodeLabel label) {
        if (label == null) {
            label = UnicodeLabel.NULL;
        }
        this.rangeBreakSource = label;
        return this;
    }

    public Transliterator getFixName() {
        return this.fixName;
    }

    public void setFixName(Transliterator fixName) {
        this.fixName = fixName;
    }

    public Tabber getTabber() {
        return this.tabber;
    }

    public void setTabber(Tabber tabber) {
        this.tabber = tabber;
    }

    public boolean isShowTotal() {
        return this.showTotal;
    }

    public void setShowTotal(boolean showTotal) {
        this.showTotal = showTotal;
    }

    static {
        boolean showFiles = false;
        try {
            showFiles = System.getProperty("SHOW_FILES") != null;
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        SHOW_FILES = showFiles;
        log = CONSOLE = new PrintWriter(System.out, true);
        nf = NumberFormat.getIntegerInstance((Locale)Locale.ENGLISH);
        nf.setGroupingUsed(false);
        hex = Transliterator.getInstance((String)"[^\\u0009\\u0020-\\u007E\\u00A0-\\u00FF] hex");
    }

    private class Join
    extends Visitor {
        StringBuffer output = new StringBuffer();
        int depth = 0;

        private Join() {
        }

        String join(Object o) {
            this.output.setLength(0);
            this.doAt(o);
            return this.output.toString();
        }

        protected void doBefore(Object container, Object item) {
            ++this.depth;
            this.output.append(BagFormatter.this.prefix);
        }

        protected void doAfter(Object container, Object item) {
            this.output.append(BagFormatter.this.suffix);
            --this.depth;
        }

        protected void doBetween(Object container, Object lastItem, Object nextItem) {
            this.output.append(BagFormatter.this.separator);
        }

        protected void doSimpleAt(Object o) {
            if (o != null) {
                this.output.append(o.toString());
            }
        }
    }

    private class RangeFinder {
        int start;
        int limit;
        private int veryLimit;

        private RangeFinder() {
        }

        void reset(int start, int limit) {
            this.limit = start;
            this.veryLimit = limit;
        }

        boolean next() {
            if (this.limit >= this.veryLimit) {
                return false;
            }
            this.start = this.limit;
            String label = BagFormatter.this.getLabelSource(false).getValue(this.limit, true);
            String value = BagFormatter.this.getValue(this.limit, true);
            String breaker = BagFormatter.this.getRangeBreakSource().getValue(this.limit, true);
            ++this.limit;
            while (this.limit < this.veryLimit) {
                String s = BagFormatter.this.getLabelSource(false).getValue(this.limit, true);
                String v = BagFormatter.this.getValue(this.limit, true);
                String b = BagFormatter.this.getRangeBreakSource().getValue(this.limit, true);
                if (!BagFormatter.this.equalTo(s, label) || !BagFormatter.this.equalTo(v, value) || !BagFormatter.this.equalTo(b, breaker)) break;
                ++this.limit;
            }
            return true;
        }
    }

    private static class NameIterator {
        String source;
        int position;
        int start;
        int limit;

        NameIterator(String source) {
            this.source = source;
            this.start = 0;
            this.limit = source.length();
        }

        String next() {
            if (this.position >= this.limit) {
                return null;
            }
            int pos = this.source.indexOf(32, this.position);
            if (pos < 0 || pos >= this.limit) {
                pos = this.limit;
            }
            String result = this.source.substring(this.position, pos);
            this.position = pos + 1;
            return result;
        }

        static int findMatchingEnd(String s1, String s2) {
            int i = s1.length();
            int j = s2.length();
            try {
                while (s1.charAt(--i) == s2.charAt(--j)) {
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            ++i;
            i = s1.indexOf(32, i);
            if (i < 0) {
                return 0;
            }
            return s1.length() - i;
        }
    }

    private class MyVisitor
    extends Visitor {
        private PrintWriter output;
        String commentSeparator;
        int counter;
        int valueSize;
        int labelSize;

        private MyVisitor() {
        }

        public void doAt(Object c, PrintWriter output) {
            this.output = output;
            this.counter = 0;
            BagFormatter.this.tabber.clear();
            BagFormatter.this.tabber.add(BagFormatter.this.mergeRanges ? 14 : 6, (byte)0);
            if (BagFormatter.this.propName.length() > 0) {
                BagFormatter.this.tabber.add(BagFormatter.this.propName.length() + 2, (byte)0);
            }
            this.valueSize = BagFormatter.this.getValueSource().getMaxWidth(BagFormatter.this.shortValue);
            if (BagFormatter.this.getValueSource() != UnicodeLabel.NULL) {
                BagFormatter.this.tabber.add(this.valueSize + 2, (byte)0);
            }
            BagFormatter.this.tabber.add(3, (byte)0);
            this.labelSize = BagFormatter.this.getLabelSource(true).getMaxWidth(BagFormatter.this.shortLabel);
            if (this.labelSize > 0) {
                BagFormatter.this.tabber.add(this.labelSize + 1, (byte)0);
            }
            if (BagFormatter.this.mergeRanges && BagFormatter.this.showCount) {
                BagFormatter.this.tabber.add(5, (byte)2);
            }
            if (BagFormatter.this.showLiteral != null) {
                BagFormatter.this.tabber.add(4, (byte)0);
            }
            this.commentSeparator = BagFormatter.this.showCount || BagFormatter.this.showLiteral != null || BagFormatter.this.getLabelSource(true) != UnicodeLabel.NULL || BagFormatter.this.getNameSource() != UnicodeLabel.NULL ? "\t #" : "";
            this.doAt(c);
        }

        public String format(Object o) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            this.doAt(o);
            pw.flush();
            String result = sw.getBuffer().toString();
            pw.close();
            return result;
        }

        protected void doBefore(Object container, Object o) {
            if (BagFormatter.this.showSetAlso && container instanceof UnicodeSet) {
                this.output.print("#" + container + BagFormatter.this.lineSeparator);
            }
        }

        protected void doBetween(Object container, Object lastItem, Object nextItem) {
        }

        protected void doAfter(Object container, Object o) {
            if (BagFormatter.this.fullTotal != -1 && BagFormatter.this.fullTotal != this.counter) {
                if (BagFormatter.this.showTotal) {
                    this.output.print(BagFormatter.this.lineSeparator);
                    this.output.print("# The above property value applies to " + nf.format((long)(BagFormatter.this.fullTotal - this.counter)) + " code points not listed here." + BagFormatter.this.lineSeparator);
                    this.output.print("# Total code points: " + nf.format((long)BagFormatter.this.fullTotal) + BagFormatter.this.lineSeparator);
                }
                BagFormatter.this.fullTotal = -1;
            } else if (BagFormatter.this.showTotal) {
                this.output.print(BagFormatter.this.lineSeparator);
                this.output.print("# Total code points: " + nf.format((long)this.counter) + BagFormatter.this.lineSeparator);
            }
        }

        protected void doSimpleAt(Object o) {
            if (o instanceof Map.Entry) {
                Map.Entry oo = (Map.Entry)o;
                Object key = oo.getKey();
                Object value = oo.getValue();
                this.doBefore(o, key);
                this.doAt(key);
                this.output.print("->");
                this.doAt(value);
                this.doAfter(o, value);
                ++this.counter;
            } else if (o instanceof Visitor.CodePointRange) {
                this.doAt((Visitor.CodePointRange)o);
            } else {
                String label;
                String value;
                String thing = o.toString();
                String string = value = BagFormatter.this.getValueSource() == UnicodeLabel.NULL ? "" : BagFormatter.this.getValueSource().getValue(thing, ",", true);
                if (BagFormatter.this.getValueSource() != UnicodeLabel.NULL) {
                    value = "\t; " + value;
                }
                String string2 = label = BagFormatter.this.getLabelSource(true) == UnicodeLabel.NULL ? "" : BagFormatter.this.getLabelSource(true).getValue(thing, ",", true);
                if (label.length() != 0) {
                    label = " " + label;
                }
                this.output.print(BagFormatter.this.tabber.process(BagFormatter.this.hex(thing) + value + this.commentSeparator + label + this.insertLiteral(thing) + "\t" + BagFormatter.this.getName(thing)) + BagFormatter.this.lineSeparator);
                ++this.counter;
            }
        }

        protected void doAt(Visitor.CodePointRange usi) {
            if (!BagFormatter.this.mergeRanges) {
                for (int cp = usi.codepoint; cp <= usi.codepointEnd; ++cp) {
                    this.showLine(cp, cp);
                }
            } else {
                BagFormatter.this.rf.reset(usi.codepoint, usi.codepointEnd + 1);
                while (BagFormatter.this.rf.next()) {
                    this.showLine(((BagFormatter)BagFormatter.this).rf.start, ((BagFormatter)BagFormatter.this).rf.limit - 1);
                }
            }
        }

        private void showLine(int start, int end) {
            String label = BagFormatter.this.getLabelSource(true).getValue(start, BagFormatter.this.shortLabel);
            String value = BagFormatter.this.getValue(start, BagFormatter.this.shortValue);
            if (value == BagFormatter.NULL_VALUE) {
                return;
            }
            this.counter += end - start + 1;
            String pn = BagFormatter.this.propName;
            if (pn.length() != 0) {
                pn = "\t; " + pn;
            }
            if (this.valueSize > 0) {
                value = "\t; " + value;
            } else if (value.length() > 0) {
                throw new IllegalArgumentException("maxwidth bogus " + value + "," + BagFormatter.this.getValueSource().getMaxWidth(BagFormatter.this.shortValue));
            }
            if (this.labelSize > 0) {
                label = "\t" + label;
            } else if (label.length() > 0) {
                throw new IllegalArgumentException("maxwidth bogus " + label + ", " + BagFormatter.this.getLabelSource(true).getMaxWidth(BagFormatter.this.shortLabel));
            }
            String count = "";
            if (BagFormatter.this.mergeRanges && BagFormatter.this.showCount) {
                count = end == start ? "\t" : "\t [" + nf.format((long)(end - start + 1)) + "]";
            }
            this.output.print(BagFormatter.this.tabber.process(BagFormatter.this.hex(start, end) + pn + value + this.commentSeparator + label + count + this.insertLiteral(start, end) + BagFormatter.this.getName("\t ", start, end)) + BagFormatter.this.lineSeparator);
        }

        private String insertLiteral(String thing) {
            return BagFormatter.this.showLiteral == null ? "" : " \t(" + BagFormatter.this.showLiteral.transliterate(thing) + ") ";
        }

        private String insertLiteral(int start, int end) {
            return BagFormatter.this.showLiteral == null ? "" : " \t(" + BagFormatter.this.showLiteral.transliterate(UTF16.valueOf((int)start)) + (start != end ? ".." + BagFormatter.this.showLiteral.transliterate(UTF16.valueOf((int)end)) : "") + ") ";
        }
    }

    public static class NameLabel
    extends UnicodeLabel {
        UnicodeProperty nameProp;
        UnicodeSet control;
        UnicodeSet private_use;
        UnicodeSet noncharacter;
        UnicodeSet surrogate;

        public NameLabel(UnicodeProperty.Factory source) {
            this.nameProp = source.getProperty("Name");
            this.control = source.getSet("gc=Cc");
            this.private_use = source.getSet("gc=Co");
            this.surrogate = source.getSet("gc=Cs");
            this.noncharacter = source.getSet("noncharactercodepoint=true");
        }

        public String getValue(int codePoint, boolean isShort) {
            String hcp = !isShort ? "U+" + Utility.hex((int)codePoint, (int)4) + " " : "";
            String result = this.nameProp.getValue(codePoint);
            if (result != null) {
                return hcp + result;
            }
            if (this.control.contains(codePoint)) {
                return "<control-" + Utility.hex((int)codePoint, (int)4) + ">";
            }
            if (this.private_use.contains(codePoint)) {
                return "<private-use-" + Utility.hex((int)codePoint, (int)4) + ">";
            }
            if (this.noncharacter.contains(codePoint)) {
                return "<noncharacter-" + Utility.hex((int)codePoint, (int)4) + ">";
            }
            if (this.surrogate.contains(codePoint)) {
                return "<surrogate-" + Utility.hex((int)codePoint, (int)4) + ">";
            }
            return hcp + "<reserved-" + Utility.hex((int)codePoint, (int)4) + ">";
        }
    }

    static class NullRelation
    extends Relation {
        NullRelation() {
        }

        public String getRelation(String a, String b) {
            return "";
        }
    }

    public static abstract class Relation {
        public abstract String getRelation(String var1, String var2);
    }
}

