/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.dev.test.util;

import com.ibm.icu.dev.test.TestFmwk;
import com.ibm.icu.util.Currency;
import com.ibm.icu.util.ULocale;
import java.util.Locale;

public class CurrencyTest
extends TestFmwk {
    public static void main(String[] args) throws Exception {
        new CurrencyTest().run(args);
    }

    public void TestAPI() {
        Locale[] avail;
        Currency usd = Currency.getInstance((String)"USD");
        usd.hashCode();
        Currency jpy = Currency.getInstance((String)"JPY");
        if (usd.equals((Object)jpy)) {
            this.errln("FAIL: USD == JPY");
        }
        if (usd.equals((Object)"abc")) {
            this.errln("FAIL: USD == (String)");
        }
        if (usd.equals(null)) {
            this.errln("FAIL: USD == (null)");
        }
        if (!usd.equals((Object)usd)) {
            this.errln("FAIL: USD != USD");
        }
        if ((avail = Currency.getAvailableLocales()) == null) {
            this.errln("FAIL: getAvailableLocales returned null");
        }
        try {
            usd.getName(ULocale.US, 5, new boolean[1]);
            this.errln("expected getName with invalid type parameter to throw exception");
        }
        catch (Exception e) {
            this.logln("PASS: getName failed as expected");
        }
    }

    public void TestRegistration() {
        Currency nus2;
        Currency nus1;
        Currency jpy = Currency.getInstance((String)"JPY");
        Currency usd = Currency.getInstance((Locale)Locale.US);
        try {
            Currency.unregister(null);
            this.errln("expected unregister of null to throw exception");
        }
        catch (Exception e) {
            this.logln("PASS: unregister of null failed as expected");
        }
        if (Currency.unregister((Object)"")) {
            this.errln("unregister before register erroneously succeeded");
        }
        ULocale fu_FU = new ULocale("fu_FU");
        Object key1 = Currency.registerInstance((Currency)jpy, (ULocale)ULocale.US);
        Object key2 = Currency.registerInstance((Currency)jpy, (ULocale)fu_FU);
        Currency nus = Currency.getInstance((Locale)Locale.US);
        if (!nus.equals((Object)jpy)) {
            this.errln("expected " + jpy + " but got: " + nus);
        }
        if (!(nus1 = Currency.getInstance((Locale)Locale.JAPAN)).equals((Object)jpy)) {
            this.errln("expected " + jpy + " but got: " + nus1);
        }
        ULocale[] locales = Currency.getAvailableULocales();
        boolean found = false;
        for (int i = 0; i < locales.length; ++i) {
            if (!locales[i].equals((Object)fu_FU)) continue;
            found = true;
            break;
        }
        if (!found) {
            this.errln("did not find locale" + fu_FU + " in currency locales");
        }
        if (!Currency.unregister((Object)key1)) {
            this.errln("unable to unregister currency using key1");
        }
        if (!Currency.unregister((Object)key2)) {
            this.errln("unable to unregister currency using key2");
        }
        if (!(nus2 = Currency.getInstance((Locale)Locale.US)).equals((Object)usd)) {
            this.errln("expected " + usd + " but got: " + nus2);
        }
        locales = Currency.getAvailableULocales();
        found = false;
        for (int i = 0; i < locales.length; ++i) {
            if (!locales[i].equals((Object)fu_FU)) continue;
            found = true;
            break;
        }
        if (found) {
            this.errln("found locale" + fu_FU + " in currency locales after unregister");
        }
    }

    public void TestNames() {
        ULocale en = ULocale.ENGLISH;
        boolean[] isChoiceFormat = new boolean[1];
        Currency usd = Currency.getInstance((String)"USD");
        if (!this.noData()) {
            this.assertEquals("USD.getName(SYMBOL_NAME)", "US$", usd.getName(en, 0, isChoiceFormat));
            this.assertEquals("USD.getName(LONG_NAME)", "US Dollar", usd.getName(en, 1, isChoiceFormat));
        }
    }

    public void TestCoverage() {
        Currency usd = Currency.getInstance((String)"USD");
        if (!this.noData()) {
            this.assertEquals("USD.getSymbol()", "$", usd.getSymbol());
        }
        this.assertEquals("USD.getLocale()", ULocale.ROOT, usd.getLocale(null));
    }

    public void TestCurrencyKeyword() {
        ULocale locale = new ULocale("th_TH@collation=traditional;currency=QQQ");
        Currency currency = Currency.getInstance((ULocale)locale);
        String result = currency.getCurrencyCode();
        if (!"QQQ".equals(result)) {
            this.errln("got unexpected currency: " + result);
        }
    }
}

