/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.dev.test.util;

import com.ibm.icu.dev.test.TestFmwk;
import com.ibm.icu.impl.Utility;
import java.util.ResourceBundle;

public final class ICUListResourceBundleTest
extends TestFmwk {
    String simpleAlias = "Open";
    Object[][] zoneTests = new Object[][]{{"zoneAlias", new String[]{"PST", "Pacific Standard Time", "PST", "Pacific Daylight Time", "PDT", "Los Angeles"}}, {"zoneAlias1", new String[]{"America/Denver", "Mountain Standard Time", "MST", "Mountain Daylight Time", "MDT", "Denver"}}, {"zoneAlias2", "America/Denver"}};
    Object[] zoneStrings = new Object[]{new String[]{"PST", "Pacific Standard Time", "PST", "Pacific Daylight Time", "PDT", "Los Angeles"}, new String[]{"America/Los_Angeles", "Pacific Standard Time", "PST", "Pacific Daylight Time", "PDT", "Los Angeles"}};
    Object[] testGetStringByIndexAliasing = new String[]{"PST", "Pacific Standard Time", "PDT", "Los Angeles"};
    Object[][] testGetStringByKeyAliasing = new Object[][]{{"KeyAlias0PST", "PST"}, {"KeyAlias1PacificStandardTime", "Pacific Standard Time"}, {"KeyAlias2PDT", "PDT"}, {"KeyAlias3LosAngeles", "Los Angeles"}};

    public static void main(String[] args) throws Exception {
        ICUListResourceBundleTest test = new ICUListResourceBundleTest();
        test.run(args);
    }

    public void TestReferences() {
        ResourceBundle rb = null;
        byte[] binaryData = null;
        Object colElem = rb.getObject("collations");
        if (colElem instanceof Object[][]) {
            Object[][] colElemArr = (Object[][])colElem;
            if (((String)colElemArr[0][0]).equals("%%CollationBin")) {
                binaryData = (byte[])colElemArr[0][1];
            }
        } else {
            this.errln("Did not get the expected object");
        }
        this.logln("got binaryData: " + binaryData + " length: " + (binaryData == null ? 0 : binaryData.length));
        Object[] stringArrayData = (Object[])rb.getObject("collations");
        this.logln("got stringData: " + stringArrayData + " length: " + stringArrayData.length);
        this.logln("got stringDataElement: " + stringArrayData[0] + " length: " + stringArrayData.length);
    }

    private boolean arrayEquals(Object[][] s1, Object[][] s2) {
        boolean isEqual = true;
        if (s1.length != s2.length) {
            return false;
        }
        for (int i = 0; i < s1.length; ++i) {
            if (s1[i] instanceof Object[][] && s2[i] instanceof Object[][]) {
                if (this.arrayEquals((Object[][])s1[i], (Object[][])s2[i])) continue;
                isEqual = false;
                continue;
            }
            if (s1[i] instanceof Object[] && s2[i] instanceof Object[]) {
                if (Utility.arrayEquals((Object[])s1[i], (Object)s2[i])) continue;
                isEqual = false;
                continue;
            }
            if (s1[i] instanceof Object && s2[i] instanceof Object) {
                if (s1[i].equals(s2[i])) continue;
                isEqual = false;
                continue;
            }
            isEqual = false;
            break;
        }
        return isEqual;
    }
}

