/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.dev.test.util;

import com.ibm.icu.dev.test.util.UnicodeProperty;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.Normalizer;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.util.VersionInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class ICUPropertyFactory
extends UnicodeProperty.Factory {
    static final Names Binary_Extras = new Names(49, new String[]{"isNFC", "isNFD", "isNFKC", "isNFKD", "isLowercase", "isUppercase", "isTitlecase", "isCasefolded", "isCased"});
    static final Names String_Extras = new Names(16397, new String[]{"toNFC", "toNFD", "toNFKC", "toNKFD"});
    static final int isNFC = 49;
    static final int isNFD = 50;
    static final int isNFKC = 51;
    static final int isNFKD = 52;
    static final int isLowercase = 53;
    static final int isUppercase = 54;
    static final int isTitlecase = 55;
    static final int isCasefolded = 56;
    static final int isCased = 57;
    static final int NFC = 16397;
    static final int NFD = 16398;
    static final int NFKC = 16399;
    static final int NFKD = 16400;
    private static ICUPropertyFactory singleton = null;

    private ICUPropertyFactory() {
        List c = this.getInternalAvailablePropertyAliases(new ArrayList());
        Iterator it = c.iterator();
        while (it.hasNext()) {
            this.add(this.getInternalProperty((String)it.next()));
        }
    }

    public static synchronized ICUPropertyFactory make() {
        if (singleton != null) {
            return singleton;
        }
        singleton = new ICUPropertyFactory();
        return singleton;
    }

    public List getInternalAvailablePropertyAliases(List result) {
        int[][] ranges = new int[][]{{0, 49}, {4096, 4117}, {12288, 12289}, {16384, 16397}};
        for (int i = 0; i < ranges.length; ++i) {
            for (int j = ranges[i][0]; j < ranges[i][1]; ++j) {
                String alias = UCharacter.getPropertyName((int)j, (int)1);
                UnicodeProperty.addUnique(alias, result);
                if (result.contains(alias)) continue;
                result.add(alias);
            }
        }
        result.addAll(String_Extras.getNames());
        result.addAll(Binary_Extras.getNames());
        return result;
    }

    public UnicodeProperty getInternalProperty(String propertyAlias) {
        int possibleItem = Binary_Extras.get(propertyAlias);
        int propEnum = possibleItem >= 0 ? possibleItem : ((possibleItem = String_Extras.get(propertyAlias)) >= 0 ? possibleItem : UCharacter.getPropertyEnum((String)propertyAlias));
        return new ICUProperty(propertyAlias, propEnum);
    }

    public static class Names {
        private String[] names;
        private int base;

        public Names(int base, String[] names) {
            this.base = base;
            this.names = names;
        }

        public int get(String name) {
            for (int i = 0; i < this.names.length; ++i) {
                if (!name.equalsIgnoreCase(this.names[i])) continue;
                return this.base + i;
            }
            return -1;
        }

        public String get(int number) {
            if ((number -= this.base) < 0 || this.names.length <= number) {
                return null;
            }
            return this.names[number];
        }

        public boolean isInRange(int number) {
            return 0 <= (number -= this.base) && number < this.names.length;
        }

        public List getNames() {
            return Arrays.asList(this.names);
        }
    }

    static class ICUProperty
    extends UnicodeProperty {
        protected int propEnum = Integer.MIN_VALUE;
        boolean shownException = false;
        static Map fixSkeleton = new HashMap();
        private Map cccHack = new HashMap();
        boolean needCccHack = true;

        protected ICUProperty(String propName, int propEnum) {
            this.setName(propName);
            this.propEnum = propEnum;
            this.setType(this.internalGetPropertyType(propEnum));
        }

        public String _getValue(int codePoint) {
            switch (this.propEnum) {
                case 16384: {
                    String temp = UCharacter.getAge((int)codePoint).toString();
                    if (temp.equals("0.0.0.0")) {
                        return "unassigned";
                    }
                    if (temp.endsWith(".0.0")) {
                        return temp.substring(0, temp.length() - 4);
                    }
                    return temp;
                }
                case 16385: {
                    return UTF16.valueOf((int)UCharacter.getMirror((int)codePoint));
                }
                case 16386: {
                    return UCharacter.foldCase((String)UTF16.valueOf((int)codePoint), (boolean)true);
                }
                case 16387: {
                    return UCharacter.getISOComment((int)codePoint);
                }
                case 16388: {
                    return UCharacter.toLowerCase((Locale)Locale.ENGLISH, (String)UTF16.valueOf((int)codePoint));
                }
                case 16389: {
                    return UCharacter.getName((int)codePoint);
                }
                case 16390: {
                    return UTF16.valueOf((int)UCharacter.foldCase((int)codePoint, (boolean)true));
                }
                case 16391: {
                    return UTF16.valueOf((int)UCharacter.toLowerCase((int)codePoint));
                }
                case 16392: {
                    return UTF16.valueOf((int)UCharacter.toTitleCase((int)codePoint));
                }
                case 16393: {
                    return UTF16.valueOf((int)UCharacter.toUpperCase((int)codePoint));
                }
                case 16394: {
                    return UCharacter.toTitleCase((Locale)Locale.ENGLISH, (String)UTF16.valueOf((int)codePoint), null);
                }
                case 16395: {
                    return UCharacter.getName1_0((int)codePoint);
                }
                case 16396: {
                    return UCharacter.toUpperCase((Locale)Locale.ENGLISH, (String)UTF16.valueOf((int)codePoint));
                }
                case 16397: {
                    return Normalizer.normalize((int)codePoint, (Normalizer.Mode)Normalizer.NFC);
                }
                case 16398: {
                    return Normalizer.normalize((int)codePoint, (Normalizer.Mode)Normalizer.NFD);
                }
                case 16399: {
                    return Normalizer.normalize((int)codePoint, (Normalizer.Mode)Normalizer.NFKC);
                }
                case 16400: {
                    return Normalizer.normalize((int)codePoint, (Normalizer.Mode)Normalizer.NFKD);
                }
                case 49: {
                    return String.valueOf(Normalizer.normalize((int)codePoint, (Normalizer.Mode)Normalizer.NFC).equals(UTF16.valueOf((int)codePoint)));
                }
                case 50: {
                    return String.valueOf(Normalizer.normalize((int)codePoint, (Normalizer.Mode)Normalizer.NFD).equals(UTF16.valueOf((int)codePoint)));
                }
                case 51: {
                    return String.valueOf(Normalizer.normalize((int)codePoint, (Normalizer.Mode)Normalizer.NFKC).equals(UTF16.valueOf((int)codePoint)));
                }
                case 52: {
                    return String.valueOf(Normalizer.normalize((int)codePoint, (Normalizer.Mode)Normalizer.NFKD).equals(UTF16.valueOf((int)codePoint)));
                }
                case 53: {
                    return String.valueOf(UCharacter.toLowerCase((Locale)Locale.ENGLISH, (String)UTF16.valueOf((int)codePoint)).equals(UTF16.valueOf((int)codePoint)));
                }
                case 54: {
                    return String.valueOf(UCharacter.toUpperCase((Locale)Locale.ENGLISH, (String)UTF16.valueOf((int)codePoint)).equals(UTF16.valueOf((int)codePoint)));
                }
                case 55: {
                    return String.valueOf(UCharacter.toTitleCase((Locale)Locale.ENGLISH, (String)UTF16.valueOf((int)codePoint), null).equals(UTF16.valueOf((int)codePoint)));
                }
                case 56: {
                    return String.valueOf(UCharacter.foldCase((String)UTF16.valueOf((int)codePoint), (boolean)true).equals(UTF16.valueOf((int)codePoint)));
                }
                case 57: {
                    return String.valueOf(UCharacter.toLowerCase((Locale)Locale.ENGLISH, (String)UTF16.valueOf((int)codePoint)).equals(UTF16.valueOf((int)codePoint)));
                }
            }
            if (this.propEnum < 4117) {
                String value;
                int enumValue;
                block36: {
                    enumValue = -1;
                    value = null;
                    try {
                        enumValue = UCharacter.getIntPropertyValue((int)codePoint, (int)this.propEnum);
                        if (enumValue >= 0) {
                            value = ICUProperty.fixedGetPropertyValueName(this.propEnum, enumValue, 1);
                        }
                    }
                    catch (IllegalArgumentException e) {
                        if (this.shownException) break block36;
                        System.out.println("Fail: " + this.getName() + ", " + Integer.toHexString(codePoint));
                        this.shownException = true;
                    }
                }
                return value != null ? value : String.valueOf(enumValue);
            }
            if (this.propEnum < 12289) {
                double num = UCharacter.getUnicodeNumericValue((int)codePoint);
                if (num == -1.23456789E8) {
                    return null;
                }
                return Double.toString(num);
            }
            return null;
        }

        private String getFixedValueAlias(String valueAlias, int valueEnum, int nameChoice) {
            String result;
            if (this.propEnum >= 16384) {
                if (nameChoice != 1) {
                    return null;
                }
                return "<string>";
            }
            if (this.propEnum >= 12288) {
                if (nameChoice != 1) {
                    return null;
                }
                return "<number>";
            }
            if (valueAlias != null && !valueAlias.equals("<integer>")) {
                valueEnum = ICUProperty.fixedGetPropertyValueEnum(this.propEnum, valueAlias);
            }
            if ((result = ICUProperty.fixedGetPropertyValueName(this.propEnum, valueEnum, nameChoice)) != null) {
                return result;
            }
            if (nameChoice == 1) {
                result = ICUProperty.fixedGetPropertyValueName(this.propEnum, valueEnum, 0);
                if (result != null) {
                    return result;
                }
                if (this.propEnum == 4098) {
                    return null;
                }
                return "<integer>";
            }
            return null;
        }

        private static int fixedGetPropertyValueEnum(int propEnum, String valueAlias) {
            try {
                return UCharacter.getPropertyValueEnum((int)propEnum, (String)valueAlias);
            }
            catch (Exception e) {
                return Integer.parseInt(valueAlias);
            }
        }

        private static String fixedGetPropertyValueName(int propEnum, int valueEnum, int nameChoice) {
            try {
                String value = UCharacter.getPropertyValueName((int)propEnum, (int)valueEnum, (int)nameChoice);
                String newValue = (String)fixSkeleton.get(value);
                if (newValue == null) {
                    newValue = value;
                    if (propEnum == 4102) {
                        newValue = newValue.toLowerCase(Locale.ENGLISH);
                    }
                    newValue = ICUProperty.regularize(newValue, true);
                    fixSkeleton.put(value, newValue);
                }
                return newValue;
            }
            catch (Exception e) {
                return null;
            }
        }

        public List _getNameAliases(List result) {
            String alias;
            if (result == null) {
                result = new ArrayList();
            }
            if ((alias = String_Extras.get(this.propEnum)) == null) {
                alias = Binary_Extras.get(this.propEnum);
            }
            if (alias != null) {
                ICUProperty.addUnique(alias, result);
            } else {
                ICUProperty.addUnique(this.getFixedPropertyName(this.propEnum, 0), result);
                ICUProperty.addUnique(this.getFixedPropertyName(this.propEnum, 1), result);
            }
            return result;
        }

        public String getFixedPropertyName(int propName, int nameChoice) {
            try {
                return UCharacter.getPropertyName((int)this.propEnum, (int)nameChoice);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }

        public List _getAvailableValues(List result) {
            if (result == null) {
                result = new ArrayList();
            }
            if (this.propEnum == 16384) {
                ICUProperty.addAllUnique(new String[]{"unassigned", "1.1", "2.0", "2.1", "3.0", "3.1", "3.2", "4.0"}, result);
                return result;
            }
            if (this.propEnum < 4117) {
                if (Binary_Extras.isInRange(this.propEnum)) {
                    this.propEnum = 0;
                }
                int start = UCharacter.getIntPropertyMinValue((int)this.propEnum);
                int end = UCharacter.getIntPropertyMaxValue((int)this.propEnum);
                for (int i = start; i <= end; ++i) {
                    String alias = this.getFixedValueAlias(null, i, 1);
                    String alias2 = this.getFixedValueAlias(null, i, 0);
                    if (alias == null && (alias = alias2) == null && this.propEnum == 4098) {
                        alias = String.valueOf(i);
                    }
                    if (this.needCccHack && this.propEnum == 4098) {
                        this.cccHack.put(alias, String.valueOf(i));
                    }
                    ICUProperty.addUnique(alias, result);
                }
                this.needCccHack = false;
            } else {
                String alias = this.getFixedValueAlias(null, -1, 1);
                ICUProperty.addUnique(alias, result);
            }
            return result;
        }

        public List _getValueAliases(String valueAlias, List result) {
            if (result == null) {
                result = new ArrayList();
            }
            if (this.propEnum == 16384) {
                ICUProperty.addUnique(valueAlias, result);
                return result;
            }
            if (this.propEnum == 4098) {
                ICUProperty.addUnique(this.cccHack.get(valueAlias), result);
            }
            ICUProperty.addUnique(this.getFixedValueAlias(valueAlias, -1, 0), result);
            ICUProperty.addUnique(this.getFixedValueAlias(valueAlias, -1, 1), result);
            return result;
        }

        private int internalGetPropertyType(int propEnum) {
            switch (propEnum) {
                case 4097: 
                case 4106: 
                case 16384: {
                    return 6;
                }
                case 16387: 
                case 16389: 
                case 16395: {
                    return 8;
                }
                case 16385: 
                case 16386: 
                case 16388: 
                case 16390: 
                case 16391: 
                case 16392: 
                case 16393: 
                case 16394: 
                case 16396: {
                    return 11;
                }
            }
            if (propEnum < 0) {
                return 0;
            }
            if (propEnum < 49) {
                return 2;
            }
            if (propEnum < 4096) {
                return 3;
            }
            if (propEnum < 4117) {
                return 4;
            }
            if (propEnum < 12288) {
                return 5;
            }
            if (propEnum < 12289) {
                return 12;
            }
            if (propEnum < 16384) {
                return 13;
            }
            if (propEnum < 16397) {
                return 10;
            }
            return 11;
        }

        public String _getVersion() {
            return VersionInfo.ICU_VERSION.toString();
        }
    }
}

