/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.dev.test.util;

import com.ibm.icu.dev.test.TestFmwk;
import com.ibm.icu.impl.ICULocaleService;
import com.ibm.icu.impl.ICUNotifier;
import com.ibm.icu.impl.ICURWLock;
import com.ibm.icu.impl.ICUResourceBundle;
import com.ibm.icu.impl.ICUService;
import com.ibm.icu.impl.LocaleUtility;
import com.ibm.icu.text.Collator;
import com.ibm.icu.util.ULocale;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;

public class ICUServiceTest
extends TestFmwk {
    public static void main(String[] args) throws Exception {
        ICUServiceTest test = new ICUServiceTest();
        test.run(args);
    }

    private String lrmsg(String message, Object lhs, Object rhs) {
        return message + " lhs: " + lhs + " rhs: " + rhs;
    }

    public void confirmBoolean(String message, boolean val) {
        this.msg(message, val ? 0 : 2, !val, true);
    }

    public void confirmEqual(String message, Object lhs, Object rhs) {
        this.msg(this.lrmsg(message, lhs, rhs), (lhs == null ? rhs == null : lhs.equals(rhs)) ? 0 : 2, true, true);
    }

    public void confirmIdentical(String message, Object lhs, Object rhs) {
        this.msg(this.lrmsg(message, lhs, rhs), lhs == rhs ? 0 : 2, true, true);
    }

    public void confirmIdentical(String message, int lhs, int rhs) {
        this.msg(message + " lhs: " + lhs + " rhs: " + rhs, lhs == rhs ? 0 : 2, true, true);
    }

    public SortedMap getDisplayNames(ICUService service) {
        ULocale locale = ULocale.getDefault();
        Collator col = Collator.getInstance((ULocale)locale);
        return service.getDisplayNames(locale, (Comparator)col, null);
    }

    public SortedMap getDisplayNames(ICUService service, ULocale locale) {
        Collator col = Collator.getInstance((ULocale)locale);
        return service.getDisplayNames(locale, (Comparator)col, null);
    }

    public SortedMap getDisplayNames(ICUService service, ULocale locale, String matchID) {
        Collator col = Collator.getInstance((ULocale)locale);
        return service.getDisplayNames(locale, (Comparator)col, matchID);
    }

    public void TestAPI() {
        Map.Entry e;
        TestService service = new TestService();
        this.logln("service name:" + service.getName());
        Integer singleton0 = new Integer(0);
        service.registerObject(singleton0, "en_US");
        Object result = service.get("en_US_FOO");
        this.confirmIdentical("1) en_US_FOO -> en_US", result, singleton0);
        Integer singleton1 = new Integer(1);
        service.registerObject(singleton1, "en_US_FOO");
        result = service.get("en_US_FOO");
        this.confirmIdentical("2) en_US_FOO -> en_US_FOO", result, singleton1);
        result = service.get("en_US_BAR");
        this.confirmIdentical("3) en_US_BAR -> en_US", result, singleton0);
        List factories = service.factories();
        this.confirmIdentical("4) factory size", factories.size(), 2);
        Integer singleton2 = new Integer(2);
        service.registerObject(singleton2, "en");
        this.confirmIdentical("5) factory size", factories.size(), 2);
        result = service.get("en_US_BAR");
        this.confirmIdentical("6) en_US_BAR -> en_US", result, singleton0);
        Integer singleton3 = new Integer(3);
        service.registerObject(singleton3, "en_US");
        factories = service.factories();
        this.confirmIdentical("9) factory size", factories.size(), 4);
        result = service.get("en_US_BAR");
        this.confirmIdentical("10) en_US_BAR -> (3)", result, singleton3);
        service.unregisterFactory((ICUService.Factory)factories.get(0));
        factories = service.factories();
        this.confirmIdentical("11) factory size", factories.size(), 3);
        result = service.get("en_US_BAR");
        this.confirmIdentical("12) en_US_BAR -> 0", result, singleton0);
        result = service.get("foo");
        this.confirmIdentical("13) foo -> null", result, null);
        String[] resultID = new String[1];
        result = service.get("EN_us_fOo", resultID);
        this.confirmEqual("14) find non-canonical", resultID[0], "en_US_FOO");
        service.registerObject(singleton3, "eN_ca_dUde");
        result = service.get("En_Ca_DuDe", resultID);
        this.confirmEqual("15) register non-canonical", resultID[0], "en_CA_DUDE");
        Integer singleton4 = new Integer(4);
        service.registerObject(singleton4, "en_US_BAR", false);
        result = service.get("en_US_BAR");
        this.confirmIdentical("17) get invisible", result, singleton4);
        Set ids = service.getVisibleIDs();
        this.confirmBoolean("18) find invisible", !ids.contains("en_US_BAR"));
        service.reset();
        ICUService.Factory factory = new ICUService.Factory(){

            public Object create(ICUService.Key key, ICUService service) {
                return new ULocale(key.currentID());
            }

            public void updateVisibleIDs(Map result) {
            }

            public String getDisplayName(String id, ULocale l) {
                return null;
            }
        };
        service.registerFactory(factory);
        result = service.get(ULocale.US.toString());
        this.confirmEqual("21) locale", result, ULocale.US);
        result = service.get("EN_US_BAR");
        this.confirmEqual("22) locale", result, new ULocale("en_US_BAR"));
        service.registerObject(singleton3, "en_US_BAR");
        result = service.get("en_US_BAR");
        this.confirmIdentical("23) override super", result, singleton3);
        service.reset();
        result = service.get("en_US");
        this.confirmIdentical("24) empty", result, null);
        Object xids = new String[]{"en_US_VALLEY_GIRL", "en_US_VALLEY_BOY", "en_US_SURFER_GAL", "en_US_SURFER_DUDE"};
        service.registerFactory((ICUService.Factory)new TestLocaleKeyFactory((String[])xids, "Later"));
        Set vids = service.getVisibleIDs();
        Iterator<Object> iter = vids.iterator();
        int count = 0;
        while (iter.hasNext()) {
            ++count;
            String id = (String)iter.next();
            this.logln("  " + id + " --> " + service.get(id));
        }
        this.confirmIdentical("25) visible ids", count, 4);
        SortedMap dids = this.getDisplayNames(service, ULocale.GERMANY);
        iter = dids.entrySet().iterator();
        count = 0;
        while (iter.hasNext()) {
            ++count;
            e = (Map.Entry)iter.next();
            this.logln("  " + e.getKey() + " -- > " + e.getValue());
        }
        this.confirmIdentical("26) display names", count, 4);
        this.confirmIdentical("27) get display name", service.getDisplayName("en_US_VALLEY_GEEK"), null);
        String name = service.getDisplayName("en_US_SURFER_DUDE", ULocale.US);
        this.confirmEqual("28) get display name", name, "English (United States, SURFER_DUDE)");
        xids = new String[]{"en_US_SURFER", "en_US_SURFER_GAL", "en_US_SILICON", "en_US_SILICON_GEEK"};
        service.registerFactory((ICUService.Factory)new TestLocaleKeyFactory((String[])xids, "Rad dude"));
        dids = this.getDisplayNames(service);
        iter = dids.entrySet().iterator();
        count = 0;
        while (iter.hasNext()) {
            ++count;
            e = (Map.Entry)iter.next();
            this.logln("  " + e.getKey() + " --> " + e.getValue());
        }
        this.confirmIdentical("29) display names", count, 7);
        String[] actualID = new String[1];
        String id = "en_us_surfer_gal";
        String gal = (String)service.get(id, actualID);
        if (gal != null) {
            this.logln("actual id: " + actualID[0]);
            String displayName = service.getDisplayName(actualID[0], ULocale.US);
            this.logln("found actual: " + gal + " with display name: " + displayName);
            this.confirmBoolean("30) found display name for actual", displayName != null);
            displayName = service.getDisplayName(id, ULocale.US);
            this.logln("found query: " + gal + " with display name: " + displayName);
        } else {
            this.errln("30) service could not find entry for " + id);
        }
        id = "en_US_SURFER_BOZO";
        String bozo = (String)service.get(id, actualID);
        if (bozo != null) {
            String displayName = service.getDisplayName(actualID[0], ULocale.US);
            this.logln("found actual: " + bozo + " with display name: " + displayName);
            this.confirmBoolean("32) found display name for actual", displayName != null);
            displayName = service.getDisplayName(id, ULocale.US);
            this.logln("found actual: " + bozo + " with display name: " + displayName);
        } else {
            this.errln("32) service could not find entry for " + id);
        }
        this.confirmBoolean("34) is default ", !service.isDefault());
        xids = service.getVisibleIDs();
        iter = xids.iterator();
        while (iter.hasNext()) {
            String xid = (String)iter.next();
            this.logln(xid + "?  " + service.get(xid));
        }
        this.logln("valleygirl?  " + service.get("en_US_VALLEY_GIRL"));
        this.logln("valleyboy?   " + service.get("en_US_VALLEY_BOY"));
        this.logln("valleydude?  " + service.get("en_US_VALLEY_DUDE"));
        this.logln("surfergirl?  " + service.get("en_US_SURFER_GIRL"));
        service.reset();
        service.registerFactory((ICUService.Factory)new ICULocaleService.ICUResourceBundleFactory());
        this.logln("all visible ids: " + service.getVisibleIDs());
        this.logln("visible ids for es locale: " + service.getVisibleIDs("es"));
        this.logln("display names: " + this.getDisplayNames(service, new ULocale("es"), "es"));
        this.logln("display names in reverse order: " + service.getDisplayNames(ULocale.US, new Comparator(){

            public int compare(Object lhs, Object rhs) {
                return -String.CASE_INSENSITIVE_ORDER.compare((String)lhs, (String)rhs);
            }
        }));
        this.logln("service display names for de_DE");
        SortedMap names = this.getDisplayNames(service, new ULocale("de_DE"));
        StringBuffer buf = new StringBuffer("{");
        Iterator iter2 = names.entrySet().iterator();
        while (iter2.hasNext()) {
            e = iter2.next();
            String name2 = (String)e.getKey();
            String id2 = (String)e.getValue();
            buf.append("\n   " + name2 + " --> " + id2);
        }
        buf.append("\n}");
        this.logln(buf.toString());
        CalifornioLanguageFactory califactory = new CalifornioLanguageFactory();
        service.registerFactory((ICUService.Factory)califactory);
        this.logln("californio language factory");
        buf = new StringBuffer("{");
        String[] idNames = new String[]{CalifornioLanguageFactory.californio, CalifornioLanguageFactory.valley, CalifornioLanguageFactory.surfer, CalifornioLanguageFactory.geek};
        for (int i = 0; i < idNames.length; ++i) {
            String idName = idNames[i];
            buf.append("\n  --- " + idName + " ---");
            SortedMap names2 = this.getDisplayNames(service, new ULocale(idName));
            Iterator iter3 = names2.entrySet().iterator();
            while (iter3.hasNext()) {
                Map.Entry e2 = iter3.next();
                String name3 = (String)e2.getKey();
                String id3 = (String)e2.getValue();
                buf.append("\n    " + name3 + " --> " + id3);
            }
        }
        buf.append("\n}");
        this.logln(buf.toString());
        this.logln("simple registration notification");
        ICULocaleService ls = new ICULocaleService();
        ICUService.ServiceListener l1 = new ICUService.ServiceListener(){
            private int n;

            public void serviceChanged(ICUService s) {
                ICUServiceTest.this.logln("listener 1 report " + this.n++ + " service changed: " + s);
            }
        };
        ls.addListener((EventListener)l1);
        ICUService.ServiceListener l2 = new ICUService.ServiceListener(){
            private int n;

            public void serviceChanged(ICUService s) {
                ICUServiceTest.this.logln("listener 2 report " + this.n++ + " service changed: " + s);
            }
        };
        ls.addListener((EventListener)l2);
        this.logln("registering foo... ");
        ls.registerObject((Object)"Foo", "en_FOO");
        this.logln("registering bar... ");
        ls.registerObject((Object)"Bar", "en_BAR");
        this.logln("getting foo...");
        this.logln((String)ls.get("en_FOO"));
        this.logln("removing listener 2...");
        ls.removeListener((EventListener)l2);
        this.logln("registering baz...");
        ls.registerObject((Object)"Baz", "en_BAZ");
        this.logln("removing listener 1");
        ls.removeListener((EventListener)l1);
        this.logln("registering burp...");
        ls.registerObject((Object)"Burp", "en_BURP");
        this.logln("... trying multiple registration");
        ls.addListener((EventListener)l1);
        ls.addListener((EventListener)l1);
        ls.addListener((EventListener)l1);
        ls.addListener((EventListener)l2);
        ls.registerObject((Object)"Foo", "en_FOO");
        this.logln("... registered foo");
        ICUService.ServiceListener l3 = new ICUService.ServiceListener(){
            private int n;

            public void serviceChanged(ICUService s) {
                ICUServiceTest.this.logln("listener 3 report " + this.n++ + " service changed...");
                if (s.get("en_BOINK") == null) {
                    ICUServiceTest.this.logln("registering boink...");
                    s.registerObject((Object)"boink", "en_BOINK");
                }
            }
        };
        ls.addListener((EventListener)l3);
        this.logln("registering boo...");
        ls.registerObject((Object)"Boo", "en_BOO");
        this.logln("...done");
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e3) {
            // empty catch block
        }
    }

    public void TestLocale() {
        ICULocaleService service = new ICULocaleService("test locale");
        service.registerObject((Object)"root", ULocale.ROOT);
        service.registerObject((Object)"german", "de");
        service.registerObject((Object)"german_Germany", ULocale.GERMANY);
        service.registerObject((Object)"japanese", "ja");
        service.registerObject((Object)"japanese_Japan", ULocale.JAPAN);
        Object target = service.get("de_US");
        this.confirmEqual("test de_US", "german", target);
        ULocale de = new ULocale("de");
        ULocale de_US = new ULocale("de_US");
        target = service.get(de_US);
        this.confirmEqual("test de_US 2", "german", target);
        target = service.get(de_US, -1);
        this.confirmEqual("test de_US 3", "german", target);
        target = service.get(de_US, 1234);
        this.confirmEqual("test de_US 4", "german", target);
        ULocale[] actualReturn = new ULocale[1];
        target = service.get(de_US, actualReturn);
        this.confirmEqual("test de_US 5", "german", target);
        this.confirmEqual("test de_US 6", actualReturn[0], de);
        actualReturn[0] = null;
        target = service.get(de_US, -1, actualReturn);
        this.confirmEqual("test de_US 7", actualReturn[0], de);
        actualReturn[0] = null;
        target = service.get(de_US, 1234, actualReturn);
        this.confirmEqual("test de_US 8", "german", target);
        this.confirmEqual("test de_US 9", actualReturn[0], de);
        service.registerObject((Object)"one/de_US", de_US, 1);
        service.registerObject((Object)"two/de_US", de_US, 2);
        target = service.get(de_US, 1);
        this.confirmEqual("test de_US kind 1", "one/de_US", target);
        target = service.get(de_US, 2);
        this.confirmEqual("test de_US kind 2", "two/de_US", target);
        target = service.get(de_US);
        this.confirmEqual("test de_US kind 3", "german", target);
        ICULocaleService.LocaleKey lkey = ICULocaleService.LocaleKey.createWithCanonicalFallback((String)"en", null, (int)1234);
        this.logln("lkey prefix: " + lkey.prefix());
        this.logln("lkey descriptor: " + lkey.currentDescriptor());
        this.logln("lkey current locale: " + lkey.currentLocale());
        lkey.fallback();
        this.logln("lkey descriptor 2: " + lkey.currentDescriptor());
        lkey.fallback();
        this.logln("lkey descriptor 3: " + lkey.currentDescriptor());
        target = service.get("za_PPP");
        this.confirmEqual("test zappp", "root", target);
        ULocale loc = ULocale.getDefault();
        ULocale.setDefault((ULocale)ULocale.JAPANESE);
        target = service.get("za_PPP");
        this.confirmEqual("test with ja locale", "japanese", target);
        Set ids = service.getVisibleIDs();
        Iterator iter = ids.iterator();
        while (iter.hasNext()) {
            this.logln("id: " + iter.next());
        }
        ULocale.setDefault((ULocale)loc);
        ids = service.getVisibleIDs();
        iter = ids.iterator();
        while (iter.hasNext()) {
            this.logln("id: " + iter.next());
        }
        target = service.get("za_PPP");
        this.confirmEqual("test with en locale", "root", target);
        ULocale[] locales = service.getAvailableULocales();
        this.confirmIdentical("test available locales", locales.length, 6);
        this.logln("locales: ");
        for (int i = 0; i < locales.length; ++i) {
            this.log("\n  [" + i + "] " + locales[i]);
        }
        this.logln(" ");
        service.registerFactory((ICUService.Factory)new ICULocaleService.ICUResourceBundleFactory());
        target = service.get(ULocale.JAPAN);
        int n = 0;
        List factories = service.factories();
        Iterator iter2 = factories.iterator();
        while (iter2.hasNext()) {
            this.logln("[" + n++ + "] " + iter2.next());
        }
        SortedMap map = service.getDisplayNames(ULocale.US, new Comparator(){

            public int compare(Object lhs, Object rhs) {
                return -String.CASE_INSENSITIVE_ORDER.compare((String)lhs, (String)rhs);
            }
        }, "es");
        this.logln("es display names in reverse order " + map);
    }

    public void TestWrapFactory() {
        String greeting = "Hello There";
        String greetingID = "greeting";
        ICUService service = new ICUService("wrap");
        service.registerObject((Object)"Hello There", "greeting");
        this.logln("test one: " + service.get("greeting"));
        class WrapFactory
        implements ICUService.Factory {
            WrapFactory() {
            }

            public Object create(ICUService.Key key, ICUService service) {
                if (key.currentID().equals("greeting")) {
                    Object previous = service.getKey(key, null, (ICUService.Factory)this);
                    return "A different greeting: \"" + previous + "\"";
                }
                return null;
            }

            public void updateVisibleIDs(Map result) {
                result.put("greeting", this);
            }

            public String getDisplayName(String id, ULocale locale) {
                return "wrap '" + id + "'";
            }
        }
        service.registerFactory((ICUService.Factory)new WrapFactory());
        this.confirmEqual("wrap test: ", service.get("greeting"), "A different greeting: \"Hello There\"");
    }

    public void TestCoverage() {
        ICUService.Key key = new ICUService.Key("foobar");
        this.logln("ID: " + key.id());
        this.logln("canonicalID: " + key.canonicalID());
        this.logln("currentID: " + key.currentID());
        this.logln("has fallback: " + key.fallback());
        Object obj = new Object();
        ICUService.SimpleFactory sf = new ICUService.SimpleFactory(obj, "object");
        try {
            sf = new ICUService.SimpleFactory(null, null);
            this.errln("didn't throw exception");
        }
        catch (IllegalArgumentException e) {
            this.logln("OK: " + e.getMessage());
        }
        catch (Exception e) {
            this.errln("threw wrong exception" + e);
        }
        this.logln(sf.getDisplayName("object", null));
        ICUService service = new ICUService();
        service.registerFactory((ICUService.Factory)sf);
        try {
            service.get(null, null);
            this.errln("didn't throw exception");
        }
        catch (NullPointerException e) {
            this.logln("OK: " + e.getMessage());
        }
        try {
            service.registerFactory(null);
            this.errln("didn't throw exception");
        }
        catch (NullPointerException e) {
            this.logln("OK: " + e.getMessage());
        }
        catch (Exception e) {
            this.errln("threw wrong exception" + e);
        }
        try {
            service.unregisterFactory(null);
            this.errln("didn't throw exception");
        }
        catch (NullPointerException e) {
            this.logln("OK: " + e.getMessage());
        }
        catch (Exception e) {
            this.errln("threw wrong exception" + e);
        }
        this.logln("object is: " + service.get("object"));
        this.logln("stats: " + service.stats());
        ICURWLock rwlock = new ICURWLock();
        rwlock.acquireRead();
        rwlock.releaseRead();
        rwlock.acquireWrite();
        rwlock.releaseWrite();
        this.logln("stats: " + rwlock.getStats());
        this.logln("stats: " + rwlock.clearStats());
        rwlock.acquireRead();
        rwlock.releaseRead();
        rwlock.acquireWrite();
        rwlock.releaseWrite();
        this.logln("stats: " + rwlock.getStats());
        try {
            rwlock.releaseRead();
            this.errln("no error thrown");
        }
        catch (IllegalStateException e) {
            this.logln("OK: " + e.getMessage());
        }
        try {
            rwlock.releaseWrite();
            this.errln("no error thrown");
        }
        catch (IllegalStateException e) {
            this.logln("OK: " + e.getMessage());
        }
        ICULocaleService.LocaleKey lkey = ICULocaleService.LocaleKey.createWithCanonicalFallback((String)"en_US", (String)"ja_JP");
        this.logln("lkey: " + lkey);
        lkey = ICULocaleService.LocaleKey.createWithCanonicalFallback(null, null);
        this.logln("lkey from null,null: " + lkey);
        LKFSubclass lkf = new LKFSubclass(false);
        this.logln("lkf: " + (Object)((Object)lkf));
        this.logln("obj: " + lkf.create((ICUService.Key)lkey, null));
        this.logln(lkf.getDisplayName("foo", null));
        this.logln(lkf.getDisplayName("bar", null));
        lkf.updateVisibleIDs(new HashMap());
        LKFSubclass invisibleLKF = new LKFSubclass(false);
        this.logln("obj: " + invisibleLKF.create((ICUService.Key)lkey, null));
        this.logln(invisibleLKF.getDisplayName("foo", null));
        this.logln(invisibleLKF.getDisplayName("bar", null));
        invisibleLKF.updateVisibleIDs(new HashMap());
        ICULocaleService.ICUResourceBundleFactory rbf = new ICULocaleService.ICUResourceBundleFactory();
        this.logln("RB: " + rbf.create((ICUService.Key)lkey, null));
        ICUNSubclass nf = new ICUNSubclass();
        try {
            nf.addListener(null);
            this.errln("added null listener");
        }
        catch (NullPointerException e) {
            this.logln(e.getMessage());
        }
        catch (Exception e) {
            this.errln("got wrong exception");
        }
        try {
            nf.addListener(new WrongListener());
            this.errln("added wrong listener");
        }
        catch (IllegalStateException e) {
            this.logln(e.getMessage());
        }
        catch (Exception e) {
            this.errln("got wrong exception");
        }
        try {
            nf.removeListener(null);
            this.errln("removed null listener");
        }
        catch (NullPointerException e) {
            this.logln(e.getMessage());
        }
        catch (Exception e) {
            this.errln("got wrong exception");
        }
        nf.removeListener(new MyListener());
        nf.notifyChanged();
        nf.addListener(new MyListener());
        nf.removeListener(new MyListener());
    }

    static class LKFSubclass
    extends ICULocaleService.LocaleKeyFactory {
        LKFSubclass(boolean visible) {
            super(visible);
        }

        protected Set getSupportedIDs() {
            return Collections.EMPTY_SET;
        }
    }

    static class ICUNSubclass
    extends ICUNotifier {
        ICUNSubclass() {
        }

        public boolean acceptsListener(EventListener l) {
            return l instanceof MyListener;
        }

        public void notifyListener(EventListener l) {
        }
    }

    static class WrongListener
    implements EventListener {
        WrongListener() {
        }
    }

    static class MyListener
    implements EventListener {
        MyListener() {
        }
    }

    static class CalifornioLanguageFactory
    extends ICULocaleService.ICUResourceBundleFactory {
        public static String californio = "en_US_CA";
        public static String valley = californio + "_VALLEY";
        public static String surfer = californio + "_SURFER";
        public static String geek = californio + "_GEEK";
        public static Set supportedIDs;

        CalifornioLanguageFactory() {
        }

        public Set getSupportedIDs() {
            return supportedIDs;
        }

        public String getDisplayName(String id, ULocale locale) {
            String prefix = "";
            String suffix = "";
            String ls = locale.toString();
            if (LocaleUtility.isFallbackOf((String)californio, (String)ls)) {
                prefix = ls.equalsIgnoreCase(valley) ? "Like, you know, it's so totally " : (ls.equalsIgnoreCase(surfer) ? "Dude, its " : (ls.equalsIgnoreCase(geek) ? "I'd estimate it's approximately " : "Huh?  Maybe "));
            }
            suffix = LocaleUtility.isFallbackOf((String)californio, (String)id) ? (id.equalsIgnoreCase(valley) ? "like the Valley, you know?  Let's go to the mall!" : (id.equalsIgnoreCase(surfer) ? "time to hit those gnarly waves, Dude!!!" : (id.equalsIgnoreCase(geek) ? "all systems go.  T-Minus 9, 8, 7..." : "No Habla Englais"))) : super.getDisplayName(id, locale);
            return prefix + suffix;
        }

        static {
            HashSet<String> result = new HashSet<String>();
            result.addAll(ICUResourceBundle.getAvailableLocaleNameSet());
            result.add(californio);
            result.add(valley);
            result.add(surfer);
            result.add(geek);
            supportedIDs = Collections.unmodifiableSet(result);
        }
    }

    static class TestLocaleKeyFactory
    extends ICULocaleService.LocaleKeyFactory {
        protected final Set ids;
        protected final String factoryID;

        public TestLocaleKeyFactory(String[] ids, String factoryID) {
            super(true, factoryID);
            this.ids = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(ids)));
            this.factoryID = factoryID + ": ";
        }

        protected Object handleCreate(ULocale loc, int kind, ICUService service) {
            return this.factoryID + loc.toString();
        }

        protected Set getSupportedIDs() {
            return this.ids;
        }
    }

    static final class TestService
    extends ICUService {
        public TestService() {
            super("Test Service");
        }

        public ICUService.Key createKey(String id) {
            return ICULocaleService.LocaleKey.createWithCanonicalFallback((String)id, null);
        }
    }
}

