/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.dev.test.util;

import com.ibm.icu.dev.test.AbstractTestLog;
import com.ibm.icu.dev.test.TestFmwk;
import com.ibm.icu.dev.test.TestLog;
import com.ibm.icu.impl.ICULocaleService;
import com.ibm.icu.impl.ICUService;
import com.ibm.icu.text.Collator;
import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Random;
import java.util.Set;
import java.util.SortedMap;

public class ICUServiceThreadTest
extends TestFmwk {
    private static final boolean PRINTSTATS = false;
    private static final String[] countries = new String[]{"ab", "bc", "cd", "de", "ef", "fg", "gh", "ji", "ij", "jk"};
    private static final String[] languages = new String[]{"", "ZY", "YX", "XW", "WV", "VU", "UT", "TS", "SR", "RQ", "QP"};
    private static final String[] variants = new String[]{"", "", "", "GOLD", "SILVER", "BRONZE"};
    private static final Random r = new Random();
    private static boolean WAIT = true;
    private static boolean GO = false;
    private static long TIME = 5000L;
    private ICUService stableService;

    public static void main(String[] args) throws Exception {
        ICUServiceThreadTest test = new ICUServiceThreadTest();
        test.run(args);
    }

    public static SortedMap getDisplayNames(ICUService service, ULocale locale) {
        Collator col;
        try {
            col = Collator.getInstance((ULocale)locale);
        }
        catch (MissingResourceException e) {
            col = null;
        }
        return service.getDisplayNames(locale, (Comparator)col, null);
    }

    private static String getCLV() {
        String c = countries[r.nextInt(countries.length)];
        String l = languages[r.nextInt(languages.length)];
        String v = variants[r.nextInt(variants.length)];
        return new Locale(c, l, v).toString();
    }

    public static void runThreads() {
        ICUServiceThreadTest.runThreads(TIME);
    }

    public static void runThreads(long time) {
        try {
            GO = true;
            WAIT = false;
            Thread.sleep(time);
            WAIT = true;
            GO = false;
            Thread.sleep(300L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    Collection getFactoryCollection(int requested) {
        HashSet<String> locales = new HashSet<String>();
        for (int i = 0; i < requested; ++i) {
            locales.add(ICUServiceThreadTest.getCLV());
        }
        ArrayList<TestFactory> factories = new ArrayList<TestFactory>(locales.size());
        Iterator iter = locales.iterator();
        while (iter.hasNext()) {
            factories.add(new TestFactory((String)iter.next()));
        }
        return factories;
    }

    void registerFactories(ICUService service, Collection c) {
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            service.registerFactory((ICUService.Factory)iter.next());
        }
    }

    ICUService stableService() {
        if (this.stableService == null) {
            this.stableService = new ICULocaleService();
            this.registerFactories(this.stableService, this.getFactoryCollection(50));
        }
        return this.stableService;
    }

    public void Test00_ConcurrentGet() {
        for (int i = 0; i < 10; ++i) {
            new GetThread("[" + Integer.toString(i) + "]", this.stableService(), 0L, this).start();
        }
        ICUServiceThreadTest.runThreads();
    }

    public void Test01_ConcurrentGetVisible() {
        for (int i = 0; i < 10; ++i) {
            new GetVisibleThread("[" + Integer.toString(i) + "]", this.stableService(), 0L, this).start();
        }
        ICUServiceThreadTest.runThreads();
    }

    public void Test02_ConcurrentGetDisplay() {
        String[] localeNames = new String[]{"en", "es", "de", "fr", "zh", "it", "no", "sv"};
        for (int i = 0; i < localeNames.length; ++i) {
            String locale = localeNames[i];
            new GetDisplayThread("[" + locale + "]", this.stableService(), 0L, new ULocale(locale), this).start();
        }
        ICUServiceThreadTest.runThreads();
    }

    public void Test03_ConcurrentRegUnreg() {
        int i;
        ICULocaleService service = new ICULocaleService();
        for (i = 0; i < 5; ++i) {
            new RegisterFactoryThread("[" + i + "]", (ICUService)service, 0L, this).start();
        }
        for (i = 0; i < 5; ++i) {
            new UnregisterFactoryThread("[" + i + "]", (ICUService)service, 0L, this).start();
        }
        ICUServiceThreadTest.runThreads();
    }

    public void Test04_WitheringService() {
        ICULocaleService service = new ICULocaleService();
        Collection fc = this.getFactoryCollection(50);
        this.registerFactories((ICUService)service, fc);
        ICUService.Factory[] factories = fc.toArray(new ICUService.Factory[fc.size()]);
        Comparator comp = new Comparator(){

            public int compare(Object lhs, Object rhs) {
                return lhs.toString().compareTo(rhs.toString());
            }
        };
        Arrays.sort(factories, comp);
        new GetThread("", (ICUService)service, 0L, this).start();
        new UnregisterFactoryListThread("", (ICUService)service, 3L, factories, this).start();
        ICUServiceThreadTest.runThreads(2000L);
    }

    public void Test05_ConcurrentEverything() {
        ICULocaleService service = new ICULocaleService();
        new RegisterFactoryThread("", (ICUService)service, 500L, this).start();
        for (int i = 0; i < 15; ++i) {
            new GetThread("[" + Integer.toString(i) + "]", (ICUService)service, 0L, this).start();
        }
        new GetVisibleThread("", (ICUService)service, 50L, this).start();
        String[] localeNames = new String[]{"en", "de"};
        for (int i = 0; i < localeNames.length; ++i) {
            String locale = localeNames[i];
            new GetDisplayThread("[" + locale + "]", this.stableService(), 500L, new ULocale(locale), this).start();
        }
        new UnregisterFactoryThread("", (ICUService)service, 500L, this).start();
        ICUServiceThreadTest.runThreads(10000L);
    }

    static class GetListThread
    extends TestThread {
        private final String[] list;
        private int n;

        GetListThread(String name, ICUService service, long delay, String[] list, TestLog log) {
            super("GETL " + name, service, delay, log);
            this.list = list;
        }

        protected void iterate() {
            if (--this.n < 0) {
                this.n = this.list.length - 1;
            }
            String id = this.list[this.n];
            Object o = this.service.get(id);
            this.log.logln(" id: " + id + " result: " + o);
        }
    }

    static class GetThread
    extends TestThread {
        private String[] actualID = new String[1];

        GetThread(String name, ICUService service, long delay, TestLog log) {
            super("GET " + name, service, delay, log);
        }

        protected void iterate() {
            String id = ICUServiceThreadTest.getCLV();
            Object o = this.service.get(id, this.actualID);
            if (o != null) {
                this.log.logln(" id: " + id + " actual: " + this.actualID[0] + " result: " + o);
            }
        }
    }

    static class GetDisplayThread
    extends TestThread {
        ULocale locale;

        GetDisplayThread(String name, ICUService service, long delay, ULocale locale, TestLog log) {
            super("DIS " + name, service, delay, log);
            this.locale = locale;
        }

        protected void iterate() {
            SortedMap names = ICUServiceThreadTest.getDisplayNames(this.service, this.locale);
            Iterator iter = names.entrySet().iterator();
            int n = 10;
            while (--n >= 0 && iter.hasNext()) {
                Map.Entry e = iter.next();
                String dname = (String)e.getKey();
                String id = (String)e.getValue();
                Object result = this.service.get(id);
                String num = Integer.toString(n);
                this.log.logln(" iter: " + num + " dname: " + dname + " id: " + id + " result: " + result);
            }
        }
    }

    static class GetVisibleThread
    extends TestThread {
        GetVisibleThread(String name, ICUService service, long delay, TestLog log) {
            super("VIS " + name, service, delay, log);
        }

        protected void iterate() {
            Set ids = this.service.getVisibleIDs();
            Iterator iter = ids.iterator();
            int n = 10;
            while (--n >= 0 && iter.hasNext()) {
                String id = (String)iter.next();
                Object result = this.service.get(id);
                this.log.logln("iter: " + n + " id: " + id + " result: " + result);
            }
        }
    }

    static class UnregisterFactoryListThread
    extends TestThread {
        ICUService.Factory[] factories;
        int n;

        UnregisterFactoryListThread(String name, ICUService service, long delay, ICUService.Factory[] factories, TestLog log) {
            super("UNREG " + name, service, delay, log);
            this.factories = factories;
        }

        public void iterate() {
            if (this.n < this.factories.length) {
                ICUService.Factory f = this.factories[this.n++];
                boolean success = this.service.unregisterFactory(f);
                this.log.logln("factory: " + f + (success ? " succeeded." : " *** failed."));
            }
        }
    }

    static class UnregisterFactoryThread
    extends TestThread {
        private Random r = new Random();
        List factories;

        UnregisterFactoryThread(String name, ICUService service, long delay, TestLog log) {
            super("UNREG " + name, service, delay, log);
            this.factories = service.factories();
        }

        public void iterate() {
            int s = this.factories.size();
            if (s == 0) {
                this.factories = this.service.factories();
            } else {
                int n = this.r.nextInt(s);
                ICUService.Factory f = (ICUService.Factory)this.factories.remove(n);
                boolean success = this.service.unregisterFactory(f);
                this.log.logln("factory: " + f + (success ? " succeeded." : " *** failed."));
            }
        }
    }

    static class RegisterFactoryThread
    extends TestThread {
        RegisterFactoryThread(String name, ICUService service, long delay, TestLog log) {
            super("REG " + name, service, delay, log);
        }

        protected void iterate() {
            TestFactory f = new TestFactory(ICUServiceThreadTest.getCLV());
            this.service.registerFactory((ICUService.Factory)f);
            this.log.logln(((Object)((Object)f)).toString());
        }
    }

    static class TestThread
    extends Thread {
        private final String name;
        protected ICUService service;
        private final long delay;
        protected final TestLog log;

        public TestThread(String name, ICUService service, long delay, TestLog log) {
            this.name = name + " ";
            this.service = service;
            this.delay = delay;
            this.log = new AbstractTestLog.DelegatingLog(log);
            this.setDaemon(true);
        }

        public void run() {
            while (WAIT) {
                Thread.yield();
            }
            try {
                while (GO) {
                    this.iterate();
                    if (this.delay <= 0L) continue;
                    Thread.sleep(this.delay);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        protected void iterate() {
        }
    }

    private static class TestFactory
    extends ICUService.SimpleFactory {
        TestFactory(String id) {
            super((Object)new ULocale(id), id, true);
        }

        public String getDisplayName(String id, ULocale locale) {
            return this.visible && id.equals(this.id) ? "(" + locale.toString() + ") " + id : null;
        }

        public String toString() {
            return "Factory_" + this.id;
        }
    }
}

