/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.dev.test.util;

import com.ibm.icu.dev.test.TestFmwk;
import com.ibm.icu.impl.LRUMap;

public class LRUMapTest
extends TestFmwk {
    public static void main(String[] args) throws Exception {
        LRUMapTest test = new LRUMapTest();
        test.run(args);
    }

    public void TestLRUMap() {
        this.logln("Testing LRUMap with the default size");
        LRUMap map = new LRUMap();
        this.execute(map, 64);
        this.logln("Testing LRUMap with initial/max size - 4/16");
        map = new LRUMap(4, 16);
        this.execute(map, 16);
    }

    private void execute(LRUMap map, int maxSize) {
        Integer num;
        for (int i = 0; i <= maxSize; ++i) {
            num = new Integer(i);
            String numStr = num.toString();
            map.put((Object)numStr, (Object)num);
        }
        num = (Integer)map.get((Object)"0");
        if (num == null) {
            this.logln("OK: The entry '0' was removed.");
        } else {
            this.errln("The entry '0' is still available.");
        }
        num = (Integer)map.get((Object)"1");
        if (num == null) {
            this.errln("The eldest entry '1' was removed.");
        } else {
            this.logln("OK: The eldest entry '1' is available.");
        }
        num = new Integer(maxSize + 1);
        map.put((Object)num.toString(), (Object)num);
        num = (Integer)map.get((Object)"2");
        if (num == null) {
            this.logln("OK: The entry '2' was removed.");
        } else {
            this.errln("The entry '2' is still available.");
        }
        boolean b = map.containsKey((Object)"3");
        if (b) {
            this.logln("OK: The eldest entry '3' is available.");
        } else {
            this.errln("The eldest entry '3' was removed.");
        }
        num = new Integer(maxSize + 2);
        map.put((Object)num.toString(), (Object)num);
        num = (Integer)map.get((Object)"3");
        if (num == null) {
            this.logln("OK: The entry '3' was removed.");
        } else {
            this.errln("The entry '3' is still available.");
        }
        num = (Integer)map.put((Object)"4", (Object)new Integer(-4));
        if (num == null) {
            this.errln("The entry '4' no longer exists");
        }
        if (num != 4) {
            this.errln("The value for '4' was not 4");
        }
        num = new Integer(maxSize + 3);
        map.put((Object)num.toString(), (Object)num);
        num = (Integer)map.get((Object)"5");
        if (num == null) {
            this.logln("OK: The entry '5' was removed.");
        } else {
            this.errln("The entry '5' is still available.");
        }
        map.clear();
        num = (Integer)map.get((Object)"6");
        if (num == null) {
            this.logln("OK: The entry '6' was removed.");
        } else {
            this.errln("The entry '6' is still available.");
        }
    }
}

