/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.dev.test.util;

import com.ibm.icu.dev.test.util.BagFormatter;
import com.ibm.icu.dev.test.util.ICUPropertyFactory;
import com.ibm.icu.dev.test.util.UnicodeMap;
import com.ibm.icu.dev.test.util.UnicodeProperty;
import com.ibm.icu.lang.UScript;
import com.ibm.icu.text.Transliterator;
import com.ibm.icu.text.UnicodeSet;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.Collator;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Locale;
import java.util.TreeSet;

public class TestBagFormatter {
    static final double LOG10 = Math.log(10.0);
    static final UnicodeSet RTL = new UnicodeSet("[[:L:]&[[:bidi class=R:][:bidi class=AL:]]]");
    static final Transliterator toHTML = Transliterator.createFromRules((String)"any-html", (String)"'<' > '&lt;' ;'&' > '&amp;' ;'>' > '&gt;' ;'\"' > '&quot;' ; ", (int)0);
    static final Transliterator fromHTML = Transliterator.createFromRules((String)"html-any", (String)"'<' < '&'[lL][Tt]';' ;'&' < '&'[aA][mM][pP]';' ;'>' < '&'[gG][tT]';' ;'\"' < '&'[qQ][uU][oO][tT]';' ; ", (int)1);

    static final void generatePropertyAliases(boolean showValues) {
        TestBagFormatter.generatePropertyAliases(showValues, ICUPropertyFactory.make());
    }

    static final void generatePropertyAliases(boolean showValues, UnicodeProperty.Factory ups) {
        Collator order = Collator.getInstance(Locale.ENGLISH);
        TreeSet<Object> props = new TreeSet<Object>(order);
        TreeSet<Object> values = new TreeSet<Object>(order);
        BagFormatter bf = new BagFormatter();
        props.addAll(ups.getAvailableNames());
        for (int i = 2; i < 14; ++i) {
            System.out.println(UnicodeProperty.getTypeName(i));
            Iterator<Object> it = props.iterator();
            while (it.hasNext()) {
                String propAlias = (String)it.next();
                UnicodeProperty up = ups.getProperty(propAlias);
                int type = up.getType();
                if (type != i) continue;
                System.out.println();
                System.out.println(propAlias + "\t" + bf.join(up.getNameAliases()));
                if (!showValues) continue;
                values.clear();
                if (type == 12 || type == 13) {
                    UnicodeMap um = new UnicodeMap();
                    um.putAll(up);
                    System.out.println(um.toString(new NumberComparator()));
                    continue;
                }
                values.clear();
                values.addAll(up.getAvailableValues());
                Iterator<Object> it2 = values.iterator();
                while (it2.hasNext()) {
                    String valueAlias = (String)it2.next();
                    System.out.println("\t" + bf.join(valueAlias + "\t" + up.getValueAliases(valueAlias)));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        System.out.println("Start");
        try {
            UnicodeProperty prop = ICUPropertyFactory.make().getProperty("Canonicalcombiningclass");
            prop.getAvailableValues();
            TestBagFormatter.generatePropertyAliases(true);
            BagFormatter bf = new BagFormatter();
            UnicodeSet us = new UnicodeSet("[:gc=nd:]");
            BagFormatter.CONSOLE.println("[:gc=nd:]");
            bf.showSetNames(BagFormatter.CONSOLE, (Object)us);
            us = new UnicodeSet("[:numeric_value=2:]");
            BagFormatter.CONSOLE.println("[:numeric_value=2:]");
            bf.showSetNames(BagFormatter.CONSOLE, (Object)us);
            us = new UnicodeSet("[:numeric_type=numeric:]");
            BagFormatter.CONSOLE.println("[:numeric_type=numeric:]");
            bf.showSetNames(BagFormatter.CONSOLE, (Object)us);
            ICUPropertyFactory ups = ICUPropertyFactory.make();
            us = ups.getSet("gc=mn", null, null);
            BagFormatter.CONSOLE.println("gc=mn");
            bf.showSetNames(BagFormatter.CONSOLE, (Object)us);
            return;
        }
        finally {
            System.out.println("End");
        }
    }

    static void testLocales() throws IOException {
        Locale[] locales = Collator.getAvailableLocales();
        TreeSet<Object> s = new TreeSet<Object>(Collator.getInstance());
        for (int i = 0; i < locales.length; ++i) {
            String lang = locales[i].getLanguage();
            String dlang = locales[i].getDisplayLanguage();
            String country = locales[i].getCountry();
            String dcountry = locales[i].getDisplayCountry();
            if (country.equals("")) continue;
            s.add("\t" + dcountry + "\t" + country + "\t" + dlang + "\t" + lang);
        }
        PrintWriter pw = BagFormatter.openUTF8Writer("", "countries.txt");
        Iterator it = s.iterator();
        while (it.hasNext()) {
            pw.println(it.next());
        }
        pw.close();
    }

    public static void useSignificantDigits(double value, int digits) {
        double log10 = Math.log(value) / LOG10;
    }

    static boolean isRTL(Locale loc) {
        int[] scripts = UScript.getCode((Locale)loc);
        return new UnicodeSet().applyIntPropertyValue(4106, scripts == null ? 25 : scripts[0]).retainAll(RTL).size() != 0;
    }

    static void testIsRTL() {
        Locale[] locales = Locale.getAvailableLocales();
        TreeSet<String> s = new TreeSet<String>();
        for (int i = 0; i < locales.length; ++i) {
            s.add((TestBagFormatter.isRTL(locales[i]) ? "R " : "L ") + locales[i].getDisplayName());
        }
        Iterator it = s.iterator();
        while (it.hasNext()) {
            System.out.println(it.next());
        }
    }

    static void checkHTML() {
        String foo = "& n < b < \"ab\"";
        String fii = toHTML.transliterate(foo);
        System.out.println("in: " + foo);
        System.out.println("out: " + fii);
        System.out.println("in*: " + fromHTML.transliterate(fii));
        System.out.println("IN*: " + fromHTML.transliterate(fii.toUpperCase()));
    }

    static class NumberComparator
    implements Comparator {
        NumberComparator() {
        }

        public int compare(Object o1, Object o2) {
            double n2;
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            double n1 = Double.parseDouble((String)o1);
            return n1 < (n2 = Double.parseDouble((String)o2)) ? -1 : (n1 > n2 ? 1 : 0);
        }
    }
}

