/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.dev.test.util;

import com.ibm.icu.dev.test.TestFmwk;
import com.ibm.icu.impl.TextTrieMap;

public class TextTrieMapTest
extends TestFmwk {
    private static final Integer SUN = new Integer(1);
    private static final Integer MON = new Integer(2);
    private static final Integer TUE = new Integer(3);
    private static final Integer WED = new Integer(4);
    private static final Integer THU = new Integer(5);
    private static final Integer FRI = new Integer(6);
    private static final Integer SAT = new Integer(7);
    private static final Integer FOO = new Integer(-1);
    private static final Integer BAR = new Integer(-2);
    private static final Object[][] TESTDATA = new Object[][]{{"Sunday", SUN}, {"Monday", MON}, {"Tuesday", TUE}, {"Wednesday", WED}, {"Thursday", THU}, {"Friday", FRI}, {"Saturday", SAT}, {"Sun", SUN}, {"Mon", MON}, {"Tue", TUE}, {"Wed", WED}, {"Thu", THU}, {"Fri", FRI}, {"Sat", SAT}, {"S", SUN}, {"M", MON}, {"T", TUE}, {"W", WED}, {"T", THU}, {"F", FRI}, {"S", SAT}};
    private static final Object[][] TESTCASES = new Object[][]{{"Sunday", SUN, SUN}, {"sunday", null, SUN}, {"Mo", MON, MON}, {"mo", null, MON}, {"Thursday Friday", THU, THU}, {"T", THU, THU}, {"TEST", THU, THU}, {"SUN", SAT, SUN}, {"super", null, SAT}, {"NO", null, null}};

    public static void main(String[] args) throws Exception {
        TextTrieMapTest test = new TextTrieMapTest();
        test.run(args);
    }

    public void TestCaseSensitive() {
        Object value;
        int i;
        TextTrieMap map = new TextTrieMap(false);
        for (i = 0; i < TESTDATA.length; ++i) {
            map.put((String)TESTDATA[i][0], TESTDATA[i][1]);
        }
        this.logln("Test for get(String)");
        for (i = 0; i < TESTCASES.length; ++i) {
            Object value2 = map.get((String)TESTCASES[i][0]);
            if (this.eql(value2, TESTCASES[i][1])) continue;
            this.errln("Invalid search results - Expected:" + TESTCASES[i][1] + " Actual:" + value2);
        }
        this.logln("Test for get(String, int)");
        StringBuffer textBuf = new StringBuffer();
        for (int i2 = 0; i2 < TESTCASES.length; ++i2) {
            textBuf.setLength(0);
            for (int j = 0; j < i2; ++j) {
                textBuf.append('X');
            }
            textBuf.append(TESTCASES[i2][0]);
            value = map.get(textBuf.toString(), i2);
            if (this.eql(value, TESTCASES[i2][1])) continue;
            this.errln("Invalid search results - Expected:" + TESTCASES[i2][1] + " Actual:" + value);
        }
        Object prev = map.put("Sunday", (Object)FOO);
        if (!this.eql(prev, SUN)) {
            this.errln("The previous value of duplicated entry is not valid - Expected:" + SUN + " Actual:" + prev);
        }
        if (!this.eql(value = map.get("Sunday"), FOO)) {
            this.errln("The map value is not valid - Expected:" + FOO + " Actual:" + value);
        }
        if (!this.eql(prev = map.put("sunday", (Object)BAR), null)) {
            this.errln("The value should be new in the trie map - Expected:null Actual:" + prev);
        }
        if (!this.eql(value = map.get("sunday"), BAR)) {
            this.errln("The map value is not valid - Expected:" + BAR + " Actual:" + value);
        }
    }

    public void TestCaseInsensitive() {
        Object value;
        int i;
        TextTrieMap map = new TextTrieMap(true);
        for (i = 0; i < TESTDATA.length; ++i) {
            map.put((String)TESTDATA[i][0], TESTDATA[i][1]);
        }
        this.logln("Test for get(String)");
        for (i = 0; i < TESTCASES.length; ++i) {
            Object value2 = map.get((String)TESTCASES[i][0]);
            if (this.eql(value2, TESTCASES[i][2])) continue;
            this.errln("Invalid search results - Expected:" + TESTCASES[i][2] + " Actual:" + value2);
        }
        this.logln("Test for get(String, int)");
        StringBuffer textBuf = new StringBuffer();
        for (int i2 = 0; i2 < TESTCASES.length; ++i2) {
            textBuf.setLength(0);
            for (int j = 0; j < i2; ++j) {
                textBuf.append('X');
            }
            textBuf.append(TESTCASES[i2][0]);
            value = map.get(textBuf.toString(), i2);
            if (this.eql(value, TESTCASES[i2][2])) continue;
            this.errln("Invalid search results - Expected:" + TESTCASES[i2][2] + " Actual:" + value);
        }
        Object prev = map.put("Sunday", (Object)FOO);
        if (!this.eql(prev, SUN)) {
            this.errln("The previous value of duplicated entry is not valid - Expected:" + SUN + " Actual:" + prev);
        }
        if (!this.eql(value = map.get("Sunday"), FOO)) {
            this.errln("The map value is not valid - Expected:" + FOO + " Actual:" + value);
        }
        if (!this.eql(prev = map.put("sunday", (Object)BAR), FOO)) {
            this.errln("The value should be new in the trie map - Expected:" + FOO + " Actual:" + prev);
        }
        if (!this.eql(value = map.get("sunday"), BAR)) {
            this.errln("The map value is not valid - Expected:" + BAR + " Actual:" + value);
        }
    }

    private boolean eql(Object o1, Object o2) {
        if (o1 == null || o2 == null) {
            return o1 == null && o2 == null;
        }
        return o1.equals(o2);
    }
}

