/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.dev.test.util;

import com.ibm.icu.dev.test.TestFmwk;
import com.ibm.icu.dev.test.util.ULocaleTest;
import com.ibm.icu.text.BreakIterator;
import com.ibm.icu.text.Collator;
import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.ULocale;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.TreeMap;

public class ULocaleTest
extends TestFmwk {
    private static final int LOCALE_SIZE = 9;
    private static final String[][] rawData2 = new String[][]{{"en", "fr", "ca", "el", "no", "zh", "de", "es", "ja"}, {"", "", "", "", "", "Hans", "", "", ""}, {"US", "FR", "ES", "GR", "NO", "CN", "DE", "", "JP"}, {"", "", "", "", "NY", "", "", "", ""}, {"en_US", "fr_FR", "ca_ES", "el_GR", "no_NO_NY", "zh_Hans_CN", "de_DE@collation=phonebook", "es@collation=traditional", "ja_JP@calendar=japanese"}, {"eng", "fra", "cat", "ell", "nor", "zho", "deu", "spa", "jpn"}, {"USA", "FRA", "ESP", "GRC", "NOR", "CHN", "DEU", "", "JPN"}, {"409", "40c", "403", "408", "814", "804", "407", "a", "411"}, {"English", "French", "Catalan", "Greek", "Norwegian", "Chinese", "German", "Spanish", "Japanese"}, {"", "", "", "", "", "Simplified Han", "", "", ""}, {"United States", "France", "Spain", "Greece", "Norway", "China", "Germany", "", "Japan"}, {"", "", "", "", "NY", "", "", "", ""}, {"English (United States)", "French (France)", "Catalan (Spain)", "Greek (Greece)", "Norwegian (Norway, NY)", "Chinese (Simplified Han, China)", "German (Germany, Collation=Phonebook Order)", "Spanish (Collation=Traditional)", "Japanese (Japan, Calendar=Japanese Calendar)"}, {"anglais", "fran\\u00E7ais", "catalan", "grec", "norv\\u00E9gien", "chinois", "allemand", "espagnol", "japonais"}, {"", "", "", "", "", "Hans", "", "", ""}, {"\\u00C9tats-Unis", "France", "Espagne", "Gr\\u00E8ce", "Norv\\u00E8ge", "Chine", "Allemagne", "", "Japon"}, {"", "", "", "", "NY", "", "", "", ""}, {"anglais (\\u00C9tats-Unis)", "fran\\u00E7ais (France)", "catalan (Espagne)", "grec (Gr\\u00E8ce)", "norv\\u00E9gien (Norv\\u00E8ge, NY)", "chinois (Hans, Chine)", "allemand (Allemagne, Ordonnancement=Ordre de l'annuaire)", "espagnol (Ordonnancement=Ordre traditionnel)", "japonais (Japon, Calendrier=Calendrier japonais)"}, {"angl\\u00E8s", "franc\\u00E8s", "catal\\u00E0", "grec", "noruec", "xin\\u00E9s", "alemany", "espanyol", "japon\\u00E8s"}, {"", "", "", "", "", "Hans", "", "", ""}, {"Estats Units", "Fran\\u00E7a", "Espanya", "Gr\\u00E8cia", "Noruega", "Xina", "Alemanya", "", "Jap\\u00F3"}, {"", "", "", "", "NY", "", "", "", ""}, {"angl\\u00E8s (Estats Units)", "franc\\u00E8s (Fran\\u00E7a)", "catal\\u00E0 (Espanya)", "grec (Gr\\u00E8cia)", "noruec (Noruega, NY)", "xin\\u00E9s (Hans, Xina)", "alemany (Alemanya, COLLATION=PHONEBOOK)", "espanyol (COLLATION=TRADITIONAL)", "japon\\u00E8s (Jap\\u00F3, CALENDAR=JAPANESE)"}, {"\\u0391\\u03b3\\u03b3\\u03bb\\u03b9\\u03ba\\u03ac", "\\u0393\\u03b1\\u03bb\\u03bb\\u03b9\\u03ba\\u03ac", "\\u039a\\u03b1\\u03c4\\u03b1\\u03bb\\u03b1\\u03bd\\u03b9\\u03ba\\u03ac", "\\u0395\\u03bb\\u03bb\\u03b7\\u03bd\\u03b9\\u03ba\\u03ac", "\\u039d\\u03bf\\u03c1\\u03b2\\u03b7\\u03b3\\u03b9\\u03ba\\u03ac", "\\u039A\\u03B9\\u03BD\\u03B5\\u03B6\\u03B9\\u03BA\\u03AC", "\\u0393\\u03B5\\u03C1\\u03BC\\u03B1\\u03BD\\u03B9\\u03BA\\u03AC", "\\u0399\\u03C3\\u03C0\\u03B1\\u03BD\\u03B9\\u03BA\\u03AC", "\\u0399\\u03B1\\u03C0\\u03C9\\u03BD\\u03B9\\u03BA\\u03AC"}, {"", "", "", "", "", "Hans", "", "", ""}, {"\\u0397\\u03bd\\u03c9\\u03bc\\u03ad\\u03bd\\u03b5\\u03c2 \\u03a0\\u03bf\\u03bb\\u03b9\\u03c4\\u03b5\\u03af\\u03b5\\u03c2", "\\u0393\\u03b1\\u03bb\\u03bb\\u03af\\u03b1", "\\u0399\\u03c3\\u03c0\\u03b1\\u03bd\\u03af\\u03b1", "\\u0395\\u03bb\\u03bb\\u03ac\\u03b4\\u03b1", "\\u039d\\u03bf\\u03c1\\u03b2\\u03b7\\u03b3\\u03af\\u03b1", "\\u039A\\u03AF\\u03BD\\u03B1", "\\u0393\\u03B5\\u03C1\\u03BC\\u03B1\\u03BD\\u03AF\\u03B1", "", "\\u0399\\u03B1\\u03C0\\u03C9\\u03BD\\u03AF\\u03B1"}, {"", "", "", "", "NY", "", "", "", ""}, {"\\u0391\\u03b3\\u03b3\\u03bb\\u03b9\\u03ba\\u03ac (\\u0397\\u03bd\\u03c9\\u03bc\\u03ad\\u03bd\\u03b5\\u03c2 \\u03a0\\u03bf\\u03bb\\u03b9\\u03c4\\u03b5\\u03af\\u03b5\\u03c2)", "\\u0393\\u03b1\\u03bb\\u03bb\\u03b9\\u03ba\\u03ac (\\u0393\\u03b1\\u03bb\\u03bb\\u03af\\u03b1)", "\\u039a\\u03b1\\u03c4\\u03b1\\u03bb\\u03b1\\u03bd\\u03b9\\u03ba\\u03ac (\\u0399\\u03c3\\u03c0\\u03b1\\u03bd\\u03af\\u03b1)", "\\u0395\\u03bb\\u03bb\\u03b7\\u03bd\\u03b9\\u03ba\\u03ac (\\u0395\\u03bb\\u03bb\\u03ac\\u03b4\\u03b1)", "\\u039d\\u03bf\\u03c1\\u03b2\\u03b7\\u03b3\\u03b9\\u03ba\\u03ac (\\u039d\\u03bf\\u03c1\\u03b2\\u03b7\\u03b3\\u03af\\u03b1, NY)", "\\u039A\\u03B9\\u03BD\\u03B5\\u03B6\\u03B9\\u03BA\\u03AC (Hans, \\u039A\\u03AF\\u03BD\\u03B1)", "\\u0393\\u03B5\\u03C1\\u03BC\\u03B1\\u03BD\\u03B9\\u03BA\\u03AC (\\u0393\\u03B5\\u03C1\\u03BC\\u03B1\\u03BD\\u03AF\\u03B1, COLLATION=PHONEBOOK)", "\\u0399\\u03C3\\u03C0\\u03B1\\u03BD\\u03B9\\u03BA\\u03AC (COLLATION=TRADITIONAL)", "\\u0399\\u03B1\\u03C0\\u03C9\\u03BD\\u03B9\\u03BA\\u03AC (\\u0399\\u03B1\\u03C0\\u03C9\\u03BD\\u03AF\\u03B1, CALENDAR=JAPANESE)"}};
    private static final int ENGLISH = 0;
    private static final int FRENCH = 1;
    private static final int CATALAN = 2;
    private static final int GREEK = 3;
    private static final int NORWEGIAN = 4;
    private static final int LANG = 0;
    private static final int SCRIPT = 1;
    private static final int CTRY = 2;
    private static final int VAR = 3;
    private static final int NAME = 4;
    private static final int LANG3 = 5;
    private static final int CTRY3 = 6;
    private static final int LCID = 7;
    private static final int DLANG_EN = 8;
    private static final int DSCRIPT_EN = 9;
    private static final int DCTRY_EN = 10;
    private static final int DVAR_EN = 11;
    private static final int DNAME_EN = 12;
    private static final int DLANG_FR = 13;
    private static final int DSCRIPT_FR = 14;
    private static final int DCTRY_FR = 15;
    private static final int DVAR_FR = 16;
    private static final int DNAME_FR = 17;
    private static final int DLANG_CA = 18;
    private static final int DSCRIPT_CA = 19;
    private static final int DCTRY_CA = 20;
    private static final int DVAR_CA = 21;
    private static final int DNAME_CA = 22;
    private static final int DLANG_EL = 23;
    private static final int DSCRIPT_EL = 24;
    private static final int DCTRY_EL = 25;
    private static final int DVAR_EL = 26;
    private static final int DNAME_EL = 27;
    private static Hashtable[] h = new Hashtable[2];
    private static final String[][] ACCEPT_LANGUAGE_TESTS = new String[][]{{"mt_MT", "false"}, {"en", "false"}, {"en", "true"}, {null, "true"}, {"es", "false"}, {"de", "false"}};
    private static final String[] ACCEPT_LANGUAGE_HTTP = new String[]{"mt-mt, ja;q=0.76, en-us;q=0.95, en;q=0.92, en-gb;q=0.89, fr;q=0.87, iu-ca;q=0.84, iu;q=0.82, ja-jp;q=0.79, mt;q=0.97, de-de;q=0.74, de;q=0.71, es;q=0.68, it-it;q=0.66, it;q=0.63, vi-vn;q=0.61, vi;q=0.58, nl-nl;q=0.55, nl;q=0.53, th-th-traditional;q=.01", "ja;q=0.5, en;q=0.8, tlh", "en-zzz, de-lx;q=0.8", "mga-ie;q=0.9, tlh", "xxx-yyy;q=.01, xxx-yyy;q=.01, xxx-yyy;q=.01, xxx-yyy;q=.01, xxx-yyy;q=.01, xxx-yyy;q=.01, xxx-yyy;q=.01, xxx-yyy;q=.01, xxx-yyy;q=.01, xxx-yyy;q=.01, xxx-yyy;q=.01, xxx-yyy;q=.01, xxx-yyy;q=.01, xxx-yyy;q=.01, xxx-yyy;q=.01, xxx-yyy;q=.01, xxx-yyy;q=.01, xxx-yyy;q=.01, xxx-yyy;q=.01, xxx-yyy;q=.01, xxx-yyy;q=.01, xxx-yyy;q=.01, xxx-yyy;q=.01, xxx-yyy;q=.01, xxx-yyy;q=.01, xxx-yyy;q=.01, xxx-yyy;q=.01, xxx-yyy;q=.01, xxx-yyy;q=.01, xxx-yyy;q=.01, xxx-yyy;q=.01, xxx-yyy;q=.01, xxx-yyy;q=.01, xxx-yyy;q=.01, xxx-yyy;q=.01, xxx-yyy;q=.01, xxx-yyy;q=.01, xxx-yyy;q=.01, xxx-yyy;q=.01, xxx-yyy;q=.01, xxx-yyy;q=.01, xxx-yyy;q=.01, xxx-yyy;q=.01, xxx-yyy;q=.01, xxx-yyy;q=.01, xxx-yyy;q=.01, xxx-yyy;q=.01, xxx-yyy;q=.01, xxx-yyy;q=.01, xxx-yyy;q=.01, xxx-yyy;q=.01, xxx-yyy;q=.01, xxx-yyy;q=.01, xxx-yyy;q=.01, xxx-yyy;q=.01, xxx-yyy;q=.01, xxx-yyy;q=.01, xxx-yyy;q=.01, xxx-yyy;q=.01, xxx-yyy;q=.01, es", "de;q=.9, fr;q=.9, xxx-yyy, sr;q=.8"};
    static /* synthetic */ Class class$com$ibm$icu$util$ULocale$Type;

    public static void main(String[] args) throws Exception {
        new ULocaleTest().run(args);
    }

    public void TestCalendar() {
        this.checkService("en_US_BROOKLYN", new ServiceFacade(){

            public Object create(ULocale req) {
                return Calendar.getInstance((ULocale)req);
            }
        });
    }

    public void TestBreakIterator() {
        this.checkService("ja_JP_OSAKA", new ServiceFacade(){

            public Object create(ULocale req) {
                return BreakIterator.getWordInstance((ULocale)req);
            }
        }, null, new Registrar(){

            public Object register(ULocale loc, Object prototype) {
                return BreakIterator.registerInstance((BreakIterator)((BreakIterator)prototype), (ULocale)loc, (int)1);
            }

            public boolean unregister(Object key) {
                return BreakIterator.unregister((Object)key);
            }
        });
    }

    public void TestCollator() {
        this.checkService("ja_JP_YOKOHAMA", new ServiceFacade(){

            public Object create(ULocale req) {
                return Collator.getInstance((ULocale)req);
            }
        }, null, new Registrar(){

            public Object register(ULocale loc, Object prototype) {
                return Collator.registerInstance((Collator)((Collator)prototype), (ULocale)loc);
            }

            public boolean unregister(Object key) {
                return Collator.unregister((Object)key);
            }
        });
    }

    public void TestDateFormat() {
        this.checkService("de_CH_ZURICH", new ServiceFacade(){

            public Object create(ULocale req) {
                return DateFormat.getDateInstance((int)2, (ULocale)req);
            }
        }, new Subobject(){

            public Object get(Object parent) {
                return ((SimpleDateFormat)parent).getDateFormatSymbols();
            }
        }, null);
    }

    public void TestNumberFormat() {
        this.checkService("fr_FR_NICE", new ServiceFacade(){

            public Object create(ULocale req) {
                return NumberFormat.getInstance((ULocale)req);
            }
        }, new Subobject(){

            public Object get(Object parent) {
                return ((DecimalFormat)parent).getDecimalFormatSymbols();
            }
        }, new Registrar(){

            public Object register(ULocale loc, Object prototype) {
                class NFactory
                extends NumberFormat.SimpleNumberFormatFactory {
                    NumberFormat proto;
                    ULocale locale;
                    private final /* synthetic */ ULocaleTest this$0;

                    public NFactory(ULocaleTest this$0, ULocale loc, NumberFormat fmt) {
                        super(loc);
                        this.this$0 = this$0;
                        this.locale = loc;
                        this.proto = fmt;
                    }

                    public NumberFormat createFormat(ULocale loc, int formatType) {
                        return (NumberFormat)(this.locale.equals((Object)loc) ? this.proto.clone() : null);
                    }
                }
                NFactory f = new NFactory(ULocaleTest.this, loc, (NumberFormat)prototype);
                return NumberFormat.registerFactory((NumberFormat.NumberFormatFactory)f);
            }

            public boolean unregister(Object key) {
                return NumberFormat.unregister((Object)key);
            }
        });
    }

    public void TestSetULocaleKeywords() {
        ULocale uloc = new ULocale("en_Latn_US");
        if (!"en_Latn_US@foo=FooValue".equals((uloc = uloc.setKeywordValue("Foo", "FooValue")).getName())) {
            this.errln("failed to add foo keyword, got: " + uloc.getName());
        }
        if (!"en_Latn_US@bar=BarValue;foo=FooValue".equals((uloc = uloc.setKeywordValue("Bar", "BarValue")).getName())) {
            this.errln("failed to add bar keyword, got: " + uloc.getName());
        }
        if (!"en_Latn_US@bar=NewBarValue;foo=FooValue".equals((uloc = uloc.setKeywordValue("BAR", "NewBarValue")).getName())) {
            this.errln("failed to change bar keyword, got: " + uloc.getName());
        }
        if (!"en_Latn_US@foo=FooValue".equals((uloc = uloc.setKeywordValue("BaR", null)).getName())) {
            this.errln("failed to delete bar keyword, got: " + uloc.getName());
        }
        if (!"en_Latn_US".equals((uloc = uloc.setKeywordValue(null, null)).getName())) {
            this.errln("failed to delete all keywords, got: " + uloc.getName());
        }
    }

    static int loccmp(String string, String prefix) {
        int slen = string.length();
        int plen = prefix.length();
        if (prefix.equals("root")) {
            return string.equals("root") ? 0 : 1;
        }
        if (plen == 0) {
            return slen == 0 ? 0 : 1;
        }
        if (!string.startsWith(prefix)) {
            return -1;
        }
        if (slen == plen) {
            return 0;
        }
        if (string.charAt(plen) == '_') {
            return 1;
        }
        return -2;
    }

    void checklocs(String label, String req, Locale validLoc, Locale actualLoc, String expReqValid, String expValidActual) {
        boolean valOK;
        String valid = validLoc.toString();
        String actual = actualLoc.toString();
        int reqValid = ULocaleTest.loccmp(req, valid);
        int validActual = ULocaleTest.loccmp(valid, actual);
        boolean reqOK = expReqValid.equals("gt") && reqValid > 0 || expReqValid.equals("ge") && reqValid >= 0 || expReqValid.equals("eq") && reqValid == 0;
        boolean bl = valOK = expValidActual.equals("gt") && validActual > 0 || expValidActual.equals("ge") && validActual >= 0 || expValidActual.equals("eq") && validActual == 0;
        if (reqOK && valOK) {
            this.logln("Ok: " + label + "; req=" + req + ", valid=" + valid + ", actual=" + actual);
        } else {
            this.errln("FAIL: " + label + "; req=" + req + ", valid=" + valid + ", actual=" + actual + (reqOK ? "" : "\n  req !" + expReqValid + " valid") + (valOK ? "" : "\n  val !" + expValidActual + " actual"));
        }
    }

    void checkObject(String requestedLocale, Object obj, String expReqValid, String expValidActual) {
        Class[] params = new Class[]{class$com$ibm$icu$util$ULocale$Type == null ? (class$com$ibm$icu$util$ULocale$Type = ULocaleTest.class$("com.ibm.icu.util.ULocale$Type")) : class$com$ibm$icu$util$ULocale$Type};
        try {
            Class<?> cls = obj.getClass();
            Method getLocale = cls.getMethod("getLocale", params);
            ULocale valid = (ULocale)getLocale.invoke(obj, ULocale.VALID_LOCALE);
            ULocale actual = (ULocale)getLocale.invoke(obj, ULocale.ACTUAL_LOCALE);
            this.checklocs(cls.getName(), requestedLocale, valid.toLocale(), actual.toLocale(), expReqValid, expValidActual);
        }
        catch (NoSuchMethodException e1) {
        }
        catch (SecurityException e2) {
            this.errln("FAIL: reflection failed: " + e2);
        }
        catch (IllegalAccessException e3) {
            this.errln("FAIL: reflection failed: " + e3);
        }
        catch (IllegalArgumentException e4) {
            this.errln("FAIL: reflection failed: " + e4);
        }
        catch (InvocationTargetException e5) {
            // empty catch block
        }
    }

    void checkService(String requestedLocale, ServiceFacade svc) {
        this.checkService(requestedLocale, svc, null, null);
    }

    void checkService(String requestedLocale, ServiceFacade svc, Subobject sub, Registrar reg) {
        ULocale req = new ULocale(requestedLocale);
        Object obj = svc.create(req);
        this.checkObject(requestedLocale, obj, "gt", "ge");
        if (sub != null) {
            Object subobj = sub.get(obj);
            this.checkObject(requestedLocale, subobj, "gt", "ge");
        }
        if (reg != null) {
            this.logln("Info: Registering service");
            Object key = reg.register(req, obj);
            Object objReg = svc.create(req);
            this.checkObject(requestedLocale, objReg, "eq", "eq");
            if (sub != null) {
                Object subobj = sub.get(obj);
                this.checkObject(requestedLocale, subobj, "gt", "ge");
            }
            this.logln("Info: Unregistering service");
            if (!reg.unregister(key)) {
                this.errln("FAIL: unregister failed");
            }
            Object objUnreg = svc.create(req);
            this.checkObject(requestedLocale, objUnreg, "gt", "ge");
        }
    }

    public void TestBasicGetters() {
        this.logln("Testing Basic Getters\n");
        for (int i = 0; i < 9; ++i) {
            String name;
            String var;
            String ctry;
            String testLocale = rawData2[4][i];
            this.logln("Testing " + testLocale + ".....\n");
            String lang = ULocale.getLanguage((String)testLocale);
            if (0 != lang.compareTo(rawData2[0][i])) {
                this.errln("  Language code mismatch: " + lang + " versus " + rawData2[0][i]);
            }
            if (0 != (ctry = ULocale.getCountry((String)testLocale)).compareTo(rawData2[2][i])) {
                this.errln("  Country code mismatch: " + ctry + " versus " + rawData2[2][i]);
            }
            if (0 != (var = ULocale.getVariant((String)testLocale)).compareTo(rawData2[3][i])) {
                this.errln("  Variant code mismatch: " + var + " versus " + rawData2[3][i]);
            }
            if (0 == (name = ULocale.getName((String)testLocale)).compareTo(rawData2[4][i])) continue;
            this.errln("  Name mismatch: " + name + " versus " + rawData2[4][i]);
        }
    }

    public void TestPrefixes() {
        String[][] testData = new String[][]{{"sv", "", "FI", "AL", "sv-fi-al", "sv_FI_AL", null}, {"en", "", "GB", "", "en-gb", "en_GB", null}, {"i-hakka", "", "MT", "XEMXIJA", "i-hakka_MT_XEMXIJA", "i-hakka_MT_XEMXIJA", null}, {"i-hakka", "", "CN", "", "i-hakka_CN", "i-hakka_CN", null}, {"i-hakka", "", "MX", "", "I-hakka_MX", "i-hakka_MX", null}, {"x-klingon", "", "US", "SANJOSE", "X-KLINGON_us_SANJOSE", "x-klingon_US_SANJOSE", null}, {"mr", "", "", "", "mr.utf8", "mr.utf8", "mr"}, {"de", "", "TV", "", "de-tv.koi8r", "de_TV.koi8r", "de_TV"}, {"x-piglatin", "", "ML", "", "x-piglatin_ML.MBE", "x-piglatin_ML.MBE", "x-piglatin_ML"}, {"i-cherokee", "", "US", "", "i-Cherokee_US.utf7", "i-cherokee_US.utf7", "i-cherokee_US"}, {"x-filfli", "", "MT", "FILFLA", "x-filfli_MT_FILFLA.gb-18030", "x-filfli_MT_FILFLA.gb-18030", "x-filfli_MT_FILFLA"}, {"no", "", "NO", "NY_B", "no-no-ny.utf32@B", "no_NO_NY.utf32@B", "no_NO_NY_B"}, {"no", "", "NO", "B", "no-no.utf32@B", "no_NO.utf32@B", "no_NO_B"}, {"no", "", "", "NY", "no__ny", "no__NY", null}, {"no", "", "", "NY", "no@ny", "no@ny", "no__NY"}, {"el", "Latn", "", "", "el-latn", "el_Latn", null}, {"en", "Cyrl", "RU", "", "en-cyrl-ru", "en_Cyrl_RU", null}, {"zh", "Hant", "TW", "STROKE", "zh-hant_TW_STROKE", "zh_Hant_TW_STROKE", null}, {"qq", "Qqqq", "QQ", "QQ", "qq_Qqqq_QQ_QQ", "qq_Qqqq_QQ_QQ", null}, {"qq", "Qqqq", "", "QQ", "qq_Qqqq__QQ", "qq_Qqqq__QQ", null}, {"12", "3456", "78", "90", "12_3456_78_90", "12_3456_78_90", null}, {"", "", "", "", "@FOO=bar", "@foo=bar", null}, {"", "", "", "", "_@FOO=bar", "@foo=bar", null}, {"", "", "", "", "__@FOO=bar", "@foo=bar", null}, {"", "", "", "FOO", "__foo@FOO=bar", "__FOO@foo=bar", null}};
        String[] testTitles = new String[]{"ULocale.getLanguage()", "ULocale.getScript()", "ULocale.getCountry()", "ULocale.getVariant()", "name", "ULocale.getName()", "canonicalize()"};
        for (int row = 0; row < testData.length; ++row) {
            String loc = testData[row][4];
            this.logln("Test #" + row + ": " + loc);
            ULocale uloc = new ULocale(loc);
            for (int n = 0; n <= 6; ++n) {
                String buf1;
                String buf;
                if (n == 4) continue;
                switch (n) {
                    case 0: {
                        buf = ULocale.getLanguage((String)loc);
                        buf1 = uloc.getLanguage();
                        break;
                    }
                    case 1: {
                        buf = ULocale.getScript((String)loc);
                        buf1 = uloc.getScript();
                        break;
                    }
                    case 2: {
                        buf = ULocale.getCountry((String)loc);
                        buf1 = uloc.getCountry();
                        break;
                    }
                    case 3: {
                        buf1 = buf = ULocale.getVariant((String)loc);
                        break;
                    }
                    case 5: {
                        buf = ULocale.getName((String)loc);
                        buf1 = uloc.getName();
                        break;
                    }
                    case 6: {
                        buf = ULocale.canonicalize((String)loc);
                        buf1 = ULocale.createCanonical((String)loc).getName();
                        break;
                    }
                    default: {
                        buf1 = buf = "**??";
                    }
                }
                this.logln("#" + row + ": " + testTitles[n] + " on " + loc + ": -> [" + buf + "]");
                String expected = testData[row][n];
                if (expected == null && n == 6) {
                    expected = testData[row][5];
                }
                if (n == 5 && (expected.indexOf(46) != -1 || expected.indexOf(64) != -1)) continue;
                if (buf.compareTo(expected) != 0) {
                    this.errln("#" + row + ": " + testTitles[n] + " on " + loc + ": -> [" + buf + "] (expected '" + expected + "'!)");
                }
                if (buf1.compareTo(expected) == 0) continue;
                this.errln("#" + row + ": " + testTitles[n] + " on ULocale object " + loc + ": -> [" + buf1 + "] (expected '" + expected + "'!)");
            }
        }
    }

    public void TestObsoleteNames() {
        String buff;
        String[][] tests = new String[][]{{"eng_USA", "eng", "en", "USA", "US"}, {"kok", "kok", "kok", "", ""}, {"in", "ind", "in", "", ""}, {"id", "ind", "id", "", ""}, {"sh", "srp", "sh", "", ""}, {"zz_FX", "", "zz", "FXX", "FX"}, {"zz_RO", "", "zz", "ROU", "RO"}, {"zz_TP", "", "zz", "TMP", "TP"}, {"zz_TL", "", "zz", "TLS", "TL"}, {"zz_ZR", "", "zz", "ZAR", "ZR"}, {"zz_FXX", "", "zz", "FXX", "FX"}, {"zz_ROM", "", "zz", "ROU", "RO"}, {"zz_ROU", "", "zz", "ROU", "RO"}, {"zz_ZAR", "", "zz", "ZAR", "ZR"}, {"zz_TMP", "", "zz", "TMP", "TP"}, {"zz_TLS", "", "zz", "TLS", "TL"}, {"mlt_PSE", "mlt", "mt", "PSE", "PS"}, {"iw", "heb", "iw", "", ""}, {"ji", "yid", "ji", "", ""}, {"jw", "jaw", "jw", "", ""}, {"sh", "srp", "sh", "", ""}, {"", "", "", "", ""}};
        for (int i = 0; i < tests.length; ++i) {
            String locale = tests[i][0];
            this.logln("** Testing : " + locale);
            ULocale uloc = new ULocale(locale);
            String buff2 = ULocale.getISO3Language((String)locale);
            if (buff2.compareTo(tests[i][1]) != 0) {
                this.errln("FAIL: ULocale.getISO3Language(" + locale + ")==" + buff2 + ",\t expected " + tests[i][1]);
            } else {
                this.logln("   ULocale.getISO3Language(" + locale + ")==" + buff2);
            }
            String buff1 = uloc.getISO3Language();
            if (buff1.compareTo(tests[i][1]) != 0) {
                this.errln("FAIL: ULocale.getISO3Language(" + locale + ")==" + buff2 + ",\t expected " + tests[i][1]);
            } else {
                this.logln("   ULocale.getISO3Language(" + locale + ")==" + buff2);
            }
            buff2 = ULocale.getLanguage((String)locale);
            if (buff2.compareTo(tests[i][2]) != 0) {
                this.errln("FAIL: ULocale.getLanguage(" + locale + ")==" + buff2 + ",\t expected " + tests[i][2]);
            } else {
                this.logln("   ULocale.getLanguage(" + locale + ")==" + buff2);
            }
            buff2 = ULocale.getISO3Country((String)locale);
            if (buff2.compareTo(tests[i][3]) != 0) {
                this.errln("FAIL: ULocale.getISO3Country(" + locale + ")==" + buff2 + ",\t expected " + tests[i][3]);
            } else {
                this.logln("   ULocale.getISO3Country(" + locale + ")==" + buff2);
            }
            buff1 = uloc.getISO3Country();
            if (buff1.compareTo(tests[i][3]) != 0) {
                this.errln("FAIL: ULocale.getISO3Country(" + locale + ")==" + buff2 + ",\t expected " + tests[i][3]);
            } else {
                this.logln("   ULocale.getISO3Country(" + locale + ")==" + buff2);
            }
            buff2 = ULocale.getCountry((String)locale);
            if (buff2.compareTo(tests[i][4]) != 0) {
                this.errln("FAIL: ULocale.getCountry(" + locale + ")==" + buff2 + ",\t expected " + tests[i][4]);
                continue;
            }
            this.logln("   ULocale.getCountry(" + locale + ")==" + buff2);
        }
        if (ULocale.getLanguage((String)"iw_IL").compareTo(ULocale.getLanguage((String)"he_IL")) == 0) {
            this.errln("he,iw ULocale.getLanguage mismatch");
        }
        if ((buff = ULocale.getLanguage((String)"kok_IN")).compareTo("kok") != 0) {
            this.errln("ULocale.getLanguage(\"kok\") failed. Expected: kok Got: " + buff);
        }
    }

    public void TestCanonicalization() {
        String[][] testCases = new String[][]{{"ca_ES_PREEURO", "ca_ES_PREEURO", "ca_ES@currency=ESP"}, {"de_AT_PREEURO", "de_AT_PREEURO", "de_AT@currency=ATS"}, {"de_DE_PREEURO", "de_DE_PREEURO", "de_DE@currency=DEM"}, {"de_LU_PREEURO", "de_LU_PREEURO", "de_LU@currency=EUR"}, {"el_GR_PREEURO", "el_GR_PREEURO", "el_GR@currency=GRD"}, {"en_BE_PREEURO", "en_BE_PREEURO", "en_BE@currency=BEF"}, {"en_IE_PREEURO", "en_IE_PREEURO", "en_IE@currency=IEP"}, {"es_ES_PREEURO", "es_ES_PREEURO", "es_ES@currency=ESP"}, {"eu_ES_PREEURO", "eu_ES_PREEURO", "eu_ES@currency=ESP"}, {"fi_FI_PREEURO", "fi_FI_PREEURO", "fi_FI@currency=FIM"}, {"fr_BE_PREEURO", "fr_BE_PREEURO", "fr_BE@currency=BEF"}, {"fr_FR_PREEURO", "fr_FR_PREEURO", "fr_FR@currency=FRF"}, {"fr_LU_PREEURO", "fr_LU_PREEURO", "fr_LU@currency=LUF"}, {"ga_IE_PREEURO", "ga_IE_PREEURO", "ga_IE@currency=IEP"}, {"gl_ES_PREEURO", "gl_ES_PREEURO", "gl_ES@currency=ESP"}, {"it_IT_PREEURO", "it_IT_PREEURO", "it_IT@currency=ITL"}, {"nl_BE_PREEURO", "nl_BE_PREEURO", "nl_BE@currency=BEF"}, {"nl_NL_PREEURO", "nl_NL_PREEURO", "nl_NL@currency=NLG"}, {"pt_PT_PREEURO", "pt_PT_PREEURO", "pt_PT@currency=PTE"}, {"de__PHONEBOOK", "de__PHONEBOOK", "de@collation=phonebook"}, {"en_GB_EURO", "en_GB_EURO", "en_GB@currency=EUR"}, {"en_GB@EURO", null, "en_GB@currency=EUR"}, {"es__TRADITIONAL", "es__TRADITIONAL", "es@collation=traditional"}, {"hi__DIRECT", "hi__DIRECT", "hi@collation=direct"}, {"ja_JP_TRADITIONAL", "ja_JP_TRADITIONAL", "ja_JP@calendar=japanese"}, {"th_TH_TRADITIONAL", "th_TH_TRADITIONAL", "th_TH@calendar=buddhist"}, {"zh_TW_STROKE", "zh_TW_STROKE", "zh_TW@collation=stroke"}, {"zh__PINYIN", "zh__PINYIN", "zh@collation=pinyin"}, {"zh@collation=pinyin", "zh@collation=pinyin", "zh@collation=pinyin"}, {"zh_CN@collation=pinyin", "zh_CN@collation=pinyin", "zh_CN@collation=pinyin"}, {"zh_CN_CA@collation=pinyin", "zh_CN_CA@collation=pinyin", "zh_CN_CA@collation=pinyin"}, {"en_US_POSIX", "en_US_POSIX", "en_US_POSIX"}, {"hy_AM_REVISED", "hy_AM_REVISED", "hy_AM_REVISED"}, {"no_NO_NY", "no_NO_NY", "no_NO_NY"}, {"no@ny", null, "no__NY"}, {"no-no.utf32@B", null, "no_NO_B"}, {"qz-qz@Euro", null, "qz_QZ@currency=EUR"}, {"en-BOONT", "en_BOONT", "en__BOONT"}, {"de-1901", "de_1901", "de__1901"}, {"de-1906", "de_1906", "de__1906"}, {"sr-SP-Cyrl", "sr_SP_CYRL", "sr_Cyrl_CS"}, {"sr-SP-Latn", "sr_SP_LATN", "sr_Latn_CS"}, {"sr_YU_CYRILLIC", "sr_YU_CYRILLIC", "sr_Cyrl_CS"}, {"uz-UZ-Cyrl", "uz_UZ_CYRL", "uz_Cyrl_UZ"}, {"uz-UZ-Latn", "uz_UZ_LATN", "uz_Latn_UZ"}, {"zh-CHS", "zh_CHS", "zh_Hans"}, {"zh-CHT", "zh_CHT", "zh_Hant"}, {"mr.utf8", null, "mr"}, {"de-tv.koi8r", null, "de_TV"}, {"x-piglatin_ML.MBE", null, "x-piglatin_ML"}, {"i-cherokee_US.utf7", null, "i-cherokee_US"}, {"x-filfli_MT_FILFLA.gb-18030", null, "x-filfli_MT_FILFLA"}, {"no-no-ny.utf8@B", null, "no_NO_NY_B"}, {"en_Hant_IL_VALLEY_GIRL@currency=EUR;calendar=Japanese;", "en_Hant_IL_VALLEY_GIRL@calendar=Japanese;currency=EUR", "en_Hant_IL_VALLEY_GIRL@calendar=Japanese;currency=EUR"}, {"en_Hant_IL_VALLEY_GIRL@calendar=Japanese;currency=EUR", "en_Hant_IL_VALLEY_GIRL@calendar=Japanese;currency=EUR", "en_Hant_IL_VALLEY_GIRL@calendar=Japanese;currency=EUR"}, {"no-Hant-GB_NY@currency=$$$", "no_Hant_GB_NY@currency=$$$", "no_Hant_GB_NY@currency=$$$"}, {"root@kw=foo", "root@kw=foo", "root@kw=foo"}, {"@calendar=gregorian", "@calendar=gregorian", "@calendar=gregorian"}};
        for (int i = 0; i < testCases.length; ++i) {
            String[] testCase = testCases[i];
            String source = testCase[0];
            String level1Expected = testCase[1];
            String level2Expected = testCase[2];
            if (level1Expected != null) {
                String level1 = ULocale.getName((String)source);
                if (!level1.equals(level1Expected)) {
                    this.errln("ULocale.getName error for: '" + source + "' expected: '" + level1Expected + "' but got: '" + level1 + "'");
                } else {
                    this.logln("Ulocale.getName for: '" + source + "' returned: '" + level1 + "'");
                }
            } else {
                this.logln("ULocale.getName skipped: '" + source + "'");
            }
            if (level2Expected != null) {
                String level2 = ULocale.canonicalize((String)source);
                if (!level2.equals(level2Expected)) {
                    this.errln("ULocale.getName error for: '" + source + "' expected: '" + level2Expected + "' but got: '" + level2 + "'");
                    continue;
                }
                this.logln("Ulocale.canonicalize for: '" + source + "' returned: '" + level2 + "'");
                continue;
            }
            this.logln("ULocale.canonicalize skipped: '" + source + "'");
        }
    }

    public void TestGetAvailable() {
        ULocale[] locales = ULocale.getAvailableLocales();
        if (locales.length < 10) {
            this.errln("Did not get the correct result from getAvailableLocales");
        }
        if (!locales[locales.length - 1].equals((Object)"zh_Hant_TW")) {
            this.errln("Did not get the expected result");
        }
    }

    public void TestDisplayNames() {
        ULocale[] locales = ULocale.getAvailableLocales();
        for (int i = 0; i < locales.length; ++i) {
            ULocale dl;
            ULocale l = locales[i];
            String name = l.getDisplayName();
            this.logln(l + " --> " + name + ", " + l.getDisplayName(ULocale.GERMAN) + ", " + l.getDisplayName(ULocale.FRANCE));
            String language = l.getDisplayLanguage();
            String script = l.getDisplayScript();
            String country = l.getDisplayCountry();
            String variant = l.getDisplayVariant();
            this.checkName(name, language, script, country, variant);
            for (int j = 0; j < locales.length && this.checkName(name = l.getDisplayName(dl = locales[j]), language = l.getDisplayLanguage(dl), script = l.getDisplayScript(dl), country = l.getDisplayCountry(dl), variant = l.getDisplayVariant(dl)); ++j) {
            }
        }
        locales = new ULocale[]{ULocale.US, ULocale.GERMANY, ULocale.FRANCE};
        String[] names = new String[]{"Chinese (China)", "Chinesisch (China)", "chinois (Chine)"};
        ULocale locale = new ULocale("zh_CN");
        for (int i = 0; i < locales.length; ++i) {
            String name = locale.getDisplayName(locales[i]);
            if (names[i].equals(name)) continue;
            this.errln("expected '" + names[i] + "' but got '" + name + "'");
        }
    }

    private boolean checkName(String name, String language, String script, String country, String variant) {
        if (language.length() > 0 && name.indexOf(language) == -1) {
            this.errln("name '" + name + "' does not contain language '" + language + "'");
            return false;
        }
        if (script.length() > 0 && name.indexOf(script) == -1) {
            this.errln("name '" + name + "' does not contain script '" + script + "'");
            return false;
        }
        if (country.length() > 0 && name.indexOf(country) == -1) {
            this.errln("name '" + name + "' does not contain country '" + country + "'");
            return false;
        }
        if (variant.length() > 0 && name.indexOf(variant) == -1) {
            this.errln("name '" + name + "' does not contain variant '" + variant + "'");
            return false;
        }
        return true;
    }

    public void TestCoverage() {
        ULocale loc5;
        ULocale loc3;
        ULocale loc4;
        ULocale loc1;
        ULocale loc2;
        String variant;
        String country;
        String script;
        String language;
        String name;
        String testLocale;
        String localeID = "zh_CN";
        this.logln("Covering APIs with signature displayXXX(String, String)");
        for (int i = 0; i < 9; ++i) {
            testLocale = rawData2[4][i];
            this.logln("Testing " + testLocale + ".....");
            name = ULocale.getDisplayName((String)localeID, (String)testLocale);
            language = ULocale.getDisplayLanguage((String)localeID, (String)testLocale);
            script = ULocale.getDisplayScript((String)localeID, (String)testLocale);
            country = ULocale.getDisplayCountry((String)localeID, (String)testLocale);
            variant = ULocale.getDisplayVariant((String)localeID, (String)testLocale);
            if (!this.checkName(name, language, script, country, variant)) break;
        }
        this.logln("Covering APIs with signature displayXXX(String, ULocale)\n");
        for (int j = 0; j < 9; ++j) {
            testLocale = rawData2[4][j];
            ULocale loc = new ULocale(testLocale);
            this.logln("Testing " + testLocale + ".....");
            name = ULocale.getDisplayName((String)localeID, (ULocale)loc);
            language = ULocale.getDisplayLanguage((String)localeID, (ULocale)loc);
            script = ULocale.getDisplayScript((String)localeID, (ULocale)loc);
            country = ULocale.getDisplayCountry((String)localeID, (ULocale)loc);
            variant = ULocale.getDisplayVariant((String)localeID, (ULocale)loc);
            if (!this.checkName(name, language, script, country, variant)) break;
        }
        if (!(loc2 = new ULocale("en", "US", "BROOKLYN")).equals((Object)(loc1 = new ULocale("en_US_BROOKLYN")))) {
            this.errln("ULocale.ULocale(String a, String b, String c)");
        }
        if (!(loc4 = new ULocale("en", "US")).equals((Object)(loc3 = new ULocale("en_US")))) {
            this.errln("ULocale.ULocale(String a, String b)");
        }
        if (!(loc5 = (ULocale)loc4.clone()).equals((Object)loc4)) {
            this.errln("ULocale.clone should get the same ULocale");
        }
        ULocale.getISOCountries();
    }

    public void TestBamBm() {
        String[] isoLanguages = ULocale.getISOLanguages();
        for (int i = 0; i < isoLanguages.length; ++i) {
            if ("bam".equals(isoLanguages[i])) {
                this.errln("found bam");
            }
            if (i <= 0 || isoLanguages[i].compareTo(isoLanguages[i - 1]) > 0) continue;
            this.errln("language list out of order: '" + isoLanguages[i] + " <= " + isoLanguages[i - 1]);
        }
    }

    public void TestDisplayKeyword() {
        this.initHashtable();
        String[] data = new String[]{"en_US@collation=direct;calendar=islamic-civil", "zh_Hans@collation=pinyin;calendar=chinese", "foo_Bar_BAZ@collation=traditional;calendar=buddhist"};
        for (int i = 0; i < data.length; ++i) {
            String localeID = data[i];
            this.logln("");
            this.logln("Testing locale " + localeID + " ...");
            ULocale loc = new ULocale(localeID);
            Iterator it = loc.getKeywords();
            Iterator it2 = ULocale.getKeywords((String)localeID);
            while (it.hasNext()) {
                String s2;
                String key = (String)it.next();
                String s0 = ULocale.getDisplayKeyword((String)key);
                String s1 = ULocale.getDisplayKeyword((String)key, (ULocale)ULocale.US);
                if (!s1.equals(s2 = ULocale.getDisplayKeyword((String)key, (String)"en_US"))) {
                    this.errln("FAIL: one of the getDisplayKeyword methods failed.");
                }
                if (!s1.equals(h[0].get(key))) {
                    this.warnln("Locale " + localeID + " getDisplayKeyword for key: " + key + " in English expected \"" + h[0].get(key) + "\" saw \"" + s1 + "\" instead");
                } else {
                    this.logln("OK: getDisplayKeyword for key: " + key + " in English got " + s1);
                }
                s1 = ULocale.getDisplayKeyword((String)key, (ULocale)ULocale.CHINA);
                s2 = ULocale.getDisplayKeyword((String)key, (String)"zh_Hans");
                if (!s1.equals(s2)) {
                    this.errln("one of the getDisplayKeyword methods failed.");
                }
                if (!s1.equals(h[1].get(key))) {
                    this.warnln("Locale " + localeID + " getDisplayKeyword for key: " + key + " in Chinese expected \"" + h[1].get(key) + "\" saw \"" + s1 + "\" instead");
                } else {
                    this.logln("OK: getDisplayKeyword for key: " + key + " in Chinese got " + s1);
                }
                String type = loc.getKeywordValue(key);
                String ss0 = loc.getDisplayKeywordValue(key);
                String ss1 = loc.getDisplayKeywordValue(key, ULocale.US);
                String ss2 = ULocale.getDisplayKeywordValue((String)localeID, (String)key, (String)"en_US");
                String ss3 = ULocale.getDisplayKeywordValue((String)localeID, (String)key, (ULocale)ULocale.US);
                if (!ss1.equals(ss2) || !ss1.equals(ss3)) {
                    this.errln("FAIL: one of the getDisplayKeywordValue methods failed.");
                }
                if (!ss1.equals(h[0].get(type))) {
                    this.warnln(" Locale " + localeID + " getDisplayKeywordValue for key: " + key + " in English expected \"" + h[0].get(type) + "\" saw \"" + ss1 + "\" instead");
                } else {
                    this.logln("OK: getDisplayKeywordValue for key: " + key + " in English got " + ss1);
                }
                ss0 = loc.getDisplayKeywordValue(key);
                ss1 = loc.getDisplayKeywordValue(key, ULocale.CHINA);
                ss2 = ULocale.getDisplayKeywordValue((String)localeID, (String)key, (String)"zh_Hans");
                ss3 = ULocale.getDisplayKeywordValue((String)localeID, (String)key, (ULocale)ULocale.CHINA);
                if (!ss1.equals(ss2) || !ss1.equals(ss3)) {
                    this.warnln("one of the getDisplayKeywordValue methods failed.");
                }
                if (!ss1.equals(h[1].get(type))) {
                    this.warnln("Locale " + localeID + " getDisplayKeywordValue for key: " + key + " in Chinese expected \"" + h[1].get(type) + "\" saw \"" + ss1 + "\" instead");
                    continue;
                }
                this.logln("OK: getDisplayKeywordValue for key: " + key + " in Chinese got " + ss1);
            }
        }
    }

    private void initHashtable() {
        ULocaleTest.h[0] = new Hashtable();
        ULocaleTest.h[1] = new Hashtable();
        h[0].put("collation", "Collation");
        h[0].put("calendar", "Calendar");
        h[0].put("currency", "Currency");
        h[0].put("phonebook", "Phonebook Order");
        h[0].put("pinyin", "Pinyin Order");
        h[0].put("traditional", "Traditional");
        h[0].put("stroke", "Stroke Order");
        h[0].put("direct", "Direct Order");
        h[0].put("japanese", "Japanese Calendar");
        h[0].put("buddhist", "Buddhist Calendar");
        h[0].put("islamic", "Islamic Calendar");
        h[0].put("islamic-civil", "Islamic-Civil Calendar");
        h[0].put("hebrew", "Hebrew Calendar");
        h[0].put("chinese", "Chinese Calendar");
        h[0].put("gregorian", "Gregorian Calendar");
        h[1].put("collation", "\u5bf9\u7167");
        h[1].put("calendar", "\u65e5\u5386");
        h[1].put("currency", "\u8d27\u5e01");
        h[1].put("direct", "\u987a\u5e8f");
        h[1].put("phonebook", "\u7535\u8bdd\u7c3f\u987a\u5e8f");
        h[1].put("pinyin", "\u62fc\u97f3\u987a\u5e8f");
        h[1].put("stroke", "\u7b14\u5212\u987a\u5e8f");
        h[1].put("traditional", "\u4f20\u7edf\u5386\u6cd5");
        h[1].put("japanese", "\u65e5\u672c\u65e5\u5386");
        h[1].put("buddhist", "\u4f5b\u6559\u65e5\u5386");
        h[1].put("islamic", "\u4f0a\u65af\u5170\u65e5\u5386");
        h[1].put("islamic-civil", "\u4f0a\u65af\u5170\u5e0c\u5409\u6765\u5386");
        h[1].put("hebrew", "\u5e0c\u4f2f\u6765\u65e5\u5386");
        h[1].put("chinese", "\u519c\u5386");
        h[1].put("gregorian", "\u516c\u5386");
    }

    public void TestAcceptLanguage() {
        for (int i = 0; i < ACCEPT_LANGUAGE_HTTP.length; ++i) {
            Boolean expectBoolean = new Boolean(ACCEPT_LANGUAGE_TESTS[i][1]);
            String expectLocale = ACCEPT_LANGUAGE_TESTS[i][0];
            this.logln("#" + i + ": expecting: " + expectLocale + " (" + expectBoolean + ")");
            boolean[] r = new boolean[]{false};
            ULocale n = ULocale.acceptLanguage((String)ACCEPT_LANGUAGE_HTTP[i], (boolean[])r);
            if (n == null && expectLocale != null) {
                this.errln("result was null! line #" + i);
                continue;
            }
            if (n == null && expectLocale == null || n.toString().equals(expectLocale)) {
                this.logln(" locale: OK.");
            } else {
                this.errln("expected " + expectLocale + " but got " + n.toString());
            }
            if (expectBoolean.equals(new Boolean(r[0]))) {
                this.logln(" bool: OK.");
                continue;
            }
            this.errln("bool: not OK, was " + new Boolean(r[0]).toString() + " expected " + expectBoolean.toString());
        }
    }

    private ULocale[] StringToULocaleArray(String acceptLanguageList) {
        class ULocaleAcceptLanguageQ
        implements Comparable {
            private double q;
            private double serial;

            public ULocaleAcceptLanguageQ(double theq, int theserial) {
                this.q = theq;
                this.serial = theserial;
            }

            public int compareTo(Object o) {
                ULocaleAcceptLanguageQ other = (ULocaleAcceptLanguageQ)o;
                if (this.q > other.q) {
                    return -1;
                }
                if (this.q < other.q) {
                    return 1;
                }
                if (this.serial < other.serial) {
                    return -1;
                }
                if (this.serial > other.serial) {
                    return 1;
                }
                return 0;
            }
        }
        TreeMap<ULocaleAcceptLanguageQ, ULocale> map = new TreeMap<ULocaleAcceptLanguageQ, ULocale>();
        int l = acceptLanguageList.length();
        int last = -1;
        for (int n = 0; n < l; ++n) {
            int itemEnd = acceptLanguageList.indexOf(44, n);
            if (itemEnd == -1) {
                itemEnd = l;
            }
            int paramEnd = acceptLanguageList.indexOf(59, n);
            double q = 1.0;
            if (paramEnd != -1 && paramEnd < itemEnd) {
                int t = paramEnd + 1;
                while (Character.isSpace(acceptLanguageList.charAt(t))) {
                    ++t;
                }
                if (acceptLanguageList.charAt(t) == 'q') {
                    ++t;
                }
                while (Character.isSpace(acceptLanguageList.charAt(t))) {
                    ++t;
                }
                if (acceptLanguageList.charAt(t) == '=') {
                    ++t;
                }
                while (Character.isSpace(acceptLanguageList.charAt(t))) {
                    ++t;
                }
                try {
                    String val = acceptLanguageList.substring(t, itemEnd).trim();
                    q = Double.parseDouble(val);
                }
                catch (NumberFormatException nfe) {
                    q = 1.0;
                }
            } else {
                q = 1.0;
                paramEnd = itemEnd;
            }
            String loc = acceptLanguageList.substring(n, paramEnd).trim();
            int serial = map.size();
            ULocaleAcceptLanguageQ entry = new ULocaleAcceptLanguageQ(q, serial);
            map.put(entry, new ULocale(ULocale.canonicalize((String)loc)));
            n = itemEnd;
        }
        ULocale[] acceptList = map.values().toArray(new ULocale[map.size()]);
        return acceptList;
    }

    public void TestAcceptLanguage2() {
        for (int i = 0; i < ACCEPT_LANGUAGE_HTTP.length; ++i) {
            Boolean expectBoolean = new Boolean(ACCEPT_LANGUAGE_TESTS[i][1]);
            String expectLocale = ACCEPT_LANGUAGE_TESTS[i][0];
            this.logln("#" + i + ": expecting: " + expectLocale + " (" + expectBoolean + ")");
            boolean[] r = new boolean[]{false};
            ULocale n = ULocale.acceptLanguage((ULocale[])this.StringToULocaleArray(ACCEPT_LANGUAGE_HTTP[i]), (boolean[])r);
            if (n == null && expectLocale != null) {
                this.errln("result was null! line #" + i);
                continue;
            }
            if (n == null && expectLocale == null || n.toString().equals(expectLocale)) {
                this.logln(" locale: OK.");
            } else {
                this.errln("expected " + expectLocale + " but got " + n.toString());
            }
            if (expectBoolean.equals(new Boolean(r[0]))) {
                this.logln(" bool: OK.");
                continue;
            }
            this.errln("bool: not OK, was " + new Boolean(r[0]).toString() + " expected " + expectBoolean.toString());
        }
    }

    public void TestJB3962() {
        ULocale loc = new ULocale("de_CH");
        String disp = loc.getDisplayName(ULocale.GERMAN);
        if (!disp.equals("Deutsch (Schweiz)")) {
            this.errln("Did not get the expected display name for de_CH locale. Got: " + ULocaleTest.prettify(disp));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static interface Registrar {
        public Object register(ULocale var1, Object var2);

        public boolean unregister(Object var1);
    }

    static interface Subobject {
        public Object get(Object var1);
    }

    static interface ServiceFacade {
        public Object create(ULocale var1);
    }
}

