/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.dev.test.util;

import com.ibm.icu.dev.test.util.BagFormatter;
import com.ibm.icu.dev.test.util.UnicodeLabel;
import com.ibm.icu.dev.test.util.UnicodeMap;
import com.ibm.icu.impl.CollectionUtilities;
import com.ibm.icu.impl.Utility;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.SymbolTable;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.text.UnicodeMatcher;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.text.UnicodeSetIterator;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class UnicodeProperty
extends UnicodeLabel {
    public static boolean DEBUG = false;
    public static String CHECK_NAME = "FC_NFKC_Closure";
    public static int CHECK_VALUE = 890;
    private String name;
    private String firstNameAlias = null;
    private int type;
    private Map valueToFirstValueAlias = null;
    public static final int UNKNOWN = 0;
    public static final int BINARY = 2;
    public static final int EXTENDED_BINARY = 3;
    public static final int ENUMERATED = 4;
    public static final int EXTENDED_ENUMERATED = 5;
    public static final int CATALOG = 6;
    public static final int EXTENDED_CATALOG = 7;
    public static final int MISC = 8;
    public static final int EXTENDED_MISC = 9;
    public static final int STRING = 10;
    public static final int EXTENDED_STRING = 11;
    public static final int NUMERIC = 12;
    public static final int EXTENDED_NUMERIC = 13;
    public static final int START_TYPE = 2;
    public static final int LIMIT_TYPE = 14;
    public static final int EXTENDED_MASK = 1;
    public static final int CORE_MASK = -2;
    public static final int BINARY_MASK = 12;
    public static final int STRING_MASK = 3072;
    public static final int STRING_OR_MISC_MASK = 3840;
    public static final int ENUMERATED_OR_CATALOG_MASK = 240;
    private static final String[] TYPE_NAMES = new String[]{"Unknown", "Unknown", "Binary", "Extended Binary", "Enumerated", "Extended Enumerated", "Catalog", "Extended Catalog", "Miscellaneous", "Extended Miscellaneous", "String", "Extended String", "Numeric", "Extended Numeric"};
    private int maxValueWidth = -1;
    private int maxFirstValueAliasWidth = -1;
    private UnicodeMap unicodeMap = null;
    public static final String UNUSED = "??";
    public static final Comparator PROPERTY_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            return UnicodeProperty.compareNames((String)o1, (String)o2);
        }
    };

    public static String getTypeName(int propType) {
        return TYPE_NAMES[propType];
    }

    public final String getName() {
        return this.name;
    }

    public final int getType() {
        return this.type;
    }

    public final boolean isType(int mask) {
        return (1 << this.type & mask) != 0;
    }

    protected final void setName(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Name must not be null");
        }
        this.name = string;
    }

    protected final void setType(int i) {
        this.type = i;
    }

    public String getVersion() {
        return this._getVersion();
    }

    public String getValue(int codepoint) {
        if (DEBUG && CHECK_VALUE == codepoint && CHECK_NAME.equals(this.getName())) {
            String value = this._getValue(codepoint);
            System.out.println(this.getName() + "(" + Utility.hex((long)codepoint) + "):" + (this.getType() == 10 ? Utility.hex((String)value) : value));
            return value;
        }
        return this._getValue(codepoint);
    }

    public List getNameAliases(List result) {
        if (result == null) {
            result = new ArrayList(1);
        }
        return this._getNameAliases(result);
    }

    public List getValueAliases(String valueAlias, List result) {
        if (result == null) {
            result = new ArrayList(1);
        }
        if (!(result = this._getValueAliases(valueAlias, result)).contains(valueAlias)) {
            result = this._getValueAliases(valueAlias, result);
            throw new IllegalArgumentException("Internal error: " + this.getName() + " doesn't contain " + valueAlias + ": " + new BagFormatter().join(result));
        }
        return result;
    }

    public List getAvailableValues(List result) {
        if (result == null) {
            result = new ArrayList(1);
        }
        return this._getAvailableValues(result);
    }

    protected abstract String _getVersion();

    protected abstract String _getValue(int var1);

    protected abstract List _getNameAliases(List var1);

    protected abstract List _getValueAliases(String var1, List var2);

    protected abstract List _getAvailableValues(List var1);

    public final List getNameAliases() {
        return this.getNameAliases(null);
    }

    public final List getValueAliases(String valueAlias) {
        return this.getValueAliases(valueAlias, null);
    }

    public final List getAvailableValues() {
        return this.getAvailableValues(null);
    }

    public final String getValue(int codepoint, boolean getShortest) {
        String result = this.getValue(codepoint);
        if (this.type >= 8 || result == null || !getShortest) {
            return result;
        }
        return this.getFirstValueAlias(result);
    }

    public final String getFirstNameAlias() {
        if (this.firstNameAlias == null) {
            this.firstNameAlias = (String)this.getNameAliases().get(0);
        }
        return this.firstNameAlias;
    }

    public final String getFirstValueAlias(String value) {
        if (this.valueToFirstValueAlias == null) {
            this._getFirstValueAliasCache();
        }
        return (String)this.valueToFirstValueAlias.get(value);
    }

    private void _getFirstValueAliasCache() {
        this.maxValueWidth = 0;
        this.maxFirstValueAliasWidth = 0;
        this.valueToFirstValueAlias = new HashMap(1);
        Iterator it = this.getAvailableValues().iterator();
        while (it.hasNext()) {
            String value = (String)it.next();
            String first = (String)this.getValueAliases(value).get(0);
            if (first == null) {
                throw new IllegalArgumentException("Value not in value aliases: " + value);
            }
            if (DEBUG && CHECK_NAME.equals(this.getName())) {
                System.out.println("First Alias: " + this.getName() + ": " + value + " => " + first + new BagFormatter().join(this.getValueAliases(value)));
            }
            this.valueToFirstValueAlias.put(value, first);
            if (value.length() > this.maxValueWidth) {
                this.maxValueWidth = value.length();
            }
            if (first.length() <= this.maxFirstValueAliasWidth) continue;
            this.maxFirstValueAliasWidth = first.length();
        }
    }

    public int getMaxWidth(boolean getShortest) {
        if (this.maxValueWidth < 0) {
            this._getFirstValueAliasCache();
        }
        if (getShortest) {
            return this.maxFirstValueAliasWidth;
        }
        return this.maxValueWidth;
    }

    public final UnicodeSet getSet(String propertyValue) {
        return this.getSet(propertyValue, null);
    }

    public final UnicodeSet getSet(PatternMatcher matcher) {
        return this.getSet(matcher, null);
    }

    public final UnicodeSet getSet(String propertyValue, UnicodeSet result) {
        return this.getSet(new SimpleMatcher(propertyValue, this.isType(3840) ? null : PROPERTY_COMPARATOR), result);
    }

    public final UnicodeSet getSet(PatternMatcher matcher, UnicodeSet result) {
        if (result == null) {
            result = new UnicodeSet();
        }
        if (this.isType(3840)) {
            for (int i = 0; i <= 0x10FFFF; ++i) {
                String value = this.getValue(i);
                if (value == null || !matcher.matches(value)) continue;
                result.add(i);
            }
            return result;
        }
        ArrayList temp = new ArrayList(1);
        UnicodeMap um = this.getUnicodeMap_internal();
        Iterator it = um.getAvailableValues(null).iterator();
        block1: while (it.hasNext()) {
            String value = (String)it.next();
            temp.clear();
            Iterator it2 = this.getValueAliases(value, temp).iterator();
            while (it2.hasNext()) {
                String value2 = (String)it2.next();
                if (!matcher.matches(value2) && !matcher.matches(UnicodeProperty.toSkeleton(value2))) continue;
                um.getSet(value, result);
                continue block1;
            }
        }
        return result;
    }

    public static String getStack() {
        Exception e = new Exception();
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        pw.flush();
        return "Showing Stack with fake " + sw.getBuffer().toString();
    }

    public UnicodeMap getUnicodeMap() {
        return this.getUnicodeMap(false);
    }

    public UnicodeMap getUnicodeMap(boolean getShortest) {
        if (!getShortest) {
            return (UnicodeMap)this.getUnicodeMap_internal().cloneAsThawed();
        }
        UnicodeMap result = new UnicodeMap();
        for (int i = 0; i <= 0x10FFFF; ++i) {
            String value = this.getValue(i, true);
            result.put(i, value);
        }
        return result;
    }

    protected UnicodeMap getUnicodeMap_internal() {
        if (this.unicodeMap == null) {
            this.unicodeMap = this._getUnicodeMap();
        }
        return this.unicodeMap;
    }

    protected UnicodeMap _getUnicodeMap() {
        String value;
        int i;
        UnicodeMap result = new UnicodeMap();
        HashMap<String, String> myIntern = new HashMap<String, String>();
        for (i = 0; i <= 0x10FFFF; ++i) {
            value = this.getValue(i);
            String iValue = (String)myIntern.get(value);
            if (iValue == null) {
                iValue = value;
                myIntern.put(value, iValue);
            }
            result.put(i, iValue);
        }
        if (DEBUG) {
            for (i = 0; i <= 0x10FFFF; ++i) {
                String resultValue;
                value = this.getValue(i);
                if (value.equals(resultValue = (String)result.getValue(i))) continue;
                throw new RuntimeException("Value failure at: " + Utility.hex((long)i));
            }
        }
        if (DEBUG && CHECK_NAME.equals(this.getName())) {
            System.out.println(this.getName() + ":\t" + this.getClass().getName() + "\t" + this.getVersion());
            System.out.println(UnicodeProperty.getStack());
            System.out.println(result);
        }
        return result;
    }

    public static Collection addUnique(Object obj, Collection result) {
        if (obj != null && !result.contains(obj)) {
            result.add(obj);
        }
        return result;
    }

    public static boolean equalNames(String a, String b) {
        if (a == b) {
            return true;
        }
        if (a == null) {
            return false;
        }
        return UnicodeProperty.toSkeleton(a).equals(UnicodeProperty.toSkeleton(b));
    }

    public static int compareNames(String a, String b) {
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        return UnicodeProperty.toSkeleton(a).compareTo(UnicodeProperty.toSkeleton(b));
    }

    public static String toSkeleton(String source) {
        if (source == null) {
            return null;
        }
        StringBuffer skeletonBuffer = new StringBuffer();
        boolean gotOne = false;
        for (int i = 0; i < source.length(); ++i) {
            char ch = source.charAt(i);
            if (i > 0 && (ch == '_' || ch == ' ' || ch == '-')) {
                gotOne = true;
                continue;
            }
            char ch2 = Character.toLowerCase(ch);
            if (ch2 != ch) {
                gotOne = true;
                skeletonBuffer.append(ch2);
                continue;
            }
            skeletonBuffer.append(ch);
        }
        if (!gotOne) {
            return source;
        }
        return skeletonBuffer.toString();
    }

    public static String toNameSkeleton(String source) {
        if (source == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < source.length(); ++i) {
            char ch = source.charAt(i);
            if ('0' <= ch && ch <= '9' || 'A' <= ch && ch <= 'Z' || ch == '<' || ch == '>') {
                result.append(ch);
                continue;
            }
            if (ch == ' ') continue;
            if (ch == '-') {
                if (0 != i && i != source.length() - 1 && source.charAt(i - 1) != ' ' && source.charAt(i + 1) != ' ' && (i != source.length() - 2 || source.charAt(i - 1) != 'O' || source.charAt(i + 1) != 'E')) continue;
                System.out.println("****** EXCEPTION " + source);
                result.append(ch);
                continue;
            }
            throw new IllegalArgumentException("Illegal Name Char: U+" + Utility.hex((char)ch) + ", " + ch);
        }
        return result.toString();
    }

    public static String regularize(String source, boolean titlecaseStart) {
        if (source == null) {
            return source;
        }
        StringBuffer result = new StringBuffer();
        int lastCat = -1;
        boolean haveFirstCased = true;
        for (int i = 0; i < source.length(); ++i) {
            char c = source.charAt(i);
            if (c == ' ' || c == '-' || c == '_') {
                c = '_';
                haveFirstCased = true;
            }
            if (c == '=') {
                haveFirstCased = true;
            }
            int cat = Character.getType(c);
            if (lastCat == 2 && cat == 1) {
                result.append('_');
            }
            if (haveFirstCased && (cat == 2 || cat == 3 || cat == 1)) {
                if (titlecaseStart) {
                    c = Character.toUpperCase(c);
                }
                haveFirstCased = false;
            }
            result.append(c);
            lastCat = cat;
        }
        return result.toString();
    }

    public static final boolean equals(int codepoint, String other) {
        if (other.length() == 1) {
            return codepoint == other.charAt(0);
        }
        if (other.length() == 2) {
            return other.equals(UTF16.valueOf((int)codepoint));
        }
        return false;
    }

    public static void addAll(UnicodeSetIterator source, UnicodeSet result) {
        while (source.nextRange()) {
            if (source.codepoint == UnicodeSetIterator.IS_STRING) {
                result.add(source.string);
                continue;
            }
            result.add(source.codepoint, source.codepointEnd);
        }
    }

    public static Collection addAllUnique(Collection source, Collection result) {
        Iterator it = source.iterator();
        while (it.hasNext()) {
            UnicodeProperty.addUnique(it.next(), result);
        }
        return result;
    }

    public static Collection addAllUnique(Object[] source, Collection result) {
        for (int i = 0; i < source.length; ++i) {
            UnicodeProperty.addUnique(source[i], result);
        }
        return result;
    }

    public static class UnicodeMapProperty
    extends BaseProperty {
        protected UnicodeMap unicodeMap;

        public UnicodeMapProperty set(UnicodeMap map) {
            this.unicodeMap = map;
            return this;
        }

        protected String _getValue(int codepoint) {
            return (String)this.unicodeMap.getValue(codepoint);
        }

        protected List _getAvailableValues(List result) {
            return (List)this.unicodeMap.getAvailableValues(result);
        }
    }

    public static abstract class SimpleProperty
    extends BaseProperty {
        List values;

        public SimpleProperty addName(String alias) {
            this.propertyAliases.add(alias);
            return this;
        }

        public SimpleProperty setValues(String valueAlias) {
            this._addToValues(valueAlias, null);
            return this;
        }

        public SimpleProperty setValues(String[] valueAliases, String[] alternateValueAliases) {
            for (int i = 0; i < valueAliases.length; ++i) {
                if (valueAliases[i].equals(UnicodeProperty.UNUSED)) continue;
                this._addToValues(valueAliases[i], alternateValueAliases != null ? alternateValueAliases[i] : null);
            }
            return this;
        }

        public SimpleProperty setValues(List valueAliases) {
            this.values = new ArrayList(valueAliases);
            Iterator it = this.values.iterator();
            while (it.hasNext()) {
                this._addToValues((String)it.next(), null);
            }
            return this;
        }

        public List _getAvailableValues(List result) {
            if (this.values == null) {
                this._fillValues();
            }
            result.addAll(this.values);
            return result;
        }

        protected void _fillValues() {
            List newvalues = (List)this.getUnicodeMap_internal().getAvailableValues(new ArrayList());
            Iterator it = newvalues.iterator();
            while (it.hasNext()) {
                this._addToValues((String)it.next(), null);
            }
        }

        private void _addToValues(String item, String alias) {
            if (this.values == null) {
                this.values = new ArrayList(1);
            }
            if (this.toValueAliases == null) {
                this._fixValueAliases();
            }
            SimpleProperty.addUnique(item, this.values);
            this._ensureValueInAliases(item);
            this.addValueAlias(item, alias, true);
        }
    }

    public static abstract class BaseProperty
    extends UnicodeProperty {
        protected List propertyAliases = new ArrayList(1);
        protected Map toValueAliases;
        protected String version;

        public BaseProperty setMain(String alias, String shortAlias, int propertyType, String version) {
            this.setName(alias);
            this.setType(propertyType);
            this.propertyAliases.add(shortAlias);
            this.propertyAliases.add(alias);
            this.version = version;
            return this;
        }

        public String _getVersion() {
            return this.version;
        }

        public List _getNameAliases(List result) {
            BaseProperty.addAllUnique(this.propertyAliases, (Collection)result);
            return result;
        }

        public BaseProperty addValueAliases(String[][] valueAndAlternates, boolean errorIfCant) {
            if (this.toValueAliases == null) {
                this._fixValueAliases();
            }
            for (int i = 0; i < valueAndAlternates.length; ++i) {
                for (int j = 1; j < valueAndAlternates[0].length; ++j) {
                    this.addValueAlias(valueAndAlternates[i][0], valueAndAlternates[i][j], errorIfCant);
                }
            }
            return this;
        }

        public void addValueAlias(String value, String valueAlias, boolean errorIfCant) {
            List result = (List)this.toValueAliases.get(value);
            if (result == null && !errorIfCant) {
                return;
            }
            BaseProperty.addUnique(value, result);
            BaseProperty.addUnique(valueAlias, result);
        }

        protected List _getValueAliases(String valueAlias, List result) {
            List a;
            if (this.toValueAliases == null) {
                this._fixValueAliases();
            }
            if ((a = (List)this.toValueAliases.get(valueAlias)) != null) {
                BaseProperty.addAllUnique(a, (Collection)result);
            }
            return result;
        }

        protected void _fixValueAliases() {
            if (this.toValueAliases == null) {
                this.toValueAliases = new HashMap(1);
            }
            Iterator it = this.getAvailableValues().iterator();
            while (it.hasNext()) {
                Object value = it.next();
                this._ensureValueInAliases(value);
            }
        }

        protected void _ensureValueInAliases(Object value) {
            ArrayList result = (ArrayList)this.toValueAliases.get(value);
            if (result == null) {
                result = new ArrayList(1);
                this.toValueAliases.put(value, result);
            }
            BaseProperty.addUnique(value, result);
        }

        public BaseProperty swapFirst2ValueAliases() {
            Iterator it = this.toValueAliases.keySet().iterator();
            while (it.hasNext()) {
                List list = (List)this.toValueAliases.get(it.next());
                if (list.size() < 2) continue;
                Object first = list.get(0);
                list.set(0, list.get(1));
                list.set(1, first);
            }
            return this;
        }
    }

    public static class RegexMatcher
    implements PatternMatcher {
        private Matcher matcher;

        public PatternMatcher set(String pattern) {
            this.matcher = Pattern.compile(pattern).matcher("");
            return this;
        }

        public boolean matches(Object value) {
            this.matcher.reset(value.toString());
            return this.matcher.matches();
        }
    }

    public static class SimpleMatcher
    implements PatternMatcher {
        Comparator comparator;
        String pattern;

        public SimpleMatcher(String pattern, Comparator comparator) {
            this.comparator = comparator;
            this.pattern = pattern;
        }

        public boolean matches(Object value) {
            if (this.comparator == null) {
                return this.pattern.equals(value);
            }
            return this.comparator.compare(this.pattern, value) == 0;
        }

        public PatternMatcher set(String pattern) {
            this.pattern = pattern;
            return this;
        }
    }

    public static class InversePatternMatcher
    extends CollectionUtilities.InverseMatcher
    implements PatternMatcher {
        PatternMatcher other;

        public PatternMatcher set(PatternMatcher toInverse) {
            this.other = toInverse;
            return this;
        }

        public boolean matches(Object value) {
            return !this.other.matches(value);
        }

        public PatternMatcher set(String pattern) {
            this.other.set(pattern);
            return this;
        }
    }

    public static interface PatternMatcher
    extends CollectionUtilities.ObjectMatcher {
        public PatternMatcher set(String var1);
    }

    public static class MapFilter
    extends StringFilter {
        private Map valueMap;

        public MapFilter(Map valueMap) {
            this.valueMap = valueMap;
        }

        public String remap(String original) {
            Object changed = this.valueMap.get(original);
            return changed == null ? original : (String)changed;
        }

        public Map getMap() {
            return this.valueMap;
        }
    }

    public static abstract class StringFilter
    implements Cloneable {
        public abstract String remap(String var1);

        public final List addUnique(Collection source, List result) {
            if (result == null) {
                result = new ArrayList(1);
            }
            Iterator it = source.iterator();
            while (it.hasNext()) {
                UnicodeProperty.addUnique(this.remap((String)it.next()), result);
            }
            return result;
        }
    }

    public static class FilteredProperty
    extends UnicodeProperty {
        private UnicodeProperty property;
        protected StringFilter filter;
        protected UnicodeSetIterator matchIterator = new UnicodeSetIterator(new UnicodeSet(0, 0x10FFFF));
        protected HashMap backmap;
        boolean allowValueAliasCollisions = false;
        List temp = new ArrayList(1);

        public FilteredProperty(UnicodeProperty property, StringFilter filter) {
            this.property = property;
            this.filter = filter;
        }

        public StringFilter getFilter() {
            return this.filter;
        }

        public UnicodeProperty setFilter(StringFilter filter) {
            this.filter = filter;
            return this;
        }

        public List _getAvailableValues(List result) {
            this.temp.clear();
            return this.filter.addUnique(this.property.getAvailableValues(this.temp), result);
        }

        public List _getNameAliases(List result) {
            this.temp.clear();
            return this.filter.addUnique(this.property.getNameAliases(this.temp), result);
        }

        public String _getValue(int codepoint) {
            return this.filter.remap(this.property.getValue(codepoint));
        }

        public List _getValueAliases(String valueAlias, List result) {
            if (this.backmap == null) {
                this.backmap = new HashMap(1);
                this.temp.clear();
                Iterator it = this.property.getAvailableValues(this.temp).iterator();
                while (it.hasNext()) {
                    String item = (String)it.next();
                    String mappedItem = this.filter.remap(item);
                    if (this.backmap.get(mappedItem) != null && !this.allowValueAliasCollisions) {
                        throw new IllegalArgumentException("Filter makes values collide! " + item + ", " + mappedItem);
                    }
                    this.backmap.put(mappedItem, item);
                }
            }
            valueAlias = (String)this.backmap.get(valueAlias);
            this.temp.clear();
            return this.filter.addUnique(this.property.getValueAliases(valueAlias, this.temp), result);
        }

        public String _getVersion() {
            return this.property.getVersion();
        }

        public boolean isAllowValueAliasCollisions() {
            return this.allowValueAliasCollisions;
        }

        public FilteredProperty setAllowValueAliasCollisions(boolean b) {
            this.allowValueAliasCollisions = b;
            return this;
        }
    }

    public static class Factory {
        static boolean DEBUG = false;
        Map canonicalNames = new TreeMap();
        Map skeletonNames = new TreeMap();
        Map propertyCache = new HashMap(1);
        InversePatternMatcher inverseMatcher = new InversePatternMatcher();

        public final Factory add(UnicodeProperty sp) {
            this.canonicalNames.put(sp.getName(), sp);
            List c = sp.getNameAliases(new ArrayList(1));
            Iterator it = c.iterator();
            while (it.hasNext()) {
                this.skeletonNames.put(UnicodeProperty.toSkeleton((String)it.next()), sp);
            }
            return this;
        }

        public final UnicodeProperty getProperty(String propertyAlias) {
            return (UnicodeProperty)this.skeletonNames.get(UnicodeProperty.toSkeleton(propertyAlias));
        }

        public final List getAvailableNames() {
            return this.getAvailableNames(null);
        }

        public final List getAvailableNames(List result) {
            if (result == null) {
                result = new ArrayList(1);
            }
            Iterator it = this.canonicalNames.keySet().iterator();
            while (it.hasNext()) {
                UnicodeProperty.addUnique(it.next(), result);
            }
            return result;
        }

        public final List getAvailableNames(int propertyTypeMask) {
            return this.getAvailableNames(propertyTypeMask, null);
        }

        public final List getAvailableNames(int propertyTypeMask, List result) {
            if (result == null) {
                result = new ArrayList(1);
            }
            Iterator it = this.canonicalNames.keySet().iterator();
            while (it.hasNext()) {
                String item = (String)it.next();
                UnicodeProperty property = this.getProperty(item);
                if (DEBUG) {
                    System.out.println("Properties: " + item + "," + property.getType());
                }
                if (!property.isType(propertyTypeMask)) continue;
                UnicodeProperty.addUnique(property.getName(), result);
            }
            return result;
        }

        public final UnicodeSet getSet(String propAndValue, PatternMatcher matcher, UnicodeSet result) {
            int equalPos = propAndValue.indexOf(61);
            String prop = propAndValue.substring(0, equalPos);
            String value = propAndValue.substring(equalPos + 1);
            boolean negative = false;
            if (prop.endsWith("!")) {
                prop = prop.substring(0, prop.length() - 1);
                negative = true;
            }
            prop = prop.trim();
            UnicodeProperty up = this.getProperty(prop);
            if (matcher == null) {
                matcher = new SimpleMatcher(value, up.isType(3840) ? null : PROPERTY_COMPARATOR);
            }
            if (negative) {
                this.inverseMatcher.set(matcher);
                matcher = this.inverseMatcher;
            }
            return up.getSet(matcher.set(value), result);
        }

        public final UnicodeSet getSet(String propAndValue, PatternMatcher matcher) {
            return this.getSet(propAndValue, matcher, null);
        }

        public final UnicodeSet getSet(String propAndValue) {
            return this.getSet(propAndValue, null, null);
        }

        public final SymbolTable getSymbolTable(String prefix) {
            return new PropertySymbolTable(prefix);
        }

        public final UnicodeSet.XSymbolTable getXSymbolTable() {
            return new MyXSymbolTable();
        }

        private class PropertySymbolTable
        implements SymbolTable {
            static final boolean DEBUG = false;
            private String prefix;
            RegexMatcher regexMatcher = new RegexMatcher();

            PropertySymbolTable(String prefix) {
                this.prefix = prefix;
            }

            public char[] lookup(String s) {
                int start = this.prefix.length();
                if (!s.regionMatches(true, 0, this.prefix, 0, start)) {
                    return null;
                }
                int pos = s.indexOf(58, start);
                if (pos < 0) {
                    throw new IllegalArgumentException("Internal Error: missing =: " + s + "\r\n");
                }
                UnicodeProperty prop = Factory.this.getProperty(s.substring(start, pos));
                if (prop == null) {
                    throw new IllegalArgumentException("Invalid Property in: " + s + "\r\nUse " + this.showSet(Factory.this.getAvailableNames()));
                }
                String value = s.substring(pos + 1);
                UnicodeSet set = value.startsWith("\u00ab") ? prop.getSet(this.regexMatcher.set(value.substring(1, value.length() - 1))) : prop.getSet(value);
                if (set.size() == 0) {
                    throw new IllegalArgumentException("Empty Property-Value in: " + s + "\r\nUse " + this.showSet(prop.getAvailableValues()));
                }
                return set.toPattern(true).toCharArray();
            }

            private String showSet(List list) {
                StringBuffer result = new StringBuffer("[");
                boolean first = true;
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    if (!first) {
                        result.append(", ");
                    } else {
                        first = false;
                    }
                    result.append(it.next().toString());
                }
                result.append("]");
                return result.toString();
            }

            public UnicodeMatcher lookupMatcher(int ch) {
                return null;
            }

            public String parseReference(String text, ParsePosition pos, int limit) {
                int start;
                int veryStart = start = pos.getIndex();
                if (!text.regionMatches(true, start, this.prefix, 0, this.prefix.length())) {
                    return null;
                }
                int i = this.getIdentifier(text, start += this.prefix.length(), limit);
                if (i == start) {
                    return null;
                }
                String prop = text.substring(start, i);
                String value = "true";
                if (i < limit && text.charAt(i) == ':') {
                    int j;
                    if (text.charAt(i + 1) == '\u00ab') {
                        j = text.indexOf(187, i + 2) + 1;
                        if (j <= 0) {
                            return null;
                        }
                    } else {
                        j = this.getIdentifier(text, i + 1, limit);
                    }
                    value = text.substring(i + 1, j);
                    i = j;
                }
                pos.setIndex(i);
                return this.prefix + prop + ":" + value;
            }

            private int getIdentifier(String text, int start, int limit) {
                int i;
                int cp = 0;
                for (i = start; i < limit && (UCharacter.isUnicodeIdentifierPart((int)(cp = UTF16.charAt((String)text, (int)i))) || cp == 46); i += UTF16.getCharCount((int)cp)) {
                }
                return i;
            }
        }

        private class MyXSymbolTable
        extends UnicodeSet.XSymbolTable {
            private MyXSymbolTable() {
            }

            public boolean applyPropertyAlias(String propertyName, String propertyValue, UnicodeSet result) {
                UnicodeProperty prop = Factory.this.getProperty(propertyName);
                if (prop == null) {
                    return false;
                }
                result.clear();
                UnicodeSet x = prop.getSet(propertyValue, result);
                return x.size() != 0;
            }
        }
    }

    public static class Name
    implements Comparable {
        private static Map skeletonCache;
        private String skeleton;
        private String pretty;
        public final int RAW = 0;
        public final int TITLE = 1;
        public final int NORMAL = 2;

        public Name(String name, int style) {
            if (name == null) {
                name = "";
            }
            if (style == 0) {
                this.skeleton = this.pretty = name;
            } else {
                this.pretty = UnicodeProperty.regularize(name, style == 1);
                this.skeleton = UnicodeProperty.toSkeleton(this.pretty);
            }
        }

        public int compareTo(Object o) {
            return this.skeleton.compareTo(((Name)o).skeleton);
        }

        public boolean equals(Object o) {
            return this.skeleton.equals(((Name)o).skeleton);
        }

        public int hashCode() {
            return this.skeleton.hashCode();
        }

        public String toString() {
            return this.pretty;
        }
    }
}

