/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.dev.test.util;

import com.ibm.icu.dev.test.TestFmwk;
import com.ibm.icu.util.VersionInfo;

public final class VersionInfoTest
extends TestFmwk {
    private static final String[] INSTANCE_INVALID_STRING_ = new String[]{"a", "-1", "-1.0", "-1.0.0", "-1.0.0.0", "0.-1", "0.0.-1", "0.0.0.-1", "256", "256.0", "256.0.0", "256.0.0.0", "0.256", "0.0.256", "0.0.0.256", "1.2.3.4.5"};
    private static final String[] INSTANCE_VALID_STRING_ = new String[]{"255", "255.255", "255.255.255", "255.255.255.255"};
    private static final int[][] INSTANCE_INVALID_INT_ = new int[][]{{-1}, {-1, 0}, {-1, 0, 0}, {-1, 0, 0, 0}, {0, -1}, {0, 0, -1}, {0, 0, 0, -1}, {256}, {256, 0}, {256, 0, 0}, {256, 0, 0, 0}, {0, 256}, {0, 0, 256}, {0, 0, 0, 256}};
    private static final int[][] INSTANCE_VALID_INT_ = new int[][]{{255}, {255, 255}, {255, 255, 255}, {255, 255, 255, 255}};
    private static final String[] COMPARE_NOT_EQUAL_STRING_ = new String[]{"2.0.0.0", "3.0.0.0"};
    private static final int[][] COMPARE_NOT_EQUAL_INT_ = new int[][]{{2, 0, 0, 0}, {3, 0, 0, 0}};
    private static final String[] COMPARE_EQUAL_STRING_ = new String[]{"2.0.0.0", "2.0.0", "2.0", "2"};
    private static final int[][] COMPARE_EQUAL_INT_ = new int[][]{{2}, {2, 0}, {2, 0, 0}, {2, 0, 0, 0}};
    private static final String[] COMPARE_LESS_ = new String[]{"0", "0.0.0.1", "0.0.1", "0.1", "1", "2", "2.1", "2.1.1", "2.1.1.1"};
    private static final String[] GET_STRING_ = new String[]{"0", "1.1", "2.1.255", "3.1.255.100"};
    private static final int[][] GET_INT_ = new int[][]{{0}, {1, 1}, {2, 1, 255}, {3, 1, 255, 100}};
    private static final int[] GET_RESULT_ = new int[]{0, 0, 0, 0, 1, 1, 0, 0, 2, 1, 255, 0, 3, 1, 255, 100};
    private static final String[] TOSTRING_STRING_ = new String[]{"0", "1.1", "2.1.255", "3.1.255.100"};
    private static final int[][] TOSTRING_INT_ = new int[][]{{0}, {1, 1}, {2, 1, 255}, {3, 1, 255, 100}};
    private static final String[] TOSTRING_RESULT_ = new String[]{"0.0.0.0", "1.1.0.0", "2.1.255.0", "3.1.255.100"};

    public static void main(String[] arg) {
        VersionInfoTest test = new VersionInfoTest();
        try {
            test.run(arg);
        }
        catch (Exception e) {
            test.errln("Error testing VersionInfo");
        }
    }

    public void TestInstance() {
        VersionInfo version;
        int i;
        for (i = 0; i < INSTANCE_INVALID_STRING_.length; ++i) {
            try {
                version = VersionInfo.getInstance((String)INSTANCE_INVALID_STRING_[i]);
                this.errln("\"" + INSTANCE_INVALID_STRING_[i] + "\" should produce an exception");
                continue;
            }
            catch (RuntimeException e) {
                this.logln("PASS: \"" + INSTANCE_INVALID_STRING_[i] + "\" failed as expected");
            }
        }
        for (i = 0; i < INSTANCE_VALID_STRING_.length; ++i) {
            try {
                version = VersionInfo.getInstance((String)INSTANCE_VALID_STRING_[i]);
                continue;
            }
            catch (RuntimeException e) {
                this.errln("\"" + INSTANCE_VALID_STRING_[i] + "\" should produce an valid version");
            }
        }
        for (i = 0; i < INSTANCE_INVALID_INT_.length; ++i) {
            try {
                version = VersionInfoTest.getInstance(INSTANCE_INVALID_INT_[i]);
                this.errln("invalid ints should produce an exception");
                continue;
            }
            catch (RuntimeException e) {
                this.logln("PASS: \"" + INSTANCE_INVALID_INT_[i] + "\" failed as expected");
            }
        }
        for (i = 0; i < INSTANCE_VALID_INT_.length; ++i) {
            try {
                version = VersionInfoTest.getInstance(INSTANCE_VALID_INT_[i]);
                continue;
            }
            catch (RuntimeException e) {
                this.errln("valid ints should not produce an exception");
            }
        }
    }

    public void TestCompare() {
        VersionInfo v2;
        VersionInfo v1;
        int i;
        for (i = 0; i < COMPARE_NOT_EQUAL_STRING_.length; i += 2) {
            v1 = VersionInfo.getInstance((String)COMPARE_NOT_EQUAL_STRING_[i]);
            if (v1.compareTo(v2 = VersionInfo.getInstance((String)COMPARE_NOT_EQUAL_STRING_[i + 1])) != 0) continue;
            this.errln(COMPARE_NOT_EQUAL_STRING_[i] + " should not equal " + COMPARE_NOT_EQUAL_STRING_[i + 1]);
        }
        for (i = 0; i < COMPARE_NOT_EQUAL_INT_.length; i += 2) {
            v1 = VersionInfoTest.getInstance(COMPARE_NOT_EQUAL_INT_[i]);
            if (v1.compareTo(v2 = VersionInfoTest.getInstance(COMPARE_NOT_EQUAL_INT_[i + 1])) != 0) continue;
            this.errln(COMPARE_NOT_EQUAL_INT_[i] + " should not equal " + COMPARE_NOT_EQUAL_INT_[i + 1]);
        }
        for (i = 0; i < COMPARE_EQUAL_STRING_.length - 1; ++i) {
            v1 = VersionInfo.getInstance((String)COMPARE_EQUAL_STRING_[i]);
            if (v1.compareTo(v2 = VersionInfo.getInstance((String)COMPARE_EQUAL_STRING_[i + 1])) == 0) continue;
            this.errln(COMPARE_EQUAL_STRING_[i] + " should equal " + COMPARE_EQUAL_STRING_[i + 1]);
        }
        for (i = 0; i < COMPARE_EQUAL_INT_.length - 1; ++i) {
            v1 = VersionInfoTest.getInstance(COMPARE_EQUAL_INT_[i]);
            if (v1.compareTo(v2 = VersionInfoTest.getInstance(COMPARE_EQUAL_INT_[i + 1])) == 0) continue;
            this.errln(COMPARE_EQUAL_INT_[i] + " should equal " + COMPARE_EQUAL_INT_[i + 1]);
        }
        for (i = 0; i < COMPARE_LESS_.length - 1; ++i) {
            v1 = VersionInfo.getInstance((String)COMPARE_LESS_[i]);
            if (v1.compareTo(v2 = VersionInfo.getInstance((String)COMPARE_LESS_[i + 1])) >= 0) {
                this.errln(COMPARE_LESS_[i] + " should be less than " + COMPARE_LESS_[i + 1]);
            }
            if (v2.compareTo(v1) > 0) continue;
            this.errln(COMPARE_LESS_[i + 1] + " should be greater than " + COMPARE_LESS_[i]);
        }
    }

    public void TestGetter() {
        for (int i = 0; i < GET_STRING_.length; ++i) {
            VersionInfo v = VersionInfo.getInstance((String)GET_STRING_[i]);
            if (v.getMajor() != GET_RESULT_[i << 2] || v.getMinor() != GET_RESULT_[(i << 2) + 1] || v.getMilli() != GET_RESULT_[(i << 2) + 2] || v.getMicro() != GET_RESULT_[(i << 2) + 3]) {
                this.errln(GET_STRING_[i] + " should return major=" + GET_RESULT_[i << 2] + " minor=" + GET_RESULT_[(i << 2) + 1] + " milli=" + GET_RESULT_[(i << 2) + 2] + " micro=" + GET_RESULT_[(i << 2) + 3]);
            }
            if ((v = VersionInfoTest.getInstance(GET_INT_[i])).getMajor() == GET_RESULT_[i << 2] && v.getMinor() == GET_RESULT_[(i << 2) + 1] && v.getMilli() == GET_RESULT_[(i << 2) + 2] && v.getMicro() == GET_RESULT_[(i << 2) + 3]) continue;
            this.errln(GET_STRING_[i] + " should return major=" + GET_RESULT_[i << 2] + " minor=" + GET_RESULT_[(i << 2) + 1] + " milli=" + GET_RESULT_[(i << 2) + 2] + " micro=" + GET_RESULT_[(i << 2) + 3]);
        }
    }

    public void TesttoString() {
        for (int i = 0; i < TOSTRING_STRING_.length; ++i) {
            VersionInfo v = VersionInfo.getInstance((String)TOSTRING_STRING_[i]);
            if (!v.toString().equals(TOSTRING_RESULT_[i])) {
                this.errln("toString() for " + TOSTRING_STRING_[i] + " should produce " + TOSTRING_RESULT_[i]);
            }
            if ((v = VersionInfoTest.getInstance(TOSTRING_INT_[i])).toString().equals(TOSTRING_RESULT_[i])) continue;
            this.errln("toString() for " + TOSTRING_INT_[i] + " should produce " + TOSTRING_RESULT_[i]);
        }
    }

    private static VersionInfo getInstance(int[] data) {
        switch (data.length) {
            case 1: {
                return VersionInfo.getInstance((int)data[0]);
            }
            case 2: {
                return VersionInfo.getInstance((int)data[0], (int)data[1]);
            }
            case 3: {
                return VersionInfo.getInstance((int)data[0], (int)data[1], (int)data[2]);
            }
        }
        return VersionInfo.getInstance((int)data[0], (int)data[1], (int)data[2], (int)data[3]);
    }
}

