/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.icu;

import com.ibm.icu.text.UTF16;
import java.io.OutputStream;

public class ICUResourceWriter {
    private static final String CHARSET = "UTF-8";
    private static final String OPENBRACE = "{";
    private static final String CLOSEBRACE = "}";
    private static final String OPENPAREN = "(";
    private static final String CLOSEPAREN = ")";
    private static final String COLON = ":";
    private static final String COMMA = ",";
    private static final String QUOTE = "\"";
    private static final String COMMENTSTART = "/**";
    private static final String COMMENTEND = " */";
    private static final String COMMENTMIDDLE = " * ";
    private static final String SPACE = " ";
    private static final String INDENT = "    ";
    private static final String EMPTY = "";
    private static final String STRINGS = "string";
    private static final String BIN = "bin";
    private static final String INTS = "int";
    private static final String TABLE = "table";
    private static final String IMPORT = "import";
    private static final String INCLUDE = "include";
    private static final String PROCESS = "process";
    private static final String ALIAS = "alias";
    private static final String INTVECTOR = "intvector";
    private static final String LINESEP = System.getProperty("line.separator");
    public static final String UCA_RULES = "uca_rules";
    public static final String TRANSLITERATOR = "transliaterator";
    public static final String COLLATION = "collation";
    public static final String DEPENDENCY = "dependency";

    public static class ResourceTable
    extends Resource {
        public String annotation;
        public static final String NO_FALLBACK = "nofallback";

        public void write(OutputStream writer, int numIndent, boolean bare) {
            this.writeComments(writer, numIndent);
            this.writeIndent(writer, numIndent);
            if (this.annotation == null) {
                this.write(writer, this.name + ICUResourceWriter.OPENBRACE + LINESEP);
            } else {
                this.write(writer, this.name + ICUResourceWriter.COLON + ICUResourceWriter.TABLE + ICUResourceWriter.OPENPAREN + this.annotation + ICUResourceWriter.CLOSEPAREN + ICUResourceWriter.OPENBRACE + LINESEP);
            }
            ++numIndent;
            Resource current = this.first;
            while (current != null) {
                current.write(writer, numIndent, false);
                current = current.next;
            }
            this.writeIndent(writer, --numIndent);
            this.write(writer, ICUResourceWriter.CLOSEBRACE + LINESEP);
        }

        public void sort() {
            Resource a;
            if (this.noSort) {
                return;
            }
            Resource b = new Resource();
            Resource t = a = this.first;
            while (t != null) {
                Resource u = t.next;
                Resource x = b;
                while (x.next != null && x.next.name.compareTo(t.name) <= 0) {
                    x = x.next;
                }
                t.next = x.next;
                x.next = t;
                t = u;
            }
            if (b.next != null) {
                this.first = b.next;
            }
            Resource current = this.first;
            while (current != null) {
                current.sort();
                current = current.next;
            }
        }
    }

    public static class ResourceString
    extends Resource {
        public String val;

        public void write(OutputStream writer, int numIndent, boolean bare) {
            this.writeComments(writer, numIndent);
            this.writeIndent(writer, numIndent);
            if (bare) {
                if (this.name != null) {
                    throw new RuntimeException("Bare option is set to true but the resource has a name! " + this.name);
                }
                this.write(writer, ICUResourceWriter.QUOTE + this.escapeSyntaxChars(this.val) + ICUResourceWriter.QUOTE);
            } else {
                StringBuffer str = this.escapeSyntaxChars(this.val);
                int colLen = 80 - numIndent * 4;
                int strLen = str.length();
                if (strLen > colLen) {
                    int startIndex = 0;
                    int endIndex = 0;
                    this.write(writer, this.name + ICUResourceWriter.OPENBRACE + LINESEP);
                    ++numIndent;
                    boolean isRules = this.name.equals("Sequence");
                    while (endIndex < strLen) {
                        int firstIndex;
                        startIndex = endIndex;
                        if ((endIndex = startIndex + colLen) > strLen) {
                            endIndex = strLen;
                        }
                        if (isRules && (firstIndex = str.indexOf("&", startIndex)) > -1) {
                            if (startIndex != firstIndex - 1 && startIndex != firstIndex && firstIndex < endIndex && str.charAt(firstIndex - 1) != '\'') {
                                endIndex = firstIndex;
                            }
                            int nextIndex = 0;
                            while ((nextIndex = str.indexOf("&", firstIndex + 1)) != -1 && nextIndex < endIndex) {
                                if (nextIndex <= -1 || firstIndex == nextIndex) continue;
                                if (str.charAt(nextIndex - 1) != '\'') {
                                    endIndex = nextIndex;
                                    break;
                                }
                                firstIndex = nextIndex;
                            }
                        }
                        int indexOfEsc = 0;
                        indexOfEsc = str.lastIndexOf("\\u", endIndex);
                        if (indexOfEsc > -1 && endIndex - indexOfEsc < 6 || (indexOfEsc = str.lastIndexOf("\\U", endIndex)) > -1 && endIndex - indexOfEsc < 10 || (indexOfEsc = str.lastIndexOf("''", endIndex)) > -1 && endIndex - indexOfEsc < 3) {
                            endIndex = indexOfEsc;
                        }
                        if (indexOfEsc > -1 && str.charAt(indexOfEsc - 1) == '\'') {
                            endIndex = indexOfEsc - 1;
                        }
                        if (endIndex < strLen && UTF16.isLeadSurrogate((char)str.charAt(endIndex - 1))) {
                            --endIndex;
                        }
                        this.writeIndent(writer, numIndent);
                        this.write(writer, ICUResourceWriter.QUOTE);
                        this.write(writer, str.substring(startIndex, endIndex));
                        this.write(writer, ICUResourceWriter.QUOTE + LINESEP);
                    }
                    this.writeIndent(writer, --numIndent);
                    this.write(writer, ICUResourceWriter.CLOSEBRACE + LINESEP);
                } else {
                    this.write(writer, this.name + ICUResourceWriter.OPENBRACE + ICUResourceWriter.QUOTE + str.toString() + ICUResourceWriter.QUOTE + ICUResourceWriter.CLOSEBRACE + LINESEP);
                }
            }
        }
    }

    public static class ResourceIntVector
    extends Resource {
        public void write(OutputStream writer, int numIndent, boolean bare) {
            this.writeComments(writer, numIndent);
            this.writeIndent(writer, numIndent);
            this.write(writer, this.name + ICUResourceWriter.COLON + ICUResourceWriter.INTVECTOR + ICUResourceWriter.OPENBRACE + LINESEP);
            ++numIndent;
            ResourceInt current = (ResourceInt)this.first;
            while (current != null) {
                this.writeIndent(writer, numIndent);
                this.write(writer, current.val);
                this.write(writer, ICUResourceWriter.COMMA + LINESEP);
                current = (ResourceInt)current.next;
            }
            this.writeIndent(writer, --numIndent);
            this.write(writer, ICUResourceWriter.CLOSEBRACE + LINESEP);
        }
    }

    public static class ResourceInt
    extends Resource {
        String val;

        public void write(OutputStream writer, int numIndent, boolean bare) {
            this.writeComments(writer, numIndent);
            this.writeIndent(writer, numIndent);
            String line = (this.name == null ? ICUResourceWriter.EMPTY : this.name) + ICUResourceWriter.COLON + ICUResourceWriter.INTS + ICUResourceWriter.OPENBRACE + this.val + ICUResourceWriter.CLOSEBRACE;
            if (bare) {
                if (this.name != null) {
                    throw new RuntimeException("Bare option is set to true but the resource has a name: " + this.name);
                }
                this.write(writer, line);
            } else {
                this.write(writer, line + LINESEP);
            }
        }
    }

    public static class ResourceBinary
    extends Resource {
        String internal;
        String external;

        public void write(OutputStream writer, int numIndent, boolean bare) {
            this.writeComments(writer, numIndent);
            this.writeIndent(writer, numIndent);
            if (this.internal == null) {
                String line = (this.name == null ? ICUResourceWriter.EMPTY : this.name) + ICUResourceWriter.COLON + ICUResourceWriter.IMPORT + ICUResourceWriter.OPENBRACE + ICUResourceWriter.QUOTE + this.external + ICUResourceWriter.QUOTE + ICUResourceWriter.CLOSEBRACE + (bare ? ICUResourceWriter.EMPTY : LINESEP);
                this.write(writer, line);
            } else {
                String line = (this.name == null ? ICUResourceWriter.EMPTY : this.name) + ICUResourceWriter.COLON + ICUResourceWriter.BIN + ICUResourceWriter.OPENBRACE + this.internal + ICUResourceWriter.CLOSEBRACE + (bare ? ICUResourceWriter.EMPTY : LINESEP);
                this.write(writer, line);
            }
        }
    }

    public static class ResourceArray
    extends Resource {
        public void write(OutputStream writer, int numIndent, boolean bare) {
            this.writeComments(writer, numIndent);
            this.writeIndent(writer, numIndent);
            if (this.name != null) {
                this.write(writer, this.name + ICUResourceWriter.OPENBRACE + LINESEP);
            } else {
                this.write(writer, ICUResourceWriter.OPENBRACE + LINESEP);
            }
            ++numIndent;
            Resource current = this.first;
            while (current != null) {
                current.write(writer, numIndent, true);
                if (!(current instanceof ResourceTable) && !(current instanceof ResourceArray)) {
                    this.write(writer, ICUResourceWriter.COMMA + LINESEP);
                }
                current = current.next;
            }
            this.writeIndent(writer, --numIndent);
            this.write(writer, ICUResourceWriter.CLOSEBRACE + LINESEP);
        }

        public void sort() {
            if (this.noSort) {
                return;
            }
            Resource current = this.first;
            while (current != null) {
                current.sort();
                current = current.next;
            }
        }
    }

    public static class ResourceImport
    extends Resource {
        String val;

        public void write(OutputStream writer, int numIndent, boolean bare) {
            this.writeComments(writer, numIndent);
            this.writeIndent(writer, numIndent);
            String line = (this.name == null ? ICUResourceWriter.EMPTY : this.name) + ICUResourceWriter.COLON + ICUResourceWriter.IMPORT + ICUResourceWriter.OPENBRACE + ICUResourceWriter.QUOTE + this.escapeSyntaxChars(this.val) + ICUResourceWriter.QUOTE + ICUResourceWriter.CLOSEBRACE;
            if (bare) {
                if (this.name != null) {
                    throw new RuntimeException("Bare option is set to true but the resource has a name! " + this.name);
                }
                this.write(writer, line);
            } else {
                this.write(writer, line + LINESEP);
            }
        }
    }

    public static class ResourceProcess
    extends Resource {
        String val;
        String ext;

        public void write(OutputStream writer, int numIndent, boolean bare) {
            this.writeComments(writer, numIndent);
            this.writeIndent(writer, numIndent);
            String line = (this.name == null ? ICUResourceWriter.EMPTY : this.name) + ICUResourceWriter.COLON + ICUResourceWriter.PROCESS + ICUResourceWriter.OPENPAREN + this.ext + ICUResourceWriter.CLOSEPAREN + ICUResourceWriter.OPENBRACE + ICUResourceWriter.QUOTE + this.escapeSyntaxChars(this.val) + ICUResourceWriter.QUOTE + ICUResourceWriter.CLOSEBRACE;
            if (bare) {
                if (this.name != null) {
                    throw new RuntimeException("Bare option is set to true but the resource has a name! " + this.name);
                }
                this.write(writer, line);
            } else {
                this.write(writer, line + LINESEP);
            }
        }
    }

    public static class ResourceInclude
    extends Resource {
        String val;

        public void write(OutputStream writer, int numIndent, boolean bare) {
            this.writeComments(writer, numIndent);
            this.writeIndent(writer, numIndent);
            String line = (this.name == null ? ICUResourceWriter.EMPTY : this.name) + ICUResourceWriter.COLON + ICUResourceWriter.INCLUDE + ICUResourceWriter.OPENBRACE + ICUResourceWriter.QUOTE + this.escapeSyntaxChars(this.val) + ICUResourceWriter.QUOTE + ICUResourceWriter.CLOSEBRACE;
            if (bare) {
                if (this.name != null) {
                    throw new RuntimeException("Bare option is set to true but the resource has a name! " + this.name);
                }
                this.write(writer, line);
            } else {
                this.write(writer, line + LINESEP);
            }
        }
    }

    public static class ResourceAlias
    extends Resource {
        String val;

        public void write(OutputStream writer, int numIndent, boolean bare) {
            this.writeComments(writer, numIndent);
            this.writeIndent(writer, numIndent);
            String line = (this.name == null ? ICUResourceWriter.EMPTY : this.name) + ICUResourceWriter.COLON + ICUResourceWriter.ALIAS + ICUResourceWriter.OPENBRACE + ICUResourceWriter.QUOTE + this.escapeSyntaxChars(this.val) + ICUResourceWriter.QUOTE + ICUResourceWriter.CLOSEBRACE;
            if (bare) {
                if (this.name != null) {
                    throw new RuntimeException("Bare option is set to true but the resource has a name! " + this.name);
                }
                this.write(writer, line);
            } else {
                this.write(writer, line + LINESEP);
            }
        }
    }

    public static class Resource {
        String[] note = new String[20];
        int noteLen = 0;
        String translate;
        String comment;
        public String name;
        public Resource next;
        boolean noSort = false;
        public Resource first = null;

        public StringBuffer escapeSyntaxChars(String val) {
            if (val == null) {
                System.err.println("Resource.escapeSyntaxChars: warning, resource '" + this.name + "': string value is NULL - assuming 'empty'");
                return new StringBuffer(ICUResourceWriter.EMPTY);
            }
            char[] str = val.toCharArray();
            StringBuffer result = new StringBuffer();
            for (int i = 0; i < str.length; ++i) {
                switch (str[i]) {
                    case '\"': {
                        result.append('\\');
                    }
                }
                result.append(str[i]);
            }
            return result;
        }

        public void write(OutputStream writer, int numIndent, boolean bare) {
            while (this.next != null) {
                this.next.write(writer, numIndent + 1, false);
            }
        }

        public void writeIndent(OutputStream writer, int numIndent) {
            for (int i = 0; i < numIndent; ++i) {
                this.write(writer, ICUResourceWriter.INDENT);
            }
        }

        public void write(OutputStream writer, String value) {
            try {
                byte[] bytes = value.getBytes(ICUResourceWriter.CHARSET);
                writer.write(bytes, 0, bytes.length);
            }
            catch (Exception e) {
                System.err.println(e);
                System.exit(1);
            }
        }

        public void writeComments(OutputStream writer, int numIndent) {
            if (this.comment != null || this.translate != null || this.noteLen > 0) {
                this.writeIndent(writer, numIndent);
                this.write(writer, ICUResourceWriter.COMMENTSTART + LINESEP);
                if (this.comment != null) {
                    int index = this.comment.indexOf(10);
                    if (index > -1) {
                        StringBuffer indent = new StringBuffer("\n");
                        for (int i = 0; i < numIndent; ++i) {
                            indent.append(ICUResourceWriter.INDENT);
                        }
                        indent.append(ICUResourceWriter.COMMENTMIDDLE);
                        this.comment = this.comment.replaceAll("\n", indent.toString());
                    }
                    this.writeIndent(writer, numIndent);
                    this.write(writer, ICUResourceWriter.COMMENTMIDDLE);
                    this.write(writer, this.comment);
                    this.write(writer, LINESEP);
                }
                this.writeIndent(writer, numIndent);
                this.write(writer, ICUResourceWriter.COMMENTEND + LINESEP);
            }
        }

        public void sort() {
        }

        public void swap() {
        }
    }
}

