/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.icu;

import com.ibm.icu.dev.tool.UOption;
import com.ibm.icu.impl.Utility;
import com.ibm.icu.text.Normalizer;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.text.UCharacterIterator;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.ULocale;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.xml.transform.TransformerException;
import org.unicode.cldr.ant.CLDRConverterTool;
import org.unicode.cldr.icu.ICUResourceWriter;
import org.unicode.cldr.util.LDMLUtilities;
import org.unicode.cldr.util.XPathTokenizer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LDML2ICUConverter
extends CLDRConverterTool {
    private static final int HELP1 = 0;
    private static final int HELP2 = 1;
    private static final int SOURCEDIR = 2;
    private static final int DESTDIR = 3;
    private static final int SPECIALSDIR = 4;
    private static final int WRITE_DEPRECATED = 5;
    private static final int WRITE_DRAFT = 6;
    private static final int SUPPLEMENTALDIR = 7;
    private static final int SUPPLEMENTALONLY = 8;
    private static final int VERBOSE = 9;
    private static final UOption[] options = new UOption[]{UOption.HELP_H(), UOption.HELP_QUESTION_MARK(), UOption.SOURCEDIR(), UOption.DESTDIR(), UOption.create((String)"specialsdir", (char)'p', (int)1), UOption.create((String)"write-deprecated", (char)'w', (int)1), UOption.create((String)"write-draft", (char)'f', (int)0), UOption.create((String)"supplementaldir", (char)'m', (int)1), UOption.create((String)"supplemental-only", (char)'l', (int)0), UOption.VERBOSE()};
    private String sourceDir = null;
    private String fileName = null;
    private String destDir = null;
    private String specialsDir = null;
    private String supplementalDir = null;
    private boolean writeDeprecated = false;
    private boolean writeDraft = false;
    private boolean writeSupplemental = false;
    private boolean verbose = false;
    private static final String LINESEP = System.getProperty("line.separator");
    private static final String BOM = "\ufeff";
    private static final String CHARSET = "UTF-8";
    private static final String DEPRECATED_LIST = "icu-config.xml & build.xml";
    private Document fullyResolvedDoc = null;
    private Document specialsDoc = null;
    private String locName = null;
    private Document supplementalDoc = null;
    private static final boolean DEBUG = false;
    private List xpathList = new ArrayList();
    private static final String LOCALE_SCRIPT = "LocaleScript";
    private static final String NUMBER_ELEMENTS = "NumberElements";
    private static final String NUMBER_PATTERNS = "NumberPatterns";
    private static final String AM_PM_MARKERS = "AmPmMarkers";
    private static final String DTP = "DateTimePatterns";
    public static final String DTE = "DateTimeElements";
    private static final TreeMap keyNameMap = new TreeMap();
    private static final TreeMap deprecatedTerritories = new TreeMap();
    private static final String commentForCurrencyMeta = "Currency metadata.  Unlike the \"Currencies\" element, this is \nNOT true locale data.  It exists only in root.  The two \nintegers are the fraction digits for each currency, and the \nrounding increment.  The fraction digits must be an integer \nfrom 0..9.  If there is no rounding, the rounding increment is \nzero.  Otherwise the rounding increment is given in units of \n10^(-fraction_digits).  The special tag \"DEFAULT\" gives the \nmeta data for all currencies not otherwise listed.";
    private static final String commentForCurrencyMap = "Map from ISO 3166 country codes to ISO 4217 currency codes \nNOTE: This is not true locale data; it exists only in ROOT";
    private String ldmlVersion = null;
    private static final String[] registeredKeys;
    private static final String ICU_SCRIPTS = "icu:scripts";
    private static final TreeMap collationMap;
    private static final UnicodeSet needsQuoting;
    private static StringBuffer quoteOperandBuffer;
    private static final String ICU_BRKITR_DATA = "icu:breakIteratorData";
    private static final String ICU_DICTIONARIES = "icu:dictionaries";
    private static final String ICU_BOUNDARIES = "icu:boundaries";
    private static final String ICU_GRAPHEME = "icu:grapheme";
    private static final String ICU_WORD = "icu:word";
    private static final String ICU_SENTENCE = "icu:sentence";
    private static final String ICU_LINE = "icu:line";
    private static final String ICU_TITLE = "icu:title";
    private static final String ICU_DICTIONARY = "icu:dictionary";
    private static final String ICU_DEPENDENCY = "icu:dependency";
    private static final String ICU_IS_LEAP_MONTH = "icu:isLeapMonth";

    public static void main(String[] args) {
        LDML2ICUConverter cnv = new LDML2ICUConverter();
        cnv.processArgs(args);
    }

    private void usage() {
        System.out.println("\nUsage: LDML2ICUConverter [OPTIONS] [FILES]\nLDML2ICUConverter [OPTIONS] -w [DIRECTORY] \nThis program is used to convert LDML files to ICU ResourceBundle TXT files.\nPlease refer to the following options. Options are not case sensitive.\nOptions:\n-s or --sourcedir          source directory for files followed by path, default is current directory.\n-d or --destdir            destination directory, followed by the path, default is current directory.\n-p or --specialsdir        source directory for files containing special data followed by the path. None if not spcified\n-f or --write-draft        write data for LDML nodes marked draft.\n-m or --suplementaldir     source directory for finding the supplemental data.\n-l or --supplemental-only  read supplementalData.xml file from the given directory and write appropriate files to destination directory\n-w [dir] or --write-deprecated [dir]   write data for deprecated locales. 'dir' is a directory of source xml files.\n-h or -? or --help         this usage text.\n-v or --verbose            print out verbose output.\nexample: org.unicode.cldr.icu.LDML2ICUConverter -s xxx -d yyy en.xml");
        System.exit(-1);
    }

    private void printInfo(String message) {
        if (this.verbose) {
            System.out.println("INFO : " + message);
        }
    }

    private void printXPathWarning(Node node, StringBuffer xpath) {
        int len = xpath.length();
        this.getXPath(node, xpath);
        System.err.println("WARNING : Not producing resource for : " + xpath.toString());
        xpath.setLength(len);
    }

    private void printWarning(String fileName, String message) {
        System.err.println(fileName + ": WARNING : " + message);
    }

    private void printError(String fileName, String message) {
        System.err.println(fileName + ": ERROR : " + message);
    }

    public void processArgs(String[] args) {
        int remainingArgc = 0;
        for (int i = 0; i < options.length; ++i) {
            LDML2ICUConverter.options[i].doesOccur = false;
        }
        try {
            remainingArgc = UOption.parseArgs((String[])args, (UOption[])options);
        }
        catch (Exception e) {
            this.printError("", "(parsing args): " + e.toString());
            e.printStackTrace();
            this.usage();
        }
        if (args.length == 0 || LDML2ICUConverter.options[0].doesOccur || LDML2ICUConverter.options[1].doesOccur) {
            this.usage();
        }
        if (LDML2ICUConverter.options[2].doesOccur) {
            this.sourceDir = LDML2ICUConverter.options[2].value;
        }
        if (LDML2ICUConverter.options[3].doesOccur) {
            this.destDir = LDML2ICUConverter.options[3].value;
        }
        if (LDML2ICUConverter.options[4].doesOccur) {
            this.specialsDir = LDML2ICUConverter.options[4].value;
        }
        if (LDML2ICUConverter.options[6].doesOccur) {
            this.writeDraft = true;
        }
        if (LDML2ICUConverter.options[7].doesOccur) {
            this.supplementalDir = LDML2ICUConverter.options[7].value;
        }
        if (LDML2ICUConverter.options[8].doesOccur) {
            this.writeSupplemental = true;
        }
        if (LDML2ICUConverter.options[9].doesOccur) {
            this.verbose = true;
        }
        if (this.destDir == null) {
            this.destDir = ".";
        }
        if (LDML2ICUConverter.options[5].doesOccur) {
            this.writeDeprecated = true;
            if (remainingArgc > 0) {
                this.printError("", "-w takes one argument, the directory, and no other XML files.\n");
                this.usage();
                return;
            }
            this.writeDeprecated();
            return;
        }
        if (remainingArgc == 0 && (this.localesMap == null || this.localesMap.size() == 0)) {
            this.printError("", "No files specified for processing. Please check the arguments and try again");
            this.usage();
        }
        if (this.supplementalDir != null) {
            this.supplementalDoc = this.createSupplementalDoc();
        }
        if (this.writeSupplemental) {
            this.makeXPathList(this.supplementalDoc);
            String fileName = "supplementalData.xml";
            System.out.println("Processing: " + fileName);
            ICUResourceWriter.Resource res = this.parseSupplemental(this.supplementalDoc, fileName);
            if (res != null && ((ICUResourceWriter.ResourceTable)res).first != null) {
                this.writeResource(res, fileName);
            }
        } else if (this.localesMap != null && this.localesMap.size() > 0) {
            Iterator iter = this.localesMap.keySet().iterator();
            while (iter.hasNext()) {
                String fileName = (String)iter.next();
                String draft = (String)this.localesMap.get(fileName);
                this.writeDraft = draft != null && !draft.equals("false");
                this.processFile(fileName);
            }
        } else if (remainingArgc > 0) {
            for (int i = 0; i < remainingArgc; ++i) {
                this.processFile(args[i]);
            }
        } else {
            this.printError("", " No files specified!");
        }
    }

    private void processFile(String fileName) {
        long start = System.currentTimeMillis();
        int lastIndex = fileName.lastIndexOf(File.separator, fileName.length()) + 1;
        fileName = fileName.substring(lastIndex, fileName.length());
        String xmlfileName = LDMLUtilities.getFullPath(0, fileName, this.sourceDir);
        this.locName = fileName;
        int index = this.locName.indexOf(".xml");
        if (index > -1) {
            this.locName = this.locName.substring(0, index);
        }
        System.out.println("Processing: " + xmlfileName);
        String icuSpecialFile = "";
        if (this.specialsDir != null) {
            icuSpecialFile = this.specialsDir + "/" + fileName;
            if (new File(icuSpecialFile).exists()) {
                this.printInfo("Parsing ICU specials from: " + icuSpecialFile);
                this.specialsDoc = LDMLUtilities.parseAndResolveAliases(fileName, this.specialsDir, true, false);
            } else {
                if (ULocale.getCountry((String)this.locName).length() == 0) {
                    this.printWarning(icuSpecialFile, "ICU special not found for language-locale \"" + this.locName + "\"");
                } else {
                    this.printInfo("ICU special " + icuSpecialFile + " not found, continuing.");
                }
                this.specialsDoc = null;
            }
        }
        Document doc = LDMLUtilities.parse(xmlfileName, false);
        if (this.specialsDoc != null) {
            StringBuffer xpath = new StringBuffer();
            doc = (Document)LDMLUtilities.mergeLDMLDocuments(doc, this.specialsDoc, xpath, icuSpecialFile, this.specialsDir, false, true);
        }
        if (!LDMLUtilities.isLocaleAlias(doc)) {
            this.fullyResolvedDoc = LDMLUtilities.getFullyResolvedLDML(this.sourceDir, fileName, false, false, false, false);
        }
        if (!this.writeDraft && this.isDraftStatusOverridable(this.locName)) {
            this.printInfo("Overriding draft status, and including: " + this.locName);
            this.writeDraft = true;
        }
        this.createResourceBundle(doc, xmlfileName, icuSpecialFile);
        long stop = System.currentTimeMillis();
        long total = stop - start;
        double s = (double)total / 1000.0;
        this.printInfo("Elapsed time: " + s + "s");
    }

    private void makeXPathList(Node node, StringBuffer xpath) {
        if (xpath == null) {
            xpath = new StringBuffer("/");
        }
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1) continue;
            String name = child.getNodeName();
            int savedLength = xpath.length();
            xpath.append("/");
            xpath.append(name);
            LDMLUtilities.appendXPathAttribute(child, xpath, false, false);
            if (name.equals("collation")) {
                this.xpathList.add(xpath.toString());
            } else if (LDMLUtilities.areChildrenElementNodes(child)) {
                this.makeXPathList(child, xpath);
            } else {
                this.xpathList.add(xpath.toString());
            }
            xpath.delete(savedLength, xpath.length());
        }
    }

    private void makeXPathList(Document doc) {
        this.makeXPathList(doc, null);
        this.makeXPathList(this.supplementalDoc, null);
        Collections.sort(this.xpathList);
        this.xpathList = this.computeConvertibleXPaths(this.xpathList, this.exemplarsContainAZ(this.fullyResolvedDoc), this.locName, this.supplementalDir);
    }

    private boolean exemplarsContainAZ(Document fullyResolvedDoc) {
        if (fullyResolvedDoc == null) {
            return false;
        }
        Node node = LDMLUtilities.getNode(fullyResolvedDoc, "//ldml/characters/exemplarCharacters");
        if (node == null) {
            return false;
        }
        String ex = LDMLUtilities.getNodeValue(node);
        UnicodeSet set = new UnicodeSet(ex);
        return set.containsAll(new UnicodeSet("[A-Z a-z]"));
    }

    private Document createSupplementalDoc() {
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.matches(".*\\.xml") && !name.equals("characters.xml");
            }
        };
        File myDir = new File(this.supplementalDir);
        String[] files = myDir.list(filter);
        Document doc = null;
        for (int i = 0; i < files.length; ++i) {
            try {
                this.printInfo("Parsing document " + files[i]);
                String fileName = myDir.getAbsolutePath() + File.separator + files[i];
                Document child = LDMLUtilities.parse(fileName, false);
                if (doc == null) {
                    doc = child;
                    continue;
                }
                StringBuffer xpath = new StringBuffer();
                LDMLUtilities.mergeLDMLDocuments(doc, child, xpath, files[i], myDir.getAbsolutePath(), true, false);
                continue;
            }
            catch (Throwable se) {
                this.printError(this.fileName, "Parsing: " + files[i] + " " + se.toString());
                se.printStackTrace();
                System.exit(1);
            }
        }
        return doc;
    }

    private void createResourceBundle(Document doc, String xmlfileName, String icuSpecialFile) {
        try {
            this.makeXPathList(doc);
            ICUResourceWriter.Resource res = this.parseBundle(doc);
            if (res != null && ((ICUResourceWriter.ResourceTable)res).first != null) {
                if (this.specialsDoc != null) {
                    String dir = this.specialsDir.replace('\\', '/');
                    dir = "<path>" + dir.substring(dir.indexOf("/xml"), dir.length());
                    res.comment = res.comment == null ? " ICU <specials> source: " + dir + "/" + this.locName + ".xml" : res.comment + " ICU <specials> source: " + dir + "/" + this.locName + ".xml";
                }
                this.writeResource(res, xmlfileName);
            }
        }
        catch (Throwable se) {
            this.printError(xmlfileName, "(parsing and writing) " + se.toString());
            se.printStackTrace();
            System.exit(1);
        }
    }

    private ICUResourceWriter.Resource parseSupplemental(Node root, String file) {
        ICUResourceWriter.ResourceTable table = new ICUResourceWriter.ResourceTable();
        ICUResourceWriter.Resource current = null;
        StringBuffer xpath = new StringBuffer();
        xpath.append("//");
        xpath.append("supplementalData");
        table.name = "supplementalData";
        table.annotation = "nofallback";
        int savedLength = xpath.length();
        for (Node node = root.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            String name = node.getNodeName();
            ICUResourceWriter.Resource res = null;
            if (name.equals("supplementalData")) {
                node = node.getFirstChild();
                continue;
            }
            if (name.equals("special")) {
                node = node.getFirstChild();
                continue;
            }
            if (name.equals("currencyData")) {
                res = this.parseCurrencyData(node, xpath);
            } else if (name.equals("territoryContainment")) {
                res = this.parseTerritoryContainment(node, xpath);
            } else if (name.equals("languageData")) {
                res = this.parseLanguageData(node, xpath);
            } else if (name.equals("territoryData")) {
                res = this.parseTerritoryData(node, xpath);
            } else if (!(name.equals("metadata") || name.equals("version") || name.equals("generation"))) {
                if (name.equals("calendarData")) {
                    res = this.parseCalendarData(node, xpath);
                } else if (name.equals("timezoneData")) {
                    res = this.parseTimeZoneData(node, xpath);
                } else if (!(name.equals("weekData") || name.equals("characters") || name.equals("measurementData"))) {
                    this.printError(file, "Encountered unknown element " + this.getXPath(node, xpath).toString());
                    System.exit(-1);
                }
            }
            if (res != null) {
                if (current == null) {
                    table.first = res;
                    current = this.findLast(res);
                } else {
                    current.next = res;
                    current = this.findLast(res);
                }
                res = null;
            }
            xpath.delete(savedLength, xpath.length());
        }
        return table;
    }

    private ICUResourceWriter.Resource parseTerritoryContainment(Node root, StringBuffer xpath) {
        int savedLength = xpath.length();
        this.getXPath(root, xpath);
        int oldLength = xpath.length();
        ICUResourceWriter.Resource current = null;
        ICUResourceWriter.ResourceArray res = null;
        if (this.isNodeNotConvertible(root, xpath)) {
            xpath.setLength(savedLength);
            return null;
        }
        ICUResourceWriter.ResourceTable table = new ICUResourceWriter.ResourceTable();
        table.name = "territoryContainment";
        for (Node node = root.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            String name = node.getNodeName();
            this.getXPath(node, xpath);
            if (this.isNodeNotConvertible(node, xpath)) {
                xpath.setLength(oldLength);
                continue;
            }
            if (name.equals("group")) {
                String cnt = LDMLUtilities.getAttributeValue(node, "contains");
                String value = LDMLUtilities.getAttributeValue(node, "type");
                res = this.getResourceArray(cnt, value);
            } else {
                System.err.println("Encountered unknown <" + root.getNodeName() + "> subelement: " + name);
                System.exit(-1);
            }
            if (res != null) {
                if (current == null) {
                    table.first = res;
                    current = this.findLast(res);
                } else {
                    current.next = res;
                    current = this.findLast(res);
                }
                res = null;
            }
            xpath.delete(oldLength, xpath.length());
        }
        xpath.delete(savedLength, xpath.length());
        if (table.first != null) {
            return table;
        }
        return null;
    }

    private ICUResourceWriter.Resource parseCalendarData(Node root, StringBuffer xpath) {
        int savedLength = xpath.length();
        this.getXPath(root, xpath);
        int oldLength = xpath.length();
        ICUResourceWriter.Resource current = null;
        ICUResourceWriter.ResourceArray res = null;
        if (this.isNodeNotConvertible(root, xpath)) {
            xpath.setLength(savedLength);
            return null;
        }
        ICUResourceWriter.ResourceTable table = new ICUResourceWriter.ResourceTable();
        table.name = "calendarData";
        for (Node node = root.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            String name = node.getNodeName();
            this.getXPath(node, xpath);
            if (this.isNodeNotConvertible(node, xpath)) {
                xpath.setLength(oldLength);
                continue;
            }
            if (name.equals("calendar")) {
                String cnt = LDMLUtilities.getAttributeValue(node, "territories");
                res = this.getResourceArray(cnt, LDMLUtilities.getAttributeValue(node, "type"));
            } else {
                System.err.println("Encountered unknown " + xpath.toString());
                System.exit(-1);
            }
            if (res != null) {
                if (current == null) {
                    table.first = res;
                    current = this.findLast(res);
                } else {
                    current.next = res;
                    current = this.findLast(res);
                }
                res = null;
            }
            xpath.delete(oldLength, xpath.length());
        }
        xpath.delete(savedLength, xpath.length());
        if (table.first != null) {
            return table;
        }
        return null;
    }

    private ICUResourceWriter.Resource parseTerritoryData(Node root, StringBuffer xpath) {
        int savedLength = xpath.length();
        this.getXPath(root, xpath);
        int oldLength = xpath.length();
        ICUResourceWriter.Resource current = null;
        ICUResourceWriter.ResourceString res = null;
        if (this.isNodeNotConvertible(root, xpath)) {
            xpath.setLength(savedLength);
            return null;
        }
        ICUResourceWriter.ResourceTable table = new ICUResourceWriter.ResourceTable();
        table.name = "territoryData";
        for (Node node = root.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            String name = node.getNodeName();
            this.getXPath(node, xpath);
            if (this.isNodeNotConvertible(node, xpath)) {
                xpath.setLength(oldLength);
                continue;
            }
            if (name.equals("territory")) {
                ICUResourceWriter.ResourceString str = new ICUResourceWriter.ResourceString();
                String type = LDMLUtilities.getAttributeValue(node, "type");
                if (type == null) {
                    this.printError(this.fileName, "Could not get type attribute for xpath: " + xpath.toString());
                }
                str.name = type;
                str.val = LDMLUtilities.getAttributeValue(node, "mostPopulousTimezone");
                res = str;
            } else {
                System.err.println("Encountered unknown <" + root.getNodeName() + "> subelement: " + name);
                System.exit(-1);
            }
            if (res != null) {
                if (current == null) {
                    table.first = res;
                    current = this.findLast(res);
                } else {
                    current.next = res;
                    current = this.findLast(res);
                }
                res = null;
            }
            xpath.delete(oldLength, xpath.length());
        }
        xpath.delete(savedLength, xpath.length());
        if (table.first != null) {
            return table;
        }
        return null;
    }

    private ICUResourceWriter.ResourceArray getResourceArray(String str, String name) {
        if (str != null) {
            String[] strs = str.split("\\s+");
            ICUResourceWriter.ResourceArray arr = new ICUResourceWriter.ResourceArray();
            arr.name = name;
            ICUResourceWriter.Resource curr = null;
            for (int i = 0; i < strs.length; ++i) {
                ICUResourceWriter.ResourceString string = new ICUResourceWriter.ResourceString();
                string.val = strs[i];
                if (curr == null) {
                    arr.first = string;
                    curr = arr.first;
                    continue;
                }
                curr.next = string;
                curr = curr.next;
            }
            return arr;
        }
        return null;
    }

    private ICUResourceWriter.Resource parseLanguageData(Node root, StringBuffer xpath) {
        int savedLength = xpath.length();
        this.getXPath(root, xpath);
        int oldLength = xpath.length();
        if (this.isNodeNotConvertible(root, xpath)) {
            xpath.setLength(savedLength);
            return null;
        }
        Hashtable<String, ICUResourceWriter.ResourceTable> hash = new Hashtable<String, ICUResourceWriter.ResourceTable>();
        ICUResourceWriter.ResourceTable table = new ICUResourceWriter.ResourceTable();
        table.name = "languageData";
        for (Node node = root.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            String name = node.getNodeName();
            this.getXPath(node, xpath);
            if (this.isNodeNotConvertible(node, xpath)) {
                xpath.setLength(oldLength);
                continue;
            }
            if (name.equals("language")) {
                ICUResourceWriter.ResourceTable main;
                String key = LDMLUtilities.getAttributeValue(node, "type");
                if (key == null) {
                    this.printError(this.fileName, "<language> element does not have type attribute! " + xpath.toString());
                    return null;
                }
                String scs = LDMLUtilities.getAttributeValue(node, "scripts");
                String trs = LDMLUtilities.getAttributeValue(node, "territories");
                String mpt = LDMLUtilities.getAttributeValue(node, "mostPopulousTerritory");
                String alt = LDMLUtilities.getAttributeValue(node, "alt");
                if (alt == null) {
                    alt = "primary";
                }
                ICUResourceWriter.ResourceTable tbl = new ICUResourceWriter.ResourceTable();
                tbl.name = alt;
                ICUResourceWriter.ResourceArray scripts = this.getResourceArray(scs, "scripts");
                ICUResourceWriter.ResourceArray terrs = this.getResourceArray(trs, "territories");
                ICUResourceWriter.ResourceArray mpts = this.getResourceArray(mpt, "mostPopulousTerritory");
                if (scripts != null) {
                    tbl.first = scripts;
                }
                if (terrs != null) {
                    if (tbl.first != null) {
                        this.findLast((ICUResourceWriter.Resource)tbl.first).next = terrs;
                    } else {
                        tbl.first = terrs;
                    }
                }
                if (mpts != null) {
                    if (tbl.first != null) {
                        this.findLast((ICUResourceWriter.Resource)tbl.first).next = mpts;
                    } else {
                        tbl.first = terrs;
                    }
                }
                if ((main = (ICUResourceWriter.ResourceTable)hash.get(key)) == null) {
                    main = new ICUResourceWriter.ResourceTable();
                    main.name = key;
                    hash.put(key, main);
                }
                if (main.first != null) {
                    this.findLast((ICUResourceWriter.Resource)main.first).next = tbl;
                } else {
                    main.first = tbl;
                }
            } else {
                System.err.println("Encountered unknown <" + root.getNodeName() + "> subelement: " + name);
                System.exit(-1);
            }
            xpath.setLength(oldLength);
        }
        Enumeration iter = hash.keys();
        ICUResourceWriter.Resource current = null;
        ICUResourceWriter.Resource res = null;
        while (iter.hasMoreElements()) {
            String key = (String)iter.nextElement();
            res = (ICUResourceWriter.Resource)hash.get(key);
            if (current == null) {
                current = table.first = res;
                continue;
            }
            current = current.next = res;
        }
        xpath.delete(savedLength, xpath.length());
        if (table.first != null) {
            return table;
        }
        return null;
    }

    private ICUResourceWriter.Resource parseTimeZoneData(Node root, StringBuffer xpath) {
        ICUResourceWriter.Resource current = null;
        ICUResourceWriter.Resource first = null;
        int savedLength = xpath.length();
        this.getXPath(root, xpath);
        int oldLength = xpath.length();
        if (this.isNodeNotConvertible(root, xpath)) {
            xpath.setLength(savedLength);
            return null;
        }
        ICUResourceWriter.ResourceTable mapZones = new ICUResourceWriter.ResourceTable();
        mapZones.name = "mapTimezones";
        for (Node node = root.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            String name = node.getNodeName();
            ICUResourceWriter.Resource res = null;
            if (name.equals("alias")) {
                res = this.parseAliasResource(node, xpath);
                res.name = name;
                return res;
            }
            if (name.equals("default")) {
                res = this.getDefaultResource(node, xpath, name);
            } else if (name.equals("mapTimezones")) {
                res = this.parseMapTimezones(node, xpath);
                if (res != null) {
                    if (mapZones.first == null) {
                        mapZones.first = res;
                    } else {
                        this.findLast((ICUResourceWriter.Resource)mapZones.first).next = res;
                    }
                }
                res = null;
            } else if (name.equals("zoneFormatting")) {
                res = this.parseZoneFormatting(node, xpath);
            } else {
                System.err.println("Encountered unknown <" + root.getNodeName() + "> subelement: " + name);
                System.exit(-1);
            }
            if (res != null) {
                if (current == null) {
                    first = res;
                    current = this.findLast(res);
                } else {
                    current.next = res;
                    current = this.findLast(res);
                }
                res = null;
            }
            xpath.delete(oldLength, xpath.length());
        }
        if (mapZones.first != null) {
            if (current == null) {
                first = current = mapZones;
            } else {
                current.next = mapZones;
                current = this.findLast(mapZones);
            }
        }
        xpath.delete(savedLength, xpath.length());
        if (first != null) {
            return first;
        }
        return null;
    }

    private ICUResourceWriter.Resource parseMapTimezones(Node root, StringBuffer xpath) {
        int savedLength = xpath.length();
        this.getXPath(root, xpath);
        int oldLength = xpath.length();
        ICUResourceWriter.Resource current = null;
        ICUResourceWriter.ResourceString res = null;
        if (this.isNodeNotConvertible(root, xpath)) {
            xpath.setLength(savedLength);
            return null;
        }
        ICUResourceWriter.ResourceTable table = new ICUResourceWriter.ResourceTable();
        table.name = LDMLUtilities.getAttributeValue(root, "type");
        for (Node node = root.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            String name = node.getNodeName();
            this.getXPath(node, xpath);
            if (this.isNodeNotConvertible(node, xpath)) {
                xpath.setLength(oldLength);
                continue;
            }
            if (name.equals("mapZone")) {
                String type = LDMLUtilities.getAttributeValue(node, "type");
                String other = LDMLUtilities.getAttributeValue(node, "other");
                ICUResourceWriter.ResourceString str = new ICUResourceWriter.ResourceString();
                str.name = type;
                str.val = other;
                res = str;
            } else {
                System.err.println("Encountered unknown <" + root.getNodeName() + "> subelement: " + name);
                System.exit(-1);
            }
            if (res != null) {
                if (current == null) {
                    table.first = res;
                    current = this.findLast(res);
                } else {
                    current.next = res;
                    current = this.findLast(res);
                }
                res = null;
            }
            xpath.setLength(oldLength);
        }
        xpath.setLength(savedLength);
        if (table.first != null) {
            return table;
        }
        return null;
    }

    private ICUResourceWriter.Resource parseZoneFormatting(Node root, StringBuffer xpath) {
        ICUResourceWriter.ResourceTable table = new ICUResourceWriter.ResourceTable();
        ICUResourceWriter.Resource current = null;
        int savedLength = xpath.length();
        this.getXPath(root, xpath);
        int oldLength = xpath.length();
        if (this.isNodeNotConvertible(root, xpath)) {
            xpath.setLength(savedLength);
            return null;
        }
        table.name = "zoneFormatting";
        table.noSort = true;
        for (Node node = root.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            String name = node.getNodeName();
            ICUResourceWriter.Resource res = null;
            this.getXPath(node, xpath);
            if (this.isNodeNotConvertible(node, xpath)) {
                xpath.setLength(oldLength);
                continue;
            }
            if (name.equals("alias")) {
                res = this.parseAliasResource(node, xpath);
                res.name = name;
                return res;
            }
            if (name.equals("default")) {
                res = this.getDefaultResource(node, xpath, name);
            } else if (name.equals("zoneItem")) {
                ICUResourceWriter.ResourceTable zi = new ICUResourceWriter.ResourceTable();
                zi.name = LDMLUtilities.getAttributeValue(node, "type");
                String territory = LDMLUtilities.getAttributeValue(node, "territory");
                ICUResourceWriter.ResourceString ter = new ICUResourceWriter.ResourceString();
                ter.name = "territory";
                ter.val = territory;
                zi.first = ter;
                String aliases = LDMLUtilities.getAttributeValue(node, "aliases");
                if (aliases != null) {
                    String[] arr = aliases.split("\\s+");
                    ICUResourceWriter.ResourceArray als = new ICUResourceWriter.ResourceArray();
                    als.name = "aliases";
                    ICUResourceWriter.Resource cur = null;
                    for (int i = 0; i < arr.length; ++i) {
                        ICUResourceWriter.ResourceString str = new ICUResourceWriter.ResourceString();
                        str.val = arr[i];
                        if (cur == null) {
                            cur = str;
                            als.first = cur;
                            continue;
                        }
                        cur.next = str;
                        cur = cur.next;
                    }
                    ter.next = als;
                }
                res = zi;
            } else {
                System.err.println("Encountered unknown <" + root.getNodeName() + "> subelement: " + name);
                System.exit(-1);
            }
            if (res != null) {
                if (current == null) {
                    table.first = res;
                    current = this.findLast(res);
                } else {
                    current.next = res;
                    current = this.findLast(res);
                }
                res = null;
            }
            xpath.delete(oldLength, xpath.length());
        }
        xpath.delete(savedLength, xpath.length());
        if (table.first != null) {
            return table;
        }
        return null;
    }

    private ICUResourceWriter.Resource parseCurrencyFraction(Node root, StringBuffer xpath) {
        ICUResourceWriter.ResourceTable table = new ICUResourceWriter.ResourceTable();
        ICUResourceWriter.Resource current = null;
        int savedLength = xpath.length();
        this.getXPath(root, xpath);
        int oldLength = xpath.length();
        if (this.isNodeNotConvertible(root, xpath)) {
            xpath.setLength(savedLength);
            return null;
        }
        table.name = "CurrencyMeta";
        table.noSort = true;
        for (Node node = root.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            String name = node.getNodeName();
            ICUResourceWriter.Resource res = null;
            this.getXPath(node, xpath);
            if (this.isNodeNotConvertible(node, xpath)) {
                xpath.setLength(oldLength);
                continue;
            }
            if (name.equals("alias")) {
                res = this.parseAliasResource(node, xpath);
                res.name = name;
                return res;
            }
            if (name.equals("default")) {
                res = this.getDefaultResource(node, xpath, name);
            } else if (name.equals("info")) {
                ICUResourceWriter.ResourceIntVector vector = new ICUResourceWriter.ResourceIntVector();
                vector.name = LDMLUtilities.getAttributeValue(node, "iso4217");
                ICUResourceWriter.ResourceInt zero = new ICUResourceWriter.ResourceInt();
                ICUResourceWriter.ResourceInt one = new ICUResourceWriter.ResourceInt();
                zero.val = LDMLUtilities.getAttributeValue(node, "digits");
                one.val = LDMLUtilities.getAttributeValue(node, "rounding");
                vector.first = zero;
                zero.next = one;
                res = vector;
            } else {
                System.err.println("Encountered unknown <" + root.getNodeName() + "> subelement: " + name);
                System.exit(-1);
            }
            if (res != null) {
                if (current == null) {
                    table.first = res;
                    current = this.findLast(res);
                } else {
                    current.next = res;
                    current = this.findLast(res);
                }
                res = null;
            }
            xpath.delete(oldLength, xpath.length());
        }
        xpath.delete(savedLength, xpath.length());
        if (table.first != null) {
            return table;
        }
        return null;
    }

    private int countHyphens(String str) {
        int ret = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != '-') continue;
            ++ret;
        }
        return ret;
    }

    private long getMilliSeconds(String dateStr) {
        try {
            if (dateStr != null) {
                int count = this.countHyphens(dateStr);
                SimpleDateFormat format = new SimpleDateFormat();
                Date date = null;
                if (count == 2) {
                    format.applyPattern("yyyy-mm-dd");
                    date = format.parse(dateStr);
                } else if (count == 1) {
                    format.applyPattern("yyyy-mm");
                    date = format.parse(dateStr);
                } else {
                    format.applyPattern("yyyy");
                    date = format.parse(dateStr);
                }
                return date.getTime();
            }
        }
        catch (ParseException ex) {
            System.err.println("Could not parse date: " + dateStr);
            System.err.println(ex.getMessage());
            System.exit(-1);
        }
        return -1L;
    }

    private ICUResourceWriter.ResourceIntVector getSeconds(String dateStr) {
        long millis = this.getMilliSeconds(dateStr);
        if (millis == -1L) {
            return null;
        }
        int top = (int)((millis & 0xFFFFFFFF00000000L) >>> 32);
        int bottom = (int)(millis & 0xFFFFFFFFL);
        ICUResourceWriter.ResourceIntVector vector = new ICUResourceWriter.ResourceIntVector();
        ICUResourceWriter.ResourceInt int1 = new ICUResourceWriter.ResourceInt();
        ICUResourceWriter.ResourceInt int2 = new ICUResourceWriter.ResourceInt();
        int1.val = Integer.toString(top);
        int2.val = Integer.toString(bottom);
        vector.first = int1;
        int1.next = int2;
        return vector;
    }

    private ICUResourceWriter.Resource parseCurrencyRegion(Node root, StringBuffer xpath) {
        ICUResourceWriter.ResourceTable table = new ICUResourceWriter.ResourceTable();
        ICUResourceWriter.Resource current = null;
        int savedLength = xpath.length();
        this.getXPath(root, xpath);
        int oldLength = xpath.length();
        if (this.isNodeNotConvertible(root, xpath)) {
            xpath.setLength(savedLength);
            return null;
        }
        table.name = LDMLUtilities.getAttributeValue(root, "iso3166");
        for (Node node = root.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            String name = node.getNodeName();
            ICUResourceWriter.Resource res = null;
            this.getXPath(node, xpath);
            if (name.equals("alias")) {
                res = this.parseAliasResource(node, xpath);
                res.name = name;
                return res;
            }
            if (name.equals("default")) {
                res = this.getDefaultResource(node, xpath, name);
            } else if (name.equals("currency")) {
                if (this.isNodeNotConvertible(node, xpath)) {
                    xpath.setLength(oldLength);
                    continue;
                }
                ICUResourceWriter.ResourceTable curr = new ICUResourceWriter.ResourceTable();
                curr.name = "";
                ICUResourceWriter.ResourceString id = new ICUResourceWriter.ResourceString();
                id.name = "id";
                id.val = LDMLUtilities.getAttributeValue(node, "iso4217");
                ICUResourceWriter.ResourceIntVector fromRes = this.getSeconds(LDMLUtilities.getAttributeValue(node, "from"));
                ICUResourceWriter.ResourceIntVector toRes = this.getSeconds(LDMLUtilities.getAttributeValue(node, "to"));
                if (fromRes != null) {
                    fromRes.name = "from";
                    curr.first = id;
                    id.next = fromRes;
                }
                if (toRes != null) {
                    toRes.name = "to";
                    fromRes.next = toRes;
                }
                res = curr;
            } else {
                System.err.println("Encountered unknown <" + root.getNodeName() + "> subelement: " + name);
                System.exit(-1);
            }
            if (res != null) {
                if (current == null) {
                    table.first = res;
                    current = this.findLast(res);
                } else {
                    current.next = res;
                    current = this.findLast(res);
                }
                res = null;
            }
            xpath.delete(oldLength, xpath.length());
        }
        xpath.delete(savedLength, xpath.length());
        if (table.first != null) {
            return table;
        }
        return null;
    }

    private ICUResourceWriter.Resource parseCurrencyData(Node root, StringBuffer xpath) {
        ICUResourceWriter.Resource currencyMeta = null;
        ICUResourceWriter.ResourceTable currencyMap = new ICUResourceWriter.ResourceTable();
        currencyMap.name = "CurrencyMap";
        currencyMap.comment = commentForCurrencyMap;
        currencyMap.noSort = true;
        ICUResourceWriter.Resource currentMap = null;
        int savedLength = xpath.length();
        this.getXPath(root, xpath);
        int oldLength = xpath.length();
        if (this.isNodeNotConvertible(root, xpath)) {
            xpath.setLength(savedLength);
            return null;
        }
        for (Node node = root.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            String name = node.getNodeName();
            ICUResourceWriter.Resource res = null;
            if (name.equals("region")) {
                res = this.parseCurrencyRegion(node, xpath);
                if (res != null) {
                    if (currentMap == null) {
                        currencyMap.first = res;
                        currentMap = this.findLast(res);
                    } else {
                        currentMap.next = res;
                        currentMap = this.findLast(res);
                    }
                    res = null;
                }
            } else if (name.equals("fractions")) {
                currencyMeta = this.parseCurrencyFraction(node, xpath);
                currencyMeta.comment = commentForCurrencyMeta;
            } else {
                System.err.println("Encountered unknown <" + root.getNodeName() + "> subelement: " + name);
                System.exit(-1);
            }
            xpath.delete(oldLength, xpath.length());
        }
        xpath.delete(savedLength, xpath.length());
        currencyMeta.next = currencyMap;
        return currencyMeta;
    }

    private ICUResourceWriter.Resource parseBundle(Document root) {
        ICUResourceWriter.ResourceTable table = new ICUResourceWriter.ResourceTable();
        ICUResourceWriter.Resource current = null;
        StringBuffer xpath = new StringBuffer();
        xpath.append("//ldml");
        int savedLength = xpath.length();
        Node ldml = null;
        for (ldml = root.getFirstChild(); ldml != null; ldml = ldml.getNextSibling()) {
            String name;
            if (ldml.getNodeType() != 1 || !(name = ldml.getNodeName()).equals("ldml")) continue;
            this.ldmlVersion = LDMLUtilities.getAttributeValue(ldml, "version");
            break;
        }
        if (ldml == null) {
            throw new RuntimeException("ERROR: no <ldml> node found in parseBundle()");
        }
        if (this.verbose) {
            this.printInfo("INFO: ");
        }
        for (Node node = ldml.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            String name = node.getNodeName();
            ICUResourceWriter.Resource res = null;
            if (this.verbose) {
                System.out.print(name + " ");
            }
            if (name.equals("alias")) {
                ICUResourceWriter.ResourceString str = new ICUResourceWriter.ResourceString();
                str.name = "\"%%ALIAS\"";
                str.val = LDMLUtilities.getAttributeValue(node, "source");
                res = str;
                current = null;
                table.first = null;
            } else {
                if (name.equals("identity")) {
                    this.parseIdentity(table, node, xpath);
                    current = this.findLast(table.first);
                    continue;
                }
                if (name.equals("special")) {
                    res = this.parseSpecialElements(node, xpath);
                } else if (name.equals("localeDisplayNames")) {
                    res = this.parseLocaleDisplayNames(node, xpath);
                } else if (name.equals("layout")) {
                    res = this.parseLayout(node, xpath);
                } else if (name.equals("characters")) {
                    res = this.parseCharacters(node, xpath);
                } else if (name.equals("delimiters")) {
                    res = this.parseDelimiters(node, xpath);
                } else if (name.equals("dates")) {
                    res = this.parseDates(node, xpath);
                } else if (name.equals("numbers")) {
                    res = this.parseNumbers(node, xpath);
                } else if (name.equals("collations")) {
                    if (this.locName.equals("root")) {
                        ICUResourceWriter.ResourceProcess process = new ICUResourceWriter.ResourceProcess();
                        process.name = "UCARules";
                        process.ext = "uca_rules";
                        process.val = "../unidata/UCARules.txt";
                        res = process;
                        process.next = this.parseCollations(node, xpath, true);
                    } else {
                        res = this.parseCollations(node, xpath, true);
                    }
                } else if (name.equals("posix")) {
                    res = this.parsePosix(node, xpath);
                } else if (!name.equals("segmentations") && name.indexOf("icu:") <= -1 && name.indexOf("openOffice:") <= -1 && !name.equals("references")) {
                    System.err.println("Encountered unknown <" + root.getNodeName() + "> subelement: " + name);
                    System.exit(-1);
                }
            }
            if (res != null) {
                if (current == null) {
                    table.first = res;
                    current = this.findLast(res);
                } else {
                    current.next = res;
                    current = this.findLast(res);
                }
                res = null;
            }
            xpath.delete(savedLength, xpath.length());
        }
        if (this.sourceDir.indexOf("main") > 0 && !LDMLUtilities.isLocaleAlias(root)) {
            ICUResourceWriter.Resource temp = this.parseWeek();
            if (temp != null) {
                ICUResourceWriter.Resource greg = this.findResource(table, "gregorian");
                ICUResourceWriter.Resource cals = this.findResource(table, "calendar");
                if (greg != null) {
                    this.findLast((ICUResourceWriter.Resource)greg.first).next = temp;
                } else if (cals != null) {
                    greg = new ICUResourceWriter.ResourceTable();
                    greg.name = "gregorian";
                    greg.first = temp;
                    this.findLast((ICUResourceWriter.Resource)cals.first).next = greg;
                } else {
                    greg = new ICUResourceWriter.ResourceTable();
                    greg.name = "gregorian";
                    greg.first = temp;
                    ICUResourceWriter.ResourceTable cal = new ICUResourceWriter.ResourceTable();
                    cal.name = "calendar";
                    cal.first = greg;
                    if (table.first != null) {
                        current.next = cal;
                    } else {
                        table.first = cal;
                    }
                }
            }
            this.findLast((ICUResourceWriter.Resource)table.first).next = temp = this.parseMeasurement();
        }
        if (this.verbose) {
            System.out.println();
        }
        if (this.supplementalDoc != null) {
            // empty if block
        }
        return table;
    }

    private ICUResourceWriter.Resource findLast(ICUResourceWriter.Resource res) {
        ICUResourceWriter.Resource current = res;
        while (current != null) {
            if (current.next == null) {
                return current;
            }
            current = current.next;
        }
        return current;
    }

    private ICUResourceWriter.Resource findResource(ICUResourceWriter.Resource res, String type) {
        ICUResourceWriter.Resource current = res;
        ICUResourceWriter.Resource ret = null;
        while (current != null) {
            if (current.name != null && current.name.equals(type)) {
                return current;
            }
            if (current.first != null) {
                ret = this.findResource(current.first, type);
            }
            if (ret != null) break;
            current = current.next;
        }
        return ret;
    }

    private ICUResourceWriter.Resource parseAliasResource(Node node, StringBuffer xpath) {
        int saveLength = xpath.length();
        this.getXPath(node, xpath);
        try {
            if (node != null && !this.isNodeNotConvertible(node, xpath)) {
                String val;
                ICUResourceWriter.ResourceAlias alias = new ICUResourceWriter.ResourceAlias();
                xpath.setLength(saveLength);
                alias.val = val = LDMLUtilities.convertXPath2ICU(node, null, xpath);
                alias.name = node.getParentNode().getNodeName();
                xpath.setLength(saveLength);
                return alias;
            }
        }
        catch (TransformerException ex) {
            System.err.println("Could not compile XPATH for source:  " + LDMLUtilities.getAttributeValue(node, "source") + " path: " + LDMLUtilities.getAttributeValue(node, "path") + " Node: " + node.getParentNode().getNodeName());
            ex.printStackTrace();
            System.exit(-1);
        }
        xpath.setLength(saveLength);
        return null;
    }

    private StringBuffer getXPath(Node node, StringBuffer xpath) {
        xpath.append("/");
        xpath.append(node.getNodeName());
        LDMLUtilities.appendXPathAttribute(node, xpath);
        return xpath;
    }

    private ICUResourceWriter.Resource parseIdentity(ICUResourceWriter.ResourceTable table, Node root, StringBuffer xpath) {
        String localeID = "";
        ICUResourceWriter.Resource res = null;
        ICUResourceWriter.Resource current = null;
        int savedLength = xpath.length();
        this.getXPath(root, xpath);
        for (Node node = root.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            String name = node.getNodeName();
            if (name.equals("version")) {
                ICUResourceWriter.ResourceString str = new ICUResourceWriter.ResourceString();
                str.val = LDMLUtilities.getAttributeValue(node, "number");
                str.name = (String)keyNameMap.get("version");
                if (this.isNodeNotConvertible(root, new StringBuffer("//ldml"))) {
                    if (!this.isDraftStatusOverridable(this.locName)) {
                        str.val = "x" + str.val;
                    }
                    str.comment = "Draft";
                }
                str.val = str.val.replaceAll(".*?Revision: (.*?) .*", "$1");
                res = str;
            } else if (name.equals("language") || name.equals("script") || name.equals("territory") || name.equals("variant")) {
                String temp = LDMLUtilities.getAttributeValue(node, "type");
                if (temp != null && temp.length() != 0) {
                    if (localeID.length() != 0) {
                        localeID = localeID + "_";
                    }
                    localeID = localeID + temp;
                }
            } else {
                if (name.equals("generation")) continue;
                if (name.equals("alias")) {
                    res = this.parseAliasResource(node, xpath);
                    res.name = table.name;
                    return res;
                }
                System.err.println("Unknown element found: " + name);
                System.exit(-1);
            }
            if (res == null) continue;
            current = current == null ? (table.first = res) : (current.next = res);
            res = null;
        }
        if (localeID.length() == 0) {
            localeID = "root";
        }
        table.name = localeID;
        xpath.delete(savedLength, xpath.length());
        return table;
    }

    private ICUResourceWriter.Resource parseLocaleDisplayNames(Node root, StringBuffer xpath) {
        ICUResourceWriter.Resource first = null;
        ICUResourceWriter.Resource current = null;
        int savedLength = xpath.length();
        this.getXPath(root, xpath);
        int oldLength = xpath.length();
        if (this.isNodeNotConvertible(root, xpath)) {
            xpath.setLength(savedLength);
            return null;
        }
        for (Node node = root.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            String name = node.getNodeName();
            ICUResourceWriter.Resource res = null;
            if (name.equals("languages") || name.equals("scripts") || name.equals("territories") || name.equals("keys") || name.equals("variants") || name.equals("measurementSystemNames")) {
                res = this.parseList(node, xpath);
            } else if (name.equals("types")) {
                res = this.parseDisplayTypes(node, xpath);
            } else if (name.equals("alias")) {
                res = this.parseAliasResource(node, xpath);
            } else if (!name.equals("measurementSystemNames")) {
                System.err.println("Unknown element found: " + name);
                System.exit(-1);
            }
            if (res != null) {
                current = current == null ? (first = res) : (current.next = res);
                res = null;
            }
            xpath.delete(oldLength, xpath.length());
        }
        xpath.delete(savedLength, xpath.length());
        return first;
    }

    private ICUResourceWriter.Resource parseDisplayTypes(Node root, StringBuffer xpath) {
        StringBuffer myXpath = new StringBuffer();
        myXpath.append("//ldml/localeDisplayNames/types/type[@key='");
        int sl = myXpath.length();
        ICUResourceWriter.ResourceTable table = new ICUResourceWriter.ResourceTable();
        table.name = (String)keyNameMap.get("types");
        ICUResourceWriter.ResourceTable current = null;
        int saveLength = xpath.length();
        this.getXPath(root, xpath);
        int oldLength = xpath.length();
        for (int i = 0; i < registeredKeys.length; ++i) {
            myXpath.append(registeredKeys[i]);
            myXpath.append("']");
            NodeList list = LDMLUtilities.getNodeList(root.getOwnerDocument(), myXpath.toString());
            if (list.getLength() != 0) {
                ICUResourceWriter.ResourceTable subTable = new ICUResourceWriter.ResourceTable();
                subTable.name = registeredKeys[i];
                ICUResourceWriter.ResourceString currentString = null;
                for (int j = 0; j < list.getLength(); ++j) {
                    Node item = list.item(j);
                    this.getXPath(item, xpath);
                    String type = LDMLUtilities.getAttributeValue(item, "type");
                    String value = LDMLUtilities.getNodeValue(item);
                    if (this.isNodeNotConvertible(item, xpath)) {
                        xpath.setLength(oldLength);
                        continue;
                    }
                    ICUResourceWriter.ResourceString string = new ICUResourceWriter.ResourceString();
                    string.name = type;
                    string.val = value;
                    if (currentString == null) {
                        currentString = string;
                        subTable.first = currentString;
                    } else {
                        currentString.next = string;
                        currentString = (ICUResourceWriter.ResourceString)currentString.next;
                    }
                    xpath.setLength(oldLength);
                }
                if (subTable.first != null) {
                    if (table.first == null) {
                        current = subTable;
                        table.first = current;
                    } else {
                        current.next = subTable;
                        current = (ICUResourceWriter.ResourceTable)current.next;
                    }
                }
            }
            myXpath.delete(sl, myXpath.length());
        }
        xpath.setLength(saveLength);
        if (table.first != null) {
            return table;
        }
        return null;
    }

    private ICUResourceWriter.Resource parseList(Node root, StringBuffer xpath) {
        ICUResourceWriter.ResourceTable table = new ICUResourceWriter.ResourceTable();
        String rootNodeName = root.getNodeName();
        table.name = (String)keyNameMap.get(rootNodeName);
        ICUResourceWriter.Resource current = null;
        boolean uc = rootNodeName.equals("variants");
        boolean prohibit = rootNodeName.equals("territories");
        int savedLength = xpath.length();
        this.getXPath(root, xpath);
        int oldLength = xpath.length();
        if (this.isNodeNotConvertible(root, xpath)) {
            xpath.setLength(savedLength);
            return null;
        }
        Node alias = LDMLUtilities.getNode(root, "alias", null, null);
        if (alias != null) {
            ICUResourceWriter.Resource res = this.parseAliasResource(alias, xpath);
            res.name = table.name;
            return res;
        }
        for (Node node = root.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            this.getXPath(node, xpath);
            if (this.isNodeNotConvertible(node, xpath)) {
                xpath.setLength(oldLength);
                continue;
            }
            ICUResourceWriter.ResourceString res = new ICUResourceWriter.ResourceString();
            res.name = LDMLUtilities.getAttributeValue(node, "type");
            if (uc) {
                res.name = res.name.toUpperCase();
            }
            res.val = LDMLUtilities.getNodeValue(node);
            if (prohibit && deprecatedTerritories.get(res.name) != null) {
                res = null;
            }
            xpath.delete(oldLength, xpath.length());
            if (res == null) continue;
            if (current == null) {
                table.first = res;
                current = table.first;
                continue;
            }
            current.next = res;
            current = current.next;
        }
        xpath.delete(savedLength, xpath.length());
        if (table.first != null) {
            return table;
        }
        return null;
    }

    private ICUResourceWriter.Resource parseArray(Node root, StringBuffer xpath) {
        ICUResourceWriter.ResourceArray array = new ICUResourceWriter.ResourceArray();
        array.name = (String)keyNameMap.get(root.getNodeName());
        ICUResourceWriter.Resource current = null;
        int savedLength = xpath.length();
        this.getXPath(root, xpath);
        int oldLength = xpath.length();
        if (this.isNodeNotConvertible(root, xpath)) {
            xpath.setLength(oldLength);
            return null;
        }
        for (Node node = root.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            this.getXPath(node, xpath);
            if (this.isNodeNotConvertible(node, xpath)) continue;
            if (current == null) {
                array.first = new ICUResourceWriter.ResourceString();
                current = array.first;
            } else {
                current.next = new ICUResourceWriter.ResourceString();
                current = current.next;
            }
            current.val = LDMLUtilities.getNodeValue(node);
            xpath.delete(oldLength, xpath.length());
        }
        xpath.delete(savedLength, xpath.length());
        if (array.first != null) {
            return array;
        }
        return null;
    }

    private ICUResourceWriter.Resource parseCharacters(Node root, StringBuffer xpath) {
        ICUResourceWriter.Resource current = null;
        ICUResourceWriter.Resource first = null;
        int savedLength = xpath.length();
        this.getXPath(root, xpath);
        int oldLength = xpath.length();
        if (this.isNodeNotConvertible(root, xpath)) {
            xpath.setLength(savedLength);
            return null;
        }
        for (Node node = root.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            String name = node.getNodeName();
            ICUResourceWriter.Resource res = null;
            if (name.equals("exemplarCharacters")) {
                this.getXPath(node, xpath);
                if (this.isNodeNotConvertible(node, xpath)) {
                    xpath.setLength(oldLength);
                    continue;
                }
                res = this.parseStringResource(node);
                res.name = this.isType(node, "auxiliary") ? (String)keyNameMap.get("auxiliary") : (String)keyNameMap.get(node.getNodeName());
            } else if (name.equals("alias")) {
                res = this.parseAliasResource(node, xpath);
            } else if (!name.equals("mapping")) {
                if (name.equals("special")) {
                    res = this.parseSpecialElements(node, xpath);
                } else {
                    System.err.println("Unknown element found: " + name);
                    System.exit(-1);
                }
            }
            if (res != null) {
                if (current == null) {
                    first = res;
                    current = this.findLast(res);
                } else {
                    current.next = res;
                    current = this.findLast(res);
                }
                res = null;
            }
            xpath.delete(oldLength, xpath.length());
        }
        xpath.delete(savedLength, xpath.length());
        return first;
    }

    private ICUResourceWriter.Resource parseStringResource(Node node) {
        ICUResourceWriter.ResourceString str = new ICUResourceWriter.ResourceString();
        str.val = LDMLUtilities.getNodeValue(node);
        str.name = node.getNodeName();
        return str;
    }

    private ICUResourceWriter.Resource parseDelimiters(Node root, StringBuffer xpath) {
        ICUResourceWriter.ResourceTable table = new ICUResourceWriter.ResourceTable();
        table.name = root.getNodeName();
        int saveLength = xpath.length();
        this.getXPath(root, xpath);
        int oldLength = xpath.length();
        if (this.isNodeNotConvertible(root, xpath)) {
            xpath.setLength(saveLength);
            return null;
        }
        ICUResourceWriter.Resource current = table.first;
        for (Node node = root.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            String name = node.getNodeName();
            ICUResourceWriter.Resource res = null;
            if (name.equals("quotationStart") || name.equals("quotationEnd") || name.equals("alternateQuotationStart") || name.equals("alternateQuotationEnd")) {
                this.getXPath(node, xpath);
                if (this.isNodeNotConvertible(node, xpath)) {
                    xpath.setLength(oldLength);
                    continue;
                }
                res = this.parseStringResource(node);
            } else if (name.equals("alias")) {
                res = this.parseAliasResource(node, xpath);
            } else {
                System.err.println("Unknown element found: " + name);
                System.exit(-1);
            }
            if (res != null) {
                current = current == null ? (table.first = res) : (current.next = res);
                res = null;
            }
            xpath.delete(oldLength, xpath.length());
        }
        xpath.setLength(saveLength);
        if (table.first != null) {
            return table;
        }
        return null;
    }

    private ICUResourceWriter.Resource parseMeasurement() {
        String country = ULocale.getCountry((String)this.locName);
        ICUResourceWriter.Resource ret = null;
        String variant = ULocale.getVariant((String)this.locName);
        if (variant.length() != 0) {
            return ret;
        }
        ICUResourceWriter.Resource current = null;
        ICUResourceWriter.Resource first = null;
        StringBuffer xpath = new StringBuffer("//supplementalData/measurementData");
        Node root = LDMLUtilities.getNode(this.supplementalDoc, xpath.toString());
        if (root == null) {
            throw new RuntimeException("Could not load: " + xpath.toString());
        }
        int savedLength = xpath.length();
        int oldLength = xpath.length();
        if (this.isNodeNotConvertible(root, xpath)) {
            return null;
        }
        for (Node node = root.getFirstChild(); node != null; node = node.getNextSibling()) {
            String terr;
            if (node.getNodeType() != 1) continue;
            String name = node.getNodeName();
            ICUResourceWriter.Resource res = null;
            if (name.equals("measurementSystem")) {
                this.getXPath(node, xpath);
                if (this.isNodeNotConvertible(node, xpath)) {
                    xpath.setLength(oldLength);
                    continue;
                }
                terr = LDMLUtilities.getAttributeValue(node, "territories");
                if (terr != null && this.locName.equals("root") && terr.equals("001") || terr.equals(country)) {
                    ICUResourceWriter.ResourceInt resint = new ICUResourceWriter.ResourceInt();
                    String sys = LDMLUtilities.getAttributeValue(node, "type");
                    resint.val = sys.equals("US") ? "1" : "0";
                    resint.name = (String)keyNameMap.get("measurementSystem");
                    res = resint;
                }
            } else if (name.equals("paperSize")) {
                terr = LDMLUtilities.getAttributeValue(node, "territories");
                if (terr != null && this.locName.equals("root") && terr.equals("001") || terr.equals(country)) {
                    ICUResourceWriter.ResourceIntVector vector = new ICUResourceWriter.ResourceIntVector();
                    vector.name = (String)keyNameMap.get(name);
                    ICUResourceWriter.ResourceInt height = new ICUResourceWriter.ResourceInt();
                    ICUResourceWriter.ResourceInt width = new ICUResourceWriter.ResourceInt();
                    vector.first = height;
                    height.next = width;
                    String type = LDMLUtilities.getAttributeValue(node, "type");
                    if (type.equals("A4")) {
                        height.val = "297";
                        width.val = "210";
                    } else if (type.equals("US-Letter")) {
                        height.val = "279";
                        width.val = "216";
                    } else {
                        throw new RuntimeException("Unknown paper type: " + type);
                    }
                    res = vector;
                }
            } else {
                System.err.println("Unknown element found: " + name);
                System.exit(-1);
            }
            if (res != null) {
                current = current == null ? (first = res) : (current.next = res);
                res = null;
            }
            xpath.delete(oldLength, xpath.length());
        }
        xpath.delete(savedLength, xpath.length());
        return first;
    }

    private ICUResourceWriter.Resource parseLayout(Node root, StringBuffer xpath) {
        ICUResourceWriter.Resource current = null;
        ICUResourceWriter.ResourceTable table = new ICUResourceWriter.ResourceTable();
        table.name = root.getNodeName();
        int savedLength = xpath.length();
        this.getXPath(root, xpath);
        int oldLength = xpath.length();
        if (this.isNodeNotConvertible(root, xpath)) {
            xpath.setLength(savedLength);
            return null;
        }
        for (Node node = root.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            String name = node.getNodeName();
            ICUResourceWriter.Resource res = null;
            if (name.equals("alias")) {
                res = this.parseAliasResource(node, xpath);
                return res;
            }
            if (name.equals("inList")) {
                String casing;
                ICUResourceWriter.ResourceString cs = null;
                this.getXPath(node, xpath);
                if (!this.isNodeNotConvertible(node, xpath) && (casing = LDMLUtilities.getAttributeValue(node, "casing")) != null) {
                    cs = new ICUResourceWriter.ResourceString();
                    cs.comment = "Used for figuring out the casing of characters in a list.";
                    cs.name = "casing";
                    cs.val = casing;
                    res = cs;
                }
            } else if (name.equals("orientation")) {
                ICUResourceWriter.ResourceString chs = null;
                ICUResourceWriter.ResourceString lns = null;
                this.getXPath(node, xpath);
                if (!this.isNodeNotConvertible(node, xpath)) {
                    String characters = LDMLUtilities.getAttributeValue(node, "characters");
                    String lines = LDMLUtilities.getAttributeValue(node, "lines");
                    if (characters != null) {
                        chs = new ICUResourceWriter.ResourceString();
                        chs.name = "characters";
                        chs.val = characters;
                    }
                    if (lines != null) {
                        lns = new ICUResourceWriter.ResourceString();
                        lns.name = "lines";
                        lns.val = lines;
                    }
                    if (chs != null) {
                        res = chs;
                        chs.next = lns;
                    } else {
                        res = lns;
                    }
                }
            } else {
                System.err.println("Unknown element found: " + name);
                System.exit(-1);
            }
            if (res != null) {
                current = current == null ? (table.first = res) : (current.next = res);
                res = null;
            }
            xpath.delete(oldLength, xpath.length());
        }
        xpath.delete(savedLength, xpath.length());
        if (table.first != null) {
            return table;
        }
        return null;
    }

    private ICUResourceWriter.Resource parseDates(Node root, StringBuffer xpath) {
        ICUResourceWriter.Resource first = null;
        ICUResourceWriter.Resource current = null;
        int savedLength = xpath.length();
        this.getXPath(root, xpath);
        int oldLength = xpath.length();
        if (this.isNodeNotConvertible(root, xpath)) {
            xpath.setLength(savedLength);
            return null;
        }
        for (Node node = root.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            String name = node.getNodeName();
            ICUResourceWriter.Resource res = null;
            if (name.equals("alias")) {
                res = this.parseAliasResource(node, xpath);
            } else if (name.equals("default")) {
                this.getXPath(node, xpath);
                if (this.isNodeNotConvertible(node, xpath)) {
                    xpath.setLength(oldLength);
                    continue;
                }
                res = this.getDefaultResource(node, xpath, name);
            } else if (name.equals("localizedPatternChars")) {
                this.getXPath(node, xpath);
                if (this.isNodeNotConvertible(node, xpath)) {
                    xpath.setLength(oldLength);
                    continue;
                }
                ICUResourceWriter.ResourceString str = new ICUResourceWriter.ResourceString();
                str.name = (String)keyNameMap.get(name);
                str.val = LDMLUtilities.getNodeValue(node);
                res = str;
            } else if (name.equals("calendars")) {
                res = this.parseCalendars(node, xpath);
            } else if (name.equals("timeZoneNames")) {
                res = this.parseTimeZoneNames(node, xpath);
            } else {
                System.err.println("Encountered unknown <" + root.getNodeName() + "> subelement: " + name);
                System.exit(-1);
            }
            if (res != null) {
                current = current == null ? (first = res) : (current.next = res);
                res = null;
            }
            xpath.delete(oldLength, xpath.length());
        }
        xpath.delete(savedLength, xpath.length());
        return first;
    }

    private ICUResourceWriter.Resource parseCalendars(Node root, StringBuffer xpath) {
        ICUResourceWriter.ResourceTable table = new ICUResourceWriter.ResourceTable();
        ICUResourceWriter.Resource current = null;
        table.name = "calendar";
        int savedLength = xpath.length();
        this.getXPath(root, xpath);
        int oldLength = xpath.length();
        if (this.isNodeNotConvertible(root, xpath)) {
            return null;
        }
        for (Node node = root.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            String name = node.getNodeName();
            ICUResourceWriter.Resource res = null;
            if (name.equals("alias")) {
                res = this.parseAliasResource(node, xpath);
                res.name = table.name;
                return res;
            }
            if (name.equals("default")) {
                res = this.getDefaultResource(node, xpath, name);
            } else if (name.equals("calendar")) {
                res = this.parseCalendar(node, xpath);
            } else {
                System.err.println("Encountered unknown <" + root.getNodeName() + "> subelement: " + name);
                System.exit(-1);
            }
            if (res != null) {
                current = current == null ? (table.first = res) : (current.next = res);
                res = null;
            }
            xpath.delete(oldLength, xpath.length());
        }
        xpath.delete(savedLength, xpath.length());
        if (table.first != null) {
            return table;
        }
        return null;
    }

    private ICUResourceWriter.Resource parseTimeZoneNames(Node root, StringBuffer xpath) {
        ICUResourceWriter.ResourceTable table = new ICUResourceWriter.ResourceTable();
        ICUResourceWriter.Resource current = null;
        table.name = (String)keyNameMap.get(root.getNodeName());
        int savedLength = xpath.length();
        this.getXPath(root, xpath);
        int oldLength = xpath.length();
        if (this.isNodeNotConvertible(root, xpath)) {
            xpath.setLength(savedLength);
            return null;
        }
        for (Node node = root.getFirstChild(); node != null; node = node.getNextSibling()) {
            ICUResourceWriter.ResourceString str;
            if (node.getNodeType() != 1) continue;
            String name = node.getNodeName();
            ICUResourceWriter.Resource res = null;
            if (name.equals("alias")) {
                res = this.parseAliasResource(node, xpath);
                res.name = table.name;
                return res;
            }
            if (name.equals("default")) {
                res = this.getDefaultResource(node, xpath, name);
            } else if (name.equals("zone")) {
                res = this.parseZone(node, xpath);
            } else if (name.equals("hourFormat") || name.equals("hoursFormat") || name.equals("gmtFormat") || name.equals("regionFormat") || name.equals("fallbackFormat")) {
                this.getXPath(node, xpath);
                if (this.isNodeNotConvertible(node, xpath)) {
                    xpath.setLength(oldLength);
                    continue;
                }
                str = new ICUResourceWriter.ResourceString();
                str.name = name;
                str.val = LDMLUtilities.getNodeValue(node);
                if (str.val != null) {
                    res = str;
                }
            } else if (name.equals("abbreviationFallback")) {
                str = new ICUResourceWriter.ResourceString();
                str.name = name;
                str.val = LDMLUtilities.getAttributeValue(node, "type");
                if (str.val != null) {
                    res = str;
                }
            } else if (name.equals("preferenceOrdering") || name.equals("singleCountries")) {
                ICUResourceWriter.ResourceArray arr = new ICUResourceWriter.ResourceArray();
                arr.name = name;
                ICUResourceWriter.Resource c = null;
                String[] values = null;
                if (name.equals("singleCountries")) {
                    values = LDMLUtilities.getAttributeValue(node, "list").split(" ");
                } else {
                    String temp = LDMLUtilities.getAttributeValue(node, "choice");
                    if (temp == null && (temp = LDMLUtilities.getAttributeValue(node, "type")) == null) {
                        throw new IllegalArgumentException("Node: " + name + "  must have either type or choice attribute");
                    }
                    values = temp.split("\\s+");
                }
                for (int i = 0; i < values.length; ++i) {
                    ICUResourceWriter.ResourceString str2 = new ICUResourceWriter.ResourceString();
                    str2.val = values[i];
                    if (c == null) {
                        c = str2;
                        arr.first = c;
                        continue;
                    }
                    c.next = str2;
                    c = c.next;
                }
                if (arr.first != null) {
                    res = arr;
                }
            } else {
                System.err.println("Encountered unknown <" + root.getNodeName() + "> subelement: " + name);
                System.exit(-1);
            }
            if (res != null) {
                current = current == null ? (table.first = res) : (current.next = res);
                res = null;
            }
            xpath.delete(oldLength, xpath.length());
        }
        xpath.delete(savedLength, xpath.length());
        if (table.first != null) {
            return table;
        }
        return null;
    }

    private ICUResourceWriter.Resource getStringResource(String name, Node node, ICUResourceWriter.Resource res) {
        ICUResourceWriter.ResourceString str = new ICUResourceWriter.ResourceString();
        str.name = name;
        str.val = LDMLUtilities.getNodeValue(node);
        if (res == null) {
            res = str;
        } else {
            this.findLast((ICUResourceWriter.Resource)res).next = str;
        }
        if (str.val == null) {
            str.val = "";
        }
        return res;
    }

    private ICUResourceWriter.ResourceString getDefaultResource(Node node, StringBuffer xpath, String name) {
        ICUResourceWriter.ResourceString str = new ICUResourceWriter.ResourceString();
        String temp = LDMLUtilities.getAttributeValue(node, "choice");
        if (temp == null && (temp = LDMLUtilities.getAttributeValue(node, "type")) == null) {
            throw new IllegalArgumentException("Node: " + name + "  must have either type or choice attribute");
        }
        str.name = name;
        str.val = temp;
        return str;
    }

    private ICUResourceWriter.Resource parseZone(Node root, StringBuffer xpath) {
        ICUResourceWriter.ResourceTable table = new ICUResourceWriter.ResourceTable();
        boolean writtenEC = false;
        boolean isECDraft = false;
        int savedLength = xpath.length();
        this.getXPath(root, xpath);
        int oldLength = xpath.length();
        if (this.isNodeNotConvertible(root, xpath)) {
            xpath.setLength(savedLength);
            return null;
        }
        String id = LDMLUtilities.getAttributeValue(root, "type");
        table.name = "\"" + id + "\"";
        table.name = table.name.replace('/', ':');
        ICUResourceWriter.Resource current = null;
        for (Node node = root.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            String name = node.getNodeName();
            ICUResourceWriter.Resource res = null;
            this.getXPath(node, xpath);
            if (this.isNodeNotConvertible(node, xpath)) {
                if (name.equals("exemplarCity")) {
                    isECDraft = true;
                }
                xpath.setLength(oldLength);
                continue;
            }
            if (name.equals("alias")) {
                res = this.parseAliasResource(node, xpath);
                if (res != null) {
                    res.name = table.name;
                }
                return res;
            }
            if (name.equals("default")) {
                res = this.getDefaultResource(node, xpath, name);
            } else if (name.equals("long") || name.equals("short")) {
                Node standard = LDMLUtilities.getNode(node, "standard");
                Node generic = LDMLUtilities.getNode(node, "generic");
                Node daylight = LDMLUtilities.getNode(node, "daylight");
                if (standard != null) {
                    res = this.getStringResource(name.charAt(0) + "s", standard, res);
                }
                if (generic != null) {
                    res = this.getStringResource(name.charAt(0) + "g", generic, res);
                }
                if (daylight != null) {
                    res = this.getStringResource(name.charAt(0) + "d", daylight, res);
                }
            } else if (name.equals("exemplarCity")) {
                String ec = LDMLUtilities.getNodeValue(node);
                if (ec != null) {
                    ICUResourceWriter.ResourceString str = new ICUResourceWriter.ResourceString();
                    str.name = "ec";
                    str.val = ec;
                    res = str;
                    writtenEC = true;
                }
            } else {
                System.err.println("Encountered unknown <" + root.getNodeName() + "> subelement: " + name);
                System.exit(-1);
            }
            if (res != null) {
                if (current == null) {
                    table.first = res;
                    current = this.findLast(res);
                } else {
                    current.next = res;
                    current = this.findLast(res);
                }
                res = null;
            }
            xpath.delete(oldLength, xpath.length());
        }
        if (!writtenEC && !isECDraft) {
            ICUResourceWriter.ResourceString str = new ICUResourceWriter.ResourceString();
            str.name = "ec";
            str.val = id.replaceAll(".*?/(.*)", "$1").replaceAll("_", " ");
            if (current == null) {
                table.first = str;
            } else {
                current.next = str;
            }
        }
        xpath.delete(savedLength, xpath.length());
        if (table.first != null) {
            return table;
        }
        return null;
    }

    private ICUResourceWriter.Resource parseLeapMonth() {
        Node root;
        if (this.specialsDoc != null && (root = LDMLUtilities.getNode(this.specialsDoc, "//ldml/dates/calendars/calendar[@type='chinese']/special")) != null) {
            for (Node node = root.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (node.getNodeType() != 1) continue;
                String name = node.getNodeName();
                if (name.equals(ICU_IS_LEAP_MONTH)) {
                    Node nonLeapSymbol = LDMLUtilities.getNode(node, "icu:nonLeapSymbol", root);
                    Node leapSymbol = LDMLUtilities.getNode(node, "icu:leapSymbol", root);
                    if (nonLeapSymbol != null && leapSymbol != null) {
                        ICUResourceWriter.ResourceArray arr = new ICUResourceWriter.ResourceArray();
                        arr.name = "isLeapMonth";
                        ICUResourceWriter.ResourceString str1 = new ICUResourceWriter.ResourceString();
                        ICUResourceWriter.ResourceString str2 = new ICUResourceWriter.ResourceString();
                        str1.val = LDMLUtilities.getNodeValue(nonLeapSymbol);
                        if (str1.val == null) {
                            str1.val = "";
                        }
                        str2.val = LDMLUtilities.getNodeValue(leapSymbol);
                        arr.first = str1;
                        str1.next = str2;
                        return arr;
                    }
                    System.err.println("Did not get required number of elements for isLeapMonth resource. Please check the data.");
                    System.exit(-1);
                    continue;
                }
                System.err.println("Encountered unknown <" + root.getNodeName() + "> subelement: " + name);
                System.exit(-1);
            }
        }
        return null;
    }

    private ICUResourceWriter.Resource parseCalendar(Node root, StringBuffer xpath) {
        ICUResourceWriter.ResourceTable table = new ICUResourceWriter.ResourceTable();
        ICUResourceWriter.Resource current = null;
        int savedLength = xpath.length();
        this.getXPath(root, xpath);
        int oldLength = xpath.length();
        if (this.isNodeNotConvertible(root, xpath)) {
            return null;
        }
        boolean writtenAmPm = false;
        boolean writtenDTF = false;
        table.name = LDMLUtilities.getAttributeValue(root, "type");
        for (Node node = root.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            String name = node.getNodeName();
            ICUResourceWriter.Resource res = null;
            if (name.equals("alias")) {
                res = this.parseAliasResource(node, xpath);
                if (res != null) {
                    res.name = table.name;
                }
                return res;
            }
            if (name.equals("default")) {
                res = this.getDefaultResource(node, xpath, name);
            } else if (name.equals("months") || name.equals("days")) {
                res = this.parseMonthsAndDays(node, xpath);
            } else if (name.equals("week")) {
                this.printInfo("<week> element is deprecated and the data should moved to supplementalData.xml");
            } else if (name.equals("am") || name.equals("pm")) {
                if (!writtenAmPm) {
                    res = this.parseAmPm(node, xpath);
                    writtenAmPm = true;
                }
            } else if (name.equals("eras")) {
                res = this.parseEras(node, xpath);
            } else if (name.equals("dateFormats") || name.equals("timeFormats") || name.equals("dateTimeFormats")) {
                if (!writtenDTF) {
                    res = this.parseDTF(node, xpath);
                    writtenDTF = true;
                }
                if (name.equals("dateTimeFormats")) {
                    ICUResourceWriter.Resource temp = this.parseFlexibleFormats(node, xpath);
                    if (res != null) {
                        this.findLast((ICUResourceWriter.Resource)res).next = temp;
                    } else {
                        res = temp;
                    }
                }
            } else if (name.equals("special")) {
                res = this.parseSpecialElements(node, xpath);
            } else if (name.equals("fields")) {
                res = this.parseFields(node, xpath);
            } else if (name.equals("quarters")) {
                res = this.parseMonthsAndDays(node, xpath);
            } else {
                System.err.println("Encountered unknown <" + root.getNodeName() + "> subelement: " + name);
                System.exit(-1);
            }
            if (res != null) {
                if (current == null) {
                    table.first = res;
                    current = this.findLast(res);
                } else {
                    current.next = res;
                    current = this.findLast(res);
                }
                res = null;
            }
            xpath.delete(oldLength, xpath.length());
        }
        if (table.name.equals("chinese") && table.first != null) {
            this.findLast((ICUResourceWriter.Resource)table.first).next = this.parseLeapMonth();
        }
        xpath.delete(savedLength, xpath.length());
        if (table.first != null) {
            return table;
        }
        return null;
    }

    private ICUResourceWriter.Resource parseFields(Node root, StringBuffer xpath) {
        ICUResourceWriter.ResourceTable table = new ICUResourceWriter.ResourceTable();
        ICUResourceWriter.Resource current = null;
        table.name = root.getNodeName();
        int savedLength = xpath.length();
        this.getXPath(root, xpath);
        int oldLength = xpath.length();
        if (this.isNodeNotConvertible(root, xpath)) {
            xpath.setLength(savedLength);
            return null;
        }
        for (Node node = root.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            String name = node.getNodeName();
            ICUResourceWriter.Resource res = null;
            if (name.equals("alias")) {
                res = this.parseAliasResource(node, xpath);
                res.name = table.name;
                return res;
            }
            if (name.equals("field")) {
                res = this.parseField(node, xpath);
            } else {
                System.err.println("Encountered unknown <" + root.getNodeName() + "> subelement: " + name);
                System.exit(-1);
            }
            if (res != null) {
                current = current == null ? (table.first = res) : (current.next = res);
                res = null;
            }
            xpath.delete(oldLength, xpath.length());
        }
        xpath.delete(savedLength, xpath.length());
        if (table.first != null) {
            return table;
        }
        return null;
    }

    private ICUResourceWriter.Resource parseField(Node root, StringBuffer xpath) {
        ICUResourceWriter.ResourceTable table = new ICUResourceWriter.ResourceTable();
        ICUResourceWriter.Resource current = null;
        table.name = LDMLUtilities.getAttributeValue(root, "type");
        ICUResourceWriter.ResourceString dn = null;
        ICUResourceWriter.ResourceTable relative = new ICUResourceWriter.ResourceTable();
        relative.name = "relative";
        int savedLength = xpath.length();
        this.getXPath(root, xpath);
        int oldLength = xpath.length();
        if (this.isNodeNotConvertible(root, xpath)) {
            xpath.setLength(savedLength);
            return null;
        }
        for (Node node = root.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            String name = node.getNodeName();
            ICUResourceWriter.Resource res = null;
            if (name.equals("alias")) {
                res = this.parseAliasResource(node, xpath);
                res.name = table.name;
                return res;
            }
            if (name.equals("relative")) {
                this.getXPath(node, xpath);
                if (!this.isNodeNotConvertible(root, xpath)) {
                    ICUResourceWriter.ResourceString str = new ICUResourceWriter.ResourceString();
                    str.name = "\"" + LDMLUtilities.getAttributeValue(node, "type") + "\"";
                    str.val = LDMLUtilities.getNodeValue(node);
                    res = str;
                    if (res != null) {
                        current = current == null ? (relative.first = res) : (current.next = res);
                        res = null;
                    }
                }
            } else if (name.equals("displayName")) {
                this.getXPath(node, xpath);
                if (!this.isNodeNotConvertible(root, xpath)) {
                    dn = new ICUResourceWriter.ResourceString();
                    dn.name = (String)keyNameMap.get("displayName");
                    dn.val = LDMLUtilities.getNodeValue(node);
                }
            } else {
                System.err.println("Encountered unknown <" + root.getNodeName() + "> subelement: " + name);
                System.exit(-1);
            }
            xpath.delete(oldLength, xpath.length());
        }
        if (dn != null) {
            table.first = dn;
        }
        if (relative.first != null) {
            if (table.first != null) {
                table.first.next = relative;
            } else {
                table.first = relative;
            }
        }
        xpath.delete(savedLength, xpath.length());
        if (table.first != null) {
            return table;
        }
        return null;
    }

    private ICUResourceWriter.Resource parseMonthsAndDays(Node root, StringBuffer xpath) {
        ICUResourceWriter.ResourceTable table = new ICUResourceWriter.ResourceTable();
        ICUResourceWriter.Resource current = null;
        table.name = (String)keyNameMap.get(root.getNodeName());
        int savedLength = xpath.length();
        this.getXPath(root, xpath);
        int oldLength = xpath.length();
        if (this.isNodeNotConvertible(root, xpath)) {
            xpath.setLength(savedLength);
            return null;
        }
        for (Node node = root.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            String name = node.getNodeName();
            ICUResourceWriter.Resource res = null;
            if (name.equals("alias")) {
                res = this.parseAliasResource(node, xpath);
                res.name = table.name;
                return res;
            }
            if (name.equals("default")) {
                res = this.getDefaultResource(node, xpath, name);
            } else if (name.equals("monthContext") || name.equals("dayContext") || name.equals("quarterContext")) {
                res = this.parseContext(node, xpath);
            } else {
                System.err.println("Encountered unknown <" + root.getNodeName() + "> subelement: " + name);
                System.exit(-1);
            }
            if (res != null) {
                current = current == null ? (table.first = res) : (current.next = res);
                res = null;
            }
            xpath.delete(oldLength, xpath.length());
        }
        xpath.delete(savedLength, xpath.length());
        if (table.first != null) {
            return table;
        }
        return null;
    }

    private ICUResourceWriter.Resource parseContext(Node root, StringBuffer xpath) {
        ICUResourceWriter.ResourceTable table = new ICUResourceWriter.ResourceTable();
        ICUResourceWriter.Resource current = null;
        table.name = LDMLUtilities.getAttributeValue(root, "type");
        int savedLength = xpath.length();
        this.getXPath(root, xpath);
        int oldLength = xpath.length();
        if (this.isNodeNotConvertible(root, xpath)) {
            xpath.setLength(savedLength);
            return null;
        }
        String resName = root.getNodeName();
        resName = resName.substring(0, resName.lastIndexOf("Context"));
        for (Node node = root.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            String name = node.getNodeName();
            ICUResourceWriter.Resource res = null;
            if (name.equals("alias")) {
                res = this.parseAliasResource(node, xpath);
                if (res != null) {
                    res.name = table.name;
                }
                return res;
            }
            if (name.equals("default")) {
                res = this.getDefaultResource(node, xpath, name);
            } else if (name.equals(resName + "Width")) {
                res = this.parseWidth(node, resName, xpath);
            } else {
                System.err.println("Encountered unknown <" + root.getNodeName() + "> subelement: " + name);
                System.exit(-1);
            }
            if (res != null) {
                current = current == null ? (table.first = res) : (current.next = res);
                res = null;
            }
            xpath.delete(oldLength, xpath.length());
        }
        xpath.delete(savedLength, xpath.length());
        if (table.first != null) {
            return table;
        }
        return null;
    }

    private String getDayNumberAsString(String type) {
        if (type.equals("sun")) {
            return "1";
        }
        if (type.equals("mon")) {
            return "2";
        }
        if (type.equals("tue")) {
            return "3";
        }
        if (type.equals("wed")) {
            return "4";
        }
        if (type.equals("thu")) {
            return "5";
        }
        if (type.equals("fri")) {
            return "6";
        }
        if (type.equals("sat")) {
            return "7";
        }
        throw new IllegalArgumentException("Unknown type: " + type);
    }

    private ICUResourceWriter.Resource parseWidth(Node root, String resName, StringBuffer xpath) {
        Node def;
        ICUResourceWriter.ResourceArray array = new ICUResourceWriter.ResourceArray();
        ICUResourceWriter.Resource current = null;
        array.name = LDMLUtilities.getAttributeValue(root, "type");
        int savedLength = xpath.length();
        this.getXPath(root, xpath);
        if (this.isNodeNotConvertible(root, xpath)) {
            xpath.setLength(savedLength);
            return null;
        }
        Node alias = LDMLUtilities.getNode(root, "alias", null, null);
        if (alias != null) {
            ICUResourceWriter.Resource res = this.parseAliasResource(alias, xpath);
            if (res != null) {
                res.name = LDMLUtilities.getAttributeValue(root, "type");
            }
            return res;
        }
        TreeMap map = this.getElementsMap(root, xpath);
        TreeMap defMap = null;
        if (this.fullyResolvedDoc != null) {
            defMap = this.getElementsMap(LDMLUtilities.getNode(this.fullyResolvedDoc, xpath.toString()), xpath, true);
        }
        if (defMap != null && map.size() != defMap.size()) {
            map = defMap;
            if (resName.equals("day") && map.size() < 7 || resName.equals("month") && map.size() < 12) {
                this.printError("", "Could not get full month names or day names array. Fatal error exiting");
            }
        }
        if (map.size() > 0) {
            for (int i = 0; i < map.size(); ++i) {
                String key = Integer.toString(i);
                ICUResourceWriter.ResourceString res = new ICUResourceWriter.ResourceString();
                res.val = (String)map.get(key);
                if (res.val == null) continue;
                if (current == null) {
                    array.first = res;
                    current = array.first;
                    continue;
                }
                current.next = res;
                current = current.next;
            }
        }
        if ((def = LDMLUtilities.getNode(root, "default", null, null)) != null) {
            ICUResourceWriter.ResourceString res = this.getDefaultResource(def, xpath, "default");
            if (current == null) {
                array.first = res;
                current = array.first;
            } else {
                current.next = res;
                current = current.next;
            }
        }
        if (array.first != null) {
            return array;
        }
        xpath.delete(savedLength, xpath.length());
        return null;
    }

    private TreeMap getElementsMap(Node root, StringBuffer xpath) {
        return this.getElementsMap(root, xpath, false);
    }

    private TreeMap getElementsMap(Node root, StringBuffer xpath, boolean isNodeFromRoot) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        int saveLength = xpath.length();
        for (Node node = root.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            this.getXPath(node, xpath);
            if (this.isNodeNotConvertible(node, xpath) && !isNodeFromRoot) {
                xpath.setLength(saveLength);
                continue;
            }
            String name = node.getNodeName();
            String val = LDMLUtilities.getNodeValue(node);
            String type = LDMLUtilities.getAttributeValue(node, "type");
            if (name.equals("day")) {
                map.put(LDMLUtilities.getDayIndexAsString(type), val);
            } else if (name.equals("month")) {
                map.put(LDMLUtilities.getMonthIndexAsString(type), val);
            } else if (name.equals("era")) {
                map.put(type, val);
            } else if (name.equals("quarter")) {
                map.put(LDMLUtilities.getMonthIndexAsString(type), val);
            } else {
                System.err.println("Encountered unknown <" + root.getNodeName() + "> subelement: " + name);
                System.exit(-1);
            }
            xpath.setLength(saveLength);
        }
        return map;
    }

    private ICUResourceWriter.Resource parseWeek() {
        String country = ULocale.getCountry((String)this.locName);
        ICUResourceWriter.Resource ret = null;
        String variant = ULocale.getVariant((String)this.locName);
        if (variant.length() != 0) {
            return ret;
        }
        StringBuffer xpath = new StringBuffer("//supplementalData/weekData");
        Node root = LDMLUtilities.getNode(this.supplementalDoc, xpath.toString());
        if (root != null) {
            ICUResourceWriter.Resource week = this.parseWeekend(root, xpath, country);
            ICUResourceWriter.Resource dte = this.parseDTE(root, xpath, country);
            if (week != null) {
                week.next = dte;
                ret = week;
            } else {
                ret = dte;
            }
        }
        return ret;
    }

    private int getMillis(String time) {
        String[] strings = time.split(":");
        int hours = Integer.parseInt(strings[0]);
        int minutes = Integer.parseInt(strings[1]);
        return (hours * 60 + minutes) * 60 * 1000;
    }

    private Node getVettedNode(Node ctx, String node, String attrb, String attrbVal, StringBuffer xpath) {
        int savedLength = xpath.length();
        NodeList list = LDMLUtilities.getNodeList(ctx, node, null, xpath.toString());
        Node ret = null;
        for (int i = 0; i < list.getLength(); ++i) {
            Node item = list.item(i);
            String val = LDMLUtilities.getAttributeValue(item, attrb);
            this.getXPath(item, xpath);
            if (val.matches(".*\\b" + attrbVal + "\\b.*")) {
                if (this.isNodeNotConvertible(item, xpath)) break;
                ret = item;
                break;
            }
            xpath.setLength(savedLength);
        }
        xpath.setLength(savedLength);
        return ret;
    }

    private ICUResourceWriter.Resource parseWeekend(Node root, StringBuffer xpath, String country) {
        Node wkendStart = null;
        Node wkendEnd = null;
        if (country.length() > 0) {
            wkendStart = this.getVettedNode(root, "weekendStart", "territories", country, xpath);
            wkendEnd = this.getVettedNode(root, "weekendEnd", "territories", country, xpath);
        }
        if (wkendEnd != null || wkendStart != null || this.locName.equals("root")) {
            if (wkendStart == null && (wkendStart = this.getVettedNode(null, root, "weekendStart[@territories='001']", xpath, true)) == null) {
                this.printError("parseWeekend", "Could not find weekendStart resource.");
            }
            if (wkendEnd == null && (wkendEnd = this.getVettedNode(null, root, "weekendEnd[@territories='001']", xpath, true)) == null) {
                this.printError("parseWeekend", "Could not find weekendEnd resource.");
            }
        }
        ICUResourceWriter.ResourceIntVector wkend = null;
        if (wkendStart != null && wkendEnd != null) {
            try {
                wkend = new ICUResourceWriter.ResourceIntVector();
                wkend.name = "weekend";
                ICUResourceWriter.ResourceInt startday = new ICUResourceWriter.ResourceInt();
                startday.val = this.getDayNumberAsString(LDMLUtilities.getAttributeValue(wkendStart, "day"));
                ICUResourceWriter.ResourceInt starttime = new ICUResourceWriter.ResourceInt();
                String time = LDMLUtilities.getAttributeValue(wkendStart, "time");
                starttime.val = Integer.toString(this.getMillis(time == null ? "00:00" : time));
                ICUResourceWriter.ResourceInt endday = new ICUResourceWriter.ResourceInt();
                endday.val = this.getDayNumberAsString(LDMLUtilities.getAttributeValue(wkendEnd, "day"));
                ICUResourceWriter.ResourceInt endtime = new ICUResourceWriter.ResourceInt();
                time = LDMLUtilities.getAttributeValue(wkendEnd, "time");
                endtime.val = Integer.toString(this.getMillis(time == null ? "24:00" : time));
                wkend.first = startday;
                startday.next = starttime;
                starttime.next = endday;
                endday.next = endtime;
            }
            catch (NullPointerException ex) {
                throw new RuntimeException(ex);
            }
        }
        return wkend;
    }

    private ICUResourceWriter.Resource parseDTE(Node root, StringBuffer xpath, String country) {
        Node minDays = null;
        Node firstDay = null;
        ICUResourceWriter.ResourceIntVector dte = null;
        if (country.length() > 0) {
            minDays = this.getVettedNode(root, "minDays", "territories", country, xpath);
            firstDay = this.getVettedNode(root, "firstDay", "territories", country, xpath);
        }
        if (minDays != null || firstDay != null || this.locName.equals("root")) {
            if (minDays == null && (minDays = this.getVettedNode(null, root, "minDays[@territories='001']", xpath, true)) == null) {
                this.printError("parseDTE", "Could not find minDays resource.");
            }
            if (firstDay == null && (firstDay = this.getVettedNode(null, root, "firstDay[@territories='001']", xpath, true)) == null) {
                this.printError("parseDTE", "Could not find firstDay resource.");
            }
        }
        if (minDays != null && firstDay != null) {
            dte = new ICUResourceWriter.ResourceIntVector();
            ICUResourceWriter.ResourceInt int1 = new ICUResourceWriter.ResourceInt();
            int1.val = this.getDayNumberAsString(LDMLUtilities.getAttributeValue(firstDay, "day"));
            ICUResourceWriter.ResourceInt int2 = new ICUResourceWriter.ResourceInt();
            int2.val = LDMLUtilities.getAttributeValue(minDays, "count");
            dte.name = DTE;
            dte.first = int1;
            int1.next = int2;
        }
        if (minDays == null && firstDay != null || minDays != null && firstDay == null) {
            System.err.println("WARNING: Could not find minDays=" + minDays + " or firstDay=" + firstDay + " from fullyResolved locale. Not producing the resource. " + xpath.toString());
            return null;
        }
        return dte;
    }

    private ICUResourceWriter.Resource parseEras(Node root, StringBuffer xpath) {
        ICUResourceWriter.ResourceTable table = new ICUResourceWriter.ResourceTable();
        ICUResourceWriter.Resource current = null;
        int savedLength = xpath.length();
        this.getXPath(root, xpath);
        int oldLength = xpath.length();
        if (this.isNodeNotConvertible(root, xpath)) {
            xpath.setLength(savedLength);
            return null;
        }
        table.name = "eras";
        for (Node node = root.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            String name = node.getNodeName();
            ICUResourceWriter.Resource res = null;
            if (name.equals("alias")) {
                res = this.parseAliasResource(node, xpath);
                res.name = table.name;
                return res;
            }
            if (name.equals("default")) {
                res = this.getDefaultResource(node, xpath, name);
            } else if (name.equals("eraAbbr")) {
                res = this.parseEra(node, xpath, "abbreviated");
            } else if (name.equals("eraNames")) {
                res = this.parseEra(node, xpath, "wide");
            } else if (name.equals("eraNarrow")) {
                res = this.parseEra(node, xpath, "narrow");
            } else {
                System.err.println("Encountered unknown <" + root.getNodeName() + "> subelement: " + name);
                System.exit(-1);
            }
            if (res != null) {
                if (current == null) {
                    table.first = res;
                    current = this.findLast(res);
                } else {
                    current.next = res;
                    current = this.findLast(res);
                }
                res = null;
            }
            xpath.delete(oldLength, xpath.length());
        }
        xpath.delete(savedLength, xpath.length());
        if (table.first != null) {
            return table;
        }
        return null;
    }

    private ICUResourceWriter.Resource parseEra(Node root, StringBuffer xpath, String name) {
        ICUResourceWriter.ResourceArray array = new ICUResourceWriter.ResourceArray();
        ICUResourceWriter.Resource current = null;
        array.name = name;
        int savedLength = xpath.length();
        this.getXPath(root, xpath);
        if (this.isNodeNotConvertible(root, xpath)) {
            xpath.setLength(savedLength);
            return null;
        }
        Node alias = LDMLUtilities.getNode(root, "alias", null, null);
        if (alias != null) {
            ICUResourceWriter.Resource res = this.parseAliasResource(alias, xpath);
            if (res != null) {
                String type = LDMLUtilities.getAttributeValue(root, "type");
                res.name = type != null ? type : name;
            }
            return res;
        }
        TreeMap map = this.getElementsMap(root, xpath);
        if (map.size() > 0) {
            for (int i = 0; i < map.size(); ++i) {
                String key = Integer.toString(i);
                ICUResourceWriter.ResourceString res = new ICUResourceWriter.ResourceString();
                res.val = (String)map.get(key);
                if (res.val == null) continue;
                if (current == null) {
                    array.first = res;
                    current = array.first;
                    continue;
                }
                current.next = res;
                current = current.next;
            }
        }
        xpath.delete(savedLength, xpath.length());
        if (array.first != null) {
            return array;
        }
        return null;
    }

    private boolean isNodeNotConvertible(Node node, StringBuffer xpath) {
        return this.isNodeNotConvertible(node, xpath, false, false);
    }

    private boolean isNodeNotConvertible(Node node, StringBuffer xpath, boolean isCollation, boolean isNodeFromParent) {
        if (LDMLUtilities.areChildrenElementNodes(node) && !isCollation) {
            return false;
        }
        if (isNodeFromParent) {
            return false;
        }
        return !this.xpathList.contains(xpath.toString());
    }

    private Node getVettedNode(Node parent, String childName, StringBuffer xpath) {
        return this.getVettedNode(this.fullyResolvedDoc, parent, childName, xpath, true);
    }

    public Node getVettedNode(Document fullyResolvedDoc, Node parent, String childName, StringBuffer xpath, boolean ignoreDraft) {
        String ctx = "./" + childName;
        NodeList list = LDMLUtilities.getNodeList(parent, ctx);
        int saveLength = xpath.length();
        Node ret = null;
        if (list == null || list.getLength() < 0) {
            if (fullyResolvedDoc != null) {
                int oldLength = xpath.length();
                xpath.append("/");
                xpath.append(childName);
                list = LDMLUtilities.getNodeList(fullyResolvedDoc, xpath.toString());
                if (list != null && list.getLength() > 0) {
                    ret = list.item(0);
                }
                xpath.setLength(oldLength);
            }
        } else {
            int end = childName.lastIndexOf(47);
            if (end > 0) {
                xpath.append('/');
                xpath.append(childName.substring(0, end));
            }
            ret = this.getVettedNode(list, xpath, ignoreDraft);
        }
        xpath.setLength(saveLength);
        return ret;
    }

    private Node getVettedNode(NodeList list, StringBuffer xpath, boolean ignoreDraft) {
        Node node = null;
        int oldLength = xpath.length();
        for (int i = 0; i < list.getLength(); ++i) {
            node = list.item(i);
            this.getXPath(node, xpath);
            if (!this.isNodeNotConvertible(node, xpath)) break;
            xpath.setLength(oldLength);
            node = null;
        }
        xpath.setLength(oldLength);
        return node;
    }

    private ICUResourceWriter.Resource parseAmPm(Node root, StringBuffer xpath) {
        Node parent = root.getParentNode();
        Node amNode = this.getVettedNode(parent, "am", xpath);
        Node pmNode = this.getVettedNode(parent, "pm", xpath);
        ICUResourceWriter.ResourceArray arr = null;
        if (amNode != null && pmNode != null) {
            arr = new ICUResourceWriter.ResourceArray();
            arr.name = AM_PM_MARKERS;
            ICUResourceWriter.ResourceString am = new ICUResourceWriter.ResourceString();
            ICUResourceWriter.ResourceString pm = new ICUResourceWriter.ResourceString();
            am.val = LDMLUtilities.getNodeValue(amNode);
            pm.val = LDMLUtilities.getNodeValue(pmNode);
            arr.first = am;
            am.next = pm;
        }
        if (amNode == null && pmNode != null || amNode != null && pmNode == null) {
            throw new RuntimeException("Could not find " + amNode + " or " + pmNode + " from fullyResolved locale!!");
        }
        return arr;
    }

    private ICUResourceWriter.Resource parseDTF(Node root, StringBuffer xpath) {
        Node parent = root.getParentNode();
        String[] paths = new String[]{"timeFormats/timeFormatLength[@type='full']/timeFormat[@type='standard']/pattern", "timeFormats/timeFormatLength[@type='long']/timeFormat[@type='standard']/pattern", "timeFormats/timeFormatLength[@type='medium']/timeFormat[@type='standard']/pattern", "timeFormats/timeFormatLength[@type='short']/timeFormat[@type='standard']/pattern", "dateFormats/dateFormatLength[@type='full']/dateFormat[@type='standard']/pattern", "dateFormats/dateFormatLength[@type='long']/dateFormat[@type='standard']/pattern", "dateFormats/dateFormatLength[@type='medium']/dateFormat[@type='standard']/pattern", "dateFormats/dateFormatLength[@type='short']/dateFormat[@type='standard']/pattern", "dateTimeFormats/dateTimeFormatLength/dateTimeFormat[@type='standard']/pattern"};
        int saveLen = xpath.length();
        Node[] nodes = new Node[paths.length];
        boolean someNonDraft = false;
        for (int i = 0; i < paths.length; ++i) {
            nodes[i] = this.getVettedNode(parent, paths[i], xpath);
            if (nodes[i] == null) continue;
            someNonDraft = true;
        }
        if (someNonDraft) {
            ICUResourceWriter.ResourceArray arr = new ICUResourceWriter.ResourceArray();
            arr.name = DTP;
            ICUResourceWriter.Resource current = null;
            for (int i = 0; i < nodes.length; ++i) {
                ICUResourceWriter.ResourceString str = new ICUResourceWriter.ResourceString();
                Node temp = nodes[i];
                if (temp == null) {
                    xpath.append("/");
                    xpath.append(paths[i]);
                    temp = LDMLUtilities.getNode(this.fullyResolvedDoc, xpath.toString());
                    xpath.setLength(saveLen);
                }
                str.val = LDMLUtilities.getNodeValue(temp);
                if (str.val != null) {
                    if (current == null) {
                        arr.first = str;
                        current = arr.first;
                        continue;
                    }
                    current.next = str;
                    current = current.next;
                    continue;
                }
                throw new RuntimeException("the node value for Date and Time patterns is null!!");
            }
            if (arr.first != null) {
                return arr;
            }
        }
        return null;
    }

    private ICUResourceWriter.Resource parseFlexibleFormats(Node root, StringBuffer xpath) {
        ICUResourceWriter.Resource current = null;
        ICUResourceWriter.Resource first = null;
        int savedLength = xpath.length();
        this.getXPath(root, xpath);
        int oldLength = xpath.length();
        for (Node node = root.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            String name = node.getNodeName();
            ICUResourceWriter.Resource res = null;
            if (!name.equals("alias")) {
                if (name.equals("availableFormats") || name.equals("appendItems")) {
                    res = this.parseItems(node, xpath);
                } else if (!name.equals("dateTimeFormatLength")) {
                    System.err.println("Encountered unknown <" + root.getNodeName() + "> subelement: " + name);
                    System.exit(-1);
                }
            }
            if (res != null) {
                if (current == null) {
                    first = res;
                    current = this.findLast(res);
                } else {
                    current.next = res;
                    current = this.findLast(res);
                }
                res = null;
            }
            xpath.delete(oldLength, xpath.length());
        }
        xpath.delete(savedLength, xpath.length());
        if (first != null) {
            return first;
        }
        return null;
    }

    private ICUResourceWriter.Resource parseItems(Node root, StringBuffer xpath) {
        ICUResourceWriter.Resource current = null;
        int savedLength = xpath.length();
        this.getXPath(root, xpath);
        int oldLength = xpath.length();
        ICUResourceWriter.ResourceTable table = new ICUResourceWriter.ResourceTable();
        table.name = root.getNodeName();
        if (this.isNodeNotConvertible(root, xpath)) {
            xpath.setLength(savedLength);
            return null;
        }
        for (Node node = root.getFirstChild(); node != null; node = node.getNextSibling()) {
            ICUResourceWriter.ResourceString str;
            if (node.getNodeType() != 1) continue;
            String name = node.getNodeName();
            ICUResourceWriter.Resource res = null;
            if (name.equals("alias")) {
                res = this.parseAliasResource(node, xpath);
                res.name = name;
                return res;
            }
            if (name.equals("dateFormatItem")) {
                this.getXPath(node, xpath);
                if (this.isNodeNotConvertible(node, xpath)) {
                    xpath.setLength(oldLength);
                    continue;
                }
                str = new ICUResourceWriter.ResourceString();
                str.name = LDMLUtilities.getAttributeValue(node, "id");
                str.val = LDMLUtilities.getNodeValue(node);
                res = str;
            } else if (name.equals("appendItem")) {
                this.getXPath(node, xpath);
                if (this.isNodeNotConvertible(node, xpath)) {
                    xpath.setLength(oldLength);
                    continue;
                }
                str = new ICUResourceWriter.ResourceString();
                str.name = LDMLUtilities.getAttributeValue(node, "request");
                str.val = LDMLUtilities.getNodeValue(node);
                res = str;
            } else {
                if (name.equals("dateTimeFormatLength")) continue;
                System.err.println("Encountered unknown <" + root.getNodeName() + "> subelement: " + name);
                System.exit(-1);
            }
            if (res != null) {
                if (current == null) {
                    table.first = res;
                    current = this.findLast(res);
                } else {
                    current.next = res;
                    current = res;
                }
                res = null;
            }
            xpath.delete(oldLength, xpath.length());
        }
        xpath.delete(savedLength, xpath.length());
        if (table.first != null) {
            return table;
        }
        return null;
    }

    private ICUResourceWriter.Resource parseNumbers(Node root, StringBuffer xpath) {
        ICUResourceWriter.Resource current = null;
        ICUResourceWriter.Resource first = null;
        boolean writtenFormats = false;
        int savedLength = xpath.length();
        this.getXPath(root, xpath);
        int oldLength = xpath.length();
        if (this.isNodeNotConvertible(root, xpath)) {
            xpath.setLength(savedLength);
            return null;
        }
        for (Node node = root.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            String name = node.getNodeName();
            ICUResourceWriter.Resource res = null;
            if (name.equals("alias")) {
                res = this.parseAliasResource(node, xpath);
                res.name = name;
                return res;
            }
            if (name.equals("default")) {
                res = this.getDefaultResource(node, xpath, name);
            } else if (name.equals("symbols")) {
                res = this.parseSymbols(node, xpath);
            } else if (name.equals("decimalFormats") || name.equals("percentFormats") || name.equals("scientificFormats") || name.equals("currencyFormats")) {
                if (!writtenFormats) {
                    res = this.parseNumberFormats(node, xpath);
                    writtenFormats = true;
                }
            } else if (name.equals("currencies")) {
                res = this.parseCurrencies(node, xpath);
            } else {
                System.err.println("Encountered unknown <" + root.getNodeName() + "> subelement: " + name);
                System.exit(-1);
            }
            if (res != null) {
                if (current == null) {
                    first = res;
                    current = this.findLast(res);
                } else {
                    current.next = res;
                    current = this.findLast(res);
                }
                res = null;
            }
            xpath.delete(oldLength, xpath.length());
        }
        xpath.delete(savedLength, xpath.length());
        if (first != null) {
            return first;
        }
        return null;
    }

    private ICUResourceWriter.Resource parseSymbols(Node root, StringBuffer xpath) {
        int savedLength = xpath.length();
        this.getXPath(root, xpath);
        if (this.isNodeNotConvertible(root, xpath)) {
            xpath.setLength(savedLength);
            return null;
        }
        ICUResourceWriter.ResourceArray arr = new ICUResourceWriter.ResourceArray();
        arr.name = NUMBER_ELEMENTS;
        ICUResourceWriter.Resource current = null;
        String[] paths = new String[]{"decimal", "group", "list", "percentSign", "nativeZeroDigit", "patternDigit", "minusSign", "exponential", "perMille", "infinity", "nan", "plusSign"};
        Node[] nodes = new Node[paths.length];
        boolean someNonDraft = false;
        for (int i = 0; i < paths.length; ++i) {
            nodes[i] = this.getVettedNode(root, paths[i], xpath);
            if (nodes[i] == null) continue;
            someNonDraft = true;
        }
        int saveLen = xpath.length();
        if (someNonDraft) {
            for (int i = 0; i < nodes.length; ++i) {
                ICUResourceWriter.ResourceString str = new ICUResourceWriter.ResourceString();
                Node temp = nodes[i];
                if (temp == null) {
                    xpath.append("/");
                    xpath.append(paths[i]);
                    temp = LDMLUtilities.getNode(this.fullyResolvedDoc, xpath.toString());
                    xpath.setLength(saveLen);
                }
                str.val = LDMLUtilities.getNodeValue(temp);
                if (str.val != null) {
                    if (current == null) {
                        arr.first = str;
                        current = arr.first;
                        continue;
                    }
                    current.next = str;
                    current = current.next;
                    continue;
                }
                throw new RuntimeException("the node value for Date and Time patterns is null!!");
            }
        }
        xpath.delete(savedLength, xpath.length());
        if (arr.first != null) {
            return arr;
        }
        return null;
    }

    private ICUResourceWriter.Resource parseNumberFormats(Node root, StringBuffer xpath) {
        String[] paths = new String[]{"decimalFormats/decimalFormatLength/decimalFormat[@type='standard']/pattern", "currencyFormats/currencyFormatLength/currencyFormat[@type='standard']/pattern", "percentFormats/percentFormatLength/percentFormat[@type='standard']/pattern", "scientificFormats/scientificFormatLength/scientificFormat[@type='standard']/pattern"};
        Node parent = root.getParentNode();
        Node[] nodes = new Node[paths.length];
        boolean someNonDraft = false;
        for (int i = 0; i < paths.length; ++i) {
            nodes[i] = this.getVettedNode(parent, paths[i], xpath);
            if (nodes[i] == null) continue;
            someNonDraft = true;
        }
        int saveLen = xpath.length();
        ICUResourceWriter.ResourceArray arr = new ICUResourceWriter.ResourceArray();
        arr.name = NUMBER_PATTERNS;
        ICUResourceWriter.Resource current = null;
        if (someNonDraft) {
            for (int i = 0; i < nodes.length; ++i) {
                ICUResourceWriter.ResourceString str = new ICUResourceWriter.ResourceString();
                Node temp = nodes[i];
                if (temp == null) {
                    xpath.append("/");
                    xpath.append(paths[i]);
                    temp = LDMLUtilities.getNode(this.fullyResolvedDoc, xpath.toString());
                    xpath.setLength(saveLen);
                }
                str.val = LDMLUtilities.getNodeValue(temp);
                if (str.val != null) {
                    if (current == null) {
                        arr.first = str;
                        current = arr.first;
                        continue;
                    }
                    current.next = str;
                    current = current.next;
                    continue;
                }
                throw new RuntimeException("the node value for number patterns is null!!");
            }
        }
        if (arr.first != null) {
            return arr;
        }
        return null;
    }

    private ICUResourceWriter.Resource parseCurrencies(Node root, StringBuffer xpath) {
        ICUResourceWriter.ResourceTable table = new ICUResourceWriter.ResourceTable();
        ICUResourceWriter.Resource current = null;
        int savedLength = xpath.length();
        this.getXPath(root, xpath);
        int oldLength = xpath.length();
        if (this.isNodeNotConvertible(root, xpath)) {
            xpath.setLength(savedLength);
            return null;
        }
        table.name = (String)keyNameMap.get(root.getNodeName());
        for (Node node = root.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            String name = node.getNodeName();
            ICUResourceWriter.Resource res = null;
            if (name.equals("alias")) {
                res = this.parseAliasResource(node, xpath);
                res.name = name;
                return res;
            }
            if (name.equals("default")) {
                res = this.getDefaultResource(node, xpath, name);
            } else if (name.equals("currency")) {
                res = this.parseCurrency(node, xpath);
            } else {
                System.err.println("Encountered unknown <" + root.getNodeName() + "> subelement: " + name);
                System.exit(-1);
            }
            if (res != null) {
                if (current == null) {
                    table.first = res;
                    current = this.findLast(res);
                } else {
                    current.next = res;
                    current = this.findLast(res);
                }
                res = null;
            }
            xpath.delete(oldLength, xpath.length());
        }
        xpath.delete(savedLength, xpath.length());
        if (table.first != null) {
            return table;
        }
        return null;
    }

    private ICUResourceWriter.Resource parseCurrency(Node root, StringBuffer xpath) {
        int savedLength = xpath.length();
        this.getXPath(root, xpath);
        ICUResourceWriter.ResourceArray arr = new ICUResourceWriter.ResourceArray();
        arr.name = LDMLUtilities.getAttributeValue(root, "type");
        if (this.isNodeNotConvertible(root, xpath)) {
            xpath.setLength(savedLength);
            return null;
        }
        Node alias = LDMLUtilities.getNode(root, "alias", this.fullyResolvedDoc, xpath.toString());
        if (alias != null) {
            ICUResourceWriter.Resource res = this.parseAliasResource(alias, xpath);
            res.name = LDMLUtilities.getAttributeValue(root, "type");
            xpath.delete(savedLength, xpath.length());
            return res;
        }
        Node symbolNode = this.getVettedNode(null, root, "symbol", xpath, true);
        Node displayNameNode = this.getVettedNode(null, root, "displayName", xpath, true);
        Node patternNode = this.getVettedNode(null, root, "pattern", xpath, false);
        Node decimalNode = this.getVettedNode(null, root, "decimal", xpath, false);
        Node groupNode = this.getVettedNode(null, root, "group", xpath, false);
        if (displayNameNode != null || symbolNode != null || patternNode != null || decimalNode != null || groupNode != null) {
            if (symbolNode == null) {
                symbolNode = this.getVettedNode(this.fullyResolvedDoc, root, "symbol", xpath, true);
            }
            if (displayNameNode == null) {
                displayNameNode = this.getVettedNode(this.fullyResolvedDoc, root, "displayName", xpath, true);
            }
            ICUResourceWriter.ResourceString displayName = null;
            ICUResourceWriter.ResourceString symbol = null;
            symbol = new ICUResourceWriter.ResourceString();
            displayName = new ICUResourceWriter.ResourceString();
            if (symbolNode != null) {
                symbol.val = LDMLUtilities.getNodeValue(symbolNode);
                String choice = LDMLUtilities.getAttributeValue(symbolNode, "choice");
                if (choice != null && choice.equals("true")) {
                    symbol.val = "=" + symbol.val.replace('\u2264', '#');
                }
            } else {
                symbol.val = arr.name;
            }
            displayName.val = displayNameNode != null ? LDMLUtilities.getNodeValue(displayNameNode) : arr.name;
            arr.first = symbol;
            symbol.next = displayName;
            if (patternNode != null || decimalNode != null || groupNode != null) {
                boolean isPatternDup = false;
                boolean isDecimalDup = false;
                boolean isGroupDup = false;
                if (patternNode == null) {
                    patternNode = LDMLUtilities.getNode(this.fullyResolvedDoc, "//ldml/numbers/currencyFormats/currencyFormatLength/currencyFormat/pattern");
                    isPatternDup = true;
                    if (patternNode == null) {
                        throw new RuntimeException("Could not get pattern currency resource!!");
                    }
                }
                if (decimalNode == null) {
                    decimalNode = LDMLUtilities.getNode(this.fullyResolvedDoc, "//ldml/numbers/symbols/decimal");
                    isDecimalDup = true;
                    if (decimalNode == null) {
                        throw new RuntimeException("Could not get decimal currency resource!!");
                    }
                }
                if (groupNode == null) {
                    groupNode = LDMLUtilities.getNode(this.fullyResolvedDoc, "//ldml/numbers/symbols/group");
                    isGroupDup = true;
                    if (groupNode == null) {
                        throw new RuntimeException("Could not get group currency resource!!");
                    }
                }
                ICUResourceWriter.ResourceArray elementsArr = new ICUResourceWriter.ResourceArray();
                ICUResourceWriter.ResourceString pattern = new ICUResourceWriter.ResourceString();
                pattern.val = LDMLUtilities.getNodeValue(patternNode);
                pattern.comment = isPatternDup ? "Duplicated from NumberPatterns resource" : null;
                ICUResourceWriter.ResourceString decimal = new ICUResourceWriter.ResourceString();
                decimal.val = LDMLUtilities.getNodeValue(decimalNode);
                decimal.comment = isDecimalDup ? "Duplicated from NumberElements resource" : null;
                ICUResourceWriter.ResourceString group = new ICUResourceWriter.ResourceString();
                group.val = LDMLUtilities.getNodeValue(groupNode);
                group.comment = isGroupDup ? "Duplicated from NumberElements resource" : null;
                elementsArr.first = pattern;
                pattern.next = decimal;
                decimal.next = group;
                if (displayName != null) {
                    displayName.next = elementsArr;
                } else {
                    System.err.println("WARNING: displayName and symbol not vetted/available for currency resource " + arr.name + " not generating the resource");
                }
            }
        }
        xpath.delete(savedLength, xpath.length());
        if (arr.first != null) {
            return arr;
        }
        return null;
    }

    private ICUResourceWriter.Resource parsePosix(Node root, StringBuffer xpath) {
        ICUResourceWriter.Resource first = null;
        ICUResourceWriter.Resource current = null;
        int savedLength = xpath.length();
        this.getXPath(root, xpath);
        int oldLength = xpath.length();
        if (this.isNodeNotConvertible(root, xpath)) {
            xpath.setLength(savedLength);
            return null;
        }
        for (Node node = root.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            String name = node.getNodeName();
            ICUResourceWriter.Resource res = null;
            if (name.equals("messages")) {
                res = this.parseMessages(node, xpath);
            } else if (name.equals("alias")) {
                res = this.parseAliasResource(node, xpath);
            } else {
                System.err.println("Unknown element found: " + name);
                System.exit(-1);
            }
            if (res != null) {
                current = current == null ? (first = res) : (current.next = res);
                res = null;
            }
            xpath.delete(oldLength, xpath.length());
        }
        xpath.delete(savedLength, xpath.length());
        return first;
    }

    private ICUResourceWriter.Resource parseMessages(Node root, StringBuffer xpath) {
        ICUResourceWriter.ResourceTable table = new ICUResourceWriter.ResourceTable();
        ICUResourceWriter.Resource current = null;
        int savedLength = xpath.length();
        this.getXPath(root, xpath);
        int oldLength = xpath.length();
        if (this.isNodeNotConvertible(root, xpath)) {
            xpath.setLength(savedLength);
            return null;
        }
        table.name = root.getNodeName();
        for (Node node = root.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            String name = node.getNodeName();
            ICUResourceWriter.Resource res = null;
            if (name.equals("yesstr") || name.equals("yesexpr") || name.equals("nostr") || name.equals("noexpr")) {
                this.getXPath(node, xpath);
                if (this.isNodeNotConvertible(node, xpath)) {
                    xpath.setLength(oldLength);
                    continue;
                }
                ICUResourceWriter.ResourceString str = new ICUResourceWriter.ResourceString();
                str.name = name;
                str.val = LDMLUtilities.getNodeValue(node);
                res = str;
            } else if (name.equals("alias")) {
                res = this.parseAliasResource(node, xpath);
            } else {
                System.err.println("Unknown element found: " + name);
                System.exit(-1);
            }
            if (res != null) {
                current = current == null ? (table.first = res) : (current.next = res);
                res = null;
            }
            xpath.delete(oldLength, xpath.length());
        }
        xpath.delete(savedLength, xpath.length());
        if (table.first != null) {
            return table;
        }
        return null;
    }

    public ICUResourceWriter.Resource parseCollations(Node root, StringBuffer xpath, boolean checkIfConvertible) {
        ICUResourceWriter.ResourceTable table = new ICUResourceWriter.ResourceTable();
        ICUResourceWriter.Resource current = null;
        table.name = root.getNodeName();
        int savedLength = xpath.length();
        this.getXPath(root, xpath);
        int oldLength = xpath.length();
        if (this.isNodeNotConvertible(root, xpath)) {
            xpath.setLength(savedLength);
            return null;
        }
        current = table.first = this.parseValidSubLocales(root, xpath);
        for (Node node = root.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            String name = node.getNodeName();
            ICUResourceWriter.Resource res = null;
            if (name.equals("alias")) {
                res = this.parseAliasResource(node, xpath);
                res.name = table.name;
                return res;
            }
            if (name.equals("default")) {
                res = this.getDefaultResource(node, xpath, name);
            } else if (name.equals("collation")) {
                res = this.parseCollation(node, xpath, checkIfConvertible);
            } else {
                System.err.println("Encountered unknown <" + root.getNodeName() + "> subelement: " + name);
                System.exit(-1);
            }
            if (res != null) {
                current = current == null ? (table.first = res) : (current.next = res);
                res = null;
            }
            xpath.delete(oldLength, xpath.length());
        }
        xpath.delete(savedLength, xpath.length());
        if (table.first != null) {
            return table;
        }
        return null;
    }

    private ICUResourceWriter.Resource parseValidSubLocales(Node root, StringBuffer xpath) {
        return null;
    }

    private ICUResourceWriter.Resource parseCollation(Node root, StringBuffer xpath, boolean checkIfConvertible) {
        ICUResourceWriter.ResourceTable table = new ICUResourceWriter.ResourceTable();
        ICUResourceWriter.Resource current = null;
        table.name = LDMLUtilities.getAttributeValue(root, "type");
        int savedLength = xpath.length();
        this.getXPath(root, xpath);
        int oldLength = xpath.length();
        if (checkIfConvertible && this.isNodeNotConvertible(root, xpath, true, false)) {
            xpath.setLength(savedLength);
            return null;
        }
        StringBuffer rules = new StringBuffer();
        for (Node node = root.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            String name = node.getNodeName();
            ICUResourceWriter.Resource res = null;
            if (name.equals("alias")) {
                res = this.parseAliasResource(node, xpath);
                res.name = table.name;
                return res;
            }
            if (name.equals("rules")) {
                Node alias = LDMLUtilities.getNode(node, "alias", this.fullyResolvedDoc, xpath.toString());
                this.getXPath(node, xpath);
                if (alias != null) {
                    res = this.parseAliasResource(alias, xpath);
                } else {
                    rules.append(this.parseRules(node, xpath));
                }
            } else if (name.equals("settings")) {
                rules.append(this.parseSettings(node));
            } else if (name.equals("suppress_contractions")) {
                int index = rules.length();
                rules.append("[suppressContractions ");
                rules.append(LDMLUtilities.getNodeValue(node));
                rules.append(" ]");
            } else if (name.equals("optimize")) {
                rules.append("[optimize ");
                rules.append(LDMLUtilities.getNodeValue(node));
                rules.append(" ]");
            } else if (name.equals("base")) {
                rules.append(this.parseBase(node, xpath, oldLength));
            } else {
                System.err.println("Encountered unknown <" + root.getNodeName() + "> subelement: " + name);
                System.exit(-1);
            }
            if (res != null) {
                if (current == null) {
                    table.first = res;
                    current = table.first;
                } else {
                    current.next = res;
                    current = current.next;
                }
                res = null;
            }
            xpath.delete(oldLength, xpath.length());
        }
        if (rules != null) {
            ICUResourceWriter.ResourceString str = new ICUResourceWriter.ResourceString();
            str.name = "Sequence";
            str.val = rules.toString();
            if (current == null) {
                table.first = str;
                current = table.first;
            } else {
                current.next = str;
                current = current.next;
            }
            str = new ICUResourceWriter.ResourceString();
            str.name = "Version";
            str.val = this.ldmlVersion;
            current.next = str;
        }
        xpath.delete(savedLength, xpath.length());
        if (table.first != null) {
            return table;
        }
        return null;
    }

    private String parseBase(Node node, StringBuffer xpath, int oldLength) {
        String myxp = xpath.substring(0, oldLength);
        String locale = LDMLUtilities.getNodeValue(node);
        if (locale == null) {
            locale = LDMLUtilities.getAttributeValue(node, "locale");
        }
        if (locale != null) {
            String fn = locale + ".xml";
            Document colDoc = LDMLUtilities.getFullyResolvedLDML(this.sourceDir, fn, false, false, false, true);
            Node col = LDMLUtilities.getNode(colDoc, myxp);
            if (col != null) {
                ICUResourceWriter.ResourceTable table = (ICUResourceWriter.ResourceTable)this.parseCollation(col, new StringBuffer(myxp), false);
                if (table != null) {
                    ICUResourceWriter.Resource current = table.first;
                    while (current != null) {
                        if (current instanceof ICUResourceWriter.ResourceString) {
                            ICUResourceWriter.ResourceString temp = (ICUResourceWriter.ResourceString)current;
                            if (temp.name.equals("Sequence")) {
                                return temp.val;
                            }
                        }
                        current = current.next;
                    }
                } else {
                    this.printWarning(fn, "Collation node could not be parsed for " + myxp);
                }
            } else {
                this.printWarning(fn, "Could not find col from xpath: " + myxp);
            }
        } else {
            this.printWarning(this.fileName, "Could not find locale from xpath: " + xpath.toString());
        }
        return "";
    }

    private StringBuffer parseSettings(Node node) {
        String numeric;
        String hiraganaQ;
        String caseFirst;
        String caseLevel;
        String normalization;
        String backwards;
        String alternate;
        String strength = LDMLUtilities.getAttributeValue(node, "strength");
        StringBuffer rules = new StringBuffer();
        if (strength != null) {
            rules.append(" [strength ");
            rules.append(this.getStrength(strength));
            rules.append(" ]");
        }
        if ((alternate = LDMLUtilities.getAttributeValue(node, "alternate")) != null) {
            rules.append(" [alternate ");
            rules.append(alternate);
            rules.append(" ]");
        }
        if ((backwards = LDMLUtilities.getAttributeValue(node, "backwards")) != null && backwards.equals("on")) {
            rules.append(" [backwards 2]");
        }
        if ((normalization = LDMLUtilities.getAttributeValue(node, "normalization")) != null) {
            rules.append(" [normalization ");
            rules.append(normalization);
            rules.append(" ]");
        }
        if ((caseLevel = LDMLUtilities.getAttributeValue(node, "caseLevel")) != null) {
            rules.append(" [caseLevel ");
            rules.append(caseLevel);
            rules.append(" ]");
        }
        if ((caseFirst = LDMLUtilities.getAttributeValue(node, "caseFirst")) != null) {
            rules.append(" [caseFirst ");
            rules.append(caseFirst);
            rules.append(" ]");
        }
        if ((hiraganaQ = LDMLUtilities.getAttributeValue(node, "hiraganaQuaternary")) == null) {
            hiraganaQ = LDMLUtilities.getAttributeValue(node, "hiraganaQuarternary");
        }
        if (hiraganaQ != null) {
            rules.append(" [hiraganaQ ");
            rules.append(hiraganaQ);
            rules.append(" ]");
        }
        if ((numeric = LDMLUtilities.getAttributeValue(node, "numeric")) != null) {
            rules.append(" [numericOrdering ");
            rules.append(numeric);
            rules.append(" ]");
        }
        return rules;
    }

    private StringBuffer parseRules(Node root, StringBuffer xpath) {
        StringBuffer rules = new StringBuffer();
        for (Node node = root.getFirstChild(); node != null; node = node.getNextSibling()) {
            String data;
            Node lastVariable;
            if (node.getNodeType() != 1) continue;
            String name = node.getNodeName();
            if (name.equals("pc") || name.equals("sc") || name.equals("tc") || name.equals("qc") || name.equals("ic")) {
                lastVariable = LDMLUtilities.getNode(node, "last_variable", null, null);
                if (lastVariable != null) {
                    rules.append(collationMap.get(lastVariable.getNodeName()));
                    continue;
                }
                data = this.getData(node, name);
                rules.append(data);
                continue;
            }
            if (name.equals("p") || name.equals("s") || name.equals("t") || name.equals("q") || name.equals("i")) {
                lastVariable = LDMLUtilities.getNode(node, "last_variable", null, null);
                if (lastVariable != null) {
                    rules.append(collationMap.get(lastVariable.getNodeName()));
                    continue;
                }
                data = this.getData(node, name);
                rules.append(data);
                continue;
            }
            if (name.equals("x")) {
                rules.append(this.parseExtension(node));
                continue;
            }
            if (name.equals("reset")) {
                rules.append(this.parseReset(node));
                continue;
            }
            System.err.println("Encountered unknown <" + root.getNodeName() + "> subelement: " + name);
            System.exit(-1);
        }
        return rules;
    }

    private static final String quoteOperand(String s) {
        int cp;
        s = Normalizer.normalize((String)s, (Normalizer.Mode)Normalizer.NFC);
        quoteOperandBuffer.setLength(0);
        boolean noQuotes = true;
        boolean inQuote = false;
        for (int i = 0; i < s.length(); i += UTF16.getCharCount((int)cp)) {
            cp = UTF16.charAt((String)s, (int)i);
            if (!needsQuoting.contains(cp)) {
                if (inQuote) {
                    quoteOperandBuffer.append('\'');
                    inQuote = false;
                }
                quoteOperandBuffer.append(UTF16.valueOf((int)cp));
                continue;
            }
            noQuotes = false;
            if (cp == 39) {
                quoteOperandBuffer.append("''");
                continue;
            }
            if (!inQuote) {
                quoteOperandBuffer.append('\'');
                inQuote = true;
            }
            if (cp > 65535) {
                quoteOperandBuffer.append("\\U").append(Utility.hex((int)cp, (int)8));
                continue;
            }
            if (cp <= 32 || cp > 126) {
                quoteOperandBuffer.append("\\u").append(Utility.hex((long)cp));
                continue;
            }
            quoteOperandBuffer.append(UTF16.valueOf((int)cp));
        }
        if (inQuote) {
            quoteOperandBuffer.append('\'');
        }
        if (noQuotes) {
            return s;
        }
        return quoteOperandBuffer.toString();
    }

    private String getData(Node root, String strength) {
        StringBuffer data = new StringBuffer();
        for (Node node = root.getFirstChild(); node != null; node = node.getNextSibling()) {
            String val;
            String name;
            if (node.getNodeType() == 1 && (name = node.getNodeName()).equals("cp")) {
                String hex = LDMLUtilities.getAttributeValue(node, "hex");
                data.append(this.getStrengthSymbol(strength));
                String cp = UTF16.valueOf((int)Integer.parseInt(hex, 16));
                data.append(LDML2ICUConverter.quoteOperand(cp));
            }
            if (node.getNodeType() != 3 || (val = node.getNodeValue()) == null) continue;
            if (strength.equals("pc") || strength.equals("sc") || strength.equals("tc") || strength.equals("qc") || strength.equals("ic")) {
                data.append(this.getExpandedRules(val, strength));
                continue;
            }
            data.append(this.getStrengthSymbol(strength));
            data.append(LDML2ICUConverter.quoteOperand(val));
        }
        return data.toString();
    }

    private String getStrengthSymbol(String name) {
        if (name.equals("pc") || name.equals("p")) {
            return "<";
        }
        if (name.equals("sc") || name.equals("s")) {
            return "<<";
        }
        if (name.equals("tc") || name.equals("t")) {
            return "<<<";
        }
        if (name.equals("qc") || name.equals("q")) {
            return "<<<<";
        }
        if (name.equals("ic") || name.equals("i")) {
            return "=";
        }
        System.err.println("Encountered strength: " + name);
        System.exit(-1);
        return null;
    }

    private String getStrength(String name) {
        if (name.equals("primary")) {
            return "1";
        }
        if (name.equals("secondary")) {
            return "2";
        }
        if (name.equals("tertiary")) {
            return "3";
        }
        if (name.equals("quarternary")) {
            return "4";
        }
        if (name.equals("identical")) {
            return "5";
        }
        System.err.println("Encountered strength: " + name);
        System.exit(-1);
        return null;
    }

    private StringBuffer parseReset(Node root) {
        StringBuffer ret = new StringBuffer();
        ret.append("&");
        String val = LDMLUtilities.getAttributeValue(root, "before");
        if (val != null) {
            ret.append("[before ");
            ret.append(this.getStrength(val));
            ret.append("]");
        }
        for (Node node = root.getFirstChild(); node != null; node = node.getNextSibling()) {
            short type = node.getNodeType();
            if (type == 1) {
                String key = node.getNodeName();
                ret.append(collationMap.get(key));
            }
            if (type != 3) continue;
            ret.append(LDML2ICUConverter.quoteOperand(node.getNodeValue()));
        }
        return ret;
    }

    private StringBuffer getExpandedRules(String data, String name) {
        int ch;
        UCharacterIterator iter = UCharacterIterator.getInstance((String)data);
        StringBuffer ret = new StringBuffer();
        String strengthSymbol = this.getStrengthSymbol(name);
        while ((ch = iter.nextCodePoint()) != -1) {
            ret.append(strengthSymbol);
            ret.append(LDML2ICUConverter.quoteOperand(UTF16.valueOf((int)ch)));
        }
        return ret;
    }

    private StringBuffer parseExtension(Node root) {
        StringBuffer rules = new StringBuffer();
        Node contextNode = null;
        Node extendNode = null;
        Node strengthNode = null;
        String strength = null;
        String string = null;
        String context = null;
        String extend = null;
        for (Node node = root.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            String name = node.getNodeName();
            if (name.equals("context")) {
                contextNode = node;
                continue;
            }
            if (name.equals("p") || name.equals("s") || name.equals("t") || name.equals("i")) {
                strengthNode = node;
                continue;
            }
            if (name.equals("extend")) {
                extendNode = node;
                continue;
            }
            System.err.println("Encountered unknown <" + root.getNodeName() + "> subelement: " + name);
            System.exit(-1);
        }
        if (contextNode != null) {
            context = LDMLUtilities.getNodeValue(contextNode);
        }
        if (strengthNode != null) {
            Node lastVariable = LDMLUtilities.getNode(strengthNode, "last_variable", null, null);
            if (lastVariable != null) {
                string = (String)collationMap.get(lastVariable.getNodeName());
            } else {
                strength = this.getStrengthSymbol(strengthNode.getNodeName());
                string = LDMLUtilities.getNodeValue(strengthNode);
            }
        }
        if (extendNode != null) {
            extend = LDMLUtilities.getNodeValue(extendNode);
        }
        rules.append(strength);
        if (context != null) {
            rules.append(LDML2ICUConverter.quoteOperand(context));
            rules.append("|");
        }
        rules.append(string);
        if (extend != null) {
            rules.append("/");
            rules.append(LDML2ICUConverter.quoteOperand(extend));
        }
        return rules;
    }

    private ICUResourceWriter.Resource parseBoundaries(Node root, StringBuffer xpath) {
        ICUResourceWriter.ResourceTable table = new ICUResourceWriter.ResourceTable();
        int savedLength = xpath.length();
        this.getXPath(root, xpath);
        ICUResourceWriter.Resource current = null;
        String name = root.getNodeName();
        table.name = name.substring(name.indexOf(58) + 1, name.length());
        for (Node node = root.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            name = node.getNodeName();
            ICUResourceWriter.ResourceProcess res = null;
            if (name.equals(ICU_GRAPHEME) || name.equals(ICU_WORD) || name.equals(ICU_LINE) || name.equals(ICU_SENTENCE) || name.equals(ICU_TITLE)) {
                ICUResourceWriter.ResourceProcess str = new ICUResourceWriter.ResourceProcess();
                str.ext = "dependency";
                str.name = name.substring(name.indexOf(58) + 1, name.length());
                str.val = LDMLUtilities.getAttributeValue(node, ICU_DEPENDENCY);
                if (str.val != null) {
                    res = str;
                }
            } else {
                System.err.println("Encountered unknown <" + root.getNodeName() + "> subelement: " + name);
                System.exit(-1);
            }
            if (res != null) {
                if (current == null) {
                    table.first = res;
                    current = this.findLast(res);
                } else {
                    current.next = res;
                    current = this.findLast(res);
                }
                res = null;
            }
            xpath.delete(savedLength, xpath.length());
        }
        if (table.first != null) {
            return table;
        }
        return null;
    }

    private ICUResourceWriter.Resource parseDictionaries(Node root, StringBuffer xpath) {
        ICUResourceWriter.ResourceTable table = new ICUResourceWriter.ResourceTable();
        int savedLength = xpath.length();
        this.getXPath(root, xpath);
        ICUResourceWriter.Resource current = null;
        String name = root.getNodeName();
        table.name = name.substring(name.indexOf(58) + 1, name.length());
        for (Node node = root.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            name = node.getNodeName();
            ICUResourceWriter.ResourceProcess res = null;
            if (name.equals(ICU_DICTIONARY)) {
                ICUResourceWriter.ResourceProcess str = new ICUResourceWriter.ResourceProcess();
                str.ext = "dependency";
                str.name = LDMLUtilities.getAttributeValue(node, "type");
                str.val = LDMLUtilities.getAttributeValue(node, ICU_DEPENDENCY);
                if (str.val != null) {
                    res = str;
                }
            } else {
                System.err.println("Encountered unknown <" + root.getNodeName() + "> subelement: " + name);
                System.exit(-1);
            }
            if (res != null) {
                if (current == null) {
                    table.first = res;
                    current = this.findLast(res);
                } else {
                    current.next = res;
                    current = this.findLast(res);
                }
                res = null;
            }
            xpath.delete(savedLength, xpath.length());
        }
        if (table.first != null) {
            return table;
        }
        return null;
    }

    private ICUResourceWriter.Resource parseSpecialElements(Node root, StringBuffer xpath) {
        ICUResourceWriter.Resource current = null;
        ICUResourceWriter.Resource first = null;
        int savedLength = xpath.length();
        this.getXPath(root, xpath);
        for (Node node = root.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            String name = node.getNodeName();
            ICUResourceWriter.Resource res = null;
            if (name.equals(ICU_SCRIPTS)) {
                res = this.parseArray(node, xpath);
                res.name = LOCALE_SCRIPT;
            } else if (name.equals(ICU_BRKITR_DATA)) {
                res = this.parseBrkItrData(node, xpath);
            } else if (!name.equals(ICU_IS_LEAP_MONTH)) {
                System.err.println("Encountered unknown <" + root.getNodeName() + "> subelement: " + name);
                System.exit(-1);
            }
            if (res != null) {
                if (current == null) {
                    first = res;
                    current = this.findLast(res);
                } else {
                    current.next = res;
                    current = this.findLast(res);
                }
                res = null;
            }
            xpath.delete(savedLength, xpath.length());
        }
        return first;
    }

    private ICUResourceWriter.Resource parseBrkItrData(Node root, StringBuffer xpath) {
        ICUResourceWriter.Resource current = null;
        ICUResourceWriter.Resource first = null;
        int savedLength = xpath.length();
        this.getXPath(root, xpath);
        for (Node node = root.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            String name = node.getNodeName();
            ICUResourceWriter.Resource res = null;
            if (name.equals(ICU_BOUNDARIES)) {
                res = this.parseBoundaries(node, xpath);
            } else if (name.equals(ICU_DICTIONARIES)) {
                res = this.parseDictionaries(node, xpath);
            } else {
                System.err.println("Encountered unknown <" + root.getNodeName() + "> subelement: " + name);
                System.exit(-1);
            }
            if (res != null) {
                if (current == null) {
                    first = res;
                    current = this.findLast(res);
                } else {
                    current.next = res;
                    current = this.findLast(res);
                }
                res = null;
            }
            xpath.delete(savedLength, xpath.length());
        }
        return first;
    }

    private void writeResource(ICUResourceWriter.Resource set, String sourceFileName) {
        try {
            String outputFileName = null;
            outputFileName = this.destDir + "/" + set.name + ".txt";
            FileOutputStream file = new FileOutputStream(outputFileName);
            BufferedOutputStream writer = new BufferedOutputStream(file);
            this.printInfo("Writing ICU: " + outputFileName);
            this.writeHeader(writer, sourceFileName);
            ICUResourceWriter.Resource current = set;
            while (current != null) {
                current.sort();
                current = current.next;
            }
            current = set;
            while (current != null) {
                current.write(writer, 0, false);
                current = current.next;
            }
            writer.flush();
            writer.close();
        }
        catch (Exception ie) {
            System.err.println(sourceFileName + ": ERROR (writing resource) :" + ie.toString());
            ie.printStackTrace();
            System.exit(1);
            return;
        }
    }

    private boolean isType(Node node, String type) {
        NamedNodeMap attributes = node.getAttributes();
        Node attr = attributes.getNamedItem("type");
        return attr != null && attr.getNodeValue().equals(type);
    }

    private void writeLine(OutputStream writer, String line) {
        try {
            byte[] bytes = line.getBytes(CHARSET);
            writer.write(bytes, 0, bytes.length);
        }
        catch (Exception e) {
            System.err.println(e);
            System.exit(1);
        }
    }

    private void writeHeader(OutputStream writer, String fileName) {
        this.writeBOM(writer);
        Calendar c = Calendar.getInstance();
        StringBuffer buffer = new StringBuffer();
        buffer.append("// ***************************************************************************" + LINESEP);
        buffer.append("// *" + LINESEP);
        buffer.append("// * Copyright (C) " + c.get(1) + " International Business Machines" + LINESEP);
        buffer.append("// * Corporation and others.  All Rights Reserved." + LINESEP);
        buffer.append("// * Tool: com.ibm.icu.dev.tool.cldr.LDML2ICUConverter.java" + LINESEP);
        String tempdir = fileName.replace('\\', '/');
        int index = tempdir.indexOf("/common");
        tempdir = index > -1 ? "<path>" + tempdir.substring(index, tempdir.length()) : ((index = tempdir.indexOf("/xml")) > -1 ? "<path>" + tempdir.substring(index, tempdir.length()) : "<path>/" + tempdir);
        buffer.append("// * Source File:" + tempdir + LINESEP);
        buffer.append("// *" + LINESEP);
        buffer.append("// ***************************************************************************" + LINESEP);
        this.writeLine(writer, buffer.toString());
    }

    private void writeBOM(OutputStream buffer) {
        try {
            byte[] bytes = BOM.getBytes(CHARSET);
            buffer.write(bytes, 0, bytes.length);
        }
        catch (Exception e) {
            System.err.println(e);
            System.exit(1);
        }
    }

    private void writeDeprecated() {
        int i;
        String myTreeName = null;
        File depF = null;
        File destD = new File(this.destDir);
        final File[] destFiles = destD.listFiles();
        if (this.writeDeprecated) {
            depF = new File(LDML2ICUConverter.options[5].value);
            if (!depF.isDirectory()) {
                this.printError("LDML2ICUConverter", LDML2ICUConverter.options[5].value + " isn't a directory.");
                this.usage();
                return;
            }
            myTreeName = depF.getName();
        }
        boolean parseDraft = !this.writeDraft;
        boolean parseSubLocale = this.sourceDir.indexOf("collation") > -1;
        boolean parseThem = parseDraft || parseSubLocale;
        TreeMap<String, String> fromToMap = new TreeMap<String, String>();
        TreeMap<String, String> fromXpathMap = new TreeMap<String, String>();
        TreeMap<String, File> fromFiles = new TreeMap<String, File>();
        TreeMap<String, File> emptyFromFiles = new TreeMap<String, File>();
        TreeMap<String, File> generatedAliasFiles = new TreeMap<String, File>();
        TreeMap<String, File> aliasFromFiles = new TreeMap<String, File>();
        TreeMap<String, String> validSubMap = new TreeMap<String, String>();
        TreeMap<String, String> maybeValidAlias = new TreeMap<String, String>();
        FileFilter myFilter = new FileFilter(){

            public boolean accept(File f) {
                String n = f.getName();
                return !f.isDirectory() && n.endsWith(".xml") && !n.startsWith("supplementalData") && this.isInDest(n);
            }

            public boolean isInDest(String n) {
                String name = n.substring(0, n.indexOf(46) + 1);
                for (int i = 0; i < destFiles.length; ++i) {
                    String dest = destFiles[i].getName();
                    if (dest.indexOf(name) != 0) continue;
                    return true;
                }
                return false;
            }
        };
        File[] inFiles = depF.listFiles(myFilter);
        int nrInFiles = inFiles.length;
        if (parseThem) {
            System.out.println("Parsing: " + nrInFiles + " LDML locale files to check " + (parseDraft ? "draft, " : "") + (parseSubLocale ? "valid-sub-locales, " : ""));
        }
        for (i = 0; i < nrInFiles; ++i) {
            boolean thisOK = true;
            String localeName = inFiles[i].getName();
            localeName = localeName.substring(0, localeName.indexOf(46));
            if (parseThem) {
                try {
                    String vsl;
                    Node collations;
                    Document doc2 = LDMLUtilities.parse(inFiles[i].toString(), false);
                    if (parseDraft && LDMLUtilities.isLocaleDraft(doc2)) {
                        thisOK = false;
                    }
                    if (thisOK && parseSubLocale && (collations = LDMLUtilities.getNode(doc2, "//ldml/collations")) != null && (vsl = LDMLUtilities.getAttributeValue(collations, "validSubLocales")) != null && vsl.length() > 0) {
                        validSubMap.put(localeName, vsl);
                        this.printInfo(localeName + " <- " + vsl);
                    }
                }
                catch (Throwable t) {
                    System.err.println("While parsing " + inFiles[i].toString() + " - ");
                    System.err.println(t.toString());
                    t.printStackTrace(System.err);
                    System.exit(-1);
                }
            }
            if (localeName.equals("root")) continue;
            if (thisOK) {
                System.out.print(".");
                fromFiles.put(inFiles[i].getName(), inFiles[i]);
                continue;
            }
            if (this.isDraftStatusOverridable(localeName)) {
                fromFiles.put(inFiles[i].getName(), inFiles[i]);
                System.out.print("o");
                continue;
            }
            System.out.print("d");
        }
        if (parseThem) {
            System.out.println("");
        }
        if (this.emptyLocaleList != null && this.emptyLocaleList.size() > 0) {
            for (i = 0; i < this.emptyLocaleList.size(); ++i) {
                String loc = (String)this.emptyLocaleList.get(i);
                this.writeSimpleLocale(loc + ".txt", loc, null, null, "empty locale file for dependency checking");
                generatedAliasFiles.put(loc + ".xml", new File(depF, loc + ".xml"));
            }
        }
        if (this.aliasMap != null && this.aliasMap.size() > 0) {
            Iterator i2 = this.aliasMap.keySet().iterator();
            while (i2.hasNext()) {
                String from = (String)i2.next();
                CLDRConverterTool.Alias value = (CLDRConverterTool.Alias)this.aliasMap.get(from);
                String to = value.to;
                String xpath = value.xpath;
                if (to.indexOf(64) != -1 && xpath == null) {
                    System.err.println("Malformed alias - '@' but no xpath: from=\"" + from + "\" to=\"" + to + "\"");
                    System.exit(-1);
                    return;
                }
                if (from == null || to == null) {
                    System.err.println("Malformed alias - no 'from' or no 'to':from=\"" + from + "\" to=\"" + to + "\"");
                    System.exit(-1);
                    return;
                }
                String toFileName = to;
                if (xpath != null) {
                    toFileName = to.substring(0, to.indexOf(64));
                }
                if (fromFiles.containsKey(from + ".xml")) {
                    throw new IllegalArgumentException("Can't be both a synthetic alias locale AND XML - consider using <aliasLocale source=\"" + from + "\"/> instead. ");
                }
                ULocale fromLocale = new ULocale(from);
                if (!fromFiles.containsKey(toFileName + ".xml")) {
                    maybeValidAlias.put(toFileName, from);
                    continue;
                }
                generatedAliasFiles.put(from, new File(depF, from + ".xml"));
                fromToMap.put(fromLocale.toString(), to);
                if (xpath != null) {
                    fromXpathMap.put(fromLocale.toString(), xpath);
                }
                this.writeSimpleLocale(from + ".txt", fromLocale, new ULocale(to), xpath, null);
            }
        }
        if (this.aliasLocaleList != null && this.aliasLocaleList.size() > 0) {
            for (int i3 = 0; i3 < this.aliasLocaleList.size(); ++i3) {
                String source = (String)this.aliasLocaleList.get(i3);
                if (!fromFiles.containsKey(source + ".xml")) {
                    System.err.println("WARNING: Alias file " + source + ".xml named in deprecates list but not present. Ignoring alias entry.");
                    continue;
                }
                aliasFromFiles.put(source + ".xml", new File(depF, source + ".xml"));
                fromFiles.remove(source + ".xml");
            }
        }
        if (!validSubMap.isEmpty() && this.sourceDir.indexOf("collation") > -1) {
            this.printInfo("Writing valid sub locs for : " + validSubMap.toString());
            Iterator e = validSubMap.keySet().iterator();
            while (e.hasNext()) {
                String actualLocale = (String)e.next();
                String list = (String)validSubMap.get(actualLocale);
                String[] validSubs = list.split(" ");
                for (int i4 = 0; i4 < validSubs.length; ++i4) {
                    String aSub;
                    String testSub = aSub = validSubs[i4];
                    while (testSub != null && !testSub.equals("root") && !testSub.equals(actualLocale)) {
                        if (fromFiles.containsKey(testSub + ".xml")) {
                            this.printWarning(actualLocale + ".xml", " validSubLocale=" + aSub + " overridden because  " + testSub + ".xml  exists.");
                            testSub = null;
                            break;
                        }
                        if (generatedAliasFiles.containsKey(testSub)) {
                            this.printWarning(actualLocale + ".xml", " validSubLocale=" + aSub + " overridden because  an alias locale " + testSub + ".xml  exists.");
                            testSub = null;
                            break;
                        }
                        testSub = LDMLUtilities.getParent(testSub);
                    }
                    if (testSub == null) continue;
                    emptyFromFiles.put(aSub + ".xml", new File(depF, aSub + ".xml"));
                    if (maybeValidAlias.containsKey(aSub)) {
                        String from = (String)maybeValidAlias.get(aSub);
                        this.writeSimpleLocale(from + ".txt", from, aSub, null, null);
                        maybeValidAlias.remove(aSub);
                        generatedAliasFiles.put(from, new File(depF, from + ".xml"));
                    }
                    this.writeSimpleLocale(aSub + ".txt", aSub, null, null, "validSubLocale of \"" + actualLocale + "\"");
                }
            }
        }
        if (!maybeValidAlias.isEmpty()) {
            Set keys = maybeValidAlias.keySet();
            Iterator iter = keys.iterator();
            while (iter.hasNext()) {
                String to = (String)iter.next();
                String from = (String)maybeValidAlias.get(to);
                System.err.println("WARNING: Alias from \"" + from + "\" not generated, because it would point to a nonexistent LDML file " + to + ".xml");
            }
        }
        String inFileText = LDML2ICUConverter.fileMapToList(fromFiles);
        String emptyFileText = null;
        if (!emptyFromFiles.isEmpty()) {
            emptyFileText = LDML2ICUConverter.fileMapToList(emptyFromFiles);
        }
        String aliasFilesList = LDML2ICUConverter.fileMapToList(aliasFromFiles);
        String generatedAliasList = LDML2ICUConverter.fileMapToList(generatedAliasFiles);
        String[] brkArray = new String[2];
        if (myTreeName.equals("brkitr")) {
            this.getBrkCtdFilesList(LDML2ICUConverter.options[5].value, brkArray);
        }
        this.writeResourceMakefile(myTreeName, generatedAliasList, aliasFilesList, inFileText, emptyFileText, brkArray[0], brkArray[1]);
        if (!this.writeDeprecated) {
            return;
        }
        System.out.println("done.");
    }

    public String[] getBrkCtdFilesList(String dir, String[] brkArray) {
        FilenameFilter myFilter = new FilenameFilter(){

            public boolean accept(File f, String name) {
                return !f.isFile() && name.endsWith(".xml") && !name.startsWith("supplementalData");
            }
        };
        File directory = new File(dir);
        String[] files = directory.list(myFilter);
        StringBuffer brkList = new StringBuffer();
        StringBuffer ctdList = new StringBuffer();
        for (int i = 0; i < files.length; ++i) {
            Document doc = LDMLUtilities.parse(dir + "/" + files[i], false);
            for (Node node = doc.getFirstChild(); node != null; node = node.getNextSibling()) {
                String val;
                String cnName;
                Node cn;
                if (node.getNodeType() != 1) continue;
                String name = node.getNodeName();
                if (name.equals("ldml")) {
                    node = node.getFirstChild();
                    continue;
                }
                if (name.equals("identity")) continue;
                if (name.equals("special")) {
                    node = node.getFirstChild();
                    continue;
                }
                if (name.equals(ICU_BRKITR_DATA)) {
                    node = node.getFirstChild();
                    continue;
                }
                if (name.equals(ICU_BOUNDARIES)) {
                    for (cn = node.getFirstChild(); cn != null; cn = cn.getNextSibling()) {
                        if (cn.getNodeType() != 1) continue;
                        cnName = cn.getNodeName();
                        if (cnName.equals(ICU_GRAPHEME) || cnName.equals(ICU_WORD) || cnName.equals(ICU_TITLE) || cnName.equals(ICU_SENTENCE) || cnName.equals(ICU_LINE)) {
                            val = LDMLUtilities.getAttributeValue(cn, ICU_DEPENDENCY);
                            if (val == null) continue;
                            brkList.append(val.substring(0, val.indexOf(46)));
                            brkList.append(".txt ");
                            continue;
                        }
                        System.err.println("Encountered unknown <" + name + "> subelement: " + cnName);
                        System.exit(-1);
                    }
                    continue;
                }
                if (name.equals(ICU_DICTIONARIES)) {
                    for (cn = node.getFirstChild(); cn != null; cn = cn.getNextSibling()) {
                        if (cn.getNodeType() != 1) continue;
                        cnName = cn.getNodeName();
                        if (cnName.equals(ICU_DICTIONARY)) {
                            val = LDMLUtilities.getAttributeValue(cn, ICU_DEPENDENCY);
                            if (val == null) continue;
                            ctdList.append(val.substring(0, val.indexOf(46)));
                            ctdList.append(".txt ");
                            continue;
                        }
                        System.err.println("Encountered unknown <" + name + "> subelement: " + cnName);
                        System.exit(-1);
                    }
                    continue;
                }
                System.err.println("Encountered unknown <" + doc.getNodeName() + "> subelement: " + name);
                System.exit(-1);
            }
        }
        if (brkList.length() > 0) {
            brkArray[0] = brkList.toString();
        }
        if (ctdList.length() > 0) {
            brkArray[1] = ctdList.toString();
        }
        return brkArray;
    }

    public boolean isDraftStatusOverridable(String locName) {
        if (this.localesMap != null && this.localesMap.size() > 0) {
            String draft = (String)this.localesMap.get(locName + ".xml");
            return draft != null && (draft.equals("true") || locName.matches(draft));
        }
        File f = new File(this.destDir + "/" + locName + ".txt");
        return f.exists();
    }

    private static String fileIteratorToList(Iterator files) {
        String out = "";
        int i = 0;
        while (files.hasNext()) {
            File f = (File)files.next();
            if (++i % 5 == 0) {
                out = out + "\\" + LINESEP;
            }
            out = out + (i == 0 ? " " : " ") + f.getName().substring(0, f.getName().indexOf(46)) + ".txt";
        }
        return out;
    }

    private static String fileMapToList(Map files) {
        return LDML2ICUConverter.fileIteratorToList(files.values().iterator());
    }

    private void writeSimpleLocale(String fileName, ULocale fromLocale, ULocale toLocale, String xpath, String comment) {
        this.writeSimpleLocale(fileName, fromLocale == null ? "" : fromLocale.toString(), toLocale == null ? "" : toLocale.toString(), xpath, comment);
    }

    private void writeSimpleLocale(String fileName, String fromLocale, String toLocale, String xpath, String comment) {
        if (xpath != null) {
            String aString;
            Document doc = LDMLUtilities.newDocument();
            Node root = doc;
            XPathTokenizer myTokenizer = new XPathTokenizer(xpath);
            while ((aString = myTokenizer.nextToken()) != null) {
                if (aString.indexOf(91) == -1) {
                    Element newNode = doc.createElement(aString);
                    root.appendChild(newNode);
                    root = newNode;
                    continue;
                }
                String tag = aString.substring(0, aString.indexOf(91));
                String attribName = aString.substring(aString.indexOf(64) + 1);
                String attribVal = attribName.substring(attribName.indexOf(39) + 1, attribName.lastIndexOf(39));
                attribName = attribName.substring(0, attribName.indexOf(61));
                Element newNode = doc.createElement(tag);
                LDMLUtilities.setAttributeValue(newNode, attribName, attribVal);
                root.appendChild(newNode);
                root = newNode;
            }
            this.locName = fromLocale.toString();
            ICUResourceWriter.Resource res = this.parseBundle(doc);
            res.name = fromLocale.toString();
            if (res != null && ((ICUResourceWriter.ResourceTable)res).first != null) {
                this.writeResource(res, DEPRECATED_LIST);
            } else {
                System.err.println("Failed to write out alias bundle " + fromLocale.toString());
            }
        } else {
            String outputFileName = this.destDir + "/" + fileName;
            ICUResourceWriter.ResourceTable set = null;
            try {
                ICUResourceWriter.ResourceString str;
                ICUResourceWriter.ResourceTable table = new ICUResourceWriter.ResourceTable();
                table.name = fromLocale.toString();
                if (toLocale != null && xpath == null) {
                    str = new ICUResourceWriter.ResourceString();
                    str.name = "\"%%ALIAS\"";
                    str.val = toLocale.toString();
                    table.first = str;
                } else {
                    str = new ICUResourceWriter.ResourceString();
                    str.name = "___";
                    str.val = "";
                    str.comment = "so genrb doesn't issue warnings";
                    table.first = str;
                }
                set = table;
                if (comment != null) {
                    set.comment = comment;
                }
            }
            catch (Throwable e) {
                this.printError("", "building synthetic locale tree for " + outputFileName + ": " + e.toString());
                e.printStackTrace();
                System.exit(1);
            }
            try {
                String info = toLocale != null ? "(alias to " + toLocale.toString() + ")" : comment;
                this.printInfo("Writing synthetic: " + outputFileName + " " + info);
                FileOutputStream file = new FileOutputStream(outputFileName);
                BufferedOutputStream writer = new BufferedOutputStream(file);
                this.writeHeader(writer, DEPRECATED_LIST);
                ICUResourceWriter.Resource current = set;
                while (current != null) {
                    current.sort();
                    current = current.next;
                }
                current = set;
                while (current != null) {
                    current.write(writer, 0, false);
                    current = current.next;
                }
                writer.flush();
                writer.close();
            }
            catch (IOException e) {
                System.err.println("ERROR: While writing synthetic locale " + outputFileName + ": " + e.toString());
                e.printStackTrace();
                System.exit(1);
            }
        }
    }

    private void writeResourceMakefile(String myTreeName, String generatedAliasList, String aliasFilesList, String inFileText, String emptyFileText, String brkFilesList, String ctdFilesList) {
        String stub = "UNKNOWN";
        String shortstub = "unk";
        if (myTreeName.equals("main")) {
            stub = "GENRB";
            shortstub = "res";
        } else if (myTreeName.equals("collation")) {
            stub = "COLLATION";
            shortstub = "col";
        } else if (myTreeName.equals("brkitr")) {
            stub = "BRK_RES";
            shortstub = "brk";
        } else {
            this.printError("", "Unknown tree name in writeResourceMakefile: " + myTreeName);
            System.exit(-1);
        }
        String resfiles_mk_name = this.destDir + "/" + shortstub + "files.mk";
        try {
            this.printInfo("Writing ICU build file: " + resfiles_mk_name);
            PrintStream resfiles_mk = new PrintStream(new FileOutputStream(resfiles_mk_name));
            Calendar c = Calendar.getInstance();
            resfiles_mk.println("# *   Copyright (C) 1998-" + c.get(1) + ", International Business Machines");
            resfiles_mk.println("# *   Corporation and others.  All Rights Reserved.");
            resfiles_mk.println("# A list of txt's to build");
            resfiles_mk.println("# Note: ");
            resfiles_mk.println("#");
            resfiles_mk.println("#   If you are thinking of modifying this file, READ THIS. ");
            resfiles_mk.println("#");
            resfiles_mk.println("# Instead of changing this file [unless you want to check it back in],");
            resfiles_mk.println("# you should consider creating a '" + shortstub + "local.mk' file in this same directory.");
            resfiles_mk.println("# Then, you can have your local changes remain even if you upgrade or");
            resfiles_mk.println("# reconfigure ICU.");
            resfiles_mk.println("#");
            resfiles_mk.println("# Example '" + shortstub + "local.mk' files:");
            resfiles_mk.println("#");
            resfiles_mk.println("#  * To add an additional locale to the list: ");
            resfiles_mk.println("#    _____________________________________________________");
            resfiles_mk.println("#    |  " + stub + "_SOURCE_LOCAL =   myLocale.txt ...");
            resfiles_mk.println("#");
            resfiles_mk.println("#  * To REPLACE the default list and only build with a few");
            resfiles_mk.println("#     locale:");
            resfiles_mk.println("#    _____________________________________________________");
            resfiles_mk.println("#    |  " + stub + "_SOURCE = ar.txt ar_AE.txt en.txt de.txt zh.txt");
            resfiles_mk.println("#");
            resfiles_mk.println("#");
            resfiles_mk.println("# Generated by LDML2ICUConverter, from LDML source files. ");
            resfiles_mk.println("");
            resfiles_mk.println("# Aliases which do not have a corresponding xx.xml file (see icu-config.xml & build.xml)");
            resfiles_mk.println(stub + "_SYNTHETIC_ALIAS =" + generatedAliasList);
            resfiles_mk.println("");
            resfiles_mk.println("");
            resfiles_mk.println("# All aliases (to not be included under 'installed'), but not including root.");
            resfiles_mk.println(stub + "_ALIAS_SOURCE = $(" + stub + "_SYNTHETIC_ALIAS)" + aliasFilesList);
            resfiles_mk.println("");
            resfiles_mk.println("");
            if (ctdFilesList != null) {
                resfiles_mk.println("# List of compact trie dictionary files (ctd).");
                resfiles_mk.println("BRK_CTD_SOURCE = " + ctdFilesList);
                resfiles_mk.println("");
                resfiles_mk.println("");
            }
            if (brkFilesList != null) {
                resfiles_mk.println("# List of break iterator files (brk).");
                resfiles_mk.println("BRK_SOURCE = " + brkFilesList);
                resfiles_mk.println("");
                resfiles_mk.println("");
            }
            if (emptyFileText != null) {
                resfiles_mk.println("# Empty locales, used for validSubLocale fallback.");
                resfiles_mk.println(stub + "_EMPTY_SOURCE =" + emptyFileText);
                resfiles_mk.println("");
                resfiles_mk.println("");
            }
            resfiles_mk.println("# Ordinary resources");
            if (emptyFileText == null) {
                resfiles_mk.print(stub + "_SOURCE =" + inFileText);
            } else {
                resfiles_mk.print(stub + "_SOURCE = $(" + stub + "_EMPTY_SOURCE)" + inFileText);
            }
            resfiles_mk.println("");
            resfiles_mk.println("");
            resfiles_mk.close();
        }
        catch (IOException e) {
            System.err.println("While writing " + resfiles_mk_name);
            e.printStackTrace();
            System.exit(1);
        }
    }

    static {
        keyNameMap.put("days", "dayNames");
        keyNameMap.put("months", "monthNames");
        keyNameMap.put("territories", "Countries");
        keyNameMap.put("languages", "Languages");
        keyNameMap.put("currencies", "Currencies");
        keyNameMap.put("variants", "Variants");
        keyNameMap.put("scripts", "Scripts");
        keyNameMap.put("keys", "Keys");
        keyNameMap.put("types", "Types");
        keyNameMap.put("version", "Version");
        keyNameMap.put("exemplarCharacters", "ExemplarCharacters");
        keyNameMap.put("auxiliary", "AuxExemplarCharacters");
        keyNameMap.put("timeZoneNames", "zoneStrings");
        keyNameMap.put("localizedPatternChars", "localPatternChars");
        keyNameMap.put("paperSize", "PaperSize");
        keyNameMap.put("measurementSystem", "MeasurementSystem");
        keyNameMap.put("measurementSystemNames", "measurementSystemNames");
        keyNameMap.put("fractions", "CurrencyData");
        keyNameMap.put("quarters", "quarters");
        keyNameMap.put("displayName", "dn");
        keyNameMap.put("icu:breakDictionaryData", "BreakDictionaryData");
        deprecatedTerritories.put("BQ", "");
        deprecatedTerritories.put("CT", "");
        deprecatedTerritories.put("DD", "");
        deprecatedTerritories.put("FQ", "");
        deprecatedTerritories.put("FX", "");
        deprecatedTerritories.put("JT", "");
        deprecatedTerritories.put("MI", "");
        deprecatedTerritories.put("NQ", "");
        deprecatedTerritories.put("NT", "");
        deprecatedTerritories.put("PC", "");
        deprecatedTerritories.put("PU", "");
        deprecatedTerritories.put("PZ", "");
        deprecatedTerritories.put("SU", "");
        deprecatedTerritories.put("VD", "");
        deprecatedTerritories.put("WK", "");
        deprecatedTerritories.put("YD", "");
        registeredKeys = new String[]{"collation", "calendar", "currency"};
        collationMap = new TreeMap();
        collationMap.put("first_tertiary_ignorable", "[first tertiary ignorable ]");
        collationMap.put("last_tertiary_ignorable", "[last tertiary ignorable ]");
        collationMap.put("first_secondary_ignorable", "[first secondary ignorable ]");
        collationMap.put("last_secondary_ignorable", "[last secondary ignorable ]");
        collationMap.put("first_primary_ignorable", "[first primary ignorable ]");
        collationMap.put("last_primary_ignorable", "[last primary ignorable ]");
        collationMap.put("first_variable", "[first variable ]");
        collationMap.put("last_variable", "[last variable ]");
        collationMap.put("first_non_ignorable", "[first regular]");
        collationMap.put("last_non_ignorable", "[last regular ]");
        collationMap.put("first_trailing", "[first trailing ]");
        collationMap.put("last_trailing", "[last trailing ]");
        needsQuoting = new UnicodeSet("[[:whitespace:][:c:][:z:][[:ascii:]-[a-zA-Z0-9]]]");
        quoteOperandBuffer = new StringBuffer();
    }
}

