/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.ooo;

import java.util.Hashtable;
import java.util.Vector;
import org.unicode.cldr.ooo.DOMWrapper;
import org.unicode.cldr.util.LDMLUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LDMLReaderForOO {
    private double m_cldr_ver = 0.0;
    private String m_filename = null;
    private Document m_doc = null;
    private DOMWrapper m_domWrapper = null;
    public String m_Version = null;
    public Hashtable m_LocaleInfo = new Hashtable();
    public String m_GenerationDate = null;
    public Vector m_Language_Vect = null;
    public Vector m_Script_Vect = null;
    public Vector m_Territory_Vect = null;
    public String m_LangID = null;
    public String m_TerritoryID = null;
    public String m_LangDefaultName = null;
    public String m_TerritoryDefaultName = null;
    public String m_PlatformID = null;
    public String m_Variant = null;
    public String m_DateSeparator = null;
    public String m_ThousandSeparator = null;
    public String m_DecimalSeparator = null;
    public String m_TimeSeparator = null;
    public String m_Time100SecSeparator = null;
    public String m_TimeAM = null;
    public String m_TimePM = null;
    public String m_ListSeparator = null;
    public String m_QuotationStart = null;
    public String m_QuotationEnd = null;
    public String m_DoubleQuotationStart = null;
    public String m_DoubleQuotationEnd = null;
    public String m_MeasurementSystem = null;
    public String m_LongDateDayOfWeekSeparator = null;
    public String m_LongDateDaySeparator = null;
    public String m_LongDateMonthSeparator = null;
    public String m_LongDateYearSeparator = null;
    public String m_FormatRefLocale = null;
    public String m_FormatReplaceFrom = null;
    public String m_FormatReplaceTo = null;
    public Hashtable m_FixedNFormats = null;
    public Hashtable m_FixedNPatterns = null;
    public Hashtable m_FixedNOO = null;
    public Hashtable m_FixedDefaultName = null;
    public Hashtable m_FractNFormats = null;
    public Hashtable m_FractNPatterns = null;
    public Hashtable m_FractNOO = null;
    public Hashtable m_FractDefaultName = null;
    public Hashtable m_PercNFormats = null;
    public Hashtable m_PercNPatterns = null;
    public Hashtable m_PercNOO = null;
    public Hashtable m_PercDefaultName = null;
    public Hashtable m_SciNFormats = null;
    public Hashtable m_SciNPatterns = null;
    public Hashtable m_SciNOO = null;
    public Hashtable m_SciDefaultName = null;
    public Hashtable m_CurrNFormats = null;
    public Hashtable m_CurrNPatterns = null;
    public Hashtable m_CurrNOO = null;
    public Hashtable m_CurrNDefaultName = null;
    public Hashtable m_DateFormats = null;
    public Hashtable m_DatePatterns = null;
    public Hashtable m_DateOO = null;
    public Hashtable m_DateDefaultName = null;
    public Hashtable m_TimeFormats = null;
    public Hashtable m_TimePatterns = null;
    public Hashtable m_TimeOO = null;
    public Hashtable m_TimeDefaultName = null;
    public Hashtable m_DateTimeFormats = null;
    public Hashtable m_DateTimePatterns = null;
    public Hashtable m_DateTimeOO = null;
    public Hashtable m_DateTimeDefaultName = null;
    public String m_CollationRefLocale = null;
    public Vector m_Collators = null;
    public Vector m_CollationOptions = null;
    public String m_SearchRefLocale = null;
    public Vector m_SearchOptions = null;
    public String m_IndexRefLocale = null;
    public Vector m_IndexKeys = null;
    public Vector m_IndexUnicodeScript = null;
    public Vector m_IndexFollowPageWord = null;
    public Vector m_CalendarTypes = null;
    public Vector m_CalendarDefaultAttribs = null;
    public Hashtable m_AbbrDays = null;
    public Hashtable m_FullDays = null;
    public Hashtable m_AbbrMonths = null;
    public Hashtable m_FullMonths = null;
    public Hashtable m_EraNames = null;
    public Hashtable m_AbbrEras = null;
    public Hashtable m_StartOfWeeks = null;
    public Hashtable m_MinDays = null;
    public Hashtable m_AbbrQuarters = null;
    public Hashtable m_WideQuarters = null;
    public Vector m_CurrencyData_ooo = new Vector();
    public Vector m_CurrencyData_cldr = new Vector();
    public String m_TransliterationRefLocale = null;
    public Vector m_TransliterationAtts = null;
    public String m_ReservedRefLocale = null;
    public Hashtable m_ReservedWords = null;
    public String m_ForbiddenRefLocale = null;
    public String m_ForbiddenLineBeg = null;
    public String m_ForbiddenLineEnd = null;
    public String m_NumberingRefLocale = null;
    public Vector m_NumberingLevelAtts = null;
    public String m_OutlineNumberingRefLocale = null;
    public Vector m_OutlineNumberingLevels = null;
    public Vector m_DateFormatItems = null;

    public LDMLReaderForOO(String filename) {
        this.m_filename = filename;
    }

    public void readDocument(String locale, boolean bIsCLDR) {
        if (this.m_filename == null) {
            return;
        }
        if (bIsCLDR) {
            String sourceDir = this.m_filename.substring(0, this.m_filename.lastIndexOf(47));
            this.m_doc = LDMLUtilities.getFullyResolvedLDML(sourceDir, locale, false, false, false, false);
        } else {
            this.m_doc = LDMLUtilities.parse(this.m_filename, false);
        }
        String sysId = this.m_doc.getDoctype().getSystemId();
        String ver = sysId.substring(sysId.indexOf("/dtd/") + 5, sysId.indexOf("/ldml.dtd"));
        Double d = new Double(ver);
        this.m_cldr_ver = d;
    }

    public double getCLDRVersion() {
        return this.m_cldr_ver;
    }

    public boolean readInXML(boolean bIsCLDR) {
        if (this.m_filename == null) {
            return false;
        }
        boolean bRc = false;
        this.m_domWrapper = new DOMWrapper(this.m_doc);
        if (this.m_doc == null) {
            return false;
        }
        if (!this.m_domWrapper.elementExists("ldml")) {
            return false;
        }
        this.readXML();
        if (!bIsCLDR) {
            this.readSpecialXML();
        }
        bRc = true;
        return bRc;
    }

    private void readXML() {
        this.m_Version = this.m_domWrapper.getAttributeFromElement("identity", "version");
        String generationStr = this.m_domWrapper.getAttributeValue("generation", "date");
        if (generationStr != null && generationStr.length() > 0) {
            this.m_GenerationDate = generationStr;
        }
        this.m_Language_Vect = this.m_domWrapper.getAttributesFromElement("identity", "language");
        this.m_Script_Vect = this.m_domWrapper.getAttributesFromElement("identity", "script");
        this.m_Territory_Vect = this.m_domWrapper.getAttributesFromElement("identity", "territory");
        if (this.m_Language_Vect != null && this.m_Language_Vect.size() > 0) {
            Hashtable languageTable = (Hashtable)this.m_Language_Vect.elementAt(0);
            this.m_LangID = languageTable != null ? (String)languageTable.get("type") : "";
        }
        if (this.m_Territory_Vect != null && this.m_Territory_Vect.size() > 0) {
            Hashtable territoryTable = (Hashtable)this.m_Territory_Vect.elementAt(0);
            this.m_TerritoryID = territoryTable != null ? (String)territoryTable.get("type") : "";
        }
        if (this.m_TerritoryID != null && this.m_TerritoryID.compareTo("CS") == 0) {
            this.m_TerritoryID = "YU";
        }
        this.m_ThousandSeparator = this.m_domWrapper.getTextFromElement("group");
        this.m_DecimalSeparator = this.m_domWrapper.getTextFromElement("decimal");
        this.m_ListSeparator = this.m_domWrapper.getTextFromElement("list");
        this.m_QuotationStart = this.m_domWrapper.getTextFromElement("quotationStart");
        this.m_QuotationEnd = this.m_domWrapper.getTextFromElement("quotationEnd");
        this.m_DoubleQuotationStart = this.m_domWrapper.getTextFromElement("alternateQuotationStart");
        this.m_DoubleQuotationEnd = this.m_domWrapper.getTextFromElement("alternateQuotationEnd");
        this.m_TimeAM = this.m_domWrapper.getTextFromElement("am");
        this.m_TimePM = this.m_domWrapper.getTextFromElement("pm");
        this.m_MeasurementSystem = this.m_domWrapper.getAttributeFromElement("measurement", "measurementSystem", "type");
        this.m_CalendarTypes = this.m_domWrapper.getAttributesFromElement("calendars", "calendar");
        this.m_CalendarDefaultAttribs = this.m_domWrapper.getAttributesFromElement("calendars", "default");
        this.m_AbbrDays = this.m_domWrapper.getTextFromAllElementsWithGGGParent("day", "type", "dayWidth", "type", "abbreviated", "dayContext", "days", "calendar", "type", "type", "format");
        this.m_FullDays = this.m_domWrapper.getTextFromAllElementsWithGGGParent("day", "type", "dayWidth", "type", "wide", "dayContext", "days", "calendar", "type", "type", "format");
        this.m_AbbrMonths = this.m_domWrapper.getTextFromAllElementsWithGGGParent("month", "type", "monthWidth", "type", "abbreviated", "monthContext", "months", "calendar", "type", "type", "format");
        this.m_FullMonths = this.m_domWrapper.getTextFromAllElementsWithGGGParent("month", "type", "monthWidth", "type", "wide", "monthContext", "months", "calendar", "type", "type", "format");
        this.m_EraNames = this.m_domWrapper.getTextFromAllElementsWithGGParent("era", "type", "eraNames", "eras", "calendar", "type");
        this.m_AbbrEras = this.m_domWrapper.getTextFromAllElementsWithGGParent("era", "type", "eraAbbr", "eras", "calendar", "type");
        if (this.m_cldr_ver > 1.399) {
            this.m_AbbrQuarters = this.m_domWrapper.getTextFromAllElementsWithGGGParent("quarter", "type", "quarterWidth", "type", "abbreviated", "quarterContext", "quarters", "calendar", "type", "type", "format");
            this.m_WideQuarters = this.m_domWrapper.getTextFromAllElementsWithGGGParent("quarter", "type", "quarterWidth", "type", "wide", "quarterContext", "quarters", "calendar", "type", "type", "format");
        }
        this.m_StartOfWeeks = this.m_domWrapper.getAttributeFromElementsAndGPAttrib("week", "firstDay", "day", "type");
        this.m_MinDays = this.m_domWrapper.getAttributeFromElementsAndGPAttrib("week", "minDays", "count", "type");
        String SearchLocation = "//ldml/numbers/currencies/currency";
        NodeList nl_code = LDMLUtilities.getNodeList(this.m_doc, SearchLocation);
        for (int i = 0; i < nl_code.getLength(); ++i) {
            Vector<String> inner = new Vector<String>();
            String code = LDMLUtilities.getAttributeValue(nl_code.item(i), "type");
            String symbol = null;
            String name = null;
            Node n = LDMLUtilities.getNode(this.m_doc, SearchLocation + "[@type=\"" + code + "\"]/symbol");
            if (n != null) {
                symbol = LDMLUtilities.getNodeValue(n);
            }
            if ((n = LDMLUtilities.getNode(this.m_doc, SearchLocation + "[@type=\"" + code + "\"]/displayName")) != null) {
                name = LDMLUtilities.getNodeValue(n);
            }
            if (symbol == null || name == null) continue;
            inner.add(0, "blank");
            inner.add(1, symbol);
            inner.add(2, code);
            inner.add(3, name);
            this.m_CurrencyData_cldr.add(inner);
        }
        this.m_DateFormatItems = this.m_domWrapper.getTextFromAllElements("availableFormats", "dateFormatItem");
    }

    private void readSpecialXML() {
        String versionDTD;
        String allowUpdateFromCLDR;
        String version = this.m_domWrapper.getAttributeFromElement("openOffice:locale", "openOffice:version");
        if (version != null) {
            this.m_LocaleInfo.put("version", version);
        }
        if ((allowUpdateFromCLDR = this.m_domWrapper.getAttributeFromElement("openOffice:locale", "openOffice:allowUpdateFromCLDR")) != null) {
            this.m_LocaleInfo.put("allowUpdateFromCLDR", allowUpdateFromCLDR);
        }
        if ((versionDTD = this.m_domWrapper.getAttributeFromElement("openOffice:locale", "openOffice:versionDTD")) != null) {
            this.m_LocaleInfo.put("versionDTD", versionDTD);
        }
        if (this.m_LangID != null) {
            this.m_LangDefaultName = this.m_domWrapper.getTextFromElementWithAttrib("openOffice:defaultName", "openOffice:type", this.m_LangID, "special", "languages");
        }
        if (this.m_TerritoryID != null) {
            this.m_TerritoryDefaultName = this.m_domWrapper.getTextFromElementWithAttrib("openOffice:defaultName", "openOffice:type", this.m_TerritoryID, "special", "territories");
        }
        this.m_PlatformID = this.m_domWrapper.getTextFromElement("special", "openOffice:platformId");
        this.m_Variant = this.m_domWrapper.getAttributeFromElement("identity", "variant", "type");
        this.m_DateSeparator = this.m_domWrapper.getTextFromElement("openOffice:dateSeparator");
        this.m_TimeSeparator = this.m_domWrapper.getTextFromElement("openOffice:timeSeparator");
        this.m_Time100SecSeparator = this.m_domWrapper.getTextFromElement("openOffice:time100SecSeparator");
        this.m_LongDateDayOfWeekSeparator = this.m_domWrapper.getTextFromElement("openOffice:longDateDayOfWeekSeparator");
        this.m_LongDateDaySeparator = this.m_domWrapper.getTextFromElement("openOffice:longDateDaySeparator");
        this.m_LongDateMonthSeparator = this.m_domWrapper.getTextFromElement("openOffice:longDateMonthSeparator");
        this.m_LongDateYearSeparator = this.m_domWrapper.getTextFromElement("openOffice:longDateYearSeparator");
        this.m_FormatRefLocale = this.m_domWrapper.getAttributeValue("openOffice:format", "openOffice:ref");
        this.m_FormatReplaceFrom = this.m_domWrapper.getAttributeFromElement("special", "openOffice:format", "openOffice:replaceFrom");
        this.m_FormatReplaceTo = this.m_domWrapper.getAttributeFromElement("special", "openOffice:format", "openOffice:replaceTo");
        if (this.m_FormatRefLocale == null) {
            this.m_FixedNFormats = this.m_domWrapper.getAttributesFromElement("decimalFormatLength", "decimalFormat", "type");
            this.m_FixedNPatterns = this.m_domWrapper.getTextFromElementsAndParentAttrib("decimalFormat", "pattern", "type");
            this.m_FixedNOO = this.m_domWrapper.getAttributesFromElement("decimalFormat", "special", "openOffice:msgtype");
            this.m_FixedDefaultName = this.m_domWrapper.getTextFromElementsAndGPAttrib("openOffice:defaultName", "special", "decimalFormat", "type");
            this.m_SciNFormats = this.m_domWrapper.getAttributesFromElement("scientificFormatLength", "scientificFormat", "type");
            this.m_SciNPatterns = this.m_domWrapper.getTextFromElementsAndParentAttrib("scientificFormat", "pattern", "type");
            this.m_SciNOO = this.m_domWrapper.getAttributesFromElement("scientificFormat", "special", "openOffice:msgtype");
            this.m_SciDefaultName = this.m_domWrapper.getTextFromElementsAndGPAttrib("openOffice:defaultName", "special", "scientificFormat", "type");
            this.m_PercNFormats = this.m_domWrapper.getAttributesFromElement("percentFormatLength", "percentFormat", "type");
            this.m_PercNPatterns = this.m_domWrapper.getTextFromElementsAndParentAttrib("percentFormat", "pattern", "type");
            this.m_PercNOO = this.m_domWrapper.getAttributesFromElement("percentFormat", "special", "openOffice:msgtype");
            this.m_PercDefaultName = this.m_domWrapper.getTextFromElementsAndGPAttrib("openOffice:defaultName", "special", "percentFormat", "type");
            this.m_CurrNFormats = this.m_domWrapper.getAttributesFromElement("currencyFormatLength", "currencyFormat", "type");
            this.m_CurrNPatterns = this.m_domWrapper.getTextFromElementsAndParentAttrib("currencyFormat", "pattern", "type");
            this.m_CurrNOO = this.m_domWrapper.getAttributesFromElement("currencyFormat", "special", "openOffice:msgtype");
            this.m_CurrNDefaultName = this.m_domWrapper.getTextFromElementsAndGPAttrib("openOffice:defaultName", "special", "currencyFormat", "type");
            this.m_DateFormats = this.m_domWrapper.getAttributesFromElement("dateFormatLength", "dateFormat", "type");
            this.m_DatePatterns = this.m_domWrapper.getTextFromElementsAndParentAttrib("dateFormat", "pattern", "type");
            this.m_DateOO = this.m_domWrapper.getAttributesFromElement("dateFormat", "special", "openOffice:msgtype");
            this.m_DateDefaultName = this.m_domWrapper.getTextFromElementsAndGPAttrib("openOffice:defaultName", "special", "dateFormat", "type");
            this.m_TimeFormats = this.m_domWrapper.getAttributesFromElement("timeFormatLength", "timeFormat", "type");
            this.m_TimePatterns = this.m_domWrapper.getTextFromElementsAndParentAttrib("timeFormat", "pattern", "type");
            this.m_TimeOO = this.m_domWrapper.getAttributesFromElement("timeFormat", "special", "openOffice:msgtype");
            this.m_TimeDefaultName = this.m_domWrapper.getTextFromElementsAndGPAttrib("openOffice:defaultName", "special", "timeFormat", "type");
            this.m_DateTimeFormats = this.m_domWrapper.getAttributesFromElement("dateTimeFormatLength", "dateTimeFormat", "type");
            this.m_DateTimePatterns = this.m_domWrapper.getTextFromElementsAndParentAttrib("dateTimeFormat", "pattern", "type");
            this.m_DateTimeOO = this.m_domWrapper.getAttributesFromElement("dateTimeFormat", "special", "openOffice:msgtype");
            this.m_DateTimeDefaultName = this.m_domWrapper.getTextFromElementsAndGPAttrib("openOffice:defaultName", "special", "dateTimeFormat", "type");
        }
        this.m_CollationRefLocale = this.m_domWrapper.getAttributeValue("openOffice:collations", "openOffice:ref");
        if (this.m_CollationRefLocale == null) {
            this.m_Collators = this.m_domWrapper.getAttributesFromElement("openOffice:collations", "openOffice:collator");
            this.m_CollationOptions = this.m_domWrapper.getTextFromAllElements("openOffice:collationOptions", "openOffice:transliterationModules");
        }
        this.m_SearchRefLocale = this.m_domWrapper.getAttributeValue("openOffice:search", "openOffice:ref");
        if (this.m_SearchRefLocale == null) {
            this.m_SearchOptions = this.m_domWrapper.getTextFromAllElements("openOffice:searchOptions", "openOffice:transliterationModules");
        }
        this.m_IndexRefLocale = this.m_domWrapper.getAttributeValue("openOffice:index", "openOffice:ref");
        if (this.m_IndexRefLocale == null) {
            this.m_IndexKeys = this.m_domWrapper.getAttributesAndTextFromAllElements("openOffice:index", "openOffice:indexKey");
            this.m_IndexUnicodeScript = this.m_domWrapper.getTextFromAllElements("openOffice:index", "openOffice:unicodeScript");
            this.m_IndexFollowPageWord = this.m_domWrapper.getTextFromAllElements("openOffice:index", "openOffice:followPageWord");
        }
        String SearchLocation = "//ldml/numbers/currencies/currency";
        NodeList ns = LDMLUtilities.getNodeList(this.m_doc, SearchLocation + "/special");
        NodeList nl_id = LDMLUtilities.getNodeList(this.m_doc, SearchLocation + "/special/openOffice:currency/openOffice:currencyId", ns.item(0));
        NodeList nl_symbol = LDMLUtilities.getNodeList(this.m_doc, SearchLocation + "/symbol");
        NodeList nl_code = LDMLUtilities.getNodeList(this.m_doc, SearchLocation);
        NodeList nl_name = LDMLUtilities.getNodeList(this.m_doc, SearchLocation + "/displayName");
        NodeList nl_attrs = LDMLUtilities.getNodeList(this.m_doc, SearchLocation + "/special/openOffice:currency", ns.item(0));
        for (int i = 0; i < nl_code.getLength(); ++i) {
            Vector<String> inner = new Vector<String>();
            String id = LDMLUtilities.getNodeValue(nl_id.item(i));
            inner.add(0, id);
            String symbol = LDMLUtilities.getNodeValue(nl_symbol.item(i));
            inner.add(1, symbol);
            String code = LDMLUtilities.getAttributeValue(nl_code.item(i), "type");
            inner.add(2, code);
            String name = LDMLUtilities.getNodeValue(nl_name.item(i));
            inner.add(3, name);
            inner.add(4, "blank");
            String def = LDMLUtilities.getAttributeValue(nl_attrs.item(i), "openOffice:default");
            inner.add(5, def);
            String uicfc = LDMLUtilities.getAttributeValue(nl_attrs.item(i), "openOffice:usedInCompatibleFormatCodes");
            inner.add(6, uicfc);
            String legacyOnly = LDMLUtilities.getAttributeValue(nl_attrs.item(i), "openOffice:legacyOnly");
            if (legacyOnly != null) {
                inner.add(7, legacyOnly);
            }
            this.m_CurrencyData_ooo.add(inner);
        }
        this.m_TransliterationRefLocale = this.m_domWrapper.getAttributeValue("openOffice:transliterations", "openOffice:ref");
        if (this.m_TransliterationRefLocale == null) {
            this.m_TransliterationAtts = this.m_domWrapper.getAttributesFromElement("openOffice:transliterations", "openOffice:transliteration");
        }
        this.m_ReservedRefLocale = this.m_domWrapper.getAttributeValue("openOffice:reservedWords", "openOffice:ref");
        if (this.m_ReservedRefLocale == null) {
            this.m_ReservedWords = new Hashtable();
            String text = this.m_domWrapper.getTextFromElement("openOffice:trueWord");
            if (text != null) {
                this.m_ReservedWords.put("trueWord", text);
            }
            if ((text = this.m_domWrapper.getTextFromElement("openOffice:falseWord")) != null) {
                this.m_ReservedWords.put("falseWord", text);
            }
            if ((text = this.m_domWrapper.getTextFromElement("openOffice:aboveWord")) != null) {
                this.m_ReservedWords.put("aboveWord", text);
            }
            if ((text = this.m_domWrapper.getTextFromElement("openOffice:belowWord")) != null) {
                this.m_ReservedWords.put("belowWord", text);
            }
            if (this.m_cldr_ver < 1.399) {
                text = this.m_domWrapper.getTextFromElement("openOffice:quarter1Word");
                if (text != null) {
                    this.m_WideQuarters.put("quarter1Word", text);
                }
                if ((text = this.m_domWrapper.getTextFromElement("openOffice:quarter2Word")) != null) {
                    this.m_WideQuarters.put("quarter2Word", text);
                }
                if ((text = this.m_domWrapper.getTextFromElement("openOffice:quarter3Word")) != null) {
                    this.m_WideQuarters.put("quarter3Word", text);
                }
                if ((text = this.m_domWrapper.getTextFromElement("openOffice:quarter4Word")) != null) {
                    this.m_WideQuarters.put("quarter4Word", text);
                }
                if ((text = this.m_domWrapper.getTextFromElement("openOffice:quarter1Abbreviation")) != null) {
                    this.m_AbbrQuarters.put("quarter1Abbreviation", text);
                }
                if ((text = this.m_domWrapper.getTextFromElement("openOffice:quarter2Abbreviation")) != null) {
                    this.m_AbbrQuarters.put("quarter2Abbreviation", text);
                }
                if ((text = this.m_domWrapper.getTextFromElement("openOffice:quarter3Abbreviation")) != null) {
                    this.m_AbbrQuarters.put("quarter3Abbreviation", text);
                }
                if ((text = this.m_domWrapper.getTextFromElement("openOffice:quarter4Abbreviation")) != null) {
                    this.m_AbbrQuarters.put("quarter4Abbreviation", text);
                }
            }
        }
        this.m_ForbiddenRefLocale = this.m_domWrapper.getAttributeValue("openOffice:forbiddenCharacters", "ref");
        if (this.m_ForbiddenRefLocale == null) {
            this.m_ForbiddenLineBeg = this.m_domWrapper.getTextFromElement("openOffice:forbiddenCharacters", "openOffice:forbiddenLineBeginCharacters");
            this.m_ForbiddenLineEnd = this.m_domWrapper.getTextFromElement("openOffice:forbiddenCharacters", "openOffice:forbiddenLineEndCharacters");
        }
        this.m_NumberingRefLocale = this.m_domWrapper.getAttributeValue("openOffice:numberingLevels", "openOffice:ref");
        if (this.m_NumberingRefLocale == null) {
            this.m_NumberingLevelAtts = this.m_domWrapper.getAttributesFromElement("openOffice:numberingLevels", "openOffice:numberingLevel");
        }
        this.m_OutlineNumberingRefLocale = this.m_domWrapper.getAttributeValue("openOffice:outLineNumberingLevels", "openOffice:ref");
        if (this.m_OutlineNumberingRefLocale == null) {
            this.m_OutlineNumberingLevels = this.m_domWrapper.getAttributesFromElementGroups("openOffice:outlineStyle", "openOffice:outLineNumberingLevel");
        }
    }
}

