/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.ooo;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import org.unicode.cldr.ooo.Logging;

public class Utilities {
    public static PrintStream setLocaleWriter(String localeStr, String enc, String subDir) {
        if (localeStr == null || subDir == null) {
            return null;
        }
        File dir = new File("./" + subDir);
        if (!dir.exists()) {
            dir.mkdir();
        }
        PrintStream ps = null;
        try {
            String fileName = Utilities.getOutputFilename(localeStr, enc, subDir);
            if (fileName != null && fileName.compareTo("") != 0) {
                FileOutputStream fos = new FileOutputStream(new File(fileName));
                ps = new PrintStream((OutputStream)fos, true, "UTF8");
                Logging.Log1("Writing to file : " + fileName);
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("Unable to create output file");
        }
        catch (UnsupportedEncodingException e) {
            System.err.println("Unsupported encoding");
        }
        return ps;
    }

    public static PrintStream setLocaleWriter2(String localeStr, String enc, String fullPath) {
        if (localeStr == null || fullPath == null) {
            return null;
        }
        File dir = new File(fullPath);
        if (!dir.exists()) {
            dir.mkdir();
        }
        PrintStream ps = null;
        try {
            String fileName = Utilities.getOutputFilename2(localeStr, enc, fullPath);
            if (fileName != null && fileName.compareTo("") != 0) {
                FileOutputStream fos = new FileOutputStream(new File(fileName));
                ps = new PrintStream((OutputStream)fos, true, "UTF8");
                Logging.Log1("Writing to file : " + fileName);
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("Unable to create output file");
        }
        catch (UnsupportedEncodingException e) {
            System.err.println("Unsupported encoding");
        }
        return ps;
    }

    public static String getOutputFilename(String localeStr, String enc, String subDir) {
        if (localeStr == null || subDir == null) {
            return null;
        }
        if (localeStr.compareTo("iw") == 0) {
            localeStr = "he";
        } else if (localeStr.compareTo("iw_IL") == 0) {
            localeStr = "he_IL";
        }
        String localeFileName = "";
        localeFileName = enc != null && enc.compareTo("") != 0 ? "./" + subDir + "/" + localeStr + "." + enc + ".xml" : "./" + subDir + "/" + localeStr + ".xml";
        return localeFileName;
    }

    public static String getOutputFilename2(String localeStr, String enc, String fullPath) {
        if (localeStr == null || fullPath == null) {
            return null;
        }
        if (localeStr.compareTo("iw") == 0) {
            localeStr = "he";
        } else if (localeStr.compareTo("iw_IL") == 0) {
            localeStr = "he_IL";
        }
        String localeFileName = "";
        localeFileName = enc != null && enc.compareTo("") != 0 ? fullPath + "/" + localeStr + "." + enc + ".xml" : fullPath + "/" + localeStr + ".xml";
        return localeFileName;
    }

    public static String stringFromLocale(Locale locale) {
        String variant;
        String localeStr = "";
        if (locale == null) {
            return localeStr;
        }
        localeStr = locale.getLanguage();
        String territory = locale.getCountry();
        if (territory != "") {
            localeStr = localeStr + "_";
            localeStr = localeStr + territory;
        }
        if ((variant = locale.getVariant()) != "") {
            localeStr = localeStr + "_";
            localeStr = localeStr + variant;
        }
        return localeStr;
    }

    public static Locale localeFromString(String localeName) {
        if (localeName == null) {
            return new Locale("", "", "");
        }
        String language = localeName;
        String country = "";
        String variant = "";
        int ndx = language.indexOf(95);
        if (ndx >= 0) {
            country = language.substring(ndx + 1);
            language = language.substring(0, ndx);
        }
        if ((ndx = country.indexOf(95)) >= 0) {
            variant = country.substring(ndx + 1);
            country = country.substring(0, ndx);
        }
        return new Locale(language, country, variant);
    }

    public static Locale localeFromStringWithOptions(String localeName) {
        if (localeName == null) {
            return new Locale("", "", "");
        }
        String variant = "";
        String language = "";
        String country = "";
        int ndx = localeName.indexOf(64);
        language = ndx > 0 ? localeName.substring(0, ndx) : localeName;
        ndx = language.indexOf(95);
        if (ndx >= 0) {
            country = language.substring(ndx + 1);
            language = language.substring(0, ndx);
        }
        if ((ndx = country.indexOf(95)) >= 0) {
            variant = country.substring(ndx + 1);
            country = country.substring(0, ndx);
        }
        return new Locale(language, country, variant);
    }

    public static String extractLocaleFromFilename(String filename) {
        int lastSlash = filename.lastIndexOf(47);
        if (lastSlash < 0) {
            lastSlash = -1;
        }
        int lastDot = filename.lastIndexOf(46);
        String localeStr = filename.substring(lastSlash + 1, lastDot);
        return localeStr;
    }
}

