/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.test;

import com.ibm.icu.dev.test.TestFmwk;
import com.ibm.icu.dev.test.util.BagFormatter;
import com.ibm.icu.text.BreakIterator;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.ULocale;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.LanguageTagParser;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.TimezoneFormatter;
import org.unicode.cldr.util.Utility;
import org.unicode.cldr.util.XPathParts;
import org.xml.sax.SAXException;

public class CLDRTest
extends TestFmwk {
    private static String MATCH;
    private static String MAIN_DIR;
    private static boolean SKIP_DRAFT;
    private Set locales;
    private Set languageLocales;
    private CLDRFile.Factory cldrFactory;
    private CLDRFile resolvedRoot;
    private CLDRFile resolvedEnglish;
    private final UnicodeSet commonAndInherited = new UnicodeSet("[[:script=common:][:script=inherited:][:alphabetic=false:]]");
    private static int[][] DIGIT_COUNT;
    private static int[][] POSIX_DIGIT_COUNT;
    private static final String[] WIDTHS;
    private static final String[] MONTHORDAYS;
    private Map localeNameCache = new HashMap();
    private CLDRFile english = null;
    private Set surveyInfo = new TreeSet();
    public static final byte NOT_NUMERIC_TYPE = -1;
    public static final byte CURRENCY_TYPE = 0;
    public static final byte DECIMAL_TYPE = 1;
    public static final byte PERCENT_TYPE = 2;
    public static final byte SCIENTIFIC_TYPE = 3;
    public static final String[] TYPE_NAME;
    static String[] EXEMPLAR_SKIPS;
    static final long disableDate;
    Map completionExceptions = Utility.asMap(new Object[][]{{"script", new HashSet<String>(Arrays.asList("Cham", "Thai"))}});
    Utility.Transform EnglishName = new Utility.Transform(){

        public Object transform(Object source) {
            return CLDRTest.this.getLocalization(source.toString()) + " (" + source + ")";
        }
    };
    Utility.Transform EnglishCurrencyName = new Utility.Transform(){

        public Object transform(Object source) {
            if (CLDRTest.this.english == null) {
                CLDRTest.this.english = CLDRTest.this.cldrFactory.make("en", true);
            }
            return CLDRTest.this.english.getName("currency", source.toString(), false) + " (" + source + ")";
        }
    };
    static final UnicodeSet XGRAPHEME;
    static final UnicodeSet DIGIT;

    public static void main(String[] args) throws Exception {
        MATCH = System.getProperty("XML_MATCH");
        if (MATCH == null) {
            MATCH = ".*";
        } else {
            System.out.println("Resetting MATCH:" + MATCH);
        }
        MAIN_DIR = System.getProperty("XML_MAIN_DIR");
        if (MAIN_DIR == null) {
            MAIN_DIR = "../../common/main/";
        } else {
            System.out.println("Resetting MAIN_DIR:" + MAIN_DIR);
        }
        boolean bl = SKIP_DRAFT = System.getProperty("XML_SKIP_DRAFT") != null;
        if (SKIP_DRAFT) {
            System.out.println("Skipping Draft locales");
        }
        double deltaTime = System.currentTimeMillis();
        new CLDRTest().run(args);
        deltaTime = (double)System.currentTimeMillis() - deltaTime;
        System.out.println("Seconds: " + deltaTime / 1000.0);
    }

    public void TestZZZZHack() throws IOException {
        PrintWriter surveyFile = BagFormatter.openUTF8Writer((String)"../../dropbox/gen/", (String)"surveyInfo.txt");
        Iterator it = this.surveyInfo.iterator();
        while (it.hasNext()) {
            surveyFile.println(it.next());
        }
        surveyFile.close();
    }

    public CLDRTest() throws SAXException, IOException {
        this.cldrFactory = CLDRFile.Factory.make(MAIN_DIR, MATCH);
        this.locales = this.cldrFactory.getAvailable();
        this.languageLocales = this.cldrFactory.getAvailableLanguages();
        this.resolvedRoot = this.cldrFactory.make("root", true);
        this.resolvedEnglish = this.cldrFactory.make("en", true);
    }

    public void TestCurrencyFormats() {
        Iterator it = this.locales.iterator();
        while (it.hasNext()) {
            String locale = (String)it.next();
            boolean isPOSIX = locale.indexOf("POSIX") >= 0;
            this.logln("Testing: " + locale);
            CLDRFile item = this.cldrFactory.make(locale, false);
            Iterator it2 = item.iterator();
            while (it2.hasNext()) {
                String value;
                String pattern;
                String xpath = (String)it2.next();
                byte type = CLDRTest.getNumericType(xpath);
                if (type == -1 || (pattern = CLDRTest.getCanonicalPattern(value = item.getStringValue(xpath), type, isPOSIX)).equals(value)) continue;
                String draft = "";
                if (item.getFullXPath(xpath).indexOf("[@draft=\"unconfirmed\"]") >= 0) {
                    draft = " [draft]";
                }
                this.assertEquals(this.getLocaleAndName(locale) + draft + " " + TYPE_NAME[type] + " pattern incorrect", pattern, value);
            }
        }
    }

    public static byte getNumericType(String xpath) {
        if (!xpath.startsWith("//ldml/numbers/") || xpath.indexOf("/pattern") < 0) {
            return -1;
        }
        if (xpath.startsWith("//ldml/numbers/currencyFormats/")) {
            return 0;
        }
        if (xpath.startsWith("//ldml/numbers/decimalFormats/")) {
            return 1;
        }
        if (xpath.startsWith("//ldml/numbers/percentFormats/")) {
            return 2;
        }
        if (xpath.startsWith("//ldml/numbers/scientificFormats/")) {
            return 3;
        }
        if (xpath.startsWith("//ldml/numbers/currencies/currency/")) {
            return 0;
        }
        return -1;
    }

    public static String getCanonicalPattern(String inpattern, byte type, boolean isPOSIX) {
        DecimalFormat df = new DecimalFormat(inpattern);
        int decimals = type == 0 ? 2 : 1;
        int[] digits = isPOSIX ? POSIX_DIGIT_COUNT[type] : DIGIT_COUNT[type];
        df.setMinimumIntegerDigits(digits[0]);
        df.setMinimumFractionDigits(digits[1]);
        df.setMaximumFractionDigits(digits[2]);
        String pattern = df.toPattern();
        return pattern;
    }

    public void TestCommonChildren() {
        if (this.disableUntilLater("TestCommonChildren")) {
            return;
        }
        TreeMap<String, ValueCount> currentValues = new TreeMap<String, ValueCount>();
        TreeSet<String> okValues = new TreeSet<String>();
        Iterator it = this.languageLocales.iterator();
        while (it.hasNext()) {
            String xpath;
            Iterator it2;
            String parent = (String)it.next();
            this.logln("Testing: " + parent);
            currentValues.clear();
            okValues.clear();
            Set availableWithParent = this.cldrFactory.getAvailableWithParent(parent, true);
            Iterator it1 = availableWithParent.iterator();
            while (it1.hasNext()) {
                String locale = (String)it1.next();
                this.logln("\tTesting: " + locale);
                CLDRFile item = this.cldrFactory.make(locale, false);
                it2 = item.iterator();
                while (it2.hasNext()) {
                    xpath = (String)it2.next();
                    if (okValues.contains(xpath) || xpath.startsWith("//ldml/identity/")) continue;
                    String v = item.getStringValue(xpath);
                    ValueCount last = (ValueCount)currentValues.get(xpath);
                    if (last == null) {
                        ValueCount vc = new ValueCount();
                        vc.value = v;
                        vc.fullxpath = item.getFullXPath(xpath);
                        currentValues.put(xpath, vc);
                        continue;
                    }
                    if (v.equals(last.value)) {
                        ++last.count;
                        continue;
                    }
                    okValues.add(xpath);
                    currentValues.remove(xpath);
                }
            }
            if (currentValues.size() == 0) continue;
            int size = availableWithParent.size();
            CLDRFile parentCLDR = this.cldrFactory.make(parent, true);
            XPathParts p = new XPathParts(null, null);
            it2 = currentValues.keySet().iterator();
            while (it2.hasNext()) {
                xpath = (String)it2.next();
                ValueCount vc = (ValueCount)currentValues.get(xpath);
                if (vc.count != size && (!vc.value.equals(parentCLDR.getStringValue(xpath)) || !vc.fullxpath.equals(parentCLDR.getStringValue(xpath)))) continue;
                String draft = "";
                if (vc.fullxpath.indexOf("[@draft=\"unconfirmed\"]") >= 0) {
                    draft = " [draft]";
                }
                String count = (vc.count == size ? "" : vc.count + "/") + size;
                this.warnln(this.getLocaleAndName(parent) + draft + "\tall children (" + count + ") have same value for:\t" + xpath + ";\t" + vc.value);
            }
        }
    }

    public void TestThatExemplarsContainAll() {
        UnicodeSet allExemplars = new UnicodeSet();
        if (this.disableUntilLater("TestThatExemplarsContainAll")) {
            return;
        }
        TreeSet<String> counts = new TreeSet<String>();
        int totalCount = 0;
        UnicodeSet localeMissing = new UnicodeSet();
        Iterator it = this.locales.iterator();
        while (it.hasNext()) {
            String locale = (String)it.next();
            if (locale.equals("root")) continue;
            CLDRFile resolved = this.cldrFactory.make(locale, false);
            UnicodeSet exemplars = this.getFixedExemplarSet(locale, resolved);
            CLDRFile plain = this.cldrFactory.make(locale, false);
            int count = 0;
            localeMissing.clear();
            Iterator it2 = plain.iterator();
            block1: while (it2.hasNext()) {
                String fullxpath;
                String xpath = (String)it2.next();
                for (int i = 0; i < EXEMPLAR_SKIPS.length; ++i) {
                    if (xpath.indexOf(EXEMPLAR_SKIPS[i]) > 0) continue block1;
                }
                if (SKIP_DRAFT && (fullxpath = plain.getFullXPath(xpath)).indexOf("[@draft=\"unconfirmed\"") > 0 || xpath.startsWith("//ldml/posix/messages")) continue;
                String value = plain.getStringValue(xpath);
                allExemplars.addAll(value);
                if (exemplars.containsAll(value)) continue;
                ++count;
                UnicodeSet missing = new UnicodeSet().addAll(value).removeAll(exemplars);
                localeMissing.addAll(missing);
                this.logln(this.getLocaleAndName(locale) + "\t" + xpath + "\t<" + value + "> contains " + missing + ", not in exemplars");
                this.surveyInfo.add(locale + "\t" + xpath + "\t'" + value + "' contains characters " + missing.toPattern(false) + ", which are not in exemplars");
            }
            DecimalFormat nf = new DecimalFormat("000");
            if (count != 0) {
                totalCount += count;
                counts.add(nf.format((long)count) + "\t" + this.getLocaleAndName(locale) + "\t" + localeMissing);
            }
            if (localeMissing.size() == 0) continue;
            this.errln(this.getLocaleAndName(locale) + "\t uses " + localeMissing + ", not in exemplars");
        }
        it = counts.iterator();
        while (it.hasNext()) {
            this.logln(it.next().toString());
        }
        this.logln("Total Count: " + totalCount);
        System.out.println("All exemplars: " + allExemplars.toPattern(true));
    }

    private boolean disableUntilLater(String string) {
        if (new Date().getTime() >= disableDate) {
            return false;
        }
        this.warnln("Disabling " + string + " until " + new Date(disableDate));
        return true;
    }

    private UnicodeSet getFixedExemplarSet(String locale, CLDRFile cldrfile) {
        UnicodeSet exemplars = this.getExemplarSet(cldrfile, "");
        if (exemplars.size() == 0) {
            this.errln(this.getLocaleAndName(locale) + " has empty exemplar set");
        }
        exemplars.addAll(this.getExemplarSet(cldrfile, "standard"));
        UnicodeSet auxiliary = this.getExemplarSet(cldrfile, "auxiliary");
        if (exemplars.containsSome(auxiliary)) {
            this.errln(this.getLocaleAndName(locale) + "Auxiliary & main exemplars should be disjoint, but overlap with " + new UnicodeSet(exemplars).retainAll(auxiliary) + ": change auxiliary to " + auxiliary.removeAll(exemplars));
        }
        exemplars.addAll(auxiliary);
        exemplars.addAll(this.commonAndInherited);
        return exemplars;
    }

    public UnicodeSet getExemplarSet(CLDRFile cldrfile, String type) {
        String v;
        if (type.length() != 0) {
            type = "[@type=\"" + type + "\"]";
        }
        if ((v = cldrfile.getStringValue("//ldml/characters/exemplarCharacters" + type)) == null) {
            return new UnicodeSet();
        }
        String pattern = v;
        if (pattern.indexOf("[:") >= 0 || pattern.indexOf("\\p{") > 0) {
            this.errln(this.getLocaleName(cldrfile.getLocaleID()) + " exemplar pattern contains property: " + pattern);
        }
        try {
            UnicodeSet result = new UnicodeSet(v, 2);
            result.remove(32);
            return result;
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            this.errln(this.getLocaleAndName(cldrfile.getLocaleID()) + " has illegal exemplar set: <" + v + ">");
            return new UnicodeSet();
        }
    }

    public String getLocaleAndName(String locale) {
        return locale + " (" + this.getLocaleName(locale) + ")";
    }

    public String getIDAndLocalization(String id) {
        return id + " " + this.getLocalization(id);
    }

    public String getLocalization(String id) {
        if (this.english == null) {
            this.english = this.cldrFactory.make("en", true);
        }
        if (id.length() == 0) {
            return "?";
        }
        char ch = id.charAt(0);
        if ('a' <= ch && ch <= 'z') {
            return this.getName(this.english, "languages/language", id);
        }
        if (id.length() == 4 && 'A' <= ch && ch <= 'Z') {
            return this.getName(this.english, "scripts/script", id);
        }
        return this.getName(this.english, "territories/territory", id);
    }

    private String getIDAndLocalization(Set missing) {
        StringBuffer buffer = new StringBuffer();
        Iterator it3 = missing.iterator();
        while (it3.hasNext()) {
            if (buffer.length() != 0) {
                buffer.append("; ");
            }
            buffer.append(this.getIDAndLocalization((String)it3.next()));
        }
        String s = buffer.toString();
        return s;
    }

    public String getLocaleName(String locale) {
        String name = (String)this.localeNameCache.get(locale);
        if (name != null) {
            return name;
        }
        if (this.english == null) {
            this.english = this.cldrFactory.make("en", true);
        }
        String result = this.english.getName(locale, false);
        this.localeNameCache.put(locale, result);
        return result;
    }

    private String getName(CLDRFile english, String kind, String type) {
        String v = english.getStringValue("//ldml/localeDisplayNames/" + kind + "[@type=\"" + type + "\"]");
        if (v == null) {
            return "<" + type + ">";
        }
        return v;
    }

    public void TestForIllegalAttributeValues() {
        TreeMap result = new TreeMap();
        TreeMap totalResult = new TreeMap();
        Iterator it = this.locales.iterator();
        while (it.hasNext()) {
            String locale = (String)it.next();
            this.logln("Testing: " + locale);
            CLDRFile item = this.cldrFactory.make(locale, false);
            result.clear();
            Set xpathFailures = null;
            CLDRTest.checkAttributeValidity(item, result, xpathFailures);
            String localeName = this.getLocaleAndName(locale);
            Iterator it3 = result.keySet().iterator();
            while (it3.hasNext()) {
                String code = (String)it3.next();
                Set avalues = (Set)result.get(code);
                this.errln(this.getLocaleAndName(locale) + "\tillegal attribute value for " + code + ", value:\t" + this.show(avalues));
                TreeSet totalvalues = (TreeSet)totalResult.get(code);
                if (totalvalues == null) {
                    totalvalues = new TreeSet();
                    totalResult.put(code, totalvalues);
                }
                totalvalues.addAll(avalues);
            }
        }
        Iterator it3 = totalResult.keySet().iterator();
        while (it3.hasNext()) {
            String code = (String)it3.next();
            Set avalues = (Set)totalResult.get(code);
            this.errln("All illegal attribute values for " + code + ", value:\t" + this.show(avalues));
        }
    }

    public void TestDisplayNameCollisions() {
        if (this.disableUntilLater("TestDisplayNameCollisions")) {
            return;
        }
        HashMap[] maps = new HashMap[13];
        for (int i = 0; i < maps.length; ++i) {
            maps[i] = new HashMap();
        }
        TreeSet<String> collisions = new TreeSet<String>();
        Iterator it = this.locales.iterator();
        while (it.hasNext()) {
            String locale = (String)it.next();
            CLDRFile item = this.cldrFactory.make(locale, true);
            for (int i = 0; i < maps.length; ++i) {
                maps[i].clear();
            }
            collisions.clear();
            Iterator it2 = item.iterator();
            while (it2.hasNext()) {
                String xpath = (String)it2.next();
                int nameType = CLDRFile.getNameType(xpath);
                if (nameType < 0) continue;
                String value = item.getStringValue(xpath);
                String xpath2 = (String)maps[nameType].get(value);
                if (xpath2 == null) {
                    maps[nameType].put(value, xpath);
                    continue;
                }
                collisions.add(CLDRFile.getNameTypeName(nameType) + "\t" + value + "\t" + xpath + "\t" + xpath2);
                this.surveyInfo.add(locale + "\t" + xpath + "\t'" + value + "' is a duplicate of what is in " + xpath2);
            }
            String name = this.getLocaleAndName(locale) + "\t";
            Iterator it22 = collisions.iterator();
            while (it22.hasNext()) {
                this.errln(name + (String)it22.next());
            }
        }
    }

    public static void checkAttributeValidity(CLDRFile item, Map badCodes, Set xpathFailures) {
        XPathParts parts = new XPathParts(null, null);
        Iterator it2 = item.iterator();
        while (it2.hasNext()) {
            String xpath = (String)it2.next();
            parts.set(item.getFullXPath(xpath));
            for (int i = 0; i < parts.size(); ++i) {
                if (parts.getAttributeCount(i) == 0) continue;
                String element = parts.getElement(i);
                Map attributes = parts.getAttributes(i);
                Iterator it3 = attributes.keySet().iterator();
                while (it3.hasNext()) {
                    String attribute = (String)it3.next();
                    String avalue = (String)attributes.get(attribute);
                    CLDRTest.checkValidity(xpath, element, attribute, avalue, badCodes, xpathFailures);
                }
            }
        }
    }

    private String show(Collection avalues) {
        StringBuffer result = new StringBuffer("{");
        boolean first = true;
        Iterator it3 = avalues.iterator();
        while (it3.hasNext()) {
            if (first) {
                first = false;
            } else {
                result.append(", ");
            }
            result.append(it3.next().toString());
        }
        result.append("}");
        return result.toString();
    }

    private static void checkValidity(String xpath, String element, String attribute, String avalue, Map results, Set xpathsFailing) {
        StandardCodes codes = StandardCodes.make();
        if (attribute.equals("type")) {
            boolean checkReplacements;
            boolean bl = checkReplacements = xpath.indexOf("/identity") < 0;
            if (element.equals("currency")) {
                CLDRTest.checkCodes(xpath, "currency", avalue, codes, results, xpathsFailing, checkReplacements);
            } else if (element.equals("script")) {
                CLDRTest.checkCodes(xpath, "script", avalue, codes, results, xpathsFailing, checkReplacements);
            } else if (element.equals("territory")) {
                CLDRTest.checkCodes(xpath, "territory", avalue, codes, results, xpathsFailing, checkReplacements);
            } else if (element.equals("language")) {
                CLDRTest.checkCodes(xpath, "language", avalue, codes, results, xpathsFailing, checkReplacements);
            } else if (element.equals("zone")) {
                CLDRTest.checkCodes(xpath, "tzid", avalue, codes, results, xpathsFailing, checkReplacements);
            }
        }
    }

    private static void checkCodes(String xpath, String code, String avalue, StandardCodes codes, Map results, Set xpathFailures, boolean checkReplacements) {
        if (!(codes.getData(code, avalue) == null || checkReplacements && codes.getReplacement(code, avalue) != null)) {
            return;
        }
        if (xpathFailures != null) {
            xpathFailures.add(xpath);
        }
        if (results == null) {
            return;
        }
        TreeSet<String> s = (TreeSet<String>)results.get(code);
        if (s == null) {
            s = new TreeSet<String>();
            results.put(code, s);
        }
        s.add(avalue);
    }

    public void TestCompleteLocales() {
        if (this.english == null) {
            this.english = this.cldrFactory.make("en", true);
        }
        this.checkTranslatedCodes(this.english);
    }

    private void checkTranslatedCodes(CLDRFile cldrfile) {
        StandardCodes codes = StandardCodes.make();
        this.checkTranslatedCode(cldrfile, codes, "currency", "//ldml/numbers/currencies/currency", "/displayName");
        this.checkTranslatedCode(cldrfile, codes, "language", "//ldml/localeDisplayNames/languages/language", "");
        this.checkTranslatedCode(cldrfile, codes, "script", "//ldml/localeDisplayNames/scripts/script", "");
        this.checkTranslatedCode(cldrfile, codes, "territory", "//ldml/localeDisplayNames/territories/territory", "");
        this.checkTranslatedCode(cldrfile, codes, "variant", "//ldml/localeDisplayNames/variants/variant", "");
    }

    private void checkTranslatedCode(CLDRFile cldrfile, StandardCodes codes, String type, String prefix, String postfix) {
        Set codeItems = codes.getGoodAvailableCodes(type);
        int count = 0;
        Set exceptions = (Set)this.completionExceptions.get(type);
        Iterator it = codeItems.iterator();
        while (it.hasNext()) {
            String code = (String)it.next();
            String rfcname = codes.getData(type, code);
            ++count;
            if (rfcname.equals("PRIVATE USE")) continue;
            String fullFragment = prefix + "[@type=\"" + code + "\"]" + postfix;
            String v = cldrfile.getStringValue(fullFragment);
            if (v == null) {
                this.errln("Missing translation for:\t<" + type + " type=\"" + code + "\">" + rfcname + "</" + type + ">");
                continue;
            }
            String translation = v;
            if (!translation.equals(code) || exceptions != null && exceptions.contains(code)) continue;
            this.errln("Translation = code for:\t<" + type + " type=\"" + code + "\">" + rfcname + "</" + type + ">");
        }
        this.logln("Total " + type + ":\t" + count);
    }

    void getSupplementalData(Map language_scripts, Map language_territories, Map group_territory, Map territory_currencies, Map aliases) {
        boolean SHOW = false;
        CLDRFile.Factory cldrFactory = CLDRFile.Factory.make("../../common/main/", ".*");
        CLDRFile supp = cldrFactory.make("supplementalData", false);
        XPathParts parts = new XPathParts((Comparator)new UTF16.StringComparator(), null);
        Iterator it = supp.iterator();
        while (it.hasNext()) {
            String path = (String)it.next();
            try {
                Map m;
                parts.set(supp.getFullXPath(path));
                String type = "";
                if (aliases != null && parts.findElement("alias") >= 0) {
                    type = "languageAlias";
                    m = parts.findAttributes("languageAlias");
                    if (m == null) {
                        type = "territoryAlias";
                        m = parts.findAttributes("territoryAlias");
                    }
                    if (m != null) {
                        TreeMap top = (TreeMap)aliases.get(type);
                        if (top == null) {
                            top = new TreeMap();
                            aliases.put(type, top);
                        }
                        top.put(m.get("type"), m.get("replacement"));
                    }
                }
                if (territory_currencies != null && (m = parts.findAttributes("region")) != null) {
                    String region = (String)m.get("iso3166");
                    LinkedHashSet<String> s = (LinkedHashSet<String>)territory_currencies.get(region);
                    if (s == null) {
                        s = new LinkedHashSet<String>();
                        territory_currencies.put(region, s);
                    }
                    if ((m = parts.findAttributes("currency")) == null) {
                        this.warnln("missing currency for region: " + path);
                        continue;
                    }
                    String currency = (String)m.get("iso4217");
                    s.add(currency);
                    m = parts.findAttributes("alternate");
                    String alternate = m == null ? null : (String)m.get("iso4217");
                    if (alternate == null) continue;
                    s.add(alternate);
                    continue;
                }
                m = parts.findAttributes("group");
                if (m != null) {
                    if (group_territory == null) continue;
                    type = (String)m.get("type");
                    String contains = (String)m.get("contains");
                    group_territory.put(type, new TreeSet(Utility.splitList(contains, ' ', true)));
                    continue;
                }
                m = parts.findAttributes("language");
                if (m == null) continue;
                String language = (String)m.get("type");
                String scripts = (String)m.get("scripts");
                if (scripts == null) {
                    language_scripts.put(language, new TreeSet());
                } else {
                    language_scripts.put(language, new TreeSet(Utility.splitList(scripts, ' ', true)));
                    if (SHOW) {
                        System.out.println(this.getIDAndLocalization(language) + "\t\t" + this.getIDAndLocalization((Set)language_scripts.get(language)));
                    }
                }
                String territories = (String)m.get("territories");
                if (territories == null) {
                    language_territories.put(language, new TreeSet());
                    continue;
                }
                language_territories.put(language, new TreeSet(Utility.splitList(territories, ' ', true)));
                if (!SHOW) continue;
                System.out.println(this.getIDAndLocalization(language) + "\t\t" + this.getIDAndLocalization((Set)language_territories.get(language)));
            }
            catch (RuntimeException e) {
                throw (IllegalArgumentException)new IllegalArgumentException("Failure with: " + path).initCause(e);
            }
        }
    }

    public void TestMinimalLocalization() throws IOException {
        if (this.disableUntilLater("TestMinimalLocalization")) {
            return;
        }
        boolean testDraft = false;
        HashMap language_scripts = new HashMap();
        HashMap language_territories = new HashMap();
        this.getSupplementalData(language_scripts, language_territories, null, null, null);
        LanguageTagParser localIDParser = new LanguageTagParser();
        int[] failureCount = new int[1];
        int[] warningCount = new int[1];
        Iterator it = this.languageLocales.iterator();
        while (it.hasNext()) {
            String locale = (String)it.next();
            if (locale.equals("root")) continue;
            CLDRFile item = this.cldrFactory.make(locale, true);
            if (!testDraft && item.isDraft()) {
                this.logln(this.getLocaleAndName(locale) + "\tskipping draft");
                continue;
            }
            UnicodeSet exemplars = this.getFixedExemplarSet(locale, item);
            CLDRFile missing = CLDRFile.make(locale);
            failureCount[0] = 0;
            warningCount[0] = 0;
            localIDParser.set(locale);
            String language = localIDParser.getLanguage();
            this.logln("Testing: " + locale);
            TreeSet<String> languages = new TreeSet<String>(Utility.MINIMUM_LANGUAGES);
            languages.add(language);
            this.checkForItems(item, languages, 0, missing, failureCount, null);
            TreeSet<String> scripts = new TreeSet<String>();
            scripts.add("Latn");
            Set others = (Set)language_scripts.get(language);
            if (others != null) {
                scripts.addAll(others);
            }
            this.checkForItems(item, scripts, 1, missing, failureCount, null);
            TreeSet countries = new TreeSet(Utility.MINIMUM_TERRITORIES);
            others = (Set)language_territories.get(language);
            if (others != null) {
                countries.addAll(others);
            }
            this.checkForItems(item, countries, 2, missing, failureCount, null);
            TreeSet currencies = new TreeSet();
            StandardCodes sc = StandardCodes.make();
            Iterator it2 = countries.iterator();
            while (it2.hasNext()) {
                String country = (String)it2.next();
                Set countryCurrencies = sc.getMainCurrencies(country);
                if (countryCurrencies == null) {
                    this.errln("Internal Error: no currencies for " + country + ", locale: " + locale);
                    continue;
                }
                currencies.addAll(countryCurrencies);
            }
            this.checkForItems(item, currencies, 4, missing, failureCount, null);
            this.checkForItems(item, currencies, 5, missing, failureCount, exemplars);
            TreeSet<String> months = new TreeSet<String>();
            for (int i = 1; i <= 12; ++i) {
                months.add(i + "");
            }
            TreeSet<String> days = new TreeSet<String>(Arrays.asList("sun", "mon", "tue", "wed", "thu", "fri", "sat"));
            for (int i = -6; i < 0; ++i) {
                this.checkForItems(item, i < -3 ? months : days, i, missing, failureCount, null);
            }
            String filename = "missing_" + locale + ".xml";
            if (failureCount[0] > 0 || warningCount[0] > 0) {
                PrintWriter out = BagFormatter.openUTF8Writer((String)"../../dropbox/gen/missing/", (String)filename);
                missing.write(out);
                out.close();
                String message = "missing localizations, creating file" + new File("../../dropbox/gen/missing/" + filename).getCanonicalPath();
                if (failureCount[0] > 0) {
                    this.warnln(this.getLocaleAndName(locale) + "\t" + message);
                    continue;
                }
                this.logln(this.getLocaleAndName(locale) + "\tpossibly " + message);
                continue;
            }
            new File("../../dropbox/gen/missing/" + filename).delete();
        }
    }

    private String getDateKey(String monthOrDay, String width, String code) {
        return "//ldml/dates/calendars/calendar[@type=\"gregorian\"]/" + monthOrDay + "s/" + monthOrDay + "Context[@type=\"format\"]/" + monthOrDay + "Width[@type=\"" + width + "\"]/" + monthOrDay + "[@type=\"" + code + "\"]";
    }

    private String getDateKey(int type, String code) {
        return this.getDateKey(MONTHORDAYS[type / 3], WIDTHS[type % 3], code);
    }

    private void checkForItems(CLDRFile item, Set codes, int type, CLDRFile missing, int[] failureCount, UnicodeSet exemplarTest) {
        Iterator it2 = codes.iterator();
        while (it2.hasNext()) {
            String code = (String)it2.next();
            String key = type >= 0 ? CLDRFile.getKey(type, code) : this.getDateKey(-type - 1, code);
            String v = item.getStringValue(key);
            String rootValue = this.resolvedRoot.getStringValue(key);
            if (v == null || v.equals(rootValue) && (exemplarTest == null || !exemplarTest.containsAll(rootValue))) {
                String englishValue = this.resolvedEnglish.getStringValue(key);
                String transValue = englishValue != null ? englishValue : code;
                missing.add(key, "TODO " + transValue);
                failureCount[0] = failureCount[0] + 1;
                continue;
            }
            this.logln("\t" + code + "\t" + v);
        }
    }

    public void TestSupplementalData() {
        TreeSet extras;
        TreeSet<Object> extras2;
        TreeMap language_scripts = new TreeMap();
        TreeMap language_territories = new TreeMap();
        TreeMap groups = new TreeMap();
        TreeMap territory_currencies = new TreeMap();
        TreeMap aliases = new TreeMap();
        this.getSupplementalData(language_scripts, language_territories, groups, territory_currencies, aliases);
        TreeSet sTerritories = new TreeSet();
        Iterator it = language_territories.values().iterator();
        while (it.hasNext()) {
            sTerritories.addAll((Collection)it.next());
        }
        StandardCodes sc = StandardCodes.make();
        Set fullTerritories = sc.getAvailableCodes("territory");
        Set fullLanguages = sc.getAvailableCodes("language");
        TreeSet allLanguages = new TreeSet(language_scripts.keySet());
        allLanguages.addAll(language_territories.keySet());
        Iterator it2 = allLanguages.iterator();
        while (it2.hasNext()) {
            Object language = it2.next();
            Set scripts = (Set)language_scripts.get(language);
            Set territories = (Set)language_territories.get(language);
            this.logln(this.EnglishName.transform(language) + " scripts: " + this.EnglishName.transform(scripts) + " territories: " + this.EnglishName.transform(territories));
        }
        TreeMap<String, String> changedLanguage = new TreeMap<String, String>();
        Iterator it3 = fullLanguages.iterator();
        while (it3.hasNext()) {
            String code = (String)it3.next();
            List data = sc.getFullData("language", code);
            if (data.size() < 3) {
                System.out.println("data problem: " + data);
                continue;
            }
            String replacement = (String)data.get(2);
            if (replacement.equals("") || replacement.equals("--")) continue;
            changedLanguage.put(code, replacement);
        }
        TreeSet<String> standardTerritories = new TreeSet<String>();
        TreeMap changedTerritory = new TreeMap();
        Iterator it4 = fullTerritories.iterator();
        while (it4.hasNext()) {
            List data;
            String code = (String)it4.next();
            if (code.equals("200") || (data = sc.getFullData("territory", code)).get(0).equals("PRIVATE USE")) continue;
            if (!data.get(2).equals("")) {
                if (data.get(2).equals("--")) continue;
                changedTerritory.put(code, data.get(2));
                continue;
            }
            standardTerritories.add(code);
        }
        standardTerritories.removeAll(groups.keySet());
        if (!standardTerritories.containsAll(sTerritories)) {
            extras2 = new TreeSet(sTerritories);
            extras2.removeAll(standardTerritories);
            this.errln("Supplemental Language Territories contain illegal values: " + this.EnglishName.transform(extras2));
        }
        if (!sTerritories.containsAll(standardTerritories)) {
            extras2 = new TreeSet(standardTerritories);
            extras2.removeAll(sTerritories);
            this.warnln("Missing Language Territories: " + this.EnglishName.transform(extras2));
        }
        this.logln("Check that no illegal territories are used");
        if (!standardTerritories.containsAll(territory_currencies.keySet())) {
            extras2 = new TreeSet(territory_currencies.keySet());
            extras2.removeAll(fullTerritories);
            if (extras2.size() != 0) {
                this.errln("Currency info -- Illegal Territories: " + this.EnglishName.transform(extras2));
            }
            extras2 = new TreeSet(territory_currencies.keySet());
            extras2.retainAll(fullTerritories);
            extras2.removeAll(standardTerritories);
            if (extras2.size() != 0) {
                this.warnln("Currency info -- Archaic Territories: " + this.EnglishName.transform(extras2));
            }
        }
        this.logln("Check that no territories are missing");
        if (!territory_currencies.keySet().containsAll(standardTerritories)) {
            extras2 = new TreeSet(standardTerritories);
            extras2.removeAll(territory_currencies.keySet());
            this.errln("Currency info -- Missing Territories: " + this.EnglishName.transform(extras2));
        }
        TreeSet currencies = new TreeSet();
        Iterator it5 = territory_currencies.values().iterator();
        while (it5.hasNext()) {
            currencies.addAll((Collection)it5.next());
        }
        this.logln("Check that no illegal currencies are used");
        TreeSet legalCurrencies = new TreeSet(sc.getAvailableCodes("currency"));
        Iterator<Object> it6 = legalCurrencies.iterator();
        while (it6.hasNext()) {
            String code = (String)it6.next();
            List data = sc.getFullData("currency", code);
            if (!"X".equals(data.get(3))) continue;
            it6.remove();
        }
        if (!legalCurrencies.containsAll(currencies)) {
            extras = new TreeSet(currencies);
            extras.removeAll(legalCurrencies);
            this.errln("Currency info -- Illegal Currencies: " + this.EnglishCurrencyName.transform(extras));
        }
        this.logln("Check that there are no missing currencies");
        if (!currencies.containsAll(legalCurrencies)) {
            extras = new TreeSet(legalCurrencies);
            extras.removeAll(currencies);
            TreeMap<String, TreeSet<String>> failures = new TreeMap<String, TreeSet<String>>();
            Iterator<Object> it7 = extras.iterator();
            while (it7.hasNext()) {
                String code = (String)it7.next();
                List data = sc.getFullData("currency", code);
                if (data.get(1).equals("ZZ")) continue;
                String type = data.get(3) + "/" + data.get(1);
                TreeSet<String> s = (TreeSet<String>)failures.get(type);
                if (s == null) {
                    s = new TreeSet<String>();
                    failures.put(type, s);
                }
                s.add(code);
            }
            it7 = failures.keySet().iterator();
            while (it7.hasNext()) {
                String type = (String)it7.next();
                Set s = (Set)failures.get(type);
                this.warnln("Currency info -- Missing Currencies: " + type + "\t \u2192 " + this.EnglishCurrencyName.transform(s));
            }
        }
        this.logln("Missing English currency names");
        it6 = legalCurrencies.iterator();
        while (it6.hasNext()) {
            String currency = (String)it6.next();
            String name = this.english.getName("currency", currency, false);
            if (name != null) continue;
            String standardName = (String)sc.getFullData("currency", currency).get(0);
            this.logln("\t\t\t<currency type=\"" + currency + "\">");
            this.logln("\t\t\t\t<displayName>" + standardName + "</displayName>");
            this.logln("\t\t\t</currency>");
        }
        this.logln("Check Aliases");
        it6 = aliases.keySet().iterator();
        while (it6.hasNext()) {
            String key = (String)it6.next();
            Map submap = (Map)aliases.get(key);
            if (key.equals("territoryAlias")) {
                this.checkEqual(key, submap, changedTerritory);
                continue;
            }
            if (!key.equals("languageAlias")) continue;
            Iterator it22 = submap.keySet().iterator();
            while (it22.hasNext()) {
                Object k = it22.next();
                String value = (String)submap.get(k);
                if (value.indexOf("_") < 0) continue;
                it22.remove();
            }
            this.checkEqual(key, submap, changedLanguage);
        }
    }

    private void checkEqual(String title, Map map1, Map map2) {
        Set foo = new TreeSet(map1.keySet());
        foo.removeAll(map2.keySet());
        if (!foo.isEmpty()) {
            this.errln("Extraneous Aliases: " + title + "\t" + foo);
        }
        foo = new TreeSet(map2.keySet());
        foo.removeAll(map1.keySet());
        if (!foo.isEmpty()) {
            this.errln("Missing Aliases: " + title + "\t" + foo);
        }
        foo = map2.keySet();
        foo.retainAll(map1.keySet());
        Iterator it = foo.iterator();
        while (it.hasNext()) {
            String result2;
            Object key = it.next();
            String result1 = (String)map1.get(key);
            if (result1.equals(result2 = (String)map2.get(key))) continue;
            this.errln("Missing Aliases: " + title + "\t" + key + "\t" + result1 + " != " + result2);
        }
    }

    public void TestZones() {
        StandardCodes sc = StandardCodes.make();
        TreeMap<String, String> defaultNames = new TreeMap<String, String>();
        Map old_new = sc.getZoneLinkold_new();
        Set core = sc.getZoneData().keySet();
        this.logln("Checking for collisions with last field");
        Iterator it = core.iterator();
        while (it.hasNext()) {
            String currentItem = (String)it.next();
            String defaultName = TimezoneFormatter.getFallbackName(currentItem);
            String fullName = (String)defaultNames.get(defaultName);
            if (fullName == null) {
                defaultNames.put(defaultName, currentItem);
                continue;
            }
            this.errln("Collision between: " + currentItem + " AND " + fullName);
        }
        this.logln("Checking that all links are TO canonical zones");
        TreeSet<Object> s = new TreeSet(old_new.values());
        s.removeAll(core);
        if (s.size() != 0) {
            this.errln("Links go TO zones that are not canonical! " + s);
        }
        this.logln("Checking that no links are FROM canonical zones");
        s = new TreeSet(core);
        s.retainAll(old_new.keySet());
        if (s.size() != 0) {
            this.errln("Links go FROM zones that are canonical! " + s);
        }
        this.logln("Checking that the zones with rule data are all canonical");
        Set zonesWithRules = sc.getZone_rules().keySet();
        s.clear();
        s.addAll(zonesWithRules);
        s.removeAll(core);
        if (s.size() != 0) {
            this.logln("Zones with rules that are not canonical: " + s);
        }
        this.logln("Checking that the rule data are all canonical");
        s.clear();
        s.addAll(core);
        s.removeAll(zonesWithRules);
        s.removeAll(old_new.keySet());
        if (s.size() != 0) {
            this.logln("Canonical zones that don't have rules or links: " + s);
        }
        Iterator it2 = old_new.keySet().iterator();
        while (it2.hasNext()) {
            String oldItem = (String)it2.next();
            this.logln("old: " + oldItem + "\tnew: " + old_new.get(oldItem));
        }
        TreeMap new_old = new TreeMap();
        Iterator it3 = core.iterator();
        while (it3.hasNext()) {
            new_old.put(it3.next(), new TreeSet());
        }
        it3 = old_new.keySet().iterator();
        while (it3.hasNext()) {
            String oldItem = (String)it3.next();
            String newItem = (String)old_new.get(oldItem);
            Set oldItems = (Set)new_old.get(newItem);
            if (oldItems == null) {
                this.logln("!!!!Skipping " + oldItem + " \u2192 " + newItem);
                continue;
            }
            oldItems.add(oldItem);
        }
        it3 = new_old.keySet().iterator();
        while (it3.hasNext()) {
            String newOne = (String)it3.next();
            Set oldItems = (Set)new_old.get(newOne);
            this.logln(newOne + "\t" + oldItems);
        }
    }

    public void TestNarrowForms() {
        if (this.disableUntilLater("TestMinimalLocalization")) {
            return;
        }
        Iterator it = this.locales.iterator();
        while (it.hasNext()) {
            String locale = (String)it.next();
            this.logln("Testing: " + this.getLocaleAndName(locale));
            BreakIterator bi = BreakIterator.getCharacterInstance((ULocale)new ULocale(locale));
            CLDRFile item = this.cldrFactory.make(locale, false);
            Iterator it2 = item.iterator();
            while (it2.hasNext()) {
                String value;
                int end;
                String xpath = (String)it2.next();
                if (xpath.indexOf("[@type=\"narrow\"]") < 0 || (end = this.getXGraphemeClusterBoundary(bi, value = item.getStringValue(xpath), 0)) == value.length()) continue;
                this.errln(this.getLocaleAndName(locale) + "\tillegal narrow value " + value + "\t path: " + xpath);
                this.surveyInfo.add(locale + "\t" + xpath + "\t'" + value + "' is too wide for a \"narrow\" value.");
            }
        }
    }

    private int getXGraphemeClusterBoundary(BreakIterator bi, String value, int start) {
        if (value.length() <= 1) {
            return 1;
        }
        bi.setText(value);
        if (start != 0) {
            bi.preceding(start + 1);
        }
        int current = bi.next();
        boolean cp = false;
        if (DIGIT.contains(UTF16.charAt((String)value, (int)(current - 1)))) {
            current = Utility.scan(DIGIT, value, current);
        }
        return Utility.scan(XGRAPHEME, value, current);
    }

    static {
        DIGIT_COUNT = new int[][]{{1, 2, 2}, {1, 0, 3}, {1, 0, 0}, {0, 0, 0}};
        POSIX_DIGIT_COUNT = new int[][]{{1, 2, 2}, {1, 0, 6}, {1, 0, 0}, {1, 6, 6}};
        WIDTHS = new String[]{"narrow", "wide", "abbreviated"};
        MONTHORDAYS = new String[]{"day", "month"};
        TYPE_NAME = new String[]{"currency", "decimal", "percent", "scientific"};
        EXEMPLAR_SKIPS = new String[]{"/hourFormat", "/exemplarCharacters", "/pattern", "/localizedPatternChars"};
        disableDate = new Date(105, 5, 3).getTime();
        XGRAPHEME = new UnicodeSet("[[:mark:][:grapheme_extend:]]");
        DIGIT = new UnicodeSet("[:decimal_number:]");
    }

    private static class ValueCount {
        int count = 1;
        String value;
        String fullxpath;

        private ValueCount() {
        }
    }
}

