/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.test;

import com.ibm.icu.text.UTF16;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.XPathParts;

public class TestMisc {
    static int[] extraCJK = new int[]{12294, 12330, 12331, 12332, 12333, 12334, 12335, 12337, 12338, 12339, 12340, 12341, 12348, 12441, 12442, 12443, 12444, 12448, 12540, 65392, 65438, 65439};
    private static final Map language_territory_hack_map = new HashMap();
    private static final String[][] language_territory_hack = new String[][]{{"af", "ZA"}, {"am", "ET"}, {"ar", "SA"}, {"as", "IN"}, {"ay", "PE"}, {"az", "AZ"}, {"bal", "PK"}, {"be", "BY"}, {"bg", "BG"}, {"bn", "IN"}, {"bs", "BA"}, {"ca", "ES"}, {"ch", "MP"}, {"cpe", "SL"}, {"cs", "CZ"}, {"cy", "GB"}, {"da", "DK"}, {"de", "DE"}, {"dv", "MV"}, {"dz", "BT"}, {"el", "GR"}, {"en", "US"}, {"es", "ES"}, {"et", "EE"}, {"eu", "ES"}, {"fa", "IR"}, {"fi", "FI"}, {"fil", "PH"}, {"fj", "FJ"}, {"fo", "FO"}, {"fr", "FR"}, {"ga", "IE"}, {"gd", "GB"}, {"gl", "ES"}, {"gn", "PY"}, {"gu", "IN"}, {"gv", "GB"}, {"ha", "NG"}, {"he", "IL"}, {"hi", "IN"}, {"ho", "PG"}, {"hr", "HR"}, {"ht", "HT"}, {"hu", "HU"}, {"hy", "AM"}, {"id", "ID"}, {"is", "IS"}, {"it", "IT"}, {"ja", "JP"}, {"ka", "GE"}, {"kk", "KZ"}, {"kl", "GL"}, {"km", "KH"}, {"kn", "IN"}, {"ko", "KR"}, {"kok", "IN"}, {"ks", "IN"}, {"ku", "TR"}, {"ky", "KG"}, {"la", "VA"}, {"lb", "LU"}, {"ln", "CG"}, {"lo", "LA"}, {"lt", "LT"}, {"lv", "LV"}, {"mai", "IN"}, {"men", "GN"}, {"mg", "MG"}, {"mh", "MH"}, {"mk", "MK"}, {"ml", "IN"}, {"mn", "MN"}, {"mni", "IN"}, {"mo", "MD"}, {"mr", "IN"}, {"ms", "MY"}, {"mt", "MT"}, {"my", "MM"}, {"na", "NR"}, {"nb", "NO"}, {"nd", "ZA"}, {"ne", "NP"}, {"niu", "NU"}, {"nl", "NL"}, {"nn", "NO"}, {"no", "NO"}, {"nr", "ZA"}, {"nso", "ZA"}, {"ny", "MW"}, {"om", "KE"}, {"or", "IN"}, {"pa", "IN"}, {"pau", "PW"}, {"pl", "PL"}, {"ps", "PK"}, {"pt", "BR"}, {"qu", "PE"}, {"rn", "BI"}, {"ro", "RO"}, {"ru", "RU"}, {"rw", "RW"}, {"sd", "IN"}, {"sg", "CF"}, {"si", "LK"}, {"sk", "SK"}, {"sl", "SI"}, {"sm", "WS"}, {"so", "DJ"}, {"sq", "CS"}, {"sr", "CS"}, {"ss", "ZA"}, {"st", "ZA"}, {"sv", "SE"}, {"sw", "KE"}, {"ta", "IN"}, {"te", "IN"}, {"tem", "SL"}, {"tet", "TL"}, {"th", "TH"}, {"ti", "ET"}, {"tg", "TJ"}, {"tk", "TM"}, {"tkl", "TK"}, {"tvl", "TV"}, {"tl", "PH"}, {"tn", "ZA"}, {"to", "TO"}, {"tpi", "PG"}, {"tr", "TR"}, {"ts", "ZA"}, {"uk", "UA"}, {"ur", "IN"}, {"uz", "UZ"}, {"ve", "ZA"}, {"vi", "VN"}, {"wo", "SN"}, {"xh", "ZA"}, {"zh", "CN"}, {"zh_Hant", "TW"}, {"zu", "ZA"}, {"aa", "ET"}, {"byn", "ER"}, {"eo", "DE"}, {"gez", "ET"}, {"haw", "US"}, {"iu", "CA"}, {"kw", "GB"}, {"sa", "IN"}, {"sh", "HR"}, {"sid", "ET"}, {"syr", "SY"}, {"tig", "ER"}, {"tt", "RU"}, {"wal", "ET"}};

    public static void main(String[] args) {
        TestMisc.checkDistinguishing();
    }

    void checkCFK() {
    }

    private static void checkDistinguishing() {
        CLDRFile.Factory cldrFactory = CLDRFile.Factory.make("../../common/main/", ".*");
        Set cldrFiles = cldrFactory.getAvailableLanguages();
        TreeSet<String> distinguishing = new TreeSet<String>();
        TreeSet<String> nondistinguishing = new TreeSet<String>();
        XPathParts parts = new XPathParts();
        Iterator it = cldrFiles.iterator();
        while (it.hasNext()) {
            CLDRFile cldrFile = cldrFactory.make(it.next().toString(), false);
            if (cldrFile.isNonInheriting()) continue;
            Iterator it2 = cldrFile.iterator();
            while (it2.hasNext()) {
                String fullPath;
                String path = (String)it2.next();
                if (path.equals(fullPath = cldrFile.getFullXPath(path))) continue;
                parts.set(fullPath);
                for (int i = 0; i < parts.size(); ++i) {
                    Map m = parts.getAttributes(i);
                    if (m.size() == 0) continue;
                    String element = parts.getElement(i);
                    Iterator mit = m.keySet().iterator();
                    while (mit.hasNext()) {
                        String attribute = (String)mit.next();
                        if (CLDRFile.isDistinguishing(element, attribute)) {
                            distinguishing.add(attribute + "\tD\t" + element);
                            continue;
                        }
                        nondistinguishing.add(attribute + "\tN\t" + element);
                    }
                }
            }
        }
        System.out.println("Distinguishing");
        it = distinguishing.iterator();
        while (it.hasNext()) {
            System.out.println(it.next());
        }
        System.out.println();
        System.out.println("Non-Distinguishing");
        it = nondistinguishing.iterator();
        while (it.hasNext()) {
            System.out.println(it.next());
        }
    }

    private static void showEnglish() {
        CLDRFile.Factory cldrFactory = CLDRFile.Factory.make("../../common/main/", ".*");
        String requestedLocale = "en";
        CLDRFile cldrFile = cldrFactory.make(requestedLocale, true);
        CLDRFile.Status status = new CLDRFile.Status();
        Iterator it = cldrFile.iterator();
        while (it.hasNext()) {
            String requestedPath = (String)it.next();
            String localeWhereFound = cldrFile.getSourceLocaleID(requestedPath, status);
            if (localeWhereFound.equals(requestedLocale) && status.pathWhereFound.equals(requestedPath)) continue;
            System.out.println("requested path:\t" + requestedPath + "\tfound locale:\t" + localeWhereFound + "\tsame?\t" + localeWhereFound.equals(requestedLocale) + "\tfound path:\t" + status.pathWhereFound + "\tsame?\t" + status.pathWhereFound.equals(requestedPath));
        }
    }

    private static void checkPrivateUse() {
        CLDRFile.Factory cldrFactory = CLDRFile.Factory.make("../../common/main/", ".*");
        String requestedLocale = "en";
        CLDRFile cldrFile = cldrFactory.make(requestedLocale, true);
        CLDRFile.Status status = new CLDRFile.Status();
        StandardCodes sc = StandardCodes.make();
        XPathParts parts = new XPathParts();
        HashSet<String> careAbout = new HashSet<String>(Arrays.asList("language", "script", "territory", "variant"));
        HashMap<String, TreeSet<String>> foundItems = new HashMap<String, TreeSet<String>>();
        TreeSet<String> problems = new TreeSet<String>();
        Iterator it = cldrFile.iterator("", (Comparator)new UTF16.StringComparator(true, false, 0));
        while (it.hasNext()) {
            String type;
            String requestedPath = (String)it.next();
            parts.set(requestedPath);
            String element = parts.getElement(-1);
            if (!careAbout.contains(element) || (type = parts.getAttributeValue(-1, "type")) == null) continue;
            TreeSet<String> foundSet = (TreeSet<String>)foundItems.get(element);
            if (foundSet == null) {
                foundSet = new TreeSet<String>();
                foundItems.put(element, foundSet);
            }
            foundSet.add(type);
            List data = sc.getFullData(element, type);
            if (data == null) {
                problems.add("No RFC3066bis data for: " + element + "\t" + type + "\t" + cldrFile.getStringValue(requestedPath));
                continue;
            }
            if (!TestMisc.isPrivateOrDeprecated(data)) continue;
            problems.add("Private/Deprecated Data for: " + element + "\t" + type + "\t" + cldrFile.getStringValue(requestedPath) + "\t" + data);
        }
        it = problems.iterator();
        while (it.hasNext()) {
            System.out.println(it.next());
        }
        it = careAbout.iterator();
        while (it.hasNext()) {
            String element = (String)it.next();
            Set real = sc.getAvailableCodes(element);
            TreeSet notFound = new TreeSet(real);
            notFound.removeAll((Set)foundItems.get(element));
            Iterator it2 = notFound.iterator();
            while (it2.hasNext()) {
                String type = (String)it2.next();
                List data = sc.getFullData(element, type);
                if (TestMisc.isPrivateOrDeprecated(data)) continue;
                System.out.println("Missing Translation for: " + element + "\t" + type + "\t" + "\t" + data);
            }
        }
    }

    static boolean isPrivateOrDeprecated(List data) {
        if (data.toString().indexOf("PRIVATE") >= 0) {
            return true;
        }
        if ("PRIVATE USE".equals(data.get(0))) {
            return true;
        }
        if (data.size() < 3) {
            return false;
        }
        if (data.get(2) == null) {
            return false;
        }
        return data.get(2).toString().length() != 0;
    }

    static void testPopulous() {
        CLDRFile.Factory cldrFactory = CLDRFile.Factory.make("../../common/main/", ".*");
        CLDRFile supp = cldrFactory.make("supplementalData", false);
        CLDRFile temp = CLDRFile.make("supplemental");
        temp.setNonInheriting(true);
        XPathParts parts = new XPathParts(null, null);
        Iterator it = supp.iterator(null, CLDRFile.ldmlComparator);
        while (it.hasNext()) {
            String path = it.next().toString();
            String value = supp.getStringValue(path);
            String fullPath = supp.getFullXPath(path);
            parts.set(fullPath);
            String type = parts.getAttributeValue(-1, "type");
            String pop = (String)language_territory_hack_map.get(type);
            if (pop != null) {
                parts.putAttributeValue(-1, "mostPopulousTerritory", pop);
                fullPath = parts.toString();
            }
            temp.add(fullPath, value);
        }
        PrintWriter pw = new PrintWriter(System.out);
        temp.write(pw);
        pw.close();
    }

    static {
        for (int i = 0; i < language_territory_hack.length; ++i) {
            language_territory_hack_map.put(language_territory_hack[i][0], language_territory_hack[i][1]);
        }
    }
}

