/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.ibm.icu.dev.test.util.ArrayComparator;
import com.ibm.icu.dev.test.util.BagFormatter;
import com.ibm.icu.dev.test.util.ICUPropertyFactory;
import com.ibm.icu.dev.test.util.Tabber;
import com.ibm.icu.dev.test.util.UnicodeMap;
import com.ibm.icu.impl.CollectionUtilities;
import com.ibm.icu.text.Collator;
import com.ibm.icu.text.RuleBasedCollator;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.ICUServiceBuilder;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.TimezoneFormatter;
import org.unicode.cldr.util.Utility;
import org.unicode.cldr.util.XPathParts;
import org.unicode.cldr.util.ZoneInflections;

public class CountItems {
    static final String needsTranslationString = "America/Buenos_Aires  America/Manaus America/Belem  America/Campo_Grande America/Sao_Paulo  Australia/Perth Australia/Darwin Australia/Brisbane Australia/Adelaide Australia/Sydney Australia/Hobart  America/Vancouver America/Edmonton America/Regina America/Winnipeg America/Toronto America/Halifax America/St_Johns  Asia/Jakarta  America/Tijuana America/Hermosillo America/Chihuahua America/Mexico_City  Europe/Moscow Europe/Kaliningrad Europe/Moscow Asia/Yekaterinburg Asia/Novosibirsk Asia/Yakutsk Asia/Vladivostok Pacific/Honolulu America/Indiana/Indianapolis America/Anchorage  America/Los_Angeles America/Phoenix America/Denver America/Chicago America/Indianapolis America/New_York";
    static final Map country_map = CollectionUtilities.asMap((Object[][])new String[][]{{"AQ", "http://www.worldtimezone.com/time-antarctica24.php"}, {"AR", "http://www.worldtimezone.com/time-south-america24.php"}, {"AU", "http://www.worldtimezone.com/time-australia24.php"}, {"BR", "http://www.worldtimezone.com/time-south-america24.php"}, {"CA", "http://www.worldtimezone.com/time-canada24.php"}, {"CD", "http://www.worldtimezone.com/time-africa24.php"}, {"CL", "http://www.worldtimezone.com/time-south-america24.php"}, {"CN", "http://www.worldtimezone.com/time-cis24.php"}, {"EC", "http://www.worldtimezone.com/time-south-america24.php"}, {"ES", "http://www.worldtimezone.com/time-europe24.php"}, {"FM", "http://www.worldtimezone.com/time-oceania24.php"}, {"GL", "http://www.worldtimezone.com/index24.php"}, {"ID", "http://www.worldtimezone.com/time-asia24.php"}, {"KI", "http://www.worldtimezone.com/time-oceania24.php"}, {"KZ", "http://www.worldtimezone.com/time-cis24.php"}, {"MH", "http://www.worldtimezone.com/time-oceania24.php"}, {"MN", "http://www.worldtimezone.com/time-cis24.php"}, {"MX", "http://www.worldtimezone.com/index24.php"}, {"MY", "http://www.worldtimezone.com/time-asia24.php"}, {"NZ", "http://www.worldtimezone.com/time-oceania24.php"}, {"PF", "http://www.worldtimezone.com/time-oceania24.php"}, {"PT", "http://www.worldtimezone.com/time-europe24.php"}, {"RU", "http://www.worldtimezone.com/time-russia24.php"}, {"SJ", "http://www.worldtimezone.com/index24.php"}, {"UA", "http://www.worldtimezone.com/time-cis24.php"}, {"UM", "http://www.worldtimezone.com/time-oceania24.php"}, {"US", "http://www.worldtimezone.com/time-usa24.php"}, {"UZ", "http://www.worldtimezone.com/time-cis24.php"}});

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        double deltaTime = System.currentTimeMillis();
        try {
            CountItems.countItems();
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            deltaTime = (double)System.currentTimeMillis() - deltaTime;
            System.out.println("Elapsed: " + deltaTime / 1000.0 + " seconds");
            System.out.println("Done");
            throw throwable;
        }
        deltaTime = (double)System.currentTimeMillis() - deltaTime;
        System.out.println("Elapsed: " + deltaTime / 1000.0 + " seconds");
        System.out.println("Done");
    }

    private static void getZoneEquivalences() throws IOException, ParseException {
        TreeSet<String> needsTranslation = new TreeSet<String>(Arrays.asList(needsTranslationString.split("[,]?\\s+")));
        TreeSet<String> singleCountries = new TreeSet<String>(Arrays.asList("Africa/Bamako America/Godthab America/Santiago America/Guayaquil     Asia/Shanghai Asia/Tashkent Asia/Kuala_Lumpur Europe/Madrid Europe/Lisbon Europe/London Pacific/Auckland Pacific/Tahiti".split("\\s")));
        TreeSet<String> defaultItems = new TreeSet<String>(Arrays.asList("Antarctica/McMurdo America/Buenos_Aires Australia/Sydney America/Sao_Paulo America/Toronto Africa/Kinshasa America/Santiago Asia/Shanghai America/Guayaquil Europe/Madrid Europe/London America/Godthab Asia/Jakarta Africa/Bamako America/Mexico_City Asia/Kuala_Lumpur Pacific/Auckland Europe/Lisbon Europe/Moscow Europe/Kiev America/New_York Asia/Tashkent Pacific/Tahiti Pacific/Kosrae Pacific/Tarawa Asia/Almaty Pacific/Majuro Asia/Ulaanbaatar Arctic/Longyearbyen Pacific/Midway".split("\\s")));
        StandardCodes sc = StandardCodes.make();
        Set codes = sc.getGoodAvailableCodes("tzid");
        TreeSet<String> icu4jTZIDs = new TreeSet<String>(Arrays.asList(TimeZone.getAvailableIDs()));
        TreeSet<String> diff2 = new TreeSet<String>((Collection<String>)icu4jTZIDs);
        diff2.removeAll(codes);
        System.out.println("icu4jTZIDs - StandardCodes: " + diff2);
        diff2 = new TreeSet(codes);
        diff2.removeAll(icu4jTZIDs);
        System.out.println("StandardCodes - icu4jTZIDs: " + diff2);
        ArrayComparator ac = new ArrayComparator(new Comparator[]{ArrayComparator.COMPARABLE, ArrayComparator.COMPARABLE, ArrayComparator.COMPARABLE});
        Map zone_countries = sc.getZoneToCounty();
        TreeSet<Object[]> country_inflection_names = new TreeSet<Object[]>((Comparator<Object[]>)ac);
        Iterator it = codes.iterator();
        while (it.hasNext()) {
            String zoneID = (String)it.next();
            String country = (String)zone_countries.get(zoneID);
            TimeZone zone = TimeZone.getTimeZone((String)zoneID);
            ZoneInflections zip = new ZoneInflections(zone);
            country_inflection_names.add(new Object[]{country, zip, zoneID});
        }
        PrintWriter out = BagFormatter.openUTF8Writer((String)"../../dropbox/gen/", (String)"modernTimezoneEquivalents.html");
        out.println("<html><head><meta http-equiv='Content-Type' content='text/html; charset=utf-8'><title>Modern Equivalent Timezones</title><style>");
        out.println("td.top,td.topr { background-color: #EEEEFF }");
        out.println("td.r,td.topr { text-align:right }");
        out.println("td.gap { font-weight:bold; border-top: 3px solid #0000FF; border-bottom: 3px solid #0000FF; background-color: #CCCCCC }");
        out.println("</style></head><body><table border='1' cellspacing='0' cellpadding='2' style='border-collapse: collapse'>");
        Tabber.HTMLTabber tabber1 = new Tabber.HTMLTabber();
        tabber1.setParameters(4, "class='r'");
        tabber1.setParameters(5, "class='r'");
        Tabber.HTMLTabber tabber2 = new Tabber.HTMLTabber();
        tabber2.setParameters(0, "class='top'");
        tabber2.setParameters(1, "class='top'");
        tabber2.setParameters(2, "class='top'");
        tabber2.setParameters(3, "class='top'");
        tabber2.setParameters(4, "class='topr'");
        tabber2.setParameters(5, "class='topr'");
        Tabber.HTMLTabber tabber3 = new Tabber.HTMLTabber();
        tabber3.setParameters(0, "class='gap'");
        tabber3.setParameters(1, "class='gap'");
        tabber3.setParameters(2, "class='gap'");
        tabber3.setParameters(3, "class='gap'");
        tabber3.setParameters(4, "class='gap'");
        tabber3.setParameters(5, "class='gap'");
        long minimumDate = ICUServiceBuilder.isoDateParse("2000-1-1T00:00:00Z").getTime();
        out.println("<h1>Modern Equivalent Timezones: <a target='_blank' href='instructions.html'>Instructions</a></h1>");
        out.println("<p>$Date: 2006/07/02 19:23:37 $, $Revision: 1.20 $, MED</p>");
        out.println("<p>Zones identical after: " + ICUServiceBuilder.isoDateFormat(minimumDate) + "</p>");
        String lastCountry = "";
        ZoneInflections lastZip = null;
        ZoneInflections.OutputLong diff = new ZoneInflections.OutputLong(0L);
        CLDRFile.Factory cldrFactory = CLDRFile.Factory.make("../../common/main/", ".*");
        TimezoneFormatter tzf = new TimezoneFormatter(cldrFactory, "en", true);
        Map country_zoneSet = sc.getCountryToZoneSet();
        boolean shortList = true;
        boolean first = true;
        int category = 1;
        Tabber.HTMLTabber tabber = tabber1;
        Iterator it2 = country_inflection_names.iterator();
        while (it2.hasNext()) {
            Object[] row = (Object[])it2.next();
            String country = (String)row[0];
            if (country.equals("001") || shortList && ((Set)country_zoneSet.get(country)).size() < 2) continue;
            ZoneInflections zip = (ZoneInflections)row[1];
            String zoneID = (String)row[2];
            int zipComp = zip.compareTo(lastZip, diff);
            if (!country.equals(lastCountry)) {
                if (first) {
                    first = false;
                }
                category = 1;
                CountItems.subheader(out, (Tabber)tabber3);
            } else if (diff.value >= minimumDate) {
                tabber = tabber == tabber1 ? tabber2 : tabber1;
                ++category;
            }
            String zoneIDShown = zoneID;
            if (needsTranslation.contains(zoneID)) {
                zoneIDShown = "<b>" + zoneIDShown + "\u00b9</b>";
            }
            if (singleCountries.contains(zoneID)) {
                zoneIDShown = "<i>" + zoneIDShown + "</i> \u00b2";
            }
            if (defaultItems.contains(zoneID)) {
                zoneIDShown = "<span style='background-color: #FFFF00'>" + zoneIDShown + "</span> ?";
            }
            String newCountry = country;
            String mapLink = (String)country_map.get(country);
            if (mapLink != null) {
                newCountry = "<a target='map' href='" + mapLink + "'>" + country + "</a>";
            }
            String minOffset = ZoneInflections.formatHours(zip.getMinOffset(minimumDate));
            String maxOffset = ZoneInflections.formatHours(zip.getMaxOffset(minimumDate));
            if (!icu4jTZIDs.contains(zoneID)) {
                maxOffset = "??";
                minOffset = "??";
            }
            out.println(tabber.process(newCountry + "\t" + "<b>" + category + "</b>" + "\t" + zoneIDShown + "\t" + tzf.getFormattedZone(zoneID, "vvvv", minimumDate, false) + "\t" + minOffset + "\t" + maxOffset));
            lastCountry = country;
            lastZip = zip;
        }
        CountItems.subheader(out, (Tabber)tabber3);
        out.println("</table></body></html>");
        out.close();
    }

    private static void subheader(PrintWriter out, Tabber tabber) {
        out.println(tabber.process("Cnty\tGrp\tZoneID\tFormatted ID\tMaxOffset\tMinOffset"));
    }

    private static void getPatternBlocks() {
        UnicodeSet patterns = new UnicodeSet("[:pattern_syntax:]");
        UnicodeSet unassigned = new UnicodeSet("[:unassigned:]");
        UnicodeSet punassigned = new UnicodeSet(patterns).retainAll(unassigned);
        UnicodeMap blocks = ICUPropertyFactory.make().getProperty("block").getUnicodeMap();
        blocks.setMissing((Object)"<Reserved-Block>");
        UnicodeMap.MapIterator it = new UnicodeMap.MapIterator(blocks);
        while (it.nextRange()) {
            boolean show;
            UnicodeSet range = new UnicodeSet(it.codepoint, it.codepointEnd);
            boolean hasPat = range.containsSome(patterns);
            String prefix = !hasPat ? "Not-Syntax" : (!range.containsSome(unassigned) ? "Closed" : (!range.containsSome(punassigned) ? "Closed2" : "Open"));
            boolean bl = show = prefix.equals("Open") || prefix.equals("Closed2");
            if (show) {
                System.out.println();
            }
            System.out.println(prefix + "\t" + range + "\t" + it.value);
            if (!show) continue;
            System.out.println(new UnicodeMap().putAll(unassigned, (Object)"<reserved>").putAll(punassigned, (Object)"<reserved-for-syntax>").setMissing((Object)"<assigned>").putAll(range.complement(), null));
        }
    }

    private static void showExemplars() throws IOException {
        PrintWriter out = BagFormatter.openUTF8Writer((String)"../../dropbox/gen/", (String)"fixed_exemplars.txt");
        CLDRFile.Factory cldrFactory = CLDRFile.Factory.make("../../common/main/", ".*");
        Set locales = cldrFactory.getAvailable();
        Iterator it = locales.iterator();
        while (it.hasNext()) {
            UnicodeSet exemplars;
            System.out.print('.');
            String locale = (String)it.next();
            CLDRFile cldrfile = cldrFactory.make(locale, false);
            String v = cldrfile.getStringValue("//ldml/characters/exemplarCharacters");
            if (v == null || (exemplars = new UnicodeSet(v)).size() == 0 || exemplars.size() >= 500) continue;
            Collator col = Collator.getInstance((ULocale)new ULocale(locale));
            Collator spaceCol = Collator.getInstance((ULocale)new ULocale(locale));
            spaceCol.setStrength(0);
            out.println(locale + ":\t\u200e" + v + '\u200e');
            String fixed = CollectionUtilities.prettyPrint((UnicodeSet)exemplars, (boolean)true, null, null, (Comparator)col, (Comparator)spaceCol);
            out.println(" =>\t\u200e" + fixed + '\u200e');
            CountItems.verifyEquality(exemplars, new UnicodeSet(fixed));
            out.flush();
        }
        out.close();
    }

    private static void verifyEquality(UnicodeSet exemplars, UnicodeSet others) {
        if (others.equals((Object)exemplars)) {
            return;
        }
        System.out.println("FAIL\ta-b\t" + new UnicodeSet(exemplars).removeAll(others));
        System.out.println("\tb-a\t" + new UnicodeSet(others).removeAll(exemplars));
    }

    private static void countItems() {
        CLDRFile.Factory cldrFactory = CLDRFile.Factory.make("../../common/main/", ".*");
        CountItems.countItems(cldrFactory, false);
    }

    public static void genSupplementalZoneData(boolean skipUnaliased) {
        RuleBasedCollator col = (RuleBasedCollator)Collator.getInstance();
        col.setNumericCollation(true);
        StandardCodes sc = StandardCodes.make();
        Map zone_country = sc.getZoneToCounty();
        Map country_zone = sc.getCountryToZoneSet();
        Map old_new = sc.getZoneLinkold_new();
        TreeMap<String, TreeSet<String>> new_old = new TreeMap<String, TreeSet<String>>();
        Iterator it = old_new.keySet().iterator();
        while (it.hasNext()) {
            String old = (String)it.next();
            String newOne = (String)old_new.get(old);
            TreeSet<String> oldSet = (TreeSet<String>)new_old.get(newOne);
            if (oldSet == null) {
                oldSet = new TreeSet<String>();
                new_old.put(newOne, oldSet);
            }
            oldSet.add(old);
        }
        TreeMap<String, String> fullMap = new TreeMap<String, String>((Comparator<String>)col);
        Iterator it2 = zone_country.keySet().iterator();
        while (it2.hasNext()) {
            String zone = (String)it2.next();
            String defaultName = TimezoneFormatter.getFallbackName(zone);
            Object already = fullMap.get(defaultName);
            if (already != null) {
                System.out.println("CONFLICT: " + already + ", " + zone);
            }
            fullMap.put(defaultName, zone);
        }
        System.out.println("<!-- Generated by org.unicode.cldr.tool.CountItems -->");
        System.out.println("<supplementalData>");
        System.out.println("\t<timezoneData>");
        System.out.println();
        TreeSet<String> multizone = new TreeSet<String>();
        Iterator it3 = country_zone.keySet().iterator();
        while (it3.hasNext()) {
            String country = (String)it3.next();
            Set zones = (Set)country_zone.get(country);
            if (zones == null || zones.size() == 1) continue;
            multizone.add(country);
        }
        System.out.println("\t\t<zoneFormatting multizone=\"" + CountItems.toString(multizone, " ") + "\">");
        TreeSet orderedSet = new TreeSet(col);
        orderedSet.addAll(zone_country.keySet());
        orderedSet.addAll(sc.getDeprecatedZoneIDs());
        StringBuffer tzid = new StringBuffer();
        Iterator it4 = orderedSet.iterator();
        while (it4.hasNext()) {
            String zone = (String)it4.next();
            if (tzid.length() != 0) {
                tzid.append(' ');
            }
            tzid.append(zone);
            String country = (String)zone_country.get(zone);
            if (country == null) continue;
            TreeSet aliases = (TreeSet)new_old.get(zone);
            if (aliases != null) {
                aliases = new TreeSet(aliases);
                aliases.remove(zone);
            }
            if (skipUnaliased && (aliases == null || aliases.size() == 0)) continue;
            System.out.println("\t\t\t<zoneItem type=\"" + zone + "\"" + " territory=\"" + country + "\"" + (aliases != null && aliases.size() > 0 ? " aliases=\"" + CountItems.toString(aliases, " ") + "\"" : "") + "/>");
        }
        System.out.println("\t\t</zoneFormatting>");
        System.out.println();
        System.out.println("\t</timezoneData>");
        System.out.println("</supplementalData>");
        System.out.println();
        System.out.println("\t\t\t<variable id=\"$tzid\" type=\"choice\">" + tzid + "</variable>");
    }

    private static String toString(Collection aliases, String separator) {
        StringBuffer result = new StringBuffer();
        boolean first = true;
        Iterator it = aliases.iterator();
        while (it.hasNext()) {
            Object item = it.next();
            if (first) {
                first = false;
            } else {
                result.append(separator);
            }
            result.append(item);
        }
        return result.toString();
    }

    public static void showZoneInfo() throws IOException {
        String old;
        StandardCodes sc = StandardCodes.make();
        Map m = sc.getZoneLinkold_new();
        int i = 0;
        System.out.println("/* Generated by org.unicode.cldr.tool.CountItems */");
        System.out.println();
        i = 0;
        System.out.println("/* zoneID, canonical zoneID */");
        Iterator it = m.keySet().iterator();
        while (it.hasNext()) {
            old = (String)it.next();
            String newOne = (String)m.get(old);
            System.out.println("{\"" + old + "\", \"" + newOne + "\"},");
            ++i;
        }
        System.out.println("/* Total: " + i + " */");
        System.out.println();
        i = 0;
        System.out.println("/* All canonical zoneIDs */");
        it = sc.getZoneData().keySet().iterator();
        while (it.hasNext()) {
            old = (String)it.next();
            System.out.println("\"" + old + "\",");
            ++i;
        }
        System.out.println("/* Total: " + i + " */");
        CLDRFile.Factory mainCldrFactory = CLDRFile.Factory.make("../../common/main" + File.separator, ".*");
        CLDRFile desiredLocaleFile = mainCldrFactory.make("root", true);
        String temp = desiredLocaleFile.getFullXPath("//ldml/dates/timeZoneNames/singleCountries");
        String singleCountriesList = (String)new XPathParts(null, null).set(temp).findAttributes("singleCountries").get("list");
        TreeSet singleCountriesSet = new TreeSet(Utility.splitList(singleCountriesList, ' '));
        Map zone_countries = StandardCodes.make().getZoneToCounty();
        Map countries_zoneSet = StandardCodes.make().getCountryToZoneSet();
        System.out.println();
        i = 0;
        System.out.println("/* zoneID, country, isSingle */");
        Iterator it2 = zone_countries.keySet().iterator();
        while (it2.hasNext()) {
            String old2 = (String)it2.next();
            String newOne = (String)zone_countries.get(old2);
            Set s = (Set)countries_zoneSet.get(newOne);
            String isSingle = s != null && s.size() == 1 || singleCountriesSet.contains(old2) ? "T" : "F";
            System.out.println("{\"" + old2 + "\", \"" + newOne + "\", \"" + isSingle + "\"},");
            ++i;
        }
        System.out.println("/* Total: " + i + " */");
    }

    private static int countItems(CLDRFile.Factory cldrFactory, boolean resolved) {
        int count = 0;
        int resolvedCount = 0;
        Set locales = cldrFactory.getAvailable();
        HashSet<String> keys = new HashSet<String>();
        HashSet<String> values = new HashSet<String>();
        HashSet<String> fullpaths = new HashSet<String>();
        HashSet<String> temp = new HashSet<String>();
        Iterator it = locales.iterator();
        while (it.hasNext()) {
            String locale = (String)it.next();
            if (CLDRFile.isSupplementalName(locale)) continue;
            CLDRFile item = cldrFactory.make(locale, false);
            temp.clear();
            Iterator it2 = item.iterator();
            while (it2.hasNext()) {
                String path = (String)it2.next();
                temp.add(path);
                keys.add(path);
                values.add(item.getStringValue(path));
                fullpaths.add(item.getFullXPath(path));
            }
            int current = temp.size();
            CLDRFile itemResolved = cldrFactory.make(locale, true);
            temp.clear();
            CollectionUtilities.addAll((Iterator)itemResolved.iterator(), temp);
            int resolvedCurrent = temp.size();
            System.out.println(locale + "\tPlain:\t" + current + "\tResolved:\t" + resolvedCurrent + "\tUnique Paths:\t" + keys.size() + "\tUnique Values:\t" + values.size() + "\tUnique Full Paths:\t" + fullpaths.size());
            count += current;
            resolvedCount += resolvedCurrent;
        }
        System.out.println("Total Items\t" + count + "\tTotal Resolved Items\t" + resolvedCount);
        System.out.println("Unique Paths\t" + keys.size());
        System.out.println("Unique Values\t" + values.size());
        System.out.println("Unique Full Paths\t" + fullpaths.size());
        return count;
    }
}

