/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.ibm.icu.dev.test.util.BNF;
import com.ibm.icu.dev.test.util.BagFormatter;
import com.ibm.icu.dev.test.util.Quoter;
import com.ibm.icu.dev.test.util.TransliteratorUtilities;
import com.ibm.icu.dev.tool.UOption;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.Collator;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.RuleBasedCollator;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.tool.GenerateAttributeList;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.LanguageTagParser;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.TimezoneFormatter;
import org.unicode.cldr.util.Utility;
import org.unicode.cldr.util.XPathParts;

public class Misc {
    static CLDRFile.Factory cldrFactory;
    static CLDRFile english;
    static CLDRFile resolvedRoot;
    private static final int HELP1 = 0;
    private static final int HELP2 = 1;
    private static final int SOURCEDIR = 2;
    private static final int DESTDIR = 3;
    private static final int MATCH = 4;
    private static final int TO_LOCALIZE = 5;
    private static final int CURRENT = 6;
    private static final int WINDOWS = 7;
    private static final int OBSOLETES = 8;
    private static final int ALIASES = 9;
    private static final int INFO = 10;
    private static final int ZONES = 11;
    private static final int LANGUAGE_TAGS = 12;
    private static final UOption[] options;
    private static final String HELP_TEXT;
    static Set priorities;
    static long JAN152006;
    static long JUNE152006;
    static NumberFormat hours;
    static String[] ZONE_MAP;
    static Utility.VariableReplacer langTag;
    static String langTagPattern;
    static String cleanedLangTagPattern;
    static Matcher regexLanguageTagOld;
    static String[] groupNames;
    static final String[] COUNTRY_CORRECTIONS;
    static final Map corrections;
    static String[] levelNames;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        try {
            UOption.parseArgs((String[])args, (UOption[])options);
            if (Misc.options[0].doesOccur || Misc.options[0].doesOccur) {
                System.out.println(HELP_TEXT);
                return;
            }
            cldrFactory = CLDRFile.Factory.make(Misc.options[2].value + "main\\", Misc.options[4].value);
            english = cldrFactory.make("en", false);
            resolvedRoot = cldrFactory.make("root", true);
            if (Misc.options[4].value.equals("group1")) {
                Misc.options[4].value = "(en|fr|de|it|es|pt|ja|ko|zh)";
            }
            TreeSet languages = new TreeSet(cldrFactory.getAvailableLanguages());
            if (Misc.options[6].doesOccur) {
                Misc.printCurrentTimezoneLocalizations(languages);
            }
            if (Misc.options[11].doesOccur) {
                Misc.printAllZoneLocalizations();
            }
            if (Misc.options[5].doesOccur) {
                Iterator it = languages.iterator();
                while (it.hasNext()) {
                    String language = (String)it.next();
                    Misc.printSupplementalData(language);
                }
            }
            if (Misc.options[7].doesOccur) {
                Misc.printWindowsZones();
            }
            if (Misc.options[10].doesOccur) {
                PrintWriter pw = BagFormatter.openUTF8Writer((String)"../../dropbox/gen/", (String)"attributesAndValues.html");
                new GenerateAttributeList(cldrFactory).show(pw);
                pw.close();
            }
            if (Misc.options[8].doesOccur) {
                Misc.listObsoletes();
            }
            if (Misc.options[9].doesOccur) {
                Misc.printZoneAliases();
            }
            if (Misc.options[12].doesOccur) {
                Misc.testLanguageTags();
            }
        }
        finally {
            System.out.println("DONE");
        }
    }

    private static void showLanguageTagCount() {
        StandardCodes sc = StandardCodes.make();
        int languageCount = sc.getAvailableCodes("language").size();
        int countryCount = sc.getAvailableCodes("territory").size();
        Iterator it = sc.getAvailableCodes("territory").iterator();
        while (it.hasNext()) {
            System.out.print("fr-" + it.next() + ", ");
        }
        System.out.println(languageCount + ", " + countryCount + ", " + (23 + languageCount * countryCount));
    }

    private static void listObsoletes() {
        StandardCodes sc = StandardCodes.make();
        Iterator typeIt = sc.getAvailableTypes().iterator();
        while (typeIt.hasNext()) {
            String type = (String)typeIt.next();
            System.out.println(type);
            Iterator codeIt = sc.getAvailableCodes(type).iterator();
            while (codeIt.hasNext()) {
                String replacementCode;
                String code = (String)codeIt.next();
                List list = sc.getFullData(type, code);
                if (list.size() < 3 || (replacementCode = (String)list.get(2)).length() == 0) continue;
                System.out.println(code + " => " + replacementCode + "; " + english.getName(type, replacementCode, true));
            }
        }
    }

    private static void printAllZoneLocalizations() throws IOException {
        Iterator<Object> it;
        StandardCodes sc = StandardCodes.make();
        Set zones = sc.getAvailableCodes("tzid");
        TreeMap offset_zone_locale_name = new TreeMap();
        Iterator it2 = priorities.iterator();
        while (it2.hasNext()) {
            String locale = (String)it2.next();
            System.out.println(locale);
            try {
                TimezoneFormatter tzf = new TimezoneFormatter(cldrFactory, locale, true);
                it = zones.iterator();
                while (it.hasNext()) {
                    TreeMap<String, String> locale_name;
                    String zone = (String)it.next();
                    TimeZone tzone = TimeZone.getTimeZone((String)zone);
                    int stdOffset = tzone.getRawOffset();
                    Integer standardOffset = new Integer(-stdOffset);
                    String name = tzf.getFormattedZone(zone, "vvvv", false, stdOffset, false);
                    String gmt = tzf.getFormattedZone(zone, "ZZZZ", false, stdOffset, false);
                    String fullName = "(" + gmt + ") " + (zone.startsWith("Etc") ? "" : name);
                    TreeMap<String, TreeMap<String, String>> zone_locale_name = (TreeMap<String, TreeMap<String, String>>)offset_zone_locale_name.get(standardOffset);
                    if (zone_locale_name == null) {
                        zone_locale_name = new TreeMap<String, TreeMap<String, String>>();
                        offset_zone_locale_name.put(standardOffset, zone_locale_name);
                    }
                    if ((locale_name = (TreeMap<String, String>)zone_locale_name.get(zone)) == null) {
                        locale_name = new TreeMap<String, String>();
                        zone_locale_name.put(zone, locale_name);
                    }
                    locale_name.put(locale, fullName);
                }
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
        PrintWriter out = BagFormatter.openUTF8Writer((String)"c:/", (String)"zone_localizations.html");
        out.println("<html><head>");
        out.println("<meta http-equiv='Content-Type' content='text/html; charset=utf-8'>");
        out.println("<title>Zone Localizations</title>");
        out.println("<style>");
        out.println("th,td { text-align: left; vertical-align: top }");
        out.println("th { background-color: gray }");
        out.println("</style>");
        out.println("</head>");
        out.println("<body>");
        out.println("<table cellspacing='0' cellpadding='2' border='1'>");
        out.println("<tr><th></th><th>No</th><th>Country</th><th>Offset(s)</th>");
        Iterator it22 = priorities.iterator();
        while (it22.hasNext()) {
            String locale = (String)it22.next();
            String englishLocaleName = english.getName(locale, false);
            out.println("<th>" + locale + " (" + englishLocaleName + ")" + "</th>");
        }
        out.println("</tr>");
        Map zone_country = sc.getZoneToCounty();
        int count = 0;
        it = offset_zone_locale_name.keySet().iterator();
        while (it.hasNext()) {
            Integer offset = (Integer)it.next();
            Map zone_locale_name = (Map)offset_zone_locale_name.get(offset);
            Iterator it23 = zone_locale_name.keySet().iterator();
            while (it23.hasNext()) {
                String zone = (String)it23.next();
                out.println("<tr>");
                out.println("<th>" + ++count + "</th>");
                out.println("<th>" + zone + "</th>");
                String country = (String)zone_country.get(zone);
                String countryName = english.getName(2, country, false);
                out.println("<td>" + country + " (" + countryName + ")" + "</td>");
                TimeZone tzone = TimeZone.getTimeZone((String)zone);
                out.println("<td>" + Misc.offsetString(tzone) + "</td>");
                Map locale_name = (Map)zone_locale_name.get(zone);
                Iterator it3 = priorities.iterator();
                while (it3.hasNext()) {
                    String locale = (String)it3.next();
                    String name = (String)locale_name.get(locale);
                    out.println("<td>");
                    if (name == null) {
                        out.println("&nbsp;");
                    } else {
                        out.println(TransliteratorUtilities.toHTML.transliterate(name));
                    }
                    out.println("</td>");
                }
                out.println("</tr>");
            }
        }
        out.println("</table></body></html>");
        out.close();
    }

    private static String offsetString(TimeZone tzone) {
        int janOffset = tzone.getOffset(JAN152006);
        int juneOffset = tzone.getOffset(JUNE152006);
        String result = hours.format((double)janOffset / 3600000.0);
        if (juneOffset != janOffset) {
            result = result + " / " + hours.format((double)juneOffset / 3600000.0);
        }
        return result;
    }

    private static void printCurrentTimezoneLocalizations(Set languages) throws IOException {
        TreeSet<String> rtlLanguages = new TreeSet<String>();
        Iterator it = languages.iterator();
        while (it.hasNext()) {
            String language = (String)it.next();
            CLDRFile desiredLocaleFile = cldrFactory.make(language, true);
            String orientation = desiredLocaleFile.getFullXPath("//ldml/layout/orientation");
            boolean rtl = orientation == null ? false : orientation.indexOf("[@characters=\"right-to-left\"]") >= 0;
            PrintWriter log = BagFormatter.openUTF8Writer((String)(Misc.options[3].value + ""), (String)(language + "_timezones.html"));
            log.println("<html><head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">");
            log.println("<style type=\"text/css\"><!--");
            log.println("td { text-align: center; vertical-align:top }");
            log.println("th { vertical-align:top }");
            if (rtl) {
                rtlLanguages.add(language);
                log.println("body { direction:rtl }");
                log.println(".ID {background-color: silver; text-align:right;}");
                log.println(".T {text-align:right; color: green}");
            } else {
                log.println(".ID {background-color: silver; text-align:left;}");
                log.println(".T {text-align:left; color: green}");
            }
            log.println(".I {color: blue}");
            log.println(".A {color: red}");
            log.println("--></style>");
            log.println("<title>Time Zone Localizations for " + language + "</title><head><body>");
            log.println("<table border=\"1\" cellpadding=\"0\" cellspacing=\"0\" style=\"border-collapse: collapse\">");
            Misc.printCurrentTimezoneLocalizations(log, language);
            log.println("</table></body></html>");
            log.close();
        }
        System.out.println("RTL languages: " + rtlLanguages);
    }

    static void printZoneAliases() {
        RuleBasedCollator col = (RuleBasedCollator)Collator.getInstance((ULocale)ULocale.ENGLISH);
        col.setNumericCollation(true);
        StandardCodes sc = StandardCodes.make();
        Map zone_countries = sc.getZoneToCounty();
        Map old_new = sc.getZoneLinkold_new();
        TreeMap new_old = new TreeMap((Comparator<String>)col);
        TreeMap<String, TreeSet<String>> country_zones = new TreeMap<String, TreeSet<String>>((Comparator<String>)col);
        Iterator it = zone_countries.keySet().iterator();
        while (it.hasNext()) {
            String zone = (String)it.next();
            new_old.put(zone, new TreeSet(col));
            String country = (String)zone_countries.get(zone);
            String name = english.getName("territory", country, false) + " (" + country + ")";
            TreeSet<String> oldSet = (TreeSet<String>)country_zones.get(name);
            if (oldSet == null) {
                oldSet = new TreeSet<String>((Comparator<String>)col);
                country_zones.put(name, oldSet);
            }
            oldSet.add(zone);
        }
        it = old_new.keySet().iterator();
        while (it.hasNext()) {
            String oldOne = (String)it.next();
            String newOne = (String)old_new.get(oldOne);
            Set oldSet = (Set)new_old.get(newOne);
            oldSet.add(oldOne);
        }
        Iterator it3 = country_zones.keySet().iterator();
        while (it3.hasNext()) {
            String country = (String)it3.next();
            System.out.println(country);
            Set zones = (Set)country_zones.get(country);
            Iterator it2 = zones.iterator();
            while (it2.hasNext()) {
                String newOne = (String)it2.next();
                System.out.println("    tzid:\t" + newOne);
                Set oldSet = (Set)new_old.get(newOne);
                Iterator it22 = oldSet.iterator();
                while (it22.hasNext()) {
                    String oldOne = (String)it22.next();
                    System.out.println("        alias:\t" + oldOne);
                }
            }
        }
    }

    static void printWindowsZones() {
        int i;
        System.out.println("\t<timezoneData>");
        System.out.println("\t\t<mapTimezones type=\"windows\">");
        for (i = 0; i < ZONE_MAP.length; i += 3) {
            System.out.println("\t\t\t<mapZone other=\"" + ZONE_MAP[i + 1] + "\" type=\"" + ZONE_MAP[i] + "\"/> <!-- " + ZONE_MAP[i + 2] + "-->");
        }
        System.out.println("\t\t</mapTimezones>");
        System.out.println("\t</timezoneData>");
        for (i = 0; i < ZONE_MAP.length; i += 3) {
            int p1 = ZONE_MAP[i + 2].indexOf(40);
            int p2 = ZONE_MAP[i + 2].indexOf(41);
            System.out.println(ZONE_MAP[i] + "\t" + ZONE_MAP[i + 1] + "\t" + ZONE_MAP[i + 2].substring(0, p1) + "\t" + ZONE_MAP[i + 2].substring(p1 + 1, p2) + "\t" + ZONE_MAP[i + 2].substring(p2 + 1));
        }
    }

    private static void printCurrentTimezoneLocalizations(PrintWriter log, String locale) throws IOException {
        StandardCodes sc = StandardCodes.make();
        Map linkNew_Old = sc.getZoneLinkNew_OldSet();
        TimezoneFormatter tzf = new TimezoneFormatter(cldrFactory, locale, true);
        RuleBasedCollator col = (RuleBasedCollator)Collator.getInstance((ULocale)new ULocale(locale));
        col.setNumericCollation(true);
        TreeSet orderedAliases = new TreeSet(col);
        Map zone_countries = StandardCodes.make().getZoneToCounty();
        Map countries_zoneSet = StandardCodes.make().getCountryToZoneSet();
        TreeMap<String, String> reordered = new TreeMap<String, String>((Comparator<String>)col);
        CLDRFile desiredLocaleFile = cldrFactory.make(locale, true);
        Iterator it = zone_countries.keySet().iterator();
        while (it.hasNext()) {
            String zoneID = (String)it.next();
            String country = (String)zone_countries.get(zoneID);
            String countryName = desiredLocaleFile.getName(2, country, false);
            if (countryName == null) {
                countryName = UTF16.valueOf((int)1114109) + country;
            }
            reordered.put(countryName + "0" + zoneID, zoneID);
        }
        String[] field = new String[4];
        boolean first = true;
        int count = 0;
        Iterator it2 = reordered.keySet().iterator();
        while (it2.hasNext()) {
            String key = (String)it2.next();
            String zoneID = (String)reordered.get(key);
            String country = (String)zone_countries.get(zoneID);
            String countryName = desiredLocaleFile.getName(2, country, false);
            if (countryName == null) {
                countryName = country;
            }
            log.println("<tr><th class='ID' colspan=\"4\"><table><tr><th class='I'>" + ++count + "</th><th class='T'>" + TransliteratorUtilities.toHTML.transliterate(countryName) + "</th><th class='I'>\u200e" + TransliteratorUtilities.toHTML.transliterate(zoneID));
            Set s = (Set)linkNew_Old.get(zoneID);
            if (s != null) {
                log.println("\u200e</th><td class='A'>\u200e");
                orderedAliases.clear();
                orderedAliases.addAll(s);
                boolean first2 = true;
                Iterator it9 = s.iterator();
                while (it9.hasNext()) {
                    String alias = (String)it9.next();
                    if (first2) {
                        first2 = false;
                    } else {
                        log.println("; ");
                    }
                    log.print(TransliteratorUtilities.toHTML.transliterate(alias));
                }
            }
            log.print("\u200e</td></tr></table></th></tr>");
            if (first) {
                first = false;
                log.println("<tr><th width=\"25%\">&nbsp;</th><th width=\"25%\">generic</th><th width=\"25%\">standard</th><th width=\"25%\">daylight</th></tr>");
            } else {
                log.println("<tr><th>&nbsp;</th><th>generic</th><th>standard</th><th>daylight</th></tr>");
            }
            for (int i = 0; i < 2; ++i) {
                int j;
                log.println("<tr><th>" + TimezoneFormatter.LENGTH.get(i) + "</th>");
                for (j = 0; j < 4; ++j) {
                    field[j] = TransliteratorUtilities.toHTML.transliterate(tzf.getFormattedZone(zoneID, i, j, 0, false));
                }
                if (field[0].equals(field[1]) && field[1].equals(field[2])) {
                    log.println("<td colspan=\"3\">" + field[0] + "</td>");
                } else {
                    for (j = 0; j < 4; ++j) {
                        log.println("<td>" + field[j] + "</td>");
                    }
                }
                log.println("</tr>");
            }
        }
    }

    void showOrderedTimezones() {
        StandardCodes sc = StandardCodes.make();
        String world = sc.getData("territory", "001");
    }

    private static void testLanguageTags() throws IOException {
        String test;
        BNFData bnfData = new BNFData();
        bnfData.setFromFile("./org/unicode/cldr/util/data/langtagRegex.txt");
        String contents = bnfData.getRules();
        Pattern pat = bnfData.getPattern();
        Matcher regexLanguageTag = pat.matcher("");
        BNF bnf = bnfData.getBnf();
        for (int i = 0; i < 100; ++i) {
            String trial = bnf.next();
            System.out.println(trial);
            if (regexLanguageTag.reset(trial).matches()) continue;
            throw new IllegalArgumentException("Regex generation fails with: " + trial);
        }
        System.out.println("*** ILL-FORMED ***");
        BNF invalidBNF = new BNF(new Random(0L), (Quoter)new Quoter.RuleQuoter()).setMaxRepeat(5).addRules("$tag = ([A-Z a-z 0-9]{1,8} 50% 20% 10% 5% 5% 5% 5%);").addRules("$s = [-_] ;").addRules("$root = $tag ($s $tag){0,7} 10% 10% 10% 10% 10% 10% 10% 10% ; ").complete();
        for (int i = 0; i < 100; ++i) {
            String trial = invalidBNF.next();
            if (regexLanguageTag.reset(trial).matches()) continue;
            System.out.println(trial);
        }
        System.out.println(contents);
        StandardCodes sc = StandardCodes.make();
        Set grandfathered = sc.getAvailableCodes("grandfathered");
        LanguageTagParser ltp = new LanguageTagParser();
        boolean expected = true;
        int errorCount = 0;
        BufferedReader in = BagFormatter.openUTF8Reader((String)"./org/unicode/cldr/util/data/", (String)"langtagTest.txt");
        int i = 0;
        while ((test = in.readLine()) != null) {
            if (test.length() != 0) {
                int hashPos;
                if (test.charAt(0) == '\ufeff') {
                    test = test.substring(1);
                }
                if ((hashPos = test.indexOf(35)) >= 0) {
                    test = test.substring(0, hashPos);
                }
                if ((test = test.trim()).length() != 0) {
                    if (test.equalsIgnoreCase("WELL-FORMED")) {
                        expected = true;
                    } else if (test.equalsIgnoreCase("ILL-FORMED")) {
                        expected = false;
                    } else {
                        try {
                            System.out.println("Parsing " + test);
                            ltp.set(test);
                            if (ltp.getLanguage().length() != 0) {
                                System.out.println("\tlang:    \t" + ltp.getLanguage() + (ltp.isGrandfathered() ? " (grandfathered)" : ""));
                            }
                            if (ltp.getScript().length() != 0) {
                                System.out.println("\tscript:\t" + ltp.getScript());
                            }
                            if (ltp.getRegion().length() != 0) {
                                System.out.println("\tregion:\t" + ltp.getRegion());
                            }
                            if (ltp.getVariants().size() != 0) {
                                System.out.println("\tvariants:\t" + ltp.getVariants());
                            }
                            if (ltp.getExtensions().size() != 0) {
                                System.out.println("\textensions:\t" + ltp.getExtensions());
                            }
                            System.out.println("\tisValid?\t" + ltp.isValid());
                        }
                        catch (Exception e) {
                            System.out.println("\t" + e.getMessage());
                            System.out.println("\tisValid?\tfalse");
                        }
                        boolean matches = regexLanguageTag.reset(test).matches();
                        if (matches != expected) {
                            ++errorCount;
                        }
                        System.out.println("\tregex?\t" + matches + (matches == expected ? "" : "\t EXPECTED: " + expected + " for\t" + test));
                        if (matches) {
                            for (int j = 0; j <= regexLanguageTag.groupCount(); ++j) {
                                String g = regexLanguageTag.group(j);
                                if (g == null || g.length() == 0) continue;
                                System.out.println("\t" + j + "\t" + groupNames[j] + ":\t" + g);
                            }
                        }
                    }
                }
            }
            ++i;
        }
        System.out.println("Error count: " + errorCount);
    }

    private static void getZoneData() {
        String key;
        String key2;
        StandardCodes sc = StandardCodes.make();
        System.out.println("Links: Old->New");
        Map m = sc.getZoneLinkold_new();
        int count = 0;
        Iterator it = m.keySet().iterator();
        while (it.hasNext()) {
            String key3 = (String)it.next();
            String newOne = (String)m.get(key3);
            System.out.println(++count + "\t" + key3 + " => " + newOne);
        }
        count = 0;
        System.out.println();
        System.out.println("Links: Old->New, not final");
        Set oldIDs = m.keySet();
        Iterator it2 = oldIDs.iterator();
        while (it2.hasNext()) {
            String temp;
            ++count;
            key2 = (String)it2.next();
            String newOne = (String)m.get(key2);
            String further = (String)m.get(newOne);
            if (further == null) continue;
            while ((temp = (String)m.get(further)) != null) {
                further = temp;
            }
            System.out.println(count + "\t" + key2 + " => " + newOne + " # NOT FINAL => " + further);
        }
        m = sc.getZone_rules();
        System.out.println();
        System.out.println("Zones with old IDs");
        it2 = m.keySet().iterator();
        while (it2.hasNext()) {
            key2 = (String)it2.next();
            if (!oldIDs.contains(key2)) continue;
            System.out.println(key2);
        }
        Set modernIDs = sc.getZoneData().keySet();
        System.out.println();
        System.out.println("Zones without countries");
        TreeSet temp = new TreeSet(m.keySet());
        temp.removeAll(modernIDs);
        System.out.println(temp);
        Set countries = sc.getAvailableCodes("territory");
        System.out.println();
        System.out.println("Countries without zones");
        temp.clear();
        temp.addAll(countries);
        temp.removeAll(sc.getOld3166());
        Iterator<Object> it3 = sc.getZoneData().values().iterator();
        while (it3.hasNext()) {
            Object x = it3.next();
            List list = (List)x;
            temp.remove(list.get(2));
        }
        it3 = temp.iterator();
        while (it3.hasNext()) {
            String item = (String)it3.next();
            if (!UCharacter.isDigit((int)item.charAt(0))) continue;
            it3.remove();
        }
        System.out.println(temp);
        System.out.println();
        System.out.println("Zone->RulesIDs");
        m = sc.getZone_rules();
        it3 = m.keySet().iterator();
        while (it3.hasNext()) {
            key = (String)it3.next();
            System.out.println(key + " => " + "\n" + "\t" + Misc.getSeparated((Collection)m.get(key), "\n\t"));
        }
        System.out.println();
        System.out.println("RulesID->Rules");
        m = sc.getZoneRuleID_rules();
        it3 = m.keySet().iterator();
        while (it3.hasNext()) {
            key = (String)it3.next();
            System.out.println(key + " => " + "\n" + "\t" + Misc.getSeparated((Collection)m.get(key), "\n\t"));
        }
    }

    private static String getSeparated(Collection c, String separator) {
        StringBuffer result = new StringBuffer();
        boolean first = true;
        Iterator it = c.iterator();
        while (it.hasNext()) {
            if (first) {
                first = false;
            } else {
                result.append(separator);
            }
            result.append(it.next());
        }
        return result.toString();
    }

    private static void getCities() throws IOException {
        StandardCodes sc = StandardCodes.make();
        Set territories = sc.getAvailableCodes("territory");
        Map zoneData = sc.getZoneData();
        TreeSet s = new TreeSet(sc.getTZIDComparator());
        s.addAll(sc.getZoneData().keySet());
        int counter = 0;
        Iterator it = s.iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            System.out.println(++counter + "\t" + key + "\t" + zoneData.get(key));
        }
        TreeSet missing2 = new TreeSet(sc.getZoneData().keySet());
        missing2.removeAll(sc.getZoneToCounty().keySet());
        System.out.println(missing2);
        missing2.clear();
        missing2.addAll(sc.getZoneToCounty().keySet());
        missing2.removeAll(sc.getZoneData().keySet());
        System.out.println(missing2);
    }

    private static void printSupplementalData(String locale) throws IOException {
        PrintWriter log = null;
        CLDRFile desiredLocaleFile = (CLDRFile)cldrFactory.make(locale, true).cloneAsThawed();
        desiredLocaleFile.removeDuplicates(resolvedRoot, false, new HashMap());
        CLDRFile english = cldrFactory.make("en", true);
        Collator col = Collator.getInstance((ULocale)new ULocale(locale));
        CLDRFile supp = cldrFactory.make("supplementalData", false);
        XPathParts parts = new XPathParts(null, null);
        Iterator it = supp.iterator();
        while (it.hasNext()) {
            String path = (String)it.next();
            parts.set(supp.getFullXPath(path));
            Map m = parts.findAttributes("language");
            if (m != null) continue;
        }
        TreeMap<String, List> groups = new TreeMap<String, List>();
        Iterator it2 = supp.iterator();
        while (it2.hasNext()) {
            String path = (String)it2.next();
            parts.set(supp.getFullXPath(path));
            Map m = parts.findAttributes("territoryContainment");
            if (m == null) continue;
            Map attributes = parts.getAttributes(2);
            String type = (String)attributes.get("type");
            List contents = Utility.splitList((String)attributes.get("contains"), ' ', true, new ArrayList());
            groups.put(type, contents);
        }
        TreeSet seen = new TreeSet();
        Misc.printTimezonesToLocalize(log, desiredLocaleFile, groups, seen, col, false, english);
        StandardCodes sc = StandardCodes.make();
        Set codes = sc.getAvailableCodes("territory");
        TreeSet missing = new TreeSet(codes);
        missing.removeAll(seen);
        if (log != null) {
            log.close();
        }
    }

    private static void printTimezonesToLocalize(PrintWriter log, CLDRFile localization, Map groups, Set seen, Collator col, boolean showCode, CLDRFile english) throws IOException {
        Set[] missing = new Set[]{new TreeSet(), new TreeSet(StandardCodes.make().getTZIDComparator())};
        Misc.printWorldTimezoneCategorization(log, localization, groups, "001", 0, seen, col, showCode, Misc.zones_countrySet(), missing);
        if (missing[0].size() == 0 && missing[1].size() == 0) {
            return;
        }
        PrintWriter log2 = BagFormatter.openUTF8Writer((String)(Misc.options[3].value + ""), (String)(localization.getLocaleID() + "_to_localize.xml"));
        log2.println("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
        log2.println("<!DOCTYPE ldml SYSTEM \"http://www.unicode.org/cldr/dtd/1.4//ldml.dtd\">");
        log2.println("<ldml><identity><version number=\"1.4\"/><generation date=\"2005-01-01\"/><language type=\"" + TransliteratorUtilities.toXML.transliterate(localization.getLocaleID()) + "\"/></identity>");
        log2.println("<!-- The following are strings that are not found in the locale (currently), but need valid translations for localizing timezones. -->");
        if (missing[0].size() != 0) {
            log2.println("<localeDisplayNames><territories>");
            Iterator it = missing[0].iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                log2.println("\t<territory type=\"" + key + "\" draft=\"unconfirmed\">" + TransliteratorUtilities.toXML.transliterate("TODO " + english.getName(2, key, false)) + "</territory>");
            }
            log2.println("</territories></localeDisplayNames>");
        }
        String lastCountry = "";
        log2.println("<dates><timeZoneNames>");
        log2.println("\t<hourFormat>TODO +HHmm;-HHmm</hourFormat>");
        log2.println("\t<hoursFormat>TODO {0}/{1}</hoursFormat>");
        log2.println("\t<gmtFormat>TODO GMT{0}</gmtFormat>");
        log2.println("\t<regionFormat>TODO {0}</regionFormat>");
        log2.println("\t<fallbackFormat>TODO {0} ({1})</fallbackFormat>");
        Iterator it = missing[1].iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            List data = (List)StandardCodes.make().getZoneData().get(key);
            String countryCode = (String)data.get(2);
            String country = english.getName(2, countryCode, false);
            if (!country.equals(lastCountry)) {
                lastCountry = country;
                log2.println("\t<!-- " + country + "-->");
            }
            log2.println("\t<zone type=\"" + key + "\"><exemplarCity draft=\"unconfirmed\">" + TransliteratorUtilities.toXML.transliterate("TODO " + Misc.getName(english, key, null)) + "</exemplarCity></zone>");
        }
        log2.println("</timeZoneNames></dates>");
        log2.println("</ldml>");
        log2.close();
    }

    private static void printWorldTimezoneCategorization(PrintWriter log, CLDRFile localization, Map groups, String key, int indent, Set seen, Collator col, boolean showCode, Map zone_countrySet, Set[] missing) {
        String value;
        seen.add(key);
        String name = Misc.getName(localization, key, missing);
        Collection s = (Collection)groups.get(key);
        String element = levelNames[indent];
        if (log != null) {
            log.print(Utility.repeat("\t", indent) + "<" + element + " n=\"" + name + (showCode ? " (" + key + ")" : "") + "\"");
        }
        boolean gotZones = true;
        if (s == null) {
            s = (Collection)zone_countrySet.get(key);
            if (s == null || s.size() == 1) {
                s = null;
            } else {
                gotZones = true;
            }
        }
        if (s == null) {
            if (log != null) {
                log.println("/>");
            }
            return;
        }
        if (log != null) {
            log.println(">");
        }
        TreeMap<String, String> reorder = new TreeMap<String, String>((Comparator<String>)col);
        Iterator<Object> it = s.iterator();
        while (it.hasNext()) {
            key = (String)it.next();
            value = Misc.getName(localization, key, missing);
            if (value == null) {
                System.out.println("Missing value for: " + key);
                value = key;
            }
            reorder.put(value, key);
        }
        it = reorder.keySet().iterator();
        while (it.hasNext()) {
            key = (String)it.next();
            value = (String)reorder.get(key);
            Misc.printWorldTimezoneCategorization(log, localization, groups, value, indent + 1, seen, col, showCode, zone_countrySet, missing);
        }
        if (log != null) {
            log.println(Utility.repeat("\t", indent) + "</" + element + ">");
        }
    }

    private static String getName(CLDRFile localization, String key, Set[] missing) {
        String name;
        int pos = key.lastIndexOf(47);
        if (pos >= 0) {
            String v = localization.getStringValue("//ldml/dates/timeZoneNames/zone[@type=\"" + key + "\"]/exemplarCity");
            if (v != null) {
                name = v;
            } else {
                if (missing != null) {
                    missing[1].add(key);
                }
                name = key.substring(pos + 1);
                name = name.replace('_', ' ');
            }
        } else {
            name = localization.getName(2, key, false);
            if (name == null) {
                if (missing != null) {
                    missing[0].add(key);
                }
                name = key;
            }
        }
        return name;
    }

    static Map zones_countrySet() {
        Map m = StandardCodes.make().getZoneData();
        TreeMap<String, TreeSet<String>> result = new TreeMap<String, TreeSet<String>>();
        Iterator it = m.keySet().iterator();
        while (it.hasNext()) {
            String tzid = (String)it.next();
            List list = (List)m.get(tzid);
            String country = (String)list.get(2);
            TreeSet<String> zones = (TreeSet<String>)result.get(country);
            if (zones == null) {
                zones = new TreeSet<String>();
                result.put(country, zones);
            }
            zones.add(tzid);
        }
        return result;
    }

    private static String fixNumericKey(String key) {
        char c = key.charAt(0);
        if (c > '9') {
            return key;
        }
        String fixedKey = key.length() == 3 ? key : (key.length() == 2 ? "0" + key : "00" + key);
        return fixedKey;
    }

    private static void compareLists() throws IOException {
        String line;
        BufferedReader in = BagFormatter.openUTF8Reader((String)"", (String)"language_list.txt");
        String[] pieces = new String[4];
        CLDRFile.Factory cldrFactory = CLDRFile.Factory.make(Misc.options[2].value + "main\\", ".*");
        Set locales = cldrFactory.getAvailable();
        TreeSet<String> cldr = new TreeSet<String>();
        LanguageTagParser parser = new LanguageTagParser();
        Iterator it = locales.iterator();
        while (it.hasNext()) {
            String locale = (String)it.next();
            parser.set(locale);
            if (parser.getScript().length() == 0 && parser.getRegion().length() == 0 || parser.getVariants().size() > 0) continue;
            cldr.add(locale.replace('_', '-'));
        }
        TreeSet<String> tex = new TreeSet<String>();
        while ((line = in.readLine()) != null) {
            if ((line = line.trim()).length() == 0) continue;
            int p = line.indexOf(32);
            tex.add(line.substring(0, p));
        }
        TreeSet inCldrButNotTex = new TreeSet(cldr);
        inCldrButNotTex.removeAll(tex);
        System.out.println(" inCldrButNotTex " + inCldrButNotTex);
        TreeSet inTexButNotCLDR = new TreeSet(tex);
        inTexButNotCLDR.removeAll(cldr);
        System.out.println(" inTexButNotCLDR " + inTexButNotCLDR);
    }

    void generateTransliterators() throws IOException {
        File translitSource = new File("C:\\ICU\\icu\\source\\data\\translit");
        Matcher m = Pattern.compile(".*Hebrew.*").matcher("");
        File[] list = translitSource.listFiles();
        for (int i = 0; i < list.length; ++i) {
            File file = list[i];
            String name = file.getName();
            if (!m.reset(name).matches() || !name.endsWith(".txt")) continue;
            String fixedName = name.substring(name.length() - 4);
            BufferedReader input = BagFormatter.openUTF8Reader((String)(file.getParent() + File.pathSeparator), (String)name);
            CLDRFile outFile = new CLDRFile(null, false);
            int count = 0;
            while (true) {
                String line;
                String contents = line = input.readLine();
                if (line == null) break;
                if (line.length() == 0) continue;
                outFile.add("//supplementalData/transforms/transform/line[@_q=\"" + ++count + "\"]", line);
            }
            PrintWriter pw = BagFormatter.openUTF8Writer((String)"../../dropbox/gen//translit/", (String)(fixedName + ".xml"));
            outFile.write(pw);
            pw.close();
        }
    }

    static {
        options = new UOption[]{UOption.HELP_H(), UOption.HELP_QUESTION_MARK(), UOption.SOURCEDIR().setDefault("../../common/"), UOption.DESTDIR().setDefault("../../dropbox/gen/timezones/"), UOption.create((String)"match", (char)'m', (int)1).setDefault(".*"), UOption.create((String)"to_localize", (char)'t', (int)0), UOption.create((String)"current", (char)'c', (int)0), UOption.create((String)"windows", (char)'w', (int)0), UOption.create((String)"obsoletes", (char)'o', (int)0), UOption.create((String)"aliases", (char)'a', (int)0), UOption.create((String)"info", (char)'i', (int)0), UOption.create((String)"zones", (char)'z', (int)0), UOption.create((String)"langauge-tags", (char)'l', (int)0)};
        HELP_TEXT = "Use the following options\n-h or -?\tfor this message\n-" + Misc.options[2].shortName + "\tsource directory. Default = " + Utility.getCanonicalName("../../common/main/") + "\n" + "-" + Misc.options[3].shortName + "\tdestination directory. Default = " + Utility.getCanonicalName("../../dropbox/gen/main/") + "\n" + "-m<regex>\tto restrict the locales to what matches <regex>" + "\n" + "-t\tgenerates files that contain items missing localizations" + "\n" + "-c\tgenerates missing timezone localizations" + "\n" + "-w\tgenerates Windows timezone IDs" + "\n" + "-o\tlist display codes that are obsolete" + "\n" + "-o\tshows timezone aliases" + "-i\tgets element/attribute/value information" + "-z\tcollected timezone localizations";
        priorities = new TreeSet<String>(Arrays.asList("en", "zh_Hans", "zh_Hant", "da", "nl", "fi", "fr", "de", "it", "ja", "ko", "nb", "pt_BR", "ru", "es", "sv", "ar", "bg", "ca", "hr", "cs", "et", "el", "he", "hi", "hu", "is", "id", "lv", "lt", "pl", "ro", "sr", "sk", "sl", "tl", "th", "tr", "uk", "ur", "vi"));
        JAN152006 = new Date(106, 0, 15, 0, 0, 0).getTime();
        JUNE152006 = new Date(106, 5, 15, 0, 0, 0).getTime();
        hours = new DecimalFormat("0.##");
        ZONE_MAP = new String[]{"Etc/GMT+12", "Dateline", "S (GMT-12:00) International Date Line West", "Pacific/Apia", "Samoa", "S (GMT-11:00) Midway Island, Samoa", "Pacific/Honolulu", "Hawaiian", "S (GMT-10:00) Hawaii", "America/Anchorage", "Alaskan", "D (GMT-09:00) Alaska", "America/Los_Angeles", "Pacific", "D (GMT-08:00) Pacific Time (US & Canada); Tijuana", "America/Phoenix", "US Mountain", "S (GMT-07:00) Arizona", "America/Denver", "Mountain", "D (GMT-07:00) Mountain Time (US & Canada)", "America/Chihuahua", "Mexico Standard Time 2", "D (GMT-07:00) Chihuahua, La Paz, Mazatlan", "America/Managua", "Central America", "S (GMT-06:00) Central America", "America/Regina", "Canada Central", "S (GMT-06:00) Saskatchewan", "America/Mexico_City", "Mexico", "D (GMT-06:00) Guadalajara, Mexico City, Monterrey", "America/Chicago", "Central", "D (GMT-06:00) Central Time (US & Canada)", "America/Indianapolis", "US Eastern", "S (GMT-05:00) Indiana (East)", "America/Bogota", "SA Pacific", "S (GMT-05:00) Bogota, Lima, Quito", "America/New_York", "Eastern", "D (GMT-05:00) Eastern Time (US & Canada)", "America/Caracas", "SA Western", "S (GMT-04:00) Caracas, La Paz", "America/Santiago", "Pacific SA", "D (GMT-04:00) Santiago", "America/Halifax", "Atlantic", "D (GMT-04:00) Atlantic Time (Canada)", "America/St_Johns", "Newfoundland", "D (GMT-03:30) Newfoundland", "America/Buenos_Aires", "SA Eastern", "S (GMT-03:00) Buenos Aires, Georgetown", "America/Godthab", "Greenland", "D (GMT-03:00) Greenland", "America/Sao_Paulo", "E. South America", "D (GMT-03:00) Brasilia", "America/Noronha", "Mid-Atlantic", "D (GMT-02:00) Mid-Atlantic", "Atlantic/Cape_Verde", "Cape Verde", "S (GMT-01:00) Cape Verde Is.", "Atlantic/Azores", "Azores", "D (GMT-01:00) Azores", "Africa/Casablanca", "Greenwich", "S (GMT) Casablanca, Monrovia", "Europe/London", "GMT", "D (GMT) Greenwich Mean Time : Dublin, Edinburgh, Lisbon, London", "Africa/Lagos", "W. Central Africa", "S (GMT+01:00) West Central Africa", "Europe/Berlin", "W. Europe", "D (GMT+01:00) Amsterdam, Berlin, Bern, Rome, Stockholm, Vienna", "Europe/Paris", "Romance", "D (GMT+01:00) Brussels, Copenhagen, Madrid, Paris", "Europe/Sarajevo", "Central European", "D (GMT+01:00) Sarajevo, Skopje, Warsaw, Zagreb", "Europe/Belgrade", "Central Europe", "D (GMT+01:00) Belgrade, Bratislava, Budapest, Ljubljana, Prague", "Africa/Johannesburg", "South Africa", "S (GMT+02:00) Harare, Pretoria", "Asia/Jerusalem", "Israel", "S (GMT+02:00) Jerusalem", "Europe/Istanbul", "GTB", "D (GMT+02:00) Athens, Istanbul, Minsk", "Europe/Helsinki", "FLE", "D (GMT+02:00) Helsinki, Kyiv, Riga, Sofia, Tallinn, Vilnius", "Africa/Cairo", "Egypt", "D (GMT+02:00) Cairo", "Europe/Bucharest", "E. Europe", "D (GMT+02:00) Bucharest", "Africa/Nairobi", "E. Africa", "S (GMT+03:00) Nairobi", "Asia/Riyadh", "Arab", "S (GMT+03:00) Kuwait, Riyadh", "Europe/Moscow", "Russian", "D (GMT+03:00) Moscow, St. Petersburg, Volgograd", "Asia/Baghdad", "Arabic", "D (GMT+03:00) Baghdad", "Asia/Tehran", "Iran", "D (GMT+03:30) Tehran", "Asia/Muscat", "Arabian", "S (GMT+04:00) Abu Dhabi, Muscat", "Asia/Tbilisi", "Caucasus", "D (GMT+04:00) Baku, Tbilisi, Yerevan", "Asia/Kabul", "Afghanistan", "S (GMT+04:30) Kabul", "Asia/Karachi", "West Asia", "S (GMT+05:00) Islamabad, Karachi, Tashkent", "Asia/Yekaterinburg", "Ekaterinburg", "D (GMT+05:00) Ekaterinburg", "Asia/Calcutta", "India", "S (GMT+05:30) Chennai, Kolkata, Mumbai, New Delhi", "Asia/Katmandu", "Nepal", "S (GMT+05:45) Kathmandu", "Asia/Colombo", "Sri Lanka", "S (GMT+06:00) Sri Jayawardenepura", "Asia/Dhaka", "Central Asia", "S (GMT+06:00) Astana, Dhaka", "Asia/Novosibirsk", "N. Central Asia", "D (GMT+06:00) Almaty, Novosibirsk", "Asia/Rangoon", "Myanmar", "S (GMT+06:30) Rangoon", "Asia/Bangkok", "SE Asia", "S (GMT+07:00) Bangkok, Hanoi, Jakarta", "Asia/Krasnoyarsk", "North Asia", "D (GMT+07:00) Krasnoyarsk", "Australia/Perth", "W. Australia", "S (GMT+08:00) Perth", "Asia/Taipei", "Taipei", "S (GMT+08:00) Taipei", "Asia/Singapore", "Singapore", "S (GMT+08:00) Kuala Lumpur, Singapore", "Asia/Hong_Kong", "China", "S (GMT+08:00) Beijing, Chongqing, Hong Kong, Urumqi", "Asia/Irkutsk", "North Asia East", "D (GMT+08:00) Irkutsk, Ulaan Bataar", "Asia/Tokyo", "Tokyo", "S (GMT+09:00) Osaka, Sapporo, Tokyo", "Asia/Seoul", "Korea", "S (GMT+09:00) Seoul", "Asia/Yakutsk", "Yakutsk", "D (GMT+09:00) Yakutsk", "Australia/Darwin", "AUS Central", "S (GMT+09:30) Darwin", "Australia/Adelaide", "Cen. Australia", "D (GMT+09:30) Adelaide", "Pacific/Guam", "West Pacific", "S (GMT+10:00) Guam, Port Moresby", "Australia/Brisbane", "E. Australia", "S (GMT+10:00) Brisbane", "Asia/Vladivostok", "Vladivostok", "D (GMT+10:00) Vladivostok", "Australia/Hobart", "Tasmania", "D (GMT+10:00) Hobart", "Australia/Sydney", "AUS Eastern", "D (GMT+10:00) Canberra, Melbourne, Sydney", "Asia/Magadan", "Central Pacific", "S (GMT+11:00) Magadan, Solomon Is., New Caledonia", "Pacific/Fiji", "Fiji", "S (GMT+12:00) Fiji, Kamchatka, Marshall Is.", "Pacific/Auckland", "New Zealand", "D (GMT+12:00) Auckland, Wellington", "Pacific/Tongatapu", "Tonga", "S (GMT+13:00) Nuku'alofa"};
        langTag = new Utility.VariableReplacer().add("$alpha", "[a-zA-Z]").add("$digit", "[0-9]").add("$alphanum", "[a-zA-Z0-9]").add("$x", "[xX]").add("$grandfathered", "en-GB-oed|i-(?:ami|bnn|default|enochian|hak|klingon|lux|mingo|navajo|pwn|tao|tay|tsu)|no-(?:bok|nyn)|sgn-(?:BE-(?:fr|nl)|CH-de)|zh-(?:gan|min(?:-nan)?|wuu|yue)").add("$lang", "$alpha{2,8}").add("$extlang", "(?:-$alpha{3})").add("$script", "(?:-$alpha{4})").add("$region", "(?:-$alpha{2}|-$digit{3})").add("$variant", "(?:-$digit$alphanum{3}|-$alphanum{5,8})").add("$extension", "(?:-[$alphanum&&[^xX]](?:-$alphanum{2,8})+)").add("$privateuse", "(?:$x(?:-$alphanum{1,8})+)").add("$privateuse2", "(?:-$privateuse)");
        langTagPattern = langTag.replace("($lang)\r\n\t($extlang{0,3})\r\n\t($script?)\r\n\t($region?)\r\n\t($variant*)\r\n\t($extension*)\r\n\t($privateuse2?)\r\n|($grandfathered)\r\n|($privateuse)");
        cleanedLangTagPattern = langTagPattern.replaceAll("[\\r\\t\\n\\s]", "");
        regexLanguageTagOld = Pattern.compile(cleanedLangTagPattern).matcher("");
        groupNames = new String[]{"whole", "lang", "script", "region", "variants", "extensions", "privateuse", "grandfathered", "privateuse"};
        COUNTRY_CORRECTIONS = new String[]{"Antigua & Barbuda", "Antigua and Barbuda", "Bosnia-Herzegovina", "Bosnia and Herzegovina", "British Virgin Islands", "Virgin Islands, British", "Brunei", "Brunei Darussalam", "Central Africa", "Central African Republic", "Congo (Dem. Rep.)", "Congo, The Democratic Republic of the", "East Timor", "Timor-Leste", "External Territories of Australia", "Australia", "Falkland Islands and dependencies", "Falkland Islands (Malvinas)", "Guernsey and Alderney", "United Kingdom", "Guinea Bissau", "Guinea-Bissau", "Iran", "Iran, Islamic Republic of", "Ivory Coast", "Cote d'Ivoire", "Jersey", "United Kingdom", "Korea (North)", "Korea, Democratic People's Republic of", "Korea (South)", "Korea, Republic of", "Laos", "Lao People's Democratic Republic", "Libya", "Libyan Arab Jamahiriya", "Macedonia", "Macedonia, The Former Yugoslav Republic of", "Man (Isle of)", "United Kingdom", "Moldova", "Moldova, Republic of", "Norfolk", "Norfolk Island", "Palestine", "Palestinian Territory, Occupied", "Russia", "Russian Federation", "R\u9d6eion", "Reunion", "Sahara", "Western Sahara", "Saint Pierre & Miquelon", "Saint Pierre and Miquelon", "Smaller Territories of the UK", "United Kingdom", "Syria", "Syrian Arab Republic", "S\u3be0Tom\u9821nd Pr\udba3ipe", "Sao Tome and Principe", "Taiwan", "Taiwan, Province of China", "Tanzania", "Tanzania, United Republic of", "Terres Australes", "French Polynesia", "United States of America", "United States", "Vatican", "Holy See (Vatican City State)", "Vietnam", "Viet Nam", "Virgin Islands of the United States", "Virgin Islands, U.S.", "Wallis & Futuna", "Wallis and Futuna"};
        corrections = new HashMap();
        for (int i = 0; i < COUNTRY_CORRECTIONS.length; i += 2) {
            corrections.put(COUNTRY_CORRECTIONS[i], COUNTRY_CORRECTIONS[i + 1]);
        }
        levelNames = new String[]{"world", "continent", "subcontinent", "country", "subzone"};
    }

    static class BNFData {
        private String rules;
        private String generationRules;
        private Pattern pattern;
        private BNF bnf;

        BNFData() {
        }

        public BNFData setFromFile(String filename) throws IOException {
            String line;
            BufferedReader in = BagFormatter.openUTF8Reader((String)"", (String)filename);
            Utility.VariableReplacer result = new Utility.VariableReplacer();
            String variable = null;
            StringBuffer definition = new StringBuffer();
            StringBuffer ruleBuffer = new StringBuffer();
            StringBuffer generationRuleBuffer = new StringBuffer();
            int count = 1;
            while ((line = in.readLine()) != null) {
                ruleBuffer.append(line).append("\r\n");
                if (line.length() != 0) {
                    int hashPos;
                    if (line.charAt(0) == '\ufeff') {
                        line = line.substring(1);
                    }
                    if ((hashPos = line.indexOf(35)) >= 0) {
                        line = line.substring(0, hashPos);
                    }
                    if ((line = line.trim()).length() != 0) {
                        generationRuleBuffer.append(line).append("\r\n");
                        String[] lineParts = line.split(";");
                        for (int i = 0; i < lineParts.length; ++i) {
                            String linePart = lineParts[i].trim();
                            if (linePart.length() == 0) continue;
                            int equalsPos = linePart.indexOf(61);
                            if (equalsPos >= 0) {
                                if (variable != null) {
                                    throw new IllegalArgumentException("Missing ';' before " + count + ") " + line);
                                }
                                variable = linePart.substring(0, equalsPos).trim();
                                definition.append(linePart.substring(equalsPos + 1).trim());
                            } else {
                                if (variable == null) {
                                    throw new IllegalArgumentException("Missing ':=' at " + count + ") " + line);
                                }
                                definition.append(linePart);
                            }
                            if (i >= lineParts.length - 1 && !line.endsWith(";")) continue;
                            result.add(variable, result.replace(definition.toString()));
                            variable = null;
                            definition.setLength(0);
                        }
                    }
                }
                ++count;
            }
            if (variable != null) {
                throw new IllegalArgumentException("Missing ';' at end");
            }
            String resolved = result.replace("$root").replaceAll("[0-9]+%", "");
            System.out.println("Regex: " + resolved);
            this.rules = ruleBuffer.toString();
            this.generationRules = generationRuleBuffer.toString().replaceAll("\\?:", "").replaceAll("\\(\\?i\\)", "");
            this.pattern = Pattern.compile(resolved, 4);
            return this;
        }

        public BNF getBnf() {
            if (this.bnf != null) {
                return this.bnf;
            }
            this.bnf = new BNF(new Random(2L), (Quoter)new Quoter.RuleQuoter()).setMaxRepeat(5).addRules(this.generationRules).complete();
            return this.bnf;
        }

        public Pattern getPattern() {
            return this.pattern;
        }

        public String getRules() {
            return this.rules;
        }

        public String getGenerationRules() {
            return this.generationRules;
        }
    }
}

