/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.ibm.icu.dev.test.util.ArrayComparator;
import com.ibm.icu.dev.test.util.BagFormatter;
import com.ibm.icu.dev.test.util.FileUtilities;
import com.ibm.icu.dev.test.util.TransliteratorUtilities;
import com.ibm.icu.impl.CollectionUtilities;
import com.ibm.icu.impl.Utility;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.Collator;
import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.Normalizer;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.text.UnicodeSetIterator;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.Log;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.XPathParts;

public class ShowLanguages {
    static CLDRFile english;
    static Comparator col;
    static StandardCodes sc;
    private static List anchors;
    static DateFormat df;

    public static void main(String[] args) throws IOException {
        CLDRFile.Factory cldrFactory = CLDRFile.Factory.make("../../common/main/", ".*");
        english = cldrFactory.make("en", false);
        ShowLanguages.printLanguageData(cldrFactory, "index.html");
        System.out.println("Done");
    }

    private static void printLanguageData(CLDRFile.Factory cldrFactory, String filename) throws IOException {
        LanguageInfo linfo = new LanguageInfo(cldrFactory);
        linfo.showTerritoryInfo();
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        linfo.printCurrency(pw);
        PrintWriter pw1 = new PrintWriter(new FormattedFileWriter(pw, "Languages and Territories"));
        pw1.println("<tr><th>Language \u2192 Territories");
        pw1.println("</th><th>Territory \u2192 Language");
        pw1.println("</th><th>Territories Not Represented");
        pw1.println("</th><th>Languages Not Represented");
        pw1.println("</th></tr>");
        pw1.println("<tr><td>");
        linfo.print(pw1, 0, 2);
        pw1.println("</td><td>");
        linfo.print(pw1, 2, 0);
        pw1.println("</td><td>");
        linfo.printMissing(pw1, 2, 2);
        pw1.println("</td><td>");
        linfo.printMissing(pw1, 0, 2);
        pw1.println("</td></tr>");
        pw1.close();
        pw1 = new PrintWriter(new FormattedFileWriter(pw, "Languages and Scripts"));
        pw1.println("<tr><th>Language \u2192 Scripts");
        pw1.println("</th><th>Script  \u2192 Language");
        pw1.println("</th><th>Territories Not Represented");
        pw1.println("</th><th>Languages Not Represented");
        pw1.println("</th></tr>");
        pw1.println("<tr><td >");
        linfo.print(pw1, 0, 1);
        pw1.println("</td><td>");
        linfo.print(pw1, 1, 0);
        pw1.println("</td><td>");
        linfo.printMissing(pw1, 1, 1);
        pw1.println("</td><td>");
        linfo.printMissing(pw1, 0, 1);
        pw1.println("</td></tr>");
        pw1.close();
        linfo.showCorrespondances();
        linfo.showCalendarData(pw);
        linfo.printContains(pw);
        linfo.printWindows_Tzid(pw);
        linfo.printCharacters(pw);
        linfo.printAliases(pw);
        pw.close();
        String contents = "<ul>";
        Iterator it = anchors.iterator();
        while (it.hasNext()) {
            String item = (String)it.next();
            contents = contents + "<li>" + item + "</li>";
        }
        contents = contents + "</ul>";
        String[] replacements = new String[]{"%date%", df.format(new Date()), "%contents%", contents, "%data%", sw.toString()};
        PrintWriter pw2 = BagFormatter.openUTF8Writer((String)"../../common/../diff/supplemental/", (String)filename);
        FileUtilities.appendFile((String)"org/unicode/cldr/tool/supplemental.html", (String)"utf-8", (PrintWriter)pw2, (String[])replacements);
        pw2.close();
    }

    private static Map getInverse(Map language_territories) {
        TreeMap territory_languages = new TreeMap();
        Iterator it = language_territories.keySet().iterator();
        while (it.hasNext()) {
            Object language = it.next();
            Set territories = (Set)language_territories.get(language);
            Iterator it2 = territories.iterator();
            while (it2.hasNext()) {
                Object territory = it2.next();
                TreeSet languages = (TreeSet)territory_languages.get(territory);
                if (languages == null) {
                    languages = new TreeSet(col);
                    territory_languages.put(territory, languages);
                }
                languages.add(language);
            }
        }
        return territory_languages;
    }

    private static void addTokens(String key, String values, String value_delimiter, Map key_value) {
        if (values != null) {
            TreeSet<String> s = (TreeSet<String>)key_value.get(key);
            if (s == null) {
                s = new TreeSet<String>(col);
                key_value.put(key, s);
            }
            s.addAll(Arrays.asList(values.split(value_delimiter)));
        }
    }

    static {
        col = new CollectionUtilities.MultiComparator(new Comparator[]{Collator.getInstance((ULocale)new ULocale("en")), new UTF16.StringComparator(true, false, 0)});
        sc = StandardCodes.make();
        anchors = new ArrayList();
        df = new SimpleDateFormat("yyyy-MM-dd HH:mm 'GMT'");
        df.setTimeZone(TimeZone.getTimeZone((String)"GMT"));
    }

    static class LanguageInfo {
        Map language_scripts = new TreeMap();
        Map language_territories = new TreeMap();
        Map windows_tzid = new TreeMap();
        List deprecatedItems = new ArrayList();
        Map territory_languages;
        Map script_languages;
        Map group_contains = new TreeMap();
        Set aliases = new TreeSet(new ArrayComparator(new Comparator[]{new UTF16.StringComparator(), col}));
        Comparator col3 = new ArrayComparator(new Comparator[]{col, col, col});
        Map currency_fractions = new TreeMap(col);
        Map currency_territory = new TreeMap(col);
        Map territory_currency = new TreeMap(col);
        Set territoriesWithCurrencies = new TreeSet();
        Set currenciesWithTerritories = new TreeSet();
        Map territoryData = new TreeMap();
        Set territoryTypes = new TreeSet();
        Map charSubstitutions = new TreeMap(col);
        String defaultDigits = null;
        Comparator territoryNameComparator = new Comparator(this){
            private final /* synthetic */ LanguageInfo this$0;
            {
                this.this$0 = this$0;
            }

            public int compare(Object o1, Object o2) {
                return col.compare(LanguageInfo.access$300(this.this$0, 2, (String)o1, false), LanguageInfo.access$300(this.this$0, 2, (String)o2, false));
            }
        };

        public LanguageInfo(CLDRFile.Factory cldrFactory) throws IOException {
            CLDRFile supp = cldrFactory.make("supplementalData", false);
            XPathParts parts = new XPathParts((Comparator)new UTF16.StringComparator(), null);
            Iterator it = supp.iterator();
            while (it.hasNext()) {
                Map attributes;
                String element;
                String type;
                Map attributes2;
                String path = (String)it.next();
                parts.set(supp.getFullXPath(path));
                if (path.indexOf("/territoryContainment") >= 0) {
                    attributes2 = parts.findAttributes("group");
                    type = (String)attributes2.get("type");
                    ShowLanguages.addTokens(type, (String)attributes2.get("contains"), " ", this.group_contains);
                    continue;
                }
                if (path.indexOf("/zoneItem") >= 0) {
                    attributes2 = parts.getAttributes(parts.size() - 1);
                    type = (String)attributes2.get("type");
                    String territory = (String)attributes2.get("territory");
                    String aliasAttributes = (String)attributes2.get("aliases");
                    if (aliasAttributes == null) continue;
                    String[] aliasesList = aliasAttributes.split("\\s+");
                    for (int i = 0; i < aliasesList.length; ++i) {
                        String alias = aliasesList[i];
                        this.aliases.add(new String[]{"timezone", alias, type});
                    }
                    continue;
                }
                if (path.indexOf("/currencyData") >= 0) {
                    String iso4217;
                    if (path.indexOf("/fractions") >= 0) {
                        element = parts.getElement(parts.size() - 1);
                        if (!element.equals("info")) {
                            throw new IllegalArgumentException("Unexpected fractions element: " + element);
                        }
                        attributes = parts.getAttributes(parts.size() - 1);
                        iso4217 = (String)attributes.get("iso4217");
                        String digits = (String)attributes.get("digits");
                        String rounding = (String)attributes.get("rounding");
                        digits = digits + (rounding.equals("0") ? "" : " (" + rounding + ")");
                        if (iso4217.equals("DEFAULT")) {
                            this.defaultDigits = digits;
                            continue;
                        }
                        this.currency_fractions.put(this.getName(4, iso4217, false), digits);
                        continue;
                    }
                    if (path.indexOf("/region") >= 0) {
                        String from;
                        attributes2 = parts.getAttributes(parts.size() - 2);
                        String iso3166 = (String)attributes2.get("iso3166");
                        attributes2 = parts.getAttributes(parts.size() - 1);
                        iso4217 = (String)attributes2.get("iso4217");
                        String to = (String)attributes2.get("to");
                        if (to == null) {
                            to = "\u221e";
                        }
                        if ((from = (String)attributes2.get("from")) == null) {
                            from = "-\u221e";
                        }
                        String countryName = this.getName(2, iso3166, false);
                        String currencyName = this.getName(4, iso4217, false);
                        Set<String> info = (TreeSet<String[]>)this.territory_currency.get(countryName);
                        if (info == null) {
                            info = new TreeSet<String[]>(this.col3);
                            this.territory_currency.put(countryName, info);
                        }
                        info.add((String)new String[]{from, to, currencyName});
                        info = (Set)this.currency_territory.get(currencyName);
                        if (info == null) {
                            info = new TreeSet(col);
                            this.currency_territory.put(currencyName, info);
                        }
                        info.add(countryName);
                        this.territoriesWithCurrencies.add(iso3166);
                        this.currenciesWithTerritories.add(iso4217);
                        continue;
                    }
                }
                if (path.indexOf("/languageData") >= 0) {
                    attributes2 = parts.findAttributes("language");
                    String language = (String)attributes2.get("type");
                    String alt = (String)attributes2.get("alt");
                    ShowLanguages.addTokens(language, (String)attributes2.get("scripts"), " ", this.language_scripts);
                    if (alt != null) {
                        language = "secondary".equals(alt) ? language + "*" : language + "*" + alt;
                    }
                    ShowLanguages.addTokens(language, (String)attributes2.get("territories"), " ", this.language_territories);
                    continue;
                }
                if (path.indexOf("/mapTimezones") >= 0) {
                    attributes2 = parts.findAttributes("mapZone");
                    String tzid = (String)attributes2.get("type");
                    String other = (String)attributes2.get("other");
                    this.windows_tzid.put(other, tzid);
                    continue;
                }
                if (path.indexOf("/deprecatedItems") >= 0) {
                    this.deprecatedItems.add(parts.findAttributes("deprecatedItems"));
                    continue;
                }
                if (path.indexOf("/calendarData") >= 0) {
                    attributes2 = parts.findAttributes("calendar");
                    type = (String)attributes2.get("type");
                    String territories = (String)attributes2.get("territories");
                    this.addTerritoryInfo(territories, "calendar", type);
                }
                if (path.indexOf("/weekData") >= 0 || path.indexOf("measurementData") >= 0) {
                    element = parts.getElement(parts.size() - 1);
                    attributes = parts.getAttributes(parts.size() - 1);
                    String key = "count";
                    String display = "days in week (min)";
                    if (element.equals("firstDay")) {
                        key = "day";
                        display = "first day of week";
                    } else if (element.equals("weekendStart")) {
                        key = "day";
                        display = "first day of weekend";
                    } else if (element.equals("weekendEnd")) {
                        key = "day";
                        display = "last day of weekend";
                    } else if (element.equals("measurementSystem")) {
                        key = "type";
                        display = "measurement system";
                    } else if (element.equals("paperSize")) {
                        key = "type";
                        display = "paper size";
                    }
                    String type2 = (String)attributes.get(key);
                    String territories = (String)attributes.get("territories");
                    this.addTerritoryInfo(territories, display, type2);
                }
                if (path.indexOf("/generation") >= 0 || path.indexOf("/version") >= 0) continue;
                System.out.println("Skipped Element: " + path);
            }
            this.territory_languages = ShowLanguages.getInverse(this.language_territories);
            this.script_languages = ShowLanguages.getInverse(this.language_scripts);
            CLDRFile supp2 = cldrFactory.make("supplementalMetadata", false);
            Iterator it2 = supp2.iterator();
            while (it2.hasNext()) {
                String path = (String)it2.next();
                parts.set(supp2.getFullXPath(path));
                if (path.indexOf("/alias") >= 0) {
                    String element = parts.getElement(parts.size() - 1);
                    Map attributes = parts.getAttributes(parts.size() - 1);
                    String type = (String)attributes.get("type");
                    if (!element.endsWith("Alias")) {
                        throw new IllegalArgumentException("Unexpected alias element: " + element);
                    }
                    element = element.substring(0, element.length() - 5);
                    String replacement = (String)attributes.get("replacement");
                    String name = "";
                    if (replacement == null) {
                        name = "(none)";
                    } else if (element.equals("language")) {
                        name = this.getName(replacement, false);
                    } else if (element.equals("zone")) {
                        element = "timezone";
                        name = replacement + "*";
                    } else {
                        int typeCode = CLDRFile.typeNameToCode(element);
                        name = typeCode >= 0 ? this.getName(typeCode, replacement, false) : "*" + replacement;
                    }
                    this.aliases.add(new String[]{element, type, name});
                    continue;
                }
                if (path.indexOf("/generation") >= 0 || path.indexOf("/version") >= 0) continue;
                System.out.println("Skipped Element: " + path);
            }
            Log.setLog("characterLog.txt");
            CLDRFile chars = cldrFactory.make("characters", false);
            int count = 0;
            Iterator it3 = chars.iterator("", CLDRFile.ldmlComparator);
            while (it3.hasNext()) {
                String path = (String)it3.next();
                parts.set(chars.getFullXPath(path));
                if (parts.getElement(1).equals("version") || parts.getElement(1).equals("generation")) continue;
                String value = parts.getAttributeValue(-2, "value");
                String substitute = chars.getStringValue(path, true);
                this.addCharSubstitution(value, substitute);
            }
            if (count != 0) {
                System.out.println("Skipped NFKC/NFC items: " + count);
            }
            Log.close();
        }

        private void addCharSubstitution(String value, String substitute) {
            if (substitute.equals(value)) {
                return;
            }
            LinkedHashSet<String> already = (LinkedHashSet<String>)this.charSubstitutions.get(value);
            if (already == null) {
                already = new LinkedHashSet<String>(0);
                this.charSubstitutions.put(value, already);
            }
            already.add(substitute);
            Log.logln(LanguageInfo.hex(value, " ") + "; " + LanguageInfo.hex(substitute, " "));
        }

        public void showTerritoryInfo() {
            TreeMap territory_parent = new TreeMap();
            this.gather("001", territory_parent);
            Iterator it = territory_parent.keySet().iterator();
            while (it.hasNext()) {
                String territory = (String)it.next();
                String parent = (String)territory_parent.get(territory);
                System.out.println(territory + "\t" + english.getName(2, territory, false) + "\t" + parent + "\t" + english.getName(2, parent, false));
            }
        }

        private void gather(String item, Map territory_parent) {
            Collection containedByItem = (Collection)this.group_contains.get(item);
            if (containedByItem == null) {
                return;
            }
            Iterator it = containedByItem.iterator();
            while (it.hasNext()) {
                String contained = (String)it.next();
                territory_parent.put(contained, item);
                this.gather(contained, territory_parent);
            }
        }

        private void addTerritoryInfo(String territoriesList, String type, String info) {
            String[] territories = territoriesList.split("\\s+");
            this.territoryTypes.add(type);
            for (int i = 0; i < territories.length; ++i) {
                TreeSet<String> ss;
                String territory = this.getName(2, territories[i], false);
                TreeMap<String, TreeSet<String>> s = (TreeMap<String, TreeSet<String>>)this.territoryData.get(territory);
                if (s == null) {
                    s = new TreeMap<String, TreeSet<String>>();
                    this.territoryData.put(territory, s);
                }
                if ((ss = (TreeSet<String>)s.get(type)) == null) {
                    ss = new TreeSet<String>();
                    s.put(type, ss);
                }
                ss.add(info);
            }
        }

        public void showCalendarData(PrintWriter pw0) throws IOException {
            PrintWriter pw = new PrintWriter(new FormattedFileWriter(pw0, "Other Territory Data"));
            pw.println("<tr><th class='source'>Territory</th>");
            Iterator it = this.territoryTypes.iterator();
            while (it.hasNext()) {
                pw.println("<th class='target'>" + it.next() + "</th>");
            }
            pw.println("</tr>");
            String worldName = this.getName(2, "001", false);
            Map worldData = (Map)this.territoryData.get(worldName);
            Iterator it2 = this.territoryData.keySet().iterator();
            while (it2.hasNext()) {
                String country = (String)it2.next();
                if (country.equals(worldName)) continue;
                this.showCountry(pw, country, country, worldData);
            }
            this.showCountry(pw, worldName, "Other", worldData);
            pw.close();
        }

        private void showCountry(PrintWriter pw, String country, String countryTitle, Map worldData) {
            pw.println("<tr><td class='source'>" + countryTitle + "</td>");
            Map data = (Map)this.territoryData.get(country);
            Iterator it2 = this.territoryTypes.iterator();
            while (it2.hasNext()) {
                String type = (String)it2.next();
                String target = "target";
                Set results = (Set)data.get(type);
                Set worldResults = (Set)worldData.get(type);
                if (results == null) {
                    results = worldResults;
                    target = "target2";
                } else if (((Object)results).equals(worldResults)) {
                    target = "target2";
                }
                String out = "";
                if (results != null) {
                    out = results + "";
                    out = out.substring(1, out.length() - 1);
                }
                pw.println("<td class='" + target + "'>" + out + "</td>");
            }
            pw.println("</tr>");
        }

        public void showCorrespondances() {
            String names;
            String language;
            TreeMap<String, String> name_script = new TreeMap<String, String>();
            Iterator it = sc.getAvailableCodes("script").iterator();
            while (it.hasNext()) {
                String script = (String)it.next();
                String name = english.getName(1, script, false);
                if (name == null) {
                    name = script;
                }
                name_script.put(name, script);
            }
            String delimiter = "\\P{L}+";
            TreeMap<String, String> name_language = new TreeMap<String, String>();
            Iterator it2 = sc.getAvailableCodes("language").iterator();
            while (it2.hasNext()) {
                language = (String)it2.next();
                names = english.getName(0, language, false);
                if (names == null) {
                    names = language;
                }
                name_language.put(names, language);
            }
            it2 = sc.getAvailableCodes("language").iterator();
            while (it2.hasNext()) {
                String[] words;
                language = (String)it2.next();
                names = english.getName(0, language, false);
                if (names == null) {
                    names = language;
                }
                if ((words = names.split(delimiter)).length > 1) {
                    // empty if block
                }
                for (int i = 0; i < words.length; ++i) {
                    String name = words[i];
                    String script = (String)name_script.get(name);
                    if (script != null) {
                        Set langSet = (Set)this.script_languages.get(script);
                        if (langSet != null && langSet.contains(language)) {
                            System.out.print("*");
                        }
                        System.out.println("\t" + name + " [" + language + "]\t=> " + name + " [" + script + "]");
                        continue;
                    }
                    String language2 = (String)name_language.get(name);
                    if (language2 == null || language.equals(language2)) continue;
                    Set langSet = (Set)this.language_scripts.get(language);
                    if (langSet != null) {
                        System.out.print("*");
                    }
                    System.out.print("?\tSame script?\t + " + this.getName(0, language, false) + "\t & " + this.getName(0, language2, false));
                    langSet = (Set)this.language_scripts.get(language2);
                    if (langSet != null) {
                        System.out.print("*");
                    }
                    System.out.println();
                }
            }
        }

        public void printCurrency(PrintWriter index) throws IOException {
            PrintWriter pw = new PrintWriter(new FormattedFileWriter(index, "Territory \u2192 Currency"));
            pw.println("<tr><th class='source'>Territory</th><th class='target'>From</th><th class='target'>To</th><th class='target'>Currency</th></tr>");
            Iterator it = this.territory_currency.keySet().iterator();
            while (it.hasNext()) {
                String territory = (String)it.next();
                Set info = (Set)this.territory_currency.get(territory);
                pw.println("<tr><td class='source' rowSpan='" + info.size() + "'>" + territory + "</td>");
                boolean first = true;
                Iterator it2 = info.iterator();
                while (it2.hasNext()) {
                    String[] items = (String[])it2.next();
                    if (first) {
                        first = false;
                    } else {
                        pw.println("<tr>");
                    }
                    pw.println("<td class='target'>" + items[0] + "</td><td class='target'>" + items[1] + "</td><td class='target'>" + items[2] + "</td></tr>");
                }
            }
            pw.close();
            pw = new PrintWriter(new FormattedFileWriter(index, "Currency Format Info"));
            pw.println("<tr><th class='source'>Currency</th><th class='target'>Digits</th><th class='target'>Countries</th></tr>");
            TreeSet currencyList = new TreeSet(col);
            currencyList.addAll(this.currency_fractions.keySet());
            currencyList.addAll(this.currency_territory.keySet());
            Iterator it2 = currencyList.iterator();
            while (it2.hasNext()) {
                String currency = (String)it2.next();
                String fractions = (String)this.currency_fractions.get(currency);
                if (fractions == null) {
                    fractions = this.defaultDigits;
                }
                Set territories = (Set)this.currency_territory.get(currency);
                pw.print("<tr><td class='source'>" + currency + "</td><td class='target'>" + fractions + "</td><td class='target'>");
                if (territories != null) {
                    boolean first = true;
                    Iterator it22 = territories.iterator();
                    while (it22.hasNext()) {
                        if (first) {
                            first = false;
                        } else {
                            pw.print(", ");
                        }
                        pw.print(it22.next());
                    }
                }
                pw.println("</td></tr>");
            }
            pw.close();
        }

        public void printAliases(PrintWriter index) throws IOException {
            PrintWriter pw = new PrintWriter(new FormattedFileWriter(index, "Aliases"));
            pw.println("<tr><th class='source'>Type</th><th class='source'>Code</th><th class='target'>Substitute (if avail)</th></tr>");
            Iterator it = this.aliases.iterator();
            while (it.hasNext()) {
                String[] items = (String[])it.next();
                pw.println("<tr><td class='source'>" + items[0] + "</td><td class='source'>" + items[1] + "</td><td class='target'>" + items[2] + "</td></tr>");
            }
            pw.close();
        }

        public void printWindows_Tzid(PrintWriter index) throws IOException {
            PrintWriter pw = new PrintWriter(new FormattedFileWriter(index, "Windows \u2192 Tzid"));
            Iterator it = this.windows_tzid.keySet().iterator();
            while (it.hasNext()) {
                String source = (String)it.next();
                String target = (String)this.windows_tzid.get(source);
                pw.println("<tr><td class='source'>" + source + "</td><td class='target'>" + target + "</td></tr>");
            }
            pw.close();
        }

        public void printContains(PrintWriter index) throws IOException {
            String title = "Territory Containment (UN M.49)";
            PrintWriter pw = new PrintWriter(new FormattedFileWriter(index, title));
            this.printContains2(pw, "<tr>", "001", 0, true);
            pw.close();
        }

        public void printCharacters(PrintWriter index) throws IOException {
            String title = "Character Fallback Substitutions";
            PrintWriter pw = new PrintWriter(new FormattedFileWriter(index, title));
            pw.println("<tr><th colSpan='3'>Substitute for character (if not in repertoire)</th><th colSpan='4'>The following (in priority order, first string that <i>is</i> in repertoire)</th></tr>");
            UnicodeSet chars = new UnicodeSet("[:NFKC_QuickCheck=N:]");
            UnicodeSetIterator it = new UnicodeSetIterator(chars);
            while (it.next()) {
                String value = it.getString();
                this.addCharSubstitution(value, Normalizer.normalize((String)value, (Normalizer.Mode)Normalizer.NFC));
                this.addCharSubstitution(value, Normalizer.normalize((String)value, (Normalizer.Mode)Normalizer.NFKC));
            }
            int[] counts = new int[4];
            Iterator it2 = this.charSubstitutions.keySet().iterator();
            while (it2.hasNext()) {
                String value = (String)it2.next();
                LinkedHashSet substitutes = (LinkedHashSet)this.charSubstitutions.get(value);
                String nfc = Normalizer.normalize((String)value, (Normalizer.Mode)Normalizer.NFC);
                String nfkc = Normalizer.normalize((String)value, (Normalizer.Mode)Normalizer.NFKC);
                String sourceTag = "<td class='source'>";
                if (substitutes.size() > 1) {
                    sourceTag = "<td class='source' rowSpan='" + substitutes.size() + "'>";
                }
                boolean first = true;
                Iterator it22 = substitutes.iterator();
                while (it22.hasNext()) {
                    String substitute = (String)it22.next();
                    String type = "Explicit";
                    String targetTag = "<td class='target3'>";
                    if (substitute.equals(nfc)) {
                        type = "NFC";
                        targetTag = "<td class='target'>";
                        counts[2] = counts[2] + 1;
                    } else if (substitute.equals(nfkc)) {
                        type = "NFKC";
                        targetTag = "<td class='target4'>";
                        counts[3] = counts[3] + 1;
                    } else {
                        counts[0] = counts[0] + 1;
                    }
                    pw.println("<tr>" + (!first ? "" : sourceTag + LanguageInfo.hex(value, ", ") + "</td>" + sourceTag + TransliteratorUtilities.toHTML.transliterate(value) + "</td>" + sourceTag + UCharacter.getName((String)value, (String)", ") + "</td>") + targetTag + type + "</td>" + targetTag + LanguageInfo.hex(substitute, ", ") + "</td>" + targetTag + TransliteratorUtilities.toHTML.transliterate(substitute) + "</td>" + targetTag + UCharacter.getName((String)substitute, (String)", ") + "</td></tr>");
                    first = false;
                }
            }
            pw.close();
            for (int i = 0; i < counts.length; ++i) {
                System.out.println("Count\t" + i + "\t" + counts[i]);
            }
        }

        public static String hex(String s, String separator) {
            int cp;
            StringBuffer result = new StringBuffer();
            for (int i = 0; i < s.length(); i += UTF16.getCharCount((int)cp)) {
                cp = UTF16.charAt((String)s, (int)i);
                if (i != 0) {
                    result.append(separator);
                }
                result.append(Utility.hex((long)cp));
            }
            return result.toString();
        }

        public void printContains2(PrintWriter pw, String lead, String start, int depth, boolean isFirst) {
            Collection contains;
            String name;
            String string = name = depth == 4 ? start : this.getName(2, start, false);
            if (!isFirst) {
                pw.print(lead);
            }
            int count = this.getTotalContainedItems(start, depth);
            pw.print("<td class='z" + depth + "' rowSpan='" + count + "'>" + name + "</td>");
            if (depth == 4) {
                pw.println("</tr>");
            }
            if ((contains = this.getContainedCollection(start, depth)) != null) {
                TreeSet contains2 = new TreeSet(this.territoryNameComparator);
                contains2.addAll(contains);
                boolean first = true;
                Iterator it = contains2.iterator();
                while (it.hasNext()) {
                    String item = (String)it.next();
                    this.printContains2(pw, lead, item, depth + 1, first);
                    first = false;
                }
            }
        }

        private int getTotalContainedItems(String start, int depth) {
            Collection c = this.getContainedCollection(start, depth);
            if (c == null) {
                return 1;
            }
            int sum = 0;
            Iterator it = c.iterator();
            while (it.hasNext()) {
                sum += this.getTotalContainedItems((String)it.next(), depth + 1);
            }
            return sum;
        }

        private Collection getContainedCollection(String start, int depth) {
            TreeSet<String> contains = (TreeSet<String>)this.group_contains.get(start);
            if (contains == null && (contains = (Collection)sc.getCountryToZoneSet().get(start)) == null && depth == 3) {
                contains = new TreeSet<String>();
                if (start.compareTo("A") >= 0) {
                    contains.add("<font color='red'>MISSING TZID</font>");
                } else {
                    contains.add("<font color='red'>Not yet ISO code</font>");
                }
            }
            return contains;
        }

        public void printMissing(PrintWriter pw, int source, int table) {
            HashSet missingItems = new HashSet();
            String type = null;
            if (source == 2) {
                type = "territory";
                missingItems.addAll(sc.getAvailableCodes(type));
                missingItems.removeAll(this.territory_languages.keySet());
                missingItems.removeAll(this.group_contains.keySet());
                missingItems.remove("200");
            } else if (source == 1) {
                type = "script";
                missingItems.addAll(sc.getAvailableCodes(type));
                missingItems.removeAll(this.script_languages.keySet());
            } else if (source == 0) {
                type = "language";
                missingItems.addAll(sc.getAvailableCodes(type));
                if (table == 1) {
                    missingItems.removeAll(this.language_scripts.keySet());
                }
                if (table == 2) {
                    missingItems.removeAll(this.language_territories.keySet());
                }
            } else {
                throw new IllegalArgumentException("Illegal code");
            }
            TreeSet<String> missingItemsNamed = new TreeSet<String>(col);
            Iterator it = missingItems.iterator();
            while (it.hasNext()) {
                String item = (String)it.next();
                List data = sc.getFullData(type, item);
                if (data.get(0).equals("PRIVATE USE") || data.size() < 3 || !"".equals(data.get(2))) continue;
                String itemName = this.getName(source, item, true);
                missingItemsNamed.add(itemName);
            }
            pw.println("<div align='center'><table>");
            it = missingItemsNamed.iterator();
            while (it.hasNext()) {
                pw.println("<tr><td class='target'>" + it.next() + "</td></tr>");
            }
            pw.println("</table></div>");
        }

        public void print(PrintWriter pw, int source, int target) {
            Map data = source == 2 && target == 0 ? this.territory_languages : (source == 0 && target == 2 ? this.language_territories : (source == 1 && target == 0 ? this.script_languages : (source == 0 && target == 1 ? this.language_scripts : null)));
            TreeMap territory_languageNames = new TreeMap(col);
            Iterator it = data.keySet().iterator();
            while (it.hasNext()) {
                String territory = (String)it.next();
                String territoryName = this.getName(source, territory, true);
                TreeSet<String> s = (TreeSet<String>)territory_languageNames.get(territoryName);
                if (s == null) {
                    s = new TreeSet<String>(col);
                    territory_languageNames.put(territoryName, s);
                }
                Iterator it2 = ((Set)data.get(territory)).iterator();
                while (it2.hasNext()) {
                    String language = (String)it2.next();
                    String languageName = this.getName(target, language, true);
                    s.add(languageName);
                }
            }
            pw.println("<div align='center'><table>");
            it = territory_languageNames.keySet().iterator();
            while (it.hasNext()) {
                String territoryName = (String)it.next();
                pw.println("<tr><td class='source' colspan='2'>" + territoryName + "</td></tr>");
                Set s = (Set)territory_languageNames.get(territoryName);
                Iterator it2 = s.iterator();
                while (it2.hasNext()) {
                    String languageName = (String)it2.next();
                    pw.println("<tr><td>&nbsp;</td><td class='target'>" + languageName + "</td></tr>");
                }
            }
            pw.println("</table></div>");
        }

        private String getName(int type, String oldcode, boolean codeFirst) {
            int pos = oldcode.indexOf(42);
            String code = pos < 0 ? oldcode : oldcode.substring(0, pos);
            String ename = english.getName(type, code, false);
            return codeFirst ? "[" + oldcode + "]\t" + (ename == null ? code : ename) : (ename == null ? code : ename) + "\t[" + oldcode + "]";
        }

        private String getName(String locale, boolean codeFirst) {
            String ename = english.getName(locale, false);
            return codeFirst ? "[" + locale + "]\t" + (ename == null ? locale : ename) : (ename == null ? locale : ename) + "\t[" + locale + "]";
        }

        static /* synthetic */ String access$300(LanguageInfo x0, int x1, String x2, boolean x3) {
            return x0.getName(x1, x2, x3);
        }
    }

    static class FormattedFileWriter
    extends Writer {
        private StringWriter out = new StringWriter();
        private String title;
        private String filename;

        public FormattedFileWriter(PrintWriter indexFile, String title) throws IOException {
            String anchor = FileUtilities.anchorize((String)title);
            this.filename = anchor + ".html";
            this.title = title;
            anchors.add("<a name='" + FileUtilities.anchorize((String)this.getTitle()) + "' href='" + this.getFilename() + "'>" + this.getTitle() + "</a></caption>");
            this.out.write("<div align='center'><table>");
        }

        public String getFilename() {
            return this.filename;
        }

        public String getTitle() {
            return this.title;
        }

        public void close() throws IOException {
            this.out.write("</table></div>");
            PrintWriter pw2 = BagFormatter.openUTF8Writer((String)"../../common/../diff/supplemental/", (String)this.filename);
            String[] replacements = new String[]{"%header%", "", "%title%", this.title, "%version%", "1.4", "%date%", df.format(new Date()), "%body%", this.out.toString()};
            FileUtilities.appendFile((String)"org/unicode/cldr/tool/chart-template.html", (String)"utf-8", (PrintWriter)pw2, (String[])replacements);
            pw2.close();
        }

        public void write(char[] cbuf, int off, int len) throws IOException {
            this.out.write(cbuf, off, len);
        }

        public void flush() throws IOException {
            this.out.flush();
        }
    }
}

