/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.DateFormatSymbols;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.DecimalFormatSymbols;
import com.ibm.icu.text.MessageFormat;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.Currency;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.util.CLDRFile;

public class ICUServiceBuilder {
    public static Currency NO_CURRENCY = Currency.getInstance((String)"XXX");
    private CLDRFile cldrFile;
    private static TimeZone utc = TimeZone.getTimeZone((String)"GMT");
    private static DateFormat iso = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", ULocale.ENGLISH);
    private Map dateFormatCache = new HashMap();
    private Map numberFormatCache = new HashMap();
    private static int[] DateFormatValues;
    private static String[] DateFormatNames;
    public static int LIMIT_DATE_FORMAT_INDEX;
    private static final String[] Days;
    static final Matcher gregorianMonthsMatcher;
    private static String[] NumberNames;
    private static int firstReal;
    private static int firstCurrency;
    public static int LIMIT_NUMBER_INDEX;
    static int CURRENCY;
    static int OTHER_KEY;
    static int PATTERN;

    public static String isoDateFormat(Date date) {
        return iso.format(date);
    }

    public static String isoDateFormat(long value) {
        return iso.format(new Date(value));
    }

    public static Date isoDateParse(String date) throws ParseException {
        return iso.parse(date);
    }

    public static String getDateNames(int i) {
        return DateFormatNames[i];
    }

    public CLDRFile getCldrFile() {
        return this.cldrFile;
    }

    public ICUServiceBuilder setCldrFile(CLDRFile cldrFile) {
        this.cldrFile = cldrFile;
        this.dateFormatCache.clear();
        this.numberFormatCache.clear();
        return this;
    }

    public SimpleDateFormat getDateFormat(String calendar, int dateIndex, int timeIndex) {
        String key = this.cldrFile.getLocaleID() + "," + calendar + "," + dateIndex + "," + timeIndex;
        SimpleDateFormat result = (SimpleDateFormat)this.dateFormatCache.get(key);
        if (result != null) {
            return (SimpleDateFormat)result.clone();
        }
        String pattern = this.getPattern(calendar, dateIndex, timeIndex);
        result = this.getFullFormat(calendar, pattern);
        this.dateFormatCache.put(key, result);
        return result;
    }

    public SimpleDateFormat getDateFormat(String calendar, String pattern) {
        String key = this.cldrFile.getLocaleID() + "," + calendar + ",," + pattern;
        SimpleDateFormat result = (SimpleDateFormat)this.dateFormatCache.get(key);
        if (result != null) {
            return (SimpleDateFormat)result.clone();
        }
        result = this.getFullFormat(calendar, pattern);
        this.dateFormatCache.put(key, result);
        return result;
    }

    private SimpleDateFormat getFullFormat(String calendar, String pattern) {
        SimpleDateFormat gregorianBackup = null;
        boolean notGregorian = !calendar.equals("gregorian");
        SimpleDateFormat result = new SimpleDateFormat(pattern, new ULocale(this.cldrFile.getLocaleID()));
        Calendar cal = Calendar.getInstance((ULocale)new ULocale("en@calendar=" + calendar));
        cal.setTimeZone(utc);
        result.setCalendar(cal);
        String[] last = null;
        DateFormatSymbols formatData = new DateFormatSymbols();
        String prefix = "//ldml/dates/calendars/calendar[@type=\"" + calendar + "\"]/";
        last = new String[]{this.cldrFile.getStringValue(prefix + "am"), this.cldrFile.getStringValue(prefix + "pm")};
        formatData.setAmPmStrings(last);
        if (last[0] == null && notGregorian) {
            if (gregorianBackup == null) {
                gregorianBackup = this.getFullFormat("gregorian", pattern);
            }
            last = gregorianBackup.getDateFormatSymbols().getAmPmStrings();
            formatData.setAmPmStrings(last);
        }
        List temp = this.getArray(prefix + "eras/eraAbbr/era[@type=\"", 0, null, "\"]", 2);
        last = temp.toArray(new String[temp.size()]);
        formatData.setEras(last);
        if (temp.size() < 2 && notGregorian) {
            if (gregorianBackup == null) {
                gregorianBackup = this.getFullFormat("gregorian", pattern);
            }
            last = gregorianBackup.getDateFormatSymbols().getEras();
            formatData.setEras(last);
        }
        temp = this.getArray(prefix + "eras/eraNames/era[@type=\"", 0, null, "\"]", 2);
        last = temp.toArray(new String[temp.size()]);
        formatData.setEraNames(last);
        if (temp.size() < 2 && notGregorian) {
            if (gregorianBackup == null) {
                gregorianBackup = this.getFullFormat("gregorian", pattern);
            }
            last = gregorianBackup.getDateFormatSymbols().getEraNames();
            formatData.setEraNames(last);
        }
        last = this.getArray(prefix, "month", "format", "wide", null);
        formatData.setMonths(last, 0, 1);
        if (last == null && notGregorian) {
            if (gregorianBackup == null) {
                gregorianBackup = this.getFullFormat("gregorian", pattern);
            }
            last = gregorianBackup.getDateFormatSymbols().getMonths();
            formatData.setMonths(last);
        }
        last = this.getArray(prefix, "month", "format", "abbreviated", last);
        formatData.setMonths(last, 0, 0);
        last = this.getArray(prefix, "month", "format", "narrow", last);
        formatData.setMonths(last, 0, 2);
        last = this.getArray(prefix, "month", "stand-alone", "wide", last);
        formatData.setMonths(last, 1, 1);
        last = this.getArray(prefix, "month", "stand-alone", "abbreviated", last);
        formatData.setMonths(last, 1, 0);
        last = this.getArray(prefix, "month", "stand-alone", "narrow", last);
        formatData.setMonths(last, 1, 2);
        last = this.getArray(prefix, "day", "format", "wide", null);
        formatData.setWeekdays(last);
        if (last == null && notGregorian) {
            if (gregorianBackup == null) {
                gregorianBackup = this.getFullFormat("gregorian", pattern);
            }
            last = gregorianBackup.getDateFormatSymbols().getWeekdays();
            formatData.setWeekdays(last);
        }
        last = this.getArray(prefix, "day", "format", "abbreviated", last);
        formatData.setWeekdays(last, 0, 0);
        last = this.getArray(prefix, "day", "format", "narrow", last);
        formatData.setWeekdays(last, 0, 2);
        last = this.getArray(prefix, "day", "stand-alone", "wide", last);
        formatData.setWeekdays(last, 1, 1);
        last = this.getArray(prefix, "day", "stand-alone", "abbreviated", last);
        formatData.setWeekdays(last, 1, 0);
        last = this.getArray(prefix, "day", "stand-alone", "narrow", last);
        formatData.setWeekdays(last, 1, 2);
        result.setDateFormatSymbols(formatData);
        DecimalFormat numberFormat = this.getNumberFormat(1);
        numberFormat.setGroupingUsed(false);
        numberFormat.setDecimalSeparatorAlwaysShown(false);
        numberFormat.setParseIntegerOnly(true);
        numberFormat.setMinimumFractionDigits(0);
        result.setNumberFormat((NumberFormat)numberFormat.clone());
        return result;
    }

    private String getPattern(String calendar, int dateIndex, int timeIndex) {
        String pattern;
        if (DateFormatValues[timeIndex] == -1) {
            pattern = this.getDateTimePattern(calendar, "date", DateFormatNames[dateIndex]);
        } else if (DateFormatValues[dateIndex] == -1) {
            pattern = this.getDateTimePattern(calendar, "time", DateFormatNames[timeIndex]);
        } else {
            String p0 = this.getDateTimePattern(calendar, "time", DateFormatNames[timeIndex]);
            String p1 = this.getDateTimePattern(calendar, "date", DateFormatNames[dateIndex]);
            String datetimePat = this.getDateTimePattern(calendar, "dateTime", "");
            pattern = MessageFormat.format((String)datetimePat, (Object[])new String[]{p0, p1});
        }
        return pattern;
    }

    private String getDateTimePattern(String calendar, String dateOrTime, String type) {
        String key;
        String value;
        if (type.length() > 0) {
            type = "[@type=\"" + type + "\"]";
        }
        if ((value = this.cldrFile.getStringValue(key = "//ldml/dates/calendars/calendar[@type=\"" + calendar + "\"]/" + dateOrTime + "Formats/" + dateOrTime + "FormatLength" + type + "/" + dateOrTime + "Format[@type=\"standard\"]/pattern[@type=\"standard\"]")) == null) {
            throw new IllegalArgumentException("locale: " + this.cldrFile.getLocaleID() + "\tpath: " + key + "\r\nvalue: " + value);
        }
        return value;
    }

    private String[] getArray(String key, String type, String context, String width, String[] fallback) {
        String[] result;
        String prefix = key + type + "s/" + type + "Context[@type=\"" + context + "\"]/" + type + "Width[@type=\"" + width + "\"]/" + type + "[@type=\"";
        String postfix = "\"]";
        boolean isDay = type.equals("day");
        List temp = this.getArray(prefix, isDay ? 0 : 1, (String[])(isDay ? Days : null), postfix, isDay ? 7 : 12);
        if (isDay) {
            temp.add(0, "");
        }
        if ((result = temp.toArray(new String[temp.size()])).length == 0 && fallback != null) {
            result = (String[])fallback.clone();
        }
        return result;
    }

    private List getArray(String prefix, int firstIndex, String[] itemNames, String postfix, int minimumSize) {
        ArrayList<String> result = new ArrayList<String>();
        int i = firstIndex;
        while (true) {
            String lastType = itemNames != null && i < itemNames.length ? itemNames[i] : String.valueOf(i);
            String item = this.cldrFile.getStringValue(prefix + lastType + postfix);
            if (item == null) break;
            result.add(item);
            ++i;
        }
        return result;
    }

    public String getNumberNames(int i) {
        return NumberNames[i];
    }

    public DecimalFormat getCurrencyFormat(String currency) {
        return this._getNumberFormat(currency, CURRENCY);
    }

    public DecimalFormat getNumberFormat(int index) {
        return this._getNumberFormat(NumberNames[index], OTHER_KEY);
    }

    public DecimalFormat getNumberFormat(String pattern) {
        return this._getNumberFormat(pattern, PATTERN);
    }

    private DecimalFormat _getNumberFormat(String key1, int kind) {
        ULocale ulocale = new ULocale(this.cldrFile.getLocaleID());
        String key = ulocale + "/" + key1 + "/" + kind;
        DecimalFormat result = (DecimalFormat)this.numberFormatCache.get(key);
        if (result != null) {
            return result;
        }
        String pattern = kind == PATTERN ? key1 : this.getPattern(key1, kind);
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setDecimalSeparator(this.cldrFile.getStringValue("//ldml/numbers/symbols/decimal").charAt(0));
        symbols.setDigit(this.cldrFile.getStringValue("//ldml/numbers/symbols/patternDigit").charAt(0));
        symbols.setExponentSeparator(this.cldrFile.getStringValue("//ldml/numbers/symbols/exponential"));
        symbols.setGroupingSeparator(this.cldrFile.getStringValue("//ldml/numbers/symbols/group").charAt(0));
        symbols.setInfinity(this.cldrFile.getStringValue("//ldml/numbers/symbols/infinity"));
        symbols.setMinusSign(this.cldrFile.getStringValue("//ldml/numbers/symbols/minusSign").charAt(0));
        symbols.setNaN(this.cldrFile.getStringValue("//ldml/numbers/symbols/nan"));
        symbols.setPatternSeparator(this.cldrFile.getStringValue("//ldml/numbers/symbols/list").charAt(0));
        symbols.setPercent(this.cldrFile.getStringValue("//ldml/numbers/symbols/percentSign").charAt(0));
        symbols.setPerMill(this.cldrFile.getStringValue("//ldml/numbers/symbols/perMille").charAt(0));
        symbols.setPlusSign(this.cldrFile.getStringValue("//ldml/numbers/symbols/plusSign").charAt(0));
        symbols.setZeroDigit(this.cldrFile.getStringValue("//ldml/numbers/symbols/nativeZeroDigit").charAt(0));
        symbols.setMonetaryDecimalSeparator(symbols.getDecimalSeparator());
        MyCurrency mc = null;
        if (kind == CURRENCY) {
            int endPos;
            String currencyGrouping;
            String prefix = "//ldml/numbers/currencyFormats/currencySpacing/beforeCurrency/";
            UnicodeSet beforeCurrencyMatch = new UnicodeSet(this.cldrFile.getStringValue(prefix + "currencyMatch"));
            UnicodeSet beforeSurroundingMatch = new UnicodeSet(this.cldrFile.getStringValue(prefix + "surroundingMatch"));
            String beforeInsertBetween = this.cldrFile.getStringValue(prefix + "insertBetween");
            prefix = "//ldml/numbers/currencyFormats/currencySpacing/afterCurrency/";
            UnicodeSet afterCurrencyMatch = new UnicodeSet(this.cldrFile.getStringValue(prefix + "currencyMatch"));
            UnicodeSet afterSurroundingMatch = new UnicodeSet(this.cldrFile.getStringValue(prefix + "surroundingMatch"));
            String afterInsertBetween = this.cldrFile.getStringValue(prefix + "insertBetween");
            prefix = "//ldml/numbers/currencies/currency[@type=\"" + key1 + "\"]/";
            String symbol = this.cldrFile.getStringValue(prefix + "symbol");
            String currencyDecimal = this.cldrFile.getStringValue(prefix + "decimal");
            if (currencyDecimal != null) {
                symbols.setMonetaryDecimalSeparator(currencyDecimal.charAt(0));
            } else {
                symbols.setMonetaryDecimalSeparator(symbols.getDecimalSeparator());
            }
            String currencyPattern = this.cldrFile.getStringValue(prefix + "pattern");
            if (currencyPattern != null) {
                pattern = currencyPattern;
            }
            if ((currencyGrouping = this.cldrFile.getStringValue(prefix + "grouping")) != null) {
                symbols.setMonetaryGroupingSeparator(currencyGrouping.charAt(0));
            } else {
                symbols.setMonetaryGroupingSeparator(symbols.getGroupingSeparator());
            }
            int startPos = pattern.indexOf(164);
            if (startPos > 0 && beforeCurrencyMatch.contains(UTF16.charAt((String)symbol, (int)0))) {
                int ch = UTF16.charAt((String)pattern, (int)(startPos - 1));
                if (ch == 35) {
                    ch = 48;
                }
                if (beforeSurroundingMatch.contains(ch)) {
                    pattern = pattern.substring(0, startPos) + beforeInsertBetween + pattern.substring(startPos);
                }
            }
            if ((endPos = pattern.lastIndexOf(164) + 1) < pattern.length() && afterCurrencyMatch.contains(UTF16.charAt((String)symbol, (int)(symbol.length() - 1)))) {
                int ch = UTF16.charAt((String)pattern, (int)endPos);
                if (ch == 35) {
                    ch = 48;
                }
                if (afterSurroundingMatch.contains(ch)) {
                    pattern = pattern.substring(0, endPos) + afterInsertBetween + pattern.substring(endPos);
                }
            }
            mc = new MyCurrency(key1, symbol, this.cldrFile.getStringValue(prefix + "displayName"), null, null);
        }
        result = new DecimalFormat(pattern, symbols);
        if (mc != null) {
            result.setCurrency(mc);
        } else {
            result.setCurrency(NO_CURRENCY);
        }
        if (kind == OTHER_KEY && key1.equals("integer")) {
            result.setMaximumFractionDigits(0);
            result.setDecimalSeparatorAlwaysShown(false);
            result.setParseIntegerOnly(true);
        }
        this.numberFormatCache.put(key, result);
        return result;
    }

    private String getPattern(String key1, int isCurrency) {
        String prefix = "//ldml/numbers/";
        String type = key1;
        if (isCurrency == CURRENCY) {
            type = "currency";
        } else if (key1.equals("integer")) {
            type = "decimal";
        }
        String path = prefix + type + "Formats/" + type + "FormatLength/" + type + "Format[@type=\"standard\"]/pattern[@type=\"standard\"]";
        String pattern = this.cldrFile.getStringValue(path);
        if (pattern == null) {
            throw new IllegalArgumentException("locale: " + this.cldrFile.getLocaleID() + "\tpath: " + path);
        }
        return pattern;
    }

    static {
        iso.setTimeZone(utc);
        DateFormatValues = new int[]{-1, 3, 2, 1, 0};
        DateFormatNames = new String[]{"none", "short", "medium", "long", "full"};
        LIMIT_DATE_FORMAT_INDEX = DateFormatValues.length;
        Days = new String[]{"sun", "mon", "tue", "wed", "thu", "fri", "sat"};
        gregorianMonthsMatcher = Pattern.compile(".*gregorian.*months.*").matcher("");
        NumberNames = new String[]{"integer", "decimal", "percent", "scientific"};
        firstReal = 1;
        firstCurrency = 4;
        LIMIT_NUMBER_INDEX = NumberNames.length;
        CURRENCY = 0;
        OTHER_KEY = 1;
        PATTERN = 2;
    }

    private static class MyCurrency
    extends Currency {
        String symbol;
        String displayName;
        int fractDigits;
        double roundingIncrement;

        MyCurrency(String code, String symbol, String displayName, String fractDigits, String roundingIncrement) {
            super(code);
            this.symbol = symbol == null ? code : symbol;
            this.displayName = displayName == null ? code : displayName;
            this.fractDigits = fractDigits == null ? 2 : Integer.parseInt(fractDigits);
            this.roundingIncrement = roundingIncrement == null ? 0.0 : (double)Integer.parseInt(roundingIncrement) * Math.pow(10.0, -this.fractDigits);
        }

        public String getName(ULocale locale, int nameStyle, boolean[] isChoiceFormat) {
            int i;
            String result;
            String string = nameStyle == 0 ? this.symbol : (nameStyle == 1 ? this.getCurrencyCode() : (result = nameStyle == 2 ? this.displayName : null));
            if (result == null) {
                throw new IllegalArgumentException();
            }
            isChoiceFormat[0] = false;
            for (i = 0; i < result.length() && result.charAt(i) == '=' && i < 2; ++i) {
            }
            boolean bl = isChoiceFormat[0] = i == 1;
            if (i != 0) {
                result = result.substring(1);
            }
            return result;
        }

        public double getRoundingIncrement() {
            return this.roundingIncrement;
        }

        public int getDefaultFractionDigits() {
            return this.fractDigits;
        }

        public boolean equals(Object other) {
            MyCurrency that = (MyCurrency)((Object)other);
            return this.roundingIncrement == that.roundingIncrement && this.fractDigits == that.fractDigits && this.symbol.equals(that.symbol) && this.displayName.equals(that.displayName);
        }

        private int hashCode(Object other) {
            MyCurrency that = (MyCurrency)((Object)other);
            return (((int)this.roundingIncrement * 37 + this.fractDigits) * 37 + this.symbol.hashCode()) * 37 + this.displayName.hashCode();
        }
    }
}

