/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.dev.test;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Locale;

public final class TestUtil {
    public static final String DATA_PATH = "/com/ibm/icu/dev/data/";
    static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};

    public static final InputStream getDataStream(String name) throws IOException {
        InputStream is = null;
        try {
            is = TestUtil.class.getResourceAsStream(DATA_PATH + name);
        }
        catch (Throwable t) {
            IOException ex = new IOException("data resource '" + name + "' not found");
            ex.initCause(t);
            throw ex;
        }
        return is;
    }

    public static final BufferedReader getDataReader(String name, String charset) throws IOException {
        InputStream is = TestUtil.getDataStream(name);
        InputStreamReader isr = charset == null ? new InputStreamReader(is) : new InputStreamReader(is, charset);
        return new BufferedReader(isr);
    }

    public static final BufferedReader getDataReader(String name) throws IOException {
        return TestUtil.getDataReader(name, null);
    }

    public static boolean isUnprintable(int c) {
        return c < 32 || c > 126;
    }

    public static boolean escapeUnprintable(StringBuffer result, int c) {
        if (TestUtil.isUnprintable(c)) {
            result.append('\\');
            if ((c & 0xFFFF0000) != 0) {
                result.append('U');
                result.append(DIGITS[0xF & c >> 28]);
                result.append(DIGITS[0xF & c >> 24]);
                result.append(DIGITS[0xF & c >> 20]);
                result.append(DIGITS[0xF & c >> 16]);
            } else {
                result.append('u');
            }
            result.append(DIGITS[0xF & c >> 12]);
            result.append(DIGITS[0xF & c >> 8]);
            result.append(DIGITS[0xF & c >> 4]);
            result.append(DIGITS[0xF & c]);
            return true;
        }
        return false;
    }

    public static void runUntilDone(Runnable[] targets) {
        if (targets == null) {
            throw new IllegalArgumentException("targets is null");
        }
        if (targets.length == 0) {
            return;
        }
        Lock lock = new Lock();
        for (int i = 0; i < targets.length; ++i) {
            new TestThread(lock, targets[i]).start();
        }
        lock.go();
    }

    public static BufferedReader openUTF8Reader(String dir, String filename) throws IOException {
        return TestUtil.openReader(dir, filename, "UTF-8");
    }

    public static BufferedReader openReader(String dir, String filename, String encoding) throws IOException {
        File file = new File(dir + filename);
        return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), encoding), 4096);
    }

    public static JavaVendor getJavaVendor() {
        JavaVendor vendor = JavaVendor.Unknown;
        String javaVendorProp = System.getProperty("java.vendor", "").toLowerCase(Locale.US).trim();
        if (javaVendorProp.startsWith("ibm")) {
            vendor = JavaVendor.IBM;
        } else if (javaVendorProp.startsWith("sun") || javaVendorProp.startsWith("oracle")) {
            vendor = JavaVendor.Oracle;
        } else if (javaVendorProp.contains("android")) {
            vendor = JavaVendor.Android;
        }
        return vendor;
    }

    public static int getJavaVersion() {
        int ver = -1;
        String verstr = System.getProperty("java.version");
        if (verstr != null) {
            String[] numbers = verstr.split("\\.");
            try {
                ver = Integer.parseInt(numbers[1]);
            }
            catch (NumberFormatException e) {
                ver = -1;
            }
        }
        return ver;
    }

    static class Lock {
        private int count;

        Lock() {
        }

        synchronized void inc() {
            ++this.count;
        }

        synchronized void dec() {
            --this.count;
        }

        synchronized int count() {
            return this.count;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void go() {
            try {
                while (this.count() > 0) {
                    Lock lock = this;
                    synchronized (lock) {
                        this.notifyAll();
                    }
                    Thread.sleep(50L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    static class TestThread
    extends Thread {
        Lock lock;
        Runnable target;

        TestThread(Lock lock, Runnable target) {
            this.lock = lock;
            this.target = target;
            lock.inc();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Lock lock = this.lock;
                synchronized (lock) {
                    this.lock.wait();
                }
                this.target.run();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.lock.dec();
        }
    }

    public static enum JavaVendor {
        Unknown,
        Oracle,
        IBM,
        Android;

    }
}

