/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.api;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.regex.Pattern;
import org.unicode.cldr.api.AttributeKey;
import org.unicode.cldr.api.CldrData;
import org.unicode.cldr.api.CldrPath;
import org.unicode.cldr.api.CldrPaths;
import org.unicode.cldr.api.CldrValue;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.XPathParts;

final class CldrFileDataSource
implements CldrData {
    private static final Pattern CAPTURE_SORT_INDEX = Pattern.compile("#([0-9]+)");
    private final CLDRFile source;

    CldrFileDataSource(CLDRFile source) {
        this.source = Preconditions.checkNotNull(source);
    }

    @Override
    public void accept(CldrData.PathOrder order, CldrData.ValueVisitor visitor) {
        Iterator<String> paths;
        switch (order) {
            case ARBITRARY: {
                paths = this.source.iterator();
                break;
            }
            case NESTED_GROUPING: {
                paths = this.source.iterator(null, Comparator.naturalOrder());
                break;
            }
            case DTD: {
                paths = this.source.iterator(null, this.source.getComparator());
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown path ordering: " + (Object)((Object)order)));
            }
        }
        this.read(paths, this.source, visitor);
    }

    @Override
    public CldrValue get(CldrPath cldrPath) {
        String dPath = CldrFileDataSource.getInternalPathString(cldrPath);
        String fullXPath = this.source.getFullXPath(dPath);
        if (fullXPath == null) {
            return null;
        }
        XPathParts pathPaths = XPathParts.getFrozenInstance(fullXPath);
        int length = pathPaths.size();
        LinkedHashMap<AttributeKey, String> attributes = new LinkedHashMap<AttributeKey, String>();
        for (int n = 0; n < length; ++n) {
            CldrPaths.processPathAttributes(pathPaths.getElement(n), pathPaths.getAttributes(n), cldrPath.getDataType(), e -> {}, attributes::put);
        }
        String value = this.source.getStringValue(dPath);
        if (value == null || value.equals(CldrUtility.INHERITANCE_MARKER)) {
            return null;
        }
        return CldrValue.create(value, attributes, cldrPath);
    }

    private static String getInternalPathString(CldrPath p) {
        String dpath = p.toString();
        if (dpath.indexOf(35) != -1) {
            dpath = CAPTURE_SORT_INDEX.matcher(dpath).replaceAll("[@_q=\"$1\"]");
        }
        return dpath;
    }

    private void read(Iterator<String> paths, CLDRFile src, CldrData.ValueVisitor visitor) {
        LinkedHashMap<AttributeKey, String> valueAttributes = new LinkedHashMap<AttributeKey, String>();
        ArrayList<CldrPath> previousElementStack = new ArrayList<CldrPath>();
        List<CldrPath> previousElements = Lists.reverse(previousElementStack);
        while (paths.hasNext()) {
            String dPath = paths.next();
            String value = src.getStringValue(dPath);
            if (value == null || value.equals(CldrUtility.INHERITANCE_MARKER)) continue;
            CldrPath cldrPath = CldrPaths.processXPath(src.getFullXPath(dPath), previousElements, valueAttributes::put);
            if (CldrPaths.isLeafPath(cldrPath) && CldrPaths.shouldEmit(cldrPath)) {
                visitor.visit(CldrValue.create(value, valueAttributes, cldrPath));
            }
            CldrFileDataSource.pushPathElements(cldrPath, previousElementStack);
            valueAttributes.clear();
        }
    }

    private static void pushPathElements(CldrPath cldrPath, List<CldrPath> stack) {
        stack.clear();
        for (CldrPath p = cldrPath; p != null; p = p.getParent()) {
            stack.add(p);
        }
    }
}

