/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.draft;

import com.google.common.base.Joiner;
import com.ibm.icu.text.UnicodeSet;
import java.io.File;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.unicode.cldr.draft.KeyboardModifierSet;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.LanguageTagParser;
import org.unicode.cldr.util.XMLFileReader;
import org.unicode.cldr.util.XPathParts;

public class Keyboard {
    private static final boolean DEBUG = false;
    private static final String BASE = CLDRPaths.BASE_DIRECTORY + "keyboards/";
    private final String locale;
    private final String version;
    private final String platformVersion;
    private final Fallback fallback;
    private final Set<String> names;
    private final Set<KeyMap> keyMaps;
    private final Map<TransformType, Transforms> transforms;

    public static Set<String> getPlatformIDs() {
        LinkedHashSet<String> results = new LinkedHashSet<String>();
        File file = new File(BASE);
        for (String f : file.list()) {
            if (f.equals("dtd") || f.startsWith(".") || f.startsWith("_")) continue;
            results.add(f);
        }
        return results;
    }

    public static Set<String> getKeyboardIDs(String platformId) {
        LinkedHashSet<String> results = new LinkedHashSet<String>();
        File base = new File(BASE + platformId + "/");
        for (String f : base.list()) {
            if (!f.endsWith(".xml") || f.startsWith(".") || f.startsWith("_")) continue;
            results.add(f.substring(0, f.length() - 4));
        }
        return results;
    }

    public static Platform getPlatform(String platformId) {
        String fileName = BASE + platformId + "/_platform.xml";
        try {
            PlatformHandler platformHandler = new PlatformHandler();
            new XMLFileReader().setHandler(platformHandler).read(fileName, -1, true);
            return platformHandler.getPlatform();
        }
        catch (Exception e) {
            throw new KeyboardException(fileName, e);
        }
    }

    public Keyboard(String locale, String version, String platformVersion, Set<String> names, Fallback fallback, Set<KeyMap> keyMaps, Map<TransformType, Transforms> transforms) {
        this.locale = locale;
        this.version = version;
        this.platformVersion = platformVersion;
        this.fallback = fallback;
        this.names = Collections.unmodifiableSet(names);
        this.keyMaps = Collections.unmodifiableSet(keyMaps);
        this.transforms = Collections.unmodifiableMap(transforms);
    }

    public static String getPlatformId(String keyboardId) {
        int pos = keyboardId.indexOf("-t-k0-") + 6;
        int pos2 = keyboardId.indexOf(45, pos);
        if (pos2 < 0) {
            pos2 = keyboardId.length();
        }
        return keyboardId.substring(pos, pos2);
    }

    public static Keyboard getKeyboard(String platformId, String keyboardId, Set<Exception> errors) {
        String fileName = BASE + platformId + "/" + keyboardId + ".xml";
        try {
            KeyboardHandler keyboardHandler = new KeyboardHandler(errors);
            new XMLFileReader().setHandler(keyboardHandler).read(fileName, -1, true);
            return keyboardHandler.getKeyboard();
        }
        catch (Exception e) {
            throw new KeyboardException(fileName + "\n" + Joiner.on(", ").join(errors), e);
        }
    }

    public static Keyboard getKeyboard(String id, Reader r, Set<Exception> errors) {
        try {
            KeyboardHandler keyboardHandler = new KeyboardHandler(errors);
            new XMLFileReader().setHandler(keyboardHandler).read(id, r, -1, true);
            return keyboardHandler.getKeyboard();
        }
        catch (Exception e) {
            errors.add(e);
            return null;
        }
    }

    public String getLocaleId() {
        return this.locale;
    }

    public String getVersion() {
        return this.version;
    }

    public String getPlatformVersion() {
        return this.platformVersion;
    }

    public Fallback getFallback() {
        return this.fallback;
    }

    public Set<String> getNames() {
        return this.names;
    }

    public Set<KeyMap> getKeyMaps() {
        return this.keyMaps;
    }

    public Map<TransformType, Transforms> getTransforms() {
        return this.transforms;
    }

    public UnicodeSet getPossibleResults() {
        UnicodeSet results = new UnicodeSet();
        for (KeyMap keymap : this.getKeyMaps()) {
            this.addOutput(keymap.iso2output.values(), results);
        }
        for (Transforms transforms : this.getTransforms().values()) {
            for (String result : transforms.string2string.values()) {
                if (result.isEmpty()) continue;
                results.add(result);
            }
        }
        return results;
    }

    private void addOutput(Collection<Output> values, UnicodeSet results) {
        for (Output value : values) {
            if (value.output != null && !value.output.isEmpty()) {
                results.add(value.output);
            }
            for (List<String> outputList : value.gestures.values()) {
                results.addAll((Iterable<?>)outputList);
            }
        }
    }

    private static class PlatformHandler
    extends XMLFileReader.SimpleHandler {
        String id;
        Map<String, Iso> hardwareMap = new HashMap<String, Iso>();

        private PlatformHandler() {
        }

        @Override
        public void handlePathValue(String path, String value) {
            String element1;
            XPathParts parts = XPathParts.getFrozenInstance(path);
            this.id = parts.getAttributeValue(0, "id");
            if (parts.size() > 1 && (element1 = parts.getElement(1)).equals("hardwareMap")) {
                this.hardwareMap.put(parts.getAttributeValue(2, "keycode"), Iso.valueOf(parts.getAttributeValue(2, "iso")));
            }
        }

        public Platform getPlatform() {
            return new Platform(this.id, this.hardwareMap);
        }
    }

    public static class Platform {
        final String id;
        final Map<String, Iso> hardwareMap;

        public String getId() {
            return this.id;
        }

        public Map<String, Iso> getHardwareMap() {
            return this.hardwareMap;
        }

        public Platform(String id, Map<String, Iso> hardwareMap) {
            this.id = id;
            this.hardwareMap = Collections.unmodifiableMap(hardwareMap);
        }
    }

    public static class KeyboardException
    extends RuntimeException {
        private static final long serialVersionUID = 3802627982169201480L;

        public KeyboardException(String string) {
            super(string);
        }

        public KeyboardException(String string, Exception e) {
            super(string, e);
        }
    }

    public static enum Fallback {
        BASE,
        OMIT;


        public static Fallback forString(String string) {
            return string == null ? BASE : Fallback.valueOf(string.toUpperCase(Locale.ENGLISH));
        }
    }

    private static class KeyboardHandler
    extends XMLFileReader.SimpleHandler {
        Set<Exception> errors;
        Set<String> errors2 = new LinkedHashSet<String>();
        String locale;
        String version;
        String platformVersion;
        Set<String> names = new LinkedHashSet<String>();
        Fallback fallback = Fallback.BASE;
        KeyboardModifierSet keyMapModifiers = null;
        Map<Iso, Output> iso2output = new EnumMap<Iso, Output>(Iso.class);
        Set<KeyMap> keyMaps = new LinkedHashSet<KeyMap>();
        TransformType currentType = null;
        Map<String, String> currentTransforms = null;
        Map<TransformType, Transforms> transformMap = new EnumMap<TransformType, Transforms>(TransformType.class);
        LanguageTagParser ltp = new LanguageTagParser();

        public KeyboardHandler(Set<Exception> errorsOutput) {
            this.errors = errorsOutput;
            this.errors.clear();
        }

        public Keyboard getKeyboard() {
            this.addToKeyMaps();
            if (this.currentType != null) {
                this.transformMap.put(this.currentType, new Transforms(this.currentTransforms));
            }
            return new Keyboard(this.locale, this.version, this.platformVersion, this.names, this.fallback, this.keyMaps, this.transformMap);
        }

        @Override
        public void handlePathValue(String path, String value) {
            block19: {
                try {
                    String element1;
                    XPathParts parts = XPathParts.getFrozenInstance(path);
                    if (this.locale == null) {
                        this.locale = parts.getAttributeValue(0, "locale");
                        this.ltp.set(this.locale);
                        Map<String, String> extensions = this.ltp.getExtensions();
                        LanguageTagParser.Status status = this.ltp.getStatus(this.errors2);
                        if (this.errors2.size() != 0 || !this.ltp.hasT()) {
                            this.errors.add(new KeyboardException("Bad locale tag: " + this.locale + ", " + this.errors2.toString()));
                        } else if (status != LanguageTagParser.Status.MINIMAL) {
                            this.errors.add(new KeyboardWarningException("Non-minimal locale tag: " + this.locale));
                        }
                    }
                    if ((element1 = parts.getElement(1)).equals("baseMap")) {
                        Iso iso = Iso.valueOf(parts.getAttributeValue(2, "iso"));
                        Output output = this.getOutput(parts);
                        if (output != null) {
                            this.iso2output.put(iso, output);
                        }
                        break block19;
                    }
                    if (element1.equals("keyMap")) {
                        String modifiers = parts.getAttributeValue(1, "modifiers");
                        KeyboardModifierSet newMods = KeyboardModifierSet.parseSet(modifiers == null ? "" : modifiers);
                        if (!newMods.equals(this.keyMapModifiers)) {
                            if (this.keyMapModifiers != null) {
                                this.addToKeyMaps();
                            }
                            this.iso2output = new LinkedHashMap<Iso, Output>();
                            this.keyMapModifiers = newMods;
                        }
                        String isoString = parts.getAttributeValue(2, "iso");
                        Output output = this.getOutput(parts);
                        if (output != null) {
                            this.iso2output.put(Iso.valueOf(isoString), output);
                        }
                        break block19;
                    }
                    if (element1.equals("transforms")) {
                        String to;
                        String from;
                        TransformType type = TransformType.forString(parts.getAttributeValue(1, "type"));
                        if (type != this.currentType) {
                            if (this.currentType != null) {
                                this.transformMap.put(this.currentType, new Transforms(this.currentTransforms));
                            }
                            this.currentType = type;
                            this.currentTransforms = new LinkedHashMap<String, String>();
                        }
                        if ((from = this.fixValue(parts.getAttributeValue(2, "from"))).equals(to = this.fixValue(parts.getAttributeValue(2, "to")))) {
                            this.errors.add(new KeyboardException("Illegal transform from:" + from + " to:" + to));
                        }
                        this.currentTransforms.put(from, to);
                        break block19;
                    }
                    if (element1.equals("version")) {
                        this.platformVersion = parts.getAttributeValue(1, "platform");
                        this.version = parts.getAttributeValue(1, "number");
                        break block19;
                    }
                    if (element1.equals("names")) {
                        this.names.add(parts.getAttributeValue(2, "value"));
                        break block19;
                    }
                    if (element1.equals("settings")) {
                        this.fallback = Fallback.forString(parts.getAttributeValue(1, "fallback"));
                        break block19;
                    }
                    throw new KeyboardException("Unexpected element: " + element1);
                }
                catch (Exception e) {
                    throw new KeyboardException("Unexpected error in: " + path, e);
                }
            }
        }

        public void addToKeyMaps() {
            for (KeyMap item : this.keyMaps) {
                if (item.modifiers.containsSome(this.keyMapModifiers)) {
                    this.errors.add(new KeyboardException("Modifier overlap: " + item.modifiers + " already contains " + this.keyMapModifiers));
                }
                if (!item.iso2output.equals(this.iso2output)) continue;
                this.errors.add(new KeyboardException("duplicate keyboard: " + item.modifiers + " has same layout as " + this.keyMapModifiers));
            }
            this.keyMaps.add(new KeyMap(this.keyMapModifiers, this.iso2output));
        }

        private String fixValue(String value) {
            int posEnd;
            int pos;
            StringBuilder b = new StringBuilder();
            int last = 0;
            while ((pos = value.indexOf("\\u{", last)) >= 0 && (posEnd = value.indexOf("}", pos + 3)) >= 0) {
                b.append(value.substring(last, pos)).appendCodePoint(Integer.parseInt(value.substring(pos + 3, posEnd), 16));
                last = posEnd + 1;
            }
            b.append(value.substring(last));
            return b.toString();
        }

        public Output getOutput(XPathParts parts) {
            String chars = null;
            TransformStatus transformStatus = TransformStatus.DEFAULT;
            EnumMap<Gesture, List<String>> gestures = new EnumMap<Gesture, List<String>>(Gesture.class);
            for (Map.Entry<String, String> attributeAndValue : parts.getAttributes(-1).entrySet()) {
                String attribute = attributeAndValue.getKey();
                String attributeValue = attributeAndValue.getValue();
                if (attribute.equals("to")) {
                    chars = this.fixValue(attributeValue);
                    if (!chars.isEmpty()) continue;
                    this.errors.add(new KeyboardException("**Empty result at " + parts.toString()));
                    continue;
                }
                if (attribute.equals("transform")) {
                    transformStatus = TransformStatus.fromString(attributeValue);
                    continue;
                }
                if (attribute.equals("iso") || attribute.equals("base")) continue;
                LinkedHashSet<String> list = new LinkedHashSet<String>();
                for (String item : attributeValue.trim().split(" ")) {
                    String fixedValue = this.fixValue(item);
                    if (fixedValue.isEmpty()) continue;
                    list.add(fixedValue);
                }
                gestures.put(Gesture.fromString(attribute), Collections.unmodifiableList(new ArrayList(list)));
            }
            return new Output(chars, gestures, transformStatus);
        }
    }

    public static class KeyMap {
        private final KeyboardModifierSet modifiers;
        final Map<Iso, Output> iso2output;

        public KeyMap(KeyboardModifierSet keyMapModifiers, Map<Iso, Output> data) {
            this.modifiers = keyMapModifiers;
            this.iso2output = Collections.unmodifiableMap(data);
        }

        public KeyboardModifierSet getModifiers() {
            return this.modifiers;
        }

        public Map<Iso, Output> getIso2Output() {
            return this.iso2output;
        }

        public String toString() {
            return "{" + this.modifiers + "," + this.iso2output + "}";
        }
    }

    public static class Transforms {
        final Map<String, String> string2string;

        public Transforms(Map<String, String> data) {
            this.string2string = data;
        }

        public Map<String, String> getMatch(String prefix) {
            LinkedHashMap<String, String> results = new LinkedHashMap<String, String>();
            for (Map.Entry<String, String> entry : this.string2string.entrySet()) {
                String key = entry.getKey();
                if (!key.startsWith(prefix)) continue;
                results.put(key.substring(prefix.length()), entry.getValue());
            }
            return results;
        }
    }

    public static class Output {
        final String output;
        final TransformStatus transformStatus;
        final Map<Gesture, List<String>> gestures;

        public Output(String output, Map<Gesture, List<String>> gestures, TransformStatus transformStatus) {
            this.output = output;
            this.transformStatus = transformStatus;
            this.gestures = Collections.unmodifiableMap(gestures);
        }

        public String getOutput() {
            return this.output;
        }

        public TransformStatus getTransformStatus() {
            return this.transformStatus;
        }

        public Map<Gesture, List<String>> getGestures() {
            return this.gestures;
        }

        public String toString() {
            return "{" + this.output + "," + (Object)((Object)this.transformStatus) + ", " + this.gestures + "}";
        }
    }

    public static class KeyboardWarningException
    extends KeyboardException {
        private static final long serialVersionUID = 3802627982169201480L;

        public KeyboardWarningException(String string) {
            super(string);
        }

        public KeyboardWarningException(String string, Exception e) {
            super(string, e);
        }
    }

    public static enum TransformType {
        SIMPLE;


        public static TransformType forString(String string) {
            return string == null ? SIMPLE : TransformType.valueOf(string.toUpperCase(Locale.ENGLISH));
        }
    }

    public static enum TransformStatus {
        DEFAULT,
        NO;


        public static TransformStatus fromString(String string) {
            return string == null ? DEFAULT : TransformStatus.valueOf(string.toUpperCase(Locale.ENGLISH));
        }
    }

    public static enum Gesture {
        LONGPRESS;


        public static Gesture fromString(String string) {
            return Gesture.valueOf(string.toUpperCase(Locale.ENGLISH));
        }
    }

    public static enum Modifier {
        cmd,
        ctrlL,
        ctrlR,
        caps,
        altL,
        altR,
        optL,
        optR,
        shiftL,
        shiftR;

    }

    public static enum Iso {
        E00,
        E01,
        E02,
        E03,
        E04,
        E05,
        E06,
        E07,
        E08,
        E09,
        E10,
        E11,
        E12,
        E13,
        D00,
        D01,
        D02,
        D03,
        D04,
        D05,
        D06,
        D07,
        D08,
        D09,
        D10,
        D11,
        D12,
        D13,
        C00,
        C01,
        C02,
        C03,
        C04,
        C05,
        C06,
        C07,
        C08,
        C09,
        C10,
        C11,
        C12,
        C13,
        B00,
        B01,
        B02,
        B03,
        B04,
        B05,
        B06,
        B07,
        B08,
        B09,
        B10,
        B11,
        B12,
        B13,
        A00,
        A01,
        A02,
        A03,
        A04,
        A05,
        A06,
        A07,
        A08,
        A09,
        A10,
        A11,
        A12,
        A13;

        public final IsoRow isoRow = IsoRow.valueOf(this.name().substring(0, 1));
    }

    public static enum IsoRow {
        E,
        D,
        C,
        B,
        A;

    }
}

