/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.draft.keyboard;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;

public final class Transform
implements Comparable<Transform> {
    private final String sequence;
    private final String output;

    private Transform(String sequence, String output) {
        this.sequence = Preconditions.checkNotNull(sequence);
        this.output = Preconditions.checkNotNull(output);
    }

    public static Transform of(String sequence, String output) {
        return new Transform(sequence, output);
    }

    public String sequence() {
        return this.sequence;
    }

    public String output() {
        return this.output;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("sequence", this.sequence).add("output", this.output).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Transform) {
            Transform other = (Transform)o;
            return this.sequence.equals(other.sequence) && this.output.equals(other.output);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.sequence, this.output);
    }

    @Override
    public int compareTo(Transform o) {
        return this.sequence.compareTo(o.sequence);
    }
}

