/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.icu;

import com.ibm.icu.text.UTF16;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.unicode.cldr.icu.LDML2ICUBinaryWriter;

public class ICUResourceWriter {
    private static final String CHARSET = "UTF-8";
    private static final String OPENBRACE = "{";
    private static final String CLOSEBRACE = "}";
    private static final String OPENPAREN = "(";
    private static final String CLOSEPAREN = ")";
    private static final String COLON = ":";
    private static final String COMMA = ",";
    private static final String QUOTE = "\"";
    private static final String COMMENTSTART = "/**";
    private static final String COMMENTEND = " */";
    private static final String COMMENTMIDDLE = " * ";
    private static final String INDENT = "    ";
    private static final String EMPTY = "";
    private static final String BIN = "bin";
    private static final String INTS = "int";
    private static final String TABLE = "table";
    private static final String IMPORT = "import";
    private static final String INCLUDE = "include";
    private static final String PROCESS = "process";
    private static final String ALIAS = "alias";
    private static final String INTVECTOR = "intvector";
    private static final String LINESEP = System.getProperty("line.separator");
    private static final String STRTERM = "\u0000";
    public static final int SIZE_OF_INT = 4;
    public static final int SIZE_OF_CHAR = 2;
    public static final String UCA_RULES = "uca_rules";
    public static final String TRANSLITERATOR = "transliaterator";
    public static final String COLLATION = "collation";
    public static final String DEPENDENCY = "dependency";
    public static final int BIN_ALIGNMENT = 16;
    public static int maxTableLength;

    public static Resource createString(String name, String val) {
        return new ResourceString(name, val);
    }

    private static int pad32(int x) {
        return x % 4 == 0 ? 0 : 4 - x % 4;
    }

    private static byte[] create32Padding(int x) {
        byte[] b = new byte[ICUResourceWriter.pad32(x)];
        if (ICUResourceWriter.pad32(x) == 0) {
            return null;
        }
        for (int z = 0; z < b.length; ++z) {
            b[z] = 0;
        }
        return b;
    }

    private static int pad16Bytes(int x) {
        return x % 16 == 0 ? 0 : 16 - x % 16;
    }

    private static byte[] intToBytes(int x) {
        byte[] b = new byte[4];
        b[3] = (byte)x;
        b[2] = (byte)(x >>>= 8);
        b[1] = (byte)(x >>>= 8);
        b[0] = (byte)(x >>>= 8);
        return b;
    }

    private static byte[] intArrayToBytes(int[] x) {
        byte[] b = new byte[x.length * 4];
        for (int i = 0; i < x.length; ++i) {
            byte[] temp = ICUResourceWriter.intToBytes(x[i]);
            for (int z = 0; z < temp.length; ++z) {
                b[i * temp.length + z] = temp[z];
            }
        }
        return b;
    }

    private static byte[] shortArrayToBytes(short[] x) {
        byte[] b = new byte[x.length * 2];
        for (int i = 0; i < x.length; ++i) {
            byte[] temp = ICUResourceWriter.shortToBytes(x[i]);
            for (int z = 0; z < temp.length; ++z) {
                b[i * temp.length + z] = temp[z];
            }
        }
        return b;
    }

    private static byte[] shortToBytes(short x) {
        byte[] b = new byte[2];
        b[1] = (byte)x;
        b[0] = (byte)(x >>> 8);
        return b;
    }

    private static void errUnsupportedEncoding() {
        System.err.print("Unsupported Encoding");
        System.exit(1);
    }

    private static void errIO() {
        System.err.print("An error occured while writing to file.");
        System.exit(1);
    }

    private static byte[] createPadding(int length) {
        byte x = 0;
        byte[] b = new byte[length];
        if (length == 0) {
            return null;
        }
        for (int z = 0; z < b.length; ++z) {
            b[z] = x;
        }
        return b;
    }

    public static class ResourceString
    extends Resource {
        public String val;
        public String smallComment = null;

        public ResourceString() {
        }

        public ResourceString(String name, String val) {
            this.name = name;
            this.val = val;
        }

        @Override
        public void write(OutputStream writer, int numIndent, boolean bare) {
            this.writeComments(writer, numIndent);
            this.writeIndent(writer, numIndent);
            if (bare) {
                if (this.name != null) {
                    throw new RuntimeException("Bare option is set to true but the resource has a name! " + this.name);
                }
                this.write(writer, ICUResourceWriter.QUOTE + this.escapeSyntaxChars(this.val) + ICUResourceWriter.QUOTE);
                if (this.smallComment != null) {
                    this.write(writer, " /** " + this.smallComment + " " + ICUResourceWriter.COMMENTEND);
                }
            } else {
                StringBuffer str = this.escapeSyntaxChars(this.val);
                int colLen = 80 - numIndent * 4;
                int strLen = str.length();
                if (strLen > colLen) {
                    int startIndex = 0;
                    int endIndex = 0;
                    this.write(writer, this.name + ICUResourceWriter.OPENBRACE + LINESEP);
                    ++numIndent;
                    boolean isRules = this.name.equals("Sequence");
                    while (endIndex < strLen) {
                        int firstIndex;
                        startIndex = endIndex;
                        if ((endIndex = startIndex + colLen) > strLen) {
                            endIndex = strLen;
                        }
                        if (isRules && (firstIndex = str.indexOf("&", startIndex)) > -1) {
                            if (startIndex != firstIndex - 1 && startIndex != firstIndex && firstIndex < endIndex && str.charAt(firstIndex - 1) != '\'') {
                                endIndex = firstIndex;
                            }
                            int nextIndex = 0;
                            while ((nextIndex = str.indexOf("&", firstIndex + 1)) != -1 && nextIndex < endIndex) {
                                if (nextIndex <= -1 || firstIndex == nextIndex) continue;
                                if (str.charAt(nextIndex - 1) != '\'') {
                                    endIndex = nextIndex;
                                    break;
                                }
                                firstIndex = nextIndex;
                            }
                        }
                        int indexOfEsc = 0;
                        indexOfEsc = str.lastIndexOf("\\u", endIndex);
                        if (indexOfEsc > -1 && endIndex - indexOfEsc < 6 || (indexOfEsc = str.lastIndexOf("\\U", endIndex)) > -1 && endIndex - indexOfEsc < 10 || (indexOfEsc = str.lastIndexOf("''", endIndex)) > -1 && endIndex - indexOfEsc < 3) {
                            endIndex = indexOfEsc;
                        }
                        if (indexOfEsc > -1 && str.charAt(indexOfEsc - 1) == '\'') {
                            endIndex = indexOfEsc - 1;
                        }
                        if (endIndex < strLen && UTF16.isLeadSurrogate(str.charAt(endIndex - 1))) {
                            --endIndex;
                        }
                        this.writeIndent(writer, numIndent);
                        this.write(writer, ICUResourceWriter.QUOTE);
                        this.write(writer, str.substring(startIndex, endIndex));
                        this.write(writer, ICUResourceWriter.QUOTE + LINESEP);
                    }
                    this.writeIndent(writer, --numIndent);
                    this.write(writer, ICUResourceWriter.CLOSEBRACE + LINESEP);
                } else {
                    this.write(writer, this.name + ICUResourceWriter.OPENBRACE + ICUResourceWriter.QUOTE + str.toString() + ICUResourceWriter.QUOTE + ICUResourceWriter.CLOSEBRACE + LINESEP);
                }
            }
        }

        @Override
        public int writeBinary(FileOutputStream out, int usedOffset) {
            if (this.val.indexOf(ICUResourceWriter.QUOTE) >= 0) {
                this.val = LDML2ICUBinaryWriter.removeQuotes(this.val);
            }
            String valPlusTerm = this.val + ICUResourceWriter.STRTERM;
            byte[] valLenBytes = ICUResourceWriter.intToBytes(this.val.length());
            try {
                byte[] valBytes = valPlusTerm.getBytes("UTF-16BE");
                byte[] padding = ICUResourceWriter.create32Padding(valBytes.length);
                out.write(valLenBytes);
                LDML2ICUBinaryWriter.written += valLenBytes.length;
                out.write(valBytes);
                LDML2ICUBinaryWriter.written += valBytes.length;
                if (padding != null) {
                    out.write(padding);
                    LDML2ICUBinaryWriter.written += padding.length;
                }
            }
            catch (UnsupportedEncodingException e) {
                System.err.print("Problems converting string resource to UTF-16BE");
                System.exit(1);
            }
            catch (IOException e) {
                System.err.print("Problems writing the string resource to file.");
                System.exit(1);
            }
            return usedOffset;
        }

        @Override
        public void setSize() {
            this.size = 4 + 2 * (this.val.length() + 1);
        }
    }

    public static class ResourceInclude
    extends Resource {
        String val;

        @Override
        public void write(OutputStream writer, int numIndent, boolean bare) {
            this.writeComments(writer, numIndent);
            this.writeIndent(writer, numIndent);
            String line = (this.name == null ? ICUResourceWriter.EMPTY : this.name) + ICUResourceWriter.COLON + ICUResourceWriter.INCLUDE + ICUResourceWriter.OPENBRACE + ICUResourceWriter.QUOTE + this.escapeSyntaxChars(this.val) + ICUResourceWriter.QUOTE + ICUResourceWriter.CLOSEBRACE;
            if (bare) {
                if (this.name != null) {
                    throw new RuntimeException("Bare option is set to true but the resource has a name! " + this.name);
                }
                this.write(writer, line);
            } else {
                this.write(writer, line + LINESEP);
            }
        }
    }

    public static class ResourceImport
    extends Resource {
        String val;

        @Override
        public void write(OutputStream writer, int numIndent, boolean bare) {
            this.writeComments(writer, numIndent);
            this.writeIndent(writer, numIndent);
            String line = (this.name == null ? ICUResourceWriter.EMPTY : this.name) + ICUResourceWriter.COLON + ICUResourceWriter.IMPORT + ICUResourceWriter.OPENBRACE + ICUResourceWriter.QUOTE + this.escapeSyntaxChars(this.val) + ICUResourceWriter.QUOTE + ICUResourceWriter.CLOSEBRACE;
            if (bare) {
                if (this.name != null) {
                    throw new RuntimeException("Bare option is set to true but the resource has a name! " + this.name);
                }
                this.write(writer, line);
            } else {
                this.write(writer, line + LINESEP);
            }
        }
    }

    public static class ResourceProcess
    extends Resource {
        String val;
        String ext;

        @Override
        public void write(OutputStream writer, int numIndent, boolean bare) {
            this.writeComments(writer, numIndent);
            this.writeIndent(writer, numIndent);
            String line = (this.name == null ? ICUResourceWriter.EMPTY : this.name) + ICUResourceWriter.COLON + ICUResourceWriter.PROCESS + ICUResourceWriter.OPENPAREN + this.ext + ICUResourceWriter.CLOSEPAREN + ICUResourceWriter.OPENBRACE + ICUResourceWriter.QUOTE + this.escapeSyntaxChars(this.val) + ICUResourceWriter.QUOTE + ICUResourceWriter.CLOSEBRACE;
            if (bare) {
                if (this.name != null) {
                    throw new RuntimeException("Bare option is set to true but the resource has a name! " + this.name);
                }
                this.write(writer, line);
            } else {
                this.write(writer, line + LINESEP);
            }
        }

        @Override
        public int writeBinary(FileOutputStream out, int usedOffset) {
            if (!this.name.equals("depends")) {
                System.err.println("Unexpected type: " + this.getClass().toString());
                System.err.println("Resource Name: " + this.name);
                return usedOffset;
            }
            return usedOffset;
        }
    }

    public static class ResourceBinary
    extends Resource {
        String internal;
        String external;
        byte[] data;

        @Override
        public void write(OutputStream writer, int numIndent, boolean bare) {
            this.writeComments(writer, numIndent);
            this.writeIndent(writer, numIndent);
            if (this.internal == null) {
                String line = (this.name == null ? ICUResourceWriter.EMPTY : this.name) + ICUResourceWriter.COLON + ICUResourceWriter.IMPORT + ICUResourceWriter.OPENBRACE + ICUResourceWriter.QUOTE + this.external + ICUResourceWriter.QUOTE + ICUResourceWriter.CLOSEBRACE + (bare ? ICUResourceWriter.EMPTY : LINESEP);
                this.write(writer, line);
            } else {
                String line = (this.name == null ? ICUResourceWriter.EMPTY : this.name) + ICUResourceWriter.COLON + ICUResourceWriter.BIN + ICUResourceWriter.OPENBRACE + this.internal + ICUResourceWriter.CLOSEBRACE + (bare ? ICUResourceWriter.EMPTY : LINESEP);
                this.write(writer, line);
            }
        }

        @Override
        public void setSize() {
            this.size = 4 + this.data.length + 16;
        }

        @Override
        public int writeBinary(FileOutputStream out, int usedOffset) {
            int pad = 0;
            int extrapad = ICUResourceWriter.pad32(this.size);
            int dataStart = usedOffset + 4;
            try {
                if (dataStart % 16 != 0) {
                    pad = 16 - dataStart % 16;
                    out.write(ICUResourceWriter.createPadding(pad));
                    usedOffset += pad;
                }
                out.write(ICUResourceWriter.intToBytes(this.data.length));
                if (this.data.length > 0) {
                    out.write(this.data);
                }
                out.write(ICUResourceWriter.createPadding(16 - pad + extrapad));
            }
            catch (Exception e) {
                System.err.println("Had problems writing Binary Resource");
            }
            return usedOffset;
        }
    }

    public static class ResourceTable
    extends Resource {
        public String annotation;
        public static final String NO_FALLBACK = "nofallback";

        @Override
        public void write(OutputStream writer, int numIndent, boolean bare) {
            this.writeComments(writer, numIndent);
            this.writeIndent(writer, numIndent);
            if (this.annotation == null) {
                this.write(writer, this.name + ICUResourceWriter.OPENBRACE + LINESEP);
            } else {
                this.write(writer, this.name + ICUResourceWriter.COLON + ICUResourceWriter.TABLE + ICUResourceWriter.OPENPAREN + this.annotation + ICUResourceWriter.CLOSEPAREN + ICUResourceWriter.OPENBRACE + LINESEP);
            }
            ++numIndent;
            Resource current = this.first;
            while (current != null) {
                current.write(writer, numIndent, false);
                current = current.next;
            }
            this.writeIndent(writer, --numIndent);
            this.write(writer, ICUResourceWriter.CLOSEBRACE + LINESEP);
        }

        @Override
        public void sort() {
            Resource a;
            if (this.noSort) {
                return;
            }
            Resource b = new Resource();
            Resource t = a = this.first;
            while (t != null) {
                Resource u = t.next;
                Resource x = b;
                while (x.next != null && x.next.name.compareTo(t.name) <= 0) {
                    x = x.next;
                }
                t.next = x.next;
                x.next = t;
                t = u;
            }
            if (b.next != null) {
                this.first = b.next;
            }
            Resource current = this.first;
            while (current != null) {
                current.sort();
                current = current.next;
            }
        }

        public boolean is32Bit() {
            Resource current = this.first;
            boolean mustBe32 = false;
            while (current != null) {
                if (current.keyStringOffset > 65535) {
                    mustBe32 = true;
                }
                current = current.next;
            }
            return mustBe32;
        }

        @Override
        public int writeBinary(FileOutputStream out, int usedOffset) {
            int count = 0;
            Resource current = this.first;
            int[] resources = new int[this.numChildren];
            short[] keys16 = null;
            int[] keys32 = null;
            boolean is32Bit = this.is32Bit();
            if (is32Bit) {
                keys32 = new int[this.numChildren];
            } else {
                keys16 = new short[this.numChildren];
            }
            if (current != null) {
                while (current != null) {
                    if (is32Bit) {
                        keys32[count] = current.keyStringOffset;
                    } else {
                        keys16[count] = (short)current.keyStringOffset;
                    }
                    if (current instanceof ResourceInt) {
                        int value = 0;
                        try {
                            value = Integer.parseInt(((ResourceInt)current).val);
                        }
                        catch (NumberFormatException e) {
                            System.err.println("Error converting string to int: " + e.getMessage());
                            System.exit(1);
                        }
                        resources[count] = 0x70000000 | value & 0xFFFFFFF;
                    } else {
                        usedOffset = current.writeBinary(out, usedOffset);
                        if (current instanceof ResourceString) {
                            resources[count] = 0 | usedOffset >>> 2;
                        } else if (current instanceof ResourceTable) {
                            resources[count] = 0x20000000 | usedOffset >>> 2;
                        } else if (current instanceof ResourceAlias) {
                            resources[count] = 0x30000000 | usedOffset >>> 2;
                        } else if (current instanceof ResourceArray) {
                            resources[count] = Integer.MIN_VALUE | usedOffset >>> 2;
                        } else if (current instanceof ResourceIntVector) {
                            resources[count] = 0xE0000000 | usedOffset >>> 2;
                        }
                        usedOffset += current.size + ICUResourceWriter.pad32(current.size);
                    }
                    ++count;
                    current = current.next;
                }
                if (is32Bit) {
                    try {
                        out.write(ICUResourceWriter.intToBytes(count));
                        LDML2ICUBinaryWriter.written += ICUResourceWriter.intToBytes(count).length;
                        out.write(ICUResourceWriter.intArrayToBytes(keys32));
                        LDML2ICUBinaryWriter.written += ICUResourceWriter.intArrayToBytes(keys32).length;
                        out.write(ICUResourceWriter.intArrayToBytes(resources));
                        LDML2ICUBinaryWriter.written += ICUResourceWriter.intArrayToBytes(resources).length;
                    }
                    catch (IOException e) {
                        ICUResourceWriter.errIO();
                    }
                } else {
                    try {
                        out.write(ICUResourceWriter.shortToBytes((short)count));
                        LDML2ICUBinaryWriter.written += ICUResourceWriter.shortToBytes((short)count).length;
                        out.write(ICUResourceWriter.shortArrayToBytes(keys16));
                        LDML2ICUBinaryWriter.written += ICUResourceWriter.shortArrayToBytes(keys16).length;
                        int pad = ICUResourceWriter.pad32(this.size);
                        byte[] padding = ICUResourceWriter.createPadding(pad);
                        if (padding != null) {
                            out.write(padding);
                            LDML2ICUBinaryWriter.written += padding.length;
                        }
                        out.write(ICUResourceWriter.intArrayToBytes(resources));
                        LDML2ICUBinaryWriter.written += ICUResourceWriter.intArrayToBytes(resources).length;
                    }
                    catch (IOException e) {
                        ICUResourceWriter.errIO();
                    }
                }
            } else {
                short zero = 0;
                try {
                    out.write(ICUResourceWriter.shortToBytes(zero));
                    LDML2ICUBinaryWriter.written += ICUResourceWriter.shortToBytes(zero).length;
                    byte[] padding = ICUResourceWriter.createPadding(ICUResourceWriter.pad16Bytes(2));
                    if (padding != null) {
                        out.write(padding);
                        LDML2ICUBinaryWriter.written += padding.length;
                    }
                }
                catch (IOException e) {
                    ICUResourceWriter.errIO();
                }
            }
            return usedOffset;
        }

        @Override
        public void setSize() {
            int x = 0;
            Resource current = this.first;
            this.sizeOfChildren = 0;
            while (current != null) {
                ++x;
                this.sizeOfChildren += current.size + ICUResourceWriter.pad32(current.size);
                if (current instanceof ResourceTable || current instanceof ResourceArray) {
                    this.sizeOfChildren += current.sizeOfChildren;
                }
                current = current.next;
            }
            if (x > maxTableLength) {
                maxTableLength = x;
            }
            this.size = this.is32Bit() ? 4 + x * 2 * 4 : 2 + x * 6;
        }
    }

    public static class ResourceIntVector
    extends Resource {
        public String smallComment = null;

        @Override
        public void write(OutputStream writer, int numIndent, boolean bare) {
            this.writeComments(writer, numIndent);
            this.writeIndent(writer, numIndent);
            this.write(writer, this.name + ICUResourceWriter.COLON + ICUResourceWriter.INTVECTOR + ICUResourceWriter.OPENBRACE);
            if (this.smallComment != null) {
                this.write(writer, " /** " + this.smallComment + " " + ICUResourceWriter.COMMENTEND);
            }
            this.write(writer, LINESEP);
            ++numIndent;
            ResourceInt current = (ResourceInt)this.first;
            while (current != null) {
                this.writeIndent(writer, numIndent);
                this.write(writer, current.val);
                this.write(writer, ICUResourceWriter.COMMA + LINESEP);
                current = (ResourceInt)current.next;
            }
            this.writeIndent(writer, --numIndent);
            this.write(writer, ICUResourceWriter.CLOSEBRACE + LINESEP);
        }

        @Override
        public int writeBinary(FileOutputStream out, int usedOffset) {
            int count = 0;
            int[] numbers = new int[this.numChildren];
            Resource current = this.first;
            while (current != null) {
                numbers[count] = Integer.parseInt(((ResourceInt)current).val);
                ++count;
                current = current.next;
            }
            byte[] numBytes = ICUResourceWriter.intArrayToBytes(numbers);
            try {
                out.write(ICUResourceWriter.intToBytes(count));
                LDML2ICUBinaryWriter.written += ICUResourceWriter.intToBytes(count).length;
                out.write(numBytes);
                LDML2ICUBinaryWriter.written += numBytes.length;
            }
            catch (IOException e) {
                ICUResourceWriter.errIO();
            }
            return usedOffset;
        }

        @Override
        public void setSize() {
            int x = 0;
            Resource current = this.first;
            while (current != null) {
                ++x;
                current = current.next;
            }
            this.size = 4 + x * 4;
        }
    }

    public static class ResourceInt
    extends Resource {
        String val;

        @Override
        public void write(OutputStream writer, int numIndent, boolean bare) {
            this.writeComments(writer, numIndent);
            this.writeIndent(writer, numIndent);
            String line = (this.name == null ? ICUResourceWriter.EMPTY : this.name) + ICUResourceWriter.COLON + ICUResourceWriter.INTS + ICUResourceWriter.OPENBRACE + this.val + ICUResourceWriter.CLOSEBRACE;
            if (bare) {
                if (this.name != null) {
                    throw new RuntimeException("Bare option is set to true but the resource has a name: " + this.name);
                }
                this.write(writer, line);
            } else {
                this.write(writer, line + LINESEP);
            }
        }

        @Override
        public int writeBinary(FileOutputStream out, int usedOffset) {
            return usedOffset;
        }

        @Override
        public void setSize() {
            this.size = 0;
        }
    }

    public static class ResourceArray
    extends Resource {
        @Override
        public void write(OutputStream writer, int numIndent, boolean bare) {
            this.writeComments(writer, numIndent);
            this.writeIndent(writer, numIndent);
            if (this.name != null) {
                this.write(writer, this.name + ICUResourceWriter.OPENBRACE + LINESEP);
            } else {
                this.write(writer, ICUResourceWriter.OPENBRACE + LINESEP);
            }
            ++numIndent;
            Resource current = this.first;
            while (current != null) {
                current.write(writer, numIndent, true);
                if (!(current instanceof ResourceTable) && !(current instanceof ResourceArray)) {
                    this.write(writer, ICUResourceWriter.COMMA + LINESEP);
                }
                current = current.next;
            }
            this.writeIndent(writer, --numIndent);
            this.write(writer, ICUResourceWriter.CLOSEBRACE + LINESEP);
        }

        @Override
        public void sort() {
            if (this.noSort) {
                return;
            }
            Resource current = this.first;
            while (current != null) {
                current.sort();
                current = current.next;
            }
        }

        @Override
        public int writeBinary(FileOutputStream out, int usedOffset) {
            int count = 0;
            int[] resources = new int[this.numChildren];
            Resource current = this.first;
            if (current != null) {
                while (current != null) {
                    if (current instanceof ResourceInt) {
                        int value = 0;
                        try {
                            value = Integer.parseInt(((ResourceInt)current).val);
                        }
                        catch (NumberFormatException e) {
                            System.err.println("Error converting string to int: " + e.getMessage());
                            System.exit(1);
                        }
                        resources[count] = 0x70000000 | value & 0xFFFFFFF;
                    } else {
                        usedOffset = current.writeBinary(out, usedOffset);
                        if (current instanceof ResourceString) {
                            resources[count] = 0 | usedOffset >>> 2;
                        } else if (current instanceof ResourceTable) {
                            resources[count] = ((ResourceTable)current).is32Bit() ? 0x40000000 | usedOffset >>> 2 : 0x20000000 | usedOffset >>> 2;
                        } else if (current instanceof ResourceAlias) {
                            resources[count] = 0x30000000 | usedOffset >>> 2;
                        } else if (current instanceof ResourceArray) {
                            resources[count] = Integer.MIN_VALUE | usedOffset >>> 2;
                        } else if (current instanceof ResourceIntVector) {
                            resources[count] = 0xE0000000 | usedOffset >>> 2;
                        }
                        usedOffset += current.size + ICUResourceWriter.pad32(current.size);
                    }
                    ++count;
                    current = current.next;
                }
                byte[] resourceBytes = ICUResourceWriter.intArrayToBytes(resources);
                try {
                    out.write(ICUResourceWriter.intToBytes(count));
                    LDML2ICUBinaryWriter.written += ICUResourceWriter.intToBytes(count).length;
                    out.write(resourceBytes);
                    LDML2ICUBinaryWriter.written += resourceBytes.length;
                }
                catch (IOException e) {
                    ICUResourceWriter.errIO();
                }
            } else {
                try {
                    out.write(ICUResourceWriter.intToBytes(0));
                    LDML2ICUBinaryWriter.written += ICUResourceWriter.intToBytes(0).length;
                }
                catch (IOException e) {
                    ICUResourceWriter.errIO();
                }
            }
            return usedOffset;
        }

        @Override
        public void setSize() {
            int x = 0;
            Resource current = this.first;
            this.sizeOfChildren = 0;
            while (current != null) {
                ++x;
                this.sizeOfChildren += current.size + ICUResourceWriter.pad32(current.size);
                if (current instanceof ResourceTable || current instanceof ResourceArray) {
                    this.sizeOfChildren += current.sizeOfChildren;
                }
                current = current.next;
            }
            this.size = 4 + x * 4;
        }
    }

    public static class ResourceAlias
    extends Resource {
        String val;

        @Override
        public void write(OutputStream writer, int numIndent, boolean bare) {
            this.writeComments(writer, numIndent);
            this.writeIndent(writer, numIndent);
            String line = (this.name == null ? ICUResourceWriter.EMPTY : this.name) + ICUResourceWriter.COLON + ICUResourceWriter.ALIAS + ICUResourceWriter.OPENBRACE + ICUResourceWriter.QUOTE + this.escapeSyntaxChars(this.val) + ICUResourceWriter.QUOTE + ICUResourceWriter.CLOSEBRACE;
            if (bare) {
                if (this.name != null) {
                    throw new RuntimeException("Bare option is set to true but the resource has a name! " + this.name);
                }
                this.write(writer, line);
            } else {
                this.write(writer, line + LINESEP);
            }
        }

        @Override
        public int writeBinary(FileOutputStream out, int usedOffset) {
            byte[] valLenBytes = ICUResourceWriter.intToBytes(this.val.length());
            try {
                byte[] valBytes = (this.val + ICUResourceWriter.STRTERM).getBytes("UTF-16BE");
                byte[] padding = ICUResourceWriter.create32Padding(valBytes.length);
                out.write(valLenBytes);
                LDML2ICUBinaryWriter.written += valLenBytes.length;
                out.write(valBytes);
                LDML2ICUBinaryWriter.written += valBytes.length;
                if (padding != null) {
                    out.write(padding);
                    LDML2ICUBinaryWriter.written += padding.length;
                }
            }
            catch (UnsupportedEncodingException e) {
                ICUResourceWriter.errUnsupportedEncoding();
            }
            catch (IOException e) {
                ICUResourceWriter.errIO();
            }
            return usedOffset;
        }

        @Override
        public void setSize() {
            this.size = 4 + (this.val.length() + 1) * 2;
        }
    }

    public static class Resource {
        String[] note = new String[20];
        int noteLen = 0;
        String translate;
        String comment;
        public String name;
        public Resource next;
        boolean noSort = false;
        public Resource first = null;
        public int numChildren;
        public int sizeOfChildren;
        public int size;
        public int keyStringOffset;
        public boolean hasKey = true;
        public boolean isTop = false;

        public void setSize() {
            this.size = 0;
        }

        public Resource end() {
            Resource current = this;
            while (current != null) {
                if (current.next == null) {
                    return current;
                }
                current = current.next;
            }
            return current;
        }

        static final Resource addAfter(Resource list, Resource res) {
            if (list == null) {
                list = res;
            } else {
                Resource last = list.end();
                last.next = res;
            }
            return list;
        }

        public Resource addAfter(Resource res) {
            return Resource.addAfter(this, res);
        }

        public Resource replaceContents(Resource res) {
            Resource old = this.first;
            this.first = res;
            return old;
        }

        public Resource appendContents(Resource res) {
            if (this.first == null) {
                this.first = res;
            } else {
                this.first.end().next = res;
            }
            return res.end();
        }

        public boolean isEmpty() {
            return this.first == null;
        }

        public StringBuffer escapeSyntaxChars(String val) {
            if (val == null) {
                System.err.println("Resource.escapeSyntaxChars: error, resource '" + this.name + "': string value is NULL - assuming 'empty'");
                throw new MalformedResourceError("Resource.escapeSyntaxChars: error, resource '" + this.name + "': string value is NULL - assuming 'empty'", this);
            }
            char[] str = val.toCharArray();
            StringBuffer result = new StringBuffer();
            for (int i = 0; i < str.length; ++i) {
                switch (str[i]) {
                    case '\"': {
                        result.append('\\');
                    }
                }
                result.append(str[i]);
            }
            return result;
        }

        public void write(OutputStream writer, int numIndent, boolean bare) {
            while (this.next != null) {
                this.next.write(writer, numIndent + 1, false);
            }
        }

        public void writeIndent(OutputStream writer, int numIndent) {
            for (int i = 0; i < numIndent; ++i) {
                this.write(writer, ICUResourceWriter.INDENT);
            }
        }

        public int writeBinary(FileOutputStream out, int usedOffset) {
            System.err.println("Unexpected type: " + this.getClass().toString());
            System.err.println("Resource Name: " + this.name);
            return usedOffset;
        }

        public void write(OutputStream writer, String value) {
            try {
                byte[] bytes = value.getBytes(ICUResourceWriter.CHARSET);
                writer.write(bytes, 0, bytes.length);
            }
            catch (Exception e) {
                System.err.println(e);
                System.exit(1);
            }
        }

        public void writeComments(OutputStream writer, int numIndent) {
            if (this.comment != null || this.translate != null || this.noteLen > 0) {
                this.writeIndent(writer, numIndent);
                this.write(writer, ICUResourceWriter.COMMENTSTART + LINESEP);
                if (this.comment != null) {
                    int index = this.comment.indexOf(10);
                    if (index > -1) {
                        StringBuffer indent = new StringBuffer("\n");
                        for (int i = 0; i < numIndent; ++i) {
                            indent.append(ICUResourceWriter.INDENT);
                        }
                        indent.append(ICUResourceWriter.COMMENTMIDDLE);
                        this.comment = this.comment.replaceAll("\n", indent.toString());
                    }
                    this.writeIndent(writer, numIndent);
                    this.write(writer, ICUResourceWriter.COMMENTMIDDLE);
                    this.write(writer, this.comment);
                    this.write(writer, LINESEP);
                }
                this.writeIndent(writer, numIndent);
                this.write(writer, ICUResourceWriter.COMMENTEND + LINESEP);
            }
        }

        public void sort() {
        }

        public void swap() {
        }

        boolean findResourcePath(StringBuffer str, Resource res) {
            if (this.name != null) {
                str.append(this.name);
            }
            if (res == this) {
                return true;
            }
            str.append('/');
            int n = 0;
            int oldLen = str.length();
            Resource child = this.first;
            while (child != null) {
                if (child.name == null) {
                    str.append("#" + n);
                }
                if (child.findResourcePath(str, res)) {
                    return true;
                }
                ++n;
                str.setLength(oldLen);
                child = child.next;
            }
            return false;
        }

        String findResourcePath(Resource res) {
            if (this.next != null) {
                throw new IllegalArgumentException("Don't call findResourcePath(Resource res) on resources which have siblings");
            }
            StringBuffer str = new StringBuffer();
            if (this.findResourcePath(str, res)) {
                return str.toString();
            }
            return null;
        }

        public class MalformedResourceError
        extends Error {
            private static final long serialVersionUID = -5943014701317383613L;
            public Resource offendingResource;

            public MalformedResourceError(String str, Resource res) {
                super(str);
                this.offendingResource = res;
            }
        }
    }
}

