/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.json;

import com.google.common.base.Joiner;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.stream.JsonWriter;
import com.ibm.icu.text.UTF16;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.draft.ScriptMetadata;
import org.unicode.cldr.json.CldrItem;
import org.unicode.cldr.json.CldrNode;
import org.unicode.cldr.json.LdmlConvertRules;
import org.unicode.cldr.tool.Option;
import org.unicode.cldr.util.Annotations;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.CLDRTool;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.CoverageInfo;
import org.unicode.cldr.util.DtdData;
import org.unicode.cldr.util.DtdType;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.FileProcessor;
import org.unicode.cldr.util.Level;
import org.unicode.cldr.util.LocaleIDParser;
import org.unicode.cldr.util.PatternCache;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.XPathParts;

@CLDRTool(alias="ldml2json", description="Convert CLDR data to JSON")
public class Ldml2JsonConverter {
    private static boolean DEBUG = false;
    private static final StandardCodes sc = StandardCodes.make();
    private Set<String> defaultContentLocales = SupplementalDataInfo.getInstance().getDefaultContentLocales();
    private Set<String> skippedDefaultContentLocales = new TreeSet<String>();
    private availableLocales avl = new availableLocales();
    private Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private static final Option.Options options = new Option.Options("Usage: LDML2JsonConverter [OPTIONS] [FILES]\nThis program converts CLDR data to the JSON format.\nPlease refer to the following options. \n\texample: org.unicode.cldr.json.Ldml2JsonConverter -c xxx -d yyy").add("commondir", Character.valueOf('c'), ".*", CLDRPaths.COMMON_DIRECTORY, "Common directory for CLDR files, defaults to CldrUtility.COMMON_DIRECTORY").add("destdir", Character.valueOf('d'), ".*", CLDRPaths.GEN_DIRECTORY, "Destination directory for output files, defaults to CldrUtility.GEN_DIRECTORY").add("match", Character.valueOf('m'), ".*", ".*", "Regular expression to define only specific locales or files to be generated").add("type", Character.valueOf('t'), "(main|supplemental|segments|rbnf|annotations|annotationsDerived)", "main", "Type of CLDR data being generated, main, supplemental, or segments.").add("resolved", Character.valueOf('r'), "(true|false)", "false", "Whether the output JSON for the main directory should be based on resolved or unresolved data").add("draftstatus", Character.valueOf('s'), "(approved|contributed|provisional|unconfirmed)", "unconfirmed", "The minimum draft status of the output data").add("coverage", Character.valueOf('l'), "(minimal|basic|moderate|modern|comprehensive|optional)", "optional", "The maximum coverage level of the output data").add("fullnumbers", Character.valueOf('n'), "(true|false)", "false", "Whether the output JSON should output data for all numbering systems, even those not used in the locale").add("other", Character.valueOf('o'), "(true|false)", "false", "Whether to write out the 'other' section, which contains any unmatched paths").add("packages", Character.valueOf('p'), "(true|false)", "false", "Whether to group data files into installable packages").add("identity", Character.valueOf('i'), "(true|false)", "true", "Whether to copy the identity info into all sections containing data").add("konfig", Character.valueOf('k'), ".*", null, "LDML to JSON configuration file");
    private String cldrCommonDir;
    private String outputDir;
    private boolean fullNumbers;
    private boolean resolve;
    private String match;
    private int coverageValue;
    private boolean writePackages;
    private RunType type;
    private Map<String, String> dependencies;
    private List<JSONSection> sections;
    private Set<String> packages;
    static final Pattern ANNOTATION_CP_REMAP = PatternCache.get("^(.*)\\[@cp=\"(\\[|\\]|'|\"|@|/|=)\"\\](.*)$");
    private static final Pattern escapePattern = PatternCache.get("\\\\(?!u)");

    public static void main(String[] args) throws Exception {
        options.parse(args, true);
        Ldml2JsonConverter l2jc = new Ldml2JsonConverter(options.get("commondir").getValue(), options.get("destdir").getValue(), options.get("type").getValue(), Boolean.parseBoolean(options.get("fullnumbers").getValue()), Boolean.parseBoolean(options.get("resolved").getValue()), options.get("coverage").getValue(), options.get("match").getValue(), Boolean.parseBoolean(options.get("packages").getValue()), options.get("konfig").getValue());
        long start = System.currentTimeMillis();
        CLDRFile.DraftStatus status = CLDRFile.DraftStatus.valueOf(options.get("draftstatus").getValue());
        l2jc.processDirectory(options.get("type").getValue(), status);
        long end = System.currentTimeMillis();
        System.out.println("Finished in " + (end - start) + " ms");
    }

    public Ldml2JsonConverter(String cldrDir, String outputDir, String runType, boolean fullNumbers, boolean resolve, String coverage, String match, boolean writePackages, String configFile) {
        this.cldrCommonDir = cldrDir;
        this.outputDir = outputDir;
        this.type = RunType.valueOf(runType);
        this.fullNumbers = fullNumbers;
        this.resolve = resolve;
        this.match = match;
        this.writePackages = writePackages;
        this.coverageValue = Level.get(coverage).getLevel();
        this.sections = new ArrayList<JSONSection>();
        this.packages = new TreeSet<String>();
        this.dependencies = new HashMap<String, String>();
        FileProcessor myReader = new FileProcessor(){

            @Override
            protected boolean handleLine(int lineCount, String line) {
                String[] lineParts = line.trim().split("\\s*;\\s*");
                String section = null;
                String path = null;
                String packageName = null;
                String dependency = null;
                boolean hasSection = false;
                boolean hasPath = false;
                boolean hasPackage = false;
                boolean hasDependency = false;
                for (String linePart : lineParts) {
                    int pos = linePart.indexOf(61);
                    if (pos < 0) {
                        throw new IllegalArgumentException();
                    }
                    String key = linePart.substring(0, pos);
                    String value = linePart.substring(pos + 1);
                    if (key.equals("section")) {
                        hasSection = true;
                        section = value;
                        continue;
                    }
                    if (key.equals("path")) {
                        hasPath = true;
                        path = value;
                        continue;
                    }
                    if (key.equals("package")) {
                        hasPackage = true;
                        packageName = value;
                        continue;
                    }
                    if (!key.equals("dependency")) continue;
                    hasDependency = true;
                    dependency = value;
                }
                if (hasSection && hasPath) {
                    JSONSection j = new JSONSection();
                    j.section = section;
                    j.pattern = PatternCache.get(path);
                    if (hasPackage) {
                        j.packageName = packageName;
                    }
                    Ldml2JsonConverter.this.sections.add(j);
                }
                if (hasDependency && hasPackage) {
                    Ldml2JsonConverter.this.dependencies.put(packageName, dependency);
                }
                return true;
            }
        };
        if (configFile != null) {
            myReader.process(configFile);
        } else {
            switch (this.type) {
                case main: {
                    myReader.process(Ldml2JsonConverter.class, "JSON_config.txt");
                    break;
                }
                case supplemental: {
                    myReader.process(Ldml2JsonConverter.class, "JSON_config_supplemental.txt");
                    break;
                }
                case segments: {
                    myReader.process(Ldml2JsonConverter.class, "JSON_config_segments.txt");
                    break;
                }
                case rbnf: {
                    myReader.process(Ldml2JsonConverter.class, "JSON_config_rbnf.txt");
                    break;
                }
                default: {
                    myReader.process(Ldml2JsonConverter.class, "JSON_config_" + this.type.name() + ".txt");
                }
            }
        }
        JSONSection j = new JSONSection();
        j.section = "other";
        j.pattern = PatternCache.get(".*");
        this.sections.add(j);
    }

    private String transformPath(String pathStr, String pathPrefix) {
        String result = pathStr;
        Matcher cpm = ANNOTATION_CP_REMAP.matcher(result);
        if (cpm.matches()) {
            String badCodepointRange = cpm.group(2);
            StringBuilder sb = new StringBuilder(cpm.group(1)).append("[@cp=\"");
            if (badCodepointRange.codePointCount(0, badCodepointRange.length()) != 1) {
                throw new IllegalArgumentException("Need exactly one codepoint in the @cp string, but got " + badCodepointRange + " in xpath " + pathStr);
            }
            badCodepointRange.codePoints().forEach(cp -> sb.append("U+").append(Integer.toHexString(cp).toUpperCase()));
            sb.append("\"]").append(cpm.group(3));
            result = sb.toString();
        }
        if (DEBUG) {
            System.out.println(" IN pathStr : " + result);
        }
        for (int i = 0; i < LdmlConvertRules.PATH_TRANSFORMATIONS.length; ++i) {
            Matcher m3 = LdmlConvertRules.PATH_TRANSFORMATIONS[i].pattern.matcher(result);
            if (!m3.matches()) continue;
            if (DEBUG) {
                System.out.println(LdmlConvertRules.PATH_TRANSFORMATIONS[i].pattern);
            }
            result = m3.replaceFirst(LdmlConvertRules.PATH_TRANSFORMATIONS[i].replacement);
            break;
        }
        result = result.replaceFirst("/ldml/", pathPrefix);
        if ((result = result.replaceFirst("/supplementalData/", pathPrefix)).contains("languages") || result.contains("languageAlias") || result.contains("languageMatches") || result.contains("likelySubtags") || result.contains("parentLocale") || result.contains("locales=")) {
            result = result.replaceAll("_", "-");
        }
        if (DEBUG) {
            System.out.println("OUT pathStr : " + result);
        }
        if (DEBUG) {
            System.out.println("result: " + result);
        }
        return result;
    }

    private Map<JSONSection, List<CldrItem>> mapPathsToSections(AtomicInteger readCount, int totalCount, CLDRFile file, String pathPrefix, SupplementalDataInfo sdi) throws IOException, ParseException {
        TreeMap<JSONSection, List<CldrItem>> sectionItems = new TreeMap<JSONSection, List<CldrItem>>();
        String locID = file.getLocaleID();
        Matcher noNumberingSystemMatcher = LdmlConvertRules.NO_NUMBERING_SYSTEM_PATTERN.matcher("");
        Matcher numberingSystemMatcher = LdmlConvertRules.NUMBERING_SYSTEM_PATTERN.matcher("");
        Matcher rootIdentityMatcher = LdmlConvertRules.ROOT_IDENTITY_PATTERN.matcher("");
        TreeSet<String> activeNumberingSystems = new TreeSet<String>();
        activeNumberingSystems.add("latn");
        for (String np : LdmlConvertRules.ACTIVE_NUMBERING_SYSTEM_XPATHS) {
            String ns = file.getWinningValue(np);
            if (ns == null || ns.length() <= 0) continue;
            activeNumberingSystems.add(ns);
        }
        DtdType fileDtdType = CLDRFile.isSupplementalName(locID) ? DtdType.supplementalData : DtdType.ldml;
        CoverageInfo covInfo = CLDRConfig.getInstance().getCoverageInfo();
        Iterator<String> it = file.iterator("", DtdData.getInstance(fileDtdType).getDtdComparator(null));
        block1: while (it.hasNext()) {
            XPathParts xpp;
            String currentNS;
            int cv = Level.UNDETERMINED.getLevel();
            String path = it.next();
            String fullPath = file.getFullXPath(path);
            String value = file.getWinningValue(path);
            if (path.startsWith("//ldml/localeDisplayNames/languages") && file.getSourceLocaleID(path, null).equals("code-fallback")) {
                value = file.getConstructedBaileyValue(path, null, null);
            }
            if (fullPath == null) {
                fullPath = path;
            }
            if (!CLDRFile.isSupplementalName(locID) && path.startsWith("//ldml/") && !path.contains("/identity")) {
                cv = covInfo.getCoverageValue(path, locID);
            }
            if (cv > this.coverageValue) continue;
            rootIdentityMatcher.reset(fullPath);
            if (rootIdentityMatcher.matches() && !"root".equals(locID)) continue;
            noNumberingSystemMatcher.reset(fullPath);
            if (noNumberingSystemMatcher.matches()) continue;
            numberingSystemMatcher.reset(fullPath);
            if (numberingSystemMatcher.matches() && !this.fullNumbers && (currentNS = (xpp = XPathParts.getFrozenInstance(fullPath)).getAttributeValue(2, "numberSystem")) != null && !activeNumberingSystems.contains(currentNS) || this.resolve && CldrUtility.NO_INHERITANCE_MARKER.equals(value)) continue;
            String transformedPath = this.transformPath(path, pathPrefix);
            String transformedFullPath = this.transformPath(fullPath, pathPrefix);
            if (transformedPath.isEmpty()) continue;
            for (JSONSection js : this.sections) {
                if (!js.pattern.matcher(transformedPath).matches()) continue;
                CldrItem item = new CldrItem(transformedPath, transformedFullPath, path, fullPath, value);
                ArrayList<CldrItem> cldrItems = (ArrayList<CldrItem>)sectionItems.get(js);
                if (cldrItems == null) {
                    cldrItems = new ArrayList<CldrItem>();
                }
                cldrItems.add(item);
                sectionItems.put(js, cldrItems);
                continue block1;
            }
        }
        Matcher versionInfoMatcher = PatternCache.get(".*/(identity|version).*").matcher("");
        JSONSection otherSection = this.sections.get(this.sections.size() - 1);
        List others = (List)sectionItems.get(otherSection);
        if (others == null) {
            return sectionItems;
        }
        ArrayList otherSectionItems = new ArrayList(others);
        int addedItemCount = 0;
        boolean copyIdentityInfo = Boolean.parseBoolean(options.get("identity").getValue());
        for (CldrItem item : otherSectionItems) {
            String thisPath = item.getPath();
            versionInfoMatcher.reset(thisPath);
            if (!versionInfoMatcher.matches()) continue;
            for (JSONSection js : this.sections) {
                List hit;
                if (sectionItems.get(js) != null && !js.section.equals("other") && copyIdentityInfo) {
                    hit = (List)sectionItems.get(js);
                    hit.add(addedItemCount, item);
                    sectionItems.put(js, hit);
                }
                if (!js.section.equals("other")) continue;
                hit = (List)sectionItems.get(js);
                hit.remove(item);
                sectionItems.put(js, hit);
            }
            ++addedItemCount;
        }
        return sectionItems;
    }

    private void convertCldrItems(AtomicInteger readCount, int totalCount, String dirName, String filename, String pathPrefix, Map<JSONSection, List<CldrItem>> sectionItems) throws IOException, ParseException {
        for (JSONSection js : this.sections) {
            File dir;
            String outFilename = this.type == RunType.rbnf ? filename.replaceAll("_", "-") + ".json" : js.section + ".json";
            String tier = "";
            boolean writeOther = Boolean.parseBoolean(options.get("other").getValue());
            if (js.section.equals("other") && !writeOther) continue;
            StringBuilder outputDirname = new StringBuilder(this.outputDir);
            if (this.writePackages) {
                if (this.type != RunType.supplemental && this.type != RunType.rbnf) {
                    LocaleIDParser lp = new LocaleIDParser();
                    lp.set(filename);
                    if (this.defaultContentLocales.contains(filename) && lp.getRegion().length() > 0) {
                        if (this.type != RunType.main) continue;
                        this.skippedDefaultContentLocales.add(filename.replaceAll("_", "-"));
                        continue;
                    }
                    Level localeCoverageLevel = sc.getLocaleCoverageLevel("Cldr", filename);
                    if (localeCoverageLevel == Level.MODERN || filename.equals("root")) {
                        tier = "-modern";
                        if (this.type == RunType.main) {
                            this.avl.modern.add(filename.replaceAll("_", "-"));
                        }
                    } else {
                        tier = "-full";
                    }
                    if (this.type == RunType.main) {
                        this.avl.full.add(filename.replaceAll("_", "-"));
                    }
                } else if (this.type == RunType.rbnf) {
                    js.packageName = "rbnf";
                    tier = "";
                }
                if (js.packageName != null) {
                    String packageName = "cldr-" + js.packageName + tier;
                    outputDirname.append("/" + packageName);
                    this.packages.add(packageName);
                }
                outputDirname.append("/" + dirName + "/");
                if (this.type != RunType.supplemental && this.type != RunType.rbnf) {
                    outputDirname.append(filename.replaceAll("_", "-"));
                }
                if (DEBUG) {
                    System.out.println("outDir: " + outputDirname);
                    System.out.println("pack: " + js.packageName);
                    System.out.println("dir: " + dirName);
                }
            } else {
                outputDirname.append("/" + filename);
            }
            if (!(dir = new File(outputDirname.toString())).exists()) {
                dir.mkdirs();
            }
            ArrayList<String> outputDirs = new ArrayList<String>();
            outputDirs.add(outputDirname.toString());
            if (this.writePackages && this.type == RunType.main && tier.equals("-modern")) {
                outputDirs.add(outputDirname.toString().replaceFirst("-modern", "-full"));
            }
            for (String outputDir : outputDirs) {
                List<CldrItem> theItems = sectionItems.get(js);
                if (theItems == null || theItems.size() == 0) {
                    System.out.println(">" + this.progressPrefix(readCount, totalCount) + outputDir + " - no items to write");
                    continue;
                }
                System.out.println("?" + this.progressPrefix(readCount, totalCount) + outputDir + " - " + theItems.size() + " item(s) to write.");
                PrintWriter outf = FileUtilities.openUTF8Writer(outputDir, outFilename);
                JsonWriter out = new JsonWriter(outf);
                out.setIndent("  ");
                ArrayList<CldrItem> sortingItems = new ArrayList<CldrItem>();
                ArrayList<CldrItem> arrayItems = new ArrayList<CldrItem>();
                ArrayList<CldrNode> nodesForLastItem = new ArrayList<CldrNode>();
                String lastLeadingArrayItemPath = null;
                String leadingArrayItemPath = "";
                int valueCount = 0;
                String previousIdentityPath = null;
                for (CldrItem item : theItems) {
                    CldrItem[] items;
                    String fullpath;
                    if (item.getPath().isEmpty()) {
                        throw new IllegalArgumentException("empty xpath in " + filename + " section " + js.packageName + "/" + js.section);
                    }
                    if (this.type == RunType.rbnf) {
                        item.setValue(item.getValue().replace('\u2192', '>'));
                        item.setValue(item.getValue().replace('\u2190', '<'));
                        if (item.getFullPath().contains("@value")) {
                            int indexStart = item.getFullPath().indexOf("@value") + 8;
                            int indexEnd = item.getFullPath().indexOf("]", indexStart) - 1;
                            if (indexStart >= 0 && indexEnd >= 0 && indexEnd > indexStart) {
                                String sub = item.getFullPath().substring(indexStart, indexEnd);
                                item.setFullPath(item.getFullPath().replace(sub, item.getValue()));
                                item.setFullPath(item.getFullPath().replaceAll("@value", "@" + sub));
                                item.setValue("");
                            }
                        }
                    }
                    if (this.type == RunType.rbnf && (fullpath = item.getFullPath()).contains("/ruleset")) {
                        int ruleStartIndex = fullpath.indexOf("/ruleset[");
                        String checkString = fullpath.substring(ruleStartIndex);
                        int ruleEndIndex = 0;
                        if (checkString.contains("/")) {
                            ruleEndIndex = fullpath.indexOf("/", ruleStartIndex + 1);
                        }
                        if (ruleEndIndex > ruleStartIndex) {
                            String oldRulePath = fullpath.substring(ruleStartIndex, ruleEndIndex);
                            String newRulePath = oldRulePath;
                            if (newRulePath.contains("@type")) {
                                int typeIndexStart = newRulePath.indexOf("\"", newRulePath.indexOf("@type"));
                                int typeIndexEnd = newRulePath.indexOf("\"", typeIndexStart + 1);
                                String type = newRulePath.substring(typeIndexStart + 1, typeIndexEnd);
                                String newType = "";
                                newType = newRulePath.contains("@access") ? "%%" + type : "%" + type;
                                newRulePath = newRulePath.replace(type, newType);
                                item.setPath(item.getPath().replace(type, newType));
                            }
                            fullpath = fullpath.replace(oldRulePath, newRulePath);
                            item.setFullPath(fullpath);
                        }
                    }
                    if (item.getPath().contains("/identity/")) {
                        String[] parts = item.getPath().split("\\[");
                        if (parts[0].equals(previousIdentityPath)) continue;
                        XPathParts xpp = XPathParts.getFrozenInstance(item.getPath());
                        String territory = xpp.findAttributeValue("territory", "type");
                        LocaleIDParser lp = new LocaleIDParser().set(filename);
                        if (territory != null && territory.length() > 0 && !territory.equals(lp.getRegion())) continue;
                        previousIdentityPath = parts[0];
                    }
                    if ((items = item.split()) == null) {
                        items = new CldrItem[]{item};
                    }
                    valueCount += items.length;
                    for (CldrItem newItem : items) {
                        if (newItem.isAliasItem()) {
                            --valueCount;
                        }
                        if (newItem.needsSort()) {
                            this.resolveArrayItems(out, nodesForLastItem, arrayItems);
                            sortingItems.add(newItem);
                            continue;
                        }
                        Matcher matcher = LdmlConvertRules.ARRAY_ITEM_PATTERN.matcher(newItem.getPath());
                        if (matcher.matches()) {
                            this.resolveSortingItems(out, nodesForLastItem, sortingItems);
                            leadingArrayItemPath = matcher.group(1);
                            if (lastLeadingArrayItemPath != null && !lastLeadingArrayItemPath.equals(leadingArrayItemPath)) {
                                this.resolveArrayItems(out, nodesForLastItem, arrayItems);
                            }
                            lastLeadingArrayItemPath = leadingArrayItemPath;
                            arrayItems.add(newItem);
                            continue;
                        }
                        this.resolveSortingItems(out, nodesForLastItem, sortingItems);
                        this.resolveArrayItems(out, nodesForLastItem, arrayItems);
                        this.outputCldrItem(out, nodesForLastItem, newItem);
                        lastLeadingArrayItemPath = "";
                    }
                }
                this.resolveSortingItems(out, nodesForLastItem, sortingItems);
                this.resolveArrayItems(out, nodesForLastItem, arrayItems);
                System.out.println(">" + this.progressPrefix(readCount, totalCount) + String.format(".../%s/%s\t= %d values", dir.getPath().substring(this.outputDir.length() + 1), outFilename, valueCount));
                this.closeNodes(out, nodesForLastItem.size() - 2, 0);
                outf.println();
                out.close();
            }
        }
    }

    public void writePackagingFiles(String outputDir, String packageName) throws IOException {
        this.writePackageJson(outputDir, packageName);
        this.writeBowerJson(outputDir, packageName);
    }

    public void writeBasicInfo(JsonObject obj, String packageName, boolean isNPM) {
        obj.addProperty("name", packageName);
        String versionString = "38.1";
        while (versionString.split("\\.").length < 3) {
            versionString = versionString + ".0";
        }
        obj.addProperty("version", versionString);
        String[] packageNameParts = packageName.split("-");
        String dependency = this.dependencies.get(packageNameParts[1]);
        if (dependency != null) {
            String[] dependentPackageNames = new String[1];
            String tier = packageNameParts[packageNameParts.length - 1];
            dependentPackageNames[0] = dependency.equals("core") ? "cldr-core" : "cldr-" + dependency + "-" + tier;
            JsonObject dependencies = new JsonObject();
            for (String dependentPackageName : dependentPackageNames) {
                if (dependentPackageName == null) continue;
                dependencies.addProperty(dependentPackageName, versionString);
            }
            obj.add(isNPM ? "peerDependencies" : "dependencies", dependencies);
        }
    }

    public void writePackageJson(String outputDir, String packageName) throws IOException {
        PrintWriter outf = FileUtilities.openUTF8Writer(outputDir + "/" + packageName, "package.json");
        System.out.println("Creating packaging file => " + outputDir + File.separator + packageName + File.separator + "package.json");
        JsonObject obj = new JsonObject();
        this.writeBasicInfo(obj, packageName, true);
        JsonArray maintainers = new JsonArray();
        JsonObject primaryMaintainer = new JsonObject();
        obj.addProperty("homepage", "http://cldr.unicode.org");
        obj.addProperty("author", "The Unicode Consortium");
        primaryMaintainer.addProperty("name", "John Emmons");
        primaryMaintainer.addProperty("email", "emmo@us.ibm.com");
        primaryMaintainer.addProperty("url", "https://github.com/JCEmmons");
        maintainers.add(primaryMaintainer);
        obj.add("maintainers", maintainers);
        JsonObject repository = new JsonObject();
        repository.addProperty("type", "git");
        repository.addProperty("url", "git://github.com/unicode-cldr/" + packageName + ".git");
        obj.add("repository", repository);
        obj.addProperty("license", "Unicode-DFS-2016");
        obj.addProperty("bugs", "https://unicode-org.atlassian.net/projects/CLDR/issues");
        outf.println(this.gson.toJson(obj));
        outf.close();
    }

    public void writeBowerJson(String outputDir, String packageName) throws IOException {
        PrintWriter outf = FileUtilities.openUTF8Writer(outputDir + "/" + packageName, "bower.json");
        System.out.println("Creating packaging file => " + outputDir + File.separator + packageName + File.separator + "bower.json");
        JsonObject obj = new JsonObject();
        this.writeBasicInfo(obj, packageName, false);
        if (this.type == RunType.supplemental) {
            JsonArray mainPaths = new JsonArray();
            mainPaths.add(new JsonPrimitive("availableLocales.json"));
            mainPaths.add(new JsonPrimitive("defaultContent.json"));
            mainPaths.add(new JsonPrimitive("scriptMetadata.json"));
            mainPaths.add(new JsonPrimitive(this.type.toString() + "/*.json"));
            obj.add("main", mainPaths);
        } else if (this.type == RunType.rbnf) {
            obj.addProperty("main", this.type.toString() + "/*.json");
        } else {
            obj.addProperty("main", this.type.toString() + "/**/*.json");
        }
        JsonArray ignorePaths = new JsonArray();
        ignorePaths.add(new JsonPrimitive(".gitattributes"));
        ignorePaths.add(new JsonPrimitive("README.md"));
        obj.add("ignore", ignorePaths);
        outf.println(this.gson.toJson(obj));
        outf.close();
    }

    public void writeDefaultContent(String outputDir) throws IOException {
        PrintWriter outf = FileUtilities.openUTF8Writer(outputDir + "/cldr-core", "defaultContent.json");
        System.out.println("Creating packaging file => " + outputDir + "cldr-core" + File.separator + "defaultContent.json");
        JsonObject obj = new JsonObject();
        obj.add("defaultContent", this.gson.toJsonTree(this.skippedDefaultContentLocales));
        outf.println(this.gson.toJson(obj));
        outf.close();
    }

    public void writeAvailableLocales(String outputDir) throws IOException {
        PrintWriter outf = FileUtilities.openUTF8Writer(outputDir + "/cldr-core", "availableLocales.json");
        System.out.println("Creating packaging file => " + outputDir + "cldr-core" + File.separator + "availableLocales.json");
        JsonObject obj = new JsonObject();
        obj.add("availableLocales", this.gson.toJsonTree(this.avl));
        outf.println(this.gson.toJson(obj));
        outf.close();
    }

    public void writeScriptMetadata(String outputDir) throws IOException {
        PrintWriter outf = FileUtilities.openUTF8Writer(outputDir + "/cldr-core", "scriptMetadata.json");
        System.out.println("Creating script metadata file => " + outputDir + File.separator + "cldr-core" + File.separator + "scriptMetadata.json");
        TreeMap<String, ScriptMetadata.Info> scriptInfo = new TreeMap<String, ScriptMetadata.Info>();
        for (String script : ScriptMetadata.getScripts()) {
            ScriptMetadata.Info i = ScriptMetadata.getInfo(script);
            scriptInfo.put(script, i);
        }
        if (ScriptMetadata.errors.size() > 0) {
            System.err.println(Joiner.on("\n\t").join(ScriptMetadata.errors));
        }
        JsonObject obj = new JsonObject();
        obj.add("scriptMetadata", this.gson.toJsonTree(scriptInfo));
        outf.println(this.gson.toJson(obj));
        outf.close();
    }

    private void resolveSortingItems(JsonWriter out, ArrayList<CldrNode> nodesForLastItem, ArrayList<CldrItem> sortingItems) throws IOException, ParseException {
        ArrayList<CldrItem> arrayItems = new ArrayList<CldrItem>();
        String lastLeadingArrayItemPath = null;
        if (!sortingItems.isEmpty()) {
            Collections.sort(sortingItems);
            for (CldrItem item : sortingItems) {
                Matcher matcher = LdmlConvertRules.ARRAY_ITEM_PATTERN.matcher(item.getPath());
                if (matcher.matches()) {
                    String leadingArrayItemPath = matcher.group(1);
                    if (lastLeadingArrayItemPath != null && !lastLeadingArrayItemPath.equals(leadingArrayItemPath)) {
                        this.resolveArrayItems(out, nodesForLastItem, arrayItems);
                    }
                    lastLeadingArrayItemPath = leadingArrayItemPath;
                    arrayItems.add(item);
                    continue;
                }
                this.outputCldrItem(out, nodesForLastItem, item);
            }
            sortingItems.clear();
            this.resolveArrayItems(out, nodesForLastItem, arrayItems);
        }
    }

    private void resolveArrayItems(JsonWriter out, ArrayList<CldrNode> nodesForLastItem, ArrayList<CldrItem> arrayItems) throws IOException, ParseException {
        boolean rbnfFlag = false;
        if (!arrayItems.isEmpty()) {
            CldrItem firstItem = arrayItems.get(0);
            if (firstItem.needsSort()) {
                Collections.sort(arrayItems);
                firstItem = arrayItems.get(0);
            }
            int arrayLevel = this.getArrayIndentLevel(firstItem);
            this.outputStartArray(out, nodesForLastItem, firstItem, arrayLevel);
            for (int len = nodesForLastItem.size(); len > arrayLevel; --len) {
                nodesForLastItem.remove(len - 1);
            }
            if (arrayItems.get(0).getFullPath().contains("rbnfrule")) {
                rbnfFlag = true;
                out.beginObject();
            }
            for (CldrItem insideItem : arrayItems) {
                this.outputArrayItem(out, insideItem, nodesForLastItem, arrayLevel);
            }
            if (rbnfFlag) {
                out.endObject();
            }
            arrayItems.clear();
            int lastLevel = nodesForLastItem.size() - 1;
            this.closeNodes(out, lastLevel, arrayLevel);
            if (!rbnfFlag) {
                out.endArray();
            }
            for (int i = arrayLevel - 1; i < lastLevel; ++i) {
                nodesForLastItem.remove(i);
            }
        }
    }

    private int getArrayIndentLevel(CldrItem item) throws ParseException {
        Matcher matcher = LdmlConvertRules.ARRAY_ITEM_PATTERN.matcher(item.getPath());
        if (!matcher.matches()) {
            System.out.println("No match found for " + item.getPath() + ", this shouldn't happen.");
            return 0;
        }
        String leadingPath = matcher.group(1);
        CldrItem fakeItem = new CldrItem(leadingPath, leadingPath, leadingPath, leadingPath, "");
        return fakeItem.getNodesInPath().size() - 1;
    }

    private void outputStartArray(JsonWriter out, ArrayList<CldrNode> nodesForLastItem, CldrItem item, int arrayLevel) throws IOException, ParseException {
        int i;
        ArrayList<CldrNode> nodesInPath = item.getNodesInPath();
        this.closeNodes(out, nodesForLastItem.size() - 2, i);
        for (i = this.findFirstDiffNodeIndex(nodesForLastItem, nodesInPath); i < arrayLevel - 1; ++i) {
            this.startNonleafNode(out, nodesInPath.get(i), i);
        }
        String objName = nodesInPath.get(i).getNodeKeyName();
        out.name(objName);
        if (!item.getFullPath().contains("rbnfrule")) {
            out.beginArray();
        }
    }

    private void outputCldrItem(JsonWriter out, ArrayList<CldrNode> nodesForLastItem, CldrItem item) throws IOException, ParseException {
        if (item.isAliasItem()) {
            return;
        }
        ArrayList<CldrNode> nodesInPath = item.getNodesInPath();
        int arraySize = nodesInPath.size();
        int i = this.findFirstDiffNodeIndex(nodesForLastItem, nodesInPath);
        if (i == nodesInPath.size() && this.type != RunType.rbnf) {
            System.err.println("This nodes and last nodes has identical path. (" + item.getPath() + ") Some distinguishing attributes wrongly removed?");
            return;
        }
        this.closeNodes(out, nodesForLastItem.size() - 2, i);
        while (i < nodesInPath.size() - 1) {
            this.startNonleafNode(out, nodesInPath.get(i), i);
            ++i;
        }
        this.writeLeafNode(out, nodesInPath.get(i), item.getValue(), i);
        nodesForLastItem.clear();
        nodesForLastItem.addAll(nodesInPath);
    }

    private void closeNodes(JsonWriter out, int last, int firstDiff) throws IOException {
        for (int i = last; i >= firstDiff; --i) {
            if (i == 0) {
                out.endObject();
                break;
            }
            out.endObject();
        }
    }

    private void startNonleafNode(JsonWriter out, CldrNode node, int level) throws IOException {
        String objName = node.getNodeKeyName();
        if (objName == null) {
            return;
        }
        if (level == 0) {
            out.beginObject();
            return;
        }
        Map<String, String> attrAsValueMap = node.getAttrAsValueMap();
        if (this.type == RunType.annotations || this.type == RunType.annotationsDerived) {
            if (objName.startsWith("U+")) {
                out.name(UTF16.valueOf(Integer.parseInt(objName.substring(2), 16)));
            } else {
                out.name(objName);
            }
        } else {
            out.name(objName);
        }
        out.beginObject();
        for (String key : attrAsValueMap.keySet()) {
            String value = this.escapeValue(attrAsValueMap.get(key));
            out.name("_" + key).value(value);
        }
    }

    private void outputArrayItem(JsonWriter out, CldrItem item, ArrayList<CldrNode> nodesForLastItem, int arrayLevel) throws IOException, ParseException {
        ArrayList<CldrNode> nodesInPath = item.getNodesInPath();
        String value = this.escapeValue(item.getValue());
        int nodesNum = nodesInPath.size();
        int diff = this.findFirstDiffNodeIndex(nodesForLastItem, nodesInPath);
        if (diff > arrayLevel) {
            this.closeNodes(out, nodesForLastItem.size() - 1, diff + 1);
            for (int i = diff; i < nodesNum - 1; ++i) {
                this.startNonleafNode(out, nodesInPath.get(i), i + 1);
            }
            this.writeLeafNode(out, nodesInPath.get(nodesNum - 1), value, nodesNum);
            return;
        }
        if (arrayLevel == nodesNum - 1) {
            Map<String, String> attrAsValueMap;
            String objName;
            int pos;
            if (nodesForLastItem.size() - 1 - arrayLevel > 0) {
                this.closeNodes(out, nodesForLastItem.size() - 1, arrayLevel);
            }
            if ((pos = (objName = nodesInPath.get(nodesNum - 1).getNodeKeyName()).indexOf(45)) > 0) {
                objName = objName.substring(0, pos);
            }
            if ((attrAsValueMap = nodesInPath.get(nodesNum - 1).getAttrAsValueMap()).containsKey("radix")) {
                String radixValue = attrAsValueMap.get("radix");
                attrAsValueMap.remove("radix");
                for (Map.Entry<String, String> attributes : attrAsValueMap.entrySet()) {
                    String oldKey = attributes.getKey();
                    String newValue = attributes.getValue();
                    String newKey = oldKey + "/" + radixValue;
                    attrAsValueMap.remove(oldKey);
                    attrAsValueMap.put(newKey, newValue);
                }
            }
            if (attrAsValueMap.isEmpty()) {
                out.beginObject();
                out.name(objName).value(value);
                out.endObject();
            } else {
                if (!objName.equals("rbnfrule")) {
                    out.beginObject();
                }
                this.writeLeafNode(out, objName, attrAsValueMap, value, nodesNum);
                if (!objName.equals("rbnfrule")) {
                    out.endObject();
                }
            }
            nodesInPath.remove(nodesNum - 1);
        } else {
            if (nodesForLastItem.size() - 1 - arrayLevel > 0) {
                this.closeNodes(out, nodesForLastItem.size() - 1, arrayLevel);
            }
            out.beginObject();
            CldrNode node = nodesInPath.get(arrayLevel);
            String objName = node.getNodeKeyName();
            int pos = objName.indexOf(45);
            if (pos > 0) {
                objName = objName.substring(0, pos);
            }
            Map<String, String> attrAsValueMap = node.getAttrAsValueMap();
            out.name(objName);
            out.beginObject();
            for (String key : attrAsValueMap.keySet()) {
                out.name("_" + key).value(this.escapeValue(attrAsValueMap.get(key)));
            }
            for (int i = arrayLevel + 1; i < nodesInPath.size() - 1; ++i) {
                this.startNonleafNode(out, nodesInPath.get(i), i + 1);
            }
            this.writeLeafNode(out, nodesInPath.get(nodesNum - 1), value, nodesNum);
        }
        nodesForLastItem.clear();
        nodesForLastItem.addAll(nodesInPath);
    }

    private int findFirstDiffNodeIndex(ArrayList<CldrNode> nodesForLastItem, ArrayList<CldrNode> nodesInPath) {
        int i;
        for (i = 0; i < nodesInPath.size() && i < nodesForLastItem.size() && nodesInPath.get(i).getNodeDistinguishingName().equals(nodesForLastItem.get(i).getNodeDistinguishingName()); ++i) {
        }
        return i;
    }

    private final String progressPrefix(AtomicInteger readCount, int totalCount) {
        return this.progressPrefix(readCount.get(), totalCount);
    }

    private final String progressPrefix(int readCount, int totalCount) {
        return String.format("[%d/%d]:\t", readCount, totalCount);
    }

    public void processDirectory(String dirName, CLDRFile.DraftStatus minimalDraftStatus) throws IOException, ParseException {
        SupplementalDataInfo sdi = SupplementalDataInfo.getInstance(this.cldrCommonDir + "supplemental");
        Factory cldrFactory = Factory.make(this.cldrCommonDir + dirName + "/", ".*");
        Set<String> files = cldrFactory.getAvailable();
        int total = files.size();
        AtomicInteger readCount = new AtomicInteger(0);
        TreeMap errs = new TreeMap();
        ((Stream)files.parallelStream().unordered()).forEach(filename -> {
            if (LdmlConvertRules.IGNORE_FILE_SET.contains(filename)) {
                return;
            }
            if (!filename.matches(this.match)) {
                return;
            }
            CLDRFile file = cldrFactory.make((String)filename, this.resolve && this.type == RunType.main, minimalDraftStatus);
            System.out.println("<" + this.progressPrefix(readCount.incrementAndGet(), total) + "Reading " + dirName + "/" + filename);
            String pathPrefix = this.type == RunType.main ? "/cldr/" + dirName + "/" + filename.replaceAll("_", "-") + "/" : "/cldr/" + dirName + "/";
            try {
                this.convertCldrItems(readCount, total, dirName, (String)filename, pathPrefix, this.mapPathsToSections(readCount, total, file, pathPrefix, sdi));
            }
            catch (IOException | ParseException t) {
                t.printStackTrace();
                System.err.println("!" + this.progressPrefix(readCount.incrementAndGet(), total) + filename + " - err - " + t);
                errs.put(filename, t);
            }
            finally {
                System.out.println("." + this.progressPrefix(readCount, total) + "Completing " + dirName + "/" + filename);
            }
        });
        if (!errs.isEmpty()) {
            System.err.println("Errors in these files:");
            for (Map.Entry entry : errs.entrySet()) {
                System.err.println((String)entry.getKey() + " - " + entry.getValue());
            }
            Iterator<Object> iterator = errs.entrySet().iterator();
            if (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                if (entry.getValue() instanceof IOException) {
                    throw (IOException)entry.getValue();
                }
                if (entry.getValue() instanceof ParseException) {
                    throw (ParseException)entry.getValue();
                }
                throw new RuntimeException("Other exception thrown: " + entry.getValue());
            }
        }
        if (this.writePackages) {
            for (String string : this.packages) {
                this.writePackagingFiles(this.outputDir, string);
            }
            if (this.type == RunType.main) {
                this.writeDefaultContent(this.outputDir);
                this.writeAvailableLocales(this.outputDir);
            } else if (this.type == RunType.supplemental) {
                this.writeScriptMetadata(this.outputDir);
            }
        }
    }

    private String escapeValue(String value) {
        Matcher match = escapePattern.matcher(value);
        String ret = match.replaceAll("\\\\\\\\");
        return ret.replace("\"", "\\\"").replace("\n", " ").replace("\t", " ");
    }

    private void writeLeafNode(JsonWriter out, CldrNode node, String value, int level) throws IOException {
        String objName = node.getNodeKeyName();
        Map<String, String> attrAsValueMaps = node.getAttrAsValueMap();
        this.writeLeafNode(out, objName, attrAsValueMaps, value, level);
    }

    private void writeLeafNode(JsonWriter out, String objName, Map<String, String> attrAsValueMap, String value, int level) throws IOException {
        if (objName == null) {
            return;
        }
        value = this.escapeValue(value);
        if (attrAsValueMap.isEmpty()) {
            out.name(objName);
            if (value.isEmpty()) {
                out.beginObject();
                out.endObject();
            } else if (this.type == RunType.annotations || this.type == RunType.annotationsDerived) {
                out.beginArray();
                for (String s2 : Annotations.splitter.split(value.trim())) {
                    out.value(s2);
                }
                out.endArray();
            } else {
                out.value(value);
            }
            return;
        }
        if (value.isEmpty() && attrAsValueMap.containsKey("_")) {
            out.name(objName).value(attrAsValueMap.get("_"));
            return;
        }
        if (!objName.equals("rbnfrule")) {
            out.name(objName);
            out.beginObject();
        }
        if (!value.isEmpty()) {
            out.name("_value").value(value);
        }
        for (String key : attrAsValueMap.keySet()) {
            String attrValue = this.escapeValue(attrAsValueMap.get(key));
            if (LdmlConvertRules.ATTRVALUE_AS_ARRAY_SET.contains(key)) {
                String[] strings = attrValue.trim().split("\\s+");
                if (this.type != RunType.rbnf) {
                    out.name("_" + key);
                } else {
                    out.name(key);
                }
                out.beginArray();
                for (String s3 : strings) {
                    out.value(s3);
                }
                out.endArray();
                continue;
            }
            if (this.type != RunType.rbnf) {
                out.name("_" + key).value(attrValue);
                continue;
            }
            out.name(key).value(attrValue);
        }
        if (!objName.equals("rbnfrule")) {
            out.endObject();
        }
    }

    private class availableLocales {
        Set<String> modern = new TreeSet<String>();
        Set<String> full = new TreeSet<String>();

        private availableLocales() {
        }
    }

    private static enum RunType {
        main,
        supplemental,
        segments,
        rbnf,
        annotations,
        annotationsDerived;

    }

    private class JSONSection
    implements Comparable<JSONSection> {
        public String section;
        public Pattern pattern;
        public String packageName;

        private JSONSection() {
        }

        @Override
        public int compareTo(JSONSection other) {
            return this.section.compareTo(other.section);
        }
    }
}

