/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.test;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multiset;
import com.google.common.collect.TreeMultiset;
import com.ibm.icu.dev.util.UnicodeMap;
import com.ibm.icu.text.Transliterator;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.Output;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.unicode.cldr.test.CheckCLDR;
import org.unicode.cldr.test.CoverageLevel2;
import org.unicode.cldr.test.FactoryCheckCLDR;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.Level;
import org.unicode.cldr.util.LocaleIDParser;
import org.unicode.cldr.util.LogicalGrouping;
import org.unicode.cldr.util.With;
import org.unicode.cldr.util.XPathParts;

public class CheckLogicalGroupings
extends FactoryCheckCLDR {
    static final CLDRFile.DraftStatus MIMIMUM_DRAFT_STATUS = CLDRFile.DraftStatus.approved;
    static final Set<CheckCLDR.Phase> PHASES_CAUSE_ERROR = ImmutableSet.of(CheckCLDR.Phase.FINAL_TESTING, CheckCLDR.Phase.VETTING);
    private boolean phaseCausesError;
    private CoverageLevel2 coverageLevel;
    static final int LIMIT_DISTANCE = 5;
    static final Transliterator SHOW_INVISIBLES = Transliterator.createFromRules("show", "([[:C:][:Z:][:whitespace:][:Default_Ignorable_Code_Point:]-[\\u0020]]) > &hex/perl($1);", 0);
    private static final UnicodeMap<String> OTHER_SPACES = new UnicodeMap<String>().putAll(new UnicodeSet("[[:Z:][:S:][:whitespace:]]"), " ").freeze();
    private static ConcurrentHashMap<String, Fingerprint> FINGERPRINT_CACHE = new ConcurrentHashMap();

    public CheckLogicalGroupings(Factory factory) {
        super(factory);
    }

    @Override
    public CheckCLDR setCldrFileToCheck(CLDRFile cldrFileToCheck, CheckCLDR.Options options, List<CheckCLDR.CheckStatus> possibleErrors) {
        super.setCldrFileToCheck(cldrFileToCheck, options, possibleErrors);
        String parent = LocaleIDParser.getParent(cldrFileToCheck.getLocaleID());
        boolean isTopLevel = parent == null || parent.equals("root");
        this.setSkipTest(!isTopLevel);
        this.phaseCausesError = PHASES_CAUSE_ERROR.contains((Object)this.getPhase());
        this.coverageLevel = CoverageLevel2.getInstance(cldrFileToCheck.getLocaleID());
        return this;
    }

    public boolean isHereOrNonRoot(String path) {
        if (this.getCldrFileToCheck().isHere(path)) {
            return true;
        }
        if (!this.getCldrFileToCheck().getLocaleID().contains("_")) {
            return false;
        }
        String value = this.getResolvedCldrFileToCheck().getStringValue(path);
        if (value == null) {
            return false;
        }
        String source = this.getResolvedCldrFileToCheck().getSourceLocaleID(path, null);
        return !source.equals("root") && !source.equals("code-fallback");
    }

    @Override
    public CheckCLDR handleCheck(String path, String fullPath, String value, CheckCLDR.Options options, List<CheckCLDR.CheckStatus> result) {
        if (LogicalGrouping.isOptional(this.getCldrFileToCheck(), path)) {
            return this;
        }
        Output<LogicalGrouping.PathType> pathType = new Output<LogicalGrouping.PathType>();
        Set<String> paths = LogicalGrouping.getPaths(this.getCldrFileToCheck(), path, pathType);
        if (paths == null || paths.size() < 2) {
            return this;
        }
        switch ((LogicalGrouping.PathType)((Object)pathType.value)) {
            case COUNT_CASE: 
            case COUNT: 
            case COUNT_CASE_GENDER: {
                Object values;
                int maxDistance;
                TreeSet<String> sorted = new TreeSet<String>(paths);
                if (!path.equals(sorted.iterator().next()) || (maxDistance = this.getMaxDistance(path, value, sorted, (Multiset<String>)(values = TreeMultiset.create()))) < 5) break;
                maxDistance = this.getMaxDistance(path, value, paths, (Multiset<String>)values);
                result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.warningType).setSubtype(CheckCLDR.CheckStatus.Subtype.largerDifferences).setMessage("{0} different characters within {1}; {2}", maxDistance, CheckLogicalGroupings.showInvisibles(values), pathType.value));
                break;
            }
        }
        HashSet<String> paths2 = new HashSet<String>(paths);
        for (String p : paths2) {
            if (!LogicalGrouping.isOptional(this.getCldrFileToCheck(), p)) continue;
            paths.remove(p);
        }
        if (paths.size() < 2) {
            return this;
        }
        HashSet<String> missingPaths = new HashSet<String>();
        boolean havePath = false;
        String firstPath = null;
        for (String apath : paths) {
            if (this.isHereOrNonRoot(apath)) {
                havePath = true;
                continue;
            }
            if (missingPaths.isEmpty()) {
                firstPath = apath;
            }
            missingPaths.add(apath);
        }
        if (havePath && !missingPaths.isEmpty()) {
            if (path.equals(firstPath)) {
                Set missingCodes = missingPaths.stream().map(x -> this.getPathReferenceForMessage((String)x, true)).collect(Collectors.toSet());
                Level cLevel = this.coverageLevel.getLevel(path);
                CheckCLDR.CheckStatus.Type showError = this.phaseCausesError ? CheckCLDR.CheckStatus.errorType : CheckCLDR.CheckStatus.warningType;
                result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(showError).setSubtype(CheckCLDR.CheckStatus.Subtype.incompleteLogicalGroup).setMessage("Incomplete logical group - missing values for: {0}; level={1}", new Object[]{missingCodes.toString(), cLevel}));
            }
            return this;
        }
        String fPath = this.getCldrFileToCheck().getFullXPath(path);
        XPathParts parts = XPathParts.getFrozenInstance(fPath);
        CLDRFile.DraftStatus myStatus = CLDRFile.DraftStatus.forString(parts.findFirstAttributeValue("draft"));
        if (myStatus.compareTo(MIMIMUM_DRAFT_STATUS) >= 0) {
            return this;
        }
        for (String apath : paths) {
            CLDRFile.DraftStatus draftStatus;
            if (apath.equals(path) || missingPaths.contains(apath) || (fPath = this.getCldrFileToCheck().getFullXPath(apath)) == null || (draftStatus = CLDRFile.DraftStatus.forString((parts = XPathParts.getFrozenInstance(fPath)).findFirstAttributeValue("draft"))).compareTo(myStatus) <= 0) continue;
            CheckCLDR.CheckStatus.Type showError = this.phaseCausesError ? CheckCLDR.CheckStatus.errorType : CheckCLDR.CheckStatus.warningType;
            result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(showError).setSubtype(CheckCLDR.CheckStatus.Subtype.inconsistentDraftStatus).setMessage("This item has a lower draft status (in its logical group) than {0}.", this.getPathReferenceForMessage(apath, true)));
            break;
        }
        return this;
    }

    public static String showInvisibles(String value) {
        return SHOW_INVISIBLES.transform(value);
    }

    public static String showInvisibles(int codePoint) {
        return CheckLogicalGroupings.showInvisibles(With.fromCodePoint(codePoint));
    }

    public static String showInvisibles(Multiset<?> codePointCounts) {
        StringBuilder b = new StringBuilder().append('{');
        for (Multiset.Entry<?> entry : codePointCounts.entrySet()) {
            Object element;
            if (b.length() > 1) {
                b.append(", ");
            }
            b.append((element = entry.getElement()) instanceof Integer ? CheckLogicalGroupings.showInvisibles((Integer)element) : CheckLogicalGroupings.showInvisibles(element.toString()));
            if (entry.getCount() <= 1) continue;
            b.append('\u2a31').append(entry.getCount());
        }
        return b.append('}').toString();
    }

    private int getMaxDistance(String path, String value, Set<String> paths, Multiset<String> values) {
        values.clear();
        CLDRFile cldrFileToCheck = this.getCldrFileToCheck();
        HashSet<Fingerprint> fingerprints = new HashSet<Fingerprint>();
        for (String path1 : paths) {
            String pathValue = CheckLogicalGroupings.cleanSpaces(path.contentEquals(path1) ? value : cldrFileToCheck.getWinningValue(path1));
            values.add(pathValue);
            fingerprints.add(Fingerprint.make(pathValue));
        }
        return Fingerprint.maxDistanceBetween(fingerprints);
    }

    public static String cleanSpaces(String pathValue) {
        return OTHER_SPACES.transform(pathValue);
    }

    public static class Fingerprint {
        private final Multiset<Integer> codePointCounts;

        private Fingerprint(String value) {
            TreeMultiset<Integer> result = TreeMultiset.create();
            for (int cp : With.codePointArray(value)) {
                result.add(cp);
            }
            this.codePointCounts = ImmutableMultiset.copyOf(result);
        }

        public static int maxDistanceBetween(Set<Fingerprint> fingerprintsIn) {
            int distance = 0;
            ImmutableList<Fingerprint> fingerprints = ImmutableList.copyOf(fingerprintsIn);
            for (int i = fingerprints.size() - 1; i > 0; --i) {
                Fingerprint fingerprint_i = (Fingerprint)fingerprints.get(i);
                for (int j = i - 1; j >= 0; --j) {
                    Fingerprint fingerprints_j = (Fingerprint)fingerprints.get(j);
                    int currentDistance = fingerprint_i.getDistanceTo(fingerprints_j);
                    distance = Math.max(distance, currentDistance);
                }
            }
            return distance;
        }

        public int getDistanceTo(Fingerprint that) {
            int distance = 0;
            HashSet<Integer> allChars = new HashSet<Integer>(that.codePointCounts.elementSet());
            allChars.addAll(this.codePointCounts.elementSet());
            for (Integer element : allChars) {
                int count = this.codePointCounts.count(element);
                int otherCount = that.codePointCounts.count(element);
                distance += Math.abs(count - otherCount);
            }
            return distance;
        }

        public int size() {
            return this.codePointCounts.size();
        }

        public static Fingerprint make(String value) {
            return FINGERPRINT_CACHE.computeIfAbsent(value, v -> new Fingerprint((String)v));
        }

        public String toString() {
            return CheckLogicalGroupings.showInvisibles(this.codePointCounts);
        }
    }
}

