/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import com.ibm.icu.impl.Relation;
import com.ibm.icu.impl.Row;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.util.ICUUncheckedIOException;
import com.ibm.icu.util.Output;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.test.SubmissionLocales;
import org.unicode.cldr.tool.Chart;
import org.unicode.cldr.tool.FormattedFileWriter;
import org.unicode.cldr.tool.LikelySubtags;
import org.unicode.cldr.tool.Option;
import org.unicode.cldr.tool.TablePrinter;
import org.unicode.cldr.tool.ToolConstants;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.Counter;
import org.unicode.cldr.util.DtdData;
import org.unicode.cldr.util.DtdType;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.LanguageTagParser;
import org.unicode.cldr.util.Level;
import org.unicode.cldr.util.LocaleIDParser;
import org.unicode.cldr.util.Organization;
import org.unicode.cldr.util.Pair;
import org.unicode.cldr.util.PathHeader;
import org.unicode.cldr.util.PathStarrer;
import org.unicode.cldr.util.PatternCache;
import org.unicode.cldr.util.SimpleXMLSource;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.TransliteratorUtilities;
import org.unicode.cldr.util.XMLFileReader;
import org.unicode.cldr.util.XPathParts;

public class ChartDelta
extends Chart {
    private static final boolean verbose_skipping = false;
    private static final String DEFAULT_DELTA_DIR_NAME = "delta";
    private static final String DEFAULT_CHURN_DIR_NAME = "churn";
    private static final boolean SKIP_REFORMAT_ANNOTATIONS = ToolConstants.PREV_CHART_VERSION.compareTo("30") >= 0;
    private static final PathHeader.PageId DEBUG_PAGE_ID = PathHeader.PageId.DayPeriod;
    private static final SupplementalDataInfo SUPPLEMENTAL_DATA_INFO = CLDRConfig.getInstance().getSupplementalDataInfo();
    private final Matcher fileFilter;
    private final String dirName;
    private final String chartNameCap;
    private final String DIR;
    private final Level minimumPathCoverage;
    private final boolean verbose;
    private final boolean highLevelOnly;
    private static final String SEP = "\u0001";
    private static final boolean DEBUG = false;
    private static final String DEBUG_FILE = null;
    static Pattern fileMatcher = PatternCache.get(".*");
    static PathHeader.Factory phf = PathHeader.getFactory(ENGLISH);
    static final Set<String> DONT_CARE = new HashSet<String>(Arrays.asList("draft", "standard", "reference"));
    private static final CLDRFile EMPTY_CLDR = new CLDRFile(new SimpleXMLSource("und").freeze());
    private static final File CLDR_BASE_DIR = CLDRConfig.getInstance().getCldrBaseDirectory();
    private Counter<ChangeType> counter = new Counter();
    private Map<String, Counter<ChangeType>> fileCounters = new TreeMap<String, Counter<ChangeType>>();
    private Set<String> badHeaders = new TreeSet<String>();
    PathStarrer starrer = new PathStarrer().setSubstitutionPattern("%A");

    public static void main(String[] args) {
        ChartDelta.main(args, false);
    }

    public static void main(String[] args, boolean highLevelOnly) {
        Matcher fileFilter;
        System.out.println("use -DCHART_VERSION=36.0 -DPREV_CHART_VERSION=34.0 to generate the differences between v36 and v34.");
        MyOptions.parse(args);
        Matcher matcher = fileFilter = !MyOptions.fileFilter.option.doesOccur() ? null : PatternCache.get(MyOptions.fileFilter.option.getValue()).matcher("");
        if (MyOptions.orgFilter.option.doesOccur()) {
            if (MyOptions.fileFilter.option.doesOccur()) {
                throw new IllegalArgumentException("Can't have both fileFilter and orgFilter");
            }
            String rawOrg = MyOptions.orgFilter.option.getValue();
            Organization org = Organization.fromString(rawOrg);
            Set<String> locales = StandardCodes.make().getLocaleCoverageLocales(org);
            fileFilter = PatternCache.get("^(main|annotations)/(" + Joiner.on("|").join(locales) + ")$").matcher("");
        }
        Level coverage = !MyOptions.coverageFilter.option.doesOccur() ? null : Level.fromString(MyOptions.coverageFilter.option.getValue());
        boolean verbose = MyOptions.verbose.option.doesOccur();
        if (MyOptions.highLevelOnly.option.doesOccur()) {
            highLevelOnly = true;
        }
        String dirName = MyOptions.directory.option.getValue();
        if (highLevelOnly && DEFAULT_DELTA_DIR_NAME.equals(dirName)) {
            System.out.println("For highLevelOnly, changing directory from delta to churn");
            dirName = DEFAULT_CHURN_DIR_NAME;
        }
        ChartDelta temp = new ChartDelta(fileFilter, coverage, dirName, verbose, highLevelOnly);
        temp.writeChart(null);
        temp.showTotals();
        if (highLevelOnly) {
            HighLevelPaths.reportHighLevelPathUsage();
        }
        System.out.println("Finished. Files may have been created in these directories:");
        System.out.println(temp.DIR);
        System.out.println(ChartDelta.getTsvDir(temp.DIR, temp.dirName));
    }

    private ChartDelta(Matcher fileFilter, Level coverage, String dirName, boolean verbose, boolean highLevelOnly) {
        this.fileFilter = fileFilter;
        this.verbose = verbose;
        this.highLevelOnly = highLevelOnly;
        this.dirName = dirName;
        this.chartNameCap = dirName.substring(0, 1).toUpperCase() + dirName.substring(1);
        this.DIR = CLDRPaths.CHART_DIRECTORY + dirName;
        this.minimumPathCoverage = coverage;
    }

    @Override
    public String getDirectory() {
        return this.DIR;
    }

    @Override
    public String getTitle() {
        return this.chartNameCap + " Charts";
    }

    @Override
    public String getFileName() {
        return "index";
    }

    @Override
    public String getExplanation() {
        return "<p>Charts showing the differences from the last version. Titles prefixed by \u00a4 are special: either the locale data summary or supplemental data. Not all changed data is charted yet. For details see each chart.</p>";
    }

    @Override
    public void writeContents(FormattedFileWriter pw) throws IOException {
        FormattedFileWriter.Anchors anchors = new FormattedFileWriter.Anchors();
        FileUtilities.copyFile(ChartDelta.class, "index.css", this.getDirectory());
        FormattedFileWriter.copyIncludeHtmls(this.getDirectory(), true);
        this.counter.clear();
        this.fileCounters.clear();
        this.writeNonLdmlPlain(anchors);
        this.writeLdml(anchors);
        pw.setIndex("Main Chart Index", "../index.html");
        pw.write(anchors.toString());
    }

    private void addChange(String file, ChangeType changeType, int count) {
        this.counter.add(changeType, count);
        Counter<ChangeType> fileCounter = this.fileCounters.get(file);
        if (fileCounter == null) {
            fileCounter = new Counter();
            this.fileCounters.put(file, fileCounter);
        }
        fileCounter.add(changeType, count);
    }

    private void showTotals() {
        try (PrintWriter pw = FileUtilities.openUTF8Writer(ChartDelta.getTsvDir(this.DIR, this.dirName), this.dirName + "_summary.tsv");){
            pw.print("# dir\tfile");
            for (ChangeType item : ChangeType.values()) {
                pw.print("\t" + (item == ChangeType.same ? "total" : item.toString()));
            }
            pw.println();
            this.showTotal(pw, "TOTAL/", this.counter);
            for (Map.Entry entry : this.fileCounters.entrySet()) {
                this.showTotal(pw, (String)entry.getKey(), (Counter)entry.getValue());
            }
            for (String string : this.badHeaders) {
                pw.println(string);
            }
        }
        catch (IOException e) {
            throw new ICUUncheckedIOException(e);
        }
    }

    private void showTotal(PrintWriter pw, String title2, Counter<ChangeType> counter2) {
        long total = counter2.getTotal();
        NumberFormat pf = NumberFormat.getPercentInstance();
        pf.setMinimumFractionDigits(2);
        NumberFormat nf = NumberFormat.getIntegerInstance();
        pw.print(title2.replace("/", "\t"));
        for (ChangeType item : ChangeType.values()) {
            if (item == ChangeType.same) {
                pw.print("\t" + nf.format(total));
                continue;
            }
            long current = counter2.getCount(item);
            pw.print("\t" + nf.format(current));
        }
        pw.println();
    }

    private void writeLdml(FormattedFileWriter.Anchors anchors) throws IOException {
        try (PrintWriter tsvFile = FileUtilities.openUTF8Writer(ChartDelta.getTsvDir(this.DIR, this.dirName), this.dirName + ".tsv");
             PrintWriter tsvCountFile = FileUtilities.openUTF8Writer(ChartDelta.getTsvDir(this.DIR, this.dirName), this.dirName + "_count.tsv");){
            tsvFile.println("# Section\tPage\tHeader\tCode\tLocale\tOld\tNew\tLevel");
            ArrayList<Factory> factories = new ArrayList<Factory>();
            ArrayList<Factory> oldFactories = new ArrayList<Factory>();
            Counter<PathHeader> counts = new Counter<PathHeader>();
            String dirBase = ToolConstants.getBaseDirectory(ToolConstants.CHART_VERSION);
            String prevDirBase = ToolConstants.getBaseDirectory(ToolConstants.PREV_CHART_VERSION);
            for (String dir : DtdType.ldml.directories) {
                if (dir.equals("annotationsDerived") || dir.equals("casing")) continue;
                String current = dirBase + "common/" + dir;
                String past = prevDirBase + "common/" + dir;
                try {
                    factories.add(Factory.make(current, ".*"));
                }
                catch (Exception e1) {
                    System.out.println("Skipping: " + dir + "\t" + e1.getMessage());
                    continue;
                }
                try {
                    oldFactories.add(Factory.make(past, ".*"));
                }
                catch (Exception e) {
                    System.out.println("Couldn't open factory: " + past);
                    past = null;
                    oldFactories.add(null);
                }
                System.out.println("Will compare: " + dir + "\t\t" + current + "\t\t" + past);
            }
            if (factories.isEmpty()) {
                throw new IllegalArgumentException("No factories found for " + dirBase + ": " + DtdType.ldml.directories);
            }
            Relation<String, String> baseToLocales = Relation.of(new TreeMap(), HashSet.class);
            Matcher m3 = fileMatcher.matcher("");
            Set<String> defaultContents = SDI.getDefaultContentLocales();
            LanguageTagParser ltp = new LanguageTagParser();
            LikelySubtags ls = new LikelySubtags();
            for (String file : ((Factory)factories.get(0)).getAvailable()) {
                if (defaultContents.contains(file) || !m3.reset(file).matches()) continue;
                String base = file.equals("root") ? "root" : ltp.set(ls.minimize(file)).getLanguageScript();
                baseToLocales.put(base, file);
            }
            CLDRFile.Status currentStatus = new CLDRFile.Status();
            CLDRFile.Status oldStatus = new CLDRFile.Status();
            TreeSet<PathDiff> diff = new TreeSet<PathDiff>();
            HashSet<String> paths = new HashSet<String>();
            Relation<PathHeader, String> diffAll = Relation.of(new TreeMap(), TreeSet.class);
            for (Map.Entry baseNLocale : baseToLocales.keyValuesSet()) {
                String base = (String)baseNLocale.getKey();
                for (int i = 0; i < factories.size(); ++i) {
                    Factory factory = (Factory)factories.get(i);
                    Factory oldFactory = (Factory)oldFactories.get(i);
                    List<File> sourceDirs = Arrays.asList(factory.getSourceDirectories());
                    if (sourceDirs.size() != 1) {
                        throw new IllegalArgumentException("Internal error: expect single source dir");
                    }
                    File sourceDir = sourceDirs.get(0);
                    String sourceDirLeaf = sourceDir.getName();
                    boolean resolving = !sourceDirLeaf.contains("subdivisions") && !sourceDirLeaf.contains("transforms");
                    for (String locale : baseNLocale.getValue()) {
                        String nameAndLocale = sourceDirLeaf + "/" + locale;
                        if (this.fileFilter != null && !this.fileFilter.reset(nameAndLocale).find()) {
                            if (!this.verbose) continue;
                            continue;
                        }
                        if (this.verbose) {
                            System.out.println(nameAndLocale);
                        }
                        CLDRFile current = this.makeWithFallback(factory, locale, resolving);
                        CLDRFile old = this.makeWithFallback(oldFactory, locale, resolving);
                        if (!locale.equals("root") && current.getLocaleID().equals("root") && old.getLocaleID().equals("root") || old == EMPTY_CLDR && current == EMPTY_CLDR || this.highLevelOnly && !HighLevelPaths.localeIsHighLevel(locale)) continue;
                        paths.clear();
                        for (String path : current.fullIterable()) {
                            if (!this.allowPath(locale, path)) continue;
                            paths.add(path);
                        }
                        for (String path : old.fullIterable()) {
                            if (paths.contains(path) || !this.allowPath(locale, path)) continue;
                            paths.add(path);
                        }
                        Output<String> reformattedValue = new Output<String>();
                        Output<Boolean> hasReformattedValue = new Output<Boolean>();
                        for (String path : paths) {
                            PathHeader ph;
                            if (this.highLevelOnly && !HighLevelPaths.pathIsHighLevel(path, locale) || path.startsWith("//ldml/identity") || path.endsWith("/alias") || path.startsWith("//ldml/segmentations") || path.startsWith("//ldml/rbnf") || (ph = this.getPathHeader(path)) == null) continue;
                            String oldValue = null;
                            String currentValue = null;
                            String sourceLocaleCurrent = current.getSourceLocaleID(path, currentStatus);
                            String sourceLocaleOld = this.getReformattedPath(oldStatus, old, path, reformattedValue, hasReformattedValue);
                            if (!sourceLocaleCurrent.equals(locale) && !sourceLocaleOld.equals(locale) || !path.equals(currentStatus.pathWhereFound) && !path.equals(oldStatus.pathWhereFound)) continue;
                            currentValue = current.getStringValue(path);
                            if (CldrUtility.INHERITANCE_MARKER.equals(currentValue)) {
                                currentValue = current.getConstructedBaileyValue(path, null, null);
                            }
                            String string = oldValue = (Boolean)hasReformattedValue.value != false ? (String)reformattedValue.value : old.getStringValue(path);
                            if (CldrUtility.INHERITANCE_MARKER.equals(oldValue)) {
                                oldValue = old.getConstructedBaileyValue(path, null, null);
                            }
                            this.addPathDiff(sourceDir, old, current, locale, ph, diff);
                            this.addValueDiff(sourceDir, oldValue, currentValue, locale, ph, diff, diffAll);
                        }
                    }
                }
                this.writeDiffs(anchors, base, diff, tsvFile, counts);
                diff.clear();
            }
            this.writeDiffs(diffAll);
            this.writeCounter(tsvCountFile, "Count", counts);
        }
    }

    private boolean allowPath(String locale, String path) {
        Level pathLevel;
        return this.minimumPathCoverage == null || this.minimumPathCoverage.compareTo(pathLevel = SUPPLEMENTAL_DATA_INFO.getCoverageLevel(path, locale)) >= 0;
    }

    private String getReformattedPath(CLDRFile.Status oldStatus, CLDRFile old, String path, Output<String> value, Output<Boolean> hasReformattedValue) {
        boolean isTts;
        if (SKIP_REFORMAT_ANNOTATIONS || !path.startsWith("//ldml/annotations/")) {
            hasReformattedValue.value = Boolean.FALSE;
            return old.getSourceLocaleID(path, oldStatus);
        }
        XPathParts parts = XPathParts.getFrozenInstance(path).cloneAsThawed();
        boolean bl = isTts = parts.getAttributeValue(-1, "type") != null;
        if (isTts) {
            parts.removeAttribute(-1, "type");
        }
        String cp = parts.getAttributeValue(-1, "cp");
        parts.setAttribute(-1, "cp", "[" + cp + "]");
        String oldStylePath = parts.toString();
        String temp = old.getStringValue(oldStylePath);
        if (temp == null) {
            hasReformattedValue.value = Boolean.FALSE;
        } else if (isTts) {
            String temp2 = old.getFullXPath(oldStylePath);
            value.value = XPathParts.getFrozenInstance(temp2).getAttributeValue(-1, "tts");
            hasReformattedValue.value = Boolean.TRUE;
        } else {
            value.value = temp.replaceAll("\\s*;\\s*", " | ");
            hasReformattedValue.value = Boolean.TRUE;
        }
        return old.getSourceLocaleID(oldStylePath, oldStatus);
    }

    private PathHeader getPathHeader(String path) {
        try {
            PathHeader ph = phf.fromPath(path);
            if (ph.getPageId() == PathHeader.PageId.Unknown) {
                String star = this.starrer.set(path);
                this.badHeaders.add(star);
                return null;
            }
            return ph;
        }
        catch (Exception e) {
            String star = this.starrer.set(path);
            this.badHeaders.add(star);
            return null;
        }
    }

    private CLDRFile makeWithFallback(Factory oldFactory, String locale, boolean resolving) {
        CLDRFile old;
        if (oldFactory == null) {
            return EMPTY_CLDR;
        }
        String oldLocale = locale;
        while (true) {
            try {
                old = oldFactory.make(oldLocale, resolving);
            }
            catch (Exception e) {
                if ((oldLocale = LocaleIDParser.getParent(oldLocale)) != null) continue;
                return EMPTY_CLDR;
            }
            break;
        }
        return old;
    }

    private void addPathDiff(File sourceDir, CLDRFile old, CLDRFile current, String locale, PathHeader ph, Set<PathDiff> diff2) {
        String fullPathOld;
        String path = ph.getOriginalPath();
        String fullPathCurrent = current.getFullXPath(path);
        if (Objects.equals(fullPathCurrent, fullPathOld = old.getFullXPath(path))) {
            return;
        }
        XPathParts pathPlain = XPathParts.getFrozenInstance(path);
        XPathParts pathCurrent = fullPathCurrent == null ? pathPlain : XPathParts.getFrozenInstance(fullPathCurrent);
        XPathParts pathOld = fullPathOld == null ? pathPlain : XPathParts.getFrozenInstance(fullPathOld);
        TreeSet<String> fullAttributes = null;
        int size = pathCurrent.size();
        String parentAndName = this.parentAndName(sourceDir, locale);
        for (int elementIndex = 0; elementIndex < size; ++elementIndex) {
            Collection<String> distinguishing = pathPlain.getAttributeKeys(elementIndex);
            Collection<String> attributesCurrent = pathCurrent.getAttributeKeys(elementIndex);
            Collection<String> attributesOld = pathCurrent.getAttributeKeys(elementIndex);
            if (attributesCurrent.isEmpty() && attributesOld.isEmpty()) continue;
            if (fullAttributes == null) {
                fullAttributes = new TreeSet<String>();
            } else {
                fullAttributes.clear();
            }
            fullAttributes.addAll(attributesCurrent);
            fullAttributes.addAll(attributesOld);
            fullAttributes.removeAll(distinguishing);
            fullAttributes.removeAll(DONT_CARE);
            for (String attribute : fullAttributes) {
                String attributeValueCurrent;
                String attributeValueOld = pathOld.getAttributeValue(elementIndex, attribute);
                if (Objects.equals(attributeValueOld, attributeValueCurrent = pathCurrent.getAttributeValue(elementIndex, attribute))) {
                    this.addChange(parentAndName, ChangeType.same, 1);
                    continue;
                }
                this.addChange(parentAndName, ChangeType.get(attributeValueOld, attributeValueCurrent), 1);
                PathDiff row = new PathDiff(locale, new PathHeaderSegment(ph, size - elementIndex - 1, attribute), attributeValueOld, attributeValueCurrent);
                diff2.add(row);
            }
        }
    }

    private String parentAndName(File sourceDir, String locale) {
        return sourceDir.getName() + "/" + locale + ".xml";
    }

    private void addValueDiff(File sourceDir, String valueOld, String valueCurrent, String locale, PathHeader ph, Set<PathDiff> diff, Relation<PathHeader, String> diffAll) {
        Splitter splitter = this.getSplitter(ph.getOriginalPath(), valueOld, valueCurrent);
        int count = 1;
        String parentAndName = this.parentAndName(sourceDir, locale);
        if (Objects.equals(valueCurrent, valueOld)) {
            if (splitter != null && valueCurrent != null) {
                count = this.splitHandlingNull(splitter, valueCurrent).size();
            }
            this.addChange(parentAndName, ChangeType.same, count);
        } else {
            if (splitter != null) {
                List<String> setOld = this.splitHandlingNull(splitter, valueOld);
                List<String> setNew = this.splitHandlingNull(splitter, valueCurrent);
                int[] sameAndNotInSecond = new int[2];
                valueOld = this.getFilteredValue(setOld, setNew, sameAndNotInSecond);
                this.addChange(parentAndName, ChangeType.same, sameAndNotInSecond[0]);
                this.addChange(parentAndName, ChangeType.deleted, sameAndNotInSecond[1]);
                sameAndNotInSecond[1] = 0;
                sameAndNotInSecond[0] = 0;
                valueCurrent = this.getFilteredValue(setNew, setOld, sameAndNotInSecond);
                this.addChange(parentAndName, ChangeType.added, sameAndNotInSecond[1]);
            } else {
                this.addChange(parentAndName, ChangeType.get(valueOld, valueCurrent), count);
            }
            PathDiff row = new PathDiff(locale, new PathHeaderSegment(ph, -1, ""), valueOld, valueCurrent);
            diff.add(row);
            diffAll.put(ph, locale);
        }
    }

    private List<String> splitHandlingNull(Splitter splitter, String value) {
        return value == null ? null : splitter.splitToList(value);
    }

    private Splitter getSplitter(String path, String valueOld, String valueCurrent) {
        if (path.contains("/annotation") && !path.contains("tts")) {
            return DtdData.BAR_SPLITTER;
        }
        if (valueOld != null && valueOld.contains("\n") || valueCurrent != null && valueCurrent.contains("\n")) {
            return DtdData.CR_SPLITTER;
        }
        return null;
    }

    private String getFilteredValue(Collection<String> toGetStringFor, Collection<String> linesToRemove, int[] sameAndDiff) {
        if (toGetStringFor == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        HashSet<String> toRemove = linesToRemove == null ? Collections.emptySet() : new HashSet<String>(linesToRemove);
        boolean removed = false;
        for (String old : toGetStringFor) {
            if (toRemove.contains(old)) {
                removed = true;
                sameAndDiff[0] = sameAndDiff[0] + 1;
                continue;
            }
            sameAndDiff[1] = sameAndDiff[1] + 1;
            if (removed) {
                buf.append("\u2026\n");
                removed = false;
            }
            buf.append(old).append('\n');
        }
        if (removed) {
            buf.append("\u2026");
        } else if (buf.length() > 0) {
            buf.setLength(buf.length() - 1);
        }
        return buf.toString();
    }

    private void writeDiffs(FormattedFileWriter.Anchors anchors, String file, String title, Multimap<PathHeader, String> bcp, PrintWriter tsvFile) {
        if (bcp.isEmpty()) {
            System.out.println("\tDeleting: " + this.DIR + "/" + file);
            new File(this.DIR + file).delete();
            return;
        }
        TablePrinter tablePrinter = new TablePrinter().addColumn("Section", "class='source'", CldrUtility.getDoubleLinkMsg(), "class='source'", true).addColumn("Page", "class='source'", CldrUtility.getDoubleLinkMsg(), "class='source'", true).addColumn("Header", "class='source'", CldrUtility.getDoubleLinkMsg(), "class='source'", true).addColumn("Code", "class='source'", null, "class='source'", false).addColumn("Old", "class='target'", null, "class='target'", false).addColumn("New", "class='target'", null, "class='target'", false);
        PathHeader ph1 = phf.fromPath("//supplementalData/metadata/alias/subdivisionAlias[@type=\"TW-TXQ\"]/_reason");
        PathHeader ph2 = phf.fromPath("//supplementalData/metadata/alias/subdivisionAlias[@type=\"LA-XN\"]/_replacement");
        ph1.compareTo(ph2);
        for (Map.Entry<PathHeader, Collection<String>> entry : bcp.asMap().entrySet()) {
            PathHeader ph = entry.getKey();
            if (ph.getPageId() == DEBUG_PAGE_ID) {
                System.out.println(ph + "\t" + ph.getOriginalPath());
            }
            for (String value : entry.getValue()) {
                String[] oldNew = value.split(SEP);
                tablePrinter.addRow().addCell((Comparable)((Object)ph.getSectionId())).addCell((Comparable)((Object)ph.getPageId())).addCell((Comparable)((Object)ph.getHeader())).addCell((Comparable)((Object)ph.getCode())).addCell((Comparable)((Object)oldNew[0])).addCell((Comparable)((Object)oldNew[1])).finishRow();
            }
        }
        this.writeTable(anchors, file, tablePrinter, title, tsvFile);
    }

    private void writeDiffs(Relation<PathHeader, String> diffAll) {
        TablePrinter tablePrinter = new TablePrinter().addColumn("Section", "class='source'", CldrUtility.getDoubleLinkMsg(), "class='source'", true).addColumn("Page", "class='source'", CldrUtility.getDoubleLinkMsg(), "class='source'", true).addColumn("Header", "class='source'", CldrUtility.getDoubleLinkMsg(), "class='source'", true).addColumn("Code", "class='source'", null, "class='source'", true).addColumn("Locales where different", "class='target'", null, "class='target'", true);
        for (Map.Entry<PathHeader, Set<String>> row : diffAll.keyValuesSet()) {
            PathHeader ph = row.getKey();
            Set<String> locales = row.getValue();
            tablePrinter.addRow().addCell((Comparable)((Object)ph.getSectionId())).addCell((Comparable)((Object)ph.getPageId())).addCell((Comparable)((Object)ph.getHeader())).addCell((Comparable)((Object)ph.getCode())).addCell((Comparable)((Object)Joiner.on(" ").join(locales))).finishRow();
        }
    }

    private void writeDiffs(FormattedFileWriter.Anchors anchors, String file, Set<PathDiff> diff, PrintWriter tsvFile, Counter<PathHeader> counts) {
        if (diff.isEmpty()) {
            return;
        }
        TablePrinter tablePrinter = new TablePrinter().addColumn("Section", "class='source'", CldrUtility.getDoubleLinkMsg(), "class='source'", true).addColumn("Page", "class='source'", CldrUtility.getDoubleLinkMsg(), "class='source'", true).addColumn("Header", "class='source'", CldrUtility.getDoubleLinkMsg(), "class='source'", true).addColumn("Code", "class='source'", null, "class='source'", true).addColumn("Locale", "class='source'", null, "class='source'", true).addColumn("Old", "class='target'", null, "class='target'", true).addColumn("New", "class='target'", null, "class='target'", true).addColumn("Level", "class='target'", null, "class='target'", true);
        for (PathDiff row : diff) {
            PathHeaderSegment phs = (PathHeaderSegment)row.get0();
            counts.add((PathHeader)phs.get0(), 1L);
            String locale = (String)row.get1();
            String oldValue = (String)row.get2();
            String currentValue = (String)row.get3();
            PathHeader ph = (PathHeader)phs.get0();
            Integer pathIndex = (Integer)phs.get1();
            String attribute = (String)phs.get2();
            String specialCode = ph.getCode();
            if (!attribute.isEmpty()) {
                specialCode = specialCode + "_" + attribute;
                if (pathIndex != 0) {
                    specialCode = specialCode + "|" + pathIndex;
                }
            }
            Level coverageLevel = SUPPLEMENTAL_DATA_INFO.getCoverageLevel(ph.getOriginalPath(), locale);
            String fixedOldValue = oldValue == null ? "\u25b7missing\u25c1" : TransliteratorUtilities.toHTML.transform(oldValue);
            String fixedNewValue = currentValue == null ? "\u25b7removed\u25c1" : TransliteratorUtilities.toHTML.transform(currentValue);
            tablePrinter.addRow().addCell((Comparable)((Object)ph.getSectionId())).addCell((Comparable)((Object)ph.getPageId())).addCell((Comparable)((Object)ph.getHeader())).addCell((Comparable)((Object)specialCode)).addCell((Comparable)((Object)locale)).addCell((Comparable)((Object)fixedOldValue)).addCell((Comparable)((Object)fixedNewValue)).addCell((Comparable)((Object)coverageLevel)).finishRow();
        }
        String title = ENGLISH.getName(file) + " " + this.chartNameCap;
        this.writeTable(anchors, file, tablePrinter, title, tsvFile);
        diff.clear();
    }

    private void writeTable(FormattedFileWriter.Anchors anchors, String file, TablePrinter tablePrinter, String title, PrintWriter tsvFile) {
        ChartDeltaSub chartDeltaSub = new ChartDeltaSub(title, file, tablePrinter, tsvFile);
        chartDeltaSub.writeChart(anchors);
    }

    private void writeNonLdmlPlain(FormattedFileWriter.Anchors anchors) throws IOException {
        try (PrintWriter tsvFile = FileUtilities.openUTF8Writer(ChartDelta.getTsvDir(this.DIR, this.dirName), this.dirName + "_supp.tsv");
             PrintWriter tsvCountFile = FileUtilities.openUTF8Writer(ChartDelta.getTsvDir(this.DIR, this.dirName), this.dirName + "_supp_count.tsv");){
            tsvFile.println("# Section\tPage\tHeader\tCode\tOld\tNew");
            TreeMultimap<PathHeader, String> bcp = TreeMultimap.create();
            TreeMultimap<PathHeader, String> supplemental = TreeMultimap.create();
            TreeMultimap<PathHeader, String> transforms = TreeMultimap.create();
            Counter<PathHeader> countSame = new Counter<PathHeader>();
            Counter<PathHeader> countAdded = new Counter<PathHeader>();
            Counter<PathHeader> countDeleted = new Counter<PathHeader>();
            for (String dir : new File(CLDRPaths.BASE_DIRECTORY + "common/").list()) {
                if (DtdType.ldml.directories.contains(dir) || dir.equals(".DS_Store") || dir.equals("dtd") || dir.equals("properties") || dir.equals("uca")) continue;
                File dirOld = new File(PREV_CHART_VERSION_DIRECTORY + "common/" + dir);
                System.out.println("\tLast dir: " + dirOld);
                File dir2 = new File(CHART_VERSION_DIRECTORY + "common/" + dir);
                System.out.println("\tCurr dir: " + dir2);
                for (String file : dir2.list()) {
                    if (!file.endsWith(".xml")) continue;
                    String parentAndFile = dir + "/" + file;
                    String base = file.substring(0, file.length() - 4);
                    if (this.fileFilter != null && !this.fileFilter.reset(dir + "/" + base).find()) {
                        if (!this.verbose) continue;
                        System.out.println("SKIPPING: " + dir + "/" + base);
                        continue;
                    }
                    if (this.highLevelOnly && !HighLevelPaths.localeIsHighLevel(base)) continue;
                    if (this.verbose) {
                        System.out.println(file);
                    }
                    Relation<PathHeader, String> contentsOld = this.fillData(dirOld.toString() + "/", file, base);
                    Relation<PathHeader, String> contents2 = this.fillData(dir2.toString() + "/", file, base);
                    TreeSet keys = new TreeSet(CldrUtility.ifNull(contentsOld.keySet(), Collections.emptySet()));
                    keys.addAll(CldrUtility.ifNull(contents2.keySet(), Collections.emptySet()));
                    DtdType dtdType = null;
                    for (PathHeader key : keys) {
                        Set<String> set2;
                        String originalPath = key.getOriginalPath();
                        if (this.highLevelOnly && !HighLevelPaths.pathIsHighLevel(originalPath, base)) continue;
                        boolean isTransform = originalPath.contains("/tRule");
                        if (dtdType == null) {
                            dtdType = DtdType.fromPath(originalPath);
                        }
                        TreeMultimap<PathHeader, String> target = dtdType == DtdType.ldmlBCP47 ? bcp : (isTransform ? transforms : supplemental);
                        Set<String> setOld = contentsOld.get(key);
                        if (Objects.equals(setOld, set2 = contents2.get(key))) {
                            if (file.equals(DEBUG_FILE)) {
                                System.out.println("**Same: " + key + "\t" + setOld);
                            }
                            this.addChange(parentAndFile, ChangeType.same, setOld.size());
                            countSame.add(key, 1L);
                            continue;
                        }
                        if (setOld == null) {
                            this.addChange(parentAndFile, ChangeType.added, set2.size());
                            for (String s2 : set2) {
                                this.addRow(target, key, "\u25b7missing\u25c1", s2);
                                countAdded.add(key, 1L);
                            }
                            continue;
                        }
                        if (set2 == null) {
                            this.addChange(parentAndFile, ChangeType.deleted, setOld.size());
                            for (String s2 : setOld) {
                                this.addRow(target, key, s2, "\u25b7removed\u25c1");
                                countDeleted.add(key, 1L);
                            }
                            continue;
                        }
                        Set<String> s1MOld = setOld;
                        Set<String> s2M1 = set2;
                        if (s1MOld.isEmpty()) {
                            this.addRow(target, key, "\u25b7missing\u25c1", Joiner.on(", ").join(s2M1));
                            this.addChange(parentAndFile, ChangeType.added, s2M1.size());
                            countAdded.add(key, 1L);
                            continue;
                        }
                        if (s2M1.isEmpty()) {
                            this.addRow(target, key, Joiner.on(", ").join(s1MOld), "\u25b7removed\u25c1");
                            this.addChange(parentAndFile, ChangeType.deleted, s1MOld.size());
                            countDeleted.add(key, 1L);
                            continue;
                        }
                        int[] sameAndNotInSecond = new int[2];
                        String valueOld = this.getFilteredValue(s1MOld, s1MOld, sameAndNotInSecond);
                        this.addChange(parentAndFile, ChangeType.same, sameAndNotInSecond[0]);
                        countSame.add(key, 1L);
                        this.addChange(parentAndFile, ChangeType.deleted, sameAndNotInSecond[1]);
                        sameAndNotInSecond[1] = 0;
                        countDeleted.add(key, 1L);
                        String valueCurrent = this.getFilteredValue(s2M1, s1MOld, sameAndNotInSecond);
                        this.addChange(parentAndFile, ChangeType.added, sameAndNotInSecond[1]);
                        this.addRow(target, key, valueOld, valueCurrent);
                        countAdded.add(key, 1L);
                    }
                }
            }
            this.writeDiffs(anchors, "bcp47", "\u00a4\u00a4BCP47 " + this.chartNameCap, bcp, tsvFile);
            this.writeDiffs(anchors, "supplemental-data", "\u00a4\u00a4Supplemental " + this.chartNameCap, supplemental, tsvFile);
            this.writeDiffs(anchors, "transforms", "\u00a4\u00a4Transforms " + this.chartNameCap, transforms, tsvFile);
            this.writeCounter(tsvCountFile, "CountSame", countSame);
            tsvCountFile.println();
            this.writeCounter(tsvCountFile, "CountAdded", countAdded);
            tsvCountFile.println();
            this.writeCounter(tsvCountFile, "CountDeleted", countDeleted);
        }
    }

    private void writeCounter(PrintWriter tsvFile, String title, Counter<PathHeader> countDeleted) {
        tsvFile.append("# " + title + "\tSection\tPage\tSubhead\tCode\n\n");
        for (Row.R2<Long, PathHeader> entry : countDeleted.getEntrySetSortedByCount(false, null)) {
            tsvFile.println(entry.get0() + "\t" + entry.get1());
        }
    }

    private void addRow(Multimap<PathHeader, String> target, PathHeader key, String oldItem, String newItem) {
        if (oldItem.isEmpty() || newItem.isEmpty()) {
            throw new IllegalArgumentException();
        }
        target.put(key, oldItem + SEP + newItem);
    }

    private Relation<PathHeader, String> fillData(String directory, String file, String fileBase) {
        List<Pair<String, String>> contents1;
        Relation<PathHeader, String> results = Relation.of(new TreeMap(), TreeSet.class);
        try {
            contents1 = XMLFileReader.loadPathValues(directory + file, new ArrayList<Pair<String, String>>(), true);
        }
        catch (Exception e) {
            return results;
        }
        DtdType dtdType = null;
        DtdData dtdData = null;
        TreeMultimap<String, String> extras = TreeMultimap.create();
        for (Pair<String, String> s2 : contents1) {
            XPathParts pathPlain;
            String value;
            block13: {
                String path = s2.getFirst();
                if (this.highLevelOnly && !HighLevelPaths.pathIsHighLevel(path, fileBase)) continue;
                value = s2.getSecond();
                if (dtdType == null) {
                    dtdType = DtdType.fromPath(path);
                    dtdData = DtdData.getInstance(dtdType, CLDR_BASE_DIR);
                }
                pathPlain = XPathParts.getFrozenInstance(path);
                try {
                    if (dtdData.isMetadata(pathPlain)) {
                    }
                    break block13;
                }
                catch (NullPointerException e) {
                    System.out.println("Caught NullPointerException in fillData calling isMetadata, path = " + path);
                }
                continue;
            }
            Set<String> pathForValues = dtdData.getRegularizedPaths(pathPlain, extras);
            if (pathForValues != null) {
                for (String string : pathForValues) {
                    PathHeader pathHeader = phf.fromPath(string);
                    Splitter splitter = DtdData.getValueSplitter(pathPlain);
                    for (String line : splitter.split(value)) {
                        if (ChartDelta.isComment(pathPlain, line)) continue;
                        results.put(pathHeader, line);
                    }
                }
            }
            for (Map.Entry entry : extras.asMap().entrySet()) {
                String extraPath = (String)entry.getKey();
                PathHeader pathHeaderExtra = phf.fromPath(extraPath);
                Collection extraValue = (Collection)entry.getValue();
                if (this.isExtraSplit(extraPath)) {
                    for (String items : extraValue) {
                        results.putAll(pathHeaderExtra, DtdData.SPACE_SPLITTER.splitToList(items));
                    }
                    continue;
                }
                results.putAll(pathHeaderExtra, extraValue);
            }
            if (pathForValues != null || value.isEmpty()) continue;
            System.err.println("Shouldn't happen");
        }
        return results;
    }

    private boolean isExtraSplit(String extraPath) {
        return extraPath.endsWith("/_type") && extraPath.startsWith("//supplementalData/metaZones/mapTimezones");
    }

    private static boolean isComment(XPathParts pathPlain, String line) {
        return pathPlain.contains("transform") && line.startsWith("#");
    }

    private static enum MyOptions {
        fileFilter(new Option.Params().setHelp("filter files by dir/locale, eg: ^main/en$ or .*/en").setMatch(".*")),
        orgFilter(new Option.Params().setHelp("filter files by organization").setMatch(".*")),
        Vxml(new Option.Params().setHelp("use cldr-aux for the base directory")),
        coverageFilter(new Option.Params().setHelp("filter files by coverage").setMatch(".*")),
        directory(new Option.Params().setHelp("Set the output directory name").setDefault("delta").setMatch(".*")),
        verbose(new Option.Params().setHelp("verbose debugging messages")),
        highLevelOnly(new Option.Params().setHelp("check high-level paths (churn) only").setFlag('H'));

        final Option option;
        private static Option.Options myOptions;

        private MyOptions(Option.Params params) {
            this.option = new Option(this, params);
        }

        private static Set<String> parse(String[] args) {
            return myOptions.parse(MyOptions.values()[0], args, true);
        }

        static {
            myOptions = new Option.Options();
            for (MyOptions option : MyOptions.values()) {
                myOptions.add(option, option.option);
            }
        }
    }

    private static class HighLevelPaths {
        private static final Set<String> highLevelPaths = new HashSet<String>(Arrays.asList("//ldml/characters/exemplarCharacters", "//ldml/numbers/defaultNumberingSystem", "//ldml/numbers/otherNumberingSystems/native", "//ldml/dates/fields/field[@type=\"year\"]/displayName", "//ldml/dates/fields/field[@type=\"month\"]/displayName", "//ldml/dates/fields/field[@type=\"week\"]/displayName", "//ldml/dates/fields/field[@type=\"day\"]/displayName", "//ldml/dates/fields/field[@type=\"hour\"]/displayName", "//ldml/dates/fields/field[@type=\"era\"]/displayName", "//ldml/dates/fields/field[@type=\"minute\"]/displayName", "//ldml/dates/fields/field[@type=\"second\"]/displayName", "//ldml/dates/calendars/calendar[@type=\"gregorian\"]/dateFormats/dateFormatLength[@type=\"full\"]/dateFormat[@type=\"standard\"]/pattern[@type=\"standard\"]", "//ldml/dates/calendars/calendar[@type=\"gregorian\"]/dateFormats/dateFormatLength[@type=\"long\"]/dateFormat[@type=\"standard\"]/pattern[@type=\"standard\"]", "//ldml/dates/calendars/calendar[@type=\"gregorian\"]/dateFormats/dateFormatLength[@type=\"medium\"]/dateFormat[@type=\"standard\"]/pattern[@type=\"standard\"]", "//ldml/dates/calendars/calendar[@type=\"gregorian\"]/dateFormats/dateFormatLength[@type=\"short\"]/dateFormat[@type=\"standard\"]/pattern[@type=\"standard\"]", "//ldml/dates/calendars/calendar[@type=\"gregorian\"]/dateTimeFormats/availableFormats/dateFormatItem[@id=\"MMMEd\"]", "//ldml/dates/calendars/calendar[@type=\"gregorian\"]/dateTimeFormats/availableFormats/dateFormatItem[@id=\"MEd\"]", "//ldml/dates/calendars/calendar[@type=\"gregorian\"]/timeFormats/timeFormatLength[@type=\"full\"]/timeFormat[@type=\"standard\"]/pattern[@type=\"standard\"]", "//ldml/dates/calendars/calendar[@type=\"gregorian\"]/timeFormats/timeFormatLength[@type=\"long\"]/timeFormat[@type=\"standard\"]/pattern[@type=\"standard\"]", "//ldml/dates/calendars/calendar[@type=\"gregorian\"]/timeFormats/timeFormatLength[@type=\"medium\"]/timeFormat[@type=\"standard\"]/pattern[@type=\"standard\"]", "//ldml/dates/calendars/calendar[@type=\"gregorian\"]/timeFormats/timeFormatLength[@type=\"short\"]/timeFormat[@type=\"standard\"]/pattern[@type=\"standard\"]", "//ldml/dates/calendars/calendar[@type=\"gregorian\"]/dayPeriods/dayPeriodContext[@type=\"format\"]/dayPeriodWidth[@type=\"wide\"]/dayPeriod[@type=\"am\"]", "//ldml/dates/calendars/calendar[@type=\"gregorian\"]/dayPeriods/dayPeriodContext[@type=\"format\"]/dayPeriodWidth[@type=\"abbreviated\"]/dayPeriod[@type=\"am\"]", "//ldml/dates/calendars/calendar[@type=\"gregorian\"]/dayPeriods/dayPeriodContext[@type=\"format\"]/dayPeriodWidth[@type=\"wide\"]/dayPeriod[@type=\"pm\"]", "//ldml/dates/calendars/calendar[@type=\"gregorian\"]/dayPeriods/dayPeriodContext[@type=\"format\"]/dayPeriodWidth[@type=\"abbreviated\"]/dayPeriod[@type=\"pm\"]", "//ldml/numbers/currencyFormats[@numberSystem=\"latn\"]/currencyFormatLength/currencyFormat[@type=\"standard\"]/pattern[@type=\"standard\"]", "//ldml/numbers/currencyFormats[@numberSystem=\"arab\"]/currencyFormatLength/currencyFormat[@type=\"standard\"]/pattern[@type=\"standard\"]", "//ldml/numbers/currencies/currency[@type=\"CNY\"]/symbol", "//ldml/numbers/currencies/currency[@type=\"CNY\"]/symbol[@alt=\"narrow\"]", "//ldml/numbers/minimumGroupingDigits", "//ldml/numbers/symbols[@numberSystem=\"latn\"]/decimal", "//ldml/numbers/symbols[@numberSystem=\"latn\"]/group", "//ldml/numbers/symbols[@numberSystem=\"arab\"]/decimal", "//ldml/numbers/symbols[@numberSystem=\"arab\"]/group", "//ldml/numbers/decimalFormats[@numberSystem=\"latn\"]/decimalFormatLength/decimalFormat[@type=\"standard\"]/pattern[@type=\"standard\"]", "//ldml/numbers/percentFormats[@numberSystem=\"latn\"]/percentFormatLength/percentFormat[@type=\"standard\"]/pattern[@type=\"standard\"]", "//ldml/numbers/currencyFormats[@numberSystem=\"latn\"]/currencyFormatLength/currencyFormat[@type=\"accounting\"]/pattern[@type=\"standard\"]", "//ldml/numbers/decimalFormats[@numberSystem=\"arab\"]/decimalFormatLength/decimalFormat[@type=\"standard\"]/pattern[@type=\"standard\"]", "//ldml/numbers/percentFormats[@numberSystem=\"arab\"]/percentFormatLength/percentFormat[@type=\"standard\"]/pattern[@type=\"standard\"]"));
        private static Set<String> highLevelPathMatched = null;
        private static boolean verboseHighLevelReporting = false;

        private HighLevelPaths() {
        }

        private static boolean pathIsHighLevel(String path, String locale) {
            if (path == null || locale == null) {
                return false;
            }
            if (!HighLevelPaths.localeIsHighLevel(locale)) {
                System.out.println("locale [" + locale + "] failed localeIsHighLevel in pathIsHighLevel; path = " + path);
                return false;
            }
            if (highLevelPaths.contains(path)) {
                HighLevelPaths.recordHighLevelMatch(path);
                return true;
            }
            if (HighLevelPaths.isHighLevelTerritoryName(path, locale)) {
                if (verboseHighLevelReporting) {
                    HighLevelPaths.recordHighLevelMatch(path);
                }
                return true;
            }
            if (HighLevelPaths.isHighLevelLangName(path, locale)) {
                if (verboseHighLevelReporting) {
                    HighLevelPaths.recordHighLevelMatch(path);
                }
                return true;
            }
            if (HighLevelPaths.isHighLevelCurrencyName(path, locale)) {
                if (verboseHighLevelReporting) {
                    HighLevelPaths.recordHighLevelMatch(path);
                }
                return true;
            }
            if (HighLevelPaths.isHighLevelLangAlias(path, locale)) {
                HighLevelPaths.recordHighLevelMatch(path);
                return true;
            }
            if (HighLevelPaths.isHighLevelTerritoryContainment(path, locale)) {
                HighLevelPaths.recordHighLevelMatch(path);
                return true;
            }
            return false;
        }

        private static boolean localeIsHighLevel(String locale) {
            return SubmissionLocales.CLDR_LOCALES.contains(locale);
        }

        private static boolean isHighLevelLangAlias(String path, String locale) {
            return false;
        }

        private static boolean isHighLevelTerritoryContainment(String path, String locale) {
            if (path.startsWith("//supplementalData/territoryContainment")) {
                System.out.println("isHighLevelTerritoryContainment got " + path);
            }
            return false;
        }

        private static boolean isHighLevelTerritoryName(String path, String locale) {
            if (path.startsWith("//ldml/localeDisplayNames/territories/territory") && !path.contains("[@alt=")) {
                if ("en".equals(locale)) {
                    return true;
                }
                SupplementalDataInfo.CoverageVariableInfo cvi = SUPPLEMENTAL_DATA_INFO.getCoverageVariableInfo(locale);
                if (cvi != null) {
                    for (String type : cvi.targetTerritories) {
                        if (!path.contains("[@type=\"" + type + "\"]")) continue;
                        return true;
                    }
                }
            }
            return false;
        }

        private static boolean isHighLevelLangName(String path, String locale) {
            if (path.startsWith("//ldml/localeDisplayNames/languages/language") && !path.contains("[@alt=")) {
                if ("en".equals(locale)) {
                    return true;
                }
                if (path.contains("[@type=\"" + locale + "\"]")) {
                    return true;
                }
            }
            return false;
        }

        private static boolean isHighLevelCurrencyName(String path, String locale) {
            if (path.startsWith("//ldml/numbers/currencies/currency")) {
                if ("en".equals(locale)) {
                    return true;
                }
                SupplementalDataInfo.CoverageVariableInfo cvi = SUPPLEMENTAL_DATA_INFO.getCoverageVariableInfo(locale);
                if (cvi != null) {
                    for (String type : cvi.targetCurrencies) {
                        if (!path.contains("[@type=\"" + type + "\"]")) continue;
                        return true;
                    }
                }
            }
            return false;
        }

        private static void recordHighLevelMatch(String path) {
            if (highLevelPathMatched == null) {
                highLevelPathMatched = new HashSet<String>();
            }
            highLevelPathMatched.add(path);
        }

        private static void reportHighLevelPathUsage() {
            if (highLevelPathMatched == null) {
                System.out.println("Zero high-level paths were matched!");
                return;
            }
            for (String path : highLevelPaths) {
                if (highLevelPathMatched.contains(path)) continue;
                System.out.println("Unmatched high-level path: " + path);
            }
            if (!verboseHighLevelReporting) {
                // empty if block
            }
            for (String path : highLevelPathMatched) {
                if (highLevelPaths.contains(path)) continue;
                System.out.println("Special matched high-level path: " + path);
            }
        }
    }

    private static enum ChangeType {
        added,
        deleted,
        changed,
        same;


        public static ChangeType get(String oldValue, String currentValue) {
            return oldValue == null ? added : (currentValue == null ? deleted : (oldValue.equals(currentValue) ? same : changed));
        }
    }

    private static class PathDiff
    extends Row.R4<PathHeaderSegment, String, String, String> {
        public PathDiff(String locale, PathHeaderSegment pathHeaderSegment, String oldValue, String newValue) {
            super(pathHeaderSegment, locale, oldValue, newValue);
        }
    }

    private static class PathHeaderSegment
    extends Row.R3<PathHeader, Integer, String> {
        public PathHeaderSegment(PathHeader b, int elementIndex, String attribute) {
            super(b, elementIndex, attribute);
        }
    }

    private class ChartDeltaSub
    extends Chart {
        private String title;
        private String file;
        private TablePrinter tablePrinter;
        private PrintWriter tsvFile;

        private ChartDeltaSub(String title, String file, TablePrinter tablePrinter, PrintWriter tsvFile) {
            this.title = title;
            this.file = file;
            this.tablePrinter = tablePrinter;
            this.tsvFile = tsvFile;
        }

        @Override
        public String getDirectory() {
            return ChartDelta.this.DIR;
        }

        @Override
        public boolean getShowDate() {
            return false;
        }

        @Override
        public String getTitle() {
            return this.title;
        }

        @Override
        public String getFileName() {
            return this.file;
        }

        @Override
        public String getExplanation() {
            return "<p>Lists data fields that differ from the last major version (see versions above). Inherited differences in locales are suppressed, except where the source locales are different. <p>";
        }

        @Override
        public void writeContents(FormattedFileWriter pw) throws IOException {
            pw.write(this.tablePrinter.toTable());
            this.tablePrinter.toTsv(this.tsvFile);
        }
    }
}

