/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.ibm.icu.impl.Utility;
import com.ibm.icu.util.VersionInfo;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import org.unicode.cldr.tool.Chart;
import org.unicode.cldr.tool.FormattedFileWriter;
import org.unicode.cldr.tool.TablePrinter;
import org.unicode.cldr.tool.ToolConstants;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.DtdData;
import org.unicode.cldr.util.DtdType;
import org.unicode.cldr.util.SupplementalDataInfo;

public class ChartDtdDelta
extends Chart {
    private static final Splitter SPLITTER_SPACE = Splitter.on(' ');
    private static final String DEPRECATED_PREFIX = "\u2296";
    private static final String NEW_PREFIX = "+";
    private static final String ORDERED_SIGN = "\u21e3";
    private static final String UNORDERED_SIGN = "\u21df";
    private static final Set<String> OMITTED_ATTRIBUTES = Collections.singleton("\u2295");
    static final String NONE = " ";
    static final SupplementalDataInfo SDI = CLDRConfig.getInstance().getSupplementalDataInfo();
    static Set<DtdType> TYPES = EnumSet.allOf(DtdType.class);
    static final Map<DtdType, String> FIRST_VERSION;
    static final DtdType DEBUG_DTD;
    static final String DEBUG_ELEMENT = "lias";
    static final boolean SHOW = false;
    List<DiffElement> data = new ArrayList<DiffElement>();
    static final Set<String> SKIP_ELEMENTS;
    static final Multimap<DtdType, String> SKIP_TYPE_ELEMENTS;
    static final Set<String> SKIP_ATTRIBUTES;

    public static void main(String[] args) {
        new ChartDtdDelta().writeChart(null);
    }

    @Override
    public String getDirectory() {
        return FormattedFileWriter.CHART_TARGET_DIR;
    }

    @Override
    public String getTitle() {
        return "DTD Deltas";
    }

    @Override
    public String getExplanation() {
        return "<p>Changes to the LDML DTDs over time.</p>\n<ul>\n<li>New elements or attributes are indicated with a + sign, and newly deprecated ones with a \u2296 sign.</li>\n<li>Element attributes are abbreviated as \u2295 where is no change to them, but the element is newly the child of another.</li>\n<li>LDML DTDs have augmented data:\n<ul><li>Attribute status is marked by: " + DtdData.AttributeStatus.distinguished.shortName + "=" + (Object)((Object)DtdData.AttributeStatus.distinguished) + ", " + DtdData.AttributeStatus.value.shortName + "=" + (Object)((Object)DtdData.AttributeStatus.value) + ", or " + DtdData.AttributeStatus.metadata.shortName + "=" + (Object)((Object)DtdData.AttributeStatus.metadata) + ".</li>\n<li>Attribute value constraints are marked with \u27e8\u2026\u27e9 (for DTD constraints) and \u27ea\u2026\u27eb (for augmented constraints, added in v35.0).</li>\n<li>Changes in status or constraints are shown with \u27a0, with identical sections shown with \u2026.</li>\n<li>Newly ordered elements are indicated with " + ORDERED_SIGN + "; newly unordered with " + UNORDERED_SIGN + ".</li>\n</ul></li></ul>\n<p>For more information, see the LDML spec.</p>";
    }

    @Override
    public void writeContents(FormattedFileWriter pw) throws IOException {
        TablePrinter tablePrinter = new TablePrinter().addColumn("Version", "class='source'", CldrUtility.getDoubleLinkMsg(), "class='source'", true).setSortPriority(0).setSortAscending(false).setBreakSpans(true).addColumn("Dtd Type", "class='source'", null, "class='source'", true).setSortPriority(1).addColumn("Intermediate Path", "class='source'", null, "class='target'", true).setSortPriority(2).addColumn("Element", "class='target'", null, "class='target'", true).setSpanRows(false).addColumn("Attributes", "class='target'", null, "class='target'", true).setSpanRows(false);
        String last = null;
        for (String current : ToolConstants.CLDR_RELEASE_AND_DEV_VERSION_SET) {
            System.out.println("DTD delta: " + current);
            boolean finalVersion = current.equals("38");
            String currentName = finalVersion ? ToolConstants.CHART_DISPLAY_VERSION : current;
            for (DtdType type : TYPES) {
                DtdData dtdLast;
                DtdData dtdCurrent;
                block9: {
                    String firstVersion = type.firstVersion;
                    if (firstVersion != null && current != null && current.compareTo(firstVersion) < 0) continue;
                    dtdCurrent = null;
                    try {
                        dtdCurrent = DtdData.getInstance(type, finalVersion ? null : current);
                    }
                    catch (Exception e) {
                        if (!(e.getCause() instanceof FileNotFoundException)) {
                            throw e;
                        }
                        System.out.println(e.getMessage() + ", " + e.getCause().getMessage());
                        continue;
                    }
                    dtdLast = null;
                    if (last != null) {
                        try {
                            dtdLast = DtdData.getInstance(type, last);
                        }
                        catch (Exception e) {
                            if (e.getCause() instanceof FileNotFoundException) break block9;
                            throw e;
                        }
                    }
                }
                this.diff(currentName, dtdLast, dtdCurrent);
            }
            last = current;
            if (!current.contentEquals(ToolConstants.CHART_VERSION)) continue;
            break;
        }
        for (DiffElement datum : this.data) {
            tablePrinter.addRow().addCell((Comparable)((Object)datum.getVersionString())).addCell((Comparable)((Object)datum.dtdType)).addCell((Comparable)((Object)datum.newPath)).addCell((Comparable)((Object)datum.newElement)).addCell((Comparable)((Object)datum.attributeNames)).finishRow();
        }
        pw.write(tablePrinter.toTable());
        pw.write(Utility.repeat("<br>", 50));
    }

    private void diff(String prefix, DtdData dtdLast, DtdData dtdCurrent) {
        Map<String, DtdData.Element> oldNameToElement = dtdLast == null ? Collections.emptyMap() : dtdLast.getElementFromName();
        this.checkNames(prefix, dtdCurrent, dtdLast, oldNameToElement, "/", dtdCurrent.ROOT, new HashSet<DtdData.Element>(), false);
    }

    private void checkNames(String version, DtdData dtdCurrent, DtdData dtdLast, Map<String, DtdData.Element> oldNameToElement, String path, DtdData.Element element, HashSet<DtdData.Element> seen, boolean showAnyway) {
        String name = element.getName();
        if (SKIP_ELEMENTS.contains(name)) {
            return;
        }
        if (SKIP_TYPE_ELEMENTS.containsEntry((Object)dtdCurrent.dtdType, name)) {
            return;
        }
        String newPath = path + "/" + element.name;
        if (seen.contains(element)) {
            if (showAnyway) {
                this.addData(dtdCurrent, NEW_PREFIX + name, version, newPath, OMITTED_ATTRIBUTES);
            }
            return;
        }
        seen.add(element);
        if (DEBUG_DTD == dtdCurrent.dtdType && name.contains(DEBUG_ELEMENT)) {
            boolean bl = false;
        }
        DtdData.Element oldElement = null;
        boolean ordered = element.isOrdered();
        if (!oldNameToElement.containsKey(name)) {
            Set<String> attributeNames = ChartDtdDelta.getAttributeNames(dtdCurrent, dtdLast, name, Collections.emptyMap(), element.getAttributes());
            this.addData(dtdCurrent, NEW_PREFIX + name + (ordered ? ORDERED_SIGN : ""), version, newPath, attributeNames);
        } else {
            String orderingStatus;
            boolean newlyDeprecated;
            oldElement = oldNameToElement.get(name);
            boolean oldOrdered = oldElement.isOrdered();
            Set<String> attributeNames = ChartDtdDelta.getAttributeNames(dtdCurrent, dtdLast, name, oldElement.getAttributes(), element.getAttributes());
            boolean currentDeprecated = element.isDeprecated();
            boolean lastDeprecated = dtdLast == null ? false : oldElement.isDeprecated();
            boolean bl = newlyDeprecated = currentDeprecated && !lastDeprecated;
            String string = ordered == oldOrdered || currentDeprecated ? "" : (orderingStatus = ordered ? ORDERED_SIGN : UNORDERED_SIGN);
            if (newlyDeprecated) {
                this.addData(dtdCurrent, DEPRECATED_PREFIX + name + orderingStatus, version, newPath, Collections.emptySet());
            }
            if (!attributeNames.isEmpty()) {
                this.addData(dtdCurrent, (newlyDeprecated ? DEPRECATED_PREFIX : "") + name + orderingStatus, version, newPath, attributeNames);
            }
        }
        if (element.getName().equals("coordinateUnit")) {
            System.out.println(version + "\toordinateUnit\t" + element.getChildren().keySet());
        }
        Set<DtdData.Element> oldChildren = oldElement == null ? Collections.emptySet() : oldElement.getChildren().keySet();
        for (DtdData.Element child : element.getChildren().keySet()) {
            showAnyway = true;
            for (DtdData.Element oldChild : oldChildren) {
                if (!oldChild.getName().equals(child.getName())) continue;
                showAnyway = false;
                break;
            }
            this.checkNames(version, dtdCurrent, dtdLast, oldNameToElement, newPath, child, seen, showAnyway);
        }
    }

    private void addData(DtdData dtdCurrent, String element, String prefix, String newPath, Set<String> attributeNames) {
        DiffElement item = new DiffElement(dtdCurrent, prefix, newPath, element, attributeNames);
        this.data.add(item);
    }

    private static Set<String> getAttributeNames(DtdData dtdCurrent, DtdData dtdLast, String elementName, Map<DtdData.Attribute, Integer> attributesOld, Map<DtdData.Attribute, Integer> attributes) {
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        if (elementName.equals("coordinateUnit")) {
            boolean bl = false;
        }
        for (DtdData.Attribute attribute : attributes.keySet()) {
            String name = attribute.getName();
            if (SKIP_ATTRIBUTES.contains(name)) continue;
            String match = attribute.getMatchString();
            DtdData.AttributeStatus status = attribute.attributeStatus;
            String display = NEW_PREFIX + name;
            String oldMatch = "?";
            DtdData.Attribute attributeOld = attribute.getMatchingName(attributesOld);
            if (attributeOld == null) {
                display = NEW_PREFIX + name + "\u00a0" + DtdData.AttributeStatus.getShortName(status) + "\u00a0" + match;
            } else if (attribute.isDeprecated() && !attributeOld.isDeprecated()) {
                display = DEPRECATED_PREFIX + name;
            } else {
                String post;
                String pre;
                oldMatch = attributeOld.getMatchString();
                DtdData.AttributeStatus oldStatus = attributeOld.attributeStatus;
                boolean matchEquals = match.equals(oldMatch);
                if (status != oldStatus) {
                    pre = DtdData.AttributeStatus.getShortName(oldStatus);
                    post = DtdData.AttributeStatus.getShortName(status);
                    if (!matchEquals) {
                        pre = pre + "\u00a0" + oldMatch;
                        post = post + "\u00a0" + match;
                    }
                } else {
                    if (matchEquals) continue;
                    pre = oldMatch;
                    post = match;
                }
                display = name + "\u00a0" + ChartDtdDelta.diff(pre, post);
            }
            names.add(display);
        }
        return names;
    }

    public static String diff(String pre, String post) {
        Matcher matcherPre = DtdData.Attribute.LEAD_TRAIL.matcher(pre);
        Matcher matcherPost = DtdData.Attribute.LEAD_TRAIL.matcher(post);
        if (matcherPre.matches() && matcherPost.matches()) {
            List<String> preParts = SPLITTER_SPACE.splitToList(matcherPre.group(2));
            List<String> postParts = SPLITTER_SPACE.splitToList(matcherPost.group(2));
            pre = matcherPre.group(1) + ChartDtdDelta.remove(preParts, postParts) + matcherPre.group(3);
            post = matcherPost.group(1) + ChartDtdDelta.remove(postParts, preParts) + matcherPost.group(3);
        }
        return pre + "\u27a0" + post;
    }

    private static String remove(List<String> main, List<String> toRemove) {
        ArrayList<String> result = new ArrayList<String>();
        boolean removed = false;
        for (String s2 : main) {
            if (toRemove.contains(s2)) {
                removed = true;
                continue;
            }
            if (removed) {
                result.add("\u2026");
                removed = false;
            }
            result.add(s2);
        }
        if (removed) {
            result.add("\u2026");
        }
        return Joiner.on(NONE).join(result);
    }

    static {
        TYPES.remove((Object)DtdType.ldmlICU);
        FIRST_VERSION = new EnumMap<DtdType, String>(DtdType.class);
        FIRST_VERSION.put(DtdType.ldmlBCP47, "1.7.2");
        FIRST_VERSION.put(DtdType.keyboard, "22.1");
        FIRST_VERSION.put(DtdType.platform, "22.1");
        DEBUG_DTD = null;
        SKIP_ELEMENTS = ImmutableSet.of("generation", "identity", "special");
        SKIP_TYPE_ELEMENTS = ImmutableMultimap.of(DtdType.ldml, "alias");
        SKIP_ATTRIBUTES = ImmutableSet.of("references", "standard", "draft", "alt");
    }

    private static class DiffElement {
        private static final String START_ATTR = "<div>";
        private static final String END_ATTR = "</div>";
        final VersionInfo version;
        final DtdType dtdType;
        final boolean isBeta;
        final String newPath;
        final String newElement;
        final String attributeNames;

        public DiffElement(DtdData dtdCurrent, String version, String newPath, String newElement, Set<String> attributeNames2) {
            this.isBeta = version.endsWith("\u03b2");
            try {
                this.version = this.isBeta ? VersionInfo.getInstance(version.substring(0, version.length() - 1)) : VersionInfo.getInstance(version);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
            this.dtdType = dtdCurrent.dtdType;
            this.newPath = this.fix(newPath);
            this.attributeNames = attributeNames2.isEmpty() ? ChartDtdDelta.NONE : START_ATTR + Joiner.on("</div><div>").join(attributeNames2) + END_ATTR;
            this.newElement = newElement;
        }

        private String fix(String substring) {
            int base = substring.indexOf(47, 2);
            if (base < 0) {
                return "";
            }
            int last = substring.lastIndexOf(47);
            if (last <= base) {
                return "/";
            }
            substring = substring.substring(base, last);
            return substring.replace("/", "\u200b/") + "/";
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("version", this.getVersionString()).add("dtdType", (Object)this.dtdType).add("newPath", this.newPath).add("newElement", this.newElement).add("attributeNames", this.attributeNames).toString();
        }

        private String getVersionString() {
            return this.version.getVersionString(2, 4) + (this.isBeta ? "\u03b2" : "");
        }
    }

    static enum DiffType {
        Element,
        Attribute,
        AttributeValue;

    }
}

