/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.collect.ImmutableSet;
import com.ibm.icu.util.ICUUncheckedIOException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Set;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.tool.Option;
import org.unicode.cldr.tool.SubdivisionNames;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.Factory;

public class CopySubdivisionsIntoMain {
    private static final String MAIN_TARGET_DIR = CLDRPaths.MAIN_DIRECTORY;
    private static final String SUBDIVISION_TARGET_DIR = CLDRPaths.SUBDIVISIONS_DIRECTORY;
    static final Set<String> target = ImmutableSet.of("gbeng", "gbsct", "gbwls");
    static final Factory mainFactory = CLDRConfig.getInstance().getCldrFactory();
    static final Factory subdivisionFactory = CLDRConfig.getInstance().getSubdivisionFactory();
    static boolean verbose;

    public static void main(String[] args) {
        MyOptions.parse(args, true);
        verbose = MyOptions.verbose.option.doesOccur();
        boolean before = MyOptions.beforeSubmission.option.doesOccur();
        boolean after = MyOptions.afterSubmission.option.doesOccur();
        if (before == after) {
            throw new IllegalArgumentException("Must do exactly one of " + (Object)((Object)MyOptions.beforeSubmission) + " and " + (Object)((Object)MyOptions.afterSubmission));
        }
        if (before) {
            CopySubdivisionsIntoMain.doBefore();
        } else {
            CopySubdivisionsIntoMain.doAfter();
        }
    }

    private static void doAfter() {
        throw new IllegalArgumentException("Should probably discontinue this, leaving translated subdivisions in main");
    }

    private static void doBefore() {
        for (String locale : SubdivisionNames.getAvailableLocales()) {
            CLDRFile cldrFile;
            SubdivisionNames sdn = new SubdivisionNames(locale);
            Set<String> keySet = sdn.keySet();
            if (Collections.disjoint(target, keySet)) continue;
            try {
                cldrFile = mainFactory.make(locale, false);
            }
            catch (Exception e) {
                System.out.println("Not in main, skipping for now: " + locale);
                continue;
            }
            boolean added = false;
            for (String key : target) {
                String oldValue;
                String path = SubdivisionNames.getPathFromCode(key);
                String name = sdn.get(key);
                if (name == null || (oldValue = cldrFile.getStringValue(path)) != null) continue;
                if (!added) {
                    cldrFile = cldrFile.cloneAsThawed();
                    added = true;
                }
                cldrFile.add(path, name);
                System.out.println("Adding " + locale + ": " + path + "\t=\u00ab" + name + "\u00bb");
            }
            if (!added) continue;
            String fileName = locale + ".xml";
            CopySubdivisionsIntoMain.writeFile(MAIN_TARGET_DIR, fileName, cldrFile);
            CLDRFile sd = subdivisionFactory.make(locale, false).cloneAsThawed();
            for (String key : target) {
                String path = SubdivisionNames.getPathFromCode(key);
                sd.remove(path);
            }
            CopySubdivisionsIntoMain.writeFile(CLDRPaths.SUBDIVISIONS_DIRECTORY, fileName, sd);
        }
    }

    private static void writeFile(String directory, String fileName, CLDRFile cldrFile) {
        try (PrintWriter pw = FileUtilities.openUTF8Writer(directory, fileName);){
            cldrFile.write(pw);
        }
        catch (IOException e) {
            throw new ICUUncheckedIOException(e);
        }
    }

    static enum MyOptions {
        beforeSubmission(new Option.Params().setHelp("Before submission: copy from /subdivisions/ to /main/")),
        afterSubmission(new Option.Params().setHelp("After submission: copy from /main/ to /subdivisions/")),
        verbose(new Option.Params().setHelp("verbose debugging messages"));

        final Option option;
        private static Option.Options myOptions;

        private MyOptions(Option.Params params) {
            this.option = new Option(this, params);
        }

        private static Set<String> parse(String[] args, boolean showArguments) {
            return myOptions.parse(MyOptions.values()[0], args, true);
        }

        static {
            myOptions = new Option.Options();
            for (MyOptions option : MyOptions.values()) {
                myOptions.add(option, option.option);
            }
        }
    }
}

